/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.internal.introspection;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.internal.Engine;
import org.apache.commons.jexl3.internal.introspection.AbstractExecutor;
import org.apache.commons.jexl3.internal.introspection.DuckGetExecutor;
import org.apache.commons.jexl3.internal.introspection.DuckSetExecutor;
import org.apache.commons.jexl3.internal.introspection.ListGetExecutor;
import org.apache.commons.jexl3.internal.introspection.ListSetExecutor;
import org.apache.commons.jexl3.internal.introspection.MapGetExecutor;
import org.apache.commons.jexl3.internal.introspection.MapSetExecutor;
import org.apache.commons.jexl3.internal.introspection.PropertyGetExecutor;
import org.apache.commons.jexl3.internal.introspection.PropertySetExecutor;
import org.apache.commons.jexl3.internal.introspection.Uberspect;
import org.apache.commons.jexl3.introspection.JexlMethod;
import org.apache.commons.jexl3.introspection.JexlPropertyGet;
import org.apache.commons.jexl3.introspection.JexlPropertySet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DiscoveryTest
extends JexlTestCase {
    public DiscoveryTest() {
        super("DiscoveryTest");
    }

    @Test
    public void testBeanIntrospection() throws Exception {
        Uberspect uber = Engine.getUberspect(null, null);
        Bean bean = new Bean("JEXL", "LXEJ");
        JexlPropertyGet get = uber.getPropertyGet((Object)bean, (Object)"value");
        JexlPropertySet set = uber.getPropertySet((Object)bean, (Object)"value", (Object)"foo");
        Assertions.assertTrue((boolean)(get instanceof PropertyGetExecutor), (String)"bean property getter");
        Assertions.assertTrue((boolean)(set instanceof PropertySetExecutor), (String)"bean property setter");
        Assertions.assertEquals((Object)get, (Object)uber.getPropertyGet((Object)bean, (Object)"value"));
        Assertions.assertEquals((Object)set, (Object)uber.getPropertySet((Object)bean, (Object)"value", (Object)"foo"));
        Assertions.assertNotEquals((Object)get, (Object)uber.getPropertyGet((Object)bean, (Object)"eulav"));
        Assertions.assertNotEquals((Object)set, (Object)uber.getPropertySet((Object)bean, (Object)"eulav", (Object)"foo"));
        Object bar = set.invoke((Object)bean, (Object)"bar");
        Assertions.assertEquals((Object)"bar", (Object)bar);
        Assertions.assertEquals((Object)"bar", (Object)get.invoke((Object)bean));
        Object quux = set.tryInvoke((Object)bean, (Object)"value", (Object)"quux");
        Assertions.assertEquals((Object)"quux", (Object)quux);
        Assertions.assertEquals((Object)"quux", (Object)get.invoke((Object)bean));
        Assertions.assertEquals((Object)AbstractExecutor.TRY_FAILED, (Object)set.tryInvoke((Object)bean, (Object)"eulav", (Object)"nope"));
    }

    @Test
    public void testDuckIntrospection() throws Exception {
        Uberspect uber = Engine.getUberspect(null, null);
        Duck duck = new Duck("JEXL", "LXEJ");
        JexlPropertyGet get = uber.getPropertyGet((Object)duck, (Object)"value");
        JexlPropertySet set = uber.getPropertySet((Object)duck, (Object)"value", (Object)"foo");
        Assertions.assertTrue((boolean)(get instanceof DuckGetExecutor), (String)"duck property getter");
        Assertions.assertTrue((boolean)(set instanceof DuckSetExecutor), (String)"duck property setter");
        Assertions.assertEquals((Object)get, (Object)uber.getPropertyGet((Object)duck, (Object)"value"));
        Assertions.assertEquals((Object)set, (Object)uber.getPropertySet((Object)duck, (Object)"value", (Object)"foo"));
        Assertions.assertNotEquals((Object)get, (Object)uber.getPropertyGet((Object)duck, (Object)"eulav"));
        Assertions.assertNotEquals((Object)set, (Object)uber.getPropertySet((Object)duck, (Object)"eulav", (Object)"foo"));
        Object bar = set.invoke((Object)duck, (Object)"bar");
        Assertions.assertEquals((Object)"bar", (Object)bar);
        Assertions.assertEquals((Object)"bar", (Object)get.invoke((Object)duck));
        Object quux = set.tryInvoke((Object)duck, (Object)"value", (Object)"quux");
        Assertions.assertEquals((Object)"quux", (Object)quux);
        Assertions.assertEquals((Object)"quux", (Object)get.invoke((Object)duck));
        Assertions.assertEquals((Object)AbstractExecutor.TRY_FAILED, (Object)set.tryInvoke((Object)duck, (Object)"eulav", (Object)"nope"));
    }

    @Test
    public void testListIntrospection() throws Exception {
        Uberspect uber = Engine.getUberspect(null, null);
        ArrayList<String> list = new ArrayList<String>();
        list.add("LIST");
        list.add("TSIL");
        JexlPropertyGet get = uber.getPropertyGet(list, (Object)1);
        JexlPropertySet set = uber.getPropertySet(list, (Object)1, (Object)"foo");
        Assertions.assertTrue((boolean)(get instanceof ListGetExecutor), (String)"list property getter");
        Assertions.assertTrue((boolean)(set instanceof ListSetExecutor), (String)"list property setter");
        Assertions.assertEquals((Object)get, (Object)uber.getPropertyGet(list, (Object)1));
        Assertions.assertEquals((Object)set, (Object)uber.getPropertySet(list, (Object)1, (Object)"foo"));
        Assertions.assertNotEquals((Object)get, (Object)uber.getPropertyGet(list, (Object)0));
        Assertions.assertNotEquals((Object)get, (Object)uber.getPropertySet(list, (Object)0, (Object)"foo"));
        Object bar = set.invoke(list, (Object)"bar");
        Assertions.assertEquals((Object)"bar", (Object)bar);
        Assertions.assertEquals((Object)"bar", (Object)get.invoke(list));
        Object quux = set.tryInvoke(list, (Object)1, (Object)"quux");
        Assertions.assertEquals((Object)"quux", (Object)quux);
        Assertions.assertEquals((Object)"quux", (Object)get.invoke(list));
        Assertions.assertEquals((Object)AbstractExecutor.TRY_FAILED, (Object)set.tryInvoke(list, (Object)"eulav", (Object)"nope"));
    }

    @Test
    public void testMapIntrospection() throws Exception {
        Uberspect uber = Engine.getUberspect(null, null);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("value", "MAP");
        map.put("eulav", "PAM");
        JexlPropertyGet get = uber.getPropertyGet(map, (Object)"value");
        JexlPropertySet set = uber.getPropertySet(map, (Object)"value", (Object)"foo");
        Assertions.assertTrue((boolean)(get instanceof MapGetExecutor), (String)"map property getter");
        Assertions.assertTrue((boolean)(set instanceof MapSetExecutor), (String)"map property setter");
        Assertions.assertEquals((Object)get, (Object)uber.getPropertyGet(map, (Object)"value"));
        Assertions.assertEquals((Object)set, (Object)uber.getPropertySet(map, (Object)"value", (Object)"foo"));
        Assertions.assertNotEquals((Object)get, (Object)uber.getPropertyGet(map, (Object)"eulav"));
        Assertions.assertNotEquals((Object)get, (Object)uber.getPropertySet(map, (Object)"eulav", (Object)"foo"));
        Object bar = set.invoke(map, (Object)"bar");
        Assertions.assertEquals((Object)"bar", (Object)bar);
        Assertions.assertEquals((Object)"bar", (Object)get.invoke(map));
        Object quux = set.tryInvoke(map, (Object)"value", (Object)"quux");
        Assertions.assertEquals((Object)"quux", (Object)quux);
        Assertions.assertEquals((Object)"quux", (Object)get.invoke(map));
        Assertions.assertEquals((Object)AbstractExecutor.TRY_FAILED, (Object)set.tryInvoke(map, (Object)1, (Object)"nope"));
    }

    @Test
    public void testMethodIntrospection() throws Exception {
        Uberspect uber = new Uberspect(null, null);
        Bulgroz bulgroz = new Bulgroz();
        JexlMethod jmethod = uber.getMethod((Object)bulgroz, "list", new Object[]{0});
        Object result = jmethod.invoke((Object)bulgroz, new Object[]{0});
        Assertions.assertEquals((Object)0, (Object)result);
        jmethod = uber.getMethod((Object)bulgroz, "list", new Object[]{"1"});
        result = jmethod.invoke((Object)bulgroz, new Object[]{"1"});
        Assertions.assertEquals((Object)1, (Object)result);
        jmethod = uber.getMethod((Object)bulgroz, "list", new Object[]{bulgroz});
        result = jmethod.invoke((Object)bulgroz, new Object[]{bulgroz});
        Assertions.assertEquals((Object)2, (Object)result);
        jmethod = uber.getMethod((Object)bulgroz, "list", new Object[]{1, bulgroz});
        result = jmethod.invoke((Object)bulgroz, new Object[]{1, bulgroz});
        Assertions.assertEquals((Object)3, (Object)result);
        jmethod = uber.getMethod((Object)bulgroz, "list", new Object[]{1, bulgroz, bulgroz});
        result = jmethod.invoke((Object)bulgroz, new Object[]{1, bulgroz, bulgroz});
        Assertions.assertEquals((Object)3, (Object)result);
        jmethod = uber.getMethod((Object)bulgroz, "list", new Object[]{1, 2});
        result = jmethod.invoke((Object)bulgroz, new Object[]{1, 2});
        Assertions.assertEquals((Object)4, (Object)result);
        jmethod = uber.getMethod((Object)bulgroz, "list", new Object[]{"1", bulgroz});
        result = jmethod.invoke((Object)bulgroz, new Object[]{"1", bulgroz});
        Assertions.assertEquals((Object)5, (Object)result);
        jmethod = uber.getMethod((Object)bulgroz, "list", new Object[]{"1", "2"});
        result = jmethod.invoke((Object)bulgroz, new Object[]{"1", "2"});
        Assertions.assertEquals((Object)6, (Object)result);
        jmethod = uber.getMethod((Object)bulgroz, "list", new Object[]{bulgroz, bulgroz});
        result = jmethod.invoke((Object)bulgroz, new Object[]{bulgroz, bulgroz});
        Assertions.assertEquals((Object)8, (Object)result);
        jmethod = uber.getMethod((Object)bulgroz, "list", new Object[]{bulgroz, 1, bulgroz});
        result = jmethod.invoke((Object)bulgroz, new Object[]{bulgroz, 1, bulgroz});
        Assertions.assertEquals((Object)7, (Object)result);
        jmethod = uber.getMethod((Object)bulgroz, "list", new Object[]{bulgroz, 1, "1"});
        result = jmethod.invoke((Object)bulgroz, new Object[]{bulgroz, 1, "1"});
        Assertions.assertEquals((Object)7, (Object)result);
        jmethod = uber.getMethod((Object)bulgroz, "list", new Object[]{null});
        result = jmethod.invoke((Object)bulgroz, new Object[]{null});
        Assertions.assertEquals((Object)2, (Object)result);
        jmethod = uber.getMethod((Object)bulgroz, "list", new Object[]{bulgroz, null});
        result = jmethod.invoke((Object)bulgroz, new Object[]{bulgroz, null});
        Assertions.assertEquals((Object)8, (Object)result);
        jmethod = uber.getMethod((Object)bulgroz, "list", new Object[]{null, "1"});
        result = jmethod.invoke((Object)bulgroz, new Object[]{null, "1"});
        Assertions.assertEquals((Object)8, (Object)result);
        jmethod = uber.getMethod((Object)bulgroz, "list", new Object[]{bulgroz, null, null});
        result = jmethod.invoke((Object)bulgroz, new Object[]{bulgroz, null, null});
        Assertions.assertEquals((Object)7, (Object)result);
        jmethod = uber.getMethod((Object)bulgroz, "amb", new Object[]{3.0});
        Assertions.assertNotNull((Object)jmethod);
    }

    public static class Bean {
        private String value;
        private String eulav;
        private boolean flag;

        public Bean(String v, String e) {
            this.value = v;
            this.eulav = e;
            this.flag = true;
        }

        public String getEulav() {
            return this.eulav;
        }

        public String getValue() {
            return this.value;
        }

        public boolean isFlag() {
            return this.flag;
        }

        public void setEulav(String v) {
            this.eulav = v;
        }

        public void setFlag(boolean f) {
            this.flag = f;
        }

        public void setValue(String v) {
            this.value = v;
        }
    }

    public static class Duck {
        private String value;
        private String eulav;

        public Duck(String v, String e) {
            this.value = v;
            this.eulav = e;
        }

        public String get(String prop) {
            if ("value".equals(prop)) {
                return this.value;
            }
            if ("eulav".equals(prop)) {
                return this.eulav;
            }
            return "no such property";
        }

        public void set(String prop, String v) {
            if ("value".equals(prop)) {
                this.value = v;
            } else if ("eulav".equals(prop)) {
                this.eulav = v;
            }
        }
    }

    public static class Bulgroz {
        public Object amb(Number x) {
            return -2;
        }

        public Object amb(Serializable x) {
            return -1;
        }

        public Object list(int x) {
            return 0;
        }

        public Object list(int x, int y) {
            return 4;
        }

        public Object list(int x, Object ... y) {
            return 3;
        }

        public Object list(Object x) {
            return 2;
        }

        public Object list(Object x, Object ... y) {
            return 7;
        }

        public Object list(Object x, Object y) {
            return 8;
        }

        public Object list(String x) {
            return 1;
        }

        public Object list(String x, Object ... y) {
            return 5;
        }

        public Object list(String x, String y) {
            return 6;
        }
    }
}

