/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.introspection;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.jexl3.JexlArithmetic;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.jexl3.annotations.NoJexl;
import org.apache.commons.jexl3.internal.MapBuilder;
import org.apache.commons.jexl3.introspection.JexlPermissions;
import org.apache.commons.jexl3.introspection.JexlSandbox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SandboxTest
extends JexlTestCase {
    static final Log LOGGER = LogFactory.getLog((String)SandboxTest.class.getName());

    public SandboxTest() {
        super("SandboxTest");
    }

    @Test
    public void testCantSeeMe() throws Exception {
        MapContext jc = new MapContext();
        String expr = "foo.doIt()";
        JexlSandbox sandbox = new JexlSandbox(false);
        sandbox.allow(Foo.class.getName());
        JexlEngine sjexl = new JexlBuilder().sandbox(sandbox).strict(true).safe(false).create();
        jc.set("foo", (Object)new CantSeeMe());
        JexlScript script = sjexl.createScript("foo.doIt()");
        Assertions.assertThrows(JexlException.class, () -> SandboxTest.lambda$testCantSeeMe$0(script, (JexlContext)jc));
        jc.set("foo", (Object)new Foo("42"));
        Object result = script.execute((JexlContext)jc);
        Assertions.assertEquals((int)42, (int)((Integer)result));
    }

    @Test
    public void testCtorAllow() throws Exception {
        String expr = "new('" + Foo.class.getName() + "', '42')";
        JexlSandbox sandbox = new JexlSandbox();
        sandbox.allow(Foo.class.getName()).execute(new String[]{""});
        JexlEngine sjexl = new JexlBuilder().sandbox(sandbox).strict(true).safe(false).create();
        JexlScript script = sjexl.createScript(expr);
        Object result = script.execute(null);
        Assertions.assertEquals((Object)"42", (Object)((Foo)result).getName());
    }

    @Test
    public void testCtorBlock() throws Exception {
        String expr = "new('" + Foo.class.getName() + "', '42')";
        JexlScript script = this.JEXL.createScript(expr);
        Object result = script.execute(null);
        Assertions.assertEquals((Object)"42", (Object)((Foo)result).getName());
        JexlSandbox sandbox = new JexlSandbox();
        sandbox.block(Foo.class.getName()).execute(new String[]{""});
        JexlEngine sjexl = new JexlBuilder().sandbox(sandbox).strict(true).safe(false).create();
        JexlScript script2 = sjexl.createScript(expr);
        Assertions.assertThrows(JexlException.Method.class, () -> script2.execute(null), (String)"ctor should not be accessible");
    }

    @Test
    public void testGetAllow() throws Exception {
        Foo foo = new Foo("42");
        String expr = "foo.alias";
        JexlSandbox sandbox = new JexlSandbox();
        sandbox.allow(Foo.class.getName()).read(new String[]{"alias"});
        sandbox.get(Foo.class.getName()).read().alias("alias", "ALIAS");
        JexlEngine sjexl = new JexlBuilder().sandbox(sandbox).safe(false).strict(true).create();
        JexlScript script = sjexl.createScript("foo.alias", new String[]{"foo"});
        Object result = script.execute(null, new Object[]{foo});
        Assertions.assertEquals((Object)foo.alias, (Object)result);
        script = sjexl.createScript("foo.ALIAS", new String[]{"foo"});
        result = script.execute(null, new Object[]{foo});
        Assertions.assertEquals((Object)foo.alias, (Object)result);
    }

    @Test
    public void testGetBlock() throws Exception {
        String expr = "foo.alias";
        JexlScript script = this.JEXL.createScript("foo.alias", new String[]{"foo"});
        Foo foo = new Foo("42");
        Object result = script.execute(null, new Object[]{foo});
        Assertions.assertEquals((Object)foo.alias, (Object)result);
        JexlSandbox sandbox = new JexlSandbox();
        sandbox.block(Foo.class.getName()).read(new String[]{"alias"});
        JexlEngine sjexl = new JexlBuilder().sandbox(sandbox).strict(true).safe(false).create();
        JexlScript script2 = sjexl.createScript("foo.alias", new String[]{"foo"});
        Assertions.assertThrows(JexlException.Property.class, () -> script2.execute(null, new Object[]{foo}), (String)"alias should not be accessible");
    }

    @Test
    public void testGetNullKeyAllowed0() throws Exception {
        JexlEngine jexl = new JexlBuilder().sandbox(new JexlSandbox(true)).create();
        JexlExpression expression = jexl.createExpression("{null : 'foo'}[null]");
        Object o = expression.evaluate(null);
        Assertions.assertEquals((Object)"foo", (Object)o);
    }

    @Test
    public void testGetNullKeyAllowed1() throws Exception {
        JexlSandbox sandbox = new JexlSandbox(true, true);
        JexlSandbox.Permissions p = sandbox.permissions("java.util.Map", false, true, true);
        p.read().add("quux");
        JexlEngine jexl = new JexlBuilder().sandbox(sandbox).create();
        String q = "'quux'";
        JexlExpression expression = jexl.createExpression("{'quux' : 'foo'}['quux']");
        Assertions.assertTrue((boolean)((JexlException.Property)Assertions.assertThrows(JexlException.Property.class, () -> expression.evaluate(null), (String)"should have blocked 'quux'")).getMessage().contains("undefined"));
        for (String k : Arrays.asList("'foo'", "null")) {
            JexlExpression expression2 = jexl.createExpression("{" + k + " : 'foo'}[" + k + "]");
            Object o = expression2.evaluate(null);
            Assertions.assertEquals((Object)"foo", (Object)o);
        }
    }

    @Test
    public void testGetNullKeyBlocked() throws Exception {
        JexlSandbox sandbox = new JexlSandbox(true, true);
        JexlSandbox.Permissions p = sandbox.permissions("java.util.Map", false, true, true);
        p.read().add(null);
        p.read().add("quux");
        JexlEngine jexl = new JexlBuilder().sandbox(sandbox).create();
        JexlExpression e0 = jexl.createExpression("{'bar' : 'foo'}['bar']");
        Object r0 = e0.evaluate(null);
        Assertions.assertEquals((Object)"foo", (Object)r0);
        for (String k : Arrays.asList("'quux'", "null")) {
            JexlExpression expression = jexl.createExpression("{" + k + " : 'foo'}[" + k + "]");
            Assertions.assertTrue((boolean)((JexlException.Property)Assertions.assertThrows(JexlException.Property.class, () -> expression.evaluate(null), (String)("should have blocked " + k))).getMessage().contains("undefined"));
        }
    }

    @Test
    public void testInheritedPermission0() {
        Foo386 foo = new Foo386();
        JexlSandbox sandbox = new JexlSandbox(false, true);
        sandbox.permissions(SomeInterface.class.getName(), true, true, true, true);
        JexlEngine sjexl = new JexlBuilder().sandbox(sandbox).safe(false).strict(true).create();
        JexlScript someOp = sjexl.createScript("foo.bar()", new String[]{"foo"});
        Assertions.assertEquals((Object)42, (Object)someOp.execute(null, new Object[]{foo}));
    }

    @Test
    public void testInheritedPermission1() {
        Quux386 foo = new Quux386();
        JexlSandbox sandbox = new JexlSandbox(false, true);
        sandbox.permissions(Foo386.class.getName(), true, true, true, true);
        JexlEngine sjexl = new JexlBuilder().sandbox(sandbox).safe(false).strict(true).create();
        JexlScript someOp = sjexl.createScript("foo.bar()", new String[]{"foo"});
        Assertions.assertEquals((Object)-42, (Object)someOp.execute(null, new Object[]{foo}));
    }

    @Test
    public void testMethodAllow() throws Exception {
        Foo foo = new Foo("42");
        String expr = "foo.Quux()";
        JexlSandbox sandbox = new JexlSandbox();
        sandbox.allow(Foo.class.getName()).execute(new String[]{"Quux"});
        JexlEngine sjexl = new JexlBuilder().sandbox(sandbox).strict(true).safe(false).create();
        JexlScript script = sjexl.createScript("foo.Quux()", new String[]{"foo"});
        Object result = script.execute(null, new Object[]{foo});
        Assertions.assertEquals((Object)foo.Quux(), (Object)result);
    }

    @Test
    public void testMethodBlock() throws Exception {
        String expr = "foo.Quux()";
        JexlScript script = this.JEXL.createScript("foo.Quux()", new String[]{"foo"});
        Foo foo = new Foo("42");
        Object result = script.execute(null, new Object[]{foo});
        Assertions.assertEquals((Object)foo.Quux(), (Object)result);
        JexlSandbox sandbox = new JexlSandbox();
        sandbox.block(Foo.class.getName()).execute(new String[]{"Quux"});
        JexlEngine sjexl = new JexlBuilder().sandbox(sandbox).strict(true).safe(false).create();
        JexlScript script2 = sjexl.createScript("foo.Quux()", new String[]{"foo"});
        Assertions.assertThrows(JexlException.Method.class, () -> script2.execute(null, new Object[]{foo}), (String)"Quux should not be accessible");
    }

    @Test
    public void testMethodNoJexl() throws Exception {
        Foo foo = new Foo("42");
        String[] exprs = new String[]{"foo.cantCallMe()", "foo.tryMe()", "foo.tryMeARiver()", "foo.callMeNot()", "foo.NONO", "new('org.apache.commons.jexl3.SandboxTest$Foo', 'one', 'two')"};
        JexlEngine sjexl = new JexlBuilder().strict(true).safe(false).create();
        for (String expr : exprs) {
            JexlScript script = sjexl.createScript(expr, new String[]{"foo"});
            Assertions.assertThrows(JexlException.class, () -> script.execute(null, new Object[]{foo}), (String)"should have not been possible");
        }
    }

    @Test
    public void testNoJexl312() throws Exception {
        MapContext ctxt = new MapContext();
        JexlEngine sjexl = new JexlBuilder().safe(false).strict(true).create();
        JexlScript foo = sjexl.createScript("x.getFoo()", new String[]{"x"});
        Assertions.assertThrows(JexlException.class, () -> SandboxTest.lambda$testNoJexl312$7(foo, (JexlContext)ctxt));
    }

    @Test
    public void testNonInheritedPermission0() {
        Foo386 foo = new Foo386();
        JexlSandbox sandbox = new JexlSandbox(false, true);
        sandbox.permissions(SomeInterface.class.getName(), false, true, true, true);
        JexlEngine sjexl = new JexlBuilder().sandbox(sandbox).safe(false).strict(true).create();
        JexlScript someOp = sjexl.createScript("foo.bar()", new String[]{"foo"});
        Assertions.assertThrows(JexlException.class, () -> someOp.execute(null, new Object[]{foo}), (String)"should not be possible");
    }

    @Test
    public void testNonInheritedPermission1() {
        Quux386 foo = new Quux386();
        JexlSandbox sandbox = new JexlSandbox(false, true);
        sandbox.permissions(Foo386.class.getName(), false, true, true, true);
        JexlEngine sjexl = new JexlBuilder().sandbox(sandbox).safe(false).strict(true).create();
        JexlScript someOp = sjexl.createScript("foo.bar()", new String[]{"foo"});
        Assertions.assertThrows(JexlException.class, () -> someOp.execute(null, new Object[]{foo}), (String)"should not be possible");
    }

    @Test
    public void testRestrict() throws Exception {
        MapContext context = new MapContext();
        context.set("System", System.class);
        JexlSandbox sandbox = new JexlSandbox();
        sandbox.allow(System.class.getName()).execute(new String[]{"currentTimeMillis"});
        sandbox.block(File.class.getName()).execute(new String[]{""});
        JexlEngine sjexl = new JexlBuilder().permissions(JexlPermissions.UNRESTRICTED).sandbox(sandbox).safe(false).strict(true).create();
        JexlScript script1 = sjexl.createScript("System.exit()");
        Assertions.assertThrows(JexlException.class, () -> SandboxTest.lambda$testRestrict$10(script1, (JexlContext)context), (String)"should not allow calling exit!");
        JexlScript script2 = sjexl.createScript("System.exit(1)");
        Assertions.assertThrows(JexlException.class, () -> SandboxTest.lambda$testRestrict$11(script2, (JexlContext)context), (String)"should not allow calling exit!");
        JexlScript script3 = sjexl.createScript("new('java.io.File', '/tmp/should-not-be-created')");
        Assertions.assertThrows(JexlException.class, () -> SandboxTest.lambda$testRestrict$12(script3, (JexlContext)context), (String)"should not allow creating a file");
        JexlScript script4 = sjexl.createScript("System.currentTimeMillis()");
        Object result = script4.execute((JexlContext)context);
        Assertions.assertNotNull((Object)result);
    }

    @Test
    public void testSandboxInherit0() throws Exception {
        JexlContext ctxt = null;
        ArrayList foo = new ArrayList();
        JexlSandbox sandbox = new JexlSandbox(false, true);
        sandbox.allow(List.class.getName());
        JexlEngine sjexl = new JexlBuilder().sandbox(sandbox).safe(false).strict(true).create();
        JexlScript method = sjexl.createScript("foo.add(y)", new String[]{"foo", "y"});
        JexlScript set = sjexl.createScript("foo[x] = y", new String[]{"foo", "x", "y"});
        JexlScript get = sjexl.createScript("foo[x]", new String[]{"foo", "x"});
        Object result = method.execute(ctxt, new Object[]{foo, "nothing"});
        Assertions.assertEquals((Object)true, (Object)result);
        result = null;
        result = get.execute(null, new Object[]{foo, 0});
        Assertions.assertEquals((Object)"nothing", (Object)result);
        result = null;
        result = set.execute(null, new Object[]{foo, 0, "42"});
        Assertions.assertEquals((Object)"42", (Object)result);
        result = null;
        result = get.execute(null, new Object[]{foo, 0});
        Assertions.assertEquals((Object)"42", (Object)result);
    }

    @Test
    public void testSandboxInherit1() throws Exception {
        JexlContext ctxt = null;
        Operation2 foo = new Operation2(12);
        JexlSandbox sandbox = new JexlSandbox(false, true);
        sandbox.allow(Operation.class.getName());
        sandbox.block(Operation.class.getName()).execute(new String[]{"nonCallable"});
        JexlEngine sjexl = new JexlBuilder().sandbox(sandbox).safe(false).strict(true).create();
        JexlScript someOp = sjexl.createScript("foo.someOp(y)", new String[]{"foo", "y"});
        Object result = someOp.execute(ctxt, new Object[]{foo, 30});
        Assertions.assertEquals((Object)42, (Object)result);
        JexlScript nonCallable = sjexl.createScript("foo.nonCallable(y)", new String[]{"foo", "y"});
        Assertions.assertThrows(JexlException.class, () -> nonCallable.execute(null, new Object[]{foo, 0}));
    }

    @Test
    public void testSetAllow() throws Exception {
        Foo foo = new Foo("42");
        String expr = "foo.alias = $0";
        JexlSandbox sandbox = new JexlSandbox();
        sandbox.allow(Foo.class.getName()).write(new String[]{"alias"});
        JexlEngine sjexl = new JexlBuilder().sandbox(sandbox).safe(false).strict(true).create();
        JexlScript script = sjexl.createScript("foo.alias = $0", new String[]{"foo", "$0"});
        Object result = script.execute(null, new Object[]{foo, "43"});
        Assertions.assertEquals((Object)"43", (Object)result);
        Assertions.assertEquals((Object)"43", (Object)foo.alias);
    }

    @Test
    public void testSetBlock() throws Exception {
        String expr = "foo.alias = $0";
        JexlScript script1 = this.JEXL.createScript("foo.alias = $0", new String[]{"foo", "$0"});
        Foo foo = new Foo("42");
        Object result = script1.execute(null, new Object[]{foo, "43"});
        Assertions.assertEquals((Object)"43", (Object)result);
        JexlSandbox sandbox = new JexlSandbox();
        sandbox.block(Foo.class.getName()).write(new String[]{"alias"});
        JexlEngine sjexl = new JexlBuilder().sandbox(sandbox).strict(true).safe(false).create();
        JexlScript script2 = sjexl.createScript("foo.alias = $0", new String[]{"foo", "$0"});
        Assertions.assertThrows(JexlException.class, () -> script2.execute(null, new Object[]{foo, "43"}), (String)"alias should not be accessible");
    }

    @Test
    public void testSetNullKeyAllowed0() throws Exception {
        Arithmetic350 a350 = new Arithmetic350(true);
        JexlEngine jexl = new JexlBuilder().arithmetic((JexlArithmetic)a350).sandbox(new JexlSandbox(true)).create();
        MapContext jc = new MapContext();
        JexlExpression expression = jexl.createExpression("{null : 'foo'}[null] = 'bar'");
        expression.evaluate((JexlContext)jc);
        Map<?, ?> map = a350.getLastMap();
        Assertions.assertEquals((Object)"bar", map.get(null));
    }

    @Test
    public void testSetNullKeyAllowed1() throws Exception {
        Arithmetic350 a350 = new Arithmetic350(true);
        JexlSandbox sandbox = new JexlSandbox(true, true);
        JexlSandbox.Permissions p = sandbox.permissions("java.util.Map", true, false, true);
        p.write().add("quux");
        JexlEngine jexl = new JexlBuilder().arithmetic((JexlArithmetic)a350).sandbox(sandbox).create();
        String q = "'quux'";
        JexlExpression expression1 = jexl.createExpression("{'quux' : 'foo'}['quux'] = '42'");
        Assertions.assertTrue((boolean)((JexlException.Property)Assertions.assertThrows(JexlException.Property.class, () -> expression1.evaluate(null), (String)"should have blocked 'quux'")).getMessage().contains("undefined"));
        JexlExpression expression2 = jexl.createExpression("{'bar' : 'foo'}['bar'] = '42'");
        expression2.evaluate(null);
        Map<?, ?> map = a350.getLastMap();
        Assertions.assertEquals((Object)"42", map.get("bar"));
        map.clear();
        expression2 = jexl.createExpression("{null : 'foo'}[null] = '42'");
        expression2.evaluate(null);
        map = a350.getLastMap();
        Assertions.assertEquals((Object)"42", map.get(null));
    }

    @Test
    public void testSetNullKeyBlocked() throws Exception {
        Arithmetic350 a350 = new Arithmetic350(true);
        JexlSandbox sandbox = new JexlSandbox(true, true);
        JexlSandbox.Permissions p = sandbox.permissions("java.util.Map", true, false, true);
        p.write().add(null);
        p.write().add("quux");
        JexlEngine jexl = new JexlBuilder().arithmetic((JexlArithmetic)a350).sandbox(sandbox).create();
        JexlExpression expression = jexl.createExpression("{'bar' : 'foo'}['bar'] = '42'");
        expression.evaluate(null);
        Map<?, ?> map = a350.getLastMap();
        Assertions.assertEquals((Object)"42", map.get("bar"));
        for (String k : Arrays.asList("'quux'", "null")) {
            JexlExpression expression2 = jexl.createExpression("{" + k + " : 'foo'}[" + k + "] = '42'");
            Assertions.assertTrue((boolean)((JexlException.Property)Assertions.assertThrows(JexlException.Property.class, () -> expression2.evaluate(null), (String)("should have blocked " + k))).getMessage().contains("undefined"));
        }
    }

    private static /* synthetic */ void lambda$testRestrict$12(JexlScript script3, JexlContext context) throws Throwable {
        script3.execute(context);
    }

    private static /* synthetic */ void lambda$testRestrict$11(JexlScript script2, JexlContext context) throws Throwable {
        script2.execute(context);
    }

    private static /* synthetic */ void lambda$testRestrict$10(JexlScript script1, JexlContext context) throws Throwable {
        script1.execute(context);
    }

    private static /* synthetic */ void lambda$testNoJexl312$7(JexlScript foo, JexlContext ctxt) throws Throwable {
        foo.execute(ctxt, new Object[]{new Foo44()});
    }

    private static /* synthetic */ void lambda$testCantSeeMe$0(JexlScript script, JexlContext jc) throws Throwable {
        script.execute(jc);
    }

    public static class Foo
    extends AbstractCallMeNot
    implements CantCallMe,
    TryCallMe {
        String name;
        public String alias;

        public Foo(String name) {
            this.name = name;
            this.alias = name + "-alias";
        }

        @NoJexl
        public Foo(String name, String notcallable) {
            throw new UnsupportedOperationException("should not be callable!");
        }

        @NoJexl
        public String cantCallMe() {
            throw new UnsupportedOperationException("should not be callable!");
        }

        public int doIt() {
            return 42;
        }

        public String getName() {
            return this.name;
        }

        public String Quux() {
            return this.name + "-quux";
        }

        public void setName(String name) {
            this.name = name;
        }

        @Override
        public void tryMe() {
            throw new UnsupportedOperationException("should not be callable!");
        }

        @Override
        public void tryMeARiver() {
            throw new UnsupportedOperationException("should not be callable!");
        }
    }

    public static class CantSeeMe {
        public boolean doIt() {
            return false;
        }
    }

    public static class Foo386
    implements SomeInterface {
        @Override
        public int bar() {
            return 42;
        }
    }

    public static interface SomeInterface {
        public int bar();
    }

    public static class Quux386
    extends Foo386 {
        @Override
        public int bar() {
            return -42;
        }
    }

    public static class Operation2
    extends Operation {
        public Operation2(int sz) {
            super(sz);
        }

        @Override
        public int nonCallable(int y) {
            throw new UnsupportedOperationException("do NOT call");
        }

        @Override
        public int someOp(int x) {
            return this.base + x;
        }
    }

    public static abstract class Operation {
        protected final int base;

        public Operation(int sz) {
            this.base = sz;
        }

        public abstract int nonCallable(int var1);

        public abstract int someOp(int var1);
    }

    public static class Arithmetic350
    extends JexlArithmetic {
        JexlArithmetic.MapBuilder mb = new MapBuilder(3);

        public Arithmetic350(boolean astrict) {
            super(astrict);
        }

        Map<?, ?> getLastMap() {
            return (Map)this.mb.create();
        }

        public JexlArithmetic.MapBuilder mapBuilder(int size, boolean extended) {
            return this.mb;
        }
    }

    public static class Foo44
    extends Foo43 {
        @Override
        public int getFoo() {
            return 44;
        }
    }

    public static interface TryCallMe {
        @NoJexl
        public void tryMeARiver();
    }

    public static class Foo43
    extends Foo42 {
        @Override
        @NoJexl
        public int getFoo() {
            return 43;
        }
    }

    public static class Foo42 {
        public int getFoo() {
            return 42;
        }
    }

    @NoJexl
    public static interface CantCallMe {
        public void tryMe();
    }

    public static abstract class AbstractCallMeNot {
        @NoJexl
        public String NONO = "should not be accessible!";

        public String allowInherit() {
            return "this is allowed";
        }

        @NoJexl
        public void callMeNot() {
            Assertions.fail((String)"should not be callable!");
        }
    }
}

