/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.scripting;

import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.introspection.JexlPermissions;
import org.apache.commons.jexl3.scripting.JexlScriptEngine;
import org.apache.commons.jexl3.scripting.JexlScriptEngineFactory;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JexlScriptEngineTest {
    private static final List<String> NAMES = Arrays.asList("JEXL", "Jexl", "jexl", "JEXL2", "Jexl2", "jexl2", "JEXL3", "Jexl3", "jexl3");
    private static final List<String> EXTENSIONS = Arrays.asList("jexl", "jexl2", "jexl3");
    private static final List<String> MIMES = Arrays.asList("application/x-jexl", "application/x-jexl2", "application/x-jexl3");

    @AfterEach
    public void tearDown() {
        JexlBuilder.setDefaultPermissions(null);
        JexlScriptEngine.setInstance(null);
        JexlScriptEngine.setPermissions(null);
    }

    @Test
    public void testCompile() throws Exception {
        ScriptEngineManager manager = new ScriptEngineManager();
        JexlScriptEngine engine = (JexlScriptEngine)manager.getEngineByName("JEXL");
        ScriptContext ctxt = engine.getContext();
        String str = null;
        Reader reader = null;
        Assertions.assertThrows(NullPointerException.class, () -> engine.compile(str));
        Assertions.assertThrows(NullPointerException.class, () -> engine.compile(reader));
        CompiledScript script0 = engine.compile((Reader)new StringReader("3 + 4"));
        Assertions.assertEquals((Object)engine, (Object)script0.getEngine());
        Object result = script0.eval();
        Assertions.assertEquals((Object)7, (Object)result);
        result = script0.eval();
        Assertions.assertEquals((Object)7, (Object)result);
        result = engine.eval((Reader)new StringReader("38 + 4"));
        Assertions.assertEquals((Object)42, (Object)result);
        result = engine.eval("38 + 4");
        Assertions.assertEquals((Object)42, (Object)result);
        CompiledScript script1 = engine.compile("3 + 4");
        Assertions.assertEquals((Object)engine, (Object)script1.getEngine());
        Object result1 = script1.eval();
        Assertions.assertEquals((Object)7, (Object)result1);
        result1 = script1.eval();
        Assertions.assertEquals((Object)7, (Object)result1);
        ctxt.setAttribute("x", 20, 100);
        ctxt.setAttribute("y", 22, 100);
        CompiledScript script2 = engine.compile("x + y");
        Object result2 = script2.eval();
        Assertions.assertEquals((Object)42, (Object)result2);
        ctxt.setAttribute("x", -20, 100);
        ctxt.setAttribute("y", -22, 100);
        result2 = script2.eval();
        Assertions.assertEquals((Object)-42, (Object)result2);
    }

    @Test
    public void testDirectNew() throws Exception {
        JexlScriptEngine engine = new JexlScriptEngine();
        Integer initialValue = 123;
        Assertions.assertEquals((Object)initialValue, (Object)engine.eval("123"));
    }

    @Test
    public void testDottedNames() throws Exception {
        ScriptEngineManager manager = new ScriptEngineManager();
        Assertions.assertNotNull((Object)manager, (String)"Manager should not be null");
        ScriptEngine engine = manager.getEngineByName("JEXL");
        Assertions.assertNotNull((Object)engine, (String)"Engine should not be null (JEXL)");
        engine.eval("this.is.a.test=null");
        Assertions.assertNull((Object)engine.get("this.is.a.test"));
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)engine.eval("empty(this.is.a.test)"));
        Object mymap = engine.eval("testmap={ 'key1' : 'value1', 'key2' : 'value2' }");
        Assertions.assertTrue((boolean)(mymap instanceof Map));
        Assertions.assertEquals((int)2, (int)((Map)mymap).size());
    }

    @Test
    public void testErrors() throws Exception {
        ScriptEngineManager manager = new ScriptEngineManager();
        JexlScriptEngine engine = (JexlScriptEngine)manager.getEngineByName("JEXL");
        ScriptContext ctxt = engine.getContext();
        engine.put("errors", (Object)new Errors());
        Assertions.assertTrue((boolean)(((ScriptException)Assertions.assertThrows(ScriptException.class, () -> engine.eval("errors.npe()"))).getCause() instanceof NullPointerException));
        Assertions.assertTrue((boolean)(((ScriptException)Assertions.assertThrows(ScriptException.class, () -> engine.eval("errors.illegal()"))).getCause() instanceof IllegalArgumentException));
        CompiledScript script0 = engine.compile("errors.npe()");
        Assertions.assertTrue((boolean)(((ScriptException)Assertions.assertThrows(ScriptException.class, () -> script0.eval())).getCause() instanceof NullPointerException));
        CompiledScript script1 = engine.compile("errors.illegal()");
        Assertions.assertTrue((boolean)(((ScriptException)Assertions.assertThrows(ScriptException.class, () -> script1.eval())).getCause() instanceof IllegalArgumentException));
    }

    @Test
    public void testNulls() throws Exception {
        ScriptEngineManager manager = new ScriptEngineManager();
        Assertions.assertNotNull((Object)manager, (String)"Manager should not be null");
        ScriptEngine engine = manager.getEngineByName("jexl3");
        Assertions.assertNotNull((Object)engine, (String)"Engine should not be null (name)");
        Assertions.assertNotNull((Object)engine.getFactory());
        Assertions.assertThrows(NullPointerException.class, () -> engine.eval((String)null));
        Assertions.assertThrows(NullPointerException.class, () -> engine.eval((Reader)null));
        ScriptContext ctxt = null;
        Assertions.assertThrows(NullPointerException.class, () -> engine.eval((String)null, ctxt));
        Assertions.assertThrows(NullPointerException.class, () -> engine.eval((Reader)null, ctxt));
    }

    @Test
    public void testScopes() throws Exception {
        ScriptEngineManager manager = new ScriptEngineManager();
        Assertions.assertNotNull((Object)manager, (String)"Manager should not be null");
        ScriptEngine engine = manager.getEngineByName("jexl3");
        Assertions.assertNotNull((Object)engine, (String)"Engine should not be null (name)");
        manager.put("global", 1);
        engine.put("local", 10);
        manager.put("both", 7);
        engine.put("both", 7);
        engine.eval("local=local+1");
        engine.eval("global=global+1");
        engine.eval("both=both+1");
        engine.eval("newvar=42;");
        Assertions.assertEquals((Object)2, (Object)manager.get("global"));
        Assertions.assertEquals((Object)11, (Object)engine.get("local"));
        Assertions.assertEquals((Object)7, (Object)manager.get("both"));
        Assertions.assertEquals((Object)8, (Object)engine.get("both"));
        Assertions.assertEquals((Object)42, (Object)engine.get("newvar"));
        Assertions.assertNull((Object)manager.get("newvar"));
    }

    @Test
    public void testScriptEngineFactory() throws Exception {
        JexlScriptEngineFactory factory = new JexlScriptEngineFactory();
        Assertions.assertEquals((Object)"JEXL Engine", (Object)factory.getParameter("javax.script.engine"));
        Assertions.assertEquals((Object)"3.4", (Object)factory.getParameter("javax.script.engine_version"));
        Assertions.assertEquals((Object)"JEXL", (Object)factory.getParameter("javax.script.language"));
        Assertions.assertEquals((Object)"3.4", (Object)factory.getParameter("javax.script.language_version"));
        Assertions.assertNull((Object)factory.getParameter("THREADING"));
        Assertions.assertEquals(NAMES, (Object)factory.getParameter("javax.script.name"));
        Assertions.assertEquals(EXTENSIONS, (Object)factory.getExtensions());
        Assertions.assertEquals(MIMES, (Object)factory.getMimeTypes());
        Assertions.assertEquals((Object)"42;", (Object)factory.getProgram(new String[]{"42"}));
        Assertions.assertEquals((Object)"str.substring(3,4)", (Object)factory.getMethodCallSyntax("str", "substring", new String[]{"3", "4"}));
    }

    @Test
    public void testScripting() throws Exception {
        ScriptEngineManager manager = new ScriptEngineManager();
        Assertions.assertNotNull((Object)manager, (String)"Manager should not be null");
        ScriptEngine engine = manager.getEngineByName("jexl3");
        Integer initialValue = 123;
        Assertions.assertEquals((Object)initialValue, (Object)engine.eval("123"));
        Assertions.assertEquals((Object)initialValue, (Object)engine.eval("0;123"));
        ScriptException xscript = (ScriptException)Assertions.assertThrows(ScriptException.class, () -> engine.eval("sys=context.class.forName(\"java.lang.System\");now=sys.currentTimeMillis();"));
        JexlException.Method xjexl = (JexlException.Method)xscript.getCause();
        Assertions.assertEquals((Object)"forName", (Object)xjexl.getMethod());
        engine.put("value", initialValue);
        Assertions.assertEquals((Object)initialValue, (Object)engine.get("value"));
        Integer newValue = 124;
        Assertions.assertEquals((Object)newValue, (Object)engine.eval("old=value;value=value+1"));
        Assertions.assertEquals((Object)initialValue, (Object)engine.get("old"));
        Assertions.assertEquals((Object)newValue, (Object)engine.get("value"));
        Assertions.assertEquals((Object)engine.getContext(), (Object)engine.get("context"));
        Assertions.assertEquals((Object)engine.getContext().getReader(), (Object)engine.eval("JEXL.in"));
        Assertions.assertEquals((Object)engine.getContext().getWriter(), (Object)engine.eval("JEXL.out"));
        Assertions.assertEquals((Object)engine.getContext().getErrorWriter(), (Object)engine.eval("JEXL.err"));
        Assertions.assertEquals(System.class, (Object)engine.eval("JEXL.System"));
    }

    @Test
    public void testScriptingGetBy() throws Exception {
        ScriptEngine engine;
        ScriptEngineManager manager = new ScriptEngineManager();
        Assertions.assertNotNull((Object)manager, (String)"Manager should not be null");
        for (String name : NAMES) {
            engine = manager.getEngineByName(name);
            Assertions.assertNotNull((Object)engine, (String)"Engine should not be null (name)");
        }
        for (String extension : EXTENSIONS) {
            engine = manager.getEngineByExtension(extension);
            Assertions.assertNotNull((Object)engine, (String)"Engine should not be null (extension)");
        }
        for (String mime : MIMES) {
            engine = manager.getEngineByMimeType(mime);
            Assertions.assertNotNull((Object)engine, (String)"Engine should not be null (mime)");
        }
    }

    @Test
    public void testScriptingInstance0() throws Exception {
        JexlScriptEngine.setPermissions((JexlPermissions)JexlPermissions.UNRESTRICTED);
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine engine = manager.getEngineByName("jexl3");
        Long time2 = (Long)engine.eval("sys=context.class.forName(\"java.lang.System\");now=sys.currentTimeMillis();");
        Assertions.assertTrue((time2 <= System.currentTimeMillis() ? 1 : 0) != 0);
    }

    @Test
    public void testScriptingPermissions1() throws Exception {
        JexlBuilder.setDefaultPermissions((JexlPermissions)JexlPermissions.UNRESTRICTED);
        JexlScriptEngine.setPermissions(null);
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine engine = manager.getEngineByName("jexl3");
        Long time2 = (Long)engine.eval("sys=context.class.forName(\"java.lang.System\");now=sys.currentTimeMillis();");
        Assertions.assertTrue((time2 <= System.currentTimeMillis() ? 1 : 0) != 0);
    }

    public static class Errors {
        public int illegal() {
            throw new IllegalArgumentException("jexl");
        }

        public int npe() {
            throw new NullPointerException("jexl");
        }
    }
}

