/* Parser.java */
/* Generated by:  JJTree&ParserGeneratorCC: Do not edit this line. Parser.java */
package org.apache.commons.jexl3.parser;

import java.util.Collections;
import java.util.List;
import java.util.LinkedList;

import org.apache.commons.jexl3.JexlInfo;
import org.apache.commons.jexl3.JexlFeatures;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.internal.Scope;

public final class Parser extends JexlParser/*@bgen(jjtree)*/implements ParserTreeConstants, ParserConstants {/*@bgen(jjtree)*/
  protected JJTParserState jjtree = new JJTParserState();public ASTJexlScript parse(JexlInfo jexlInfo, JexlFeatures jexlFeatures, String jexlSrc, Scope jexlScope) {
        JexlFeatures previous = getFeatures();
        try {
            setFeatures(jexlFeatures);
            // lets do the 'Unique Init' in here to be safe - it's a pain to remember
            info = jexlInfo != null? jexlInfo : new JexlInfo();
            source = jexlSrc;
            pragmas = null;
            this.scope = jexlScope;
            token_source.comparatorNames = jexlFeatures.supportsComparatorNames();
            ReInit(jexlSrc);
            ASTJexlScript script = jexlFeatures.supportsScript()? JexlScript(jexlScope) : JexlExpression(jexlScope);
            script.jjtSetValue(info.detach());
            script.setFeatures(jexlFeatures);
            script.setPragmas(pragmas != null
                             ? Collections.unmodifiableMap(pragmas)
                             : Collections.emptyMap());
            return script;
        } catch (TokenMgrException xtme) {
            throw new JexlException.Tokenization(info, xtme).clean();
        } catch (ParseException xparse) {
            Token errortok = errorToken(jj_lastpos, jj_scanpos, token.next, token);
            throw new JexlException.Parsing(info.at(errortok.beginLine, errortok.beginColumn), errortok.image).clean();
        } finally {
            token_source.defaultLexState = DEFAULT;
            cleanup(previous);
            jjtree.reset();
        }
    }

/***************************************
 *      Statements
 ***************************************/
  final public 
ASTJexlScript JexlScript(Scope frame) throws ParseException {/*@bgen(jjtree) JexlScript */
    ASTJexlScript jjtn000 = new ASTJexlScript(JJTJEXLSCRIPT);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtreeOpenNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));jjtn000.setScope(frame);
    try {
pushUnit(jjtn000);
      label_1:
      while (true) {
        if (jj_2_1(1)) {
        } else {
          break label_1;
        }
        if (jj_2_2(2147483647)) {
          Pragma();
        } else if (jj_2_3(1)) {
controlPragmaAnywhere();
          Statement();
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      jj_consume_token(0);
jjtree.closeNodeScope(jjtn000, true);
     jjtc000 = false;
     if (jjtree.nodeCreated()) {
      jjtreeCloseNodeScope(jjtn000);
     }
     jjtn000.jjtSetLastToken(getToken(0));
popUnit(jjtn000);
        {if ("" != null) return jjtn000.script();}
    } catch (Throwable jjte000) {
if (jjtc000) {
       jjtree.clearNodeScope(jjtn000);
       jjtc000 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte000 instanceof ParseException) {
       throw (ParseException)jjte000;
     }
     if (jjte000 instanceof RuntimeException) {
       throw (RuntimeException)jjte000;
     }
     throw (Error)jjte000;
    } finally {
if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
       if (jjtree.nodeCreated()) {
        jjtreeCloseNodeScope(jjtn000);
       }
       jjtn000.jjtSetLastToken(getToken(0));
     }
    }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ASTJexlScript JexlExpression(Scope frame) throws ParseException {/*@bgen(jjtree) JexlScript */
    ASTJexlScript jjtn000 = new ASTJexlScript(JJTJEXLSCRIPT);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtreeOpenNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));jjtn000.setScope(frame);
    try {
pushUnit(jjtn000);
      label_2:
      while (true) {
        switch (jj_nt.kind) {
        case PRAGMA:{
          break;
          }
        default:
          break label_2;
        }
        Pragma();
      }
controlPragmaAnywhere();
      if (jj_2_4(1)) {
        Expression();
      } else {
        ;
      }
      jj_consume_token(0);
jjtree.closeNodeScope(jjtn000, true);
     jjtc000 = false;
     if (jjtree.nodeCreated()) {
      jjtreeCloseNodeScope(jjtn000);
     }
     jjtn000.jjtSetLastToken(getToken(0));
popUnit(jjtn000);
        {if ("" != null) return jjtn000.script();}
    } catch (Throwable jjte000) {
if (jjtc000) {
       jjtree.clearNodeScope(jjtn000);
       jjtc000 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte000 instanceof ParseException) {
       throw (ParseException)jjte000;
     }
     if (jjte000 instanceof RuntimeException) {
       throw (RuntimeException)jjte000;
     }
     throw (Error)jjte000;
    } finally {
if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
       if (jjtree.nodeCreated()) {
        jjtreeCloseNodeScope(jjtn000);
       }
       jjtn000.jjtSetLastToken(getToken(0));
     }
    }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public void Annotation() throws ParseException {/*@bgen(jjtree) Annotation */
    ASTAnnotation jjtn000 = new ASTAnnotation(JJTANNOTATION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtreeOpenNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Token t;
    try {
      t = jj_consume_token(ANNOTATION);
jjtn000.setName(t.image);
      if (jj_2_5(2147483647)) {
        Arguments();
      } else {
        ;
      }
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof ParseException) {
        throw (ParseException)jjte000;
      }
      if (jjte000 instanceof RuntimeException) {
        throw (RuntimeException)jjte000;
      }
      throw (Error)jjte000;
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        if (jjtree.nodeCreated()) {
         jjtreeCloseNodeScope(jjtn000);
        }
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
}

  final public void AnnotatedStatement() throws ParseException {/*@bgen(jjtree) AnnotatedStatement */
  ASTAnnotatedStatement jjtn000 = new ASTAnnotatedStatement(JJTANNOTATEDSTATEMENT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      label_3:
      while (true) {
        Annotation();
        if (jj_2_6(2147483647)) {
        } else {
          break label_3;
        }
      }
      switch (jj_nt.kind) {
      case LCURLY:{
        Block();
        break;
        }
      default:
        if (jj_2_7(1)) {
          Statement();
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof ParseException) {
        throw (ParseException)jjte000;
      }
      if (jjte000 instanceof RuntimeException) {
        throw (RuntimeException)jjte000;
      }
      throw (Error)jjte000;
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        if (jjtree.nodeCreated()) {
         jjtreeCloseNodeScope(jjtn000);
        }
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
}

  final public void Statement() throws ParseException {
    if (jj_2_8(2147483647)) {
      Var();
    } else if (jj_2_9(2147483647)) {
      FunctionStatement();
    } else if (jj_2_10(1)) {
      StatementNoVar();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public void StatementNoVar() throws ParseException {
    switch (jj_nt.kind) {
    case SEMICOL:{
      jj_consume_token(SEMICOL);
      break;
      }
    default:
      if (jj_2_11(2147483647)) {
        AnnotatedStatement();
      } else if (jj_2_12(2147483647)) {
        IfStatement();
      } else if (jj_2_13(2147483647)) {
        ForeachStatement();
      } else if (jj_2_14(2147483647)) {
        WhileStatement();
      } else if (jj_2_15(2147483647)) {
        DoWhileStatement();
      } else if (jj_2_16(2147483647)) {
        ReturnStatement();
      } else if (jj_2_17(2147483647)) {
        Continue();
      } else if (jj_2_18(2147483647)) {
        Break();
      } else if (jj_2_19(2147483647)) {
        ThrowStatement();
      } else if (jj_2_20(2147483647)) {
        TryStatement();
      } else if (jj_2_21(2147483647)) {
        Lambda();
      } else if (jj_2_22(2147483647)) {
        ExpressionStatement();
      } else {
        switch (jj_nt.kind) {
        case LCURLY:{
          Block();
          break;
          }
        default:
          if (jj_2_23(2147483647) && (!getFeatures().isLexical())) {
            Var();
          } else {
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      }
    }
}

  final public void Block() throws ParseException {/*@bgen(jjtree) Block */
  ASTBlock jjtn000 = new ASTBlock(JJTBLOCK);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(LCURLY);
pushUnit(jjtn000);
      label_4:
      while (true) {
        if (jj_2_24(1)) {
        } else {
          break label_4;
        }
        if (jj_2_25(2147483647)) {
          Pragma();
        } else if (jj_2_26(1)) {
          Statement();
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
popUnit(jjtn000);
      jj_consume_token(RCURLY);
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof ParseException) {
        throw (ParseException)jjte000;
      }
      if (jjte000 instanceof RuntimeException) {
        throw (RuntimeException)jjte000;
      }
      throw (Error)jjte000;
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        if (jjtree.nodeCreated()) {
         jjtreeCloseNodeScope(jjtn000);
        }
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
}

  final public void FunctionStatement() throws ParseException {/*@bgen(jjtree) JexlLambda */
  ASTJexlLambda jjtn000 = new ASTJexlLambda(JJTJEXLLAMBDA);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(FUNCTION);
      DeclareFunction();
pushScope(); pushUnit(jjtn000);
      Parameters();
      if (jj_2_27(3)) {
        Block();
      } else if (jj_2_28(1)) {
        Expression();
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
jjtree.closeNodeScope(jjtn000, true);
                                                                                                                       jjtc000 = false;
                                                                                                                       if (jjtree.nodeCreated()) {
                                                                                                                        jjtreeCloseNodeScope(jjtn000);
                                                                                                                       }
                                                                                                                       jjtn000.jjtSetLastToken(getToken(0));
popUnit(jjtn000); popScope();
    } catch (Throwable jjte000) {
if (jjtc000) {
    jjtree.clearNodeScope(jjtn000);
    jjtc000 = false;
  } else {
    jjtree.popNode();
  }
  if (jjte000 instanceof ParseException) {
    throw (ParseException)jjte000;
  }
  if (jjte000 instanceof RuntimeException) {
    throw (RuntimeException)jjte000;
  }
  throw (Error)jjte000;
    } finally {
if (jjtc000) {
    jjtree.closeNodeScope(jjtn000, true);
    if (jjtree.nodeCreated()) {
     jjtreeCloseNodeScope(jjtn000);
    }
    jjtn000.jjtSetLastToken(getToken(0));
  }
    }
}

  final public void ExpressionStatement() throws ParseException {
    Expression();
    label_5:
    while (true) {
      if (jj_2_29(2147483647)) {
      } else {
        break label_5;
      }
ASTAmbiguous jjtn001 = new ASTAmbiguous(JJTAMBIGUOUS);
                                            boolean jjtc001 = true;
                                            jjtree.openNodeScope(jjtn001);
                                            jjtreeOpenNodeScope(jjtn001);
                                            jjtn001.jjtSetFirstToken(getToken(1));
      try {
        Expression();
      } catch (Throwable jjte001) {
if (jjtc001) {
                                              jjtree.clearNodeScope(jjtn001);
                                              jjtc001 = false;
                                            } else {
                                              jjtree.popNode();
                                            }
                                            if (jjte001 instanceof ParseException) {
                                              throw (ParseException)jjte001;
                                            }
                                            if (jjte001 instanceof RuntimeException) {
                                              throw (RuntimeException)jjte001;
                                            }
                                            throw (Error)jjte001;
      } finally {
if (jjtc001) {
                                              jjtree.closeNodeScope(jjtn001,  1);
                                              if (jjtree.nodeCreated()) {
                                               jjtreeCloseNodeScope(jjtn001);
                                              }
                                              jjtn001.jjtSetLastToken(getToken(0));
                                            }
      }
    }
    switch (jj_nt.kind) {
    case SEMICOL:{
      jj_consume_token(SEMICOL);
      break;
      }
    default:
      ;
    }
}

  final public void IfStatement() throws ParseException {/*@bgen(jjtree) IfStatement */
  ASTIfStatement jjtn000 = new ASTIfStatement(JJTIFSTATEMENT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(IF);
      jj_consume_token(LPAREN);
      Expression();
      jj_consume_token(RPAREN);
      switch (jj_nt.kind) {
      case LCURLY:{
        Block();
        break;
        }
      default:
        if (jj_2_30(1)) {
          StatementNoVar();
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      label_6:
      while (true) {
        if (jj_2_31(2)) {
        } else {
          break label_6;
        }
        jj_consume_token(ELSE);
        jj_consume_token(IF);
        jj_consume_token(LPAREN);
        Expression();
        jj_consume_token(RPAREN);
        switch (jj_nt.kind) {
        case LCURLY:{
          Block();
          break;
          }
        default:
          if (jj_2_32(1)) {
            StatementNoVar();
          } else {
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      }
      switch (jj_nt.kind) {
      case ELSE:{
        jj_consume_token(ELSE);
        switch (jj_nt.kind) {
        case LCURLY:{
          Block();
          break;
          }
        default:
          if (jj_2_33(1)) {
            StatementNoVar();
          } else {
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        break;
        }
      default:
        ;
      }
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof ParseException) {
        throw (ParseException)jjte000;
      }
      if (jjte000 instanceof RuntimeException) {
        throw (RuntimeException)jjte000;
      }
      throw (Error)jjte000;
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        if (jjtree.nodeCreated()) {
         jjtreeCloseNodeScope(jjtn000);
        }
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
}

  final public void TryStatement() throws ParseException {/*@bgen(jjtree) TryStatement */
  ASTTryStatement jjtn000 = new ASTTryStatement(JJTTRYSTATEMENT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(TRY);
      switch (jj_nt.kind) {
      case LPAREN:{
        TryResources();
        break;
        }
      case LCURLY:{
        Block();
        break;
        }
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch (jj_nt.kind) {
      case CATCH:{
        jj_consume_token(CATCH);
        jj_consume_token(LPAREN);
        InlineVar();
        jj_consume_token(RPAREN);
        Block();
jjtn000.catchClause();
        break;
        }
      default:
        ;
      }
      switch (jj_nt.kind) {
      case FINALLY:{
        jj_consume_token(FINALLY);
        Block();
jjtn000.finallyClause();
        break;
        }
      default:
        ;
      }
    } catch (Throwable jjte000) {
if (jjtc000) {
         jjtree.clearNodeScope(jjtn000);
         jjtc000 = false;
       } else {
         jjtree.popNode();
       }
       if (jjte000 instanceof ParseException) {
         throw (ParseException)jjte000;
       }
       if (jjte000 instanceof RuntimeException) {
         throw (RuntimeException)jjte000;
       }
       throw (Error)jjte000;
    } finally {
if (jjtc000) {
         jjtree.closeNodeScope(jjtn000, true);
         if (jjtree.nodeCreated()) {
          jjtreeCloseNodeScope(jjtn000);
         }
         jjtn000.jjtSetLastToken(getToken(0));
       }
    }
}

  final public void TryResources() throws ParseException {/*@bgen(jjtree) TryResources */
  ASTTryResources jjtn000 = new ASTTryResources(JJTTRYRESOURCES);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
pushUnit(jjtn000);
      jj_consume_token(LPAREN);
      TryResource();
      label_7:
      while (true) {
        if (jj_2_34(2)) {
        } else {
          break label_7;
        }
        jj_consume_token(SEMICOL);
        TryResource();
      }
      switch (jj_nt.kind) {
      case SEMICOL:{
        jj_consume_token(SEMICOL);
        break;
        }
      default:
        ;
      }
      jj_consume_token(RPAREN);
      Block();
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      if (jjtree.nodeCreated()) {
       jjtreeCloseNodeScope(jjtn000);
      }
      jjtn000.jjtSetLastToken(getToken(0));
popUnit(jjtn000);
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof ParseException) {
        throw (ParseException)jjte000;
      }
      if (jjte000 instanceof RuntimeException) {
        throw (RuntimeException)jjte000;
      }
      throw (Error)jjte000;
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        if (jjtree.nodeCreated()) {
         jjtreeCloseNodeScope(jjtn000);
        }
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
}

  final public void TryResource() throws ParseException {
    if (jj_2_35(2)) {
      Var();
    } else {
      switch (jj_nt.kind) {
      case IDENTIFIER:
      case REGISTER:{
        Identifier(true);
        break;
        }
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
}

  final public void WhileStatement() throws ParseException {/*@bgen(jjtree) WhileStatement */
  ASTWhileStatement jjtn000 = new ASTWhileStatement(JJTWHILESTATEMENT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(WHILE);
      jj_consume_token(LPAREN);
      Expression();
      jj_consume_token(RPAREN);
loopCount += 1;
      switch (jj_nt.kind) {
      case LCURLY:{
        Block();
        break;
        }
      default:
        if (jj_2_36(1)) {
          StatementNoVar();
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
jjtree.closeNodeScope(jjtn000, true);
                                                                                                             jjtc000 = false;
                                                                                                             if (jjtree.nodeCreated()) {
                                                                                                              jjtreeCloseNodeScope(jjtn000);
                                                                                                             }
                                                                                                             jjtn000.jjtSetLastToken(getToken(0));
loopCount -= 1;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof ParseException) {
        throw (ParseException)jjte000;
      }
      if (jjte000 instanceof RuntimeException) {
        throw (RuntimeException)jjte000;
      }
      throw (Error)jjte000;
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        if (jjtree.nodeCreated()) {
         jjtreeCloseNodeScope(jjtn000);
        }
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
}

  final public void DoWhileStatement() throws ParseException {/*@bgen(jjtree) DoWhileStatement */
  ASTDoWhileStatement jjtn000 = new ASTDoWhileStatement(JJTDOWHILESTATEMENT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(DO);
loopCount += 1;
      switch (jj_nt.kind) {
      case LCURLY:{
        Block();
        break;
        }
      default:
        if (jj_2_37(1)) {
          StatementNoVar();
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      jj_consume_token(WHILE);
      jj_consume_token(LPAREN);
      Expression();
      jj_consume_token(RPAREN);
jjtree.closeNodeScope(jjtn000, true);
                                                                                                                jjtc000 = false;
                                                                                                                if (jjtree.nodeCreated()) {
                                                                                                                 jjtreeCloseNodeScope(jjtn000);
                                                                                                                }
                                                                                                                jjtn000.jjtSetLastToken(getToken(0));
loopCount -= 1;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof ParseException) {
        throw (ParseException)jjte000;
      }
      if (jjte000 instanceof RuntimeException) {
        throw (RuntimeException)jjte000;
      }
      throw (Error)jjte000;
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        if (jjtree.nodeCreated()) {
         jjtreeCloseNodeScope(jjtn000);
        }
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
}

  final public void ReturnStatement() throws ParseException {/*@bgen(jjtree) ReturnStatement */
  ASTReturnStatement jjtn000 = new ASTReturnStatement(JJTRETURNSTATEMENT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(RETURN);
      if (jj_2_38(2)) {
        ExpressionStatement();
      } else {
        ;
      }
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof ParseException) {
        throw (ParseException)jjte000;
      }
      if (jjte000 instanceof RuntimeException) {
        throw (RuntimeException)jjte000;
      }
      throw (Error)jjte000;
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        if (jjtree.nodeCreated()) {
         jjtreeCloseNodeScope(jjtn000);
        }
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
}

  final public void ThrowStatement() throws ParseException {/*@bgen(jjtree) ThrowStatement */
  ASTThrowStatement jjtn000 = new ASTThrowStatement(JJTTHROWSTATEMENT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(THROW);
      if (jj_2_39(2)) {
        ExpressionStatement();
      } else {
        ;
      }
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof ParseException) {
        throw (ParseException)jjte000;
      }
      if (jjte000 instanceof RuntimeException) {
        throw (RuntimeException)jjte000;
      }
      throw (Error)jjte000;
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        if (jjtree.nodeCreated()) {
         jjtreeCloseNodeScope(jjtn000);
        }
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
}

  final public void Continue() throws ParseException {/*@bgen(jjtree) Continue */
    ASTContinue jjtn000 = new ASTContinue(JJTCONTINUE);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtreeOpenNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Token t;
    try {
      t = jj_consume_token(CONTINUE);
jjtree.closeNodeScope(jjtn000, true);
                   jjtc000 = false;
                   if (jjtree.nodeCreated()) {
                    jjtreeCloseNodeScope(jjtn000);
                   }
                   jjtn000.jjtSetLastToken(getToken(0));
if (loopCount == 0) { throwParsingException(t); }
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        if (jjtree.nodeCreated()) {
         jjtreeCloseNodeScope(jjtn000);
        }
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
}

  final public void Break() throws ParseException {/*@bgen(jjtree) Break */
    ASTBreak jjtn000 = new ASTBreak(JJTBREAK);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtreeOpenNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Token t;
    try {
      t = jj_consume_token(BREAK);
jjtree.closeNodeScope(jjtn000, true);
                jjtc000 = false;
                if (jjtree.nodeCreated()) {
                 jjtreeCloseNodeScope(jjtn000);
                }
                jjtn000.jjtSetLastToken(getToken(0));
if (loopCount == 0) { throwParsingException(t); }
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        if (jjtree.nodeCreated()) {
         jjtreeCloseNodeScope(jjtn000);
        }
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
}

  final public void ForeachStatement() throws ParseException {/*@bgen(jjtree) ForeachStatement */
 ASTForeachStatement jjtn000 = new ASTForeachStatement(JJTFOREACHSTATEMENT);
 boolean jjtc000 = true;
 jjtree.openNodeScope(jjtn000);
 jjtreeOpenNodeScope(jjtn000);
 jjtn000.jjtSetFirstToken(getToken(1));int loopForm = 0;
    try {
pushUnit(jjtn000);
      jj_consume_token(FOR);
      jj_consume_token(LPAREN);
      if (jj_2_44(3)) {
        InlineVar();
        jj_consume_token(COLON);
        Expression();
loopForm = 0;
      } else if (jj_2_45(1)) {
        if (jj_2_41(1)) {
          switch (jj_nt.kind) {
          case VAR:
          case LET:
          case CONST:{
            Var();
            break;
            }
          default:
            if (jj_2_40(1)) {
              Expression();
            } else {
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
loopForm = 1;
        } else {
          ;
        }
        jj_consume_token(SEMICOL);
        if (jj_2_42(1)) {
          Expression();
loopForm |= 2;
        } else {
          ;
        }
        jj_consume_token(SEMICOL);
        if (jj_2_43(1)) {
          Expression();
loopForm |= 4;
        } else {
          ;
        }
loopForm |= 8;
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(RPAREN);
loopCount += 1;
      switch (jj_nt.kind) {
      case LCURLY:{
        Block();
        break;
        }
      default:
        if (jj_2_46(1)) {
          StatementNoVar();
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      if (jjtree.nodeCreated()) {
       jjtreeCloseNodeScope(jjtn000);
      }
      jjtn000.jjtSetLastToken(getToken(0));
loopCount -= 1;
        jjtn000.setLoopForm(loopForm);
        popUnit(jjtn000);
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof ParseException) {
        throw (ParseException)jjte000;
      }
      if (jjte000 instanceof RuntimeException) {
        throw (RuntimeException)jjte000;
      }
      throw (Error)jjte000;
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        if (jjtree.nodeCreated()) {
         jjtreeCloseNodeScope(jjtn000);
        }
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
}

  final public void InlineVar() throws ParseException {/*@bgen(jjtree) Reference */
  ASTReference jjtn000 = new ASTReference(JJTREFERENCE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      switch (jj_nt.kind) {
      case VAR:{
        jj_consume_token(VAR);
        DeclareVar(false, false);
        break;
        }
      case LET:{
        jj_consume_token(LET);
        DeclareVar(true, false);
        break;
        }
      case CONST:{
        jj_consume_token(CONST);
        DeclareVar(true, true);
        break;
        }
      case IDENTIFIER:
      case REGISTER:{
        Identifier(true);
        break;
        }
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof ParseException) {
        throw (ParseException)jjte000;
      }
      if (jjte000 instanceof RuntimeException) {
        throw (RuntimeException)jjte000;
      }
      throw (Error)jjte000;
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        if (jjtree.nodeCreated()) {
         jjtreeCloseNodeScope(jjtn000);
        }
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
}

  final public void Var() throws ParseException {
    switch (jj_nt.kind) {
    case VAR:{
ASTDefineVars jjtn001 = new ASTDefineVars(JJTDEFINEVARS);
      boolean jjtc001 = true;
      jjtree.openNodeScope(jjtn001);
      jjtreeOpenNodeScope(jjtn001);
      jjtn001.jjtSetFirstToken(getToken(1));
      try {
        jj_consume_token(VAR);
        DefineVar();
        label_8:
        while (true) {
          switch (jj_nt.kind) {
          case COMMA:{
            break;
            }
          default:
            break label_8;
          }
          jj_consume_token(COMMA);
          DefineVar();
        }
      } catch (Throwable jjte001) {
if (jjtc001) {
        jjtree.clearNodeScope(jjtn001);
        jjtc001 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte001 instanceof ParseException) {
        throw (ParseException)jjte001;
      }
      if (jjte001 instanceof RuntimeException) {
        throw (RuntimeException)jjte001;
      }
      throw (Error)jjte001;
      } finally {
if (jjtc001) {
        jjtree.closeNodeScope(jjtn001, jjtree.nodeArity() >  1);
        if (jjtree.nodeCreated()) {
         jjtreeCloseNodeScope(jjtn001);
        }
        jjtn001.jjtSetLastToken(getToken(0));
      }
      }
      break;
      }
    case LET:{
ASTDefineVars jjtn002 = new ASTDefineVars(JJTDEFINEVARS);
      boolean jjtc002 = true;
      jjtree.openNodeScope(jjtn002);
      jjtreeOpenNodeScope(jjtn002);
      jjtn002.jjtSetFirstToken(getToken(1));
      try {
        jj_consume_token(LET);
        DefineLet();
        label_9:
        while (true) {
          switch (jj_nt.kind) {
          case COMMA:{
            break;
            }
          default:
            break label_9;
          }
          jj_consume_token(COMMA);
          DefineLet();
        }
      } catch (Throwable jjte002) {
if (jjtc002) {
        jjtree.clearNodeScope(jjtn002);
        jjtc002 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte002 instanceof ParseException) {
        throw (ParseException)jjte002;
      }
      if (jjte002 instanceof RuntimeException) {
        throw (RuntimeException)jjte002;
      }
      throw (Error)jjte002;
      } finally {
if (jjtc002) {
        jjtree.closeNodeScope(jjtn002, jjtree.nodeArity() >  1);
        if (jjtree.nodeCreated()) {
         jjtreeCloseNodeScope(jjtn002);
        }
        jjtn002.jjtSetLastToken(getToken(0));
      }
      }
      break;
      }
    case CONST:{
ASTDefineVars jjtn003 = new ASTDefineVars(JJTDEFINEVARS);
      boolean jjtc003 = true;
      jjtree.openNodeScope(jjtn003);
      jjtreeOpenNodeScope(jjtn003);
      jjtn003.jjtSetFirstToken(getToken(1));
      try {
        jj_consume_token(CONST);
        DefineConst();
        label_10:
        while (true) {
          switch (jj_nt.kind) {
          case COMMA:{
            break;
            }
          default:
            break label_10;
          }
          jj_consume_token(COMMA);
          DefineConst();
        }
      } catch (Throwable jjte003) {
if (jjtc003) {
        jjtree.clearNodeScope(jjtn003);
        jjtc003 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte003 instanceof ParseException) {
        throw (ParseException)jjte003;
      }
      if (jjte003 instanceof RuntimeException) {
        throw (RuntimeException)jjte003;
      }
      throw (Error)jjte003;
      } finally {
if (jjtc003) {
        jjtree.closeNodeScope(jjtn003, jjtree.nodeArity() >  1);
        if (jjtree.nodeCreated()) {
         jjtreeCloseNodeScope(jjtn003);
        }
        jjtn003.jjtSetLastToken(getToken(0));
      }
      }
      break;
      }
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public void DefineVar() throws ParseException {
    DeclareVar(false, false);
    switch (jj_nt.kind) {
    case assign:{
      jj_consume_token(assign);
ASTAssignment jjtn001 = new ASTAssignment(JJTASSIGNMENT);
                                                      boolean jjtc001 = true;
                                                      jjtree.openNodeScope(jjtn001);
                                                      jjtreeOpenNodeScope(jjtn001);
                                                      jjtn001.jjtSetFirstToken(getToken(1));
      try {
        Expression();
      } catch (Throwable jjte001) {
if (jjtc001) {
                                                        jjtree.clearNodeScope(jjtn001);
                                                        jjtc001 = false;
                                                      } else {
                                                        jjtree.popNode();
                                                      }
                                                      if (jjte001 instanceof ParseException) {
                                                        throw (ParseException)jjte001;
                                                      }
                                                      if (jjte001 instanceof RuntimeException) {
                                                        throw (RuntimeException)jjte001;
                                                      }
                                                      throw (Error)jjte001;
      } finally {
if (jjtc001) {
                                                        jjtree.closeNodeScope(jjtn001,  2);
                                                        if (jjtree.nodeCreated()) {
                                                         jjtreeCloseNodeScope(jjtn001);
                                                        }
                                                        jjtn001.jjtSetLastToken(getToken(0));
                                                      }
      }
      break;
      }
    default:
      ;
    }
}

  final public void DefineLet() throws ParseException {
    DeclareVar(true, false);
    switch (jj_nt.kind) {
    case assign:{
      jj_consume_token(assign);
ASTAssignment jjtn001 = new ASTAssignment(JJTASSIGNMENT);
                                                     boolean jjtc001 = true;
                                                     jjtree.openNodeScope(jjtn001);
                                                     jjtreeOpenNodeScope(jjtn001);
                                                     jjtn001.jjtSetFirstToken(getToken(1));
      try {
        Expression();
      } catch (Throwable jjte001) {
if (jjtc001) {
                                                       jjtree.clearNodeScope(jjtn001);
                                                       jjtc001 = false;
                                                     } else {
                                                       jjtree.popNode();
                                                     }
                                                     if (jjte001 instanceof ParseException) {
                                                       throw (ParseException)jjte001;
                                                     }
                                                     if (jjte001 instanceof RuntimeException) {
                                                       throw (RuntimeException)jjte001;
                                                     }
                                                     throw (Error)jjte001;
      } finally {
if (jjtc001) {
                                                       jjtree.closeNodeScope(jjtn001,  2);
                                                       if (jjtree.nodeCreated()) {
                                                        jjtreeCloseNodeScope(jjtn001);
                                                       }
                                                       jjtn001.jjtSetLastToken(getToken(0));
                                                     }
      }
      break;
      }
    default:
      ;
    }
}

  final public void DefineConst() throws ParseException {
    DeclareVar(true, true);
    jj_consume_token(assign);
ASTAssignment jjtn001 = new ASTAssignment(JJTASSIGNMENT);
                                      boolean jjtc001 = true;
                                      jjtree.openNodeScope(jjtn001);
                                      jjtreeOpenNodeScope(jjtn001);
                                      jjtn001.jjtSetFirstToken(getToken(1));
    try {
      Expression();
    } catch (Throwable jjte001) {
if (jjtc001) {
                                        jjtree.clearNodeScope(jjtn001);
                                        jjtc001 = false;
                                      } else {
                                        jjtree.popNode();
                                      }
                                      if (jjte001 instanceof ParseException) {
                                        throw (ParseException)jjte001;
                                      }
                                      if (jjte001 instanceof RuntimeException) {
                                        throw (RuntimeException)jjte001;
                                      }
                                      throw (Error)jjte001;
    } finally {
if (jjtc001) {
                                        jjtree.closeNodeScope(jjtn001,  2);
                                        if (jjtree.nodeCreated()) {
                                         jjtreeCloseNodeScope(jjtn001);
                                        }
                                        jjtn001.jjtSetLastToken(getToken(0));
                                      }
    }
}

  final public void DeclareVar(boolean lexical, boolean constant) throws ParseException {/*@bgen(jjtree) Var */
    ASTVar jjtn000 = new ASTVar(JJTVAR);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtreeOpenNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Token t;
    try {
      t = jj_consume_token(IDENTIFIER);
jjtree.closeNodeScope(jjtn000, true);
                     jjtc000 = false;
                     if (jjtree.nodeCreated()) {
                      jjtreeCloseNodeScope(jjtn000);
                     }
                     jjtn000.jjtSetLastToken(getToken(0));
declareVariable(jjtn000, t, lexical, constant);
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        if (jjtree.nodeCreated()) {
         jjtreeCloseNodeScope(jjtn000);
        }
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
}

  final public void DeclareFunction() throws ParseException {/*@bgen(jjtree) Var */
    ASTVar jjtn000 = new ASTVar(JJTVAR);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtreeOpenNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Token t;
    try {
      t = jj_consume_token(IDENTIFIER);
jjtree.closeNodeScope(jjtn000, true);
                     jjtc000 = false;
                     if (jjtree.nodeCreated()) {
                      jjtreeCloseNodeScope(jjtn000);
                     }
                     jjtn000.jjtSetLastToken(getToken(0));
declareFunction(jjtn000, t);
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        if (jjtree.nodeCreated()) {
         jjtreeCloseNodeScope(jjtn000);
        }
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
}

  final public void Pragma() throws ParseException {LinkedList<String> lstr = new LinkedList<String>();
    Object value;
    jj_consume_token(PRAGMA);
    pragmaKey(lstr);
    value = pragmaValue();
declarePragma(stringify(lstr), value);
}

  final public void pragmaKey(List<String> lstr) throws ParseException {Token t;
    switch (jj_nt.kind) {
    case IDENTIFIER:{
      t = jj_consume_token(IDENTIFIER);
lstr.add(t.image);
      label_11:
      while (true) {
        if (jj_2_47(2147483647)) {
        } else {
          break label_11;
        }
        pragmaKey(lstr);
      }
      break;
      }
    case DOT:{
      jj_consume_token(DOT);
      t = jj_consume_token(DOT_IDENTIFIER);
lstr.add(t.image);
      break;
      }
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public Object pragmaValue() throws ParseException {Token s = null;
Token v;
LinkedList<String> lstr = new LinkedList<String>();
Object result;
    if (jj_2_48(2)) {
      switch (jj_nt.kind) {
      case plus:
      case minus:{
        switch (jj_nt.kind) {
        case plus:{
          s = jj_consume_token(plus);
          break;
          }
        case minus:{
          s = jj_consume_token(minus);
          break;
          }
        default:
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        ;
      }
      v = jj_consume_token(INTEGER_LITERAL);
result = NumberParser.parseInteger(s, v);
    } else if (jj_2_49(2)) {
      switch (jj_nt.kind) {
      case plus:
      case minus:{
        switch (jj_nt.kind) {
        case plus:{
          s = jj_consume_token(plus);
          break;
          }
        case minus:{
          s = jj_consume_token(minus);
          break;
          }
        default:
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        ;
      }
      v = jj_consume_token(FLOAT_LITERAL);
result = NumberParser.parseDouble(s, v);
    } else {
      switch (jj_nt.kind) {
      case STRING_LITERAL:{
        v = jj_consume_token(STRING_LITERAL);
result = Parser.buildString(v.image, true);
        break;
        }
      case DOT:
      case IDENTIFIER:{
        pragmaKey(lstr);
result = stringify(lstr);
        break;
        }
      case TRUE:{
        jj_consume_token(TRUE);
result = true;
        break;
        }
      case FALSE:{
        jj_consume_token(FALSE);
result = false;
        break;
        }
      case NULL:{
        jj_consume_token(NULL);
result = null;
        break;
        }
      case NAN_LITERAL:{
        jj_consume_token(NAN_LITERAL);
result = Double.NaN;
        break;
        }
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return result;}
    throw new IllegalStateException ("Missing return statement in function");
}

/***************************************
 *      Expression syntax
 ***************************************/
  final public 
void Expression() throws ParseException {
    AssignmentExpression();
}

  final public void AssignmentExpression() throws ParseException {
    ConditionalExpression();
    if (jj_2_50(2)) {
      switch (jj_nt.kind) {
      case plus_assign:{
        jj_consume_token(plus_assign);
ASTSetAddNode jjtn001 = new ASTSetAddNode(JJTSETADDNODE);
                     boolean jjtc001 = true;
                     jjtree.openNodeScope(jjtn001);
                     jjtreeOpenNodeScope(jjtn001);
                     jjtn001.jjtSetFirstToken(getToken(1));
        try {
          Expression();
        } catch (Throwable jjte001) {
if (jjtc001) {
                       jjtree.clearNodeScope(jjtn001);
                       jjtc001 = false;
                     } else {
                       jjtree.popNode();
                     }
                     if (jjte001 instanceof ParseException) {
                       throw (ParseException)jjte001;
                     }
                     if (jjte001 instanceof RuntimeException) {
                       throw (RuntimeException)jjte001;
                     }
                     throw (Error)jjte001;
        } finally {
if (jjtc001) {
                       jjtree.closeNodeScope(jjtn001,  2);
                       if (jjtree.nodeCreated()) {
                        jjtreeCloseNodeScope(jjtn001);
                       }
                       jjtn001.jjtSetLastToken(getToken(0));
                     }
        }
        break;
        }
      case mult_assign:{
        jj_consume_token(mult_assign);
ASTSetMultNode jjtn002 = new ASTSetMultNode(JJTSETMULTNODE);
                     boolean jjtc002 = true;
                     jjtree.openNodeScope(jjtn002);
                     jjtreeOpenNodeScope(jjtn002);
                     jjtn002.jjtSetFirstToken(getToken(1));
        try {
          Expression();
        } catch (Throwable jjte002) {
if (jjtc002) {
                       jjtree.clearNodeScope(jjtn002);
                       jjtc002 = false;
                     } else {
                       jjtree.popNode();
                     }
                     if (jjte002 instanceof ParseException) {
                       throw (ParseException)jjte002;
                     }
                     if (jjte002 instanceof RuntimeException) {
                       throw (RuntimeException)jjte002;
                     }
                     throw (Error)jjte002;
        } finally {
if (jjtc002) {
                       jjtree.closeNodeScope(jjtn002,  2);
                       if (jjtree.nodeCreated()) {
                        jjtreeCloseNodeScope(jjtn002);
                       }
                       jjtn002.jjtSetLastToken(getToken(0));
                     }
        }
        break;
        }
      case div_assign:{
        jj_consume_token(div_assign);
ASTSetDivNode jjtn003 = new ASTSetDivNode(JJTSETDIVNODE);
                    boolean jjtc003 = true;
                    jjtree.openNodeScope(jjtn003);
                    jjtreeOpenNodeScope(jjtn003);
                    jjtn003.jjtSetFirstToken(getToken(1));
        try {
          Expression();
        } catch (Throwable jjte003) {
if (jjtc003) {
                      jjtree.clearNodeScope(jjtn003);
                      jjtc003 = false;
                    } else {
                      jjtree.popNode();
                    }
                    if (jjte003 instanceof ParseException) {
                      throw (ParseException)jjte003;
                    }
                    if (jjte003 instanceof RuntimeException) {
                      throw (RuntimeException)jjte003;
                    }
                    throw (Error)jjte003;
        } finally {
if (jjtc003) {
                      jjtree.closeNodeScope(jjtn003,  2);
                      if (jjtree.nodeCreated()) {
                       jjtreeCloseNodeScope(jjtn003);
                      }
                      jjtn003.jjtSetLastToken(getToken(0));
                    }
        }
        break;
        }
      case mod_assign:{
        jj_consume_token(mod_assign);
ASTSetModNode jjtn004 = new ASTSetModNode(JJTSETMODNODE);
                    boolean jjtc004 = true;
                    jjtree.openNodeScope(jjtn004);
                    jjtreeOpenNodeScope(jjtn004);
                    jjtn004.jjtSetFirstToken(getToken(1));
        try {
          Expression();
        } catch (Throwable jjte004) {
if (jjtc004) {
                      jjtree.clearNodeScope(jjtn004);
                      jjtc004 = false;
                    } else {
                      jjtree.popNode();
                    }
                    if (jjte004 instanceof ParseException) {
                      throw (ParseException)jjte004;
                    }
                    if (jjte004 instanceof RuntimeException) {
                      throw (RuntimeException)jjte004;
                    }
                    throw (Error)jjte004;
        } finally {
if (jjtc004) {
                      jjtree.closeNodeScope(jjtn004,  2);
                      if (jjtree.nodeCreated()) {
                       jjtreeCloseNodeScope(jjtn004);
                      }
                      jjtn004.jjtSetLastToken(getToken(0));
                    }
        }
        break;
        }
      case and_assign:{
        jj_consume_token(and_assign);
ASTSetAndNode jjtn005 = new ASTSetAndNode(JJTSETANDNODE);
                    boolean jjtc005 = true;
                    jjtree.openNodeScope(jjtn005);
                    jjtreeOpenNodeScope(jjtn005);
                    jjtn005.jjtSetFirstToken(getToken(1));
        try {
          Expression();
        } catch (Throwable jjte005) {
if (jjtc005) {
                      jjtree.clearNodeScope(jjtn005);
                      jjtc005 = false;
                    } else {
                      jjtree.popNode();
                    }
                    if (jjte005 instanceof ParseException) {
                      throw (ParseException)jjte005;
                    }
                    if (jjte005 instanceof RuntimeException) {
                      throw (RuntimeException)jjte005;
                    }
                    throw (Error)jjte005;
        } finally {
if (jjtc005) {
                      jjtree.closeNodeScope(jjtn005,  2);
                      if (jjtree.nodeCreated()) {
                       jjtreeCloseNodeScope(jjtn005);
                      }
                      jjtn005.jjtSetLastToken(getToken(0));
                    }
        }
        break;
        }
      case or_assign:{
        jj_consume_token(or_assign);
ASTSetOrNode jjtn006 = new ASTSetOrNode(JJTSETORNODE);
                   boolean jjtc006 = true;
                   jjtree.openNodeScope(jjtn006);
                   jjtreeOpenNodeScope(jjtn006);
                   jjtn006.jjtSetFirstToken(getToken(1));
        try {
          Expression();
        } catch (Throwable jjte006) {
if (jjtc006) {
                     jjtree.clearNodeScope(jjtn006);
                     jjtc006 = false;
                   } else {
                     jjtree.popNode();
                   }
                   if (jjte006 instanceof ParseException) {
                     throw (ParseException)jjte006;
                   }
                   if (jjte006 instanceof RuntimeException) {
                     throw (RuntimeException)jjte006;
                   }
                   throw (Error)jjte006;
        } finally {
if (jjtc006) {
                     jjtree.closeNodeScope(jjtn006,  2);
                     if (jjtree.nodeCreated()) {
                      jjtreeCloseNodeScope(jjtn006);
                     }
                     jjtn006.jjtSetLastToken(getToken(0));
                   }
        }
        break;
        }
      case xor_assign:{
        jj_consume_token(xor_assign);
ASTSetXorNode jjtn007 = new ASTSetXorNode(JJTSETXORNODE);
                   boolean jjtc007 = true;
                   jjtree.openNodeScope(jjtn007);
                   jjtreeOpenNodeScope(jjtn007);
                   jjtn007.jjtSetFirstToken(getToken(1));
        try {
          Expression();
        } catch (Throwable jjte007) {
if (jjtc007) {
                     jjtree.clearNodeScope(jjtn007);
                     jjtc007 = false;
                   } else {
                     jjtree.popNode();
                   }
                   if (jjte007 instanceof ParseException) {
                     throw (ParseException)jjte007;
                   }
                   if (jjte007 instanceof RuntimeException) {
                     throw (RuntimeException)jjte007;
                   }
                   throw (Error)jjte007;
        } finally {
if (jjtc007) {
                     jjtree.closeNodeScope(jjtn007,  2);
                     if (jjtree.nodeCreated()) {
                      jjtreeCloseNodeScope(jjtn007);
                     }
                     jjtn007.jjtSetLastToken(getToken(0));
                   }
        }
        break;
        }
      case minus_assign:{
        jj_consume_token(minus_assign);
ASTSetSubNode jjtn008 = new ASTSetSubNode(JJTSETSUBNODE);
                      boolean jjtc008 = true;
                      jjtree.openNodeScope(jjtn008);
                      jjtreeOpenNodeScope(jjtn008);
                      jjtn008.jjtSetFirstToken(getToken(1));
        try {
          Expression();
        } catch (Throwable jjte008) {
if (jjtc008) {
                        jjtree.clearNodeScope(jjtn008);
                        jjtc008 = false;
                      } else {
                        jjtree.popNode();
                      }
                      if (jjte008 instanceof ParseException) {
                        throw (ParseException)jjte008;
                      }
                      if (jjte008 instanceof RuntimeException) {
                        throw (RuntimeException)jjte008;
                      }
                      throw (Error)jjte008;
        } finally {
if (jjtc008) {
                        jjtree.closeNodeScope(jjtn008,  2);
                        if (jjtree.nodeCreated()) {
                         jjtreeCloseNodeScope(jjtn008);
                        }
                        jjtn008.jjtSetLastToken(getToken(0));
                      }
        }
        break;
        }
      case lshift_assign:{
        jj_consume_token(lshift_assign);
ASTSetShiftLeftNode jjtn009 = new ASTSetShiftLeftNode(JJTSETSHIFTLEFTNODE);
                       boolean jjtc009 = true;
                       jjtree.openNodeScope(jjtn009);
                       jjtreeOpenNodeScope(jjtn009);
                       jjtn009.jjtSetFirstToken(getToken(1));
        try {
          Expression();
        } catch (Throwable jjte009) {
if (jjtc009) {
                         jjtree.clearNodeScope(jjtn009);
                         jjtc009 = false;
                       } else {
                         jjtree.popNode();
                       }
                       if (jjte009 instanceof ParseException) {
                         throw (ParseException)jjte009;
                       }
                       if (jjte009 instanceof RuntimeException) {
                         throw (RuntimeException)jjte009;
                       }
                       throw (Error)jjte009;
        } finally {
if (jjtc009) {
                         jjtree.closeNodeScope(jjtn009,  2);
                         if (jjtree.nodeCreated()) {
                          jjtreeCloseNodeScope(jjtn009);
                         }
                         jjtn009.jjtSetLastToken(getToken(0));
                       }
        }
        break;
        }
      case rshift_assign:{
        jj_consume_token(rshift_assign);
ASTSetShiftRightNode jjtn010 = new ASTSetShiftRightNode(JJTSETSHIFTRIGHTNODE);
                       boolean jjtc010 = true;
                       jjtree.openNodeScope(jjtn010);
                       jjtreeOpenNodeScope(jjtn010);
                       jjtn010.jjtSetFirstToken(getToken(1));
        try {
          Expression();
        } catch (Throwable jjte010) {
if (jjtc010) {
                         jjtree.clearNodeScope(jjtn010);
                         jjtc010 = false;
                       } else {
                         jjtree.popNode();
                       }
                       if (jjte010 instanceof ParseException) {
                         throw (ParseException)jjte010;
                       }
                       if (jjte010 instanceof RuntimeException) {
                         throw (RuntimeException)jjte010;
                       }
                       throw (Error)jjte010;
        } finally {
if (jjtc010) {
                         jjtree.closeNodeScope(jjtn010,  2);
                         if (jjtree.nodeCreated()) {
                          jjtreeCloseNodeScope(jjtn010);
                         }
                         jjtn010.jjtSetLastToken(getToken(0));
                       }
        }
        break;
        }
      case rshiftu_assign:{
        jj_consume_token(rshiftu_assign);
ASTSetShiftRightUnsignedNode jjtn011 = new ASTSetShiftRightUnsignedNode(JJTSETSHIFTRIGHTUNSIGNEDNODE);
                        boolean jjtc011 = true;
                        jjtree.openNodeScope(jjtn011);
                        jjtreeOpenNodeScope(jjtn011);
                        jjtn011.jjtSetFirstToken(getToken(1));
        try {
          Expression();
        } catch (Throwable jjte011) {
if (jjtc011) {
                          jjtree.clearNodeScope(jjtn011);
                          jjtc011 = false;
                        } else {
                          jjtree.popNode();
                        }
                        if (jjte011 instanceof ParseException) {
                          throw (ParseException)jjte011;
                        }
                        if (jjte011 instanceof RuntimeException) {
                          throw (RuntimeException)jjte011;
                        }
                        throw (Error)jjte011;
        } finally {
if (jjtc011) {
                          jjtree.closeNodeScope(jjtn011,  2);
                          if (jjtree.nodeCreated()) {
                           jjtreeCloseNodeScope(jjtn011);
                          }
                          jjtn011.jjtSetLastToken(getToken(0));
                        }
        }
        break;
        }
      case assign:{
        jj_consume_token(assign);
ASTAssignment jjtn012 = new ASTAssignment(JJTASSIGNMENT);
               boolean jjtc012 = true;
               jjtree.openNodeScope(jjtn012);
               jjtreeOpenNodeScope(jjtn012);
               jjtn012.jjtSetFirstToken(getToken(1));
        try {
          Expression();
        } catch (Throwable jjte012) {
if (jjtc012) {
                 jjtree.clearNodeScope(jjtn012);
                 jjtc012 = false;
               } else {
                 jjtree.popNode();
               }
               if (jjte012 instanceof ParseException) {
                 throw (ParseException)jjte012;
               }
               if (jjte012 instanceof RuntimeException) {
                 throw (RuntimeException)jjte012;
               }
               throw (Error)jjte012;
        } finally {
if (jjtc012) {
                 jjtree.closeNodeScope(jjtn012,  2);
                 if (jjtree.nodeCreated()) {
                  jjtreeCloseNodeScope(jjtn012);
                 }
                 jjtn012.jjtSetLastToken(getToken(0));
               }
        }
        break;
        }
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else {
      ;
    }
}

/***************************************
 *      Conditional & relational
 ***************************************/
  final public 
void ConditionalExpression() throws ParseException {
    ConditionalOrExpression();
    if (jj_2_51(2)) {
      switch (jj_nt.kind) {
      case QMARK:{
        jj_consume_token(QMARK);
        Expression();
        jj_consume_token(COLON);
ASTTernaryNode jjtn001 = new ASTTernaryNode(JJTTERNARYNODE);
                                   boolean jjtc001 = true;
                                   jjtree.openNodeScope(jjtn001);
                                   jjtreeOpenNodeScope(jjtn001);
                                   jjtn001.jjtSetFirstToken(getToken(1));
        try {
          Expression();
        } catch (Throwable jjte001) {
if (jjtc001) {
                                     jjtree.clearNodeScope(jjtn001);
                                     jjtc001 = false;
                                   } else {
                                     jjtree.popNode();
                                   }
                                   if (jjte001 instanceof ParseException) {
                                     throw (ParseException)jjte001;
                                   }
                                   if (jjte001 instanceof RuntimeException) {
                                     throw (RuntimeException)jjte001;
                                   }
                                   throw (Error)jjte001;
        } finally {
if (jjtc001) {
                                     jjtree.closeNodeScope(jjtn001,  3);
                                     if (jjtree.nodeCreated()) {
                                      jjtreeCloseNodeScope(jjtn001);
                                     }
                                     jjtn001.jjtSetLastToken(getToken(0));
                                   }
        }
        break;
        }
      case ELVIS:{
        jj_consume_token(ELVIS);
ASTTernaryNode jjtn002 = new ASTTernaryNode(JJTTERNARYNODE);
              boolean jjtc002 = true;
              jjtree.openNodeScope(jjtn002);
              jjtreeOpenNodeScope(jjtn002);
              jjtn002.jjtSetFirstToken(getToken(1));
        try {
          Expression();
        } catch (Throwable jjte002) {
if (jjtc002) {
                jjtree.clearNodeScope(jjtn002);
                jjtc002 = false;
              } else {
                jjtree.popNode();
              }
              if (jjte002 instanceof ParseException) {
                throw (ParseException)jjte002;
              }
              if (jjte002 instanceof RuntimeException) {
                throw (RuntimeException)jjte002;
              }
              throw (Error)jjte002;
        } finally {
if (jjtc002) {
                jjtree.closeNodeScope(jjtn002,  2);
                if (jjtree.nodeCreated()) {
                 jjtreeCloseNodeScope(jjtn002);
                }
                jjtn002.jjtSetLastToken(getToken(0));
              }
        }
        break;
        }
      case NULLP:{
        jj_consume_token(NULLP);
ASTNullpNode jjtn003 = new ASTNullpNode(JJTNULLPNODE);
              boolean jjtc003 = true;
              jjtree.openNodeScope(jjtn003);
              jjtreeOpenNodeScope(jjtn003);
              jjtn003.jjtSetFirstToken(getToken(1));
        try {
          Expression();
        } catch (Throwable jjte003) {
if (jjtc003) {
                jjtree.clearNodeScope(jjtn003);
                jjtc003 = false;
              } else {
                jjtree.popNode();
              }
              if (jjte003 instanceof ParseException) {
                throw (ParseException)jjte003;
              }
              if (jjte003 instanceof RuntimeException) {
                throw (RuntimeException)jjte003;
              }
              throw (Error)jjte003;
        } finally {
if (jjtc003) {
                jjtree.closeNodeScope(jjtn003,  2);
                if (jjtree.nodeCreated()) {
                 jjtreeCloseNodeScope(jjtn003);
                }
                jjtn003.jjtSetLastToken(getToken(0));
              }
        }
        break;
        }
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else {
      ;
    }
}

  final public void ConditionalOrExpression() throws ParseException {
    ConditionalAndExpression();
    label_12:
    while (true) {
      if (jj_2_52(2)) {
      } else {
        break label_12;
      }
      switch (jj_nt.kind) {
      case OR:{
        jj_consume_token(OR);
        break;
        }
      case _OR:{
        jj_consume_token(_OR);
        break;
        }
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
ASTOrNode jjtn001 = new ASTOrNode(JJTORNODE);
                                  boolean jjtc001 = true;
                                  jjtree.openNodeScope(jjtn001);
                                  jjtreeOpenNodeScope(jjtn001);
                                  jjtn001.jjtSetFirstToken(getToken(1));
      try {
        ConditionalAndExpression();
      } catch (Throwable jjte001) {
if (jjtc001) {
                                    jjtree.clearNodeScope(jjtn001);
                                    jjtc001 = false;
                                  } else {
                                    jjtree.popNode();
                                  }
                                  if (jjte001 instanceof ParseException) {
                                    throw (ParseException)jjte001;
                                  }
                                  if (jjte001 instanceof RuntimeException) {
                                    throw (RuntimeException)jjte001;
                                  }
                                  throw (Error)jjte001;
      } finally {
if (jjtc001) {
                                    jjtree.closeNodeScope(jjtn001,  2);
                                    if (jjtree.nodeCreated()) {
                                     jjtreeCloseNodeScope(jjtn001);
                                    }
                                    jjtn001.jjtSetLastToken(getToken(0));
                                  }
      }
    }
}

  final public void ConditionalAndExpression() throws ParseException {
    InclusiveOrExpression();
    label_13:
    while (true) {
      if (jj_2_53(2)) {
      } else {
        break label_13;
      }
      switch (jj_nt.kind) {
      case AND:{
        jj_consume_token(AND);
        break;
        }
      case _AND:{
        jj_consume_token(_AND);
        break;
        }
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
ASTAndNode jjtn001 = new ASTAndNode(JJTANDNODE);
                                    boolean jjtc001 = true;
                                    jjtree.openNodeScope(jjtn001);
                                    jjtreeOpenNodeScope(jjtn001);
                                    jjtn001.jjtSetFirstToken(getToken(1));
      try {
        InclusiveOrExpression();
      } catch (Throwable jjte001) {
if (jjtc001) {
                                      jjtree.clearNodeScope(jjtn001);
                                      jjtc001 = false;
                                    } else {
                                      jjtree.popNode();
                                    }
                                    if (jjte001 instanceof ParseException) {
                                      throw (ParseException)jjte001;
                                    }
                                    if (jjte001 instanceof RuntimeException) {
                                      throw (RuntimeException)jjte001;
                                    }
                                    throw (Error)jjte001;
      } finally {
if (jjtc001) {
                                      jjtree.closeNodeScope(jjtn001,  2);
                                      if (jjtree.nodeCreated()) {
                                       jjtreeCloseNodeScope(jjtn001);
                                      }
                                      jjtn001.jjtSetLastToken(getToken(0));
                                    }
      }
    }
}

  final public void InclusiveOrExpression() throws ParseException {
    ExclusiveOrExpression();
    label_14:
    while (true) {
      if (jj_2_54(2)) {
      } else {
        break label_14;
      }
      jj_consume_token(or);
ASTBitwiseOrNode jjtn001 = new ASTBitwiseOrNode(JJTBITWISEORNODE);
                          boolean jjtc001 = true;
                          jjtree.openNodeScope(jjtn001);
                          jjtreeOpenNodeScope(jjtn001);
                          jjtn001.jjtSetFirstToken(getToken(1));
      try {
        ExclusiveOrExpression();
      } catch (Throwable jjte001) {
if (jjtc001) {
                            jjtree.clearNodeScope(jjtn001);
                            jjtc001 = false;
                          } else {
                            jjtree.popNode();
                          }
                          if (jjte001 instanceof ParseException) {
                            throw (ParseException)jjte001;
                          }
                          if (jjte001 instanceof RuntimeException) {
                            throw (RuntimeException)jjte001;
                          }
                          throw (Error)jjte001;
      } finally {
if (jjtc001) {
                            jjtree.closeNodeScope(jjtn001,  2);
                            if (jjtree.nodeCreated()) {
                             jjtreeCloseNodeScope(jjtn001);
                            }
                            jjtn001.jjtSetLastToken(getToken(0));
                          }
      }
    }
}

  final public void ExclusiveOrExpression() throws ParseException {
    AndExpression();
    label_15:
    while (true) {
      if (jj_2_55(2)) {
      } else {
        break label_15;
      }
      jj_consume_token(xor);
ASTBitwiseXorNode jjtn001 = new ASTBitwiseXorNode(JJTBITWISEXORNODE);
                           boolean jjtc001 = true;
                           jjtree.openNodeScope(jjtn001);
                           jjtreeOpenNodeScope(jjtn001);
                           jjtn001.jjtSetFirstToken(getToken(1));
      try {
        AndExpression();
      } catch (Throwable jjte001) {
if (jjtc001) {
                             jjtree.clearNodeScope(jjtn001);
                             jjtc001 = false;
                           } else {
                             jjtree.popNode();
                           }
                           if (jjte001 instanceof ParseException) {
                             throw (ParseException)jjte001;
                           }
                           if (jjte001 instanceof RuntimeException) {
                             throw (RuntimeException)jjte001;
                           }
                           throw (Error)jjte001;
      } finally {
if (jjtc001) {
                             jjtree.closeNodeScope(jjtn001,  2);
                             if (jjtree.nodeCreated()) {
                              jjtreeCloseNodeScope(jjtn001);
                             }
                             jjtn001.jjtSetLastToken(getToken(0));
                           }
      }
    }
}

  final public void AndExpression() throws ParseException {
    EqualityExpression();
    label_16:
    while (true) {
      if (jj_2_56(2)) {
      } else {
        break label_16;
      }
      jj_consume_token(and);
ASTBitwiseAndNode jjtn001 = new ASTBitwiseAndNode(JJTBITWISEANDNODE);
                          boolean jjtc001 = true;
                          jjtree.openNodeScope(jjtn001);
                          jjtreeOpenNodeScope(jjtn001);
                          jjtn001.jjtSetFirstToken(getToken(1));
      try {
        EqualityExpression();
      } catch (Throwable jjte001) {
if (jjtc001) {
                            jjtree.clearNodeScope(jjtn001);
                            jjtc001 = false;
                          } else {
                            jjtree.popNode();
                          }
                          if (jjte001 instanceof ParseException) {
                            throw (ParseException)jjte001;
                          }
                          if (jjte001 instanceof RuntimeException) {
                            throw (RuntimeException)jjte001;
                          }
                          throw (Error)jjte001;
      } finally {
if (jjtc001) {
                            jjtree.closeNodeScope(jjtn001,  2);
                            if (jjtree.nodeCreated()) {
                             jjtreeCloseNodeScope(jjtn001);
                            }
                            jjtn001.jjtSetLastToken(getToken(0));
                          }
      }
    }
}

  final public void EqualityExpression() throws ParseException {
    RelationalExpression();
    if (jj_2_57(2)) {
      switch (jj_nt.kind) {
      case eq:
      case EQ:{
        switch (jj_nt.kind) {
        case eq:{
          jj_consume_token(eq);
          break;
          }
        case EQ:{
          jj_consume_token(EQ);
          break;
          }
        default:
          jj_consume_token(-1);
          throw new ParseException();
        }
ASTEQNode jjtn001 = new ASTEQNode(JJTEQNODE);
                     boolean jjtc001 = true;
                     jjtree.openNodeScope(jjtn001);
                     jjtreeOpenNodeScope(jjtn001);
                     jjtn001.jjtSetFirstToken(getToken(1));
        try {
          RelationalExpression();
        } catch (Throwable jjte001) {
if (jjtc001) {
                       jjtree.clearNodeScope(jjtn001);
                       jjtc001 = false;
                     } else {
                       jjtree.popNode();
                     }
                     if (jjte001 instanceof ParseException) {
                       throw (ParseException)jjte001;
                     }
                     if (jjte001 instanceof RuntimeException) {
                       throw (RuntimeException)jjte001;
                     }
                     throw (Error)jjte001;
        } finally {
if (jjtc001) {
                       jjtree.closeNodeScope(jjtn001,  2);
                       if (jjtree.nodeCreated()) {
                        jjtreeCloseNodeScope(jjtn001);
                       }
                       jjtn001.jjtSetLastToken(getToken(0));
                     }
        }
        break;
        }
      case ne:
      case NE:{
        switch (jj_nt.kind) {
        case ne:{
          jj_consume_token(ne);
          break;
          }
        case NE:{
          jj_consume_token(NE);
          break;
          }
        default:
          jj_consume_token(-1);
          throw new ParseException();
        }
ASTNENode jjtn002 = new ASTNENode(JJTNENODE);
                     boolean jjtc002 = true;
                     jjtree.openNodeScope(jjtn002);
                     jjtreeOpenNodeScope(jjtn002);
                     jjtn002.jjtSetFirstToken(getToken(1));
        try {
          RelationalExpression();
        } catch (Throwable jjte002) {
if (jjtc002) {
                       jjtree.clearNodeScope(jjtn002);
                       jjtc002 = false;
                     } else {
                       jjtree.popNode();
                     }
                     if (jjte002 instanceof ParseException) {
                       throw (ParseException)jjte002;
                     }
                     if (jjte002 instanceof RuntimeException) {
                       throw (RuntimeException)jjte002;
                     }
                     throw (Error)jjte002;
        } finally {
if (jjtc002) {
                       jjtree.closeNodeScope(jjtn002,  2);
                       if (jjtree.nodeCreated()) {
                        jjtreeCloseNodeScope(jjtn002);
                       }
                       jjtn002.jjtSetLastToken(getToken(0));
                     }
        }
        break;
        }
      case eqstrict:{
        jj_consume_token(eqstrict);
ASTEQSNode jjtn003 = new ASTEQSNode(JJTEQSNODE);
                    boolean jjtc003 = true;
                    jjtree.openNodeScope(jjtn003);
                    jjtreeOpenNodeScope(jjtn003);
                    jjtn003.jjtSetFirstToken(getToken(1));
        try {
          RelationalExpression();
        } catch (Throwable jjte003) {
if (jjtc003) {
                      jjtree.clearNodeScope(jjtn003);
                      jjtc003 = false;
                    } else {
                      jjtree.popNode();
                    }
                    if (jjte003 instanceof ParseException) {
                      throw (ParseException)jjte003;
                    }
                    if (jjte003 instanceof RuntimeException) {
                      throw (RuntimeException)jjte003;
                    }
                    throw (Error)jjte003;
        } finally {
if (jjtc003) {
                      jjtree.closeNodeScope(jjtn003,  2);
                      if (jjtree.nodeCreated()) {
                       jjtreeCloseNodeScope(jjtn003);
                      }
                      jjtn003.jjtSetLastToken(getToken(0));
                    }
        }
        break;
        }
      case neqstrict:{
        jj_consume_token(neqstrict);
ASTNESNode jjtn004 = new ASTNESNode(JJTNESNODE);
                     boolean jjtc004 = true;
                     jjtree.openNodeScope(jjtn004);
                     jjtreeOpenNodeScope(jjtn004);
                     jjtn004.jjtSetFirstToken(getToken(1));
        try {
          RelationalExpression();
        } catch (Throwable jjte004) {
if (jjtc004) {
                       jjtree.clearNodeScope(jjtn004);
                       jjtc004 = false;
                     } else {
                       jjtree.popNode();
                     }
                     if (jjte004 instanceof ParseException) {
                       throw (ParseException)jjte004;
                     }
                     if (jjte004 instanceof RuntimeException) {
                       throw (RuntimeException)jjte004;
                     }
                     throw (Error)jjte004;
        } finally {
if (jjtc004) {
                       jjtree.closeNodeScope(jjtn004,  2);
                       if (jjtree.nodeCreated()) {
                        jjtreeCloseNodeScope(jjtn004);
                       }
                       jjtn004.jjtSetLastToken(getToken(0));
                     }
        }
        break;
        }
      case range:{
        jj_consume_token(range);
ASTRangeNode jjtn005 = new ASTRangeNode(JJTRANGENODE);
               boolean jjtc005 = true;
               jjtree.openNodeScope(jjtn005);
               jjtreeOpenNodeScope(jjtn005);
               jjtn005.jjtSetFirstToken(getToken(1));
        try {
          RelationalExpression();
        } catch (Throwable jjte005) {
if (jjtc005) {
                 jjtree.clearNodeScope(jjtn005);
                 jjtc005 = false;
               } else {
                 jjtree.popNode();
               }
               if (jjte005 instanceof ParseException) {
                 throw (ParseException)jjte005;
               }
               if (jjte005 instanceof RuntimeException) {
                 throw (RuntimeException)jjte005;
               }
               throw (Error)jjte005;
        } finally {
if (jjtc005) {
                 jjtree.closeNodeScope(jjtn005,  2);
                 if (jjtree.nodeCreated()) {
                  jjtreeCloseNodeScope(jjtn005);
                 }
                 jjtn005.jjtSetLastToken(getToken(0));
               }
        }
        break;
        }
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else {
      ;
    }
}

  final public void RelationalExpression() throws ParseException {
    ShiftExpression();
    if (jj_2_58(2)) {
      switch (jj_nt.kind) {
      case lt:
      case LT:{
        switch (jj_nt.kind) {
        case lt:{
          jj_consume_token(lt);
          break;
          }
        case LT:{
          jj_consume_token(LT);
          break;
          }
        default:
          jj_consume_token(-1);
          throw new ParseException();
        }
ASTLTNode jjtn001 = new ASTLTNode(JJTLTNODE);
                    boolean jjtc001 = true;
                    jjtree.openNodeScope(jjtn001);
                    jjtreeOpenNodeScope(jjtn001);
                    jjtn001.jjtSetFirstToken(getToken(1));
        try {
          ShiftExpression();
        } catch (Throwable jjte001) {
if (jjtc001) {
                      jjtree.clearNodeScope(jjtn001);
                      jjtc001 = false;
                    } else {
                      jjtree.popNode();
                    }
                    if (jjte001 instanceof ParseException) {
                      throw (ParseException)jjte001;
                    }
                    if (jjte001 instanceof RuntimeException) {
                      throw (RuntimeException)jjte001;
                    }
                    throw (Error)jjte001;
        } finally {
if (jjtc001) {
                      jjtree.closeNodeScope(jjtn001,  2);
                      if (jjtree.nodeCreated()) {
                       jjtreeCloseNodeScope(jjtn001);
                      }
                      jjtn001.jjtSetLastToken(getToken(0));
                    }
        }
        break;
        }
      case gt:
      case GT:{
        switch (jj_nt.kind) {
        case gt:{
          jj_consume_token(gt);
          break;
          }
        case GT:{
          jj_consume_token(GT);
          break;
          }
        default:
          jj_consume_token(-1);
          throw new ParseException();
        }
ASTGTNode jjtn002 = new ASTGTNode(JJTGTNODE);
                    boolean jjtc002 = true;
                    jjtree.openNodeScope(jjtn002);
                    jjtreeOpenNodeScope(jjtn002);
                    jjtn002.jjtSetFirstToken(getToken(1));
        try {
          ShiftExpression();
        } catch (Throwable jjte002) {
if (jjtc002) {
                      jjtree.clearNodeScope(jjtn002);
                      jjtc002 = false;
                    } else {
                      jjtree.popNode();
                    }
                    if (jjte002 instanceof ParseException) {
                      throw (ParseException)jjte002;
                    }
                    if (jjte002 instanceof RuntimeException) {
                      throw (RuntimeException)jjte002;
                    }
                    throw (Error)jjte002;
        } finally {
if (jjtc002) {
                      jjtree.closeNodeScope(jjtn002,  2);
                      if (jjtree.nodeCreated()) {
                       jjtreeCloseNodeScope(jjtn002);
                      }
                      jjtn002.jjtSetLastToken(getToken(0));
                    }
        }
        break;
        }
      case le:
      case LE:{
        switch (jj_nt.kind) {
        case le:{
          jj_consume_token(le);
          break;
          }
        case LE:{
          jj_consume_token(LE);
          break;
          }
        default:
          jj_consume_token(-1);
          throw new ParseException();
        }
ASTLENode jjtn003 = new ASTLENode(JJTLENODE);
                    boolean jjtc003 = true;
                    jjtree.openNodeScope(jjtn003);
                    jjtreeOpenNodeScope(jjtn003);
                    jjtn003.jjtSetFirstToken(getToken(1));
        try {
          ShiftExpression();
        } catch (Throwable jjte003) {
if (jjtc003) {
                      jjtree.clearNodeScope(jjtn003);
                      jjtc003 = false;
                    } else {
                      jjtree.popNode();
                    }
                    if (jjte003 instanceof ParseException) {
                      throw (ParseException)jjte003;
                    }
                    if (jjte003 instanceof RuntimeException) {
                      throw (RuntimeException)jjte003;
                    }
                    throw (Error)jjte003;
        } finally {
if (jjtc003) {
                      jjtree.closeNodeScope(jjtn003,  2);
                      if (jjtree.nodeCreated()) {
                       jjtreeCloseNodeScope(jjtn003);
                      }
                      jjtn003.jjtSetLastToken(getToken(0));
                    }
        }
        break;
        }
      case ge:
      case GE:{
        switch (jj_nt.kind) {
        case ge:{
          jj_consume_token(ge);
          break;
          }
        case GE:{
          jj_consume_token(GE);
          break;
          }
        default:
          jj_consume_token(-1);
          throw new ParseException();
        }
ASTGENode jjtn004 = new ASTGENode(JJTGENODE);
                    boolean jjtc004 = true;
                    jjtree.openNodeScope(jjtn004);
                    jjtreeOpenNodeScope(jjtn004);
                    jjtn004.jjtSetFirstToken(getToken(1));
        try {
          ShiftExpression();
        } catch (Throwable jjte004) {
if (jjtc004) {
                      jjtree.clearNodeScope(jjtn004);
                      jjtc004 = false;
                    } else {
                      jjtree.popNode();
                    }
                    if (jjte004 instanceof ParseException) {
                      throw (ParseException)jjte004;
                    }
                    if (jjte004 instanceof RuntimeException) {
                      throw (RuntimeException)jjte004;
                    }
                    throw (Error)jjte004;
        } finally {
if (jjtc004) {
                      jjtree.closeNodeScope(jjtn004,  2);
                      if (jjtree.nodeCreated()) {
                       jjtreeCloseNodeScope(jjtn004);
                      }
                      jjtn004.jjtSetLastToken(getToken(0));
                    }
        }
        break;
        }
      case req:{
        jj_consume_token(req);
ASTERNode jjtn005 = new ASTERNode(JJTERNODE);
            boolean jjtc005 = true;
            jjtree.openNodeScope(jjtn005);
            jjtreeOpenNodeScope(jjtn005);
            jjtn005.jjtSetFirstToken(getToken(1));
        try {
          ShiftExpression();
        } catch (Throwable jjte005) {
if (jjtc005) {
              jjtree.clearNodeScope(jjtn005);
              jjtc005 = false;
            } else {
              jjtree.popNode();
            }
            if (jjte005 instanceof ParseException) {
              throw (ParseException)jjte005;
            }
            if (jjte005 instanceof RuntimeException) {
              throw (RuntimeException)jjte005;
            }
            throw (Error)jjte005;
        } finally {
if (jjtc005) {
              jjtree.closeNodeScope(jjtn005,  2);
              if (jjtree.nodeCreated()) {
               jjtreeCloseNodeScope(jjtn005);
              }
              jjtn005.jjtSetLastToken(getToken(0));
            }
        }
        break;
        }
      case rne:{
        jj_consume_token(rne);
ASTNRNode jjtn006 = new ASTNRNode(JJTNRNODE);
            boolean jjtc006 = true;
            jjtree.openNodeScope(jjtn006);
            jjtreeOpenNodeScope(jjtn006);
            jjtn006.jjtSetFirstToken(getToken(1));
        try {
          ShiftExpression();
        } catch (Throwable jjte006) {
if (jjtc006) {
              jjtree.clearNodeScope(jjtn006);
              jjtc006 = false;
            } else {
              jjtree.popNode();
            }
            if (jjte006 instanceof ParseException) {
              throw (ParseException)jjte006;
            }
            if (jjte006 instanceof RuntimeException) {
              throw (RuntimeException)jjte006;
            }
            throw (Error)jjte006;
        } finally {
if (jjtc006) {
              jjtree.closeNodeScope(jjtn006,  2);
              if (jjtree.nodeCreated()) {
               jjtreeCloseNodeScope(jjtn006);
              }
              jjtn006.jjtSetLastToken(getToken(0));
            }
        }
        break;
        }
      case seq:{
        jj_consume_token(seq);
ASTSWNode jjtn007 = new ASTSWNode(JJTSWNODE);
            boolean jjtc007 = true;
            jjtree.openNodeScope(jjtn007);
            jjtreeOpenNodeScope(jjtn007);
            jjtn007.jjtSetFirstToken(getToken(1));
        try {
          ShiftExpression();
        } catch (Throwable jjte007) {
if (jjtc007) {
              jjtree.clearNodeScope(jjtn007);
              jjtc007 = false;
            } else {
              jjtree.popNode();
            }
            if (jjte007 instanceof ParseException) {
              throw (ParseException)jjte007;
            }
            if (jjte007 instanceof RuntimeException) {
              throw (RuntimeException)jjte007;
            }
            throw (Error)jjte007;
        } finally {
if (jjtc007) {
              jjtree.closeNodeScope(jjtn007,  2);
              if (jjtree.nodeCreated()) {
               jjtreeCloseNodeScope(jjtn007);
              }
              jjtn007.jjtSetLastToken(getToken(0));
            }
        }
        break;
        }
      case sne:{
        jj_consume_token(sne);
ASTNSWNode jjtn008 = new ASTNSWNode(JJTNSWNODE);
            boolean jjtc008 = true;
            jjtree.openNodeScope(jjtn008);
            jjtreeOpenNodeScope(jjtn008);
            jjtn008.jjtSetFirstToken(getToken(1));
        try {
          ShiftExpression();
        } catch (Throwable jjte008) {
if (jjtc008) {
              jjtree.clearNodeScope(jjtn008);
              jjtc008 = false;
            } else {
              jjtree.popNode();
            }
            if (jjte008 instanceof ParseException) {
              throw (ParseException)jjte008;
            }
            if (jjte008 instanceof RuntimeException) {
              throw (RuntimeException)jjte008;
            }
            throw (Error)jjte008;
        } finally {
if (jjtc008) {
              jjtree.closeNodeScope(jjtn008,  2);
              if (jjtree.nodeCreated()) {
               jjtreeCloseNodeScope(jjtn008);
              }
              jjtn008.jjtSetLastToken(getToken(0));
            }
        }
        break;
        }
      case eeq:{
        jj_consume_token(eeq);
ASTEWNode jjtn009 = new ASTEWNode(JJTEWNODE);
            boolean jjtc009 = true;
            jjtree.openNodeScope(jjtn009);
            jjtreeOpenNodeScope(jjtn009);
            jjtn009.jjtSetFirstToken(getToken(1));
        try {
          ShiftExpression();
        } catch (Throwable jjte009) {
if (jjtc009) {
              jjtree.clearNodeScope(jjtn009);
              jjtc009 = false;
            } else {
              jjtree.popNode();
            }
            if (jjte009 instanceof ParseException) {
              throw (ParseException)jjte009;
            }
            if (jjte009 instanceof RuntimeException) {
              throw (RuntimeException)jjte009;
            }
            throw (Error)jjte009;
        } finally {
if (jjtc009) {
              jjtree.closeNodeScope(jjtn009,  2);
              if (jjtree.nodeCreated()) {
               jjtreeCloseNodeScope(jjtn009);
              }
              jjtn009.jjtSetLastToken(getToken(0));
            }
        }
        break;
        }
      case ene:{
        jj_consume_token(ene);
ASTNEWNode jjtn010 = new ASTNEWNode(JJTNEWNODE);
            boolean jjtc010 = true;
            jjtree.openNodeScope(jjtn010);
            jjtreeOpenNodeScope(jjtn010);
            jjtn010.jjtSetFirstToken(getToken(1));
        try {
          ShiftExpression();
        } catch (Throwable jjte010) {
if (jjtc010) {
              jjtree.clearNodeScope(jjtn010);
              jjtc010 = false;
            } else {
              jjtree.popNode();
            }
            if (jjte010 instanceof ParseException) {
              throw (ParseException)jjte010;
            }
            if (jjte010 instanceof RuntimeException) {
              throw (RuntimeException)jjte010;
            }
            throw (Error)jjte010;
        } finally {
if (jjtc010) {
              jjtree.closeNodeScope(jjtn010,  2);
              if (jjtree.nodeCreated()) {
               jjtreeCloseNodeScope(jjtn010);
              }
              jjtn010.jjtSetLastToken(getToken(0));
            }
        }
        break;
        }
      case ISA:{
        jj_consume_token(ISA);
ASTInstanceOf jjtn011 = new ASTInstanceOf(JJTINSTANCEOF);
            boolean jjtc011 = true;
            jjtree.openNodeScope(jjtn011);
            jjtreeOpenNodeScope(jjtn011);
            jjtn011.jjtSetFirstToken(getToken(1));
        try {
          ShiftExpression();
        } catch (Throwable jjte011) {
if (jjtc011) {
              jjtree.clearNodeScope(jjtn011);
              jjtc011 = false;
            } else {
              jjtree.popNode();
            }
            if (jjte011 instanceof ParseException) {
              throw (ParseException)jjte011;
            }
            if (jjte011 instanceof RuntimeException) {
              throw (RuntimeException)jjte011;
            }
            throw (Error)jjte011;
        } finally {
if (jjtc011) {
              jjtree.closeNodeScope(jjtn011,  2);
              if (jjtree.nodeCreated()) {
               jjtreeCloseNodeScope(jjtn011);
              }
              jjtn011.jjtSetLastToken(getToken(0));
            }
        }
        break;
        }
      case NISA:{
        jj_consume_token(NISA);
ASTNotInstanceOf jjtn012 = new ASTNotInstanceOf(JJTNOTINSTANCEOF);
             boolean jjtc012 = true;
             jjtree.openNodeScope(jjtn012);
             jjtreeOpenNodeScope(jjtn012);
             jjtn012.jjtSetFirstToken(getToken(1));
        try {
          ShiftExpression();
        } catch (Throwable jjte012) {
if (jjtc012) {
               jjtree.clearNodeScope(jjtn012);
               jjtc012 = false;
             } else {
               jjtree.popNode();
             }
             if (jjte012 instanceof ParseException) {
               throw (ParseException)jjte012;
             }
             if (jjte012 instanceof RuntimeException) {
               throw (RuntimeException)jjte012;
             }
             throw (Error)jjte012;
        } finally {
if (jjtc012) {
               jjtree.closeNodeScope(jjtn012,  2);
               if (jjtree.nodeCreated()) {
                jjtreeCloseNodeScope(jjtn012);
               }
               jjtn012.jjtSetLastToken(getToken(0));
             }
        }
        break;
        }
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else {
      ;
    }
}

/***************************************
 *      Arithmetic
 ***************************************/
  final public void ShiftExpression() throws ParseException {
    AdditiveExpression();
    label_17:
    while (true) {
      if (jj_2_59(2)) {
      } else {
        break label_17;
      }
      switch (jj_nt.kind) {
      case lshift:{
        jj_consume_token(lshift);
ASTShiftLeftNode jjtn001 = new ASTShiftLeftNode(JJTSHIFTLEFTNODE);
                 boolean jjtc001 = true;
                 jjtree.openNodeScope(jjtn001);
                 jjtreeOpenNodeScope(jjtn001);
                 jjtn001.jjtSetFirstToken(getToken(1));
        try {
          AdditiveExpression();
        } catch (Throwable jjte001) {
if (jjtc001) {
                   jjtree.clearNodeScope(jjtn001);
                   jjtc001 = false;
                 } else {
                   jjtree.popNode();
                 }
                 if (jjte001 instanceof ParseException) {
                   throw (ParseException)jjte001;
                 }
                 if (jjte001 instanceof RuntimeException) {
                   throw (RuntimeException)jjte001;
                 }
                 throw (Error)jjte001;
        } finally {
if (jjtc001) {
                   jjtree.closeNodeScope(jjtn001,  2);
                   if (jjtree.nodeCreated()) {
                    jjtreeCloseNodeScope(jjtn001);
                   }
                   jjtn001.jjtSetLastToken(getToken(0));
                 }
        }
        break;
        }
      case rshift:{
        jj_consume_token(rshift);
ASTShiftRightNode jjtn002 = new ASTShiftRightNode(JJTSHIFTRIGHTNODE);
                 boolean jjtc002 = true;
                 jjtree.openNodeScope(jjtn002);
                 jjtreeOpenNodeScope(jjtn002);
                 jjtn002.jjtSetFirstToken(getToken(1));
        try {
          AdditiveExpression();
        } catch (Throwable jjte002) {
if (jjtc002) {
                   jjtree.clearNodeScope(jjtn002);
                   jjtc002 = false;
                 } else {
                   jjtree.popNode();
                 }
                 if (jjte002 instanceof ParseException) {
                   throw (ParseException)jjte002;
                 }
                 if (jjte002 instanceof RuntimeException) {
                   throw (RuntimeException)jjte002;
                 }
                 throw (Error)jjte002;
        } finally {
if (jjtc002) {
                   jjtree.closeNodeScope(jjtn002,  2);
                   if (jjtree.nodeCreated()) {
                    jjtreeCloseNodeScope(jjtn002);
                   }
                   jjtn002.jjtSetLastToken(getToken(0));
                 }
        }
        break;
        }
      case rshiftu:{
        jj_consume_token(rshiftu);
ASTShiftRightUnsignedNode jjtn003 = new ASTShiftRightUnsignedNode(JJTSHIFTRIGHTUNSIGNEDNODE);
                  boolean jjtc003 = true;
                  jjtree.openNodeScope(jjtn003);
                  jjtreeOpenNodeScope(jjtn003);
                  jjtn003.jjtSetFirstToken(getToken(1));
        try {
          AdditiveExpression();
        } catch (Throwable jjte003) {
if (jjtc003) {
                    jjtree.clearNodeScope(jjtn003);
                    jjtc003 = false;
                  } else {
                    jjtree.popNode();
                  }
                  if (jjte003 instanceof ParseException) {
                    throw (ParseException)jjte003;
                  }
                  if (jjte003 instanceof RuntimeException) {
                    throw (RuntimeException)jjte003;
                  }
                  throw (Error)jjte003;
        } finally {
if (jjtc003) {
                    jjtree.closeNodeScope(jjtn003,  2);
                    if (jjtree.nodeCreated()) {
                     jjtreeCloseNodeScope(jjtn003);
                    }
                    jjtn003.jjtSetLastToken(getToken(0));
                  }
        }
        break;
        }
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
}

  final public void AdditiveExpression() throws ParseException {
    MultiplicativeExpression();
    label_18:
    while (true) {
      if (jj_2_60(2)) {
      } else {
        break label_18;
      }
      switch (jj_nt.kind) {
      case plus:{
        jj_consume_token(plus);
ASTAddNode jjtn001 = new ASTAddNode(JJTADDNODE);
             boolean jjtc001 = true;
             jjtree.openNodeScope(jjtn001);
             jjtreeOpenNodeScope(jjtn001);
             jjtn001.jjtSetFirstToken(getToken(1));
        try {
          MultiplicativeExpression();
        } catch (Throwable jjte001) {
if (jjtc001) {
               jjtree.clearNodeScope(jjtn001);
               jjtc001 = false;
             } else {
               jjtree.popNode();
             }
             if (jjte001 instanceof ParseException) {
               throw (ParseException)jjte001;
             }
             if (jjte001 instanceof RuntimeException) {
               throw (RuntimeException)jjte001;
             }
             throw (Error)jjte001;
        } finally {
if (jjtc001) {
               jjtree.closeNodeScope(jjtn001,  2);
               if (jjtree.nodeCreated()) {
                jjtreeCloseNodeScope(jjtn001);
               }
               jjtn001.jjtSetLastToken(getToken(0));
             }
        }
        break;
        }
      case minus:{
        jj_consume_token(minus);
ASTSubNode jjtn002 = new ASTSubNode(JJTSUBNODE);
              boolean jjtc002 = true;
              jjtree.openNodeScope(jjtn002);
              jjtreeOpenNodeScope(jjtn002);
              jjtn002.jjtSetFirstToken(getToken(1));
        try {
          MultiplicativeExpression();
        } catch (Throwable jjte002) {
if (jjtc002) {
                jjtree.clearNodeScope(jjtn002);
                jjtc002 = false;
              } else {
                jjtree.popNode();
              }
              if (jjte002 instanceof ParseException) {
                throw (ParseException)jjte002;
              }
              if (jjte002 instanceof RuntimeException) {
                throw (RuntimeException)jjte002;
              }
              throw (Error)jjte002;
        } finally {
if (jjtc002) {
                jjtree.closeNodeScope(jjtn002,  2);
                if (jjtree.nodeCreated()) {
                 jjtreeCloseNodeScope(jjtn002);
                }
                jjtn002.jjtSetLastToken(getToken(0));
              }
        }
        break;
        }
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
}

  final public void MultiplicativeExpression() throws ParseException {
    UnaryExpression();
    label_19:
    while (true) {
      if (jj_2_61(2)) {
      } else {
        break label_19;
      }
      switch (jj_nt.kind) {
      case mult:{
        jj_consume_token(mult);
ASTMulNode jjtn001 = new ASTMulNode(JJTMULNODE);
             boolean jjtc001 = true;
             jjtree.openNodeScope(jjtn001);
             jjtreeOpenNodeScope(jjtn001);
             jjtn001.jjtSetFirstToken(getToken(1));
        try {
          UnaryExpression();
        } catch (Throwable jjte001) {
if (jjtc001) {
               jjtree.clearNodeScope(jjtn001);
               jjtc001 = false;
             } else {
               jjtree.popNode();
             }
             if (jjte001 instanceof ParseException) {
               throw (ParseException)jjte001;
             }
             if (jjte001 instanceof RuntimeException) {
               throw (RuntimeException)jjte001;
             }
             throw (Error)jjte001;
        } finally {
if (jjtc001) {
               jjtree.closeNodeScope(jjtn001,  2);
               if (jjtree.nodeCreated()) {
                jjtreeCloseNodeScope(jjtn001);
               }
               jjtn001.jjtSetLastToken(getToken(0));
             }
        }
        break;
        }
      case div:
      case DIV:{
        switch (jj_nt.kind) {
        case div:{
          jj_consume_token(div);
          break;
          }
        case DIV:{
          jj_consume_token(DIV);
          break;
          }
        default:
          jj_consume_token(-1);
          throw new ParseException();
        }
ASTDivNode jjtn002 = new ASTDivNode(JJTDIVNODE);
                    boolean jjtc002 = true;
                    jjtree.openNodeScope(jjtn002);
                    jjtreeOpenNodeScope(jjtn002);
                    jjtn002.jjtSetFirstToken(getToken(1));
        try {
          UnaryExpression();
        } catch (Throwable jjte002) {
if (jjtc002) {
                      jjtree.clearNodeScope(jjtn002);
                      jjtc002 = false;
                    } else {
                      jjtree.popNode();
                    }
                    if (jjte002 instanceof ParseException) {
                      throw (ParseException)jjte002;
                    }
                    if (jjte002 instanceof RuntimeException) {
                      throw (RuntimeException)jjte002;
                    }
                    throw (Error)jjte002;
        } finally {
if (jjtc002) {
                      jjtree.closeNodeScope(jjtn002,  2);
                      if (jjtree.nodeCreated()) {
                       jjtreeCloseNodeScope(jjtn002);
                      }
                      jjtn002.jjtSetLastToken(getToken(0));
                    }
        }
        break;
        }
      case mod:
      case MOD:{
        switch (jj_nt.kind) {
        case mod:{
          jj_consume_token(mod);
          break;
          }
        case MOD:{
          jj_consume_token(MOD);
          break;
          }
        default:
          jj_consume_token(-1);
          throw new ParseException();
        }
ASTModNode jjtn003 = new ASTModNode(JJTMODNODE);
                    boolean jjtc003 = true;
                    jjtree.openNodeScope(jjtn003);
                    jjtreeOpenNodeScope(jjtn003);
                    jjtn003.jjtSetFirstToken(getToken(1));
        try {
          UnaryExpression();
        } catch (Throwable jjte003) {
if (jjtc003) {
                      jjtree.clearNodeScope(jjtn003);
                      jjtc003 = false;
                    } else {
                      jjtree.popNode();
                    }
                    if (jjte003 instanceof ParseException) {
                      throw (ParseException)jjte003;
                    }
                    if (jjte003 instanceof RuntimeException) {
                      throw (RuntimeException)jjte003;
                    }
                    throw (Error)jjte003;
        } finally {
if (jjtc003) {
                      jjtree.closeNodeScope(jjtn003,  2);
                      if (jjtree.nodeCreated()) {
                       jjtreeCloseNodeScope(jjtn003);
                      }
                      jjtn003.jjtSetLastToken(getToken(0));
                    }
        }
        break;
        }
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
}

  final public void UnaryExpression() throws ParseException {
    switch (jj_nt.kind) {
    case minus:{
      jj_consume_token(minus);
ASTUnaryMinusNode jjtn001 = new ASTUnaryMinusNode(JJTUNARYMINUSNODE);
              boolean jjtc001 = true;
              jjtree.openNodeScope(jjtn001);
              jjtreeOpenNodeScope(jjtn001);
              jjtn001.jjtSetFirstToken(getToken(1));
      try {
        UnaryExpression();
      } catch (Throwable jjte001) {
if (jjtc001) {
                jjtree.clearNodeScope(jjtn001);
                jjtc001 = false;
              } else {
                jjtree.popNode();
              }
              if (jjte001 instanceof ParseException) {
                throw (ParseException)jjte001;
              }
              if (jjte001 instanceof RuntimeException) {
                throw (RuntimeException)jjte001;
              }
              throw (Error)jjte001;
      } finally {
if (jjtc001) {
                jjtree.closeNodeScope(jjtn001,  1);
                if (jjtree.nodeCreated()) {
                 jjtreeCloseNodeScope(jjtn001);
                }
                jjtn001.jjtSetLastToken(getToken(0));
              }
      }
      break;
      }
    case plus:{
      jj_consume_token(plus);
ASTUnaryPlusNode jjtn002 = new ASTUnaryPlusNode(JJTUNARYPLUSNODE);
             boolean jjtc002 = true;
             jjtree.openNodeScope(jjtn002);
             jjtreeOpenNodeScope(jjtn002);
             jjtn002.jjtSetFirstToken(getToken(1));
      try {
        UnaryExpression();
      } catch (Throwable jjte002) {
if (jjtc002) {
               jjtree.clearNodeScope(jjtn002);
               jjtc002 = false;
             } else {
               jjtree.popNode();
             }
             if (jjte002 instanceof ParseException) {
               throw (ParseException)jjte002;
             }
             if (jjte002 instanceof RuntimeException) {
               throw (RuntimeException)jjte002;
             }
             throw (Error)jjte002;
      } finally {
if (jjtc002) {
               jjtree.closeNodeScope(jjtn002,  1);
               if (jjtree.nodeCreated()) {
                jjtreeCloseNodeScope(jjtn002);
               }
               jjtn002.jjtSetLastToken(getToken(0));
             }
      }
      break;
      }
    case tilda:{
      jj_consume_token(tilda);
ASTBitwiseComplNode jjtn003 = new ASTBitwiseComplNode(JJTBITWISECOMPLNODE);
              boolean jjtc003 = true;
              jjtree.openNodeScope(jjtn003);
              jjtreeOpenNodeScope(jjtn003);
              jjtn003.jjtSetFirstToken(getToken(1));
      try {
        UnaryExpression();
      } catch (Throwable jjte003) {
if (jjtc003) {
                jjtree.clearNodeScope(jjtn003);
                jjtc003 = false;
              } else {
                jjtree.popNode();
              }
              if (jjte003 instanceof ParseException) {
                throw (ParseException)jjte003;
              }
              if (jjte003 instanceof RuntimeException) {
                throw (RuntimeException)jjte003;
              }
              throw (Error)jjte003;
      } finally {
if (jjtc003) {
                jjtree.closeNodeScope(jjtn003,  1);
                if (jjtree.nodeCreated()) {
                 jjtreeCloseNodeScope(jjtn003);
                }
                jjtn003.jjtSetLastToken(getToken(0));
              }
      }
      break;
      }
    case not:
    case NOT:{
      switch (jj_nt.kind) {
      case not:{
        jj_consume_token(not);
        break;
        }
      case NOT:{
        jj_consume_token(NOT);
        break;
        }
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
ASTNotNode jjtn004 = new ASTNotNode(JJTNOTNODE);
                    boolean jjtc004 = true;
                    jjtree.openNodeScope(jjtn004);
                    jjtreeOpenNodeScope(jjtn004);
                    jjtn004.jjtSetFirstToken(getToken(1));
      try {
        UnaryExpression();
      } catch (Throwable jjte004) {
if (jjtc004) {
                      jjtree.clearNodeScope(jjtn004);
                      jjtc004 = false;
                    } else {
                      jjtree.popNode();
                    }
                    if (jjte004 instanceof ParseException) {
                      throw (ParseException)jjte004;
                    }
                    if (jjte004 instanceof RuntimeException) {
                      throw (RuntimeException)jjte004;
                    }
                    throw (Error)jjte004;
      } finally {
if (jjtc004) {
                      jjtree.closeNodeScope(jjtn004,  1);
                      if (jjtree.nodeCreated()) {
                       jjtreeCloseNodeScope(jjtn004);
                      }
                      jjtn004.jjtSetLastToken(getToken(0));
                    }
      }
      break;
      }
    case EMPTY:{
      jj_consume_token(EMPTY);
ASTEmptyFunction jjtn005 = new ASTEmptyFunction(JJTEMPTYFUNCTION);
              boolean jjtc005 = true;
              jjtree.openNodeScope(jjtn005);
              jjtreeOpenNodeScope(jjtn005);
              jjtn005.jjtSetFirstToken(getToken(1));
      try {
        UnaryExpression();
      } catch (Throwable jjte005) {
if (jjtc005) {
                jjtree.clearNodeScope(jjtn005);
                jjtc005 = false;
              } else {
                jjtree.popNode();
              }
              if (jjte005 instanceof ParseException) {
                throw (ParseException)jjte005;
              }
              if (jjte005 instanceof RuntimeException) {
                throw (RuntimeException)jjte005;
              }
              throw (Error)jjte005;
      } finally {
if (jjtc005) {
                jjtree.closeNodeScope(jjtn005,  1);
                if (jjtree.nodeCreated()) {
                 jjtreeCloseNodeScope(jjtn005);
                }
                jjtn005.jjtSetLastToken(getToken(0));
              }
      }
      break;
      }
    case SIZE:{
      jj_consume_token(SIZE);
ASTSizeFunction jjtn006 = new ASTSizeFunction(JJTSIZEFUNCTION);
             boolean jjtc006 = true;
             jjtree.openNodeScope(jjtn006);
             jjtreeOpenNodeScope(jjtn006);
             jjtn006.jjtSetFirstToken(getToken(1));
      try {
        UnaryExpression();
      } catch (Throwable jjte006) {
if (jjtc006) {
               jjtree.clearNodeScope(jjtn006);
               jjtc006 = false;
             } else {
               jjtree.popNode();
             }
             if (jjte006 instanceof ParseException) {
               throw (ParseException)jjte006;
             }
             if (jjte006 instanceof RuntimeException) {
               throw (RuntimeException)jjte006;
             }
             throw (Error)jjte006;
      } finally {
if (jjtc006) {
               jjtree.closeNodeScope(jjtn006,  1);
               if (jjtree.nodeCreated()) {
                jjtreeCloseNodeScope(jjtn006);
               }
               jjtn006.jjtSetLastToken(getToken(0));
             }
      }
      break;
      }
    case minusminus:{
      jj_consume_token(minusminus);
ASTDecrementGetNode jjtn007 = new ASTDecrementGetNode(JJTDECREMENTGETNODE);
                  boolean jjtc007 = true;
                  jjtree.openNodeScope(jjtn007);
                  jjtreeOpenNodeScope(jjtn007);
                  jjtn007.jjtSetFirstToken(getToken(1));
      try {
        UnaryExpression();
      } catch (Throwable jjte007) {
if (jjtc007) {
                    jjtree.clearNodeScope(jjtn007);
                    jjtc007 = false;
                  } else {
                    jjtree.popNode();
                  }
                  if (jjte007 instanceof ParseException) {
                    throw (ParseException)jjte007;
                  }
                  if (jjte007 instanceof RuntimeException) {
                    throw (RuntimeException)jjte007;
                  }
                  throw (Error)jjte007;
      } finally {
if (jjtc007) {
                    jjtree.closeNodeScope(jjtn007,  1);
                    if (jjtree.nodeCreated()) {
                     jjtreeCloseNodeScope(jjtn007);
                    }
                    jjtn007.jjtSetLastToken(getToken(0));
                  }
      }
      break;
      }
    case plusplus:{
      jj_consume_token(plusplus);
ASTIncrementGetNode jjtn008 = new ASTIncrementGetNode(JJTINCREMENTGETNODE);
                boolean jjtc008 = true;
                jjtree.openNodeScope(jjtn008);
                jjtreeOpenNodeScope(jjtn008);
                jjtn008.jjtSetFirstToken(getToken(1));
      try {
        UnaryExpression();
      } catch (Throwable jjte008) {
if (jjtc008) {
                  jjtree.clearNodeScope(jjtn008);
                  jjtc008 = false;
                } else {
                  jjtree.popNode();
                }
                if (jjte008 instanceof ParseException) {
                  throw (ParseException)jjte008;
                }
                if (jjte008 instanceof RuntimeException) {
                  throw (RuntimeException)jjte008;
                }
                throw (Error)jjte008;
      } finally {
if (jjtc008) {
                  jjtree.closeNodeScope(jjtn008,  1);
                  if (jjtree.nodeCreated()) {
                   jjtreeCloseNodeScope(jjtn008);
                  }
                  jjtn008.jjtSetLastToken(getToken(0));
                }
      }
      break;
      }
    default:
      if (jj_2_62(1)) {
        PostfixExpression();
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
}

  final public void PostfixOperator() throws ParseException {
    switch (jj_nt.kind) {
    case plusplus:{
ASTGetIncrementNode jjtn001 = new ASTGetIncrementNode(JJTGETINCREMENTNODE);
      boolean jjtc001 = true;
      jjtree.openNodeScope(jjtn001);
      jjtreeOpenNodeScope(jjtn001);
      jjtn001.jjtSetFirstToken(getToken(1));
      try {
        jj_consume_token(plusplus);
      } finally {
if (jjtc001) {
        jjtree.closeNodeScope(jjtn001,  1);
        if (jjtree.nodeCreated()) {
         jjtreeCloseNodeScope(jjtn001);
        }
        jjtn001.jjtSetLastToken(getToken(0));
      }
      }
      break;
      }
    case minusminus:{
ASTGetDecrementNode jjtn002 = new ASTGetDecrementNode(JJTGETDECREMENTNODE);
      boolean jjtc002 = true;
      jjtree.openNodeScope(jjtn002);
      jjtreeOpenNodeScope(jjtn002);
      jjtn002.jjtSetFirstToken(getToken(1));
      try {
        jj_consume_token(minusminus);
      } finally {
if (jjtc002) {
        jjtree.closeNodeScope(jjtn002,  1);
        if (jjtree.nodeCreated()) {
         jjtreeCloseNodeScope(jjtn002);
        }
        jjtn002.jjtSetLastToken(getToken(0));
      }
      }
      break;
      }
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public void PostfixExpression() throws ParseException {
    ValueExpression();
    switch (jj_nt.kind) {
    case plusplus:
    case minusminus:{
      PostfixOperator();
      break;
      }
    default:
      ;
    }
}

/***************************************
 *      Identifier & Literals
 ***************************************/
  final public 
void Identifier(boolean top) throws ParseException {/*@bgen(jjtree) Identifier */
    ASTIdentifier jjtn000 = new ASTIdentifier(JJTIDENTIFIER);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtreeOpenNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Token t;
    try {
      switch (jj_nt.kind) {
      case IDENTIFIER:{
        t = jj_consume_token(IDENTIFIER);
jjtree.closeNodeScope(jjtn000, true);
                     jjtc000 = false;
                     if (jjtree.nodeCreated()) {
                      jjtreeCloseNodeScope(jjtn000);
                     }
                     jjtn000.jjtSetLastToken(getToken(0));
jjtn000.setSymbol(top? checkVariable(jjtn000, t.image) : t.image);
        break;
        }
      case REGISTER:{
        t = jj_consume_token(REGISTER);
jjtree.closeNodeScope(jjtn000, true);
                   jjtc000 = false;
                   if (jjtree.nodeCreated()) {
                    jjtreeCloseNodeScope(jjtn000);
                   }
                   jjtn000.jjtSetLastToken(getToken(0));
if (!getFeatures().supportsRegister()) throwParsingException(t); jjtn000.setSymbol(t.image);
        break;
        }
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        if (jjtree.nodeCreated()) {
         jjtreeCloseNodeScope(jjtn000);
        }
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
}

  final public void NamespaceIdentifier() throws ParseException {/*@bgen(jjtree) NamespaceIdentifier */
    ASTNamespaceIdentifier jjtn000 = new ASTNamespaceIdentifier(JJTNAMESPACEIDENTIFIER);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtreeOpenNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Token ns;
    Token id;
    try {
      ns = jj_consume_token(IDENTIFIER);
      jj_consume_token(COLON);
      id = jj_consume_token(IDENTIFIER);
jjtree.closeNodeScope(jjtn000, true);
                                             jjtc000 = false;
                                             if (jjtree.nodeCreated()) {
                                              jjtreeCloseNodeScope(jjtn000);
                                             }
                                             jjtn000.jjtSetLastToken(getToken(0));
jjtn000.setNamespace(ns.image, id.image);
    } finally {
if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
       if (jjtree.nodeCreated()) {
        jjtreeCloseNodeScope(jjtn000);
       }
       jjtn000.jjtSetLastToken(getToken(0));
     }
    }
}

  final public void Literal() throws ParseException {Token t;
    switch (jj_nt.kind) {
    case INTEGER_LITERAL:{
      IntegerLiteral();
      break;
      }
    case FLOAT_LITERAL:{
      FloatLiteral();
      break;
      }
    case TRUE:
    case FALSE:{
      BooleanLiteral();
      break;
      }
    case JXLT_LITERAL:{
      JxltLiteral();
      break;
      }
    case STRING_LITERAL:{
      StringLiteral();
      break;
      }
    case REGEX_LITERAL:{
      RegexLiteral();
      break;
      }
    case NULL:{
      NullLiteral();
      break;
      }
    case NAN_LITERAL:{
      NaNLiteral();
      break;
      }
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public void NaNLiteral() throws ParseException {/*@bgen(jjtree) NumberLiteral */
  ASTNumberLiteral jjtn000 = new ASTNumberLiteral(JJTNUMBERLITERAL);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(NAN_LITERAL);
jjtree.closeNodeScope(jjtn000, true);
                    jjtc000 = false;
                    if (jjtree.nodeCreated()) {
                     jjtreeCloseNodeScope(jjtn000);
                    }
                    jjtn000.jjtSetLastToken(getToken(0));
jjtn000.setReal("NaN");
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        if (jjtree.nodeCreated()) {
         jjtreeCloseNodeScope(jjtn000);
        }
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
}

  final public void NullLiteral() throws ParseException {/*@bgen(jjtree) NullLiteral */
  ASTNullLiteral jjtn000 = new ASTNullLiteral(JJTNULLLITERAL);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(NULL);
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        if (jjtree.nodeCreated()) {
         jjtreeCloseNodeScope(jjtn000);
        }
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
}

  final public void BooleanLiteral() throws ParseException {
    switch (jj_nt.kind) {
    case TRUE:{
ASTTrueNode jjtn001 = new ASTTrueNode(JJTTRUENODE);
    boolean jjtc001 = true;
    jjtree.openNodeScope(jjtn001);
    jjtreeOpenNodeScope(jjtn001);
    jjtn001.jjtSetFirstToken(getToken(1));
      try {
        jj_consume_token(TRUE);
      } finally {
if (jjtc001) {
      jjtree.closeNodeScope(jjtn001, true);
      if (jjtree.nodeCreated()) {
       jjtreeCloseNodeScope(jjtn001);
      }
      jjtn001.jjtSetLastToken(getToken(0));
    }
      }
      break;
      }
    case FALSE:{
ASTFalseNode jjtn002 = new ASTFalseNode(JJTFALSENODE);
    boolean jjtc002 = true;
    jjtree.openNodeScope(jjtn002);
    jjtreeOpenNodeScope(jjtn002);
    jjtn002.jjtSetFirstToken(getToken(1));
      try {
        jj_consume_token(FALSE);
      } finally {
if (jjtc002) {
      jjtree.closeNodeScope(jjtn002, true);
      if (jjtree.nodeCreated()) {
       jjtreeCloseNodeScope(jjtn002);
      }
      jjtn002.jjtSetLastToken(getToken(0));
    }
      }
      break;
      }
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public void IntegerLiteral() throws ParseException {/*@bgen(jjtree) NumberLiteral */
  ASTNumberLiteral jjtn000 = new ASTNumberLiteral(JJTNUMBERLITERAL);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));Token t;
    try {
      t = jj_consume_token(INTEGER_LITERAL);
jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    if (jjtree.nodeCreated()) {
     jjtreeCloseNodeScope(jjtn000);
    }
    jjtn000.jjtSetLastToken(getToken(0));
jjtn000.setNatural(t.image);
    } finally {
if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      if (jjtree.nodeCreated()) {
       jjtreeCloseNodeScope(jjtn000);
      }
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
}

  final public void FloatLiteral() throws ParseException {/*@bgen(jjtree) NumberLiteral */
  ASTNumberLiteral jjtn000 = new ASTNumberLiteral(JJTNUMBERLITERAL);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));Token t;
    try {
      t = jj_consume_token(FLOAT_LITERAL);
jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    if (jjtree.nodeCreated()) {
     jjtreeCloseNodeScope(jjtn000);
    }
    jjtn000.jjtSetLastToken(getToken(0));
jjtn000.setReal(t.image);
    } finally {
if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      if (jjtree.nodeCreated()) {
       jjtreeCloseNodeScope(jjtn000);
      }
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
}

  final public void StringLiteral() throws ParseException {/*@bgen(jjtree) StringLiteral */
   ASTStringLiteral jjtn000 = new ASTStringLiteral(JJTSTRINGLITERAL);
   boolean jjtc000 = true;
   jjtree.openNodeScope(jjtn000);
   jjtreeOpenNodeScope(jjtn000);
   jjtn000.jjtSetFirstToken(getToken(1));Token t;
    try {
      t = jj_consume_token(STRING_LITERAL);
jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    if (jjtree.nodeCreated()) {
     jjtreeCloseNodeScope(jjtn000);
    }
    jjtn000.jjtSetLastToken(getToken(0));
jjtn000.setLiteral(Parser.buildString(t.image, true));
    } finally {
if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      if (jjtree.nodeCreated()) {
       jjtreeCloseNodeScope(jjtn000);
      }
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
}

  final public void JxltLiteral() throws ParseException {/*@bgen(jjtree) JxltLiteral */
   ASTJxltLiteral jjtn000 = new ASTJxltLiteral(JJTJXLTLITERAL);
   boolean jjtc000 = true;
   jjtree.openNodeScope(jjtn000);
   jjtreeOpenNodeScope(jjtn000);
   jjtn000.jjtSetFirstToken(getToken(1));Token t;
    try {
      t = jj_consume_token(JXLT_LITERAL);
jjtree.closeNodeScope(jjtn000, true);
     jjtc000 = false;
     if (jjtree.nodeCreated()) {
      jjtreeCloseNodeScope(jjtn000);
     }
     jjtn000.jjtSetLastToken(getToken(0));
jjtn000.setLiteral(Parser.buildString(t.image, true));
    } finally {
if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
       if (jjtree.nodeCreated()) {
        jjtreeCloseNodeScope(jjtn000);
       }
       jjtn000.jjtSetLastToken(getToken(0));
     }
    }
}

  final public void RegexLiteral() throws ParseException {/*@bgen(jjtree) RegexLiteral */
   ASTRegexLiteral jjtn000 = new ASTRegexLiteral(JJTREGEXLITERAL);
   boolean jjtc000 = true;
   jjtree.openNodeScope(jjtn000);
   jjtreeOpenNodeScope(jjtn000);
   jjtn000.jjtSetFirstToken(getToken(1));Token t;
    try {
      t = jj_consume_token(REGEX_LITERAL);
jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    if (jjtree.nodeCreated()) {
     jjtreeCloseNodeScope(jjtn000);
    }
    jjtn000.jjtSetLastToken(getToken(0));
jjtn000.setLiteral(Parser.buildRegex(t.image));
    } finally {
if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      if (jjtree.nodeCreated()) {
       jjtreeCloseNodeScope(jjtn000);
      }
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
}

  final public void ExtendedLiteral() throws ParseException {/*@bgen(jjtree) ExtendedLiteral */
  ASTExtendedLiteral jjtn000 = new ASTExtendedLiteral(JJTEXTENDEDLITERAL);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(ELIPSIS);
    } finally {
if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
       if (jjtree.nodeCreated()) {
        jjtreeCloseNodeScope(jjtn000);
       }
       jjtn000.jjtSetLastToken(getToken(0));
     }
    }
}

  final public void ArrayLiteral() throws ParseException {/*@bgen(jjtree) ArrayLiteral */
  ASTArrayLiteral jjtn000 = new ASTArrayLiteral(JJTARRAYLITERAL);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(LBRACKET);
      switch (jj_nt.kind) {
      case COMMA:
      case ELIPSIS:{
        switch (jj_nt.kind) {
        case COMMA:{
          jj_consume_token(COMMA);
          break;
          }
        default:
          ;
        }
        ExtendedLiteral();
        break;
        }
      default:
        if (jj_2_64(1)) {
          Expression();
          label_20:
          while (true) {
            if (jj_2_63(2)) {
            } else {
              break label_20;
            }
            jj_consume_token(COMMA);
            Expression();
          }
          switch (jj_nt.kind) {
          case COMMA:{
            jj_consume_token(COMMA);
            switch (jj_nt.kind) {
            case ELIPSIS:{
              ExtendedLiteral();
jjtn000.setExtended(true);
              break;
              }
            default:
              ;
            }
            break;
            }
          default:
            ;
          }
        } else {
          ;
        }
      }
      jj_consume_token(RBRACKET);
    } catch (Throwable jjte000) {
if (jjtc000) {
       jjtree.clearNodeScope(jjtn000);
       jjtc000 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte000 instanceof ParseException) {
       throw (ParseException)jjte000;
     }
     if (jjte000 instanceof RuntimeException) {
       throw (RuntimeException)jjte000;
     }
     throw (Error)jjte000;
    } finally {
if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
       if (jjtree.nodeCreated()) {
        jjtreeCloseNodeScope(jjtn000);
       }
       jjtn000.jjtSetLastToken(getToken(0));
     }
    }
}

  final public void MapLiteral() throws ParseException {/*@bgen(jjtree) MapLiteral */
  ASTMapLiteral jjtn000 = new ASTMapLiteral(JJTMAPLITERAL);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(LCURLY);
      if (jj_2_66(1)) {
        MapEntry();
        label_21:
        while (true) {
          if (jj_2_65(2)) {
          } else {
            break label_21;
          }
          jj_consume_token(COMMA);
          MapEntry();
        }
        switch (jj_nt.kind) {
        case COMMA:{
          jj_consume_token(COMMA);
          switch (jj_nt.kind) {
          case ELIPSIS:{
            ExtendedLiteral();
jjtn000.setExtended(true);
            break;
            }
          default:
            ;
          }
          break;
          }
        default:
          ;
        }
      } else {
        switch (jj_nt.kind) {
        case COLON:{
          jj_consume_token(COLON);
          break;
          }
        default:
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      jj_consume_token(RCURLY);
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof ParseException) {
        throw (ParseException)jjte000;
      }
      if (jjte000 instanceof RuntimeException) {
        throw (RuntimeException)jjte000;
      }
      throw (Error)jjte000;
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        if (jjtree.nodeCreated()) {
         jjtreeCloseNodeScope(jjtn000);
        }
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
}

  final public void MapEntry() throws ParseException {/*@bgen(jjtree) MapEntry */
  ASTMapEntry jjtn000 = new ASTMapEntry(JJTMAPENTRY);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      if (jj_2_67(2)) {
        Identifier(true);
        jj_consume_token(COLON);
        Expression();
      } else if (jj_2_68(1)) {
        Expression();
        jj_consume_token(COLON);
        Expression();
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof ParseException) {
        throw (ParseException)jjte000;
      }
      if (jjte000 instanceof RuntimeException) {
        throw (RuntimeException)jjte000;
      }
      throw (Error)jjte000;
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        if (jjtree.nodeCreated()) {
         jjtreeCloseNodeScope(jjtn000);
        }
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
}

  final public void SetLiteral() throws ParseException {/*@bgen(jjtree) SetLiteral */
  ASTSetLiteral jjtn000 = new ASTSetLiteral(JJTSETLITERAL);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(LCURLY);
      if (jj_2_70(1)) {
        Expression();
        label_22:
        while (true) {
          if (jj_2_69(2)) {
          } else {
            break label_22;
          }
          jj_consume_token(COMMA);
          Expression();
        }
        switch (jj_nt.kind) {
        case COMMA:{
          jj_consume_token(COMMA);
          switch (jj_nt.kind) {
          case ELIPSIS:{
            ExtendedLiteral();
jjtn000.setExtended(true);
            break;
            }
          default:
            ;
          }
          break;
          }
        default:
          ;
        }
      } else {
        ;
      }
      jj_consume_token(RCURLY);
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof ParseException) {
        throw (ParseException)jjte000;
      }
      if (jjte000 instanceof RuntimeException) {
        throw (RuntimeException)jjte000;
      }
      throw (Error)jjte000;
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        if (jjtree.nodeCreated()) {
         jjtreeCloseNodeScope(jjtn000);
        }
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
}

/***************************************
 *      Functions & Methods
 ***************************************/
  final public 
void Arguments() throws ParseException {/*@bgen(jjtree) Arguments */
  ASTArguments jjtn000 = new ASTArguments(JJTARGUMENTS);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(LPAREN);
      if (jj_2_71(1)) {
        Expression();
        label_23:
        while (true) {
          switch (jj_nt.kind) {
          case COMMA:{
            break;
            }
          default:
            break label_23;
          }
          jj_consume_token(COMMA);
          Expression();
        }
      } else {
        ;
      }
      jj_consume_token(RPAREN);
    } catch (Throwable jjte000) {
if (jjtc000) {
         jjtree.clearNodeScope(jjtn000);
         jjtc000 = false;
       } else {
         jjtree.popNode();
       }
       if (jjte000 instanceof ParseException) {
         throw (ParseException)jjte000;
       }
       if (jjte000 instanceof RuntimeException) {
         throw (RuntimeException)jjte000;
       }
       throw (Error)jjte000;
    } finally {
if (jjtc000) {
         jjtree.closeNodeScope(jjtn000, true);
         if (jjtree.nodeCreated()) {
          jjtreeCloseNodeScope(jjtn000);
         }
         jjtn000.jjtSetLastToken(getToken(0));
       }
    }
}

  final public void FunctionCallLookahead() throws ParseException {
    if (jj_2_72(4) && (isNamespaceFuncall(getToken(1), getToken(2), getToken(3), getToken(4)))) {
      jj_consume_token(IDENTIFIER);
      jj_consume_token(COLON);
      jj_consume_token(IDENTIFIER);
      jj_consume_token(LPAREN);
    } else if (jj_2_73(2)) {
      jj_consume_token(IDENTIFIER);
      jj_consume_token(LPAREN);
    } else if (jj_2_74(2)) {
      jj_consume_token(REGISTER);
      jj_consume_token(LPAREN);
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public void FunctionCall() throws ParseException {
    if (jj_2_75(4) && (isNamespaceFuncall(getToken(1), getToken(2), getToken(3), getToken(4)))) {
      NamespaceIdentifier();
ASTFunctionNode jjtn001 = new ASTFunctionNode(JJTFUNCTIONNODE);
                                                                                                                                                                   boolean jjtc001 = true;
                                                                                                                                                                   jjtree.openNodeScope(jjtn001);
                                                                                                                                                                   jjtreeOpenNodeScope(jjtn001);
                                                                                                                                                                   jjtn001.jjtSetFirstToken(getToken(1));
      try {
        Arguments();
      } catch (Throwable jjte001) {
if (jjtc001) {
                                                                                                                                                                     jjtree.clearNodeScope(jjtn001);
                                                                                                                                                                     jjtc001 = false;
                                                                                                                                                                   } else {
                                                                                                                                                                     jjtree.popNode();
                                                                                                                                                                   }
                                                                                                                                                                   if (jjte001 instanceof ParseException) {
                                                                                                                                                                     throw (ParseException)jjte001;
                                                                                                                                                                   }
                                                                                                                                                                   if (jjte001 instanceof RuntimeException) {
                                                                                                                                                                     throw (RuntimeException)jjte001;
                                                                                                                                                                   }
                                                                                                                                                                   throw (Error)jjte001;
      } finally {
if (jjtc001) {
                                                                                                                                                                     jjtree.closeNodeScope(jjtn001,  2);
                                                                                                                                                                     if (jjtree.nodeCreated()) {
                                                                                                                                                                      jjtreeCloseNodeScope(jjtn001);
                                                                                                                                                                     }
                                                                                                                                                                     jjtn001.jjtSetLastToken(getToken(0));
                                                                                                                                                                   }
      }
    } else if (jj_2_76(2147483647)) {
      Identifier(true);
ASTFunctionNode jjtn002 = new ASTFunctionNode(JJTFUNCTIONNODE);
                                                        boolean jjtc002 = true;
                                                        jjtree.openNodeScope(jjtn002);
                                                        jjtreeOpenNodeScope(jjtn002);
                                                        jjtn002.jjtSetFirstToken(getToken(1));
      try {
        Arguments();
      } catch (Throwable jjte002) {
if (jjtc002) {
                                                          jjtree.clearNodeScope(jjtn002);
                                                          jjtc002 = false;
                                                        } else {
                                                          jjtree.popNode();
                                                        }
                                                        if (jjte002 instanceof ParseException) {
                                                          throw (ParseException)jjte002;
                                                        }
                                                        if (jjte002 instanceof RuntimeException) {
                                                          throw (RuntimeException)jjte002;
                                                        }
                                                        throw (Error)jjte002;
      } finally {
if (jjtc002) {
                                                          jjtree.closeNodeScope(jjtn002,  2);
                                                          if (jjtree.nodeCreated()) {
                                                           jjtreeCloseNodeScope(jjtn002);
                                                          }
                                                          jjtn002.jjtSetLastToken(getToken(0));
                                                        }
      }
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public void QualifiedIdentifier() throws ParseException {/*@bgen(jjtree) QualifiedIdentifier */
    ASTQualifiedIdentifier jjtn000 = new ASTQualifiedIdentifier(JJTQUALIFIEDIDENTIFIER);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtreeOpenNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));LinkedList<String> lstr = new LinkedList<String>();
    try {
      pragmaKey(lstr);
jjtree.closeNodeScope(jjtn000, true);
                      jjtc000 = false;
                      if (jjtree.nodeCreated()) {
                       jjtreeCloseNodeScope(jjtn000);
                      }
                      jjtn000.jjtSetLastToken(getToken(0));
jjtn000.setName(stringify(lstr));
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof ParseException) {
        throw (ParseException)jjte000;
      }
      if (jjte000 instanceof RuntimeException) {
        throw (RuntimeException)jjte000;
      }
      throw (Error)jjte000;
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        if (jjtree.nodeCreated()) {
         jjtreeCloseNodeScope(jjtn000);
        }
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
}

  final public void Constructor() throws ParseException {/*@bgen(jjtree) ConstructorNode */
  ASTConstructorNode jjtn000 = new ASTConstructorNode(JJTCONSTRUCTORNODE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      if (jj_2_78(2)) {
        jj_consume_token(NEW);
        jj_consume_token(LPAREN);
        Expression();
        label_24:
        while (true) {
          switch (jj_nt.kind) {
          case COMMA:{
            break;
            }
          default:
            break label_24;
          }
          jj_consume_token(COMMA);
          Expression();
        }
        jj_consume_token(RPAREN);
      } else {
        switch (jj_nt.kind) {
        case NEW:{
          jj_consume_token(NEW);
          QualifiedIdentifier();
          jj_consume_token(LPAREN);
          if (jj_2_77(1)) {
            Expression();
            label_25:
            while (true) {
              switch (jj_nt.kind) {
              case COMMA:{
                break;
                }
              default:
                break label_25;
              }
              jj_consume_token(COMMA);
              Expression();
            }
          } else {
            ;
          }
          jj_consume_token(RPAREN);
          break;
          }
        default:
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    } catch (Throwable jjte000) {
if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof ParseException) {
      throw (ParseException)jjte000;
    }
    if (jjte000 instanceof RuntimeException) {
      throw (RuntimeException)jjte000;
    }
    throw (Error)jjte000;
    } finally {
if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      if (jjtree.nodeCreated()) {
       jjtreeCloseNodeScope(jjtn000);
      }
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
}

  final public void Parameter() throws ParseException {Token t;
    switch (jj_nt.kind) {
    case VAR:
    case IDENTIFIER:{
      switch (jj_nt.kind) {
      case VAR:{
        jj_consume_token(VAR);
        break;
        }
      default:
        ;
      }
      t = jj_consume_token(IDENTIFIER);
declareParameter(t, false, false);
      break;
      }
    case LET:{
      jj_consume_token(LET);
      t = jj_consume_token(IDENTIFIER);
declareParameter(t, true, false);
      break;
      }
    case CONST:{
      jj_consume_token(CONST);
      t = jj_consume_token(IDENTIFIER);
declareParameter(t, true, true);
      break;
      }
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public void Parameters() throws ParseException {
    jj_consume_token(LPAREN);
    switch (jj_nt.kind) {
    case VAR:
    case LET:
    case CONST:
    case IDENTIFIER:{
      Parameter();
      label_26:
      while (true) {
        switch (jj_nt.kind) {
        case COMMA:{
          break;
          }
        default:
          break label_26;
        }
        jj_consume_token(COMMA);
        Parameter();
      }
      break;
      }
    default:
      ;
    }
    jj_consume_token(RPAREN);
}

  final public void ParametersLookahead() throws ParseException {
    jj_consume_token(LPAREN);
    switch (jj_nt.kind) {
    case VAR:
    case LET:
    case CONST:
    case IDENTIFIER:{
      switch (jj_nt.kind) {
      case VAR:
      case LET:
      case CONST:{
        switch (jj_nt.kind) {
        case VAR:{
          jj_consume_token(VAR);
          break;
          }
        case LET:{
          jj_consume_token(LET);
          break;
          }
        case CONST:{
          jj_consume_token(CONST);
          break;
          }
        default:
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        ;
      }
      jj_consume_token(IDENTIFIER);
      label_27:
      while (true) {
        switch (jj_nt.kind) {
        case COMMA:{
          break;
          }
        default:
          break label_27;
        }
        jj_consume_token(COMMA);
        switch (jj_nt.kind) {
        case VAR:
        case LET:
        case CONST:{
          switch (jj_nt.kind) {
          case VAR:{
            jj_consume_token(VAR);
            break;
            }
          case LET:{
            jj_consume_token(LET);
            break;
            }
          case CONST:{
            jj_consume_token(CONST);
            break;
            }
          default:
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
          }
        default:
          ;
        }
        jj_consume_token(IDENTIFIER);
      }
      break;
      }
    default:
      ;
    }
    jj_consume_token(RPAREN);
}

  final public void LambdaLookahead() throws ParseException {
    switch (jj_nt.kind) {
    case FUNCTION:{
      jj_consume_token(FUNCTION);
      ParametersLookahead();
      break;
      }
    case LPAREN:{
      ParametersLookahead();
      switch (jj_nt.kind) {
      case LAMBDA:{
        jj_consume_token(LAMBDA);
        break;
        }
      case FATARROW:{
        jj_consume_token(FATARROW);
        break;
        }
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case IDENTIFIER:{
      jj_consume_token(IDENTIFIER);
      switch (jj_nt.kind) {
      case LAMBDA:{
        jj_consume_token(LAMBDA);
        break;
        }
      case FATARROW:{
        jj_consume_token(FATARROW);
        break;
        }
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public void Lambda() throws ParseException {/*@bgen(jjtree) JexlLambda */
   ASTJexlLambda jjtn000 = new ASTJexlLambda(JJTJEXLLAMBDA);
   boolean jjtc000 = true;
   jjtree.openNodeScope(jjtn000);
   jjtreeOpenNodeScope(jjtn000);
   jjtn000.jjtSetFirstToken(getToken(1));Token arrow;
   Token name;
    try {
      switch (jj_nt.kind) {
      case FUNCTION:{
        jj_consume_token(FUNCTION);
        if (jj_2_79(2147483647)) {
          DeclareFunction();
        } else {
          ;
        }
pushScope(); pushUnit(jjtn000);
        Parameters();
        if (jj_2_80(3)) {
          Block();
        } else if (jj_2_81(1)) {
          Expression();
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
jjtree.closeNodeScope(jjtn000, true);
                                                                                           jjtc000 = false;
                                                                                           if (jjtree.nodeCreated()) {
                                                                                            jjtreeCloseNodeScope(jjtn000);
                                                                                           }
                                                                                           jjtn000.jjtSetLastToken(getToken(0));
popUnit(jjtn000); popScope();
        break;
        }
      case LPAREN:{
pushScope(); pushUnit(jjtn000);
        Parameters();
        switch (jj_nt.kind) {
        case LAMBDA:{
          arrow = jj_consume_token(LAMBDA);
          break;
          }
        case FATARROW:{
          arrow = jj_consume_token(FATARROW);
          break;
          }
        default:
          jj_consume_token(-1);
          throw new ParseException();
        }
        if (jj_2_82(3)) {
          Block();
        } else if (jj_2_83(1)) {
          Expression();
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
jjtree.closeNodeScope(jjtn000, true);
                                                                                                                                jjtc000 = false;
                                                                                                                                if (jjtree.nodeCreated()) {
                                                                                                                                 jjtreeCloseNodeScope(jjtn000);
                                                                                                                                }
                                                                                                                                jjtn000.jjtSetLastToken(getToken(0));
checkLambda(arrow); popUnit(jjtn000); popScope();
        break;
        }
      case VAR:
      case LET:
      case CONST:
      case IDENTIFIER:{
pushScope(); pushUnit(jjtn000);
        Parameter();
        switch (jj_nt.kind) {
        case LAMBDA:{
          arrow = jj_consume_token(LAMBDA);
          break;
          }
        case FATARROW:{
          arrow = jj_consume_token(FATARROW);
          break;
          }
        default:
          jj_consume_token(-1);
          throw new ParseException();
        }
        if (jj_2_84(3)) {
          Block();
        } else if (jj_2_85(1)) {
          Expression();
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
jjtree.closeNodeScope(jjtn000, true);
                                                                                                                              jjtc000 = false;
                                                                                                                              if (jjtree.nodeCreated()) {
                                                                                                                               jjtreeCloseNodeScope(jjtn000);
                                                                                                                              }
                                                                                                                              jjtn000.jjtSetLastToken(getToken(0));
checkLambda(arrow); popUnit(jjtn000); popScope();
        break;
        }
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (Throwable jjte000) {
if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof ParseException) {
      throw (ParseException)jjte000;
    }
    if (jjte000 instanceof RuntimeException) {
      throw (RuntimeException)jjte000;
    }
    throw (Error)jjte000;
    } finally {
if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      if (jjtree.nodeCreated()) {
       jjtreeCloseNodeScope(jjtn000);
      }
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
}

/***************************************
 *     References
 ***************************************/
  final public 
void IdentifierAccess() throws ParseException {Token t;
    switch (jj_nt.kind) {
    case DOT:{
      jj_consume_token(DOT);
      switch (jj_nt.kind) {
      case DOT_IDENTIFIER:{
        t = jj_consume_token(DOT_IDENTIFIER);
ASTIdentifierAccess jjtn001 = new ASTIdentifierAccess(JJTIDENTIFIERACCESS);
                             boolean jjtc001 = true;
                             jjtree.openNodeScope(jjtn001);
                             jjtreeOpenNodeScope(jjtn001);
                             jjtn001.jjtSetFirstToken(getToken(1));
        try {
jjtree.closeNodeScope(jjtn001, true);
                             jjtc001 = false;
                             if (jjtree.nodeCreated()) {
                              jjtreeCloseNodeScope(jjtn001);
                             }
                             jjtn001.jjtSetLastToken(getToken(0));
jjtn001.setIdentifier(t.image);
        } finally {
if (jjtc001) {
                               jjtree.closeNodeScope(jjtn001, true);
                               if (jjtree.nodeCreated()) {
                                jjtreeCloseNodeScope(jjtn001);
                               }
                               jjtn001.jjtSetLastToken(getToken(0));
                             }
        }
        break;
        }
      case STRING_LITERAL:{
        t = jj_consume_token(STRING_LITERAL);
ASTIdentifierAccess jjtn002 = new ASTIdentifierAccess(JJTIDENTIFIERACCESS);
                             boolean jjtc002 = true;
                             jjtree.openNodeScope(jjtn002);
                             jjtreeOpenNodeScope(jjtn002);
                             jjtn002.jjtSetFirstToken(getToken(1));
        try {
jjtree.closeNodeScope(jjtn002, true);
                             jjtc002 = false;
                             if (jjtree.nodeCreated()) {
                              jjtreeCloseNodeScope(jjtn002);
                             }
                             jjtn002.jjtSetLastToken(getToken(0));
jjtn002.setIdentifier(Parser.buildString(t.image, true));
        } finally {
if (jjtc002) {
                               jjtree.closeNodeScope(jjtn002, true);
                               if (jjtree.nodeCreated()) {
                                jjtreeCloseNodeScope(jjtn002);
                               }
                               jjtn002.jjtSetLastToken(getToken(0));
                             }
        }
        break;
        }
      case JXLT_LITERAL:{
        t = jj_consume_token(JXLT_LITERAL);
ASTIdentifierAccessJxlt jjtn003 = new ASTIdentifierAccessJxlt(JJTIDENTIFIERACCESSJXLT);
                           boolean jjtc003 = true;
                           jjtree.openNodeScope(jjtn003);
                           jjtreeOpenNodeScope(jjtn003);
                           jjtn003.jjtSetFirstToken(getToken(1));
        try {
jjtree.closeNodeScope(jjtn003, true);
                           jjtc003 = false;
                           if (jjtree.nodeCreated()) {
                            jjtreeCloseNodeScope(jjtn003);
                           }
                           jjtn003.jjtSetLastToken(getToken(0));
jjtn003.setIdentifier(Parser.buildString(t.image, true));
        } finally {
if (jjtc003) {
                             jjtree.closeNodeScope(jjtn003, true);
                             if (jjtree.nodeCreated()) {
                              jjtreeCloseNodeScope(jjtn003);
                             }
                             jjtn003.jjtSetLastToken(getToken(0));
                           }
        }
        break;
        }
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case QDOT:{
      jj_consume_token(QDOT);
      switch (jj_nt.kind) {
      case DOT_IDENTIFIER:{
        t = jj_consume_token(DOT_IDENTIFIER);
ASTIdentifierAccessSafe jjtn004 = new ASTIdentifierAccessSafe(JJTIDENTIFIERACCESSSAFE);
                             boolean jjtc004 = true;
                             jjtree.openNodeScope(jjtn004);
                             jjtreeOpenNodeScope(jjtn004);
                             jjtn004.jjtSetFirstToken(getToken(1));
        try {
jjtree.closeNodeScope(jjtn004, true);
                             jjtc004 = false;
                             if (jjtree.nodeCreated()) {
                              jjtreeCloseNodeScope(jjtn004);
                             }
                             jjtn004.jjtSetLastToken(getToken(0));
jjtn004.setIdentifier(t.image);
        } finally {
if (jjtc004) {
                               jjtree.closeNodeScope(jjtn004, true);
                               if (jjtree.nodeCreated()) {
                                jjtreeCloseNodeScope(jjtn004);
                               }
                               jjtn004.jjtSetLastToken(getToken(0));
                             }
        }
        break;
        }
      case STRING_LITERAL:{
        t = jj_consume_token(STRING_LITERAL);
ASTIdentifierAccessSafe jjtn005 = new ASTIdentifierAccessSafe(JJTIDENTIFIERACCESSSAFE);
                             boolean jjtc005 = true;
                             jjtree.openNodeScope(jjtn005);
                             jjtreeOpenNodeScope(jjtn005);
                             jjtn005.jjtSetFirstToken(getToken(1));
        try {
jjtree.closeNodeScope(jjtn005, true);
                             jjtc005 = false;
                             if (jjtree.nodeCreated()) {
                              jjtreeCloseNodeScope(jjtn005);
                             }
                             jjtn005.jjtSetLastToken(getToken(0));
jjtn005.setIdentifier(Parser.buildString(t.image, true));
        } finally {
if (jjtc005) {
                               jjtree.closeNodeScope(jjtn005, true);
                               if (jjtree.nodeCreated()) {
                                jjtreeCloseNodeScope(jjtn005);
                               }
                               jjtn005.jjtSetLastToken(getToken(0));
                             }
        }
        break;
        }
      case JXLT_LITERAL:{
        t = jj_consume_token(JXLT_LITERAL);
ASTIdentifierAccessSafeJxlt jjtn006 = new ASTIdentifierAccessSafeJxlt(JJTIDENTIFIERACCESSSAFEJXLT);
                           boolean jjtc006 = true;
                           jjtree.openNodeScope(jjtn006);
                           jjtreeOpenNodeScope(jjtn006);
                           jjtn006.jjtSetFirstToken(getToken(1));
        try {
jjtree.closeNodeScope(jjtn006, true);
                           jjtc006 = false;
                           if (jjtree.nodeCreated()) {
                            jjtreeCloseNodeScope(jjtn006);
                           }
                           jjtn006.jjtSetLastToken(getToken(0));
jjtn006.setIdentifier(Parser.buildString(t.image, true));
        } finally {
if (jjtc006) {
                             jjtree.closeNodeScope(jjtn006, true);
                             if (jjtree.nodeCreated()) {
                              jjtreeCloseNodeScope(jjtn006);
                             }
                             jjtn006.jjtSetLastToken(getToken(0));
                           }
        }
        break;
        }
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public void ArrayAccess() throws ParseException {/*@bgen(jjtree) ArrayAccess */
 ASTArrayAccess jjtn000 = new ASTArrayAccess(JJTARRAYACCESS);
 boolean jjtc000 = true;
 jjtree.openNodeScope(jjtn000);
 jjtreeOpenNodeScope(jjtn000);
 jjtn000.jjtSetFirstToken(getToken(1));long safe = 0L;
 int s = 0;
    try {
      label_28:
      while (true) {
        switch (jj_nt.kind) {
        case LBRACKET:{
          jj_consume_token(LBRACKET);
          break;
          }
        case QLBRACKET:{
          jj_consume_token(QLBRACKET);
safe |= (1 << s++);
          break;
          }
        default:
          jj_consume_token(-1);
          throw new ParseException();
        }
        Expression();
        jj_consume_token(RBRACKET);
        if (jj_2_86(2)) {
        } else {
          break label_28;
        }
      }
jjtree.closeNodeScope(jjtn000, true);
                                                                                               jjtc000 = false;
                                                                                               if (jjtree.nodeCreated()) {
                                                                                                jjtreeCloseNodeScope(jjtn000);
                                                                                               }
                                                                                               jjtn000.jjtSetLastToken(getToken(0));
jjtn000.setSafe(safe);
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof ParseException) {
        throw (ParseException)jjte000;
      }
      if (jjte000 instanceof RuntimeException) {
        throw (RuntimeException)jjte000;
      }
      throw (Error)jjte000;
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        if (jjtree.nodeCreated()) {
         jjtreeCloseNodeScope(jjtn000);
        }
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
}

  final public void MemberAccess() throws ParseException {
    if (jj_2_87(2147483647)) {
      ArrayAccess();
    } else if (jj_2_88(2147483647)) {
      IdentifierAccess();
    } else if (jj_2_89(2147483647)) {
      IdentifierAccess();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public void ReferenceExpression() throws ParseException {/*@bgen(jjtree) #MethodNode(> 1) */
  ASTMethodNode jjtn000 = new ASTMethodNode(JJTMETHODNODE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(LPAREN);
      Expression();
ASTReferenceExpression jjtn001 = new ASTReferenceExpression(JJTREFERENCEEXPRESSION);
                            boolean jjtc001 = true;
                            jjtree.openNodeScope(jjtn001);
                            jjtreeOpenNodeScope(jjtn001);
                            jjtn001.jjtSetFirstToken(getToken(1));
      try {
        jj_consume_token(RPAREN);
      } finally {
if (jjtc001) {
                              jjtree.closeNodeScope(jjtn001,  1);
                              if (jjtree.nodeCreated()) {
                               jjtreeCloseNodeScope(jjtn001);
                              }
                              jjtn001.jjtSetLastToken(getToken(0));
                            }
      }
      label_29:
      while (true) {
        if (jj_2_90(2147483647)) {
        } else {
          break label_29;
        }
        Arguments();
      }
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof ParseException) {
        throw (ParseException)jjte000;
      }
      if (jjte000 instanceof RuntimeException) {
        throw (RuntimeException)jjte000;
      }
      throw (Error)jjte000;
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, jjtree.nodeArity() >  1);
        if (jjtree.nodeCreated()) {
         jjtreeCloseNodeScope(jjtn000);
        }
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
}

  final public void PrimaryExpression() throws ParseException {
    if (jj_2_91(2147483647)) {
      Lambda();
    } else if (jj_2_92(2147483647)) {
      ReferenceExpression();
    } else if (jj_2_93(2147483647)) {
      MapLiteral();
    } else if (jj_2_94(2147483647)) {
      MapLiteral();
    } else if (jj_2_95(2147483647)) {
      SetLiteral();
    } else if (jj_2_96(2147483647)) {
      SetLiteral();
    } else if (jj_2_97(2147483647)) {
      ArrayLiteral();
    } else if (jj_2_98(2147483647)) {
      Constructor();
    } else if (jj_2_99(2147483647)) {
      FunctionCall();
    } else {
      switch (jj_nt.kind) {
      case IDENTIFIER:
      case REGISTER:{
        Identifier(true);
        break;
        }
      case NULL:
      case TRUE:
      case FALSE:
      case NAN_LITERAL:
      case INTEGER_LITERAL:
      case FLOAT_LITERAL:
      case STRING_LITERAL:
      case JXLT_LITERAL:
      case REGEX_LITERAL:{
        Literal();
        break;
        }
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
}

  final public void MethodCall() throws ParseException {
ASTMethodNode jjtn001 = new ASTMethodNode(JJTMETHODNODE);
      boolean jjtc001 = true;
      jjtree.openNodeScope(jjtn001);
      jjtreeOpenNodeScope(jjtn001);
      jjtn001.jjtSetFirstToken(getToken(1));
    try {
      MemberAccess();
      label_30:
      while (true) {
        Arguments();
        if (jj_2_100(2147483647)) {
        } else {
          break label_30;
        }
      }
    } catch (Throwable jjte001) {
if (jjtc001) {
        jjtree.clearNodeScope(jjtn001);
        jjtc001 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte001 instanceof ParseException) {
        throw (ParseException)jjte001;
      }
      if (jjte001 instanceof RuntimeException) {
        throw (RuntimeException)jjte001;
      }
      throw (Error)jjte001;
    } finally {
if (jjtc001) {
        jjtree.closeNodeScope(jjtn001, jjtree.nodeArity() >  1);
        if (jjtree.nodeCreated()) {
         jjtreeCloseNodeScope(jjtn001);
        }
        jjtn001.jjtSetLastToken(getToken(0));
      }
    }
}

  final public void MethodCallLookahead() throws ParseException {
    MemberAccess();
    jj_consume_token(LPAREN);
}

  final public void MemberExpression() throws ParseException {
    if (jj_2_101(2147483647)) {
      MethodCall();
    } else {
      switch (jj_nt.kind) {
      case LBRACKET:
      case QLBRACKET:
      case DOT:
      case QDOT:{
        MemberAccess();
        break;
        }
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
}

  final public void ValueExpression() throws ParseException {
ASTReference jjtn001 = new ASTReference(JJTREFERENCE);
      boolean jjtc001 = true;
      jjtree.openNodeScope(jjtn001);
      jjtreeOpenNodeScope(jjtn001);
      jjtn001.jjtSetFirstToken(getToken(1));
    try {
      PrimaryExpression();
      label_31:
      while (true) {
        if (jj_2_102(2)) {
        } else {
          break label_31;
        }
        MemberExpression();
      }
    } catch (Throwable jjte001) {
if (jjtc001) {
        jjtree.clearNodeScope(jjtn001);
        jjtc001 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte001 instanceof ParseException) {
        throw (ParseException)jjte001;
      }
      if (jjte001 instanceof RuntimeException) {
        throw (RuntimeException)jjte001;
      }
      throw (Error)jjte001;
    } finally {
if (jjtc001) {
        jjtree.closeNodeScope(jjtn001, jjtree.nodeArity() >  1);
        if (jjtree.nodeCreated()) {
         jjtreeCloseNodeScope(jjtn001);
        }
        jjtn001.jjtSetLastToken(getToken(0));
      }
    }
}

  private boolean jj_2_1(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_1()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_2(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_2()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_3(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_3()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_4(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_4()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_5(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_5()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_6(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_6()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_7(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_7()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_8(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_8()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_9(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_9()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_10(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_10()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_11(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_11()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_12(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_12()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_13(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_13()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_14(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_14()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_15(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_15()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_16(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_16()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_17(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_17()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_18(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_18()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_19(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_19()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_20(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_20()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_21(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_21()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_22(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_22()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_23(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_23()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_24(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_24()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_25(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_25()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_26(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_26()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_27(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_27()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_28(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_28()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_29(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_29()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_30(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_30()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_31(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_31()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_32(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_32()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_33(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_33()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_34(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_34()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_35(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_35()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_36(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_36()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_37(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_37()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_38(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_38()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_39(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_39()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_40(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_40()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_41(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_41()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_42(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_42()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_43(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_43()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_44(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_44()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_45(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_45()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_46(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_46()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_47(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_47()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_48(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_48()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_49(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_49()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_50(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_50()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_51(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_51()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_52(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_52()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_53(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_53()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_54(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_54()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_55(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_55()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_56(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_56()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_57(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_57()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_58(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_58()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_59(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_59()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_60(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_60()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_61(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_61()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_62(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_62()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_63(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_63()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_64(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_64()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_65(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_65()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_66(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_66()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_67(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_67()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_68(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_68()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_69(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_69()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_70(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_70()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_71(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_71()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_72(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_72()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_73(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_73()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_74(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_74()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_75(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_75()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_76(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_76()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_77(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_77()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_78(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_78()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_79(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_79()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_80(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_80()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_81(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_81()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_82(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_82()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_83(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_83()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_84(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_84()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_85(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_85()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_86(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_86()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_87(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_87()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_88(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_88()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_89(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_89()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_90(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_90()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_91(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_91()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_92(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_92()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_93(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_93()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_94(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_94()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_95(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_95()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_96(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_96()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_97(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_97()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_98(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_98()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_99(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_99()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_100(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_100()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_101(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_101()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_102(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_102()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_3R_192()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_205()) {
    jj_scanpos = xsp;
    if (jj_3R_206()) {
    jj_scanpos = xsp;
    if (jj_3R_207()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_205()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(101)) jj_scanpos = xsp;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_206()
 {
    if (jj_scan_token(LET)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_207()
 {
    if (jj_scan_token(CONST)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_191()
 {
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_247()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_153()
 {
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_176()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_36()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_116()) {
    jj_scanpos = xsp;
    if (jj_3R_117()) {
    jj_scanpos = xsp;
    if (jj_3R_118()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_116()
 {
    if (jj_scan_token(FUNCTION)) return true;
    if (jj_3R_153()) return true;
    return false;
  }

  private boolean jj_3R_117()
 {
    if (jj_3R_153()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(86)) {
    jj_scanpos = xsp;
    if (jj_scan_token(87)) return true;
    }
    return false;
  }

  private boolean jj_3R_247()
 {
    if (jj_3R_192()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_266()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_118()
 {
    if (jj_scan_token(IDENTIFIER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(86)) {
    jj_scanpos = xsp;
    if (jj_scan_token(87)) return true;
    }
    return false;
  }

  private boolean jj_3R_176()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_193()) jj_scanpos = xsp;
    if (jj_scan_token(IDENTIFIER)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_194()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_193()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(101)) {
    jj_scanpos = xsp;
    if (jj_scan_token(102)) {
    jj_scanpos = xsp;
    if (jj_scan_token(103)) return true;
    }
    }
    return false;
  }

  private boolean jj_3_77()
 {
    if (jj_3R_34()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_265()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_152()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_173()) {
    jj_scanpos = xsp;
    if (jj_3R_174()) {
    jj_scanpos = xsp;
    if (jj_3R_175()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_173()
 {
    if (jj_scan_token(FUNCTION)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_245()) jj_scanpos = xsp;
    if (jj_3R_191()) return true;
    xsp = jj_scanpos;
    if (jj_3_80()) {
    jj_scanpos = xsp;
    if (jj_3_81()) return true;
    }
    return false;
  }

  private boolean jj_3R_259()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_34()) return true;
    return false;
  }

  private boolean jj_3R_174()
 {
    if (jj_3R_191()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(86)) {
    jj_scanpos = xsp;
    if (jj_scan_token(87)) return true;
    }
    xsp = jj_scanpos;
    if (jj_3_82()) {
    jj_scanpos = xsp;
    if (jj_3_83()) return true;
    }
    return false;
  }

  private boolean jj_3R_266()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_192()) return true;
    return false;
  }

  private boolean jj_3R_175()
 {
    if (jj_3R_192()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(86)) {
    jj_scanpos = xsp;
    if (jj_scan_token(87)) return true;
    }
    xsp = jj_scanpos;
    if (jj_3_84()) {
    jj_scanpos = xsp;
    if (jj_3_85()) return true;
    }
    return false;
  }

  private boolean jj_3R_245()
 {
    if (jj_3R_228()) return true;
    return false;
  }

  private boolean jj_3R_265()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_34()) return true;
    return false;
  }

  private boolean jj_3R_189()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_203()) {
    jj_scanpos = xsp;
    if (jj_3R_204()) return true;
    }
    return false;
  }

  private boolean jj_3R_203()
 {
    if (jj_scan_token(DOT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_222()) {
    jj_scanpos = xsp;
    if (jj_3R_223()) {
    jj_scanpos = xsp;
    if (jj_3R_224()) return true;
    }
    }
    return false;
  }

  private boolean jj_3_79()
 {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_222()
 {
    if (jj_scan_token(DOT_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_223()
 {
    if (jj_scan_token(STRING_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_204()
 {
    if (jj_scan_token(QDOT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_225()) {
    jj_scanpos = xsp;
    if (jj_3R_226()) {
    jj_scanpos = xsp;
    if (jj_3R_227()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_224()
 {
    if (jj_scan_token(JXLT_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_194()
 {
    if (jj_scan_token(COMMA)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_208()) jj_scanpos = xsp;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_225()
 {
    if (jj_scan_token(DOT_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_226()
 {
    if (jj_scan_token(STRING_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_227()
 {
    if (jj_scan_token(JXLT_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_208()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(101)) {
    jj_scanpos = xsp;
    if (jj_scan_token(102)) {
    jj_scanpos = xsp;
    if (jj_scan_token(103)) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_188()
 {
    Token xsp;
    if (jj_3_86()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_86()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_86()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(18)) {
    jj_scanpos = xsp;
    if (jj_3R_94()) return true;
    }
    if (jj_3R_34()) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_137()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_167()) {
    jj_scanpos = xsp;
    if (jj_3R_168()) {
    jj_scanpos = xsp;
    if (jj_3R_169()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_167()
 {
    if (jj_3R_188()) return true;
    return false;
  }

  private boolean jj_3R_168()
 {
    if (jj_3R_189()) return true;
    return false;
  }

  private boolean jj_3_80()
 {
    if (jj_3R_38()) return true;
    return false;
  }

  private boolean jj_3R_169()
 {
    if (jj_3R_189()) return true;
    return false;
  }

  private boolean jj_3R_196()
 {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_34()) return true;
    if (jj_scan_token(RPAREN)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_253()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_87()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(18)) {
    jj_scanpos = xsp;
    if (jj_scan_token(19)) return true;
    }
    return false;
  }

  private boolean jj_3_88()
 {
    if (jj_scan_token(DOT)) return true;
    return false;
  }

  private boolean jj_3_89()
 {
    if (jj_scan_token(QDOT)) return true;
    return false;
  }

  private boolean jj_3R_166()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_177()) {
    jj_scanpos = xsp;
    if (jj_3R_178()) {
    jj_scanpos = xsp;
    if (jj_3R_179()) {
    jj_scanpos = xsp;
    if (jj_3R_180()) {
    jj_scanpos = xsp;
    if (jj_3R_181()) {
    jj_scanpos = xsp;
    if (jj_3R_182()) {
    jj_scanpos = xsp;
    if (jj_3R_183()) {
    jj_scanpos = xsp;
    if (jj_3R_184()) {
    jj_scanpos = xsp;
    if (jj_3R_185()) {
    jj_scanpos = xsp;
    if (jj_3R_186()) {
    jj_scanpos = xsp;
    if (jj_3R_187()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_177()
 {
    if (jj_3R_152()) return true;
    return false;
  }

  private boolean jj_3R_178()
 {
    if (jj_3R_196()) return true;
    return false;
  }

  private boolean jj_3R_94()
 {
    if (jj_scan_token(QLBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_179()
 {
    if (jj_3R_197()) return true;
    return false;
  }

  private boolean jj_3R_180()
 {
    if (jj_3R_197()) return true;
    return false;
  }

  private boolean jj_3R_181()
 {
    if (jj_3R_198()) return true;
    return false;
  }

  private boolean jj_3_81()
 {
    if (jj_3R_34()) return true;
    return false;
  }

  private boolean jj_3R_182()
 {
    if (jj_3R_198()) return true;
    return false;
  }

  private boolean jj_3_91()
 {
    if (jj_3R_36()) return true;
    return false;
  }

  private boolean jj_3R_183()
 {
    if (jj_3R_199()) return true;
    return false;
  }

  private boolean jj_3_92()
 {
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_184()
 {
    if (jj_3R_200()) return true;
    return false;
  }

  private boolean jj_3_93()
 {
    if (jj_scan_token(LCURLY)) return true;
    if (jj_3R_34()) return true;
    if (jj_scan_token(COLON)) return true;
    return false;
  }

  private boolean jj_3R_185()
 {
    if (jj_3R_201()) return true;
    return false;
  }

  private boolean jj_3_94()
 {
    if (jj_scan_token(LCURLY)) return true;
    if (jj_scan_token(COLON)) return true;
    return false;
  }

  private boolean jj_3R_186()
 {
    if (jj_3R_93()) return true;
    return false;
  }

  private boolean jj_3_95()
 {
    if (jj_scan_token(LCURLY)) return true;
    if (jj_3R_34()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(23)) {
    jj_scanpos = xsp;
    if (jj_scan_token(17)) return true;
    }
    return false;
  }

  private boolean jj_3R_187()
 {
    if (jj_3R_202()) return true;
    return false;
  }

  private boolean jj_3_96()
 {
    if (jj_scan_token(LCURLY)) return true;
    if (jj_scan_token(RCURLY)) return true;
    return false;
  }

  private boolean jj_3R_170()
 {
    if (jj_3R_137()) return true;
    Token xsp;
    if (jj_3R_261()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_261()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_97()
 {
    if (jj_scan_token(LBRACKET)) return true;
    return false;
  }

  private boolean jj_3_82()
 {
    if (jj_3R_38()) return true;
    return false;
  }

  private boolean jj_3_84()
 {
    if (jj_3R_38()) return true;
    return false;
  }

  private boolean jj_3_98()
 {
    if (jj_scan_token(NEW)) return true;
    return false;
  }

  private boolean jj_3_99()
 {
    if (jj_3R_95()) return true;
    return false;
  }

  private boolean jj_3R_96()
 {
    if (jj_3R_137()) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_97()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_138()) {
    jj_scanpos = xsp;
    if (jj_3R_139()) return true;
    }
    return false;
  }

  private boolean jj_3R_138()
 {
    if (jj_3R_170()) return true;
    return false;
  }

  private boolean jj_3R_133()
 {
    if (jj_3R_166()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_102()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_261()
 {
    if (jj_3R_248()) return true;
    return false;
  }

  private boolean jj_3_101()
 {
    if (jj_3R_96()) return true;
    return false;
  }

  private boolean jj_3_83()
 {
    if (jj_3R_34()) return true;
    return false;
  }

  private boolean jj_3_85()
 {
    if (jj_3R_34()) return true;
    return false;
  }

  private boolean jj_3_100()
 {
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_253()
 {
    if (jj_3R_248()) return true;
    return false;
  }

  private boolean jj_3_90()
 {
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3_102()
 {
    if (jj_3R_97()) return true;
    return false;
  }

  private boolean jj_3R_139()
 {
    if (jj_3R_137()) return true;
    return false;
  }

  private boolean jj_3_1()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_32()) {
    jj_scanpos = xsp;
    if (jj_3_3()) return true;
    }
    return false;
  }

  private boolean jj_3R_32()
 {
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3_2()
 {
    if (jj_scan_token(PRAGMA)) return true;
    return false;
  }

  private boolean jj_3R_190()
 {
    if (jj_scan_token(ANNOTATION)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_246()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_142()
 {
    Token xsp;
    if (jj_3R_172()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_172()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_240()) {
    jj_scanpos = xsp;
    if (jj_3_7()) return true;
    }
    return false;
  }

  private boolean jj_3R_172()
 {
    if (jj_3R_190()) return true;
    return false;
  }

  private boolean jj_3R_33()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_99()) {
    jj_scanpos = xsp;
    if (jj_3R_100()) {
    jj_scanpos = xsp;
    if (jj_3_10()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_99()
 {
    if (jj_3R_40()) return true;
    return false;
  }

  private boolean jj_3_3()
 {
    if (jj_3R_33()) return true;
    return false;
  }

  private boolean jj_3R_100()
 {
    if (jj_3R_140()) return true;
    return false;
  }

  private boolean jj_3_10()
 {
    if (jj_3R_35()) return true;
    return false;
  }

  private boolean jj_3_6()
 {
    if (jj_scan_token(ANNOTATION)) return true;
    return false;
  }

  private boolean jj_3R_35()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(21)) {
    jj_scanpos = xsp;
    if (jj_3R_102()) {
    jj_scanpos = xsp;
    if (jj_3R_103()) {
    jj_scanpos = xsp;
    if (jj_3R_104()) {
    jj_scanpos = xsp;
    if (jj_3R_105()) {
    jj_scanpos = xsp;
    if (jj_3R_106()) {
    jj_scanpos = xsp;
    if (jj_3R_107()) {
    jj_scanpos = xsp;
    if (jj_3R_108()) {
    jj_scanpos = xsp;
    if (jj_3R_109()) {
    jj_scanpos = xsp;
    if (jj_3R_110()) {
    jj_scanpos = xsp;
    if (jj_3R_111()) {
    jj_scanpos = xsp;
    if (jj_3R_112()) {
    jj_scanpos = xsp;
    if (jj_3R_113()) {
    jj_scanpos = xsp;
    if (jj_3R_114()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = !getFeatures().isLexical();
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_115()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_8()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(102)) {
    jj_scanpos = xsp;
    if (jj_scan_token(103)) {
    jj_scanpos = xsp;
    if (jj_scan_token(101)) return true;
    }
    }
    return false;
  }

  private boolean jj_3_9()
 {
    if (jj_scan_token(FUNCTION)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_102()
 {
    if (jj_3R_142()) return true;
    return false;
  }

  private boolean jj_3R_103()
 {
    if (jj_3R_143()) return true;
    return false;
  }

  private boolean jj_3R_104()
 {
    if (jj_3R_144()) return true;
    return false;
  }

  private boolean jj_3R_105()
 {
    if (jj_3R_145()) return true;
    return false;
  }

  private boolean jj_3R_106()
 {
    if (jj_3R_146()) return true;
    return false;
  }

  private boolean jj_3R_107()
 {
    if (jj_3R_147()) return true;
    return false;
  }

  private boolean jj_3R_108()
 {
    if (jj_3R_148()) return true;
    return false;
  }

  private boolean jj_3R_109()
 {
    if (jj_3R_149()) return true;
    return false;
  }

  private boolean jj_3R_110()
 {
    if (jj_3R_150()) return true;
    return false;
  }

  private boolean jj_3R_111()
 {
    if (jj_3R_151()) return true;
    return false;
  }

  private boolean jj_3_4()
 {
    if (jj_3R_34()) return true;
    return false;
  }

  private boolean jj_3_11()
 {
    if (jj_scan_token(ANNOTATION)) return true;
    return false;
  }

  private boolean jj_3R_112()
 {
    if (jj_3R_152()) return true;
    return false;
  }

  private boolean jj_3_12()
 {
    if (jj_scan_token(IF)) return true;
    return false;
  }

  private boolean jj_3R_113()
 {
    if (jj_3R_41()) return true;
    return false;
  }

  private boolean jj_3_13()
 {
    if (jj_scan_token(FOR)) return true;
    return false;
  }

  private boolean jj_3R_114()
 {
    if (jj_3R_38()) return true;
    return false;
  }

  private boolean jj_3_14()
 {
    if (jj_scan_token(WHILE)) return true;
    return false;
  }

  private boolean jj_3R_115()
 {
    if (jj_3R_40()) return true;
    return false;
  }

  private boolean jj_3_15()
 {
    if (jj_scan_token(DO)) return true;
    return false;
  }

  private boolean jj_3_16()
 {
    if (jj_scan_token(RETURN)) return true;
    return false;
  }

  private boolean jj_3_17()
 {
    if (jj_scan_token(CONTINUE)) return true;
    return false;
  }

  private boolean jj_3R_38()
 {
    if (jj_scan_token(LCURLY)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_24()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RCURLY)) return true;
    return false;
  }

  private boolean jj_3_18()
 {
    if (jj_scan_token(BREAK)) return true;
    return false;
  }

  private boolean jj_3R_140()
 {
    if (jj_scan_token(FUNCTION)) return true;
    if (jj_3R_228()) return true;
    if (jj_3R_191()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_27()) {
    jj_scanpos = xsp;
    if (jj_3_28()) return true;
    }
    return false;
  }

  private boolean jj_3_19()
 {
    if (jj_scan_token(THROW)) return true;
    return false;
  }

  private boolean jj_3_20()
 {
    if (jj_scan_token(TRY)) return true;
    return false;
  }

  private boolean jj_3_21()
 {
    if (jj_3R_36()) return true;
    return false;
  }

  private boolean jj_3_22()
 {
    if (jj_3R_34()) return true;
    return false;
  }

  private boolean jj_3_23()
 {
    if (jj_scan_token(VAR)) return true;
    return false;
  }

  private boolean jj_3R_240()
 {
    if (jj_3R_38()) return true;
    return false;
  }

  private boolean jj_3R_246()
 {
    if (jj_3R_248()) return true;
    return false;
  }

  private boolean jj_3R_41()
 {
    if (jj_3R_34()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_123()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_scan_token(21)) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_143()
 {
    if (jj_scan_token(IF)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_34()) return true;
    if (jj_scan_token(RPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_282()) {
    jj_scanpos = xsp;
    if (jj_3_30()) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_31()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_283()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_5()
 {
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3_31()
 {
    if (jj_scan_token(ELSE)) return true;
    if (jj_scan_token(IF)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_34()) return true;
    if (jj_scan_token(RPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_288()) {
    jj_scanpos = xsp;
    if (jj_3_32()) return true;
    }
    return false;
  }

  private boolean jj_3R_283()
 {
    if (jj_scan_token(ELSE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_289()) {
    jj_scanpos = xsp;
    if (jj_3_33()) return true;
    }
    return false;
  }

  private boolean jj_3R_123()
 {
    if (jj_3R_34()) return true;
    return false;
  }

  private boolean jj_3R_151()
 {
    if (jj_scan_token(TRY)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_242()) {
    jj_scanpos = xsp;
    if (jj_3R_243()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_286()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_287()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_286()
 {
    if (jj_scan_token(CATCH)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_43()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_38()) return true;
    return false;
  }

  private boolean jj_3R_287()
 {
    if (jj_scan_token(FINALLY)) return true;
    if (jj_3R_38()) return true;
    return false;
  }

  private boolean jj_3R_244()
 {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_39()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_34()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_scan_token(21)) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_38()) return true;
    return false;
  }

  private boolean jj_3_7()
 {
    if (jj_3R_33()) return true;
    return false;
  }

  private boolean jj_3R_242()
 {
    if (jj_3R_244()) return true;
    return false;
  }

  private boolean jj_3_24()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_37()) {
    jj_scanpos = xsp;
    if (jj_3_26()) return true;
    }
    return false;
  }

  private boolean jj_3_29()
 {
    if (jj_3R_34()) return true;
    return false;
  }

  private boolean jj_3R_37()
 {
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3R_39()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_35()) {
    jj_scanpos = xsp;
    if (jj_3R_119()) return true;
    }
    return false;
  }

  private boolean jj_3_35()
 {
    if (jj_3R_40()) return true;
    return false;
  }

  private boolean jj_3R_289()
 {
    if (jj_3R_38()) return true;
    return false;
  }

  private boolean jj_3_25()
 {
    if (jj_scan_token(PRAGMA)) return true;
    return false;
  }

  private boolean jj_3R_145()
 {
    if (jj_scan_token(WHILE)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_34()) return true;
    if (jj_scan_token(RPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_285()) {
    jj_scanpos = xsp;
    if (jj_3_36()) return true;
    }
    return false;
  }

  private boolean jj_3_34()
 {
    if (jj_scan_token(SEMICOL)) return true;
    if (jj_3R_39()) return true;
    return false;
  }

  private boolean jj_3R_282()
 {
    if (jj_3R_38()) return true;
    return false;
  }

  private boolean jj_3R_146()
 {
    if (jj_scan_token(DO)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_241()) {
    jj_scanpos = xsp;
    if (jj_3_37()) return true;
    }
    if (jj_scan_token(WHILE)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_34()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_147()
 {
    if (jj_scan_token(RETURN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_38()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_119()
 {
    if (jj_3R_93()) return true;
    return false;
  }

  private boolean jj_3R_150()
 {
    if (jj_scan_token(THROW)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_39()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_243()
 {
    if (jj_3R_38()) return true;
    return false;
  }

  private boolean jj_3_33()
 {
    if (jj_3R_35()) return true;
    return false;
  }

  private boolean jj_3_26()
 {
    if (jj_3R_33()) return true;
    return false;
  }

  private boolean jj_3_38()
 {
    if (jj_3R_41()) return true;
    return false;
  }

  private boolean jj_3R_148()
 {
    if (jj_scan_token(CONTINUE)) return true;
    return false;
  }

  private boolean jj_3_39()
 {
    if (jj_3R_41()) return true;
    return false;
  }

  private boolean jj_3_30()
 {
    if (jj_3R_35()) return true;
    return false;
  }

  private boolean jj_3R_288()
 {
    if (jj_3R_38()) return true;
    return false;
  }

  private boolean jj_3R_149()
 {
    if (jj_scan_token(BREAK)) return true;
    return false;
  }

  private boolean jj_3R_241()
 {
    if (jj_3R_38()) return true;
    return false;
  }

  private boolean jj_3_27()
 {
    if (jj_3R_38()) return true;
    return false;
  }

  private boolean jj_3R_144()
 {
    if (jj_scan_token(FOR)) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_44()) {
    jj_scanpos = xsp;
    if (jj_3_45()) return true;
    }
    if (jj_scan_token(RPAREN)) return true;
    xsp = jj_scanpos;
    if (jj_3R_284()) {
    jj_scanpos = xsp;
    if (jj_3_46()) return true;
    }
    return false;
  }

  private boolean jj_3_44()
 {
    if (jj_3R_43()) return true;
    if (jj_scan_token(COLON)) return true;
    if (jj_3R_34()) return true;
    return false;
  }

  private boolean jj_3_45()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_41()) jj_scanpos = xsp;
    if (jj_scan_token(SEMICOL)) return true;
    xsp = jj_scanpos;
    if (jj_3_42()) jj_scanpos = xsp;
    if (jj_scan_token(SEMICOL)) return true;
    xsp = jj_scanpos;
    if (jj_3_43()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_41()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_42()) {
    jj_scanpos = xsp;
    if (jj_3_40()) return true;
    }
    return false;
  }

  private boolean jj_3_42()
 {
    if (jj_3R_34()) return true;
    return false;
  }

  private boolean jj_3R_42()
 {
    if (jj_3R_40()) return true;
    return false;
  }

  private boolean jj_3_32()
 {
    if (jj_3R_35()) return true;
    return false;
  }

  private boolean jj_3_43()
 {
    if (jj_3R_34()) return true;
    return false;
  }

  private boolean jj_3_37()
 {
    if (jj_3R_35()) return true;
    return false;
  }

  private boolean jj_3_28()
 {
    if (jj_3R_34()) return true;
    return false;
  }

  private boolean jj_3R_284()
 {
    if (jj_3R_38()) return true;
    return false;
  }

  private boolean jj_3R_43()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_124()) {
    jj_scanpos = xsp;
    if (jj_3R_125()) {
    jj_scanpos = xsp;
    if (jj_3R_126()) {
    jj_scanpos = xsp;
    if (jj_3R_127()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_124()
 {
    if (jj_scan_token(VAR)) return true;
    if (jj_3R_157()) return true;
    return false;
  }

  private boolean jj_3R_285()
 {
    if (jj_3R_38()) return true;
    return false;
  }

  private boolean jj_3R_125()
 {
    if (jj_scan_token(LET)) return true;
    if (jj_3R_157()) return true;
    return false;
  }

  private boolean jj_3R_126()
 {
    if (jj_scan_token(CONST)) return true;
    if (jj_3R_157()) return true;
    return false;
  }

  private boolean jj_3R_127()
 {
    if (jj_3R_93()) return true;
    return false;
  }

  private boolean jj_3_40()
 {
    if (jj_3R_34()) return true;
    return false;
  }

  private boolean jj_3R_40()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_120()) {
    jj_scanpos = xsp;
    if (jj_3R_121()) {
    jj_scanpos = xsp;
    if (jj_3R_122()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_120()
 {
    if (jj_scan_token(VAR)) return true;
    if (jj_3R_154()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_277()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_121()
 {
    if (jj_scan_token(LET)) return true;
    if (jj_3R_155()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_278()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_122()
 {
    if (jj_scan_token(CONST)) return true;
    if (jj_3R_156()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_279()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_46()
 {
    if (jj_3R_35()) return true;
    return false;
  }

  private boolean jj_3R_154()
 {
    if (jj_3R_157()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_280()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_36()
 {
    if (jj_3R_35()) return true;
    return false;
  }

  private boolean jj_3R_155()
 {
    if (jj_3R_157()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_281()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_156()
 {
    if (jj_3R_157()) return true;
    if (jj_scan_token(assign)) return true;
    if (jj_3R_34()) return true;
    return false;
  }

  private boolean jj_3R_277()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_154()) return true;
    return false;
  }

  private boolean jj_3R_278()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_155()) return true;
    return false;
  }

  private boolean jj_3R_157()
 {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_279()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_156()) return true;
    return false;
  }

  private boolean jj_3R_228()
 {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_280()
 {
    if (jj_scan_token(assign)) return true;
    if (jj_3R_34()) return true;
    return false;
  }

  private boolean jj_3R_98()
 {
    if (jj_scan_token(PRAGMA)) return true;
    if (jj_3R_195()) return true;
    if (jj_3R_270()) return true;
    return false;
  }

  private boolean jj_3R_281()
 {
    if (jj_scan_token(assign)) return true;
    if (jj_3R_34()) return true;
    return false;
  }

  private boolean jj_3R_195()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_209()) {
    jj_scanpos = xsp;
    if (jj_3R_210()) return true;
    }
    return false;
  }

  private boolean jj_3R_209()
 {
    if (jj_scan_token(IDENTIFIER)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_269()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_210()
 {
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(DOT_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_270()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_48()) {
    jj_scanpos = xsp;
    if (jj_3_49()) {
    jj_scanpos = xsp;
    if (jj_3R_271()) {
    jj_scanpos = xsp;
    if (jj_3R_272()) {
    jj_scanpos = xsp;
    if (jj_3R_273()) {
    jj_scanpos = xsp;
    if (jj_3R_274()) {
    jj_scanpos = xsp;
    if (jj_3R_275()) {
    jj_scanpos = xsp;
    if (jj_3R_276()) return true;
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_48()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_44()) jj_scanpos = xsp;
    if (jj_scan_token(INTEGER_LITERAL)) return true;
    return false;
  }

  private boolean jj_3_49()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_45()) jj_scanpos = xsp;
    if (jj_scan_token(FLOAT_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_271()
 {
    if (jj_scan_token(STRING_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_272()
 {
    if (jj_3R_195()) return true;
    return false;
  }

  private boolean jj_3R_273()
 {
    if (jj_scan_token(TRUE)) return true;
    return false;
  }

  private boolean jj_3R_274()
 {
    if (jj_scan_token(FALSE)) return true;
    return false;
  }

  private boolean jj_3R_275()
 {
    if (jj_scan_token(NULL)) return true;
    return false;
  }

  private boolean jj_3R_276()
 {
    if (jj_scan_token(NAN_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_44()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(67)) {
    jj_scanpos = xsp;
    if (jj_scan_token(69)) return true;
    }
    return false;
  }

  private boolean jj_3R_45()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(67)) {
    jj_scanpos = xsp;
    if (jj_scan_token(69)) return true;
    }
    return false;
  }

  private boolean jj_3R_34()
 {
    if (jj_3R_101()) return true;
    return false;
  }

  private boolean jj_3R_101()
 {
    if (jj_3R_141()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_50()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_50()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_46()) {
    jj_scanpos = xsp;
    if (jj_3R_47()) {
    jj_scanpos = xsp;
    if (jj_3R_48()) {
    jj_scanpos = xsp;
    if (jj_3R_49()) {
    jj_scanpos = xsp;
    if (jj_3R_50()) {
    jj_scanpos = xsp;
    if (jj_3R_51()) {
    jj_scanpos = xsp;
    if (jj_3R_52()) {
    jj_scanpos = xsp;
    if (jj_3R_53()) {
    jj_scanpos = xsp;
    if (jj_3R_54()) {
    jj_scanpos = xsp;
    if (jj_3R_55()) {
    jj_scanpos = xsp;
    if (jj_3R_56()) {
    jj_scanpos = xsp;
    if (jj_3R_57()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_269()
 {
    if (jj_3R_195()) return true;
    return false;
  }

  private boolean jj_3R_46()
 {
    if (jj_scan_token(plus_assign)) return true;
    if (jj_3R_34()) return true;
    return false;
  }

  private boolean jj_3R_47()
 {
    if (jj_scan_token(mult_assign)) return true;
    if (jj_3R_34()) return true;
    return false;
  }

  private boolean jj_3R_48()
 {
    if (jj_scan_token(div_assign)) return true;
    if (jj_3R_34()) return true;
    return false;
  }

  private boolean jj_3R_49()
 {
    if (jj_scan_token(mod_assign)) return true;
    if (jj_3R_34()) return true;
    return false;
  }

  private boolean jj_3R_50()
 {
    if (jj_scan_token(and_assign)) return true;
    if (jj_3R_34()) return true;
    return false;
  }

  private boolean jj_3_47()
 {
    if (jj_scan_token(DOT)) return true;
    return false;
  }

  private boolean jj_3R_51()
 {
    if (jj_scan_token(or_assign)) return true;
    if (jj_3R_34()) return true;
    return false;
  }

  private boolean jj_3R_52()
 {
    if (jj_scan_token(xor_assign)) return true;
    if (jj_3R_34()) return true;
    return false;
  }

  private boolean jj_3R_53()
 {
    if (jj_scan_token(minus_assign)) return true;
    if (jj_3R_34()) return true;
    return false;
  }

  private boolean jj_3R_54()
 {
    if (jj_scan_token(lshift_assign)) return true;
    if (jj_3R_34()) return true;
    return false;
  }

  private boolean jj_3R_55()
 {
    if (jj_scan_token(rshift_assign)) return true;
    if (jj_3R_34()) return true;
    return false;
  }

  private boolean jj_3R_56()
 {
    if (jj_scan_token(rshiftu_assign)) return true;
    if (jj_3R_34()) return true;
    return false;
  }

  private boolean jj_3R_57()
 {
    if (jj_scan_token(assign)) return true;
    if (jj_3R_34()) return true;
    return false;
  }

  private boolean jj_3R_141()
 {
    if (jj_3R_171()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_51()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_51()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_58()) {
    jj_scanpos = xsp;
    if (jj_3R_59()) {
    jj_scanpos = xsp;
    if (jj_3R_60()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_58()
 {
    if (jj_scan_token(QMARK)) return true;
    if (jj_3R_34()) return true;
    if (jj_scan_token(COLON)) return true;
    if (jj_3R_34()) return true;
    return false;
  }

  private boolean jj_3R_59()
 {
    if (jj_scan_token(ELVIS)) return true;
    if (jj_3R_34()) return true;
    return false;
  }

  private boolean jj_3R_60()
 {
    if (jj_scan_token(NULLP)) return true;
    if (jj_3R_34()) return true;
    return false;
  }

  private boolean jj_3R_171()
 {
    if (jj_3R_61()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_52()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_52()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(31)) {
    jj_scanpos = xsp;
    if (jj_scan_token(34)) return true;
    }
    if (jj_3R_61()) return true;
    return false;
  }

  private boolean jj_3R_61()
 {
    if (jj_3R_62()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_53()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_53()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(30)) {
    jj_scanpos = xsp;
    if (jj_scan_token(33)) return true;
    }
    if (jj_3R_62()) return true;
    return false;
  }

  private boolean jj_3R_62()
 {
    if (jj_3R_63()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_54()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_54()
 {
    if (jj_scan_token(or)) return true;
    if (jj_3R_63()) return true;
    return false;
  }

  private boolean jj_3R_63()
 {
    if (jj_3R_64()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_55()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_55()
 {
    if (jj_scan_token(xor)) return true;
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_64()
 {
    if (jj_3R_65()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_56()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_56()
 {
    if (jj_scan_token(and)) return true;
    if (jj_3R_65()) return true;
    return false;
  }

  private boolean jj_3R_65()
 {
    if (jj_3R_128()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_57()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_57()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_66()) {
    jj_scanpos = xsp;
    if (jj_3R_67()) {
    jj_scanpos = xsp;
    if (jj_3R_68()) {
    jj_scanpos = xsp;
    if (jj_3R_69()) {
    jj_scanpos = xsp;
    if (jj_3R_70()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_66()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(35)) {
    jj_scanpos = xsp;
    if (jj_scan_token(49)) return true;
    }
    if (jj_3R_128()) return true;
    return false;
  }

  private boolean jj_3R_67()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(36)) {
    jj_scanpos = xsp;
    if (jj_scan_token(50)) return true;
    }
    if (jj_3R_128()) return true;
    return false;
  }

  private boolean jj_3R_68()
 {
    if (jj_scan_token(eqstrict)) return true;
    if (jj_3R_128()) return true;
    return false;
  }

  private boolean jj_3R_69()
 {
    if (jj_scan_token(neqstrict)) return true;
    if (jj_3R_128()) return true;
    return false;
  }

  private boolean jj_3R_70()
 {
    if (jj_scan_token(range)) return true;
    if (jj_3R_128()) return true;
    return false;
  }

  private boolean jj_3R_128()
 {
    if (jj_3R_129()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_58()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_58()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_71()) {
    jj_scanpos = xsp;
    if (jj_3R_72()) {
    jj_scanpos = xsp;
    if (jj_3R_73()) {
    jj_scanpos = xsp;
    if (jj_3R_74()) {
    jj_scanpos = xsp;
    if (jj_3R_75()) {
    jj_scanpos = xsp;
    if (jj_3R_76()) {
    jj_scanpos = xsp;
    if (jj_3R_77()) {
    jj_scanpos = xsp;
    if (jj_3R_78()) {
    jj_scanpos = xsp;
    if (jj_3R_79()) {
    jj_scanpos = xsp;
    if (jj_3R_80()) {
    jj_scanpos = xsp;
    if (jj_3R_81()) {
    jj_scanpos = xsp;
    if (jj_3R_82()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_71()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(39)) {
    jj_scanpos = xsp;
    if (jj_scan_token(53)) return true;
    }
    if (jj_3R_129()) return true;
    return false;
  }

  private boolean jj_3R_72()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(37)) {
    jj_scanpos = xsp;
    if (jj_scan_token(51)) return true;
    }
    if (jj_3R_129()) return true;
    return false;
  }

  private boolean jj_3R_73()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(40)) {
    jj_scanpos = xsp;
    if (jj_scan_token(54)) return true;
    }
    if (jj_3R_129()) return true;
    return false;
  }

  private boolean jj_3R_74()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(38)) {
    jj_scanpos = xsp;
    if (jj_scan_token(52)) return true;
    }
    if (jj_3R_129()) return true;
    return false;
  }

  private boolean jj_3R_75()
 {
    if (jj_scan_token(req)) return true;
    if (jj_3R_129()) return true;
    return false;
  }

  private boolean jj_3R_76()
 {
    if (jj_scan_token(rne)) return true;
    if (jj_3R_129()) return true;
    return false;
  }

  private boolean jj_3R_77()
 {
    if (jj_scan_token(seq)) return true;
    if (jj_3R_129()) return true;
    return false;
  }

  private boolean jj_3R_78()
 {
    if (jj_scan_token(sne)) return true;
    if (jj_3R_129()) return true;
    return false;
  }

  private boolean jj_3R_79()
 {
    if (jj_scan_token(eeq)) return true;
    if (jj_3R_129()) return true;
    return false;
  }

  private boolean jj_3R_80()
 {
    if (jj_scan_token(ene)) return true;
    if (jj_3R_129()) return true;
    return false;
  }

  private boolean jj_3R_81()
 {
    if (jj_scan_token(ISA)) return true;
    if (jj_3R_129()) return true;
    return false;
  }

  private boolean jj_3R_82()
 {
    if (jj_scan_token(NISA)) return true;
    if (jj_3R_129()) return true;
    return false;
  }

  private boolean jj_3R_129()
 {
    if (jj_3R_130()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_59()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_59()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_83()) {
    jj_scanpos = xsp;
    if (jj_3R_84()) {
    jj_scanpos = xsp;
    if (jj_3R_85()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_83()
 {
    if (jj_scan_token(lshift)) return true;
    if (jj_3R_130()) return true;
    return false;
  }

  private boolean jj_3R_84()
 {
    if (jj_scan_token(rshift)) return true;
    if (jj_3R_130()) return true;
    return false;
  }

  private boolean jj_3R_85()
 {
    if (jj_scan_token(rshiftu)) return true;
    if (jj_3R_130()) return true;
    return false;
  }

  private boolean jj_3R_130()
 {
    if (jj_3R_131()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_60()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_60()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_86()) {
    jj_scanpos = xsp;
    if (jj_3R_87()) return true;
    }
    return false;
  }

  private boolean jj_3R_86()
 {
    if (jj_scan_token(plus)) return true;
    if (jj_3R_131()) return true;
    return false;
  }

  private boolean jj_3R_87()
 {
    if (jj_scan_token(minus)) return true;
    if (jj_3R_131()) return true;
    return false;
  }

  private boolean jj_3R_131()
 {
    if (jj_3R_132()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_61()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_61()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_88()) {
    jj_scanpos = xsp;
    if (jj_3R_89()) {
    jj_scanpos = xsp;
    if (jj_3R_90()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_88()
 {
    if (jj_scan_token(mult)) return true;
    if (jj_3R_132()) return true;
    return false;
  }

  private boolean jj_3R_89()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(72)) {
    jj_scanpos = xsp;
    if (jj_scan_token(84)) return true;
    }
    if (jj_3R_132()) return true;
    return false;
  }

  private boolean jj_3R_90()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(73)) {
    jj_scanpos = xsp;
    if (jj_scan_token(85)) return true;
    }
    if (jj_3R_132()) return true;
    return false;
  }

  private boolean jj_3R_132()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_158()) {
    jj_scanpos = xsp;
    if (jj_3R_159()) {
    jj_scanpos = xsp;
    if (jj_3R_160()) {
    jj_scanpos = xsp;
    if (jj_3R_161()) {
    jj_scanpos = xsp;
    if (jj_3R_162()) {
    jj_scanpos = xsp;
    if (jj_3R_163()) {
    jj_scanpos = xsp;
    if (jj_3R_164()) {
    jj_scanpos = xsp;
    if (jj_3R_165()) {
    jj_scanpos = xsp;
    if (jj_3_62()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_158()
 {
    if (jj_scan_token(minus)) return true;
    if (jj_3R_132()) return true;
    return false;
  }

  private boolean jj_3R_159()
 {
    if (jj_scan_token(plus)) return true;
    if (jj_3R_132()) return true;
    return false;
  }

  private boolean jj_3R_160()
 {
    if (jj_scan_token(tilda)) return true;
    if (jj_3R_132()) return true;
    return false;
  }

  private boolean jj_3R_161()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(74)) {
    jj_scanpos = xsp;
    if (jj_scan_token(83)) return true;
    }
    if (jj_3R_132()) return true;
    return false;
  }

  private boolean jj_3R_162()
 {
    if (jj_scan_token(EMPTY)) return true;
    if (jj_3R_132()) return true;
    return false;
  }

  private boolean jj_3R_163()
 {
    if (jj_scan_token(SIZE)) return true;
    if (jj_3R_132()) return true;
    return false;
  }

  private boolean jj_3R_164()
 {
    if (jj_scan_token(minusminus)) return true;
    if (jj_3R_132()) return true;
    return false;
  }

  private boolean jj_3R_165()
 {
    if (jj_scan_token(plusplus)) return true;
    if (jj_3R_132()) return true;
    return false;
  }

  private boolean jj_3_62()
 {
    if (jj_3R_91()) return true;
    return false;
  }

  private boolean jj_3R_250()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_251()) {
    jj_scanpos = xsp;
    if (jj_3R_252()) return true;
    }
    return false;
  }

  private boolean jj_3R_251()
 {
    if (jj_scan_token(plusplus)) return true;
    return false;
  }

  private boolean jj_3R_252()
 {
    if (jj_scan_token(minusminus)) return true;
    return false;
  }

  private boolean jj_3R_91()
 {
    if (jj_3R_133()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_249()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_93()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_134()) {
    jj_scanpos = xsp;
    if (jj_3R_135()) return true;
    }
    return false;
  }

  private boolean jj_3R_134()
 {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_135()
 {
    if (jj_scan_token(REGISTER)) return true;
    return false;
  }

  private boolean jj_3R_249()
 {
    if (jj_3R_250()) return true;
    return false;
  }

  private boolean jj_3R_229()
 {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(COLON)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_202()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_214()) {
    jj_scanpos = xsp;
    if (jj_3R_215()) {
    jj_scanpos = xsp;
    if (jj_3R_216()) {
    jj_scanpos = xsp;
    if (jj_3R_217()) {
    jj_scanpos = xsp;
    if (jj_3R_218()) {
    jj_scanpos = xsp;
    if (jj_3R_219()) {
    jj_scanpos = xsp;
    if (jj_3R_220()) {
    jj_scanpos = xsp;
    if (jj_3R_221()) return true;
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_214()
 {
    if (jj_3R_230()) return true;
    return false;
  }

  private boolean jj_3R_215()
 {
    if (jj_3R_231()) return true;
    return false;
  }

  private boolean jj_3R_216()
 {
    if (jj_3R_232()) return true;
    return false;
  }

  private boolean jj_3R_217()
 {
    if (jj_3R_233()) return true;
    return false;
  }

  private boolean jj_3R_218()
 {
    if (jj_3R_234()) return true;
    return false;
  }

  private boolean jj_3R_219()
 {
    if (jj_3R_235()) return true;
    return false;
  }

  private boolean jj_3R_220()
 {
    if (jj_3R_236()) return true;
    return false;
  }

  private boolean jj_3R_221()
 {
    if (jj_3R_237()) return true;
    return false;
  }

  private boolean jj_3R_237()
 {
    if (jj_scan_token(NAN_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_236()
 {
    if (jj_scan_token(NULL)) return true;
    return false;
  }

  private boolean jj_3R_232()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_238()) {
    jj_scanpos = xsp;
    if (jj_3R_239()) return true;
    }
    return false;
  }

  private boolean jj_3R_238()
 {
    if (jj_scan_token(TRUE)) return true;
    return false;
  }

  private boolean jj_3R_239()
 {
    if (jj_scan_token(FALSE)) return true;
    return false;
  }

  private boolean jj_3R_230()
 {
    if (jj_scan_token(INTEGER_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_231()
 {
    if (jj_scan_token(FLOAT_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_234()
 {
    if (jj_scan_token(STRING_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_233()
 {
    if (jj_scan_token(JXLT_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_235()
 {
    if (jj_scan_token(REGEX_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_258()
 {
    if (jj_scan_token(ELIPSIS)) return true;
    return false;
  }

  private boolean jj_3R_199()
 {
    if (jj_scan_token(LBRACKET)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_254()) {
    jj_scanpos = xsp;
    if (jj_3R_255()) return true;
    }
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_254()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(23)) jj_scanpos = xsp;
    if (jj_3R_258()) return true;
    return false;
  }

  private boolean jj_3R_255()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_64()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_64()
 {
    if (jj_3R_34()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_63()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_264()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_197()
 {
    if (jj_scan_token(LCURLY)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_66()) {
    jj_scanpos = xsp;
    if (jj_scan_token(22)) return true;
    }
    if (jj_scan_token(RCURLY)) return true;
    return false;
  }

  private boolean jj_3R_264()
 {
    if (jj_scan_token(COMMA)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_268()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_66()
 {
    if (jj_3R_92()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_65()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_256()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_63()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_34()) return true;
    return false;
  }

  private boolean jj_3_67()
 {
    if (jj_3R_93()) return true;
    if (jj_scan_token(COLON)) return true;
    if (jj_3R_34()) return true;
    return false;
  }

  private boolean jj_3R_92()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_67()) {
    jj_scanpos = xsp;
    if (jj_3_68()) return true;
    }
    return false;
  }

  private boolean jj_3R_268()
 {
    if (jj_3R_258()) return true;
    return false;
  }

  private boolean jj_3R_256()
 {
    if (jj_scan_token(COMMA)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_262()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_68()
 {
    if (jj_3R_34()) return true;
    if (jj_scan_token(COLON)) return true;
    if (jj_3R_34()) return true;
    return false;
  }

  private boolean jj_3_65()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_92()) return true;
    return false;
  }

  private boolean jj_3R_198()
 {
    if (jj_scan_token(LCURLY)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_70()) jj_scanpos = xsp;
    if (jj_scan_token(RCURLY)) return true;
    return false;
  }

  private boolean jj_3_70()
 {
    if (jj_3R_34()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_69()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_257()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_262()
 {
    if (jj_3R_258()) return true;
    return false;
  }

  private boolean jj_3R_257()
 {
    if (jj_scan_token(COMMA)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_263()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_248()
 {
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_71()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3_69()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_34()) return true;
    return false;
  }

  private boolean jj_3R_263()
 {
    if (jj_3R_258()) return true;
    return false;
  }

  private boolean jj_3R_95()
 {
    Token xsp;
    xsp = jj_scanpos;
    jj_lookingAhead = true;
    jj_semLA = isNamespaceFuncall(getToken(1), getToken(2), getToken(3), getToken(4));
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_136()) {
    jj_scanpos = xsp;
    if (jj_3_73()) {
    jj_scanpos = xsp;
    if (jj_3_74()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_136()
 {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(COLON)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3_73()
 {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3_74()
 {
    if (jj_scan_token(REGISTER)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3_71()
 {
    if (jj_3R_34()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_267()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_201()
 {
    Token xsp;
    xsp = jj_scanpos;
    jj_lookingAhead = true;
    jj_semLA = isNamespaceFuncall(getToken(1), getToken(2), getToken(3), getToken(4));
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_212()) {
    jj_scanpos = xsp;
    if (jj_3R_213()) return true;
    }
    return false;
  }

  private boolean jj_3R_212()
 {
    if (jj_3R_229()) return true;
    if (jj_3R_248()) return true;
    return false;
  }

  private boolean jj_3R_213()
 {
    if (jj_3R_93()) return true;
    if (jj_3R_248()) return true;
    return false;
  }

  private boolean jj_3_72()
 {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(COLON)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_260()
 {
    if (jj_3R_195()) return true;
    return false;
  }

  private boolean jj_3R_267()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_34()) return true;
    return false;
  }

  private boolean jj_3_76()
 {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3_78()
 {
    if (jj_scan_token(NEW)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_34()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_259()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_200()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_78()) {
    jj_scanpos = xsp;
    if (jj_3R_211()) return true;
    }
    return false;
  }

  private boolean jj_3_75()
 {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(COLON)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_211()
 {
    if (jj_scan_token(NEW)) return true;
    if (jj_3R_260()) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_77()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  /** Generated Token Manager. */
  public ParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  /** Whether we are looking ahead. */
  private boolean jj_lookingAhead = false;
  private boolean jj_semLA;

  /**
   * Constructor with InputStream.
   * @param stream char stream
   */
  public Parser(final Provider stream) {
	 jj_input_stream = new SimpleCharStream(stream, 1, 1);
	 token_source = new ParserTokenManager(jj_input_stream);
	 token = new Token();
	 token.next = jj_nt = token_source.getNextToken();
  }

  /**
   * Constructor with InputStream.
   * @param sDSL String representation to be parsed
   */
  public Parser(final String sDSL) {
	   this(new StringProvider(sDSL));
  }

  /**
   * Reinitialise.
   * @param sDSL String representation to be parsed
   */
  public void ReInit(final String sDSL) {
	  ReInit(new StringProvider(sDSL));
  }
  /**
   * Reinitialise
   * @param stream char stream
   */
  public void ReInit(final Provider stream) {
	if (jj_input_stream == null) {
	  jj_input_stream = new SimpleCharStream(stream, 1, 1);
	} else {
	  jj_input_stream.reInit(stream, 1, 1);
  }
	if (token_source == null) {
 token_source = new ParserTokenManager(jj_input_stream);
	}

	 token_source.ReInit(jj_input_stream);
	 token = new Token();
	 token.next = jj_nt = token_source.getNextToken();
  }

  /**
   * Constructor with generated Token Manager.
   * @param tm Token manager to use
   */
  public Parser(final ParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 token.next = jj_nt = token_source.getNextToken();
  }

  /**
   * Reinitialise
   * @param tm Token manager to use
   */
  public void ReInit(final ParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 token.next = jj_nt = token_source.getNextToken();
  }

  private Token jj_consume_token(final int kind) throws ParseException {
    final Token oldToken = token;
    token = jj_nt;
    if (token.next != null)
      jj_nt = jj_nt.next;
    else {
      jj_nt.next = token_source.getNextToken();
      jj_nt = jj_nt.next;
    }
    if (token.kind == kind) {
      return token;
    }
    jj_nt = token;
    token = oldToken;
    throw generateParseException();
  }

  private static final class LookaheadSuccess extends IllegalStateException {}
  private static final LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
	 if (jj_scanpos == jj_lastpos) {
	   jj_la--;
	   if (jj_scanpos.next == null) {
		   jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
	   } else {
		   jj_lastpos = jj_scanpos = jj_scanpos.next;
	   }
	 } else {
	   jj_scanpos = jj_scanpos.next;
	 }
	 if (jj_scanpos.kind != kind) return true;
	 if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
	 return false;
  }


  /**
   * @return the next Token.
   */
  public final Token getNextToken() {
   token = jj_nt;
   if (token.next != null)
     jj_nt = jj_nt.next;
   else
     jj_nt = jj_nt.next = token_source.getNextToken();
	 return token;
  }

  /**
   * @param index index to be retrieved
   * @return the specific Token.
   */
  public final Token getToken(final int index) {
    Token t = jj_lookingAhead ? jj_scanpos : token;
    for (int i = 0; i < index; i++) {
      if (t.next == null)
        t.next = token_source.getNextToken();
      t = t.next;
    }
    return t;
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
  final Token errortok = token.next;
  final int line = errortok.beginLine;
  final int column = errortok.beginColumn;
  final String mess = errortok.kind == 0 ? tokenImage[0] : errortok.image;
  return new ParseException("Parse error at line " + line + ", column " + column + ".  Encountered: " + mess);
  }

  /**
   * @return Always <code>false</code>.
   */
  public final boolean trace_enabled() {
    return false;
  }

  /** Enable tracing. */
  public final void enable_tracing() {}

  /** Disable tracing. */
  public final void disable_tracing() {}

}
