/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.util.Arrays;
import java.util.Set;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlFeatures;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FeaturesTest
extends JexlTestCase {
    private final JexlEngine jexl = new JexlBuilder().create();

    public FeaturesTest() {
        super("FeaturesTest");
    }

    private void assertOk(String[] scripts) {
        for (String str : scripts) {
            try {
                JexlScript jexlScript = this.jexl.createScript(str);
            }
            catch (JexlException.Feature xfeature) {
                Assertions.fail((String)(str + " :: should not fail parse: " + xfeature.getMessage()));
            }
        }
    }

    private void checkFeature(JexlFeatures features, String[] scripts) throws Exception {
        for (String script : scripts) {
            JexlScript ctl = this.JEXL.createScript(script);
            Assertions.assertNotNull((Object)ctl);
            JexlException.Parsing xfeature = (JexlException.Parsing)Assertions.assertThrows(JexlException.Parsing.class, () -> this.jexl.createScript(features, null, script, new String[0]));
            Assertions.assertNotNull((Object)xfeature.getMessage());
        }
    }

    @Test
    void test410a() {
        long x = JexlFeatures.createAll().getFlags();
        Assertions.assertEquals((int)25, (int)Long.bitCount(x));
        Assertions.assertTrue(((x & 0x1000000L) != 0L ? 1 : 0) != 0);
        JexlFeatures all = JexlFeatures.createAll();
        JexlEngine jexl = new JexlBuilder().features(all).create();
        JexlScript script = jexl.createScript("#0 * #1", new String[]{"#0", "#1"});
        Object r = script.execute(null, new Object[]{6, 7});
        Assertions.assertEquals((Object)42, (Object)r);
    }

    @Test
    void test410b() {
        String[] cmpNameScripts;
        JexlFeatures features = JexlFeatures.createScript();
        Assertions.assertTrue((boolean)features.isLexical());
        Assertions.assertTrue((boolean)features.isLexicalShade());
        Assertions.assertTrue((boolean)features.supportsConstCapture());
        Assertions.assertFalse((boolean)features.supportsPragmaAnywhere());
        Assertions.assertFalse((boolean)features.supportsComparatorNames());
        JexlEngine jexl = new JexlBuilder().features(features).create();
        Set reserved = features.getReservedNames();
        for (String varName : reserved) {
            String src = "var " + varName;
            Assertions.assertThrows(JexlException.Feature.class, () -> jexl.createScript(src), (String)src);
        }
        for (String src : cmpNameScripts = new String[]{"1 eq 1", "2 ne 3", "1 lt 2", "3 le 3", "4 gt 2", "3 ge 2"}) {
            Assertions.assertThrows(JexlException.Ambiguous.class, () -> jexl.createScript(src));
        }
    }

    @Test
    void testAnnotations() throws Exception {
        JexlFeatures f = new JexlFeatures().annotation(false);
        String[] scripts = new String[]{"@synchronized(2) { return 42; }", "@two var x = 3;"};
        this.checkFeature(f, scripts);
    }

    @Test
    void testArrayRefs() throws Exception {
        JexlFeatures f = new JexlFeatures().arrayReferenceExpr(false);
        String[] scripts = new String[]{"x[y]", "x['a'][b]", "x()['a'][b]", "x.y['a'][b]"};
        this.checkFeature(f, scripts);
        this.assertOk(scripts);
        String[] scriptsOk = new String[]{"x['y']", "x['a'][1]", "x()['a']['b']", "x.y['a']['b']"};
        this.assertOk(scriptsOk);
    }

    @Test
    void testConstCapture() throws Exception {
        JexlFeatures f = new JexlFeatures().constCapture(true);
        String[] scripts = new String[]{"let x = 0; const f = y -> x += y; f(42)", "let x = 0; function f(y) { z -> x *= y }; f(42)"};
        this.checkFeature(f, scripts);
        JexlFeatures nof = new JexlFeatures().constCapture(true);
        this.assertOk(scripts);
    }

    @Test
    void testCreate() {
        JexlFeatures f = JexlFeatures.createNone();
        Assertions.assertTrue((boolean)f.supportsExpression());
        Assertions.assertFalse((boolean)f.supportsAnnotation());
        Assertions.assertFalse((boolean)f.supportsArrayReferenceExpr());
        Assertions.assertFalse((boolean)f.supportsComparatorNames());
        Assertions.assertFalse((boolean)f.supportsFatArrow());
        Assertions.assertFalse((boolean)f.supportsImportPragma());
        Assertions.assertFalse((boolean)f.supportsLambda());
        Assertions.assertFalse((boolean)f.supportsLocalVar());
        Assertions.assertFalse((boolean)f.supportsLoops());
        Assertions.assertFalse((boolean)f.supportsMethodCall());
        Assertions.assertFalse((boolean)f.supportsNamespacePragma());
        Assertions.assertFalse((boolean)f.supportsNewInstance());
        Assertions.assertFalse((boolean)f.supportsPragma());
        Assertions.assertFalse((boolean)f.supportsPragmaAnywhere());
        Assertions.assertFalse((boolean)f.supportsScript());
        Assertions.assertFalse((boolean)f.supportsStructuredLiteral());
        Assertions.assertFalse((boolean)f.isLexical());
        Assertions.assertFalse((boolean)f.isLexicalShade());
        Assertions.assertFalse((boolean)f.supportsConstCapture());
        JexlEngine jnof = new JexlBuilder().features(f).create();
        Assertions.assertThrows(JexlException.Feature.class, () -> jnof.createScript("{ 3 + 4 }"));
        Assertions.assertNotNull((Object)jnof.createExpression("3 + 4"));
    }

    @Test
    void testIssue409() {
        JexlFeatures baseFeatures = JexlFeatures.createDefault();
        Assertions.assertFalse((boolean)baseFeatures.isLexical());
        Assertions.assertFalse((boolean)baseFeatures.isLexicalShade());
        Assertions.assertFalse((boolean)baseFeatures.supportsConstCapture());
        JexlFeatures scriptFeatures = JexlFeatures.createScript();
        Assertions.assertTrue((boolean)scriptFeatures.isLexical());
        Assertions.assertTrue((boolean)scriptFeatures.isLexicalShade());
        scriptFeatures.lexical(false);
        Assertions.assertFalse((boolean)scriptFeatures.isLexical());
        Assertions.assertFalse((boolean)scriptFeatures.isLexicalShade());
    }

    @Test
    void testMethodCalls() throws Exception {
        JexlFeatures f = new JexlFeatures().methodCall(false);
        String[] scripts = new String[]{"x.y(z)", "x['a'].m(b)", "x()['a'](b)", "x.y['a'](b)"};
        this.checkFeature(f, scripts);
        String[] scriptsOk = new String[]{"x('y')", "x('a')[1]", "x()['a']['b']"};
        this.assertOk(scriptsOk);
    }

    @Test
    void testMixedFeatures() throws Exception {
        JexlFeatures f = new JexlFeatures().newInstance(false).localVar(false).lambda(false).loops(false).sideEffectGlobal(false);
        String[] scripts = new String[]{"return new(clazz);", "()->{ return 0 };", "var x = 0;", "(x, y)->{ return 0 };", "for(var i : {0 .. 10}) { bar(i); }", "x += 1", "x.y += 1"};
        this.checkFeature(f, scripts);
    }

    @Test
    void testNoComparatorNames() throws Exception {
        JexlFeatures f = new JexlFeatures().comparatorNames(false);
        String[] scripts = new String[]{"1 eq 1", "2 ne 3", "1 lt 2", "3 le 3", "4 gt 2", "3 ge 2"};
        this.checkFeature(f, scripts);
    }

    @Test
    void testNoLambda() throws Exception {
        JexlFeatures f = new JexlFeatures().lambda(false);
        String[] scripts = new String[]{"var x  = ()->{ return 0 };", "()->{ return 0 };", "(x, y)->{ return 0 };", "function() { return 0 };", "function(x, y) { return 0 };", "if (false) { (function(x, y) { return x + y })(3, 4) }"};
        this.checkFeature(f, scripts);
    }

    @Test
    void testNoLocals() throws Exception {
        JexlFeatures f = new JexlFeatures().localVar(false);
        String[] scripts = new String[]{"var x = 0;", "(x)->{ x }"};
        this.checkFeature(f, scripts);
    }

    @Test
    void testNoLoop() throws Exception {
        JexlFeatures f = new JexlFeatures().loops(false);
        String[] scripts = new String[]{"while(true);", "for(var i : {0 .. 10}) { bar(i); }"};
        this.checkFeature(f, scripts);
    }

    @Test
    void testNoNew() throws Exception {
        JexlFeatures f = new JexlFeatures().newInstance(false);
        String[] scripts = new String[]{"return new(clazz);", "new('java.math.BigDecimal', 12) + 1"};
        this.checkFeature(f, scripts);
    }

    @Test
    void testNoScript() throws Exception {
        JexlFeatures f = new JexlFeatures().script(false);
        Assertions.assertTrue((boolean)f.supportsExpression());
        String[] scripts = new String[]{"if (false) { block(); }", "{ noway(); }", "while(true);", "for(var i : {0 .. 10}) { bar(i); }"};
        this.checkFeature(f, scripts);
    }

    @Test
    void testNoSideEffects() throws Exception {
        JexlFeatures f = new JexlFeatures().sideEffect(false);
        String[] scripts = new String[]{"x = 1", "x.y = 1", "x().y = 1", "x += 1", "x.y += 1", "x().y += 1", "x -= 1", "x *= 1", "x /= 1", "x %= 1", "x ^= 1", "x &= 1", "x |= 1", "x >>= 1", "x <<= 1", "x >>>= 1"};
        this.checkFeature(f, scripts);
    }

    @Test
    void testNoSideEffectsGlobal() throws Exception {
        JexlFeatures f = new JexlFeatures().sideEffectGlobal(false);
        String[] scripts = new String[]{"x = 1", "x.y = 1", "x().y = 1", "x += 1", "x.y += 1", "x().y += 1", "x -= 1", "x *= 1", "x /= 1", "x ^= 1", "x &= 1", "x |= 1", "4 + (x.y = 1)", "if (true) x.y.z = 4"};
        this.checkFeature(f, scripts);
        for (String str : scripts) {
            try {
                JexlScript jexlScript = this.jexl.createScript("var x = foo(); " + str);
            }
            catch (JexlException.Feature xfeature) {
                Assertions.fail((String)(str + " :: should not fail parse: " + xfeature.getMessage()));
            }
        }
    }

    @Test
    void testPragma() throws Exception {
        JexlFeatures f = new JexlFeatures().pragma(false);
        String[] scripts = new String[]{"#pragma foo 42", "#pragma foo 'bar'\n@two var x = 3;"};
        this.checkFeature(f, scripts);
    }

    @Test
    void testPragmaAnywhere() throws Exception {
        JexlFeatures f = new JexlFeatures().pragmaAnywhere(false);
        String[] scripts = new String[]{"var x = 3;\n#pragma foo 42"};
        this.checkFeature(f, scripts);
    }

    @Test
    void testReservedVars() throws Exception {
        JexlFeatures f = new JexlFeatures().reservedNames(Arrays.asList("foo", "bar"));
        String[] scripts = new String[]{"var foo = 0;", "(bar)->{ bar }", "var f = function(bar) { bar; }"};
        this.checkFeature(f, scripts);
        String[] scriptsOk = new String[]{"var foo0 = 0;", "(bar1)->{ bar }", "var f = function(bar2) { bar2; }"};
        this.assertOk(scriptsOk);
    }

    @Test
    void testStructuredLiterals() throws Exception {
        JexlFeatures f = new JexlFeatures().structuredLiteral(false);
        String[] scripts = new String[]{"{1, 2, 3}", "[1, 2, 3]", "{ 1 :'one', 2 : 'two', 3 : 'three' }", "(1 .. 5)"};
        this.checkFeature(f, scripts);
        this.assertOk(scripts);
    }
}

