/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.jexl3.JexlArithmetic;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.internal.Engine;
import org.apache.commons.jexl3.introspection.JexlPropertyGet;
import org.apache.commons.jexl3.introspection.JexlPropertySet;
import org.apache.commons.jexl3.introspection.JexlUberspect;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StrategyTest
extends JexlTestCase {
    public StrategyTest() {
        super("StrategyTest");
    }

    public void run171(JexlEngine jexl, boolean std) throws Exception {
        HashMap<String, Integer> i = new HashMap<String, Integer>();
        i.put("class", 42);
        Object result = jexl.createScript("i['class'] ", new String[]{"i"}).execute((JexlContext)null, new Object[]{i});
        Assertions.assertEquals((Object)42, (Object)result);
        result = jexl.createScript("i['class'] = 28", new String[]{"i"}).execute((JexlContext)null, new Object[]{i});
        Assertions.assertEquals((Object)28, (Object)result);
        Assertions.assertEquals((Object)28, i.get("class"));
        result = jexl.createScript("i.class", new String[]{"i"}).execute((JexlContext)null, new Object[]{i});
        if (std) {
            Assertions.assertEquals(HashMap.class, (Object)result);
        } else {
            Assertions.assertEquals((Object)28, (Object)result);
        }
        result = jexl.createScript("i.'class'", new String[]{"i"}).execute((JexlContext)null, new Object[]{i});
        if (std) {
            Assertions.assertEquals(HashMap.class, (Object)result);
        } else {
            Assertions.assertEquals((Object)28, (Object)result);
        }
        i.put("size", 4242);
        result = jexl.createScript("i['size'] ", new String[]{"i"}).execute((JexlContext)null, new Object[]{i});
        Assertions.assertEquals((Object)4242, (Object)result);
        result = jexl.createScript("i['size'] = 2828", new String[]{"i"}).execute((JexlContext)null, new Object[]{i});
        Assertions.assertEquals((Object)2828, (Object)result);
        Assertions.assertEquals((Object)2828, i.get("size"));
        result = jexl.createScript("i.'size'", new String[]{"i"}).execute((JexlContext)null, new Object[]{i});
        Assertions.assertEquals((Object)2828, (Object)result);
        result = jexl.createScript("size i", new String[]{"i"}).execute((JexlContext)null, new Object[]{i});
        Assertions.assertEquals((Object)2, (Object)result);
        i.put("empty", 424242);
        result = jexl.createScript("i['empty'] ", new String[]{"i"}).execute((JexlContext)null, new Object[]{i});
        Assertions.assertEquals((Object)424242, (Object)result);
        result = jexl.createScript("i['empty'] = 282828", new String[]{"i"}).execute((JexlContext)null, new Object[]{i});
        Assertions.assertEquals((Object)282828, (Object)result);
        Assertions.assertEquals((Object)282828, i.get("empty"));
        result = jexl.createScript("i.'empty'", new String[]{"i"}).execute((JexlContext)null, new Object[]{i});
        if (std) {
            Assertions.assertNotEquals((Object)282828, (Object)result);
        } else {
            Assertions.assertEquals((Object)282828, (Object)result);
        }
        result = jexl.createScript("empty i", new String[]{"i"}).execute((JexlContext)null, new Object[]{i});
        Assertions.assertFalse((boolean)((Boolean)result));
    }

    @Test
    public void testJexlStrategy() throws Exception {
        Engine jexl = new Engine();
        this.run171((JexlEngine)jexl, true);
    }

    @Test
    public void testMapStrategy() throws Exception {
        JexlEngine jexl = new JexlBuilder().strategy(JexlUberspect.MAP_STRATEGY).create();
        this.run171(jexl, false);
    }

    @Test
    public void testMyMapStrategy() throws Exception {
        JexlEngine jexl = new JexlBuilder().arithmetic((JexlArithmetic)new MapArithmetic(true)).create();
        this.run171(jexl, false);
    }

    @Test
    public void testRawResolvers() throws Exception {
        HashMap map = new HashMap();
        JexlEngine jexl = new JexlBuilder().create();
        JexlUberspect uberspect = jexl.getUberspect();
        JexlUberspect.JexlResolver rfieldp = JexlUberspect.JexlResolver.FIELD;
        JexlPropertyGet fget = rfieldp.getPropertyGet(uberspect, map, (Object)"key");
        Assertions.assertNull((Object)fget);
        JexlPropertySet fset = rfieldp.getPropertySet(uberspect, map, (Object)"key", (Object)"value");
        Assertions.assertNull((Object)fset);
        JexlUberspect.JexlResolver rmap = JexlUberspect.JexlResolver.MAP;
        JexlPropertyGet mget = rmap.getPropertyGet(uberspect, map, (Object)"key");
        Assertions.assertNotNull((Object)mget);
        JexlPropertySet mset = rmap.getPropertySet(uberspect, map, (Object)"key", (Object)"value");
        Assertions.assertNotNull((Object)mset);
    }

    public static class MapArithmetic
    extends JexlArithmetic {
        public MapArithmetic(boolean flag) {
            super(flag);
        }

        public Object arrayGet(Map<?, ?> map, Object identifier) {
            return map.get(identifier);
        }

        public Object arraySet(Map<Object, Object> map, Object identifier, Object value) {
            map.put(identifier, value);
            return value;
        }

        public Object propertyGet(Map<?, ?> map, Object identifier) {
            return this.arrayGet(map, identifier);
        }

        public Object propertySet(Map<Object, Object> map, Object identifier, Object value) {
            return this.arraySet(map, identifier, value);
        }
    }
}

