/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.internal.introspection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.commons.jexl3.annotations.NoJexl;
import org.apache.commons.jexl3.internal.introspection.Permissions;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class NoJexlTest {
    @Test
    public void testNoJexlPermissions() throws Exception {
        Permissions p = Permissions.UNRESTRICTED;
        Assertions.assertFalse((boolean)p.allow((Field)null));
        Assertions.assertFalse((boolean)p.allow((Package)null));
        Assertions.assertFalse((boolean)p.allow((Method)null));
        Assertions.assertFalse((boolean)p.allow((Constructor)null));
        Assertions.assertFalse((boolean)p.allow((Class)null));
        Assertions.assertFalse((boolean)p.allow(A2.class));
        Assertions.assertTrue((boolean)p.allow(A3.class));
        Assertions.assertTrue((boolean)p.allow(A5.class));
        Method mA = A.class.getMethod("method", new Class[0]);
        Assertions.assertNotNull((Object)mA);
        Method mA0 = A0.class.getMethod("method", new Class[0]);
        Assertions.assertNotNull((Object)mA0);
        Method mA1 = A1.class.getMethod("method", new Class[0]);
        Assertions.assertNotNull((Object)mA1);
        Method mA2 = A2.class.getMethod("method", new Class[0]);
        Assertions.assertNotNull((Object)mA2);
        Method mA3 = A2.class.getDeclaredMethod("method", new Class[0]);
        Assertions.assertNotNull((Object)mA3);
        Assertions.assertTrue((boolean)p.allow(mA));
        Assertions.assertFalse((boolean)p.allow(mA0));
        Assertions.assertFalse((boolean)p.allow(mA1));
        Assertions.assertFalse((boolean)p.allow(mA2));
        Assertions.assertFalse((boolean)p.allow(mA3));
        Field fA = A.class.getField("i");
        Assertions.assertNotNull((Object)fA);
        Assertions.assertTrue((boolean)p.allow(fA));
        Field fA0 = A0.class.getField("i0");
        Assertions.assertNotNull((Object)fA0);
        Assertions.assertFalse((boolean)p.allow(fA0));
        Field fA1 = A1.class.getDeclaredField("i1");
        Assertions.assertNotNull((Object)fA1);
        Assertions.assertFalse((boolean)p.allow(fA0));
        Constructor cA = A.class.getConstructor(new Class[0]);
        Assertions.assertNotNull(cA);
        Assertions.assertTrue((boolean)p.allow(cA));
        Constructor cA0 = A0.class.getConstructor(new Class[0]);
        Assertions.assertNotNull(cA0);
        Assertions.assertFalse((boolean)p.allow(cA0));
        Constructor cA3 = A3.class.getDeclaredConstructor(new Class[0]);
        Assertions.assertNotNull(cA3);
        Assertions.assertFalse((boolean)p.allow(cA3));
    }

    @NoJexl
    public static class A2
    extends A {
        @Override
        public int method() {
            return 3;
        }
    }

    protected static class A3 {
        protected int i3;

        protected A3() {
        }

        int method() {
            return 4;
        }
    }

    public static class A5
    implements InterNoJexl5 {
        @Override
        public int method() {
            return 0;
        }
    }

    public static class A {
        public int i;

        public int method() {
            return 0;
        }
    }

    public static class A0
    extends A
    implements InterNoJexl0 {
        @NoJexl
        public int i0;

        @NoJexl
        public A0() {
        }

        @Override
        public int method() {
            return 1;
        }
    }

    public static class A1
    extends A
    implements InterNoJexl1 {
        private int i1;

        @NoJexl
        public A1() {
        }

        @Override
        public int method() {
            return 2;
        }
    }

    @NoJexl
    public static interface InterNoJexl5 {
        public int method();
    }

    public static interface InterNoJexl1 {
        @NoJexl
        public int method();
    }

    @NoJexl
    public static interface InterNoJexl0 {
        public int method();
    }
}

