/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath;

import java.util.HashMap;
import org.apache.commons.jxpath.JXPathBasicBeanInfo;
import org.apache.commons.jxpath.JXPathBeanInfo;

public class JXPathIntrospector {
    private static HashMap byClass;
    private static HashMap byInterface;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;
    static /* synthetic */ Class class$13;
    static /* synthetic */ Class class$14;
    static /* synthetic */ Class class$15;
    static /* synthetic */ Class class$16;

    static {
        Class<?> clazz;
        byClass = new HashMap();
        byInterface = new HashMap();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.lang.Class");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JXPathIntrospector.registerAtomicClass(clazz2);
        JXPathIntrospector.registerAtomicClass(Boolean.TYPE);
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JXPathIntrospector.registerAtomicClass(clazz3);
        JXPathIntrospector.registerAtomicClass(Byte.TYPE);
        Class<?> clazz4 = class$2;
        if (clazz4 == null) {
            try {
                clazz4 = class$2 = Class.forName("java.lang.Byte");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JXPathIntrospector.registerAtomicClass(clazz4);
        JXPathIntrospector.registerAtomicClass(Character.TYPE);
        Class<?> clazz5 = class$3;
        if (clazz5 == null) {
            try {
                clazz5 = class$3 = Class.forName("java.lang.Character");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JXPathIntrospector.registerAtomicClass(clazz5);
        JXPathIntrospector.registerAtomicClass(Short.TYPE);
        Class<?> clazz6 = class$4;
        if (clazz6 == null) {
            try {
                clazz6 = class$4 = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JXPathIntrospector.registerAtomicClass(clazz6);
        JXPathIntrospector.registerAtomicClass(Integer.TYPE);
        Class<?> clazz7 = class$5;
        if (clazz7 == null) {
            try {
                clazz7 = class$5 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JXPathIntrospector.registerAtomicClass(clazz7);
        JXPathIntrospector.registerAtomicClass(Long.TYPE);
        Class<?> clazz8 = class$6;
        if (clazz8 == null) {
            try {
                clazz8 = class$6 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JXPathIntrospector.registerAtomicClass(clazz8);
        JXPathIntrospector.registerAtomicClass(Float.TYPE);
        Class<?> clazz9 = class$7;
        if (clazz9 == null) {
            try {
                clazz9 = class$7 = Class.forName("java.lang.Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JXPathIntrospector.registerAtomicClass(clazz9);
        JXPathIntrospector.registerAtomicClass(Double.TYPE);
        Class<?> clazz10 = class$8;
        if (clazz10 == null) {
            try {
                clazz10 = class$8 = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JXPathIntrospector.registerAtomicClass(clazz10);
        Class<?> clazz11 = class$9;
        if (clazz11 == null) {
            try {
                clazz11 = class$9 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JXPathIntrospector.registerAtomicClass(clazz11);
        Class<?> clazz12 = class$10;
        if (clazz12 == null) {
            try {
                clazz12 = class$10 = Class.forName("java.util.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JXPathIntrospector.registerAtomicClass(clazz12);
        Class<?> clazz13 = class$11;
        if (clazz13 == null) {
            try {
                clazz13 = class$11 = Class.forName("java.sql.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JXPathIntrospector.registerAtomicClass(clazz13);
        Class<?> clazz14 = class$12;
        if (clazz14 == null) {
            try {
                clazz14 = class$12 = Class.forName("java.sql.Time");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JXPathIntrospector.registerAtomicClass(clazz14);
        Class<?> clazz15 = class$13;
        if (clazz15 == null) {
            try {
                clazz15 = class$13 = Class.forName("java.sql.Timestamp");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JXPathIntrospector.registerAtomicClass(clazz15);
        Class<?> clazz16 = class$14;
        if (clazz16 == null) {
            try {
                clazz16 = class$14 = Class.forName("java.util.Map");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz = class$15) == null) {
            try {
                clazz = class$15 = Class.forName("org.apache.commons.jxpath.MapDynamicPropertyHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JXPathIntrospector.registerDynamicClass(clazz16, clazz);
    }

    public static void registerAtomicClass(Class beanClass) {
        byClass.put(beanClass, new JXPathBasicBeanInfo(beanClass, true));
    }

    public static void registerDynamicClass(Class beanClass, Class dynamicPropertyHandlerClass) {
        JXPathBasicBeanInfo bi = new JXPathBasicBeanInfo(beanClass, dynamicPropertyHandlerClass);
        if (beanClass.isInterface()) {
            byInterface.put(beanClass, bi);
        } else {
            byClass.put(beanClass, bi);
        }
    }

    public static JXPathBeanInfo getBeanInfo(Class beanClass) {
        JXPathBeanInfo beanInfo = (JXPathBeanInfo)byClass.get(beanClass);
        if (beanInfo == null) {
            beanInfo = JXPathIntrospector.findDynamicBeanInfo(beanClass);
            if (beanInfo == null && (beanInfo = JXPathIntrospector.findInformant(beanClass)) == null) {
                beanInfo = new JXPathBasicBeanInfo(beanClass);
            }
            byClass.put(beanClass, beanInfo);
        }
        return beanInfo;
    }

    private static JXPathBeanInfo findDynamicBeanInfo(Class beanClass) {
        Class sup;
        JXPathBeanInfo beanInfo = null;
        if (beanClass.isInterface() && (beanInfo = (JXPathBeanInfo)byInterface.get(beanClass)) != null && beanInfo.isDynamic()) {
            return beanInfo;
        }
        Class<?>[] interfaces = beanClass.getInterfaces();
        if (interfaces != null) {
            int i = 0;
            while (i < interfaces.length) {
                beanInfo = JXPathIntrospector.findDynamicBeanInfo(interfaces[i]);
                if (beanInfo != null && beanInfo.isDynamic()) {
                    return beanInfo;
                }
                ++i;
            }
        }
        if ((sup = beanClass.getSuperclass()) != null) {
            beanInfo = (JXPathBeanInfo)byClass.get(sup);
            if (beanInfo != null && beanInfo.isDynamic()) {
                return beanInfo;
            }
            return JXPathIntrospector.findDynamicBeanInfo(sup);
        }
        return null;
    }

    private static synchronized JXPathBeanInfo findInformant(Class beanClass) {
        String name = String.valueOf(beanClass.getName()) + "XBeanInfo";
        try {
            return (JXPathBeanInfo)JXPathIntrospector.instantiate(beanClass, name);
        }
        catch (Exception exception) {
            try {
                Class<?> clazz = class$16;
                if (clazz == null) {
                    try {
                        clazz = class$16 = Class.forName("org.apache.commons.jxpath.JXPathBeanInfo");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz.isAssignableFrom(beanClass)) {
                    return (JXPathBeanInfo)beanClass.newInstance();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            return null;
        }
    }

    private static Object instantiate(Class sibling, String className) throws Exception {
        ClassLoader cl = sibling.getClassLoader();
        if (cl != null) {
            try {
                Class<?> cls = cl.loadClass(className);
                return cls.newInstance();
            }
            catch (Exception cls) {
                // empty catch block
            }
        }
        Class<?> cls = Class.forName(className);
        return cls.newInstance();
    }
}

