/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.compiler;

import org.apache.commons.jxpath.ri.EvalContext;
import org.apache.commons.jxpath.ri.compiler.Expression;
import org.apache.commons.jxpath.ri.compiler.Operation;

public abstract class CoreOperation
extends Operation {
    public CoreOperation(Expression[] args) {
        super(args);
    }

    public Object compute(EvalContext context) {
        return this.computeValue(context);
    }

    public abstract Object computeValue(EvalContext var1);

    public abstract String getSymbol();

    protected abstract boolean isSymmetric();

    protected abstract int getPrecedence();

    public String toString() {
        if (this.args.length == 1) {
            return String.valueOf(this.getSymbol()) + this.parenthesize(this.args[0], false);
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.args.length) {
            if (i > 0) {
                buffer.append(' ');
                buffer.append(this.getSymbol());
                buffer.append(' ');
            }
            buffer.append(this.parenthesize(this.args[i], i == 0));
            ++i;
        }
        return buffer.toString();
    }

    private String parenthesize(Expression expression, boolean left) {
        if (!(expression instanceof CoreOperation)) {
            return expression.toString();
        }
        CoreOperation op = (CoreOperation)expression;
        int myPrecedence = this.getPrecedence();
        int thePrecedence = op.getPrecedence();
        boolean needParens = true;
        if (myPrecedence < thePrecedence) {
            needParens = false;
        } else if (myPrecedence == thePrecedence) {
            if (this.isSymmetric()) {
                needParens = false;
            } else {
                boolean bl = needParens = !left;
            }
        }
        if (needParens) {
            return "(" + expression.toString() + ")";
        }
        return expression.toString();
    }
}

