/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri;

import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.ri.EvalContext;
import org.apache.commons.jxpath.ri.model.NodePointer;

public class InfoSetUtil {
    private static final Double ZERO = new Double(0.0);
    private static final Double ONE = new Double(1.0);
    private static final Double NaN = new Double(Double.NaN);

    public static String stringValue(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Number) {
            long l;
            double d = ((Number)object).doubleValue();
            if (d == (double)(l = ((Number)object).longValue())) {
                return String.valueOf(l);
            }
            return String.valueOf(d);
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? "true" : "false";
        }
        if (object == null) {
            return "";
        }
        if (object instanceof NodePointer) {
            return InfoSetUtil.stringValue(((NodePointer)object).getValue());
        }
        if (object instanceof EvalContext) {
            EvalContext ctx = (EvalContext)object;
            Pointer ptr = ctx.getSingleNodePointer();
            if (ptr != null) {
                return InfoSetUtil.stringValue(ptr);
            }
            return "";
        }
        return String.valueOf(object);
    }

    public static Number number(Object object) {
        if (object instanceof Number) {
            return (Number)object;
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? ONE : ZERO;
        }
        if (object instanceof String) {
            Double value;
            try {
                value = new Double((String)object);
            }
            catch (NumberFormatException ex) {
                value = NaN;
            }
            return value;
        }
        if (object instanceof EvalContext) {
            return InfoSetUtil.number(InfoSetUtil.stringValue(object));
        }
        if (object instanceof NodePointer) {
            return InfoSetUtil.number(((NodePointer)object).getValue());
        }
        return ZERO;
    }

    public static double doubleValue(Object object) {
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 0.0 : 1.0;
        }
        if (object instanceof String) {
            double value;
            if (object.equals("")) {
                return 0.0;
            }
            try {
                value = Double.parseDouble((String)object);
            }
            catch (NumberFormatException ex) {
                value = Double.NaN;
            }
            return value;
        }
        if (object instanceof NodePointer) {
            return InfoSetUtil.doubleValue(((NodePointer)object).getValue());
        }
        if (object instanceof EvalContext) {
            return InfoSetUtil.doubleValue(InfoSetUtil.stringValue(object));
        }
        return 0.0;
    }

    public static boolean booleanValue(Object object) {
        if (object instanceof Number) {
            double value = ((Number)object).doubleValue();
            return value != 0.0 && value != 0.0 && !Double.isNaN(value);
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof EvalContext) {
            EvalContext ctx = (EvalContext)object;
            return ctx.nextSet() && ctx.nextNode();
        }
        if (object instanceof String) {
            return ((String)object).length() != 0;
        }
        if (object instanceof NodePointer) {
            return InfoSetUtil.booleanValue(((NodePointer)object).getValue());
        }
        return false;
    }
}

