/*
 * $Header: /home/cvs/jakarta-commons/jxpath/src/java/org/apache/commons/jxpath/JXPathBeanInfo.java,v 1.5 2003/03/11 00:59:12 dmitri Exp $
 * $Revision: 1.5 $
 * $Date: 2003/03/11 00:59:12 $
 *
 * ====================================================================
 * The Apache Software License, Version 1.1
 *
 *
 * Copyright (c) 1999-2003 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Commons", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation and was
 * originally based on software copyright (c) 2001, Plotnix, Inc,
 * <http://www.plotnix.com/>.
 * For more information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */
package org.apache.commons.jxpath;

import java.beans.PropertyDescriptor;

/**
 * JXPathBeanInfo  is similar to java.beans.BeanInfo in that it describes
 * properties of a JavaBean class.  By default, JXPathBeanInfo classes are
 * automatically generated by {@link JXPathIntrospector JXPathIntrospector}
 * based on the java.beans.BeanInfo. As with JavaBeans, the user can supply an
 * alternative implementation of JXPathBeanInfo for a custom class.  The
 * alternative implementation is located by class name, which is the same as the
 * name of the class it represents with the suffix "XBeanInfo".  So, for
 * example, if you need to provide an alternative JXPathBeanInfo class for class
 * "com.foo.Bar", write a class "com.foo.BarXBeanInfo" and make it implement the
 * JXPathBeanInfo interface.
 *
 * @author Dmitri Plotnikov
 * @version $Revision: 1.5 $ $Date: 2003/03/11 00:59:12 $
 */
public interface JXPathBeanInfo  {

    /**
     * Returns true if objects of this class are treated as atomic
     * objects which have no properties of their own.
     * For example, java.lang.String and java.lang.Number are atomic.
     */
    boolean isAtomic();

    /**
     * Returns true if the objects of this class have dynamic properties
     * (e.g. java.util.Map). If this method returns true, getPropertyDescriptors
     * should return null and getDynamicPropertyHandlerClass should return
     * a valid class name.  An object cannot have both static and dynamic
     * properties at the same time.
     */
    boolean isDynamic();

    /**
     * Returns a list of property descriptors for the beans described by this
     * bean info object.  Returns null for atomic beans.
     */
    PropertyDescriptor[] getPropertyDescriptors();

    /**
     * Returns a PropertyDescriptor for the specified name or null if there
     * is no such property.
     */
    PropertyDescriptor getPropertyDescriptor(String propertyName);

    /**
     * For dynamic objects, returns the class implementing
     * the DynamicPropertyHandler interface. That class can
     * be used to access dynamic properties.
     */
    Class getDynamicPropertyHandlerClass();
}