/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.jxpath.JXPathException;
import org.apache.commons.jxpath.NodeSet;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.util.TypeConverter;

public class BasicTypeConverter
implements TypeConverter {
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$Set;

    public boolean canConvert(Object object, Class toType) {
        if (object == null) {
            return true;
        }
        if (toType == (class$java$lang$Object == null ? (class$java$lang$Object = BasicTypeConverter.class$("java.lang.Object")) : class$java$lang$Object)) {
            return true;
        }
        Class<?> fromType = object.getClass();
        if (fromType.equals(toType)) {
            return true;
        }
        if (toType.isAssignableFrom(fromType)) {
            return true;
        }
        if (toType == (class$java$lang$String == null ? (class$java$lang$String = BasicTypeConverter.class$("java.lang.String")) : class$java$lang$String)) {
            return true;
        }
        if (object instanceof Boolean) {
            if (toType == Boolean.TYPE || (class$java$lang$Number == null ? (class$java$lang$Number = BasicTypeConverter.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(toType)) {
                return true;
            }
        } else if (object instanceof Number) {
            if (toType.isPrimitive() || (class$java$lang$Number == null ? (class$java$lang$Number = BasicTypeConverter.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(toType)) {
                return true;
            }
        } else if (object instanceof Character) {
            if (toType == Character.TYPE) {
                return true;
            }
        } else if (object instanceof String) {
            if (toType.isPrimitive()) {
                return true;
            }
            if (toType == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = BasicTypeConverter.class$("java.lang.Boolean")) : class$java$lang$Boolean) || toType == (class$java$lang$Character == null ? (class$java$lang$Character = BasicTypeConverter.class$("java.lang.Character")) : class$java$lang$Character) || toType == (class$java$lang$Byte == null ? (class$java$lang$Byte = BasicTypeConverter.class$("java.lang.Byte")) : class$java$lang$Byte) || toType == (class$java$lang$Short == null ? (class$java$lang$Short = BasicTypeConverter.class$("java.lang.Short")) : class$java$lang$Short) || toType == (class$java$lang$Integer == null ? (class$java$lang$Integer = BasicTypeConverter.class$("java.lang.Integer")) : class$java$lang$Integer) || toType == (class$java$lang$Long == null ? (class$java$lang$Long = BasicTypeConverter.class$("java.lang.Long")) : class$java$lang$Long) || toType == (class$java$lang$Float == null ? (class$java$lang$Float = BasicTypeConverter.class$("java.lang.Float")) : class$java$lang$Float) || toType == (class$java$lang$Double == null ? (class$java$lang$Double = BasicTypeConverter.class$("java.lang.Double")) : class$java$lang$Double)) {
                return true;
            }
        } else if (fromType.isArray()) {
            if (toType.isArray()) {
                Class<?> cType = toType.getComponentType();
                int length = Array.getLength(object);
                int i = 0;
                while (i < length) {
                    Object value = Array.get(object, i);
                    if (!this.canConvert(value, cType)) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            if ((class$java$util$Collection == null ? (class$java$util$Collection = BasicTypeConverter.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(toType)) {
                return BasicTypeConverter.canCreateCollection(toType);
            }
            if (Array.getLength(object) == 1) {
                Object value = Array.get(object, 0);
                return this.canConvert(value, toType);
            }
        } else if (object instanceof Collection) {
            if (toType.isArray()) {
                Class<?> cType = toType.getComponentType();
                Iterator it = ((Collection)object).iterator();
                while (it.hasNext()) {
                    Object value = it.next();
                    if (this.canConvert(value, cType)) continue;
                    return false;
                }
                return true;
            }
            if ((class$java$util$Collection == null ? (class$java$util$Collection = BasicTypeConverter.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(toType)) {
                return BasicTypeConverter.canCreateCollection(toType);
            }
            if (((Collection)object).size() == 1) {
                Object value;
                if (object instanceof List) {
                    value = ((List)object).get(0);
                } else {
                    Iterator it = ((Collection)object).iterator();
                    value = it.next();
                }
                return this.canConvert(value, toType);
            }
        } else {
            if (object instanceof NodeSet) {
                return this.canConvert(((NodeSet)object).getValues(), toType);
            }
            if (object instanceof Pointer) {
                return this.canConvert(((Pointer)object).getValue(), toType);
            }
        }
        return false;
    }

    public Object convert(Object object, Class toType) {
        if (object == null) {
            if (toType.isPrimitive()) {
                return this.convertNullToPrimitive(toType);
            }
            return null;
        }
        if (toType == (class$java$lang$Object == null ? (class$java$lang$Object = BasicTypeConverter.class$("java.lang.Object")) : class$java$lang$Object)) {
            return object;
        }
        Class<?> fromType = object.getClass();
        if (fromType.equals(toType) || toType.isAssignableFrom(fromType)) {
            return object;
        }
        if (toType == (class$java$lang$String == null ? (class$java$lang$String = BasicTypeConverter.class$("java.lang.String")) : class$java$lang$String)) {
            return object.toString();
        }
        if (object instanceof Boolean) {
            if (toType == Boolean.TYPE) {
                return object;
            }
            boolean value = (Boolean)object;
            return BasicTypeConverter.allocateNumber(toType, value ? 1.0 : 0.0);
        }
        if (object instanceof Number) {
            double value = ((Number)object).doubleValue();
            if (toType == Boolean.TYPE || toType == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = BasicTypeConverter.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                return value == 0.0 ? Boolean.FALSE : Boolean.TRUE;
            }
            if (toType.isPrimitive() || (class$java$lang$Number == null ? (class$java$lang$Number = BasicTypeConverter.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(toType)) {
                return BasicTypeConverter.allocateNumber(toType, value);
            }
        } else if (object instanceof Character) {
            if (toType == Character.TYPE) {
                return object;
            }
        } else if (object instanceof String) {
            Object value = this.convertStringToPrimitive(object, toType);
            if (value != null) {
                return value;
            }
        } else if (fromType.isArray()) {
            int length = Array.getLength(object);
            if (toType.isArray()) {
                Class<?> cType = toType.getComponentType();
                Object array = Array.newInstance(cType, length);
                int i = 0;
                while (i < length) {
                    Object value = Array.get(object, i);
                    Array.set(array, i, this.convert(value, cType));
                    ++i;
                }
                return array;
            }
            if ((class$java$util$Collection == null ? (class$java$util$Collection = BasicTypeConverter.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(toType)) {
                Collection collection = BasicTypeConverter.allocateCollection(toType);
                int i = 0;
                while (i < length) {
                    collection.add(Array.get(object, i));
                    ++i;
                }
                return this.unmodifiableCollection(collection);
            }
            if (length == 1) {
                Object value = Array.get(object, 0);
                return this.convert(value, toType);
            }
        } else {
            if (object instanceof Collection) {
                int length = ((Collection)object).size();
                if (toType.isArray()) {
                    Class<?> cType = toType.getComponentType();
                    Object array = Array.newInstance(cType, length);
                    Iterator it = ((Collection)object).iterator();
                    int i = 0;
                    while (i < length) {
                        Object value = it.next();
                        Array.set(array, i, this.convert(value, cType));
                        ++i;
                    }
                    return array;
                }
                if ((class$java$util$Collection == null ? (class$java$util$Collection = BasicTypeConverter.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(toType)) {
                    Collection collection = BasicTypeConverter.allocateCollection(toType);
                    collection.addAll((Collection)object);
                    return this.unmodifiableCollection(collection);
                }
                if (length == 1) {
                    Object value;
                    if (object instanceof List) {
                        value = ((List)object).get(0);
                    } else {
                        Iterator it = ((Collection)object).iterator();
                        value = it.next();
                    }
                    return this.convert(value, toType);
                }
                throw new RuntimeException("Cannot convert collection to " + toType + ", it contains " + length + " elements");
            }
            if (object instanceof NodeSet) {
                return this.convert(((NodeSet)object).getValues(), toType);
            }
            if (object instanceof Pointer) {
                return this.convert(((Pointer)object).getValue(), toType);
            }
        }
        throw new RuntimeException("Cannot convert " + object.getClass() + " to " + toType);
    }

    private Object convertNullToPrimitive(Class toType) {
        if (toType == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (toType == Character.TYPE) {
            return new Character('\u0000');
        }
        if (toType == Byte.TYPE) {
            return new Byte(0);
        }
        if (toType == Short.TYPE) {
            return new Short(0);
        }
        if (toType == Integer.TYPE) {
            return new Integer(0);
        }
        if (toType == Long.TYPE) {
            return new Long(0L);
        }
        if (toType == Float.TYPE) {
            return new Float(0.0f);
        }
        if (toType == Double.TYPE) {
            return new Double(0.0);
        }
        return null;
    }

    private Object convertStringToPrimitive(Object object, Class toType) {
        if (toType == Boolean.TYPE || toType == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = BasicTypeConverter.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            return Boolean.valueOf((String)object);
        }
        if (toType == Character.TYPE || toType == (class$java$lang$Character == null ? (class$java$lang$Character = BasicTypeConverter.class$("java.lang.Character")) : class$java$lang$Character)) {
            return new Character(((String)object).charAt(0));
        }
        if (toType == Byte.TYPE || toType == (class$java$lang$Byte == null ? (class$java$lang$Byte = BasicTypeConverter.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return new Byte((String)object);
        }
        if (toType == Short.TYPE || toType == (class$java$lang$Short == null ? (class$java$lang$Short = BasicTypeConverter.class$("java.lang.Short")) : class$java$lang$Short)) {
            return new Short((String)object);
        }
        if (toType == Integer.TYPE || toType == (class$java$lang$Integer == null ? (class$java$lang$Integer = BasicTypeConverter.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return new Integer((String)object);
        }
        if (toType == Long.TYPE || toType == (class$java$lang$Long == null ? (class$java$lang$Long = BasicTypeConverter.class$("java.lang.Long")) : class$java$lang$Long)) {
            return new Long((String)object);
        }
        if (toType == Float.TYPE || toType == (class$java$lang$Float == null ? (class$java$lang$Float = BasicTypeConverter.class$("java.lang.Float")) : class$java$lang$Float)) {
            return new Float((String)object);
        }
        if (toType == Double.TYPE || toType == (class$java$lang$Double == null ? (class$java$lang$Double = BasicTypeConverter.class$("java.lang.Double")) : class$java$lang$Double)) {
            return new Double((String)object);
        }
        return null;
    }

    private static Number allocateNumber(Class type, double value) {
        if (type == (class$java$lang$Byte == null ? (class$java$lang$Byte = BasicTypeConverter.class$("java.lang.Byte")) : class$java$lang$Byte) || type == Byte.TYPE) {
            return new Byte((byte)value);
        }
        if (type == (class$java$lang$Short == null ? (class$java$lang$Short = BasicTypeConverter.class$("java.lang.Short")) : class$java$lang$Short) || type == Short.TYPE) {
            return new Short((short)value);
        }
        if (type == (class$java$lang$Integer == null ? (class$java$lang$Integer = BasicTypeConverter.class$("java.lang.Integer")) : class$java$lang$Integer) || type == Integer.TYPE) {
            return new Integer((int)value);
        }
        if (type == (class$java$lang$Long == null ? (class$java$lang$Long = BasicTypeConverter.class$("java.lang.Long")) : class$java$lang$Long) || type == Long.TYPE) {
            return new Long((long)value);
        }
        if (type == (class$java$lang$Float == null ? (class$java$lang$Float = BasicTypeConverter.class$("java.lang.Float")) : class$java$lang$Float) || type == Float.TYPE) {
            return new Float((float)value);
        }
        if (type == (class$java$lang$Double == null ? (class$java$lang$Double = BasicTypeConverter.class$("java.lang.Double")) : class$java$lang$Double) || type == Double.TYPE) {
            return new Double(value);
        }
        return null;
    }

    private static boolean canCreateCollection(Class type) {
        if (!type.isInterface() && (type.getModifiers() | 0x400) == 0) {
            return true;
        }
        if (type == (class$java$util$List == null ? (class$java$util$List = BasicTypeConverter.class$("java.util.List")) : class$java$util$List)) {
            return true;
        }
        return type == (class$java$util$Set == null ? (class$java$util$Set = BasicTypeConverter.class$("java.util.Set")) : class$java$util$Set);
    }

    private static Collection allocateCollection(Class type) {
        if (!type.isInterface() && (type.getModifiers() | 0x400) == 0) {
            try {
                return (Collection)type.newInstance();
            }
            catch (Exception ex) {
                throw new JXPathException("Cannot create collection of type: " + type, ex);
            }
        }
        if (type == (class$java$util$List == null ? (class$java$util$List = BasicTypeConverter.class$("java.util.List")) : class$java$util$List)) {
            return new ArrayList();
        }
        if (type == (class$java$util$Set == null ? (class$java$util$Set = BasicTypeConverter.class$("java.util.Set")) : class$java$util$Set)) {
            return new HashSet();
        }
        throw new RuntimeException("Cannot create collection of type: " + type);
    }

    private Collection unmodifiableCollection(Collection collection) {
        if (collection instanceof List) {
            return Collections.unmodifiableList((List)collection);
        }
        if (collection instanceof Set) {
            return Collections.unmodifiableSet((Set)collection);
        }
        return collection;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static final class ValuePointer
    implements Pointer {
        private Object bean;

        public ValuePointer(Object object) {
            this.bean = object;
        }

        public Object getValue() {
            return this.bean;
        }

        public Object getNode() {
            return this.bean;
        }

        public Object getRootNode() {
            return this.bean;
        }

        public void setValue(Object value) {
            throw new UnsupportedOperationException();
        }

        public Object clone() {
            return this;
        }

        public int compareTo(Object object) {
            return 0;
        }

        public String asPath() {
            if (this.bean == null) {
                return "null()";
            }
            if (this.bean instanceof Number) {
                String string = this.bean.toString();
                if (string.endsWith(".0")) {
                    string = string.substring(0, string.length() - 2);
                }
                return string;
            }
            if (this.bean instanceof Boolean) {
                return (Boolean)this.bean != false ? "true()" : "false()";
            }
            if (this.bean instanceof String) {
                return "'" + this.bean + "'";
            }
            return "{object of type " + this.bean.getClass().getName() + "}";
        }
    }

    static class ValueNodeSet
    implements NodeSet {
        private List values;
        private List pointers;

        public ValueNodeSet(List values) {
            this.values = values;
        }

        public List getValues() {
            return Collections.unmodifiableList(this.values);
        }

        public List getNodes() {
            return Collections.unmodifiableList(this.values);
        }

        public List getPointers() {
            if (this.pointers == null) {
                this.pointers = new ArrayList();
                int i = 0;
                while (i < this.values.size()) {
                    this.pointers.add(new ValuePointer(this.values.get(i)));
                    ++i;
                }
                this.pointers = Collections.unmodifiableList(this.pointers);
            }
            return this.pointers;
        }
    }
}

