/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.xml;

import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import org.apache.commons.jxpath.Container;
import org.apache.commons.jxpath.JXPathException;
import org.apache.commons.jxpath.xml.XMLParser;

public class DocumentContainer
implements Container {
    public static final String MODEL_DOM = "DOM";
    public static final String MODEL_JDOM = "JDOM";
    private Object document;
    private URL xmlURL;
    private String model;
    private static HashMap parserClasses = new HashMap();
    private static HashMap parsers;

    public static void registerXMLParser(String model, XMLParser parser) {
        parsers.put(model, parser);
    }

    public DocumentContainer(URL xmlURL) {
        this(xmlURL, MODEL_DOM);
    }

    public DocumentContainer(URL xmlURL, String model) {
        this.xmlURL = xmlURL;
        if (xmlURL == null) {
            throw new JXPathException("XML URL is null");
        }
        this.model = model;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getValue() {
        if (this.document != null) return this.document;
        try {
            InputStream stream = null;
            try {
                if (this.xmlURL != null) {
                    stream = this.xmlURL.openStream();
                }
                this.document = DocumentContainer.getParser(this.model).parseXML(stream);
                Object var3_3 = null;
                if (stream == null) return this.document;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                if (stream == null) throw throwable;
                stream.close();
                throw throwable;
            }
            stream.close();
            return this.document;
        }
        catch (Exception ex) {
            throw new JXPathException("Cannot read XML from: " + this.xmlURL.toString(), ex);
        }
    }

    public void setValue(Object value) {
        throw new UnsupportedOperationException();
    }

    private static final XMLParser getParser(String model) {
        XMLParser parser = (XMLParser)parsers.get(model);
        if (parser == null) {
            String className = (String)parserClasses.get(model);
            if (className == null) {
                throw new JXPathException("Unsupported XML model: " + model);
            }
            try {
                Class<?> clazz = Class.forName(className);
                parser = (XMLParser)clazz.newInstance();
            }
            catch (Exception ex) {
                throw new JXPathException("Cannot allocate XMLParser: " + className);
            }
            parsers.put(model, parser);
        }
        return parser;
    }

    static {
        parserClasses.put(MODEL_DOM, "org.apache.commons.jxpath.xml.DOMParser");
        parserClasses.put(MODEL_JDOM, "org.apache.commons.jxpath.xml.JDOMParser");
        parsers = new HashMap();
    }
}

