/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.Arrays;
import junit.framework.TestCase;
import org.apache.commons.lang3.ArrayUtils;

public class ArrayUtilsAddTest
extends TestCase {
    public void testJira567() {
        Number[] n = (Number[])ArrayUtils.addAll((Object[])new Number[]{1}, (Object[])new Long[]{2L});
        ArrayUtilsAddTest.assertEquals((int)2, (int)n.length);
        ArrayUtilsAddTest.assertEquals(Number.class, n.getClass().getComponentType());
        try {
            n = (Number[])ArrayUtils.addAll((Object[])new Integer[]{1}, (Object[])new Long[]{2L});
            ArrayUtilsAddTest.fail((String)"Should have generated IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testAddObjectArrayBoolean() {
        boolean[] newArray = ArrayUtils.add((boolean[])null, (boolean)false);
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new boolean[]{false}, newArray));
        ArrayUtilsAddTest.assertEquals(Boolean.TYPE, newArray.getClass().getComponentType());
        newArray = ArrayUtils.add((boolean[])null, (boolean)true);
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new boolean[]{true}, newArray));
        ArrayUtilsAddTest.assertEquals(Boolean.TYPE, newArray.getClass().getComponentType());
        boolean[] array1 = new boolean[]{true, false, true};
        newArray = ArrayUtils.add((boolean[])array1, (boolean)false);
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new boolean[]{true, false, true, false}, newArray));
        ArrayUtilsAddTest.assertEquals(Boolean.TYPE, newArray.getClass().getComponentType());
    }

    public void testAddObjectArrayByte() {
        byte[] newArray = ArrayUtils.add((byte[])null, (byte)0);
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new byte[]{0}, newArray));
        ArrayUtilsAddTest.assertEquals(Byte.TYPE, newArray.getClass().getComponentType());
        newArray = ArrayUtils.add((byte[])null, (byte)1);
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new byte[]{1}, newArray));
        ArrayUtilsAddTest.assertEquals(Byte.TYPE, newArray.getClass().getComponentType());
        byte[] array1 = new byte[]{1, 2, 3};
        newArray = ArrayUtils.add((byte[])array1, (byte)0);
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new byte[]{1, 2, 3, 0}, newArray));
        ArrayUtilsAddTest.assertEquals(Byte.TYPE, newArray.getClass().getComponentType());
        newArray = ArrayUtils.add((byte[])array1, (byte)4);
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new byte[]{1, 2, 3, 4}, newArray));
        ArrayUtilsAddTest.assertEquals(Byte.TYPE, newArray.getClass().getComponentType());
    }

    public void testAddObjectArrayChar() {
        char[] newArray = ArrayUtils.add((char[])null, (char)'\u0000');
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new char[]{'\u0000'}, newArray));
        ArrayUtilsAddTest.assertEquals(Character.TYPE, newArray.getClass().getComponentType());
        newArray = ArrayUtils.add((char[])null, (char)'\u0001');
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new char[]{'\u0001'}, newArray));
        ArrayUtilsAddTest.assertEquals(Character.TYPE, newArray.getClass().getComponentType());
        char[] array1 = new char[]{'\u0001', '\u0002', '\u0003'};
        newArray = ArrayUtils.add((char[])array1, (char)'\u0000');
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new char[]{'\u0001', '\u0002', '\u0003', '\u0000'}, newArray));
        ArrayUtilsAddTest.assertEquals(Character.TYPE, newArray.getClass().getComponentType());
        newArray = ArrayUtils.add((char[])array1, (char)'\u0004');
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new char[]{'\u0001', '\u0002', '\u0003', '\u0004'}, newArray));
        ArrayUtilsAddTest.assertEquals(Character.TYPE, newArray.getClass().getComponentType());
    }

    public void testAddObjectArrayDouble() {
        double[] newArray = ArrayUtils.add((double[])null, (double)0.0);
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new double[]{0.0}, newArray));
        ArrayUtilsAddTest.assertEquals(Double.TYPE, newArray.getClass().getComponentType());
        newArray = ArrayUtils.add((double[])null, (double)1.0);
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new double[]{1.0}, newArray));
        ArrayUtilsAddTest.assertEquals(Double.TYPE, newArray.getClass().getComponentType());
        double[] array1 = new double[]{1.0, 2.0, 3.0};
        newArray = ArrayUtils.add((double[])array1, (double)0.0);
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new double[]{1.0, 2.0, 3.0, 0.0}, newArray));
        ArrayUtilsAddTest.assertEquals(Double.TYPE, newArray.getClass().getComponentType());
        newArray = ArrayUtils.add((double[])array1, (double)4.0);
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new double[]{1.0, 2.0, 3.0, 4.0}, newArray));
        ArrayUtilsAddTest.assertEquals(Double.TYPE, newArray.getClass().getComponentType());
    }

    public void testAddObjectArrayFloat() {
        float[] newArray = ArrayUtils.add((float[])null, (float)0.0f);
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new float[]{0.0f}, newArray));
        ArrayUtilsAddTest.assertEquals(Float.TYPE, newArray.getClass().getComponentType());
        newArray = ArrayUtils.add((float[])null, (float)1.0f);
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new float[]{1.0f}, newArray));
        ArrayUtilsAddTest.assertEquals(Float.TYPE, newArray.getClass().getComponentType());
        float[] array1 = new float[]{1.0f, 2.0f, 3.0f};
        newArray = ArrayUtils.add((float[])array1, (float)0.0f);
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new float[]{1.0f, 2.0f, 3.0f, 0.0f}, newArray));
        ArrayUtilsAddTest.assertEquals(Float.TYPE, newArray.getClass().getComponentType());
        newArray = ArrayUtils.add((float[])array1, (float)4.0f);
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new float[]{1.0f, 2.0f, 3.0f, 4.0f}, newArray));
        ArrayUtilsAddTest.assertEquals(Float.TYPE, newArray.getClass().getComponentType());
    }

    public void testAddObjectArrayInt() {
        int[] newArray = ArrayUtils.add((int[])null, (int)0);
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new int[]{0}, newArray));
        ArrayUtilsAddTest.assertEquals(Integer.TYPE, newArray.getClass().getComponentType());
        newArray = ArrayUtils.add((int[])null, (int)1);
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new int[]{1}, newArray));
        ArrayUtilsAddTest.assertEquals(Integer.TYPE, newArray.getClass().getComponentType());
        int[] array1 = new int[]{1, 2, 3};
        newArray = ArrayUtils.add((int[])array1, (int)0);
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new int[]{1, 2, 3, 0}, newArray));
        ArrayUtilsAddTest.assertEquals(Integer.TYPE, newArray.getClass().getComponentType());
        newArray = ArrayUtils.add((int[])array1, (int)4);
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new int[]{1, 2, 3, 4}, newArray));
        ArrayUtilsAddTest.assertEquals(Integer.TYPE, newArray.getClass().getComponentType());
    }

    public void testAddObjectArrayLong() {
        long[] newArray = ArrayUtils.add((long[])null, (long)0L);
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new long[]{0L}, newArray));
        ArrayUtilsAddTest.assertEquals(Long.TYPE, newArray.getClass().getComponentType());
        newArray = ArrayUtils.add((long[])null, (long)1L);
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new long[]{1L}, newArray));
        ArrayUtilsAddTest.assertEquals(Long.TYPE, newArray.getClass().getComponentType());
        long[] array1 = new long[]{1L, 2L, 3L};
        newArray = ArrayUtils.add((long[])array1, (long)0L);
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new long[]{1L, 2L, 3L, 0L}, newArray));
        ArrayUtilsAddTest.assertEquals(Long.TYPE, newArray.getClass().getComponentType());
        newArray = ArrayUtils.add((long[])array1, (long)4L);
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new long[]{1L, 2L, 3L, 4L}, newArray));
        ArrayUtilsAddTest.assertEquals(Long.TYPE, newArray.getClass().getComponentType());
    }

    public void testAddObjectArrayShort() {
        short[] newArray = ArrayUtils.add((short[])null, (short)0);
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new short[]{0}, newArray));
        ArrayUtilsAddTest.assertEquals(Short.TYPE, newArray.getClass().getComponentType());
        newArray = ArrayUtils.add((short[])null, (short)1);
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new short[]{1}, newArray));
        ArrayUtilsAddTest.assertEquals(Short.TYPE, newArray.getClass().getComponentType());
        short[] array1 = new short[]{1, 2, 3};
        newArray = ArrayUtils.add((short[])array1, (short)0);
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new short[]{1, 2, 3, 0}, newArray));
        ArrayUtilsAddTest.assertEquals(Short.TYPE, newArray.getClass().getComponentType());
        newArray = ArrayUtils.add((short[])array1, (short)4);
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new short[]{1, 2, 3, 4}, newArray));
        ArrayUtilsAddTest.assertEquals(Short.TYPE, newArray.getClass().getComponentType());
    }

    public void testAddObjectArrayObject() {
        Object[] newArray = ArrayUtils.add((Object[])null, (Object)"a");
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new String[]{"a"}, newArray));
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new Object[]{"a"}, newArray));
        ArrayUtilsAddTest.assertEquals(String.class, newArray.getClass().getComponentType());
        Object[] newStringArray = (String[])ArrayUtils.add(null, (Object)"a");
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new String[]{"a"}, newStringArray));
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new Object[]{"a"}, newStringArray));
        ArrayUtilsAddTest.assertEquals(String.class, newStringArray.getClass().getComponentType());
        Object[] stringArray1 = new String[]{"a", "b", "c"};
        newArray = ArrayUtils.add((Object[])stringArray1, null);
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new String[]{"a", "b", "c", null}, newArray));
        ArrayUtilsAddTest.assertEquals(String.class, newArray.getClass().getComponentType());
        newArray = ArrayUtils.add((Object[])stringArray1, (Object)"d");
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new String[]{"a", "b", "c", "d"}, newArray));
        ArrayUtilsAddTest.assertEquals(String.class, newArray.getClass().getComponentType());
        Object[] numberArray1 = new Number[]{new Integer(1), new Double(2.0)};
        newArray = ArrayUtils.add((Object[])numberArray1, (Object)new Float(3.0f));
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new Number[]{new Integer(1), new Double(2.0), new Float(3.0f)}, newArray));
        ArrayUtilsAddTest.assertEquals(Number.class, newArray.getClass().getComponentType());
        numberArray1 = null;
        newArray = ArrayUtils.add((Object[])numberArray1, (Object)new Float(3.0f));
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals((Object[])new Float[]{new Float(3.0f)}, newArray));
        ArrayUtilsAddTest.assertEquals(Float.class, newArray.getClass().getComponentType());
    }

    public void testLANG571() {
        String[] sa;
        Object[] stringArray = null;
        Object aString = null;
        try {
            sa = (String[])ArrayUtils.add(stringArray, aString);
            ArrayUtilsAddTest.fail((String)"Should have caused IllegalArgumentException");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            sa = (String[])ArrayUtils.add(stringArray, (int)0, aString);
            ArrayUtilsAddTest.fail((String)"Should have caused IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testAddObjectArrayToObjectArray() {
        ArrayUtilsAddTest.assertNull((Object)ArrayUtils.addAll((Object[])null, (Object[])null));
        Object[] stringArray1 = new String[]{"a", "b", "c"};
        Object[] stringArray2 = new String[]{"1", "2", "3"};
        Object[] newArray = ArrayUtils.addAll((Object[])stringArray1, (Object[])null);
        ArrayUtilsAddTest.assertNotSame((Object)stringArray1, (Object)newArray);
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(stringArray1, newArray));
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new String[]{"a", "b", "c"}, newArray));
        ArrayUtilsAddTest.assertEquals(String.class, newArray.getClass().getComponentType());
        newArray = ArrayUtils.addAll(null, (Object[])stringArray2);
        ArrayUtilsAddTest.assertNotSame((Object)stringArray2, (Object)newArray);
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(stringArray2, newArray));
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new String[]{"1", "2", "3"}, newArray));
        ArrayUtilsAddTest.assertEquals(String.class, newArray.getClass().getComponentType());
        newArray = ArrayUtils.addAll((Object[])stringArray1, (Object[])stringArray2);
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new String[]{"a", "b", "c", "1", "2", "3"}, newArray));
        ArrayUtilsAddTest.assertEquals(String.class, newArray.getClass().getComponentType());
        newArray = ArrayUtils.addAll((Object[])ArrayUtils.EMPTY_STRING_ARRAY, (Object[])null);
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_STRING_ARRAY, newArray));
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new String[0], newArray));
        ArrayUtilsAddTest.assertEquals(String.class, newArray.getClass().getComponentType());
        newArray = ArrayUtils.addAll(null, (Object[])ArrayUtils.EMPTY_STRING_ARRAY);
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_STRING_ARRAY, newArray));
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new String[0], newArray));
        ArrayUtilsAddTest.assertEquals(String.class, newArray.getClass().getComponentType());
        newArray = ArrayUtils.addAll((Object[])ArrayUtils.EMPTY_STRING_ARRAY, (Object[])ArrayUtils.EMPTY_STRING_ARRAY);
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_STRING_ARRAY, newArray));
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new String[0], newArray));
        ArrayUtilsAddTest.assertEquals(String.class, newArray.getClass().getComponentType());
        Object[] stringArrayNull = new String[]{null};
        newArray = ArrayUtils.addAll((Object[])stringArrayNull, (Object[])stringArrayNull);
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new String[]{null, null}, newArray));
        ArrayUtilsAddTest.assertEquals(String.class, newArray.getClass().getComponentType());
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new boolean[]{true, false, false, true}, ArrayUtils.addAll((boolean[])new boolean[]{true, false}, (boolean[])new boolean[]{false, true})));
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new boolean[]{false, true}, ArrayUtils.addAll(null, (boolean[])new boolean[]{false, true})));
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new boolean[]{true, false}, ArrayUtils.addAll((boolean[])new boolean[]{true, false}, null)));
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new char[]{'a', 'b', 'c', 'd'}, ArrayUtils.addAll((char[])new char[]{'a', 'b'}, (char[])new char[]{'c', 'd'})));
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new char[]{'c', 'd'}, ArrayUtils.addAll(null, (char[])new char[]{'c', 'd'})));
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new char[]{'a', 'b'}, ArrayUtils.addAll((char[])new char[]{'a', 'b'}, null)));
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new byte[]{0, 1, 2, 3}, ArrayUtils.addAll((byte[])new byte[]{0, 1}, (byte[])new byte[]{2, 3})));
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new byte[]{2, 3}, ArrayUtils.addAll(null, (byte[])new byte[]{2, 3})));
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new byte[]{0, 1}, ArrayUtils.addAll((byte[])new byte[]{0, 1}, null)));
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new short[]{10, 20, 30, 40}, ArrayUtils.addAll((short[])new short[]{10, 20}, (short[])new short[]{30, 40})));
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new short[]{30, 40}, ArrayUtils.addAll(null, (short[])new short[]{30, 40})));
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new short[]{10, 20}, ArrayUtils.addAll((short[])new short[]{10, 20}, null)));
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new int[]{1, 1000, -1000, -1}, ArrayUtils.addAll((int[])new int[]{1, 1000}, (int[])new int[]{-1000, -1})));
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new int[]{-1000, -1}, ArrayUtils.addAll(null, (int[])new int[]{-1000, -1})));
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new int[]{1, 1000}, ArrayUtils.addAll((int[])new int[]{1, 1000}, null)));
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new long[]{1L, -1L, 1000L, -1000L}, ArrayUtils.addAll((long[])new long[]{1L, -1L}, (long[])new long[]{1000L, -1000L})));
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new long[]{1000L, -1000L}, ArrayUtils.addAll(null, (long[])new long[]{1000L, -1000L})));
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new long[]{1L, -1L}, ArrayUtils.addAll((long[])new long[]{1L, -1L}, null)));
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new float[]{10.5f, 10.1f, 1.6f, 0.01f}, ArrayUtils.addAll((float[])new float[]{10.5f, 10.1f}, (float[])new float[]{1.6f, 0.01f})));
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new float[]{1.6f, 0.01f}, ArrayUtils.addAll(null, (float[])new float[]{1.6f, 0.01f})));
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new float[]{10.5f, 10.1f}, ArrayUtils.addAll((float[])new float[]{10.5f, 10.1f}, null)));
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new double[]{Math.PI, -Math.PI, 0.0, 9.99}, ArrayUtils.addAll((double[])new double[]{Math.PI, -Math.PI}, (double[])new double[]{0.0, 9.99})));
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new double[]{0.0, 9.99}, ArrayUtils.addAll(null, (double[])new double[]{0.0, 9.99})));
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new double[]{Math.PI, -Math.PI}, ArrayUtils.addAll((double[])new double[]{Math.PI, -Math.PI}, null)));
    }

    public void testAddObjectAtIndex() {
        Object[] newArray = ArrayUtils.add((Object[])null, (int)0, (Object)"a");
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new String[]{"a"}, newArray));
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new Object[]{"a"}, newArray));
        ArrayUtilsAddTest.assertEquals(String.class, newArray.getClass().getComponentType());
        Object[] stringArray1 = new String[]{"a", "b", "c"};
        newArray = ArrayUtils.add((Object[])stringArray1, (int)0, null);
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new String[]{null, "a", "b", "c"}, newArray));
        ArrayUtilsAddTest.assertEquals(String.class, newArray.getClass().getComponentType());
        newArray = ArrayUtils.add((Object[])stringArray1, (int)1, null);
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new String[]{"a", null, "b", "c"}, newArray));
        ArrayUtilsAddTest.assertEquals(String.class, newArray.getClass().getComponentType());
        newArray = ArrayUtils.add((Object[])stringArray1, (int)3, null);
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new String[]{"a", "b", "c", null}, newArray));
        ArrayUtilsAddTest.assertEquals(String.class, newArray.getClass().getComponentType());
        newArray = ArrayUtils.add((Object[])stringArray1, (int)3, (Object)"d");
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new String[]{"a", "b", "c", "d"}, newArray));
        ArrayUtilsAddTest.assertEquals(String.class, newArray.getClass().getComponentType());
        ArrayUtilsAddTest.assertEquals(String.class, newArray.getClass().getComponentType());
        Object[] o = new Object[]{"1", "2", "4"};
        Object[] result = ArrayUtils.add((Object[])o, (int)2, (Object)"3");
        Object[] result2 = ArrayUtils.add((Object[])o, (int)3, (Object)"5");
        ArrayUtilsAddTest.assertNotNull((Object)result);
        ArrayUtilsAddTest.assertEquals((int)4, (int)result.length);
        ArrayUtilsAddTest.assertEquals((Object)"1", (Object)result[0]);
        ArrayUtilsAddTest.assertEquals((Object)"2", (Object)result[1]);
        ArrayUtilsAddTest.assertEquals((Object)"3", (Object)result[2]);
        ArrayUtilsAddTest.assertEquals((Object)"4", (Object)result[3]);
        ArrayUtilsAddTest.assertNotNull((Object)result2);
        ArrayUtilsAddTest.assertEquals((int)4, (int)result2.length);
        ArrayUtilsAddTest.assertEquals((Object)"1", (Object)result2[0]);
        ArrayUtilsAddTest.assertEquals((Object)"2", (Object)result2[1]);
        ArrayUtilsAddTest.assertEquals((Object)"4", (Object)result2[2]);
        ArrayUtilsAddTest.assertEquals((Object)"5", (Object)result2[3]);
        boolean[] booleanArray = ArrayUtils.add(null, (int)0, (boolean)true);
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new boolean[]{true}, booleanArray));
        try {
            booleanArray = ArrayUtils.add(null, (int)-1, (boolean)true);
        }
        catch (IndexOutOfBoundsException e) {
            ArrayUtilsAddTest.assertEquals((String)"Index: -1, Length: 0", (String)e.getMessage());
        }
        booleanArray = ArrayUtils.add((boolean[])new boolean[]{true}, (int)0, (boolean)false);
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new boolean[]{false, true}, booleanArray));
        booleanArray = ArrayUtils.add((boolean[])new boolean[]{false}, (int)1, (boolean)true);
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new boolean[]{false, true}, booleanArray));
        booleanArray = ArrayUtils.add((boolean[])new boolean[]{true, false}, (int)1, (boolean)true);
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new boolean[]{true, true, false}, booleanArray));
        try {
            booleanArray = ArrayUtils.add((boolean[])new boolean[]{true, false}, (int)4, (boolean)true);
        }
        catch (IndexOutOfBoundsException e) {
            ArrayUtilsAddTest.assertEquals((String)"Index: 4, Length: 2", (String)e.getMessage());
        }
        try {
            booleanArray = ArrayUtils.add((boolean[])new boolean[]{true, false}, (int)-1, (boolean)true);
        }
        catch (IndexOutOfBoundsException e) {
            ArrayUtilsAddTest.assertEquals((String)"Index: -1, Length: 2", (String)e.getMessage());
        }
        char[] charArray = ArrayUtils.add((char[])null, (int)0, (char)'a');
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new char[]{'a'}, charArray));
        try {
            charArray = ArrayUtils.add((char[])null, (int)-1, (char)'a');
        }
        catch (IndexOutOfBoundsException e) {
            ArrayUtilsAddTest.assertEquals((String)"Index: -1, Length: 0", (String)e.getMessage());
        }
        charArray = ArrayUtils.add((char[])new char[]{'a'}, (int)0, (char)'b');
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new char[]{'b', 'a'}, charArray));
        charArray = ArrayUtils.add((char[])new char[]{'a', 'b'}, (int)0, (char)'c');
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new char[]{'c', 'a', 'b'}, charArray));
        charArray = ArrayUtils.add((char[])new char[]{'a', 'b'}, (int)1, (char)'k');
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new char[]{'a', 'k', 'b'}, charArray));
        charArray = ArrayUtils.add((char[])new char[]{'a', 'b', 'c'}, (int)1, (char)'t');
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new char[]{'a', 't', 'b', 'c'}, charArray));
        try {
            charArray = ArrayUtils.add((char[])new char[]{'a', 'b'}, (int)4, (char)'c');
        }
        catch (IndexOutOfBoundsException e) {
            ArrayUtilsAddTest.assertEquals((String)"Index: 4, Length: 2", (String)e.getMessage());
        }
        try {
            charArray = ArrayUtils.add((char[])new char[]{'a', 'b'}, (int)-1, (char)'c');
        }
        catch (IndexOutOfBoundsException e) {
            ArrayUtilsAddTest.assertEquals((String)"Index: -1, Length: 2", (String)e.getMessage());
        }
        short[] shortArray = ArrayUtils.add((short[])new short[]{1}, (int)0, (short)2);
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new short[]{2, 1}, shortArray));
        try {
            shortArray = ArrayUtils.add((short[])null, (int)-1, (short)2);
        }
        catch (IndexOutOfBoundsException e) {
            ArrayUtilsAddTest.assertEquals((String)"Index: -1, Length: 0", (String)e.getMessage());
        }
        shortArray = ArrayUtils.add((short[])new short[]{2, 6}, (int)2, (short)10);
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new short[]{2, 6, 10}, shortArray));
        shortArray = ArrayUtils.add((short[])new short[]{2, 6}, (int)0, (short)-4);
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new short[]{-4, 2, 6}, shortArray));
        shortArray = ArrayUtils.add((short[])new short[]{2, 6, 3}, (int)2, (short)1);
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new short[]{2, 6, 1, 3}, shortArray));
        try {
            shortArray = ArrayUtils.add((short[])new short[]{2, 6}, (int)4, (short)10);
        }
        catch (IndexOutOfBoundsException e) {
            ArrayUtilsAddTest.assertEquals((String)"Index: 4, Length: 2", (String)e.getMessage());
        }
        try {
            shortArray = ArrayUtils.add((short[])new short[]{2, 6}, (int)-1, (short)10);
        }
        catch (IndexOutOfBoundsException e) {
            ArrayUtilsAddTest.assertEquals((String)"Index: -1, Length: 2", (String)e.getMessage());
        }
        byte[] byteArray = ArrayUtils.add((byte[])new byte[]{1}, (int)0, (byte)2);
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new byte[]{2, 1}, byteArray));
        try {
            byteArray = ArrayUtils.add((byte[])null, (int)-1, (byte)2);
        }
        catch (IndexOutOfBoundsException e) {
            ArrayUtilsAddTest.assertEquals((String)"Index: -1, Length: 0", (String)e.getMessage());
        }
        byteArray = ArrayUtils.add((byte[])new byte[]{2, 6}, (int)2, (byte)3);
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new byte[]{2, 6, 3}, byteArray));
        byteArray = ArrayUtils.add((byte[])new byte[]{2, 6}, (int)0, (byte)1);
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new byte[]{1, 2, 6}, byteArray));
        byteArray = ArrayUtils.add((byte[])new byte[]{2, 6, 3}, (int)2, (byte)1);
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new byte[]{2, 6, 1, 3}, byteArray));
        try {
            byteArray = ArrayUtils.add((byte[])new byte[]{2, 6}, (int)4, (byte)3);
        }
        catch (IndexOutOfBoundsException e) {
            ArrayUtilsAddTest.assertEquals((String)"Index: 4, Length: 2", (String)e.getMessage());
        }
        try {
            byteArray = ArrayUtils.add((byte[])new byte[]{2, 6}, (int)-1, (byte)3);
        }
        catch (IndexOutOfBoundsException e) {
            ArrayUtilsAddTest.assertEquals((String)"Index: -1, Length: 2", (String)e.getMessage());
        }
        int[] intArray = ArrayUtils.add((int[])new int[]{1}, (int)0, (int)2);
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new int[]{2, 1}, intArray));
        try {
            intArray = ArrayUtils.add((int[])null, (int)-1, (int)2);
        }
        catch (IndexOutOfBoundsException e) {
            ArrayUtilsAddTest.assertEquals((String)"Index: -1, Length: 0", (String)e.getMessage());
        }
        intArray = ArrayUtils.add((int[])new int[]{2, 6}, (int)2, (int)10);
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new int[]{2, 6, 10}, intArray));
        intArray = ArrayUtils.add((int[])new int[]{2, 6}, (int)0, (int)-4);
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new int[]{-4, 2, 6}, intArray));
        intArray = ArrayUtils.add((int[])new int[]{2, 6, 3}, (int)2, (int)1);
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new int[]{2, 6, 1, 3}, intArray));
        try {
            intArray = ArrayUtils.add((int[])new int[]{2, 6}, (int)4, (int)10);
        }
        catch (IndexOutOfBoundsException e) {
            ArrayUtilsAddTest.assertEquals((String)"Index: 4, Length: 2", (String)e.getMessage());
        }
        try {
            intArray = ArrayUtils.add((int[])new int[]{2, 6}, (int)-1, (int)10);
        }
        catch (IndexOutOfBoundsException e) {
            ArrayUtilsAddTest.assertEquals((String)"Index: -1, Length: 2", (String)e.getMessage());
        }
        long[] longArray = ArrayUtils.add((long[])new long[]{1L}, (int)0, (long)2L);
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new long[]{2L, 1L}, longArray));
        try {
            longArray = ArrayUtils.add((long[])null, (int)-1, (long)2L);
        }
        catch (IndexOutOfBoundsException e) {
            ArrayUtilsAddTest.assertEquals((String)"Index: -1, Length: 0", (String)e.getMessage());
        }
        longArray = ArrayUtils.add((long[])new long[]{2L, 6L}, (int)2, (long)10L);
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new long[]{2L, 6L, 10L}, longArray));
        longArray = ArrayUtils.add((long[])new long[]{2L, 6L}, (int)0, (long)-4L);
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new long[]{-4L, 2L, 6L}, longArray));
        longArray = ArrayUtils.add((long[])new long[]{2L, 6L, 3L}, (int)2, (long)1L);
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new long[]{2L, 6L, 1L, 3L}, longArray));
        try {
            longArray = ArrayUtils.add((long[])new long[]{2L, 6L}, (int)4, (long)10L);
        }
        catch (IndexOutOfBoundsException e) {
            ArrayUtilsAddTest.assertEquals((String)"Index: 4, Length: 2", (String)e.getMessage());
        }
        try {
            longArray = ArrayUtils.add((long[])new long[]{2L, 6L}, (int)-1, (long)10L);
        }
        catch (IndexOutOfBoundsException e) {
            ArrayUtilsAddTest.assertEquals((String)"Index: -1, Length: 2", (String)e.getMessage());
        }
        float[] floatArray = ArrayUtils.add((float[])new float[]{1.1f}, (int)0, (float)2.2f);
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new float[]{2.2f, 1.1f}, floatArray));
        try {
            floatArray = ArrayUtils.add((float[])null, (int)-1, (float)2.2f);
        }
        catch (IndexOutOfBoundsException e) {
            ArrayUtilsAddTest.assertEquals((String)"Index: -1, Length: 0", (String)e.getMessage());
        }
        floatArray = ArrayUtils.add((float[])new float[]{2.3f, 6.4f}, (int)2, (float)10.5f);
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new float[]{2.3f, 6.4f, 10.5f}, floatArray));
        floatArray = ArrayUtils.add((float[])new float[]{2.6f, 6.7f}, (int)0, (float)-4.8f);
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new float[]{-4.8f, 2.6f, 6.7f}, floatArray));
        floatArray = ArrayUtils.add((float[])new float[]{2.9f, 6.0f, 0.3f}, (int)2, (float)1.0f);
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new float[]{2.9f, 6.0f, 1.0f, 0.3f}, floatArray));
        try {
            floatArray = ArrayUtils.add((float[])new float[]{2.3f, 6.4f}, (int)4, (float)10.5f);
        }
        catch (IndexOutOfBoundsException e) {
            ArrayUtilsAddTest.assertEquals((String)"Index: 4, Length: 2", (String)e.getMessage());
        }
        try {
            floatArray = ArrayUtils.add((float[])new float[]{2.3f, 6.4f}, (int)-1, (float)10.5f);
        }
        catch (IndexOutOfBoundsException e) {
            ArrayUtilsAddTest.assertEquals((String)"Index: -1, Length: 2", (String)e.getMessage());
        }
        double[] doubleArray = ArrayUtils.add((double[])new double[]{1.1}, (int)0, (double)2.2);
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new double[]{2.2, 1.1}, doubleArray));
        try {
            doubleArray = ArrayUtils.add((double[])null, (int)-1, (double)2.2);
        }
        catch (IndexOutOfBoundsException e) {
            ArrayUtilsAddTest.assertEquals((String)"Index: -1, Length: 0", (String)e.getMessage());
        }
        doubleArray = ArrayUtils.add((double[])new double[]{2.3, 6.4}, (int)2, (double)10.5);
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new double[]{2.3, 6.4, 10.5}, doubleArray));
        doubleArray = ArrayUtils.add((double[])new double[]{2.6, 6.7}, (int)0, (double)-4.8);
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new double[]{-4.8, 2.6, 6.7}, doubleArray));
        doubleArray = ArrayUtils.add((double[])new double[]{2.9, 6.0, 0.3}, (int)2, (double)1.0);
        ArrayUtilsAddTest.assertTrue((boolean)Arrays.equals(new double[]{2.9, 6.0, 1.0, 0.3}, doubleArray));
        try {
            doubleArray = ArrayUtils.add((double[])new double[]{2.3, 6.4}, (int)4, (double)10.5);
        }
        catch (IndexOutOfBoundsException e) {
            ArrayUtilsAddTest.assertEquals((String)"Index: 4, Length: 2", (String)e.getMessage());
        }
        try {
            doubleArray = ArrayUtils.add((double[])new double[]{2.3, 6.4}, (int)-1, (double)10.5);
        }
        catch (IndexOutOfBoundsException e) {
            ArrayUtilsAddTest.assertEquals((String)"Index: -1, Length: 2", (String)e.getMessage());
        }
    }
}

