/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.sql.Date;
import java.util.Arrays;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayUtilsTest
extends TestCase {
    public ArrayUtilsTest(String name) {
        super(name);
    }

    public void testConstructor() {
        ArrayUtilsTest.assertNotNull((Object)new ArrayUtils());
        Constructor<?>[] cons = ArrayUtils.class.getDeclaredConstructors();
        ArrayUtilsTest.assertEquals((int)1, (int)cons.length);
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)Modifier.isPublic(cons[0].getModifiers()));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)Modifier.isPublic(ArrayUtils.class.getModifiers()));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)Modifier.isFinal(ArrayUtils.class.getModifiers()));
    }

    public void testToString() {
        ArrayUtilsTest.assertEquals((String)"{}", (String)ArrayUtils.toString(null));
        ArrayUtilsTest.assertEquals((String)"{}", (String)ArrayUtils.toString((Object)new Object[0]));
        ArrayUtilsTest.assertEquals((String)"{}", (String)ArrayUtils.toString((Object)new String[0]));
        ArrayUtilsTest.assertEquals((String)"{<null>}", (String)ArrayUtils.toString((Object)new String[]{null}));
        ArrayUtilsTest.assertEquals((String)"{pink,blue}", (String)ArrayUtils.toString((Object)new String[]{"pink", "blue"}));
        ArrayUtilsTest.assertEquals((String)"<empty>", (String)ArrayUtils.toString(null, (String)"<empty>"));
        ArrayUtilsTest.assertEquals((String)"{}", (String)ArrayUtils.toString((Object)new Object[0], (String)"<empty>"));
        ArrayUtilsTest.assertEquals((String)"{}", (String)ArrayUtils.toString((Object)new String[0], (String)"<empty>"));
        ArrayUtilsTest.assertEquals((String)"{<null>}", (String)ArrayUtils.toString((Object)new String[]{null}, (String)"<empty>"));
        ArrayUtilsTest.assertEquals((String)"{pink,blue}", (String)ArrayUtils.toString((Object)new String[]{"pink", "blue"}, (String)"<empty>"));
    }

    public void testHashCode() {
        long[][] array1 = new long[][]{{2L, 5L}, {4L, 5L}};
        long[][] array2 = new long[][]{{2L, 5L}, {4L, 6L}};
        ArrayUtilsTest.assertEquals((boolean)true, (ArrayUtils.hashCode((Object)array1) == ArrayUtils.hashCode((Object)array1) ? 1 : 0) != 0);
        ArrayUtilsTest.assertEquals((boolean)false, (ArrayUtils.hashCode((Object)array1) == ArrayUtils.hashCode((Object)array2) ? 1 : 0) != 0);
        Object[] array3 = new Object[]{new String(new char[]{'A', 'B'})};
        Object[] array4 = new Object[]{"AB"};
        ArrayUtilsTest.assertEquals((boolean)true, (ArrayUtils.hashCode((Object)array3) == ArrayUtils.hashCode((Object)array3) ? 1 : 0) != 0);
        ArrayUtilsTest.assertEquals((boolean)true, (ArrayUtils.hashCode((Object)array3) == ArrayUtils.hashCode((Object)array4) ? 1 : 0) != 0);
        Object[] arrayA = new Object[]{new boolean[]{true, false}, new int[]{6, 7}};
        Object[] arrayB = new Object[]{new boolean[]{true, false}, new int[]{6, 7}};
        ArrayUtilsTest.assertEquals((boolean)true, (ArrayUtils.hashCode((Object)arrayB) == ArrayUtils.hashCode((Object)arrayA) ? 1 : 0) != 0);
    }

    private void assertIsEquals(Object array1, Object array2, Object array3) {
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isEquals((Object)array1, (Object)array1));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isEquals((Object)array2, (Object)array2));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isEquals((Object)array3, (Object)array3));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isEquals((Object)array1, (Object)array2));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isEquals((Object)array2, (Object)array1));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isEquals((Object)array1, (Object)array3));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isEquals((Object)array3, (Object)array1));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isEquals((Object)array1, (Object)array2));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isEquals((Object)array2, (Object)array1));
    }

    public void testIsEquals() {
        long[][] larray1 = new long[][]{{2L, 5L}, {4L, 5L}};
        long[][] larray2 = new long[][]{{2L, 5L}, {4L, 6L}};
        long[] larray3 = new long[]{2L, 5L};
        this.assertIsEquals(larray1, larray2, larray3);
        int[][] iarray1 = new int[][]{{2, 5}, {4, 5}};
        int[][] iarray2 = new int[][]{{2, 5}, {4, 6}};
        int[] iarray3 = new int[]{2, 5};
        this.assertIsEquals(iarray1, iarray2, iarray3);
        short[][] sarray1 = new short[][]{{2, 5}, {4, 5}};
        short[][] sarray2 = new short[][]{{2, 5}, {4, 6}};
        short[] sarray3 = new short[]{2, 5};
        this.assertIsEquals(sarray1, sarray2, sarray3);
        float[][] farray1 = new float[][]{{2.0f, 5.0f}, {4.0f, 5.0f}};
        float[][] farray2 = new float[][]{{2.0f, 5.0f}, {4.0f, 6.0f}};
        float[] farray3 = new float[]{2.0f, 5.0f};
        this.assertIsEquals(farray1, farray2, farray3);
        double[][] darray1 = new double[][]{{2.0, 5.0}, {4.0, 5.0}};
        double[][] darray2 = new double[][]{{2.0, 5.0}, {4.0, 6.0}};
        double[] darray3 = new double[]{2.0, 5.0};
        this.assertIsEquals(darray1, darray2, darray3);
        byte[][] byteArray1 = new byte[][]{{2, 5}, {4, 5}};
        byte[][] byteArray2 = new byte[][]{{2, 5}, {4, 6}};
        byte[] byteArray3 = new byte[]{2, 5};
        this.assertIsEquals(byteArray1, byteArray2, byteArray3);
        char[][] charArray1 = new char[][]{{'\u0002', '\u0005'}, {'\u0004', '\u0005'}};
        char[][] charArray2 = new char[][]{{'\u0002', '\u0005'}, {'\u0004', '\u0006'}};
        char[] charArray3 = new char[]{'\u0002', '\u0005'};
        this.assertIsEquals(charArray1, charArray2, charArray3);
        boolean[][] barray1 = new boolean[][]{{true, false}, {true, true}};
        boolean[][] barray2 = new boolean[][]{{true, false}, {true, false}};
        boolean[] barray3 = new boolean[]{false, true};
        this.assertIsEquals(barray1, barray2, barray3);
        Object[] array3 = new Object[]{new String(new char[]{'A', 'B'})};
        Object[] array4 = new Object[]{"AB"};
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isEquals((Object)array3, (Object)array3));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isEquals((Object)array3, (Object)array4));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isEquals(null, null));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isEquals(null, (Object)array4));
    }

    public void testArrayCreation() {
        String[] array = (String[])ArrayUtils.toArray((Object[])new String[]{"foo", "bar"});
        ArrayUtilsTest.assertEquals((int)2, (int)array.length);
        ArrayUtilsTest.assertEquals((String)"foo", (String)array[0]);
        ArrayUtilsTest.assertEquals((String)"bar", (String)array[1]);
    }

    public void testArrayCreationWithGeneralReturnType() {
        Object[] obj = ArrayUtils.toArray((Object[])new String[]{"foo", "bar"});
        ArrayUtilsTest.assertTrue((boolean)(obj instanceof String[]));
    }

    public void testArrayCreationWithDifferentTypes() {
        Number[] array = (Number[])ArrayUtils.toArray((Object[])new Number[]{42, Math.PI});
        ArrayUtilsTest.assertEquals((int)2, (int)array.length);
        ArrayUtilsTest.assertEquals((Object)42, (Object)array[0]);
        ArrayUtilsTest.assertEquals((Object)Math.PI, (Object)array[1]);
    }

    public void testIndirectArrayCreation() {
        String[] array = ArrayUtilsTest.toArrayPropagatingType("foo", "bar");
        ArrayUtilsTest.assertEquals((int)2, (int)array.length);
        ArrayUtilsTest.assertEquals((String)"foo", (String)array[0]);
        ArrayUtilsTest.assertEquals((String)"bar", (String)array[1]);
    }

    public void testEmptyArrayCreation() {
        String[] array = (String[])ArrayUtils.toArray((Object[])new String[0]);
        ArrayUtilsTest.assertEquals((int)0, (int)array.length);
    }

    public void testIndirectEmptyArrayCreation() {
        String[] array = ArrayUtilsTest.toArrayPropagatingType(new String[0]);
        ArrayUtilsTest.assertEquals((int)0, (int)array.length);
    }

    private static <T> T[] toArrayPropagatingType(T ... items) {
        return ArrayUtils.toArray((Object[])items);
    }

    public void testToMap() {
        Map map = ArrayUtils.toMap((Object[])new String[][]{{"foo", "bar"}, {"hello", "world"}});
        ArrayUtilsTest.assertEquals((Object)"bar", map.get("foo"));
        ArrayUtilsTest.assertEquals((Object)"world", map.get("hello"));
        ArrayUtilsTest.assertEquals(null, (Object)ArrayUtils.toMap(null));
        try {
            ArrayUtils.toMap((Object[])new String[][]{{"foo", "bar"}, {"short"}});
            ArrayUtilsTest.fail((String)"exception expected");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            ArrayUtils.toMap((Object[])new Object[]{new Object[]{"foo", "bar"}, "illegal type"});
            ArrayUtilsTest.fail((String)"exception expected");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            ArrayUtils.toMap((Object[])new Object[]{new Object[]{"foo", "bar"}, null});
            ArrayUtilsTest.fail((String)"exception expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        map = ArrayUtils.toMap((Object[])new Object[]{new Map.Entry<Object, Object>(){

            @Override
            public Object getKey() {
                return "foo";
            }

            @Override
            public Object getValue() {
                return "bar";
            }

            @Override
            public Object setValue(Object value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean equals(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int hashCode() {
                throw new UnsupportedOperationException();
            }
        }});
        ArrayUtilsTest.assertEquals((Object)"bar", map.get("foo"));
    }

    public void testClone() {
        ArrayUtilsTest.assertEquals(null, (Object)ArrayUtils.clone((Object[])null));
        Object[] original1 = new Object[]{};
        Object[] cloned1 = ArrayUtils.clone((Object[])original1);
        ArrayUtilsTest.assertTrue((boolean)Arrays.equals(original1, cloned1));
        ArrayUtilsTest.assertTrue((original1 != cloned1 ? 1 : 0) != 0);
        StringBuffer buf = new StringBuffer("pick");
        original1 = new Object[]{buf, "a", new String[]{"stick"}};
        cloned1 = ArrayUtils.clone((Object[])original1);
        ArrayUtilsTest.assertTrue((boolean)Arrays.equals(original1, cloned1));
        ArrayUtilsTest.assertTrue((original1 != cloned1 ? 1 : 0) != 0);
        ArrayUtilsTest.assertSame((Object)original1[0], (Object)cloned1[0]);
        ArrayUtilsTest.assertSame((Object)original1[1], (Object)cloned1[1]);
        ArrayUtilsTest.assertSame((Object)original1[2], (Object)cloned1[2]);
    }

    public void testCloneBoolean() {
        ArrayUtilsTest.assertEquals(null, (Object)ArrayUtils.clone((boolean[])null));
        boolean[] original = new boolean[]{true, false};
        boolean[] cloned = ArrayUtils.clone((boolean[])original);
        ArrayUtilsTest.assertTrue((boolean)Arrays.equals(original, cloned));
        ArrayUtilsTest.assertTrue((original != cloned ? 1 : 0) != 0);
    }

    public void testCloneLong() {
        ArrayUtilsTest.assertEquals(null, (Object)ArrayUtils.clone((long[])null));
        long[] original = new long[]{0L, 1L};
        long[] cloned = ArrayUtils.clone((long[])original);
        ArrayUtilsTest.assertTrue((boolean)Arrays.equals(original, cloned));
        ArrayUtilsTest.assertTrue((original != cloned ? 1 : 0) != 0);
    }

    public void testCloneInt() {
        ArrayUtilsTest.assertEquals(null, (Object)ArrayUtils.clone((int[])null));
        int[] original = new int[]{5, 8};
        int[] cloned = ArrayUtils.clone((int[])original);
        ArrayUtilsTest.assertTrue((boolean)Arrays.equals(original, cloned));
        ArrayUtilsTest.assertTrue((original != cloned ? 1 : 0) != 0);
    }

    public void testCloneShort() {
        ArrayUtilsTest.assertEquals(null, (Object)ArrayUtils.clone((short[])null));
        short[] original = new short[]{1, 4};
        short[] cloned = ArrayUtils.clone((short[])original);
        ArrayUtilsTest.assertTrue((boolean)Arrays.equals(original, cloned));
        ArrayUtilsTest.assertTrue((original != cloned ? 1 : 0) != 0);
    }

    public void testCloneChar() {
        ArrayUtilsTest.assertEquals(null, (Object)ArrayUtils.clone((char[])null));
        char[] original = new char[]{'a', '4'};
        char[] cloned = ArrayUtils.clone((char[])original);
        ArrayUtilsTest.assertTrue((boolean)Arrays.equals(original, cloned));
        ArrayUtilsTest.assertTrue((original != cloned ? 1 : 0) != 0);
    }

    public void testCloneByte() {
        ArrayUtilsTest.assertEquals(null, (Object)ArrayUtils.clone((byte[])null));
        byte[] original = new byte[]{1, 6};
        byte[] cloned = ArrayUtils.clone((byte[])original);
        ArrayUtilsTest.assertTrue((boolean)Arrays.equals(original, cloned));
        ArrayUtilsTest.assertTrue((original != cloned ? 1 : 0) != 0);
    }

    public void testCloneDouble() {
        ArrayUtilsTest.assertEquals(null, (Object)ArrayUtils.clone((double[])null));
        double[] original = new double[]{2.4, 5.7};
        double[] cloned = ArrayUtils.clone((double[])original);
        ArrayUtilsTest.assertTrue((boolean)Arrays.equals(original, cloned));
        ArrayUtilsTest.assertTrue((original != cloned ? 1 : 0) != 0);
    }

    public void testCloneFloat() {
        ArrayUtilsTest.assertEquals(null, (Object)ArrayUtils.clone((float[])null));
        float[] original = new float[]{2.6f, 6.4f};
        float[] cloned = ArrayUtils.clone((float[])original);
        ArrayUtilsTest.assertTrue((boolean)Arrays.equals(original, cloned));
        ArrayUtilsTest.assertTrue((original != cloned ? 1 : 0) != 0);
    }

    public void testNullToEmptyBoolean() {
        ArrayUtilsTest.assertEquals((Object)ArrayUtils.EMPTY_BOOLEAN_ARRAY, (Object)ArrayUtils.nullToEmpty((boolean[])null));
        boolean[] original = new boolean[]{true, false};
        ArrayUtilsTest.assertEquals((Object)original, (Object)ArrayUtils.nullToEmpty((boolean[])original));
        boolean[] empty = new boolean[]{};
        boolean[] result = ArrayUtils.nullToEmpty((boolean[])empty);
        ArrayUtilsTest.assertEquals((Object)ArrayUtils.EMPTY_BOOLEAN_ARRAY, (Object)result);
        ArrayUtilsTest.assertTrue((empty != result ? 1 : 0) != 0);
    }

    public void testNullToEmptyLong() {
        ArrayUtilsTest.assertEquals((Object)ArrayUtils.EMPTY_LONG_ARRAY, (Object)ArrayUtils.nullToEmpty((long[])null));
        long[] original = new long[]{1L, 2L};
        ArrayUtilsTest.assertEquals((Object)original, (Object)ArrayUtils.nullToEmpty((long[])original));
        long[] empty = new long[]{};
        long[] result = ArrayUtils.nullToEmpty((long[])empty);
        ArrayUtilsTest.assertEquals((Object)ArrayUtils.EMPTY_LONG_ARRAY, (Object)result);
        ArrayUtilsTest.assertTrue((empty != result ? 1 : 0) != 0);
    }

    public void testNullToEmptyInt() {
        ArrayUtilsTest.assertEquals((Object)ArrayUtils.EMPTY_INT_ARRAY, (Object)ArrayUtils.nullToEmpty((int[])null));
        int[] original = new int[]{1, 2};
        ArrayUtilsTest.assertEquals((Object)original, (Object)ArrayUtils.nullToEmpty((int[])original));
        int[] empty = new int[]{};
        int[] result = ArrayUtils.nullToEmpty((int[])empty);
        ArrayUtilsTest.assertEquals((Object)ArrayUtils.EMPTY_INT_ARRAY, (Object)result);
        ArrayUtilsTest.assertTrue((empty != result ? 1 : 0) != 0);
    }

    public void testNullToEmptyShort() {
        ArrayUtilsTest.assertEquals((Object)ArrayUtils.EMPTY_SHORT_ARRAY, (Object)ArrayUtils.nullToEmpty((short[])null));
        short[] original = new short[]{1, 2};
        ArrayUtilsTest.assertEquals((Object)original, (Object)ArrayUtils.nullToEmpty((short[])original));
        short[] empty = new short[]{};
        short[] result = ArrayUtils.nullToEmpty((short[])empty);
        ArrayUtilsTest.assertEquals((Object)ArrayUtils.EMPTY_SHORT_ARRAY, (Object)result);
        ArrayUtilsTest.assertTrue((empty != result ? 1 : 0) != 0);
    }

    public void testNullToEmptyChar() {
        ArrayUtilsTest.assertEquals((Object)ArrayUtils.EMPTY_CHAR_ARRAY, (Object)ArrayUtils.nullToEmpty((char[])null));
        char[] original = new char[]{'a', 'b'};
        ArrayUtilsTest.assertEquals((Object)original, (Object)ArrayUtils.nullToEmpty((char[])original));
        char[] empty = new char[]{};
        char[] result = ArrayUtils.nullToEmpty((char[])empty);
        ArrayUtilsTest.assertEquals((Object)ArrayUtils.EMPTY_CHAR_ARRAY, (Object)result);
        ArrayUtilsTest.assertTrue((empty != result ? 1 : 0) != 0);
    }

    public void testNullToEmptyByte() {
        ArrayUtilsTest.assertEquals((Object)ArrayUtils.EMPTY_BYTE_ARRAY, (Object)ArrayUtils.nullToEmpty((byte[])null));
        byte[] original = new byte[]{15, 14};
        ArrayUtilsTest.assertEquals((Object)original, (Object)ArrayUtils.nullToEmpty((byte[])original));
        byte[] empty = new byte[]{};
        byte[] result = ArrayUtils.nullToEmpty((byte[])empty);
        ArrayUtilsTest.assertEquals((Object)ArrayUtils.EMPTY_BYTE_ARRAY, (Object)result);
        ArrayUtilsTest.assertTrue((empty != result ? 1 : 0) != 0);
    }

    public void testNullToEmptyDouble() {
        ArrayUtilsTest.assertEquals((Object)ArrayUtils.EMPTY_DOUBLE_ARRAY, (Object)ArrayUtils.nullToEmpty((double[])null));
        double[] original = new double[]{1.0, 2.0};
        ArrayUtilsTest.assertEquals((Object)original, (Object)ArrayUtils.nullToEmpty((double[])original));
        double[] empty = new double[]{};
        double[] result = ArrayUtils.nullToEmpty((double[])empty);
        ArrayUtilsTest.assertEquals((Object)ArrayUtils.EMPTY_DOUBLE_ARRAY, (Object)result);
        ArrayUtilsTest.assertTrue((empty != result ? 1 : 0) != 0);
    }

    public void testNullToEmptyFloat() {
        ArrayUtilsTest.assertEquals((Object)ArrayUtils.EMPTY_FLOAT_ARRAY, (Object)ArrayUtils.nullToEmpty((float[])null));
        float[] original = new float[]{2.6f, 3.8f};
        ArrayUtilsTest.assertEquals((Object)original, (Object)ArrayUtils.nullToEmpty((float[])original));
        float[] empty = new float[]{};
        float[] result = ArrayUtils.nullToEmpty((float[])empty);
        ArrayUtilsTest.assertEquals((Object)ArrayUtils.EMPTY_FLOAT_ARRAY, (Object)result);
        ArrayUtilsTest.assertTrue((empty != result ? 1 : 0) != 0);
    }

    public void testNullToEmptyObject() {
        ArrayUtilsTest.assertEquals((Object)ArrayUtils.EMPTY_OBJECT_ARRAY, (Object)ArrayUtils.nullToEmpty((Object[])null));
        Object[] original = new Object[]{true, false};
        ArrayUtilsTest.assertEquals((Object)original, (Object)ArrayUtils.nullToEmpty((Object[])original));
        Object[] empty = new Object[]{};
        Object[] result = ArrayUtils.nullToEmpty((Object[])empty);
        ArrayUtilsTest.assertEquals((Object)ArrayUtils.EMPTY_OBJECT_ARRAY, (Object)result);
        ArrayUtilsTest.assertTrue((empty != result ? 1 : 0) != 0);
    }

    public void testNullToEmptyString() {
        ArrayUtilsTest.assertEquals((Object)ArrayUtils.EMPTY_STRING_ARRAY, (Object)ArrayUtils.nullToEmpty((String[])null));
        String[] original = new String[]{"abc", "def"};
        ArrayUtilsTest.assertEquals((Object)original, (Object)ArrayUtils.nullToEmpty((String[])original));
        String[] empty = new String[]{};
        String[] result = ArrayUtils.nullToEmpty((String[])empty);
        ArrayUtilsTest.assertEquals((Object)ArrayUtils.EMPTY_STRING_ARRAY, (Object)result);
        ArrayUtilsTest.assertTrue((empty != result ? 1 : 0) != 0);
    }

    public void testNullToEmptyBooleanObject() {
        ArrayUtilsTest.assertEquals((Object)ArrayUtils.EMPTY_BOOLEAN_OBJECT_ARRAY, (Object)ArrayUtils.nullToEmpty((Boolean[])null));
        Boolean[] original = new Boolean[]{Boolean.TRUE, Boolean.FALSE};
        ArrayUtilsTest.assertEquals((Object)original, (Object)ArrayUtils.nullToEmpty((Boolean[])original));
        Boolean[] empty = new Boolean[]{};
        Boolean[] result = ArrayUtils.nullToEmpty((Boolean[])empty);
        ArrayUtilsTest.assertEquals((Object)ArrayUtils.EMPTY_BOOLEAN_OBJECT_ARRAY, (Object)result);
        ArrayUtilsTest.assertTrue((empty != result ? 1 : 0) != 0);
    }

    public void testNullToEmptyLongObject() {
        ArrayUtilsTest.assertEquals((Object)ArrayUtils.EMPTY_LONG_OBJECT_ARRAY, (Object)ArrayUtils.nullToEmpty((Long[])null));
        Long[] original = new Long[]{1L, 2L};
        ArrayUtilsTest.assertEquals((Object)original, (Object)ArrayUtils.nullToEmpty((Long[])original));
        Long[] empty = new Long[]{};
        Long[] result = ArrayUtils.nullToEmpty((Long[])empty);
        ArrayUtilsTest.assertEquals((Object)ArrayUtils.EMPTY_LONG_OBJECT_ARRAY, (Object)result);
        ArrayUtilsTest.assertTrue((empty != result ? 1 : 0) != 0);
    }

    public void testNullToEmptyIntObject() {
        ArrayUtilsTest.assertEquals((Object)ArrayUtils.EMPTY_INTEGER_OBJECT_ARRAY, (Object)ArrayUtils.nullToEmpty((Integer[])null));
        Integer[] original = new Integer[]{1, 2};
        ArrayUtilsTest.assertEquals((Object)original, (Object)ArrayUtils.nullToEmpty((Integer[])original));
        Integer[] empty = new Integer[]{};
        Integer[] result = ArrayUtils.nullToEmpty((Integer[])empty);
        ArrayUtilsTest.assertEquals((Object)ArrayUtils.EMPTY_INTEGER_OBJECT_ARRAY, (Object)result);
        ArrayUtilsTest.assertTrue((empty != result ? 1 : 0) != 0);
    }

    public void testNullToEmptyShortObject() {
        ArrayUtilsTest.assertEquals((Object)ArrayUtils.EMPTY_SHORT_OBJECT_ARRAY, (Object)ArrayUtils.nullToEmpty((Short[])null));
        Short[] original = new Short[]{(short)1, (short)2};
        ArrayUtilsTest.assertEquals((Object)original, (Object)ArrayUtils.nullToEmpty((Short[])original));
        Short[] empty = new Short[]{};
        Short[] result = ArrayUtils.nullToEmpty((Short[])empty);
        ArrayUtilsTest.assertEquals((Object)ArrayUtils.EMPTY_SHORT_OBJECT_ARRAY, (Object)result);
        ArrayUtilsTest.assertTrue((empty != result ? 1 : 0) != 0);
    }

    public void testNullToEmptyCharObject() {
        ArrayUtilsTest.assertEquals((Object)ArrayUtils.EMPTY_CHARACTER_OBJECT_ARRAY, (Object)ArrayUtils.nullToEmpty((Character[])null));
        Character[] original = new Character[]{Character.valueOf('a'), Character.valueOf('b')};
        ArrayUtilsTest.assertEquals((Object)original, (Object)ArrayUtils.nullToEmpty((Character[])original));
        Character[] empty = new Character[]{};
        Character[] result = ArrayUtils.nullToEmpty((Character[])empty);
        ArrayUtilsTest.assertEquals((Object)ArrayUtils.EMPTY_CHARACTER_OBJECT_ARRAY, (Object)result);
        ArrayUtilsTest.assertTrue((empty != result ? 1 : 0) != 0);
    }

    public void testNullToEmptyByteObject() {
        ArrayUtilsTest.assertEquals((Object)ArrayUtils.EMPTY_BYTE_OBJECT_ARRAY, (Object)ArrayUtils.nullToEmpty((Byte[])null));
        Byte[] original = new Byte[]{(byte)15, (byte)14};
        ArrayUtilsTest.assertEquals((Object)original, (Object)ArrayUtils.nullToEmpty((Byte[])original));
        Byte[] empty = new Byte[]{};
        Byte[] result = ArrayUtils.nullToEmpty((Byte[])empty);
        ArrayUtilsTest.assertEquals((Object)ArrayUtils.EMPTY_BYTE_OBJECT_ARRAY, (Object)result);
        ArrayUtilsTest.assertTrue((empty != result ? 1 : 0) != 0);
    }

    public void testNullToEmptyDoubleObject() {
        ArrayUtilsTest.assertEquals((Object)ArrayUtils.EMPTY_DOUBLE_OBJECT_ARRAY, (Object)ArrayUtils.nullToEmpty((Double[])null));
        Double[] original = new Double[]{1.0, 2.0};
        ArrayUtilsTest.assertEquals((Object)original, (Object)ArrayUtils.nullToEmpty((Double[])original));
        Double[] empty = new Double[]{};
        Double[] result = ArrayUtils.nullToEmpty((Double[])empty);
        ArrayUtilsTest.assertEquals((Object)ArrayUtils.EMPTY_DOUBLE_OBJECT_ARRAY, (Object)result);
        ArrayUtilsTest.assertTrue((empty != result ? 1 : 0) != 0);
    }

    public void testNullToEmptyFloatObject() {
        ArrayUtilsTest.assertEquals((Object)ArrayUtils.EMPTY_FLOAT_OBJECT_ARRAY, (Object)ArrayUtils.nullToEmpty((Float[])null));
        Float[] original = new Float[]{Float.valueOf(2.6f), Float.valueOf(3.8f)};
        ArrayUtilsTest.assertEquals((Object)original, (Object)ArrayUtils.nullToEmpty((Float[])original));
        Float[] empty = new Float[]{};
        Float[] result = ArrayUtils.nullToEmpty((Float[])empty);
        ArrayUtilsTest.assertEquals((Object)ArrayUtils.EMPTY_FLOAT_OBJECT_ARRAY, (Object)result);
        ArrayUtilsTest.assertTrue((empty != result ? 1 : 0) != 0);
    }

    public void testSubarrayObject() {
        Object[] nullArray = null;
        Object[] objectArray = new Object[]{"a", "b", "c", "d", "e", "f"};
        ArrayUtilsTest.assertEquals((String)"0 start, mid end", (String)"abcd", (String)StringUtils.join((Object[])ArrayUtils.subarray((Object[])objectArray, (int)0, (int)4)));
        ArrayUtilsTest.assertEquals((String)"0 start, length end", (String)"abcdef", (String)StringUtils.join((Object[])ArrayUtils.subarray((Object[])objectArray, (int)0, (int)objectArray.length)));
        ArrayUtilsTest.assertEquals((String)"mid start, mid end", (String)"bcd", (String)StringUtils.join((Object[])ArrayUtils.subarray((Object[])objectArray, (int)1, (int)4)));
        ArrayUtilsTest.assertEquals((String)"mid start, length end", (String)"bcdef", (String)StringUtils.join((Object[])ArrayUtils.subarray((Object[])objectArray, (int)1, (int)objectArray.length)));
        ArrayUtilsTest.assertNull((String)"null input", (Object)ArrayUtils.subarray(nullArray, (int)0, (int)3));
        ArrayUtilsTest.assertEquals((String)"empty array", (String)"", (String)StringUtils.join((Object[])ArrayUtils.subarray((Object[])ArrayUtils.EMPTY_OBJECT_ARRAY, (int)1, (int)2)));
        ArrayUtilsTest.assertEquals((String)"start > end", (String)"", (String)StringUtils.join((Object[])ArrayUtils.subarray((Object[])objectArray, (int)4, (int)2)));
        ArrayUtilsTest.assertEquals((String)"start == end", (String)"", (String)StringUtils.join((Object[])ArrayUtils.subarray((Object[])objectArray, (int)3, (int)3)));
        ArrayUtilsTest.assertEquals((String)"start undershoot, normal end", (String)"abcd", (String)StringUtils.join((Object[])ArrayUtils.subarray((Object[])objectArray, (int)-2, (int)4)));
        ArrayUtilsTest.assertEquals((String)"start overshoot, any end", (String)"", (String)StringUtils.join((Object[])ArrayUtils.subarray((Object[])objectArray, (int)33, (int)4)));
        ArrayUtilsTest.assertEquals((String)"normal start, end overshoot", (String)"cdef", (String)StringUtils.join((Object[])ArrayUtils.subarray((Object[])objectArray, (int)2, (int)33)));
        ArrayUtilsTest.assertEquals((String)"start undershoot, end overshoot", (String)"abcdef", (String)StringUtils.join((Object[])ArrayUtils.subarray((Object[])objectArray, (int)-2, (int)12)));
        Object[] dateArray = new java.util.Date[]{new Date(new java.util.Date().getTime()), new java.util.Date(), new java.util.Date(), new java.util.Date(), new java.util.Date()};
        ArrayUtilsTest.assertSame((String)"Object type", Object.class, ArrayUtils.subarray((Object[])objectArray, (int)2, (int)4).getClass().getComponentType());
        ArrayUtilsTest.assertSame((String)"java.util.Date type", java.util.Date.class, ((java.util.Date[])ArrayUtils.subarray((Object[])dateArray, (int)1, (int)4)).getClass().getComponentType());
        ArrayUtilsTest.assertNotSame((String)"java.sql.Date type", Date.class, ((java.util.Date[])ArrayUtils.subarray((Object[])dateArray, (int)1, (int)4)).getClass().getComponentType());
        try {
            Date[] dummy = (Date[])ArrayUtils.subarray((Object[])dateArray, (int)1, (int)3);
            ArrayUtilsTest.fail((String)"Invalid downcast");
        }
        catch (ClassCastException e) {
            // empty catch block
        }
    }

    public void testSubarrayLong() {
        long[] nullArray = null;
        long[] array = new long[]{999910L, 999911L, 999912L, 999913L, 999914L, 999915L};
        long[] leftSubarray = new long[]{999910L, 999911L, 999912L, 999913L};
        long[] midSubarray = new long[]{999911L, 999912L, 999913L, 999914L};
        long[] rightSubarray = new long[]{999912L, 999913L, 999914L, 999915L};
        ArrayUtilsTest.assertTrue((String)"0 start, mid end", (boolean)ArrayUtils.isEquals((Object)leftSubarray, (Object)ArrayUtils.subarray((long[])array, (int)0, (int)4)));
        ArrayUtilsTest.assertTrue((String)"0 start, length end", (boolean)ArrayUtils.isEquals((Object)array, (Object)ArrayUtils.subarray((long[])array, (int)0, (int)array.length)));
        ArrayUtilsTest.assertTrue((String)"mid start, mid end", (boolean)ArrayUtils.isEquals((Object)midSubarray, (Object)ArrayUtils.subarray((long[])array, (int)1, (int)5)));
        ArrayUtilsTest.assertTrue((String)"mid start, length end", (boolean)ArrayUtils.isEquals((Object)rightSubarray, (Object)ArrayUtils.subarray((long[])array, (int)2, (int)array.length)));
        ArrayUtilsTest.assertNull((String)"null input", (Object)ArrayUtils.subarray(nullArray, (int)0, (int)3));
        ArrayUtilsTest.assertEquals((String)"empty array", (Object)ArrayUtils.EMPTY_LONG_ARRAY, (Object)ArrayUtils.subarray((long[])ArrayUtils.EMPTY_LONG_ARRAY, (int)1, (int)2));
        ArrayUtilsTest.assertEquals((String)"start > end", (Object)ArrayUtils.EMPTY_LONG_ARRAY, (Object)ArrayUtils.subarray((long[])array, (int)4, (int)2));
        ArrayUtilsTest.assertEquals((String)"start == end", (Object)ArrayUtils.EMPTY_LONG_ARRAY, (Object)ArrayUtils.subarray((long[])array, (int)3, (int)3));
        ArrayUtilsTest.assertTrue((String)"start undershoot, normal end", (boolean)ArrayUtils.isEquals((Object)leftSubarray, (Object)ArrayUtils.subarray((long[])array, (int)-2, (int)4)));
        ArrayUtilsTest.assertEquals((String)"start overshoot, any end", (Object)ArrayUtils.EMPTY_LONG_ARRAY, (Object)ArrayUtils.subarray((long[])array, (int)33, (int)4));
        ArrayUtilsTest.assertTrue((String)"normal start, end overshoot", (boolean)ArrayUtils.isEquals((Object)rightSubarray, (Object)ArrayUtils.subarray((long[])array, (int)2, (int)33)));
        ArrayUtilsTest.assertTrue((String)"start undershoot, end overshoot", (boolean)ArrayUtils.isEquals((Object)array, (Object)ArrayUtils.subarray((long[])array, (int)-2, (int)12)));
        ArrayUtilsTest.assertSame((String)"empty array, object test", (Object)ArrayUtils.EMPTY_LONG_ARRAY, (Object)ArrayUtils.subarray((long[])ArrayUtils.EMPTY_LONG_ARRAY, (int)1, (int)2));
        ArrayUtilsTest.assertSame((String)"start > end, object test", (Object)ArrayUtils.EMPTY_LONG_ARRAY, (Object)ArrayUtils.subarray((long[])array, (int)4, (int)1));
        ArrayUtilsTest.assertSame((String)"start == end, object test", (Object)ArrayUtils.EMPTY_LONG_ARRAY, (Object)ArrayUtils.subarray((long[])array, (int)3, (int)3));
        ArrayUtilsTest.assertSame((String)"start overshoot, any end, object test", (Object)ArrayUtils.EMPTY_LONG_ARRAY, (Object)ArrayUtils.subarray((long[])array, (int)8733, (int)4));
        ArrayUtilsTest.assertSame((String)"long type", Long.TYPE, ArrayUtils.subarray((long[])array, (int)2, (int)4).getClass().getComponentType());
    }

    public void testSubarrayInt() {
        int[] nullArray = null;
        int[] array = new int[]{10, 11, 12, 13, 14, 15};
        int[] leftSubarray = new int[]{10, 11, 12, 13};
        int[] midSubarray = new int[]{11, 12, 13, 14};
        int[] rightSubarray = new int[]{12, 13, 14, 15};
        ArrayUtilsTest.assertTrue((String)"0 start, mid end", (boolean)ArrayUtils.isEquals((Object)leftSubarray, (Object)ArrayUtils.subarray((int[])array, (int)0, (int)4)));
        ArrayUtilsTest.assertTrue((String)"0 start, length end", (boolean)ArrayUtils.isEquals((Object)array, (Object)ArrayUtils.subarray((int[])array, (int)0, (int)array.length)));
        ArrayUtilsTest.assertTrue((String)"mid start, mid end", (boolean)ArrayUtils.isEquals((Object)midSubarray, (Object)ArrayUtils.subarray((int[])array, (int)1, (int)5)));
        ArrayUtilsTest.assertTrue((String)"mid start, length end", (boolean)ArrayUtils.isEquals((Object)rightSubarray, (Object)ArrayUtils.subarray((int[])array, (int)2, (int)array.length)));
        ArrayUtilsTest.assertNull((String)"null input", (Object)ArrayUtils.subarray(nullArray, (int)0, (int)3));
        ArrayUtilsTest.assertEquals((String)"empty array", (Object)ArrayUtils.EMPTY_INT_ARRAY, (Object)ArrayUtils.subarray((int[])ArrayUtils.EMPTY_INT_ARRAY, (int)1, (int)2));
        ArrayUtilsTest.assertEquals((String)"start > end", (Object)ArrayUtils.EMPTY_INT_ARRAY, (Object)ArrayUtils.subarray((int[])array, (int)4, (int)2));
        ArrayUtilsTest.assertEquals((String)"start == end", (Object)ArrayUtils.EMPTY_INT_ARRAY, (Object)ArrayUtils.subarray((int[])array, (int)3, (int)3));
        ArrayUtilsTest.assertTrue((String)"start undershoot, normal end", (boolean)ArrayUtils.isEquals((Object)leftSubarray, (Object)ArrayUtils.subarray((int[])array, (int)-2, (int)4)));
        ArrayUtilsTest.assertEquals((String)"start overshoot, any end", (Object)ArrayUtils.EMPTY_INT_ARRAY, (Object)ArrayUtils.subarray((int[])array, (int)33, (int)4));
        ArrayUtilsTest.assertTrue((String)"normal start, end overshoot", (boolean)ArrayUtils.isEquals((Object)rightSubarray, (Object)ArrayUtils.subarray((int[])array, (int)2, (int)33)));
        ArrayUtilsTest.assertTrue((String)"start undershoot, end overshoot", (boolean)ArrayUtils.isEquals((Object)array, (Object)ArrayUtils.subarray((int[])array, (int)-2, (int)12)));
        ArrayUtilsTest.assertSame((String)"empty array, object test", (Object)ArrayUtils.EMPTY_INT_ARRAY, (Object)ArrayUtils.subarray((int[])ArrayUtils.EMPTY_INT_ARRAY, (int)1, (int)2));
        ArrayUtilsTest.assertSame((String)"start > end, object test", (Object)ArrayUtils.EMPTY_INT_ARRAY, (Object)ArrayUtils.subarray((int[])array, (int)4, (int)1));
        ArrayUtilsTest.assertSame((String)"start == end, object test", (Object)ArrayUtils.EMPTY_INT_ARRAY, (Object)ArrayUtils.subarray((int[])array, (int)3, (int)3));
        ArrayUtilsTest.assertSame((String)"start overshoot, any end, object test", (Object)ArrayUtils.EMPTY_INT_ARRAY, (Object)ArrayUtils.subarray((int[])array, (int)8733, (int)4));
        ArrayUtilsTest.assertSame((String)"int type", Integer.TYPE, ArrayUtils.subarray((int[])array, (int)2, (int)4).getClass().getComponentType());
    }

    public void testSubarrayShort() {
        short[] nullArray = null;
        short[] array = new short[]{10, 11, 12, 13, 14, 15};
        short[] leftSubarray = new short[]{10, 11, 12, 13};
        short[] midSubarray = new short[]{11, 12, 13, 14};
        short[] rightSubarray = new short[]{12, 13, 14, 15};
        ArrayUtilsTest.assertTrue((String)"0 start, mid end", (boolean)ArrayUtils.isEquals((Object)leftSubarray, (Object)ArrayUtils.subarray((short[])array, (int)0, (int)4)));
        ArrayUtilsTest.assertTrue((String)"0 start, length end", (boolean)ArrayUtils.isEquals((Object)array, (Object)ArrayUtils.subarray((short[])array, (int)0, (int)array.length)));
        ArrayUtilsTest.assertTrue((String)"mid start, mid end", (boolean)ArrayUtils.isEquals((Object)midSubarray, (Object)ArrayUtils.subarray((short[])array, (int)1, (int)5)));
        ArrayUtilsTest.assertTrue((String)"mid start, length end", (boolean)ArrayUtils.isEquals((Object)rightSubarray, (Object)ArrayUtils.subarray((short[])array, (int)2, (int)array.length)));
        ArrayUtilsTest.assertNull((String)"null input", (Object)ArrayUtils.subarray(nullArray, (int)0, (int)3));
        ArrayUtilsTest.assertEquals((String)"empty array", (Object)ArrayUtils.EMPTY_SHORT_ARRAY, (Object)ArrayUtils.subarray((short[])ArrayUtils.EMPTY_SHORT_ARRAY, (int)1, (int)2));
        ArrayUtilsTest.assertEquals((String)"start > end", (Object)ArrayUtils.EMPTY_SHORT_ARRAY, (Object)ArrayUtils.subarray((short[])array, (int)4, (int)2));
        ArrayUtilsTest.assertEquals((String)"start == end", (Object)ArrayUtils.EMPTY_SHORT_ARRAY, (Object)ArrayUtils.subarray((short[])array, (int)3, (int)3));
        ArrayUtilsTest.assertTrue((String)"start undershoot, normal end", (boolean)ArrayUtils.isEquals((Object)leftSubarray, (Object)ArrayUtils.subarray((short[])array, (int)-2, (int)4)));
        ArrayUtilsTest.assertEquals((String)"start overshoot, any end", (Object)ArrayUtils.EMPTY_SHORT_ARRAY, (Object)ArrayUtils.subarray((short[])array, (int)33, (int)4));
        ArrayUtilsTest.assertTrue((String)"normal start, end overshoot", (boolean)ArrayUtils.isEquals((Object)rightSubarray, (Object)ArrayUtils.subarray((short[])array, (int)2, (int)33)));
        ArrayUtilsTest.assertTrue((String)"start undershoot, end overshoot", (boolean)ArrayUtils.isEquals((Object)array, (Object)ArrayUtils.subarray((short[])array, (int)-2, (int)12)));
        ArrayUtilsTest.assertSame((String)"empty array, object test", (Object)ArrayUtils.EMPTY_SHORT_ARRAY, (Object)ArrayUtils.subarray((short[])ArrayUtils.EMPTY_SHORT_ARRAY, (int)1, (int)2));
        ArrayUtilsTest.assertSame((String)"start > end, object test", (Object)ArrayUtils.EMPTY_SHORT_ARRAY, (Object)ArrayUtils.subarray((short[])array, (int)4, (int)1));
        ArrayUtilsTest.assertSame((String)"start == end, object test", (Object)ArrayUtils.EMPTY_SHORT_ARRAY, (Object)ArrayUtils.subarray((short[])array, (int)3, (int)3));
        ArrayUtilsTest.assertSame((String)"start overshoot, any end, object test", (Object)ArrayUtils.EMPTY_SHORT_ARRAY, (Object)ArrayUtils.subarray((short[])array, (int)8733, (int)4));
        ArrayUtilsTest.assertSame((String)"short type", Short.TYPE, ArrayUtils.subarray((short[])array, (int)2, (int)4).getClass().getComponentType());
    }

    public void testSubarrChar() {
        char[] nullArray = null;
        char[] array = new char[]{'a', 'b', 'c', 'd', 'e', 'f'};
        char[] leftSubarray = new char[]{'a', 'b', 'c', 'd'};
        char[] midSubarray = new char[]{'b', 'c', 'd', 'e'};
        char[] rightSubarray = new char[]{'c', 'd', 'e', 'f'};
        ArrayUtilsTest.assertTrue((String)"0 start, mid end", (boolean)ArrayUtils.isEquals((Object)leftSubarray, (Object)ArrayUtils.subarray((char[])array, (int)0, (int)4)));
        ArrayUtilsTest.assertTrue((String)"0 start, length end", (boolean)ArrayUtils.isEquals((Object)array, (Object)ArrayUtils.subarray((char[])array, (int)0, (int)array.length)));
        ArrayUtilsTest.assertTrue((String)"mid start, mid end", (boolean)ArrayUtils.isEquals((Object)midSubarray, (Object)ArrayUtils.subarray((char[])array, (int)1, (int)5)));
        ArrayUtilsTest.assertTrue((String)"mid start, length end", (boolean)ArrayUtils.isEquals((Object)rightSubarray, (Object)ArrayUtils.subarray((char[])array, (int)2, (int)array.length)));
        ArrayUtilsTest.assertNull((String)"null input", (Object)ArrayUtils.subarray(nullArray, (int)0, (int)3));
        ArrayUtilsTest.assertEquals((String)"empty array", (Object)ArrayUtils.EMPTY_CHAR_ARRAY, (Object)ArrayUtils.subarray((char[])ArrayUtils.EMPTY_CHAR_ARRAY, (int)1, (int)2));
        ArrayUtilsTest.assertEquals((String)"start > end", (Object)ArrayUtils.EMPTY_CHAR_ARRAY, (Object)ArrayUtils.subarray((char[])array, (int)4, (int)2));
        ArrayUtilsTest.assertEquals((String)"start == end", (Object)ArrayUtils.EMPTY_CHAR_ARRAY, (Object)ArrayUtils.subarray((char[])array, (int)3, (int)3));
        ArrayUtilsTest.assertTrue((String)"start undershoot, normal end", (boolean)ArrayUtils.isEquals((Object)leftSubarray, (Object)ArrayUtils.subarray((char[])array, (int)-2, (int)4)));
        ArrayUtilsTest.assertEquals((String)"start overshoot, any end", (Object)ArrayUtils.EMPTY_CHAR_ARRAY, (Object)ArrayUtils.subarray((char[])array, (int)33, (int)4));
        ArrayUtilsTest.assertTrue((String)"normal start, end overshoot", (boolean)ArrayUtils.isEquals((Object)rightSubarray, (Object)ArrayUtils.subarray((char[])array, (int)2, (int)33)));
        ArrayUtilsTest.assertTrue((String)"start undershoot, end overshoot", (boolean)ArrayUtils.isEquals((Object)array, (Object)ArrayUtils.subarray((char[])array, (int)-2, (int)12)));
        ArrayUtilsTest.assertSame((String)"empty array, object test", (Object)ArrayUtils.EMPTY_CHAR_ARRAY, (Object)ArrayUtils.subarray((char[])ArrayUtils.EMPTY_CHAR_ARRAY, (int)1, (int)2));
        ArrayUtilsTest.assertSame((String)"start > end, object test", (Object)ArrayUtils.EMPTY_CHAR_ARRAY, (Object)ArrayUtils.subarray((char[])array, (int)4, (int)1));
        ArrayUtilsTest.assertSame((String)"start == end, object test", (Object)ArrayUtils.EMPTY_CHAR_ARRAY, (Object)ArrayUtils.subarray((char[])array, (int)3, (int)3));
        ArrayUtilsTest.assertSame((String)"start overshoot, any end, object test", (Object)ArrayUtils.EMPTY_CHAR_ARRAY, (Object)ArrayUtils.subarray((char[])array, (int)8733, (int)4));
        ArrayUtilsTest.assertSame((String)"char type", Character.TYPE, ArrayUtils.subarray((char[])array, (int)2, (int)4).getClass().getComponentType());
    }

    public void testSubarrayByte() {
        byte[] nullArray = null;
        byte[] array = new byte[]{10, 11, 12, 13, 14, 15};
        byte[] leftSubarray = new byte[]{10, 11, 12, 13};
        byte[] midSubarray = new byte[]{11, 12, 13, 14};
        byte[] rightSubarray = new byte[]{12, 13, 14, 15};
        ArrayUtilsTest.assertTrue((String)"0 start, mid end", (boolean)ArrayUtils.isEquals((Object)leftSubarray, (Object)ArrayUtils.subarray((byte[])array, (int)0, (int)4)));
        ArrayUtilsTest.assertTrue((String)"0 start, length end", (boolean)ArrayUtils.isEquals((Object)array, (Object)ArrayUtils.subarray((byte[])array, (int)0, (int)array.length)));
        ArrayUtilsTest.assertTrue((String)"mid start, mid end", (boolean)ArrayUtils.isEquals((Object)midSubarray, (Object)ArrayUtils.subarray((byte[])array, (int)1, (int)5)));
        ArrayUtilsTest.assertTrue((String)"mid start, length end", (boolean)ArrayUtils.isEquals((Object)rightSubarray, (Object)ArrayUtils.subarray((byte[])array, (int)2, (int)array.length)));
        ArrayUtilsTest.assertNull((String)"null input", (Object)ArrayUtils.subarray(nullArray, (int)0, (int)3));
        ArrayUtilsTest.assertEquals((String)"empty array", (Object)ArrayUtils.EMPTY_BYTE_ARRAY, (Object)ArrayUtils.subarray((byte[])ArrayUtils.EMPTY_BYTE_ARRAY, (int)1, (int)2));
        ArrayUtilsTest.assertEquals((String)"start > end", (Object)ArrayUtils.EMPTY_BYTE_ARRAY, (Object)ArrayUtils.subarray((byte[])array, (int)4, (int)2));
        ArrayUtilsTest.assertEquals((String)"start == end", (Object)ArrayUtils.EMPTY_BYTE_ARRAY, (Object)ArrayUtils.subarray((byte[])array, (int)3, (int)3));
        ArrayUtilsTest.assertTrue((String)"start undershoot, normal end", (boolean)ArrayUtils.isEquals((Object)leftSubarray, (Object)ArrayUtils.subarray((byte[])array, (int)-2, (int)4)));
        ArrayUtilsTest.assertEquals((String)"start overshoot, any end", (Object)ArrayUtils.EMPTY_BYTE_ARRAY, (Object)ArrayUtils.subarray((byte[])array, (int)33, (int)4));
        ArrayUtilsTest.assertTrue((String)"normal start, end overshoot", (boolean)ArrayUtils.isEquals((Object)rightSubarray, (Object)ArrayUtils.subarray((byte[])array, (int)2, (int)33)));
        ArrayUtilsTest.assertTrue((String)"start undershoot, end overshoot", (boolean)ArrayUtils.isEquals((Object)array, (Object)ArrayUtils.subarray((byte[])array, (int)-2, (int)12)));
        ArrayUtilsTest.assertSame((String)"empty array, object test", (Object)ArrayUtils.EMPTY_BYTE_ARRAY, (Object)ArrayUtils.subarray((byte[])ArrayUtils.EMPTY_BYTE_ARRAY, (int)1, (int)2));
        ArrayUtilsTest.assertSame((String)"start > end, object test", (Object)ArrayUtils.EMPTY_BYTE_ARRAY, (Object)ArrayUtils.subarray((byte[])array, (int)4, (int)1));
        ArrayUtilsTest.assertSame((String)"start == end, object test", (Object)ArrayUtils.EMPTY_BYTE_ARRAY, (Object)ArrayUtils.subarray((byte[])array, (int)3, (int)3));
        ArrayUtilsTest.assertSame((String)"start overshoot, any end, object test", (Object)ArrayUtils.EMPTY_BYTE_ARRAY, (Object)ArrayUtils.subarray((byte[])array, (int)8733, (int)4));
        ArrayUtilsTest.assertSame((String)"byte type", Byte.TYPE, ArrayUtils.subarray((byte[])array, (int)2, (int)4).getClass().getComponentType());
    }

    public void testSubarrayDouble() {
        double[] nullArray = null;
        double[] array = new double[]{10.123, 11.234, 12.345, 13.456, 14.567, 15.678};
        double[] leftSubarray = new double[]{10.123, 11.234, 12.345, 13.456};
        double[] midSubarray = new double[]{11.234, 12.345, 13.456, 14.567};
        double[] rightSubarray = new double[]{12.345, 13.456, 14.567, 15.678};
        ArrayUtilsTest.assertTrue((String)"0 start, mid end", (boolean)ArrayUtils.isEquals((Object)leftSubarray, (Object)ArrayUtils.subarray((double[])array, (int)0, (int)4)));
        ArrayUtilsTest.assertTrue((String)"0 start, length end", (boolean)ArrayUtils.isEquals((Object)array, (Object)ArrayUtils.subarray((double[])array, (int)0, (int)array.length)));
        ArrayUtilsTest.assertTrue((String)"mid start, mid end", (boolean)ArrayUtils.isEquals((Object)midSubarray, (Object)ArrayUtils.subarray((double[])array, (int)1, (int)5)));
        ArrayUtilsTest.assertTrue((String)"mid start, length end", (boolean)ArrayUtils.isEquals((Object)rightSubarray, (Object)ArrayUtils.subarray((double[])array, (int)2, (int)array.length)));
        ArrayUtilsTest.assertNull((String)"null input", (Object)ArrayUtils.subarray(nullArray, (int)0, (int)3));
        ArrayUtilsTest.assertEquals((String)"empty array", (Object)ArrayUtils.EMPTY_DOUBLE_ARRAY, (Object)ArrayUtils.subarray((double[])ArrayUtils.EMPTY_DOUBLE_ARRAY, (int)1, (int)2));
        ArrayUtilsTest.assertEquals((String)"start > end", (Object)ArrayUtils.EMPTY_DOUBLE_ARRAY, (Object)ArrayUtils.subarray((double[])array, (int)4, (int)2));
        ArrayUtilsTest.assertEquals((String)"start == end", (Object)ArrayUtils.EMPTY_DOUBLE_ARRAY, (Object)ArrayUtils.subarray((double[])array, (int)3, (int)3));
        ArrayUtilsTest.assertTrue((String)"start undershoot, normal end", (boolean)ArrayUtils.isEquals((Object)leftSubarray, (Object)ArrayUtils.subarray((double[])array, (int)-2, (int)4)));
        ArrayUtilsTest.assertEquals((String)"start overshoot, any end", (Object)ArrayUtils.EMPTY_DOUBLE_ARRAY, (Object)ArrayUtils.subarray((double[])array, (int)33, (int)4));
        ArrayUtilsTest.assertTrue((String)"normal start, end overshoot", (boolean)ArrayUtils.isEquals((Object)rightSubarray, (Object)ArrayUtils.subarray((double[])array, (int)2, (int)33)));
        ArrayUtilsTest.assertTrue((String)"start undershoot, end overshoot", (boolean)ArrayUtils.isEquals((Object)array, (Object)ArrayUtils.subarray((double[])array, (int)-2, (int)12)));
        ArrayUtilsTest.assertSame((String)"empty array, object test", (Object)ArrayUtils.EMPTY_DOUBLE_ARRAY, (Object)ArrayUtils.subarray((double[])ArrayUtils.EMPTY_DOUBLE_ARRAY, (int)1, (int)2));
        ArrayUtilsTest.assertSame((String)"start > end, object test", (Object)ArrayUtils.EMPTY_DOUBLE_ARRAY, (Object)ArrayUtils.subarray((double[])array, (int)4, (int)1));
        ArrayUtilsTest.assertSame((String)"start == end, object test", (Object)ArrayUtils.EMPTY_DOUBLE_ARRAY, (Object)ArrayUtils.subarray((double[])array, (int)3, (int)3));
        ArrayUtilsTest.assertSame((String)"start overshoot, any end, object test", (Object)ArrayUtils.EMPTY_DOUBLE_ARRAY, (Object)ArrayUtils.subarray((double[])array, (int)8733, (int)4));
        ArrayUtilsTest.assertSame((String)"double type", Double.TYPE, ArrayUtils.subarray((double[])array, (int)2, (int)4).getClass().getComponentType());
    }

    public void testSubarrayFloat() {
        float[] nullArray = null;
        float[] array = new float[]{10.0f, 11.0f, 12.0f, 13.0f, 14.0f, 15.0f};
        float[] leftSubarray = new float[]{10.0f, 11.0f, 12.0f, 13.0f};
        float[] midSubarray = new float[]{11.0f, 12.0f, 13.0f, 14.0f};
        float[] rightSubarray = new float[]{12.0f, 13.0f, 14.0f, 15.0f};
        ArrayUtilsTest.assertTrue((String)"0 start, mid end", (boolean)ArrayUtils.isEquals((Object)leftSubarray, (Object)ArrayUtils.subarray((float[])array, (int)0, (int)4)));
        ArrayUtilsTest.assertTrue((String)"0 start, length end", (boolean)ArrayUtils.isEquals((Object)array, (Object)ArrayUtils.subarray((float[])array, (int)0, (int)array.length)));
        ArrayUtilsTest.assertTrue((String)"mid start, mid end", (boolean)ArrayUtils.isEquals((Object)midSubarray, (Object)ArrayUtils.subarray((float[])array, (int)1, (int)5)));
        ArrayUtilsTest.assertTrue((String)"mid start, length end", (boolean)ArrayUtils.isEquals((Object)rightSubarray, (Object)ArrayUtils.subarray((float[])array, (int)2, (int)array.length)));
        ArrayUtilsTest.assertNull((String)"null input", (Object)ArrayUtils.subarray(nullArray, (int)0, (int)3));
        ArrayUtilsTest.assertEquals((String)"empty array", (Object)ArrayUtils.EMPTY_FLOAT_ARRAY, (Object)ArrayUtils.subarray((float[])ArrayUtils.EMPTY_FLOAT_ARRAY, (int)1, (int)2));
        ArrayUtilsTest.assertEquals((String)"start > end", (Object)ArrayUtils.EMPTY_FLOAT_ARRAY, (Object)ArrayUtils.subarray((float[])array, (int)4, (int)2));
        ArrayUtilsTest.assertEquals((String)"start == end", (Object)ArrayUtils.EMPTY_FLOAT_ARRAY, (Object)ArrayUtils.subarray((float[])array, (int)3, (int)3));
        ArrayUtilsTest.assertTrue((String)"start undershoot, normal end", (boolean)ArrayUtils.isEquals((Object)leftSubarray, (Object)ArrayUtils.subarray((float[])array, (int)-2, (int)4)));
        ArrayUtilsTest.assertEquals((String)"start overshoot, any end", (Object)ArrayUtils.EMPTY_FLOAT_ARRAY, (Object)ArrayUtils.subarray((float[])array, (int)33, (int)4));
        ArrayUtilsTest.assertTrue((String)"normal start, end overshoot", (boolean)ArrayUtils.isEquals((Object)rightSubarray, (Object)ArrayUtils.subarray((float[])array, (int)2, (int)33)));
        ArrayUtilsTest.assertTrue((String)"start undershoot, end overshoot", (boolean)ArrayUtils.isEquals((Object)array, (Object)ArrayUtils.subarray((float[])array, (int)-2, (int)12)));
        ArrayUtilsTest.assertSame((String)"empty array, object test", (Object)ArrayUtils.EMPTY_FLOAT_ARRAY, (Object)ArrayUtils.subarray((float[])ArrayUtils.EMPTY_FLOAT_ARRAY, (int)1, (int)2));
        ArrayUtilsTest.assertSame((String)"start > end, object test", (Object)ArrayUtils.EMPTY_FLOAT_ARRAY, (Object)ArrayUtils.subarray((float[])array, (int)4, (int)1));
        ArrayUtilsTest.assertSame((String)"start == end, object test", (Object)ArrayUtils.EMPTY_FLOAT_ARRAY, (Object)ArrayUtils.subarray((float[])array, (int)3, (int)3));
        ArrayUtilsTest.assertSame((String)"start overshoot, any end, object test", (Object)ArrayUtils.EMPTY_FLOAT_ARRAY, (Object)ArrayUtils.subarray((float[])array, (int)8733, (int)4));
        ArrayUtilsTest.assertSame((String)"float type", Float.TYPE, ArrayUtils.subarray((float[])array, (int)2, (int)4).getClass().getComponentType());
    }

    public void testSubarrayBoolean() {
        boolean[] nullArray = null;
        boolean[] array = new boolean[]{true, true, false, true, false, true};
        boolean[] leftSubarray = new boolean[]{true, true, false, true};
        boolean[] midSubarray = new boolean[]{true, false, true, false};
        boolean[] rightSubarray = new boolean[]{false, true, false, true};
        ArrayUtilsTest.assertTrue((String)"0 start, mid end", (boolean)ArrayUtils.isEquals((Object)leftSubarray, (Object)ArrayUtils.subarray((boolean[])array, (int)0, (int)4)));
        ArrayUtilsTest.assertTrue((String)"0 start, length end", (boolean)ArrayUtils.isEquals((Object)array, (Object)ArrayUtils.subarray((boolean[])array, (int)0, (int)array.length)));
        ArrayUtilsTest.assertTrue((String)"mid start, mid end", (boolean)ArrayUtils.isEquals((Object)midSubarray, (Object)ArrayUtils.subarray((boolean[])array, (int)1, (int)5)));
        ArrayUtilsTest.assertTrue((String)"mid start, length end", (boolean)ArrayUtils.isEquals((Object)rightSubarray, (Object)ArrayUtils.subarray((boolean[])array, (int)2, (int)array.length)));
        ArrayUtilsTest.assertNull((String)"null input", (Object)ArrayUtils.subarray(nullArray, (int)0, (int)3));
        ArrayUtilsTest.assertEquals((String)"empty array", (Object)ArrayUtils.EMPTY_BOOLEAN_ARRAY, (Object)ArrayUtils.subarray((boolean[])ArrayUtils.EMPTY_BOOLEAN_ARRAY, (int)1, (int)2));
        ArrayUtilsTest.assertEquals((String)"start > end", (Object)ArrayUtils.EMPTY_BOOLEAN_ARRAY, (Object)ArrayUtils.subarray((boolean[])array, (int)4, (int)2));
        ArrayUtilsTest.assertEquals((String)"start == end", (Object)ArrayUtils.EMPTY_BOOLEAN_ARRAY, (Object)ArrayUtils.subarray((boolean[])array, (int)3, (int)3));
        ArrayUtilsTest.assertTrue((String)"start undershoot, normal end", (boolean)ArrayUtils.isEquals((Object)leftSubarray, (Object)ArrayUtils.subarray((boolean[])array, (int)-2, (int)4)));
        ArrayUtilsTest.assertEquals((String)"start overshoot, any end", (Object)ArrayUtils.EMPTY_BOOLEAN_ARRAY, (Object)ArrayUtils.subarray((boolean[])array, (int)33, (int)4));
        ArrayUtilsTest.assertTrue((String)"normal start, end overshoot", (boolean)ArrayUtils.isEquals((Object)rightSubarray, (Object)ArrayUtils.subarray((boolean[])array, (int)2, (int)33)));
        ArrayUtilsTest.assertTrue((String)"start undershoot, end overshoot", (boolean)ArrayUtils.isEquals((Object)array, (Object)ArrayUtils.subarray((boolean[])array, (int)-2, (int)12)));
        ArrayUtilsTest.assertSame((String)"empty array, object test", (Object)ArrayUtils.EMPTY_BOOLEAN_ARRAY, (Object)ArrayUtils.subarray((boolean[])ArrayUtils.EMPTY_BOOLEAN_ARRAY, (int)1, (int)2));
        ArrayUtilsTest.assertSame((String)"start > end, object test", (Object)ArrayUtils.EMPTY_BOOLEAN_ARRAY, (Object)ArrayUtils.subarray((boolean[])array, (int)4, (int)1));
        ArrayUtilsTest.assertSame((String)"start == end, object test", (Object)ArrayUtils.EMPTY_BOOLEAN_ARRAY, (Object)ArrayUtils.subarray((boolean[])array, (int)3, (int)3));
        ArrayUtilsTest.assertSame((String)"start overshoot, any end, object test", (Object)ArrayUtils.EMPTY_BOOLEAN_ARRAY, (Object)ArrayUtils.subarray((boolean[])array, (int)8733, (int)4));
        ArrayUtilsTest.assertSame((String)"boolean type", Boolean.TYPE, ArrayUtils.subarray((boolean[])array, (int)2, (int)4).getClass().getComponentType());
    }

    public void testSameLength() {
        Object[] nullArray = null;
        Object[] emptyArray = new Object[]{};
        Object[] oneArray = new Object[]{"pick"};
        Object[] twoArray = new Object[]{"pick", "stick"};
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isSameLength(nullArray, nullArray));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isSameLength(nullArray, (Object[])emptyArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength(nullArray, (Object[])oneArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength(nullArray, (Object[])twoArray));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isSameLength((Object[])emptyArray, nullArray));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isSameLength((Object[])emptyArray, (Object[])emptyArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength((Object[])emptyArray, (Object[])oneArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength((Object[])emptyArray, (Object[])twoArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength((Object[])oneArray, nullArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength((Object[])oneArray, (Object[])emptyArray));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isSameLength((Object[])oneArray, (Object[])oneArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength((Object[])oneArray, (Object[])twoArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength((Object[])twoArray, nullArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength((Object[])twoArray, (Object[])emptyArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength((Object[])twoArray, (Object[])oneArray));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isSameLength((Object[])twoArray, (Object[])twoArray));
    }

    public void testSameLengthBoolean() {
        boolean[] nullArray = null;
        boolean[] emptyArray = new boolean[]{};
        boolean[] oneArray = new boolean[]{true};
        boolean[] twoArray = new boolean[]{true, false};
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isSameLength(nullArray, nullArray));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isSameLength(nullArray, (boolean[])emptyArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength(nullArray, (boolean[])oneArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength(nullArray, (boolean[])twoArray));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isSameLength((boolean[])emptyArray, nullArray));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isSameLength((boolean[])emptyArray, (boolean[])emptyArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength((boolean[])emptyArray, (boolean[])oneArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength((boolean[])emptyArray, (boolean[])twoArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength((boolean[])oneArray, nullArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength((boolean[])oneArray, (boolean[])emptyArray));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isSameLength((boolean[])oneArray, (boolean[])oneArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength((boolean[])oneArray, (boolean[])twoArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength((boolean[])twoArray, nullArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength((boolean[])twoArray, (boolean[])emptyArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength((boolean[])twoArray, (boolean[])oneArray));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isSameLength((boolean[])twoArray, (boolean[])twoArray));
    }

    public void testSameLengthLong() {
        long[] nullArray = null;
        long[] emptyArray = new long[]{};
        long[] oneArray = new long[]{0L};
        long[] twoArray = new long[]{0L, 76L};
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isSameLength(nullArray, nullArray));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isSameLength(nullArray, (long[])emptyArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength(nullArray, (long[])oneArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength(nullArray, (long[])twoArray));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isSameLength((long[])emptyArray, nullArray));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isSameLength((long[])emptyArray, (long[])emptyArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength((long[])emptyArray, (long[])oneArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength((long[])emptyArray, (long[])twoArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength((long[])oneArray, nullArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength((long[])oneArray, (long[])emptyArray));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isSameLength((long[])oneArray, (long[])oneArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength((long[])oneArray, (long[])twoArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength((long[])twoArray, nullArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength((long[])twoArray, (long[])emptyArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength((long[])twoArray, (long[])oneArray));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isSameLength((long[])twoArray, (long[])twoArray));
    }

    public void testSameLengthInt() {
        int[] nullArray = null;
        int[] emptyArray = new int[]{};
        int[] oneArray = new int[]{4};
        int[] twoArray = new int[]{5, 7};
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isSameLength(nullArray, nullArray));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isSameLength(nullArray, (int[])emptyArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength(nullArray, (int[])oneArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength(nullArray, (int[])twoArray));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isSameLength((int[])emptyArray, nullArray));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isSameLength((int[])emptyArray, (int[])emptyArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength((int[])emptyArray, (int[])oneArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength((int[])emptyArray, (int[])twoArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength((int[])oneArray, nullArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength((int[])oneArray, (int[])emptyArray));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isSameLength((int[])oneArray, (int[])oneArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength((int[])oneArray, (int[])twoArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength((int[])twoArray, nullArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength((int[])twoArray, (int[])emptyArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength((int[])twoArray, (int[])oneArray));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isSameLength((int[])twoArray, (int[])twoArray));
    }

    public void testSameLengthShort() {
        short[] nullArray = null;
        short[] emptyArray = new short[]{};
        short[] oneArray = new short[]{4};
        short[] twoArray = new short[]{6, 8};
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isSameLength(nullArray, nullArray));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isSameLength(nullArray, (short[])emptyArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength(nullArray, (short[])oneArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength(nullArray, (short[])twoArray));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isSameLength((short[])emptyArray, nullArray));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isSameLength((short[])emptyArray, (short[])emptyArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength((short[])emptyArray, (short[])oneArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength((short[])emptyArray, (short[])twoArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength((short[])oneArray, nullArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength((short[])oneArray, (short[])emptyArray));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isSameLength((short[])oneArray, (short[])oneArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength((short[])oneArray, (short[])twoArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength((short[])twoArray, nullArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength((short[])twoArray, (short[])emptyArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength((short[])twoArray, (short[])oneArray));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isSameLength((short[])twoArray, (short[])twoArray));
    }

    public void testSameLengthChar() {
        char[] nullArray = null;
        char[] emptyArray = new char[]{};
        char[] oneArray = new char[]{'f'};
        char[] twoArray = new char[]{'d', 't'};
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isSameLength(nullArray, nullArray));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isSameLength(nullArray, (char[])emptyArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength(nullArray, (char[])oneArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength(nullArray, (char[])twoArray));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isSameLength((char[])emptyArray, nullArray));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isSameLength((char[])emptyArray, (char[])emptyArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength((char[])emptyArray, (char[])oneArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength((char[])emptyArray, (char[])twoArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength((char[])oneArray, nullArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength((char[])oneArray, (char[])emptyArray));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isSameLength((char[])oneArray, (char[])oneArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength((char[])oneArray, (char[])twoArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength((char[])twoArray, nullArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength((char[])twoArray, (char[])emptyArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength((char[])twoArray, (char[])oneArray));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isSameLength((char[])twoArray, (char[])twoArray));
    }

    public void testSameLengthByte() {
        byte[] nullArray = null;
        byte[] emptyArray = new byte[]{};
        byte[] oneArray = new byte[]{3};
        byte[] twoArray = new byte[]{4, 6};
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isSameLength(nullArray, nullArray));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isSameLength(nullArray, (byte[])emptyArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength(nullArray, (byte[])oneArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength(nullArray, (byte[])twoArray));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isSameLength((byte[])emptyArray, nullArray));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isSameLength((byte[])emptyArray, (byte[])emptyArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength((byte[])emptyArray, (byte[])oneArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength((byte[])emptyArray, (byte[])twoArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength((byte[])oneArray, nullArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength((byte[])oneArray, (byte[])emptyArray));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isSameLength((byte[])oneArray, (byte[])oneArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength((byte[])oneArray, (byte[])twoArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength((byte[])twoArray, nullArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength((byte[])twoArray, (byte[])emptyArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength((byte[])twoArray, (byte[])oneArray));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isSameLength((byte[])twoArray, (byte[])twoArray));
    }

    public void testSameLengthDouble() {
        double[] nullArray = null;
        double[] emptyArray = new double[]{};
        double[] oneArray = new double[]{1.3};
        double[] twoArray = new double[]{4.5, 6.3};
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isSameLength(nullArray, nullArray));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isSameLength(nullArray, (double[])emptyArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength(nullArray, (double[])oneArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength(nullArray, (double[])twoArray));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isSameLength((double[])emptyArray, nullArray));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isSameLength((double[])emptyArray, (double[])emptyArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength((double[])emptyArray, (double[])oneArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength((double[])emptyArray, (double[])twoArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength((double[])oneArray, nullArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength((double[])oneArray, (double[])emptyArray));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isSameLength((double[])oneArray, (double[])oneArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength((double[])oneArray, (double[])twoArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength((double[])twoArray, nullArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength((double[])twoArray, (double[])emptyArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength((double[])twoArray, (double[])oneArray));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isSameLength((double[])twoArray, (double[])twoArray));
    }

    public void testSameLengthFloat() {
        float[] nullArray = null;
        float[] emptyArray = new float[]{};
        float[] oneArray = new float[]{2.5f};
        float[] twoArray = new float[]{6.4f, 5.8f};
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isSameLength(nullArray, nullArray));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isSameLength(nullArray, (float[])emptyArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength(nullArray, (float[])oneArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength(nullArray, (float[])twoArray));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isSameLength((float[])emptyArray, nullArray));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isSameLength((float[])emptyArray, (float[])emptyArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength((float[])emptyArray, (float[])oneArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength((float[])emptyArray, (float[])twoArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength((float[])oneArray, nullArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength((float[])oneArray, (float[])emptyArray));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isSameLength((float[])oneArray, (float[])oneArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength((float[])oneArray, (float[])twoArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength((float[])twoArray, nullArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength((float[])twoArray, (float[])emptyArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameLength((float[])twoArray, (float[])oneArray));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isSameLength((float[])twoArray, (float[])twoArray));
    }

    public void testSameType() {
        try {
            ArrayUtils.isSameType(null, null);
            ArrayUtilsTest.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            ArrayUtils.isSameType(null, (Object)new Object[0]);
            ArrayUtilsTest.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            ArrayUtils.isSameType((Object)new Object[0], null);
            ArrayUtilsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isSameType((Object)new Object[0], (Object)new Object[0]));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameType((Object)new String[0], (Object)new Object[0]));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isSameType((Object)new String[0][0], (Object)new String[0][0]));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameType((Object)new String[0], (Object)new String[0][0]));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isSameType((Object)new String[0][0], (Object)new String[0]));
    }

    public void testReverse() {
        StringBuffer str1 = new StringBuffer("pick");
        String str2 = "a";
        String[] str3 = new String[]{"stick"};
        String str4 = "up";
        Object[] array = new Object[]{str1, str2, str3};
        ArrayUtils.reverse((Object[])array);
        ArrayUtilsTest.assertEquals((Object)array[0], (Object)str3);
        ArrayUtilsTest.assertEquals((Object)array[1], (Object)str2);
        ArrayUtilsTest.assertEquals((Object)array[2], (Object)str1);
        array = new Object[]{str1, str2, str3, str4};
        ArrayUtils.reverse((Object[])array);
        ArrayUtilsTest.assertEquals((Object)array[0], (Object)str4);
        ArrayUtilsTest.assertEquals((Object)array[1], (Object)str3);
        ArrayUtilsTest.assertEquals((Object)array[2], (Object)str2);
        ArrayUtilsTest.assertEquals((Object)array[3], (Object)str1);
        array = null;
        ArrayUtils.reverse((Object[])array);
        ArrayUtilsTest.assertEquals(null, (Object)array);
    }

    public void testReverseLong() {
        long[] array = new long[]{1L, 2L, 3L};
        ArrayUtils.reverse((long[])array);
        ArrayUtilsTest.assertEquals((long)array[0], (long)3L);
        ArrayUtilsTest.assertEquals((long)array[1], (long)2L);
        ArrayUtilsTest.assertEquals((long)array[2], (long)1L);
        array = null;
        ArrayUtils.reverse((long[])array);
        ArrayUtilsTest.assertEquals(null, (Object)array);
    }

    public void testReverseInt() {
        int[] array = new int[]{1, 2, 3};
        ArrayUtils.reverse((int[])array);
        ArrayUtilsTest.assertEquals((int)array[0], (int)3);
        ArrayUtilsTest.assertEquals((int)array[1], (int)2);
        ArrayUtilsTest.assertEquals((int)array[2], (int)1);
        array = null;
        ArrayUtils.reverse((int[])array);
        ArrayUtilsTest.assertEquals(null, (Object)array);
    }

    public void testReverseShort() {
        short[] array = new short[]{1, 2, 3};
        ArrayUtils.reverse((short[])array);
        ArrayUtilsTest.assertEquals((int)array[0], (int)3);
        ArrayUtilsTest.assertEquals((int)array[1], (int)2);
        ArrayUtilsTest.assertEquals((int)array[2], (int)1);
        array = null;
        ArrayUtils.reverse((short[])array);
        ArrayUtilsTest.assertEquals(null, (Object)array);
    }

    public void testReverseChar() {
        char[] array = new char[]{'a', 'f', 'C'};
        ArrayUtils.reverse((char[])array);
        ArrayUtilsTest.assertEquals((char)array[0], (char)'C');
        ArrayUtilsTest.assertEquals((char)array[1], (char)'f');
        ArrayUtilsTest.assertEquals((char)array[2], (char)'a');
        array = null;
        ArrayUtils.reverse((char[])array);
        ArrayUtilsTest.assertEquals(null, (Object)array);
    }

    public void testReverseByte() {
        byte[] array = new byte[]{2, 3, 4};
        ArrayUtils.reverse((byte[])array);
        ArrayUtilsTest.assertEquals((int)array[0], (int)4);
        ArrayUtilsTest.assertEquals((int)array[1], (int)3);
        ArrayUtilsTest.assertEquals((int)array[2], (int)2);
        array = null;
        ArrayUtils.reverse((byte[])array);
        ArrayUtilsTest.assertEquals(null, (Object)array);
    }

    public void testReverseDouble() {
        double[] array = new double[]{0.3, 0.4, 0.5};
        ArrayUtils.reverse((double[])array);
        ArrayUtilsTest.assertEquals((double)array[0], (double)0.5, (double)0.0);
        ArrayUtilsTest.assertEquals((double)array[1], (double)0.4, (double)0.0);
        ArrayUtilsTest.assertEquals((double)array[2], (double)0.3, (double)0.0);
        array = null;
        ArrayUtils.reverse((double[])array);
        ArrayUtilsTest.assertEquals(null, (Object)array);
    }

    public void testReverseFloat() {
        float[] array = new float[]{0.3f, 0.4f, 0.5f};
        ArrayUtils.reverse((float[])array);
        ArrayUtilsTest.assertEquals((float)array[0], (float)0.5f, (float)0.0f);
        ArrayUtilsTest.assertEquals((float)array[1], (float)0.4f, (float)0.0f);
        ArrayUtilsTest.assertEquals((float)array[2], (float)0.3f, (float)0.0f);
        array = null;
        ArrayUtils.reverse((float[])array);
        ArrayUtilsTest.assertEquals(null, (Object)array);
    }

    public void testReverseBoolean() {
        boolean[] array = new boolean[]{false, false, true};
        ArrayUtils.reverse((boolean[])array);
        ArrayUtilsTest.assertEquals((boolean)array[0], (boolean)true);
        ArrayUtilsTest.assertEquals((boolean)array[1], (boolean)false);
        ArrayUtilsTest.assertEquals((boolean)array[2], (boolean)false);
        array = null;
        ArrayUtils.reverse((boolean[])array);
        ArrayUtilsTest.assertEquals(null, (Object)array);
    }

    public void testIndexOf() {
        Object[] array = new Object[]{"0", "1", "2", "3", null, "0"};
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.indexOf(null, null));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.indexOf(null, (Object)"0"));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.indexOf((Object[])new Object[0], (Object)"0"));
        ArrayUtilsTest.assertEquals((int)0, (int)ArrayUtils.indexOf((Object[])array, (Object)"0"));
        ArrayUtilsTest.assertEquals((int)1, (int)ArrayUtils.indexOf((Object[])array, (Object)"1"));
        ArrayUtilsTest.assertEquals((int)2, (int)ArrayUtils.indexOf((Object[])array, (Object)"2"));
        ArrayUtilsTest.assertEquals((int)3, (int)ArrayUtils.indexOf((Object[])array, (Object)"3"));
        ArrayUtilsTest.assertEquals((int)4, (int)ArrayUtils.indexOf((Object[])array, null));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.indexOf((Object[])array, (Object)"notInArray"));
    }

    public void testIndexOfWithStartIndex() {
        Object[] array = new Object[]{"0", "1", "2", "3", null, "0"};
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.indexOf(null, null, (int)2));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.indexOf((Object[])new Object[0], (Object)"0", (int)0));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.indexOf(null, (Object)"0", (int)2));
        ArrayUtilsTest.assertEquals((int)5, (int)ArrayUtils.indexOf((Object[])array, (Object)"0", (int)2));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.indexOf((Object[])array, (Object)"1", (int)2));
        ArrayUtilsTest.assertEquals((int)2, (int)ArrayUtils.indexOf((Object[])array, (Object)"2", (int)2));
        ArrayUtilsTest.assertEquals((int)3, (int)ArrayUtils.indexOf((Object[])array, (Object)"3", (int)2));
        ArrayUtilsTest.assertEquals((int)4, (int)ArrayUtils.indexOf((Object[])array, null, (int)2));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.indexOf((Object[])array, (Object)"notInArray", (int)2));
        ArrayUtilsTest.assertEquals((int)4, (int)ArrayUtils.indexOf((Object[])array, null, (int)-1));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.indexOf((Object[])array, null, (int)8));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.indexOf((Object[])array, (Object)"0", (int)8));
    }

    public void testLastIndexOf() {
        Object[] array = new Object[]{"0", "1", "2", "3", null, "0"};
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf(null, null));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf(null, (Object)"0"));
        ArrayUtilsTest.assertEquals((int)5, (int)ArrayUtils.lastIndexOf((Object[])array, (Object)"0"));
        ArrayUtilsTest.assertEquals((int)1, (int)ArrayUtils.lastIndexOf((Object[])array, (Object)"1"));
        ArrayUtilsTest.assertEquals((int)2, (int)ArrayUtils.lastIndexOf((Object[])array, (Object)"2"));
        ArrayUtilsTest.assertEquals((int)3, (int)ArrayUtils.lastIndexOf((Object[])array, (Object)"3"));
        ArrayUtilsTest.assertEquals((int)4, (int)ArrayUtils.lastIndexOf((Object[])array, null));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((Object[])array, (Object)"notInArray"));
    }

    public void testLastIndexOfWithStartIndex() {
        Object[] array = new Object[]{"0", "1", "2", "3", null, "0"};
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf(null, null, (int)2));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf(null, (Object)"0", (int)2));
        ArrayUtilsTest.assertEquals((int)0, (int)ArrayUtils.lastIndexOf((Object[])array, (Object)"0", (int)2));
        ArrayUtilsTest.assertEquals((int)1, (int)ArrayUtils.lastIndexOf((Object[])array, (Object)"1", (int)2));
        ArrayUtilsTest.assertEquals((int)2, (int)ArrayUtils.lastIndexOf((Object[])array, (Object)"2", (int)2));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((Object[])array, (Object)"3", (int)2));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((Object[])array, (Object)"3", (int)-1));
        ArrayUtilsTest.assertEquals((int)4, (int)ArrayUtils.lastIndexOf((Object[])array, null, (int)5));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((Object[])array, null, (int)2));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((Object[])array, (Object)"notInArray", (int)5));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((Object[])array, null, (int)-1));
        ArrayUtilsTest.assertEquals((int)5, (int)ArrayUtils.lastIndexOf((Object[])array, (Object)"0", (int)88));
    }

    public void testContains() {
        Object[] array = new Object[]{"0", "1", "2", "3", null, "0"};
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.contains(null, null));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.contains(null, (Object)"1"));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((Object[])array, (Object)"0"));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((Object[])array, (Object)"1"));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((Object[])array, (Object)"2"));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((Object[])array, (Object)"3"));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((Object[])array, null));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.contains((Object[])array, (Object)"notInArray"));
    }

    public void testIndexOfLong() {
        long[] array = null;
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.indexOf(array, (long)0L));
        array = new long[]{0L, 1L, 2L, 3L, 0L};
        ArrayUtilsTest.assertEquals((int)0, (int)ArrayUtils.indexOf((long[])array, (long)0L));
        ArrayUtilsTest.assertEquals((int)1, (int)ArrayUtils.indexOf((long[])array, (long)1L));
        ArrayUtilsTest.assertEquals((int)2, (int)ArrayUtils.indexOf((long[])array, (long)2L));
        ArrayUtilsTest.assertEquals((int)3, (int)ArrayUtils.indexOf((long[])array, (long)3L));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.indexOf((long[])array, (long)99L));
    }

    public void testIndexOfLongWithStartIndex() {
        long[] array = null;
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.indexOf(array, (long)0L, (int)2));
        array = new long[]{0L, 1L, 2L, 3L, 0L};
        ArrayUtilsTest.assertEquals((int)4, (int)ArrayUtils.indexOf((long[])array, (long)0L, (int)2));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.indexOf((long[])array, (long)1L, (int)2));
        ArrayUtilsTest.assertEquals((int)2, (int)ArrayUtils.indexOf((long[])array, (long)2L, (int)2));
        ArrayUtilsTest.assertEquals((int)3, (int)ArrayUtils.indexOf((long[])array, (long)3L, (int)2));
        ArrayUtilsTest.assertEquals((int)3, (int)ArrayUtils.indexOf((long[])array, (long)3L, (int)-1));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.indexOf((long[])array, (long)99L, (int)0));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.indexOf((long[])array, (long)0L, (int)6));
    }

    public void testLastIndexOfLong() {
        long[] array = null;
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf(array, (long)0L));
        array = new long[]{0L, 1L, 2L, 3L, 0L};
        ArrayUtilsTest.assertEquals((int)4, (int)ArrayUtils.lastIndexOf((long[])array, (long)0L));
        ArrayUtilsTest.assertEquals((int)1, (int)ArrayUtils.lastIndexOf((long[])array, (long)1L));
        ArrayUtilsTest.assertEquals((int)2, (int)ArrayUtils.lastIndexOf((long[])array, (long)2L));
        ArrayUtilsTest.assertEquals((int)3, (int)ArrayUtils.lastIndexOf((long[])array, (long)3L));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((long[])array, (long)99L));
    }

    public void testLastIndexOfLongWithStartIndex() {
        long[] array = null;
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf(array, (long)0L, (int)2));
        array = new long[]{0L, 1L, 2L, 3L, 0L};
        ArrayUtilsTest.assertEquals((int)0, (int)ArrayUtils.lastIndexOf((long[])array, (long)0L, (int)2));
        ArrayUtilsTest.assertEquals((int)1, (int)ArrayUtils.lastIndexOf((long[])array, (long)1L, (int)2));
        ArrayUtilsTest.assertEquals((int)2, (int)ArrayUtils.lastIndexOf((long[])array, (long)2L, (int)2));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((long[])array, (long)3L, (int)2));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((long[])array, (long)3L, (int)-1));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((long[])array, (long)99L, (int)4));
        ArrayUtilsTest.assertEquals((int)4, (int)ArrayUtils.lastIndexOf((long[])array, (long)0L, (int)88));
    }

    public void testContainsLong() {
        long[] array = null;
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.contains(array, (long)1L));
        array = new long[]{0L, 1L, 2L, 3L, 0L};
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((long[])array, (long)0L));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((long[])array, (long)1L));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((long[])array, (long)2L));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((long[])array, (long)3L));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.contains((long[])array, (long)99L));
    }

    public void testIndexOfInt() {
        int[] array = null;
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.indexOf(array, (int)0));
        array = new int[]{0, 1, 2, 3, 0};
        ArrayUtilsTest.assertEquals((int)0, (int)ArrayUtils.indexOf((int[])array, (int)0));
        ArrayUtilsTest.assertEquals((int)1, (int)ArrayUtils.indexOf((int[])array, (int)1));
        ArrayUtilsTest.assertEquals((int)2, (int)ArrayUtils.indexOf((int[])array, (int)2));
        ArrayUtilsTest.assertEquals((int)3, (int)ArrayUtils.indexOf((int[])array, (int)3));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.indexOf((int[])array, (int)99));
    }

    public void testIndexOfIntWithStartIndex() {
        int[] array = null;
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.indexOf(array, (int)0, (int)2));
        array = new int[]{0, 1, 2, 3, 0};
        ArrayUtilsTest.assertEquals((int)4, (int)ArrayUtils.indexOf((int[])array, (int)0, (int)2));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.indexOf((int[])array, (int)1, (int)2));
        ArrayUtilsTest.assertEquals((int)2, (int)ArrayUtils.indexOf((int[])array, (int)2, (int)2));
        ArrayUtilsTest.assertEquals((int)3, (int)ArrayUtils.indexOf((int[])array, (int)3, (int)2));
        ArrayUtilsTest.assertEquals((int)3, (int)ArrayUtils.indexOf((int[])array, (int)3, (int)-1));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.indexOf((int[])array, (int)99, (int)0));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.indexOf((int[])array, (int)0, (int)6));
    }

    public void testLastIndexOfInt() {
        int[] array = null;
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf(array, (int)0));
        array = new int[]{0, 1, 2, 3, 0};
        ArrayUtilsTest.assertEquals((int)4, (int)ArrayUtils.lastIndexOf((int[])array, (int)0));
        ArrayUtilsTest.assertEquals((int)1, (int)ArrayUtils.lastIndexOf((int[])array, (int)1));
        ArrayUtilsTest.assertEquals((int)2, (int)ArrayUtils.lastIndexOf((int[])array, (int)2));
        ArrayUtilsTest.assertEquals((int)3, (int)ArrayUtils.lastIndexOf((int[])array, (int)3));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((int[])array, (int)99));
    }

    public void testLastIndexOfIntWithStartIndex() {
        int[] array = null;
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf(array, (int)0, (int)2));
        array = new int[]{0, 1, 2, 3, 0};
        ArrayUtilsTest.assertEquals((int)0, (int)ArrayUtils.lastIndexOf((int[])array, (int)0, (int)2));
        ArrayUtilsTest.assertEquals((int)1, (int)ArrayUtils.lastIndexOf((int[])array, (int)1, (int)2));
        ArrayUtilsTest.assertEquals((int)2, (int)ArrayUtils.lastIndexOf((int[])array, (int)2, (int)2));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((int[])array, (int)3, (int)2));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((int[])array, (int)3, (int)-1));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((int[])array, (int)99));
        ArrayUtilsTest.assertEquals((int)4, (int)ArrayUtils.lastIndexOf((int[])array, (int)0, (int)88));
    }

    public void testContainsInt() {
        int[] array = null;
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.contains(array, (int)1));
        array = new int[]{0, 1, 2, 3, 0};
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((int[])array, (int)0));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((int[])array, (int)1));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((int[])array, (int)2));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((int[])array, (int)3));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.contains((int[])array, (int)99));
    }

    public void testIndexOfShort() {
        short[] array = null;
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.indexOf(array, (short)0));
        array = new short[]{0, 1, 2, 3, 0};
        ArrayUtilsTest.assertEquals((int)0, (int)ArrayUtils.indexOf((short[])array, (short)0));
        ArrayUtilsTest.assertEquals((int)1, (int)ArrayUtils.indexOf((short[])array, (short)1));
        ArrayUtilsTest.assertEquals((int)2, (int)ArrayUtils.indexOf((short[])array, (short)2));
        ArrayUtilsTest.assertEquals((int)3, (int)ArrayUtils.indexOf((short[])array, (short)3));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.indexOf((short[])array, (short)99));
    }

    public void testIndexOfShortWithStartIndex() {
        short[] array = null;
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.indexOf(array, (short)0, (int)2));
        array = new short[]{0, 1, 2, 3, 0};
        ArrayUtilsTest.assertEquals((int)4, (int)ArrayUtils.indexOf((short[])array, (short)0, (int)2));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.indexOf((short[])array, (short)1, (int)2));
        ArrayUtilsTest.assertEquals((int)2, (int)ArrayUtils.indexOf((short[])array, (short)2, (int)2));
        ArrayUtilsTest.assertEquals((int)3, (int)ArrayUtils.indexOf((short[])array, (short)3, (int)2));
        ArrayUtilsTest.assertEquals((int)3, (int)ArrayUtils.indexOf((short[])array, (short)3, (int)-1));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.indexOf((short[])array, (short)99, (int)0));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.indexOf((short[])array, (short)0, (int)6));
    }

    public void testLastIndexOfShort() {
        short[] array = null;
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf(array, (short)0));
        array = new short[]{0, 1, 2, 3, 0};
        ArrayUtilsTest.assertEquals((int)4, (int)ArrayUtils.lastIndexOf((short[])array, (short)0));
        ArrayUtilsTest.assertEquals((int)1, (int)ArrayUtils.lastIndexOf((short[])array, (short)1));
        ArrayUtilsTest.assertEquals((int)2, (int)ArrayUtils.lastIndexOf((short[])array, (short)2));
        ArrayUtilsTest.assertEquals((int)3, (int)ArrayUtils.lastIndexOf((short[])array, (short)3));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((short[])array, (short)99));
    }

    public void testLastIndexOfShortWithStartIndex() {
        short[] array = null;
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf(array, (short)0, (int)2));
        array = new short[]{0, 1, 2, 3, 0};
        ArrayUtilsTest.assertEquals((int)0, (int)ArrayUtils.lastIndexOf((short[])array, (short)0, (int)2));
        ArrayUtilsTest.assertEquals((int)1, (int)ArrayUtils.lastIndexOf((short[])array, (short)1, (int)2));
        ArrayUtilsTest.assertEquals((int)2, (int)ArrayUtils.lastIndexOf((short[])array, (short)2, (int)2));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((short[])array, (short)3, (int)2));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((short[])array, (short)3, (int)-1));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((short[])array, (short)99));
        ArrayUtilsTest.assertEquals((int)4, (int)ArrayUtils.lastIndexOf((short[])array, (short)0, (int)88));
    }

    public void testContainsShort() {
        short[] array = null;
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.contains(array, (short)1));
        array = new short[]{0, 1, 2, 3, 0};
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((short[])array, (short)0));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((short[])array, (short)1));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((short[])array, (short)2));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((short[])array, (short)3));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.contains((short[])array, (short)99));
    }

    public void testIndexOfChar() {
        char[] array = null;
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.indexOf(array, (char)'a'));
        array = new char[]{'a', 'b', 'c', 'd', 'a'};
        ArrayUtilsTest.assertEquals((int)0, (int)ArrayUtils.indexOf((char[])array, (char)'a'));
        ArrayUtilsTest.assertEquals((int)1, (int)ArrayUtils.indexOf((char[])array, (char)'b'));
        ArrayUtilsTest.assertEquals((int)2, (int)ArrayUtils.indexOf((char[])array, (char)'c'));
        ArrayUtilsTest.assertEquals((int)3, (int)ArrayUtils.indexOf((char[])array, (char)'d'));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.indexOf((char[])array, (char)'e'));
    }

    public void testIndexOfCharWithStartIndex() {
        char[] array = null;
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.indexOf(array, (char)'a', (int)2));
        array = new char[]{'a', 'b', 'c', 'd', 'a'};
        ArrayUtilsTest.assertEquals((int)4, (int)ArrayUtils.indexOf((char[])array, (char)'a', (int)2));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.indexOf((char[])array, (char)'b', (int)2));
        ArrayUtilsTest.assertEquals((int)2, (int)ArrayUtils.indexOf((char[])array, (char)'c', (int)2));
        ArrayUtilsTest.assertEquals((int)3, (int)ArrayUtils.indexOf((char[])array, (char)'d', (int)2));
        ArrayUtilsTest.assertEquals((int)3, (int)ArrayUtils.indexOf((char[])array, (char)'d', (int)-1));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.indexOf((char[])array, (char)'e', (int)0));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.indexOf((char[])array, (char)'a', (int)6));
    }

    public void testLastIndexOfChar() {
        char[] array = null;
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf(array, (char)'a'));
        array = new char[]{'a', 'b', 'c', 'd', 'a'};
        ArrayUtilsTest.assertEquals((int)4, (int)ArrayUtils.lastIndexOf((char[])array, (char)'a'));
        ArrayUtilsTest.assertEquals((int)1, (int)ArrayUtils.lastIndexOf((char[])array, (char)'b'));
        ArrayUtilsTest.assertEquals((int)2, (int)ArrayUtils.lastIndexOf((char[])array, (char)'c'));
        ArrayUtilsTest.assertEquals((int)3, (int)ArrayUtils.lastIndexOf((char[])array, (char)'d'));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((char[])array, (char)'e'));
    }

    public void testLastIndexOfCharWithStartIndex() {
        char[] array = null;
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf(array, (char)'a', (int)2));
        array = new char[]{'a', 'b', 'c', 'd', 'a'};
        ArrayUtilsTest.assertEquals((int)0, (int)ArrayUtils.lastIndexOf((char[])array, (char)'a', (int)2));
        ArrayUtilsTest.assertEquals((int)1, (int)ArrayUtils.lastIndexOf((char[])array, (char)'b', (int)2));
        ArrayUtilsTest.assertEquals((int)2, (int)ArrayUtils.lastIndexOf((char[])array, (char)'c', (int)2));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((char[])array, (char)'d', (int)2));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((char[])array, (char)'d', (int)-1));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((char[])array, (char)'e'));
        ArrayUtilsTest.assertEquals((int)4, (int)ArrayUtils.lastIndexOf((char[])array, (char)'a', (int)88));
    }

    public void testContainsChar() {
        char[] array = null;
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.contains(array, (char)'b'));
        array = new char[]{'a', 'b', 'c', 'd', 'a'};
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((char[])array, (char)'a'));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((char[])array, (char)'b'));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((char[])array, (char)'c'));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((char[])array, (char)'d'));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.contains((char[])array, (char)'e'));
    }

    public void testIndexOfByte() {
        byte[] array = null;
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.indexOf(array, (byte)0));
        array = new byte[]{0, 1, 2, 3, 0};
        ArrayUtilsTest.assertEquals((int)0, (int)ArrayUtils.indexOf((byte[])array, (byte)0));
        ArrayUtilsTest.assertEquals((int)1, (int)ArrayUtils.indexOf((byte[])array, (byte)1));
        ArrayUtilsTest.assertEquals((int)2, (int)ArrayUtils.indexOf((byte[])array, (byte)2));
        ArrayUtilsTest.assertEquals((int)3, (int)ArrayUtils.indexOf((byte[])array, (byte)3));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.indexOf((byte[])array, (byte)99));
    }

    public void testIndexOfByteWithStartIndex() {
        byte[] array = null;
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.indexOf(array, (byte)0, (int)2));
        array = new byte[]{0, 1, 2, 3, 0};
        ArrayUtilsTest.assertEquals((int)4, (int)ArrayUtils.indexOf((byte[])array, (byte)0, (int)2));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.indexOf((byte[])array, (byte)1, (int)2));
        ArrayUtilsTest.assertEquals((int)2, (int)ArrayUtils.indexOf((byte[])array, (byte)2, (int)2));
        ArrayUtilsTest.assertEquals((int)3, (int)ArrayUtils.indexOf((byte[])array, (byte)3, (int)2));
        ArrayUtilsTest.assertEquals((int)3, (int)ArrayUtils.indexOf((byte[])array, (byte)3, (int)-1));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.indexOf((byte[])array, (byte)99, (int)0));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.indexOf((byte[])array, (byte)0, (int)6));
    }

    public void testLastIndexOfByte() {
        byte[] array = null;
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf(array, (byte)0));
        array = new byte[]{0, 1, 2, 3, 0};
        ArrayUtilsTest.assertEquals((int)4, (int)ArrayUtils.lastIndexOf((byte[])array, (byte)0));
        ArrayUtilsTest.assertEquals((int)1, (int)ArrayUtils.lastIndexOf((byte[])array, (byte)1));
        ArrayUtilsTest.assertEquals((int)2, (int)ArrayUtils.lastIndexOf((byte[])array, (byte)2));
        ArrayUtilsTest.assertEquals((int)3, (int)ArrayUtils.lastIndexOf((byte[])array, (byte)3));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((byte[])array, (byte)99));
    }

    public void testLastIndexOfByteWithStartIndex() {
        byte[] array = null;
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf(array, (byte)0, (int)2));
        array = new byte[]{0, 1, 2, 3, 0};
        ArrayUtilsTest.assertEquals((int)0, (int)ArrayUtils.lastIndexOf((byte[])array, (byte)0, (int)2));
        ArrayUtilsTest.assertEquals((int)1, (int)ArrayUtils.lastIndexOf((byte[])array, (byte)1, (int)2));
        ArrayUtilsTest.assertEquals((int)2, (int)ArrayUtils.lastIndexOf((byte[])array, (byte)2, (int)2));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((byte[])array, (byte)3, (int)2));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((byte[])array, (byte)3, (int)-1));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((byte[])array, (byte)99));
        ArrayUtilsTest.assertEquals((int)4, (int)ArrayUtils.lastIndexOf((byte[])array, (byte)0, (int)88));
    }

    public void testContainsByte() {
        byte[] array = null;
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.contains(array, (byte)1));
        array = new byte[]{0, 1, 2, 3, 0};
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((byte[])array, (byte)0));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((byte[])array, (byte)1));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((byte[])array, (byte)2));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((byte[])array, (byte)3));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.contains((byte[])array, (byte)99));
    }

    public void testIndexOfDouble() {
        double[] array = null;
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.indexOf(array, (double)0.0));
        array = new double[]{};
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.indexOf((double[])array, (double)0.0));
        array = new double[]{0.0, 1.0, 2.0, 3.0, 0.0};
        ArrayUtilsTest.assertEquals((int)0, (int)ArrayUtils.indexOf((double[])array, (double)0.0));
        ArrayUtilsTest.assertEquals((int)1, (int)ArrayUtils.indexOf((double[])array, (double)1.0));
        ArrayUtilsTest.assertEquals((int)2, (int)ArrayUtils.indexOf((double[])array, (double)2.0));
        ArrayUtilsTest.assertEquals((int)3, (int)ArrayUtils.indexOf((double[])array, (double)3.0));
        ArrayUtilsTest.assertEquals((int)3, (int)ArrayUtils.indexOf((double[])array, (double)3.0, (int)-1));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.indexOf((double[])array, (double)99.0));
    }

    public void testIndexOfDoubleTolerance() {
        double[] array = null;
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.indexOf(array, (double)0.0, (double)0.0));
        array = new double[]{};
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.indexOf((double[])array, (double)0.0, (double)0.0));
        array = new double[]{0.0, 1.0, 2.0, 3.0, 0.0};
        ArrayUtilsTest.assertEquals((int)0, (int)ArrayUtils.indexOf((double[])array, (double)0.0, (double)0.3));
        ArrayUtilsTest.assertEquals((int)2, (int)ArrayUtils.indexOf((double[])array, (double)2.2, (double)0.35));
        ArrayUtilsTest.assertEquals((int)3, (int)ArrayUtils.indexOf((double[])array, (double)4.15, (double)2.0));
        ArrayUtilsTest.assertEquals((int)1, (int)ArrayUtils.indexOf((double[])array, (double)1.00001324, (double)1.0E-4));
    }

    public void testIndexOfDoubleWithStartIndex() {
        double[] array = null;
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.indexOf(array, (double)0.0, (int)2));
        array = new double[]{};
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.indexOf((double[])array, (double)0.0, (int)2));
        array = new double[]{0.0, 1.0, 2.0, 3.0, 0.0};
        ArrayUtilsTest.assertEquals((int)4, (int)ArrayUtils.indexOf((double[])array, (double)0.0, (int)2));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.indexOf((double[])array, (double)1.0, (int)2));
        ArrayUtilsTest.assertEquals((int)2, (int)ArrayUtils.indexOf((double[])array, (double)2.0, (int)2));
        ArrayUtilsTest.assertEquals((int)3, (int)ArrayUtils.indexOf((double[])array, (double)3.0, (int)2));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.indexOf((double[])array, (double)99.0, (int)0));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.indexOf((double[])array, (double)0.0, (int)6));
    }

    public void testIndexOfDoubleWithStartIndexTolerance() {
        double[] array = null;
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.indexOf(array, (double)0.0, (int)2, (double)0.0));
        array = new double[]{};
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.indexOf((double[])array, (double)0.0, (int)2, (double)0.0));
        array = new double[]{0.0, 1.0, 2.0, 3.0, 0.0};
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.indexOf((double[])array, (double)0.0, (int)99, (double)0.3));
        ArrayUtilsTest.assertEquals((int)0, (int)ArrayUtils.indexOf((double[])array, (double)0.0, (int)0, (double)0.3));
        ArrayUtilsTest.assertEquals((int)4, (int)ArrayUtils.indexOf((double[])array, (double)0.0, (int)3, (double)0.3));
        ArrayUtilsTest.assertEquals((int)2, (int)ArrayUtils.indexOf((double[])array, (double)2.2, (int)0, (double)0.35));
        ArrayUtilsTest.assertEquals((int)3, (int)ArrayUtils.indexOf((double[])array, (double)4.15, (int)0, (double)2.0));
        ArrayUtilsTest.assertEquals((int)1, (int)ArrayUtils.indexOf((double[])array, (double)1.00001324, (int)0, (double)1.0E-4));
        ArrayUtilsTest.assertEquals((int)3, (int)ArrayUtils.indexOf((double[])array, (double)4.15, (int)-1, (double)2.0));
        ArrayUtilsTest.assertEquals((int)1, (int)ArrayUtils.indexOf((double[])array, (double)1.00001324, (int)-300, (double)1.0E-4));
    }

    public void testLastIndexOfDouble() {
        double[] array = null;
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf(array, (double)0.0));
        array = new double[]{};
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((double[])array, (double)0.0));
        array = new double[]{0.0, 1.0, 2.0, 3.0, 0.0};
        ArrayUtilsTest.assertEquals((int)4, (int)ArrayUtils.lastIndexOf((double[])array, (double)0.0));
        ArrayUtilsTest.assertEquals((int)1, (int)ArrayUtils.lastIndexOf((double[])array, (double)1.0));
        ArrayUtilsTest.assertEquals((int)2, (int)ArrayUtils.lastIndexOf((double[])array, (double)2.0));
        ArrayUtilsTest.assertEquals((int)3, (int)ArrayUtils.lastIndexOf((double[])array, (double)3.0));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((double[])array, (double)99.0));
    }

    public void testLastIndexOfDoubleTolerance() {
        double[] array = null;
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf(array, (double)0.0, (double)0.0));
        array = new double[]{};
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((double[])array, (double)0.0, (double)0.0));
        array = new double[]{0.0, 1.0, 2.0, 3.0, 0.0};
        ArrayUtilsTest.assertEquals((int)4, (int)ArrayUtils.lastIndexOf((double[])array, (double)0.0, (double)0.3));
        ArrayUtilsTest.assertEquals((int)2, (int)ArrayUtils.lastIndexOf((double[])array, (double)2.2, (double)0.35));
        ArrayUtilsTest.assertEquals((int)3, (int)ArrayUtils.lastIndexOf((double[])array, (double)4.15, (double)2.0));
        ArrayUtilsTest.assertEquals((int)1, (int)ArrayUtils.lastIndexOf((double[])array, (double)1.00001324, (double)1.0E-4));
    }

    public void testLastIndexOfDoubleWithStartIndex() {
        double[] array = null;
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf(array, (double)0.0, (int)2));
        array = new double[]{};
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((double[])array, (double)0.0, (int)2));
        array = new double[]{0.0, 1.0, 2.0, 3.0, 0.0};
        ArrayUtilsTest.assertEquals((int)0, (int)ArrayUtils.lastIndexOf((double[])array, (double)0.0, (int)2));
        ArrayUtilsTest.assertEquals((int)1, (int)ArrayUtils.lastIndexOf((double[])array, (double)1.0, (int)2));
        ArrayUtilsTest.assertEquals((int)2, (int)ArrayUtils.lastIndexOf((double[])array, (double)2.0, (int)2));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((double[])array, (double)3.0, (int)2));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((double[])array, (double)3.0, (int)-1));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((double[])array, (double)99.0));
        ArrayUtilsTest.assertEquals((int)4, (int)ArrayUtils.lastIndexOf((double[])array, (double)0.0, (int)88));
    }

    public void testLastIndexOfDoubleWithStartIndexTolerance() {
        double[] array = null;
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf(array, (double)0.0, (int)2, (double)0.0));
        array = new double[]{};
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((double[])array, (double)0.0, (int)2, (double)0.0));
        array = new double[]{3.0};
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((double[])array, (double)1.0, (int)0, (double)0.0));
        array = new double[]{0.0, 1.0, 2.0, 3.0, 0.0};
        ArrayUtilsTest.assertEquals((int)4, (int)ArrayUtils.lastIndexOf((double[])array, (double)0.0, (int)99, (double)0.3));
        ArrayUtilsTest.assertEquals((int)0, (int)ArrayUtils.lastIndexOf((double[])array, (double)0.0, (int)3, (double)0.3));
        ArrayUtilsTest.assertEquals((int)2, (int)ArrayUtils.lastIndexOf((double[])array, (double)2.2, (int)3, (double)0.35));
        ArrayUtilsTest.assertEquals((int)3, (int)ArrayUtils.lastIndexOf((double[])array, (double)4.15, (int)array.length, (double)2.0));
        ArrayUtilsTest.assertEquals((int)1, (int)ArrayUtils.lastIndexOf((double[])array, (double)1.00001324, (int)array.length, (double)1.0E-4));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((double[])array, (double)4.15, (int)-200, (double)2.0));
    }

    public void testContainsDouble() {
        double[] array = null;
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.contains(array, (double)1.0));
        array = new double[]{0.0, 1.0, 2.0, 3.0, 0.0};
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((double[])array, (double)0.0));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((double[])array, (double)1.0));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((double[])array, (double)2.0));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((double[])array, (double)3.0));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.contains((double[])array, (double)99.0));
    }

    public void testContainsDoubleTolerance() {
        double[] array = null;
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.contains(array, (double)1.0, (double)0.0));
        array = new double[]{0.0, 1.0, 2.0, 3.0, 0.0};
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.contains((double[])array, (double)4.0, (double)0.33));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.contains((double[])array, (double)2.5, (double)0.49));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((double[])array, (double)2.5, (double)0.5));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((double[])array, (double)2.5, (double)0.51));
    }

    public void testIndexOfFloat() {
        float[] array = null;
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.indexOf(array, (float)0.0f));
        array = new float[]{};
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.indexOf((float[])array, (float)0.0f));
        array = new float[]{0.0f, 1.0f, 2.0f, 3.0f, 0.0f};
        ArrayUtilsTest.assertEquals((int)0, (int)ArrayUtils.indexOf((float[])array, (float)0.0f));
        ArrayUtilsTest.assertEquals((int)1, (int)ArrayUtils.indexOf((float[])array, (float)1.0f));
        ArrayUtilsTest.assertEquals((int)2, (int)ArrayUtils.indexOf((float[])array, (float)2.0f));
        ArrayUtilsTest.assertEquals((int)3, (int)ArrayUtils.indexOf((float[])array, (float)3.0f));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.indexOf((float[])array, (float)99.0f));
    }

    public void testIndexOfFloatWithStartIndex() {
        float[] array = null;
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.indexOf(array, (float)0.0f, (int)2));
        array = new float[]{};
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.indexOf((float[])array, (float)0.0f, (int)2));
        array = new float[]{0.0f, 1.0f, 2.0f, 3.0f, 0.0f};
        ArrayUtilsTest.assertEquals((int)4, (int)ArrayUtils.indexOf((float[])array, (float)0.0f, (int)2));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.indexOf((float[])array, (float)1.0f, (int)2));
        ArrayUtilsTest.assertEquals((int)2, (int)ArrayUtils.indexOf((float[])array, (float)2.0f, (int)2));
        ArrayUtilsTest.assertEquals((int)3, (int)ArrayUtils.indexOf((float[])array, (float)3.0f, (int)2));
        ArrayUtilsTest.assertEquals((int)3, (int)ArrayUtils.indexOf((float[])array, (float)3.0f, (int)-1));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.indexOf((float[])array, (float)99.0f, (int)0));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.indexOf((float[])array, (float)0.0f, (int)6));
    }

    public void testLastIndexOfFloat() {
        float[] array = null;
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf(array, (float)0.0f));
        array = new float[]{};
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((float[])array, (float)0.0f));
        array = new float[]{0.0f, 1.0f, 2.0f, 3.0f, 0.0f};
        ArrayUtilsTest.assertEquals((int)4, (int)ArrayUtils.lastIndexOf((float[])array, (float)0.0f));
        ArrayUtilsTest.assertEquals((int)1, (int)ArrayUtils.lastIndexOf((float[])array, (float)1.0f));
        ArrayUtilsTest.assertEquals((int)2, (int)ArrayUtils.lastIndexOf((float[])array, (float)2.0f));
        ArrayUtilsTest.assertEquals((int)3, (int)ArrayUtils.lastIndexOf((float[])array, (float)3.0f));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((float[])array, (float)99.0f));
    }

    public void testLastIndexOfFloatWithStartIndex() {
        float[] array = null;
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf(array, (float)0.0f, (int)2));
        array = new float[]{};
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((float[])array, (float)0.0f, (int)2));
        array = new float[]{0.0f, 1.0f, 2.0f, 3.0f, 0.0f};
        ArrayUtilsTest.assertEquals((int)0, (int)ArrayUtils.lastIndexOf((float[])array, (float)0.0f, (int)2));
        ArrayUtilsTest.assertEquals((int)1, (int)ArrayUtils.lastIndexOf((float[])array, (float)1.0f, (int)2));
        ArrayUtilsTest.assertEquals((int)2, (int)ArrayUtils.lastIndexOf((float[])array, (float)2.0f, (int)2));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((float[])array, (float)3.0f, (int)2));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((float[])array, (float)3.0f, (int)-1));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((float[])array, (float)99.0f));
        ArrayUtilsTest.assertEquals((int)4, (int)ArrayUtils.lastIndexOf((float[])array, (float)0.0f, (int)88));
    }

    public void testContainsFloat() {
        float[] array = null;
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.contains(array, (float)1.0f));
        array = new float[]{0.0f, 1.0f, 2.0f, 3.0f, 0.0f};
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((float[])array, (float)0.0f));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((float[])array, (float)1.0f));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((float[])array, (float)2.0f));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((float[])array, (float)3.0f));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.contains((float[])array, (float)99.0f));
    }

    public void testIndexOfBoolean() {
        boolean[] array = null;
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.indexOf(array, (boolean)true));
        array = new boolean[]{};
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.indexOf((boolean[])array, (boolean)true));
        array = new boolean[]{true, false, true};
        ArrayUtilsTest.assertEquals((int)0, (int)ArrayUtils.indexOf((boolean[])array, (boolean)true));
        ArrayUtilsTest.assertEquals((int)1, (int)ArrayUtils.indexOf((boolean[])array, (boolean)false));
        array = new boolean[]{true, true};
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.indexOf((boolean[])array, (boolean)false));
    }

    public void testIndexOfBooleanWithStartIndex() {
        boolean[] array = null;
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.indexOf(array, (boolean)true, (int)2));
        array = new boolean[]{};
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.indexOf((boolean[])array, (boolean)true, (int)2));
        array = new boolean[]{true, false, true};
        ArrayUtilsTest.assertEquals((int)2, (int)ArrayUtils.indexOf((boolean[])array, (boolean)true, (int)1));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.indexOf((boolean[])array, (boolean)false, (int)2));
        ArrayUtilsTest.assertEquals((int)1, (int)ArrayUtils.indexOf((boolean[])array, (boolean)false, (int)0));
        ArrayUtilsTest.assertEquals((int)1, (int)ArrayUtils.indexOf((boolean[])array, (boolean)false, (int)-1));
        array = new boolean[]{true, true};
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.indexOf((boolean[])array, (boolean)false, (int)0));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.indexOf((boolean[])array, (boolean)false, (int)-1));
    }

    public void testLastIndexOfBoolean() {
        boolean[] array = null;
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf(array, (boolean)true));
        array = new boolean[]{};
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((boolean[])array, (boolean)true));
        array = new boolean[]{true, false, true};
        ArrayUtilsTest.assertEquals((int)2, (int)ArrayUtils.lastIndexOf((boolean[])array, (boolean)true));
        ArrayUtilsTest.assertEquals((int)1, (int)ArrayUtils.lastIndexOf((boolean[])array, (boolean)false));
        array = new boolean[]{true, true};
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((boolean[])array, (boolean)false));
    }

    public void testLastIndexOfBooleanWithStartIndex() {
        boolean[] array = null;
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf(array, (boolean)true, (int)2));
        array = new boolean[]{};
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((boolean[])array, (boolean)true, (int)2));
        array = new boolean[]{true, false, true};
        ArrayUtilsTest.assertEquals((int)2, (int)ArrayUtils.lastIndexOf((boolean[])array, (boolean)true, (int)2));
        ArrayUtilsTest.assertEquals((int)0, (int)ArrayUtils.lastIndexOf((boolean[])array, (boolean)true, (int)1));
        ArrayUtilsTest.assertEquals((int)1, (int)ArrayUtils.lastIndexOf((boolean[])array, (boolean)false, (int)2));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((boolean[])array, (boolean)true, (int)-1));
        array = new boolean[]{true, true};
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((boolean[])array, (boolean)false, (int)2));
        ArrayUtilsTest.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((boolean[])array, (boolean)true, (int)-1));
    }

    public void testContainsBoolean() {
        boolean[] array = null;
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.contains(array, (boolean)true));
        array = new boolean[]{true, false, true};
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((boolean[])array, (boolean)true));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((boolean[])array, (boolean)false));
        array = new boolean[]{true, true};
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((boolean[])array, (boolean)true));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.contains((boolean[])array, (boolean)false));
    }

    public void testToPrimitive_boolean() {
        Boolean[] b = null;
        ArrayUtilsTest.assertEquals(null, (Object)ArrayUtils.toPrimitive(b));
        ArrayUtilsTest.assertSame((Object)ArrayUtils.EMPTY_BOOLEAN_ARRAY, (Object)ArrayUtils.toPrimitive((Boolean[])new Boolean[0]));
        ArrayUtilsTest.assertTrue((boolean)Arrays.equals(new boolean[]{true, false, true}, ArrayUtils.toPrimitive((Boolean[])new Boolean[]{Boolean.TRUE, Boolean.FALSE, Boolean.TRUE})));
        try {
            ArrayUtils.toPrimitive((Boolean[])new Boolean[]{Boolean.TRUE, null});
            ArrayUtilsTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testToPrimitive_boolean_boolean() {
        ArrayUtilsTest.assertEquals(null, (Object)ArrayUtils.toPrimitive(null, (boolean)false));
        ArrayUtilsTest.assertSame((Object)ArrayUtils.EMPTY_BOOLEAN_ARRAY, (Object)ArrayUtils.toPrimitive((Boolean[])new Boolean[0], (boolean)false));
        ArrayUtilsTest.assertTrue((boolean)Arrays.equals(new boolean[]{true, false, true}, ArrayUtils.toPrimitive((Boolean[])new Boolean[]{Boolean.TRUE, Boolean.FALSE, Boolean.TRUE}, (boolean)false)));
        ArrayUtilsTest.assertTrue((boolean)Arrays.equals(new boolean[]{true, false, false}, ArrayUtils.toPrimitive((Boolean[])new Boolean[]{Boolean.TRUE, null, Boolean.FALSE}, (boolean)false)));
        ArrayUtilsTest.assertTrue((boolean)Arrays.equals(new boolean[]{true, true, false}, ArrayUtils.toPrimitive((Boolean[])new Boolean[]{Boolean.TRUE, null, Boolean.FALSE}, (boolean)true)));
    }

    public void testToObject_boolean() {
        boolean[] b = null;
        ArrayUtilsTest.assertEquals(null, (Object)ArrayUtils.toObject(b));
        ArrayUtilsTest.assertSame((Object)ArrayUtils.EMPTY_BOOLEAN_OBJECT_ARRAY, (Object)ArrayUtils.toObject((boolean[])new boolean[0]));
        ArrayUtilsTest.assertTrue((boolean)Arrays.equals((Object[])new Boolean[]{Boolean.TRUE, Boolean.FALSE, Boolean.TRUE}, (Object[])ArrayUtils.toObject((boolean[])new boolean[]{true, false, true})));
    }

    public void testToPrimitive_char() {
        Character[] b = null;
        ArrayUtilsTest.assertEquals(null, (Object)ArrayUtils.toPrimitive(b));
        ArrayUtilsTest.assertSame((Object)ArrayUtils.EMPTY_CHAR_ARRAY, (Object)ArrayUtils.toPrimitive((Character[])new Character[0]));
        ArrayUtilsTest.assertTrue((boolean)Arrays.equals(new char[]{'\u0000', '\uffff', '0'}, ArrayUtils.toPrimitive((Character[])new Character[]{new Character('\u0000'), new Character('\uffff'), new Character('0')})));
        try {
            ArrayUtils.toPrimitive((Character[])new Character[]{new Character('\u0000'), null});
            ArrayUtilsTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testToPrimitive_char_char() {
        Character[] b = null;
        ArrayUtilsTest.assertEquals(null, (Object)ArrayUtils.toPrimitive(b, (char)'\u0000'));
        ArrayUtilsTest.assertSame((Object)ArrayUtils.EMPTY_CHAR_ARRAY, (Object)ArrayUtils.toPrimitive((Character[])new Character[0], (char)'\u0000'));
        ArrayUtilsTest.assertTrue((boolean)Arrays.equals(new char[]{'\u0000', '\uffff', '0'}, ArrayUtils.toPrimitive((Character[])new Character[]{new Character('\u0000'), new Character('\uffff'), new Character('0')}, (char)'\u0000')));
        ArrayUtilsTest.assertTrue((boolean)Arrays.equals(new char[]{'\u0000', '\uffff', '0'}, ArrayUtils.toPrimitive((Character[])new Character[]{new Character('\u0000'), null, new Character('0')}, (char)'\uffff')));
    }

    public void testToObject_char() {
        char[] b = null;
        ArrayUtilsTest.assertEquals(null, (Object)ArrayUtils.toObject(b));
        ArrayUtilsTest.assertSame((Object)ArrayUtils.EMPTY_CHARACTER_OBJECT_ARRAY, (Object)ArrayUtils.toObject((char[])new char[0]));
        ArrayUtilsTest.assertTrue((boolean)Arrays.equals((Object[])new Character[]{new Character('\u0000'), new Character('\uffff'), new Character('0')}, (Object[])ArrayUtils.toObject((char[])new char[]{'\u0000', '\uffff', '0'})));
    }

    public void testToPrimitive_byte() {
        Byte[] b = null;
        ArrayUtilsTest.assertEquals(null, (Object)ArrayUtils.toPrimitive(b));
        ArrayUtilsTest.assertSame((Object)ArrayUtils.EMPTY_BYTE_ARRAY, (Object)ArrayUtils.toPrimitive((Byte[])new Byte[0]));
        ArrayUtilsTest.assertTrue((boolean)Arrays.equals(new byte[]{-128, 127, 127}, ArrayUtils.toPrimitive((Byte[])new Byte[]{(byte)-128, (byte)127, (byte)127})));
        try {
            ArrayUtils.toPrimitive((Byte[])new Byte[]{(byte)-128, null});
            ArrayUtilsTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testToPrimitive_byte_byte() {
        Byte[] b = null;
        ArrayUtilsTest.assertEquals(null, (Object)ArrayUtils.toPrimitive(b, (byte)-128));
        ArrayUtilsTest.assertSame((Object)ArrayUtils.EMPTY_BYTE_ARRAY, (Object)ArrayUtils.toPrimitive((Byte[])new Byte[0], (byte)1));
        ArrayUtilsTest.assertTrue((boolean)Arrays.equals(new byte[]{-128, 127, 127}, ArrayUtils.toPrimitive((Byte[])new Byte[]{(byte)-128, (byte)127, (byte)127}, (byte)-128)));
        ArrayUtilsTest.assertTrue((boolean)Arrays.equals(new byte[]{-128, 127, 127}, ArrayUtils.toPrimitive((Byte[])new Byte[]{(byte)-128, null, (byte)127}, (byte)127)));
    }

    public void testToObject_byte() {
        byte[] b = null;
        ArrayUtilsTest.assertEquals(null, (Object)ArrayUtils.toObject(b));
        ArrayUtilsTest.assertSame((Object)ArrayUtils.EMPTY_BYTE_OBJECT_ARRAY, (Object)ArrayUtils.toObject((byte[])new byte[0]));
        ArrayUtilsTest.assertTrue((boolean)Arrays.equals((Object[])new Byte[]{(byte)-128, (byte)127, (byte)127}, (Object[])ArrayUtils.toObject((byte[])new byte[]{-128, 127, 127})));
    }

    public void testToPrimitive_short() {
        Short[] b = null;
        ArrayUtilsTest.assertEquals(null, (Object)ArrayUtils.toPrimitive(b));
        ArrayUtilsTest.assertSame((Object)ArrayUtils.EMPTY_SHORT_ARRAY, (Object)ArrayUtils.toPrimitive((Short[])new Short[0]));
        ArrayUtilsTest.assertTrue((boolean)Arrays.equals(new short[]{Short.MIN_VALUE, Short.MAX_VALUE, -27009}, ArrayUtils.toPrimitive((Short[])new Short[]{new Short(Short.MIN_VALUE), new Short(Short.MAX_VALUE), new Short(-27009)})));
        try {
            ArrayUtils.toPrimitive((Short[])new Short[]{new Short(Short.MIN_VALUE), null});
            ArrayUtilsTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testToPrimitive_short_short() {
        Short[] s = null;
        ArrayUtilsTest.assertEquals(null, (Object)ArrayUtils.toPrimitive(s, (short)Short.MIN_VALUE));
        ArrayUtilsTest.assertSame((Object)ArrayUtils.EMPTY_SHORT_ARRAY, (Object)ArrayUtils.toPrimitive((Short[])new Short[0], (short)Short.MIN_VALUE));
        ArrayUtilsTest.assertTrue((boolean)Arrays.equals(new short[]{Short.MIN_VALUE, Short.MAX_VALUE, -27009}, ArrayUtils.toPrimitive((Short[])new Short[]{new Short(Short.MIN_VALUE), new Short(Short.MAX_VALUE), new Short(-27009)}, (short)Short.MIN_VALUE)));
        ArrayUtilsTest.assertTrue((boolean)Arrays.equals(new short[]{Short.MIN_VALUE, Short.MAX_VALUE, -27009}, ArrayUtils.toPrimitive((Short[])new Short[]{new Short(Short.MIN_VALUE), null, new Short(-27009)}, (short)Short.MAX_VALUE)));
    }

    public void testToObject_short() {
        short[] b = null;
        ArrayUtilsTest.assertEquals(null, (Object)ArrayUtils.toObject(b));
        ArrayUtilsTest.assertSame((Object)ArrayUtils.EMPTY_SHORT_OBJECT_ARRAY, (Object)ArrayUtils.toObject((short[])new short[0]));
        ArrayUtilsTest.assertTrue((boolean)Arrays.equals((Object[])new Short[]{new Short(Short.MIN_VALUE), new Short(Short.MAX_VALUE), new Short(-27009)}, (Object[])ArrayUtils.toObject((short[])new short[]{Short.MIN_VALUE, Short.MAX_VALUE, -27009})));
    }

    public void testToPrimitive_int() {
        Integer[] b = null;
        ArrayUtilsTest.assertEquals(null, (Object)ArrayUtils.toPrimitive(b));
        ArrayUtilsTest.assertSame((Object)ArrayUtils.EMPTY_INT_ARRAY, (Object)ArrayUtils.toPrimitive((Integer[])new Integer[0]));
        ArrayUtilsTest.assertTrue((boolean)Arrays.equals(new int[]{Integer.MIN_VALUE, Integer.MAX_VALUE, 9999999}, ArrayUtils.toPrimitive((Integer[])new Integer[]{new Integer(Integer.MIN_VALUE), new Integer(Integer.MAX_VALUE), new Integer(9999999)})));
        try {
            ArrayUtils.toPrimitive((Integer[])new Integer[]{new Integer(Integer.MIN_VALUE), null});
            ArrayUtilsTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testToPrimitive_int_int() {
        Long[] l = null;
        ArrayUtilsTest.assertEquals(null, (Object)ArrayUtils.toPrimitive(l, (long)Integer.MIN_VALUE));
        ArrayUtilsTest.assertSame((Object)ArrayUtils.EMPTY_INT_ARRAY, (Object)ArrayUtils.toPrimitive((Integer[])new Integer[0], (int)1));
        ArrayUtilsTest.assertTrue((boolean)Arrays.equals(new int[]{Integer.MIN_VALUE, Integer.MAX_VALUE, 9999999}, ArrayUtils.toPrimitive((Integer[])new Integer[]{new Integer(Integer.MIN_VALUE), new Integer(Integer.MAX_VALUE), new Integer(9999999)}, (int)1)));
        ArrayUtilsTest.assertTrue((boolean)Arrays.equals(new int[]{Integer.MIN_VALUE, Integer.MAX_VALUE, 9999999}, ArrayUtils.toPrimitive((Integer[])new Integer[]{new Integer(Integer.MIN_VALUE), null, new Integer(9999999)}, (int)Integer.MAX_VALUE)));
    }

    public void testToPrimitive_intNull() {
        Integer[] iArray = null;
        ArrayUtilsTest.assertEquals(null, (Object)ArrayUtils.toPrimitive(iArray, (int)Integer.MIN_VALUE));
    }

    public void testToObject_int() {
        int[] b = null;
        ArrayUtilsTest.assertEquals(null, (Object)ArrayUtils.toObject(b));
        ArrayUtilsTest.assertSame((Object)ArrayUtils.EMPTY_INTEGER_OBJECT_ARRAY, (Object)ArrayUtils.toObject((int[])new int[0]));
        ArrayUtilsTest.assertTrue((boolean)Arrays.equals((Object[])new Integer[]{new Integer(Integer.MIN_VALUE), new Integer(Integer.MAX_VALUE), new Integer(9999999)}, (Object[])ArrayUtils.toObject((int[])new int[]{Integer.MIN_VALUE, Integer.MAX_VALUE, 9999999})));
    }

    public void testToPrimitive_long() {
        Long[] b = null;
        ArrayUtilsTest.assertEquals(null, (Object)ArrayUtils.toPrimitive(b));
        ArrayUtilsTest.assertSame((Object)ArrayUtils.EMPTY_LONG_ARRAY, (Object)ArrayUtils.toPrimitive((Long[])new Long[0]));
        ArrayUtilsTest.assertTrue((boolean)Arrays.equals(new long[]{Long.MIN_VALUE, Long.MAX_VALUE, 9999999L}, ArrayUtils.toPrimitive((Long[])new Long[]{new Long(Long.MIN_VALUE), new Long(Long.MAX_VALUE), new Long(9999999L)})));
        try {
            ArrayUtils.toPrimitive((Long[])new Long[]{new Long(Long.MIN_VALUE), null});
            ArrayUtilsTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testToPrimitive_long_long() {
        Long[] l = null;
        ArrayUtilsTest.assertEquals(null, (Object)ArrayUtils.toPrimitive(l, (long)Long.MIN_VALUE));
        ArrayUtilsTest.assertSame((Object)ArrayUtils.EMPTY_LONG_ARRAY, (Object)ArrayUtils.toPrimitive((Long[])new Long[0], (long)1L));
        ArrayUtilsTest.assertTrue((boolean)Arrays.equals(new long[]{Long.MIN_VALUE, Long.MAX_VALUE, 9999999L}, ArrayUtils.toPrimitive((Long[])new Long[]{new Long(Long.MIN_VALUE), new Long(Long.MAX_VALUE), new Long(9999999L)}, (long)1L)));
        ArrayUtilsTest.assertTrue((boolean)Arrays.equals(new long[]{Long.MIN_VALUE, Long.MAX_VALUE, 9999999L}, ArrayUtils.toPrimitive((Long[])new Long[]{new Long(Long.MIN_VALUE), null, new Long(9999999L)}, (long)Long.MAX_VALUE)));
    }

    public void testToObject_long() {
        long[] b = null;
        ArrayUtilsTest.assertEquals(null, (Object)ArrayUtils.toObject(b));
        ArrayUtilsTest.assertSame((Object)ArrayUtils.EMPTY_LONG_OBJECT_ARRAY, (Object)ArrayUtils.toObject((long[])new long[0]));
        ArrayUtilsTest.assertTrue((boolean)Arrays.equals((Object[])new Long[]{new Long(Long.MIN_VALUE), new Long(Long.MAX_VALUE), new Long(9999999L)}, (Object[])ArrayUtils.toObject((long[])new long[]{Long.MIN_VALUE, Long.MAX_VALUE, 9999999L})));
    }

    public void testToPrimitive_float() {
        Float[] b = null;
        ArrayUtilsTest.assertEquals(null, (Object)ArrayUtils.toPrimitive(b));
        ArrayUtilsTest.assertSame((Object)ArrayUtils.EMPTY_FLOAT_ARRAY, (Object)ArrayUtils.toPrimitive((Float[])new Float[0]));
        ArrayUtilsTest.assertTrue((boolean)Arrays.equals(new float[]{Float.MIN_VALUE, Float.MAX_VALUE, 9999999.0f}, ArrayUtils.toPrimitive((Float[])new Float[]{new Float(Float.MIN_VALUE), new Float(Float.MAX_VALUE), new Float(9999999.0f)})));
        try {
            ArrayUtils.toPrimitive((Float[])new Float[]{new Float(Float.MIN_VALUE), null});
            ArrayUtilsTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testToPrimitive_float_float() {
        Float[] l = null;
        ArrayUtilsTest.assertEquals(null, (Object)ArrayUtils.toPrimitive(l, (float)Float.MIN_VALUE));
        ArrayUtilsTest.assertSame((Object)ArrayUtils.EMPTY_FLOAT_ARRAY, (Object)ArrayUtils.toPrimitive((Float[])new Float[0], (float)1.0f));
        ArrayUtilsTest.assertTrue((boolean)Arrays.equals(new float[]{Float.MIN_VALUE, Float.MAX_VALUE, 9999999.0f}, ArrayUtils.toPrimitive((Float[])new Float[]{new Float(Float.MIN_VALUE), new Float(Float.MAX_VALUE), new Float(9999999.0f)}, (float)1.0f)));
        ArrayUtilsTest.assertTrue((boolean)Arrays.equals(new float[]{Float.MIN_VALUE, Float.MAX_VALUE, 9999999.0f}, ArrayUtils.toPrimitive((Float[])new Float[]{new Float(Float.MIN_VALUE), null, new Float(9999999.0f)}, (float)Float.MAX_VALUE)));
    }

    public void testToObject_float() {
        float[] b = null;
        ArrayUtilsTest.assertEquals(null, (Object)ArrayUtils.toObject(b));
        ArrayUtilsTest.assertSame((Object)ArrayUtils.EMPTY_FLOAT_OBJECT_ARRAY, (Object)ArrayUtils.toObject((float[])new float[0]));
        ArrayUtilsTest.assertTrue((boolean)Arrays.equals((Object[])new Float[]{new Float(Float.MIN_VALUE), new Float(Float.MAX_VALUE), new Float(9999999.0f)}, (Object[])ArrayUtils.toObject((float[])new float[]{Float.MIN_VALUE, Float.MAX_VALUE, 9999999.0f})));
    }

    public void testToPrimitive_double() {
        Double[] b = null;
        ArrayUtilsTest.assertEquals(null, (Object)ArrayUtils.toPrimitive(b));
        ArrayUtilsTest.assertSame((Object)ArrayUtils.EMPTY_DOUBLE_ARRAY, (Object)ArrayUtils.toPrimitive((Double[])new Double[0]));
        ArrayUtilsTest.assertTrue((boolean)Arrays.equals(new double[]{Double.MIN_VALUE, Double.MAX_VALUE, 9999999.0}, ArrayUtils.toPrimitive((Double[])new Double[]{new Double(Double.MIN_VALUE), new Double(Double.MAX_VALUE), new Double(9999999.0)})));
        try {
            ArrayUtils.toPrimitive((Float[])new Float[]{new Float(Float.MIN_VALUE), null});
            ArrayUtilsTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testToPrimitive_double_double() {
        Double[] l = null;
        ArrayUtilsTest.assertEquals(null, (Object)ArrayUtils.toPrimitive(l, (double)Double.MIN_VALUE));
        ArrayUtilsTest.assertSame((Object)ArrayUtils.EMPTY_DOUBLE_ARRAY, (Object)ArrayUtils.toPrimitive((Double[])new Double[0], (double)1.0));
        ArrayUtilsTest.assertTrue((boolean)Arrays.equals(new double[]{Double.MIN_VALUE, Double.MAX_VALUE, 9999999.0}, ArrayUtils.toPrimitive((Double[])new Double[]{new Double(Double.MIN_VALUE), new Double(Double.MAX_VALUE), new Double(9999999.0)}, (double)1.0)));
        ArrayUtilsTest.assertTrue((boolean)Arrays.equals(new double[]{Double.MIN_VALUE, Double.MAX_VALUE, 9999999.0}, ArrayUtils.toPrimitive((Double[])new Double[]{new Double(Double.MIN_VALUE), null, new Double(9999999.0)}, (double)Double.MAX_VALUE)));
    }

    public void testToObject_double() {
        double[] b = null;
        ArrayUtilsTest.assertEquals(null, (Object)ArrayUtils.toObject(b));
        ArrayUtilsTest.assertSame((Object)ArrayUtils.EMPTY_DOUBLE_OBJECT_ARRAY, (Object)ArrayUtils.toObject((double[])new double[0]));
        ArrayUtilsTest.assertTrue((boolean)Arrays.equals((Object[])new Double[]{new Double(Double.MIN_VALUE), new Double(Double.MAX_VALUE), new Double(9999999.0)}, (Object[])ArrayUtils.toObject((double[])new double[]{Double.MIN_VALUE, Double.MAX_VALUE, 9999999.0})));
    }

    public void testIsEmptyObject() {
        Object[] emptyArray = new Object[]{};
        Object[] notEmptyArray = new Object[]{new String("Value")};
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isEmpty((Object[])null));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isEmpty((Object[])emptyArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isEmpty((Object[])notEmptyArray));
    }

    public void testIsEmptyPrimitives() {
        long[] emptyLongArray = new long[]{};
        long[] notEmptyLongArray = new long[]{1L};
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isEmpty((long[])null));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isEmpty((long[])emptyLongArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isEmpty((long[])notEmptyLongArray));
        int[] emptyIntArray = new int[]{};
        int[] notEmptyIntArray = new int[]{1};
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isEmpty((int[])null));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isEmpty((int[])emptyIntArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isEmpty((int[])notEmptyIntArray));
        short[] emptyShortArray = new short[]{};
        short[] notEmptyShortArray = new short[]{1};
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isEmpty((short[])null));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isEmpty((short[])emptyShortArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isEmpty((short[])notEmptyShortArray));
        char[] emptyCharArray = new char[]{};
        char[] notEmptyCharArray = new char[]{'\u0001'};
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isEmpty((char[])null));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isEmpty((char[])emptyCharArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isEmpty((char[])notEmptyCharArray));
        byte[] emptyByteArray = new byte[]{};
        byte[] notEmptyByteArray = new byte[]{1};
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isEmpty((byte[])null));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isEmpty((byte[])emptyByteArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isEmpty((byte[])notEmptyByteArray));
        double[] emptyDoubleArray = new double[]{};
        double[] notEmptyDoubleArray = new double[]{1.0};
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isEmpty((double[])null));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isEmpty((double[])emptyDoubleArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isEmpty((double[])notEmptyDoubleArray));
        float[] emptyFloatArray = new float[]{};
        float[] notEmptyFloatArray = new float[]{1.0f};
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isEmpty((float[])null));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isEmpty((float[])emptyFloatArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isEmpty((float[])notEmptyFloatArray));
        boolean[] emptyBooleanArray = new boolean[]{};
        boolean[] notEmptyBooleanArray = new boolean[]{true};
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isEmpty((boolean[])null));
        ArrayUtilsTest.assertEquals((boolean)true, (boolean)ArrayUtils.isEmpty((boolean[])emptyBooleanArray));
        ArrayUtilsTest.assertEquals((boolean)false, (boolean)ArrayUtils.isEmpty((boolean[])notEmptyBooleanArray));
    }

    public void testIsNotEmptyObject() {
        Object[] emptyArray = new Object[]{};
        Object[] notEmptyArray = new Object[]{new String("Value")};
        ArrayUtilsTest.assertFalse((boolean)ArrayUtils.isNotEmpty((Object[])null));
        ArrayUtilsTest.assertFalse((boolean)ArrayUtils.isNotEmpty((Object[])emptyArray));
        ArrayUtilsTest.assertTrue((boolean)ArrayUtils.isNotEmpty((Object[])notEmptyArray));
    }

    public void testIsNotEmptyPrimitives() {
        long[] emptyLongArray = new long[]{};
        long[] notEmptyLongArray = new long[]{1L};
        ArrayUtilsTest.assertFalse((boolean)ArrayUtils.isNotEmpty((long[])null));
        ArrayUtilsTest.assertFalse((boolean)ArrayUtils.isNotEmpty((long[])emptyLongArray));
        ArrayUtilsTest.assertTrue((boolean)ArrayUtils.isNotEmpty((long[])notEmptyLongArray));
        int[] emptyIntArray = new int[]{};
        int[] notEmptyIntArray = new int[]{1};
        ArrayUtilsTest.assertFalse((boolean)ArrayUtils.isNotEmpty((int[])null));
        ArrayUtilsTest.assertFalse((boolean)ArrayUtils.isNotEmpty((int[])emptyIntArray));
        ArrayUtilsTest.assertTrue((boolean)ArrayUtils.isNotEmpty((int[])notEmptyIntArray));
        short[] emptyShortArray = new short[]{};
        short[] notEmptyShortArray = new short[]{1};
        ArrayUtilsTest.assertFalse((boolean)ArrayUtils.isNotEmpty((short[])null));
        ArrayUtilsTest.assertFalse((boolean)ArrayUtils.isNotEmpty((short[])emptyShortArray));
        ArrayUtilsTest.assertTrue((boolean)ArrayUtils.isNotEmpty((short[])notEmptyShortArray));
        char[] emptyCharArray = new char[]{};
        char[] notEmptyCharArray = new char[]{'\u0001'};
        ArrayUtilsTest.assertFalse((boolean)ArrayUtils.isNotEmpty((char[])null));
        ArrayUtilsTest.assertFalse((boolean)ArrayUtils.isNotEmpty((char[])emptyCharArray));
        ArrayUtilsTest.assertTrue((boolean)ArrayUtils.isNotEmpty((char[])notEmptyCharArray));
        byte[] emptyByteArray = new byte[]{};
        byte[] notEmptyByteArray = new byte[]{1};
        ArrayUtilsTest.assertFalse((boolean)ArrayUtils.isNotEmpty((byte[])null));
        ArrayUtilsTest.assertFalse((boolean)ArrayUtils.isNotEmpty((byte[])emptyByteArray));
        ArrayUtilsTest.assertTrue((boolean)ArrayUtils.isNotEmpty((byte[])notEmptyByteArray));
        double[] emptyDoubleArray = new double[]{};
        double[] notEmptyDoubleArray = new double[]{1.0};
        ArrayUtilsTest.assertFalse((boolean)ArrayUtils.isNotEmpty((double[])null));
        ArrayUtilsTest.assertFalse((boolean)ArrayUtils.isNotEmpty((double[])emptyDoubleArray));
        ArrayUtilsTest.assertTrue((boolean)ArrayUtils.isNotEmpty((double[])notEmptyDoubleArray));
        float[] emptyFloatArray = new float[]{};
        float[] notEmptyFloatArray = new float[]{1.0f};
        ArrayUtilsTest.assertFalse((boolean)ArrayUtils.isNotEmpty((float[])null));
        ArrayUtilsTest.assertFalse((boolean)ArrayUtils.isNotEmpty((float[])emptyFloatArray));
        ArrayUtilsTest.assertTrue((boolean)ArrayUtils.isNotEmpty((float[])notEmptyFloatArray));
        boolean[] emptyBooleanArray = new boolean[]{};
        boolean[] notEmptyBooleanArray = new boolean[]{true};
        ArrayUtilsTest.assertFalse((boolean)ArrayUtils.isNotEmpty((boolean[])null));
        ArrayUtilsTest.assertFalse((boolean)ArrayUtils.isNotEmpty((boolean[])emptyBooleanArray));
        ArrayUtilsTest.assertTrue((boolean)ArrayUtils.isNotEmpty((boolean[])notEmptyBooleanArray));
    }

    public void testGetLength() {
        ArrayUtilsTest.assertEquals((int)0, (int)ArrayUtils.getLength(null));
        Object[] emptyObjectArray = new Object[]{};
        Object[] notEmptyObjectArray = new Object[]{"aValue"};
        ArrayUtilsTest.assertEquals((int)0, (int)ArrayUtils.getLength((Object)null));
        ArrayUtilsTest.assertEquals((int)0, (int)ArrayUtils.getLength((Object)emptyObjectArray));
        ArrayUtilsTest.assertEquals((int)1, (int)ArrayUtils.getLength((Object)notEmptyObjectArray));
        int[] emptyIntArray = new int[]{};
        int[] notEmptyIntArray = new int[]{1};
        ArrayUtilsTest.assertEquals((int)0, (int)ArrayUtils.getLength((Object)null));
        ArrayUtilsTest.assertEquals((int)0, (int)ArrayUtils.getLength((Object)emptyIntArray));
        ArrayUtilsTest.assertEquals((int)1, (int)ArrayUtils.getLength((Object)notEmptyIntArray));
        short[] emptyShortArray = new short[]{};
        short[] notEmptyShortArray = new short[]{1};
        ArrayUtilsTest.assertEquals((int)0, (int)ArrayUtils.getLength((Object)null));
        ArrayUtilsTest.assertEquals((int)0, (int)ArrayUtils.getLength((Object)emptyShortArray));
        ArrayUtilsTest.assertEquals((int)1, (int)ArrayUtils.getLength((Object)notEmptyShortArray));
        char[] emptyCharArray = new char[]{};
        char[] notEmptyCharArray = new char[]{'\u0001'};
        ArrayUtilsTest.assertEquals((int)0, (int)ArrayUtils.getLength((Object)null));
        ArrayUtilsTest.assertEquals((int)0, (int)ArrayUtils.getLength((Object)emptyCharArray));
        ArrayUtilsTest.assertEquals((int)1, (int)ArrayUtils.getLength((Object)notEmptyCharArray));
        byte[] emptyByteArray = new byte[]{};
        byte[] notEmptyByteArray = new byte[]{1};
        ArrayUtilsTest.assertEquals((int)0, (int)ArrayUtils.getLength((Object)null));
        ArrayUtilsTest.assertEquals((int)0, (int)ArrayUtils.getLength((Object)emptyByteArray));
        ArrayUtilsTest.assertEquals((int)1, (int)ArrayUtils.getLength((Object)notEmptyByteArray));
        double[] emptyDoubleArray = new double[]{};
        double[] notEmptyDoubleArray = new double[]{1.0};
        ArrayUtilsTest.assertEquals((int)0, (int)ArrayUtils.getLength((Object)null));
        ArrayUtilsTest.assertEquals((int)0, (int)ArrayUtils.getLength((Object)emptyDoubleArray));
        ArrayUtilsTest.assertEquals((int)1, (int)ArrayUtils.getLength((Object)notEmptyDoubleArray));
        float[] emptyFloatArray = new float[]{};
        float[] notEmptyFloatArray = new float[]{1.0f};
        ArrayUtilsTest.assertEquals((int)0, (int)ArrayUtils.getLength((Object)null));
        ArrayUtilsTest.assertEquals((int)0, (int)ArrayUtils.getLength((Object)emptyFloatArray));
        ArrayUtilsTest.assertEquals((int)1, (int)ArrayUtils.getLength((Object)notEmptyFloatArray));
        boolean[] emptyBooleanArray = new boolean[]{};
        boolean[] notEmptyBooleanArray = new boolean[]{true};
        ArrayUtilsTest.assertEquals((int)0, (int)ArrayUtils.getLength((Object)null));
        ArrayUtilsTest.assertEquals((int)0, (int)ArrayUtils.getLength((Object)emptyBooleanArray));
        ArrayUtilsTest.assertEquals((int)1, (int)ArrayUtils.getLength((Object)notEmptyBooleanArray));
        try {
            ArrayUtils.getLength((Object)"notAnArray");
            ArrayUtilsTest.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }
}

