/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import junit.framework.TestCase;
import org.apache.commons.lang3.BooleanUtils;

public class BooleanUtilsTest
extends TestCase {
    public BooleanUtilsTest(String name) {
        super(name);
    }

    public void testConstructor() {
        BooleanUtilsTest.assertNotNull((Object)new BooleanUtils());
        Constructor<?>[] cons = BooleanUtils.class.getDeclaredConstructors();
        BooleanUtilsTest.assertEquals((int)1, (int)cons.length);
        BooleanUtilsTest.assertEquals((boolean)true, (boolean)Modifier.isPublic(cons[0].getModifiers()));
        BooleanUtilsTest.assertEquals((boolean)true, (boolean)Modifier.isPublic(BooleanUtils.class.getModifiers()));
        BooleanUtilsTest.assertEquals((boolean)false, (boolean)Modifier.isFinal(BooleanUtils.class.getModifiers()));
    }

    public void test_negate_Boolean() {
        BooleanUtilsTest.assertSame(null, (Object)BooleanUtils.negate(null));
        BooleanUtilsTest.assertSame((Object)Boolean.TRUE, (Object)BooleanUtils.negate((Boolean)Boolean.FALSE));
        BooleanUtilsTest.assertSame((Object)Boolean.FALSE, (Object)BooleanUtils.negate((Boolean)Boolean.TRUE));
    }

    public void test_isTrue_Boolean() {
        BooleanUtilsTest.assertEquals((boolean)true, (boolean)BooleanUtils.isTrue((Boolean)Boolean.TRUE));
        BooleanUtilsTest.assertEquals((boolean)false, (boolean)BooleanUtils.isTrue((Boolean)Boolean.FALSE));
        BooleanUtilsTest.assertEquals((boolean)false, (boolean)BooleanUtils.isTrue((Boolean)null));
    }

    public void test_isNotTrue_Boolean() {
        BooleanUtilsTest.assertEquals((boolean)false, (boolean)BooleanUtils.isNotTrue((Boolean)Boolean.TRUE));
        BooleanUtilsTest.assertEquals((boolean)true, (boolean)BooleanUtils.isNotTrue((Boolean)Boolean.FALSE));
        BooleanUtilsTest.assertEquals((boolean)true, (boolean)BooleanUtils.isNotTrue((Boolean)null));
    }

    public void test_isFalse_Boolean() {
        BooleanUtilsTest.assertEquals((boolean)false, (boolean)BooleanUtils.isFalse((Boolean)Boolean.TRUE));
        BooleanUtilsTest.assertEquals((boolean)true, (boolean)BooleanUtils.isFalse((Boolean)Boolean.FALSE));
        BooleanUtilsTest.assertEquals((boolean)false, (boolean)BooleanUtils.isFalse((Boolean)null));
    }

    public void test_isNotFalse_Boolean() {
        BooleanUtilsTest.assertEquals((boolean)true, (boolean)BooleanUtils.isNotFalse((Boolean)Boolean.TRUE));
        BooleanUtilsTest.assertEquals((boolean)false, (boolean)BooleanUtils.isNotFalse((Boolean)Boolean.FALSE));
        BooleanUtilsTest.assertEquals((boolean)true, (boolean)BooleanUtils.isNotFalse((Boolean)null));
    }

    public void test_toBoolean_Boolean() {
        BooleanUtilsTest.assertEquals((boolean)true, (boolean)BooleanUtils.toBoolean((Boolean)Boolean.TRUE));
        BooleanUtilsTest.assertEquals((boolean)false, (boolean)BooleanUtils.toBoolean((Boolean)Boolean.FALSE));
        BooleanUtilsTest.assertEquals((boolean)false, (boolean)BooleanUtils.toBoolean((Boolean)null));
    }

    public void test_toBooleanDefaultIfNull_Boolean_boolean() {
        BooleanUtilsTest.assertEquals((boolean)true, (boolean)BooleanUtils.toBooleanDefaultIfNull((Boolean)Boolean.TRUE, (boolean)true));
        BooleanUtilsTest.assertEquals((boolean)true, (boolean)BooleanUtils.toBooleanDefaultIfNull((Boolean)Boolean.TRUE, (boolean)false));
        BooleanUtilsTest.assertEquals((boolean)false, (boolean)BooleanUtils.toBooleanDefaultIfNull((Boolean)Boolean.FALSE, (boolean)true));
        BooleanUtilsTest.assertEquals((boolean)false, (boolean)BooleanUtils.toBooleanDefaultIfNull((Boolean)Boolean.FALSE, (boolean)false));
        BooleanUtilsTest.assertEquals((boolean)true, (boolean)BooleanUtils.toBooleanDefaultIfNull((Boolean)null, (boolean)true));
        BooleanUtilsTest.assertEquals((boolean)false, (boolean)BooleanUtils.toBooleanDefaultIfNull((Boolean)null, (boolean)false));
    }

    public void test_toBoolean_int() {
        BooleanUtilsTest.assertEquals((boolean)true, (boolean)BooleanUtils.toBoolean((int)1));
        BooleanUtilsTest.assertEquals((boolean)true, (boolean)BooleanUtils.toBoolean((int)-1));
        BooleanUtilsTest.assertEquals((boolean)false, (boolean)BooleanUtils.toBoolean((int)0));
    }

    public void test_toBooleanObject_int() {
        BooleanUtilsTest.assertEquals((Object)Boolean.TRUE, (Object)BooleanUtils.toBooleanObject((int)1));
        BooleanUtilsTest.assertEquals((Object)Boolean.TRUE, (Object)BooleanUtils.toBooleanObject((int)-1));
        BooleanUtilsTest.assertEquals((Object)Boolean.FALSE, (Object)BooleanUtils.toBooleanObject((int)0));
    }

    public void test_toBooleanObject_Integer() {
        BooleanUtilsTest.assertEquals((Object)Boolean.TRUE, (Object)BooleanUtils.toBooleanObject((Integer)new Integer(1)));
        BooleanUtilsTest.assertEquals((Object)Boolean.TRUE, (Object)BooleanUtils.toBooleanObject((Integer)new Integer(-1)));
        BooleanUtilsTest.assertEquals((Object)Boolean.FALSE, (Object)BooleanUtils.toBooleanObject((Integer)new Integer(0)));
        BooleanUtilsTest.assertEquals(null, (Object)BooleanUtils.toBooleanObject((Integer)null));
    }

    public void test_toBoolean_int_int_int() {
        BooleanUtilsTest.assertEquals((boolean)true, (boolean)BooleanUtils.toBoolean((int)6, (int)6, (int)7));
        BooleanUtilsTest.assertEquals((boolean)false, (boolean)BooleanUtils.toBoolean((int)7, (int)6, (int)7));
        try {
            BooleanUtils.toBoolean((int)8, (int)6, (int)7);
            BooleanUtilsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void test_toBoolean_Integer_Integer_Integer() {
        Integer six = new Integer(6);
        Integer seven = new Integer(7);
        BooleanUtilsTest.assertEquals((boolean)true, (boolean)BooleanUtils.toBoolean((Integer)null, null, (Integer)seven));
        BooleanUtilsTest.assertEquals((boolean)false, (boolean)BooleanUtils.toBoolean((Integer)null, (Integer)six, null));
        try {
            BooleanUtils.toBoolean(null, (Integer)six, (Integer)seven);
            BooleanUtilsTest.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        BooleanUtilsTest.assertEquals((boolean)true, (boolean)BooleanUtils.toBoolean((Integer)new Integer(6), (Integer)six, (Integer)seven));
        BooleanUtilsTest.assertEquals((boolean)false, (boolean)BooleanUtils.toBoolean((Integer)new Integer(7), (Integer)six, (Integer)seven));
        try {
            BooleanUtils.toBoolean((Integer)new Integer(8), (Integer)six, (Integer)seven);
            BooleanUtilsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void test_toBooleanObject_int_int_int() {
        BooleanUtilsTest.assertEquals((Object)Boolean.TRUE, (Object)BooleanUtils.toBooleanObject((int)6, (int)6, (int)7, (int)8));
        BooleanUtilsTest.assertEquals((Object)Boolean.FALSE, (Object)BooleanUtils.toBooleanObject((int)7, (int)6, (int)7, (int)8));
        BooleanUtilsTest.assertEquals(null, (Object)BooleanUtils.toBooleanObject((int)8, (int)6, (int)7, (int)8));
        try {
            BooleanUtils.toBooleanObject((int)9, (int)6, (int)7, (int)8);
            BooleanUtilsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void test_toBooleanObject_Integer_Integer_Integer_Integer() {
        Integer six = new Integer(6);
        Integer seven = new Integer(7);
        Integer eight = new Integer(8);
        BooleanUtilsTest.assertSame((Object)Boolean.TRUE, (Object)BooleanUtils.toBooleanObject((Integer)null, null, (Integer)seven, (Integer)eight));
        BooleanUtilsTest.assertSame((Object)Boolean.FALSE, (Object)BooleanUtils.toBooleanObject((Integer)null, (Integer)six, null, (Integer)eight));
        BooleanUtilsTest.assertSame(null, (Object)BooleanUtils.toBooleanObject((Integer)null, (Integer)six, (Integer)seven, null));
        try {
            BooleanUtils.toBooleanObject(null, (Integer)six, (Integer)seven, (Integer)eight);
            BooleanUtilsTest.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        BooleanUtilsTest.assertEquals((Object)Boolean.TRUE, (Object)BooleanUtils.toBooleanObject((Integer)new Integer(6), (Integer)six, (Integer)seven, (Integer)eight));
        BooleanUtilsTest.assertEquals((Object)Boolean.FALSE, (Object)BooleanUtils.toBooleanObject((Integer)new Integer(7), (Integer)six, (Integer)seven, (Integer)eight));
        BooleanUtilsTest.assertEquals(null, (Object)BooleanUtils.toBooleanObject((Integer)new Integer(8), (Integer)six, (Integer)seven, (Integer)eight));
        try {
            BooleanUtils.toBooleanObject((Integer)new Integer(9), (Integer)six, (Integer)seven, (Integer)eight);
            BooleanUtilsTest.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
    }

    public void test_toInteger_boolean() {
        BooleanUtilsTest.assertEquals((int)1, (int)BooleanUtils.toInteger((boolean)true));
        BooleanUtilsTest.assertEquals((int)0, (int)BooleanUtils.toInteger((boolean)false));
    }

    public void test_toIntegerObject_boolean() {
        BooleanUtilsTest.assertEquals((Object)new Integer(1), (Object)BooleanUtils.toIntegerObject((boolean)true));
        BooleanUtilsTest.assertEquals((Object)new Integer(0), (Object)BooleanUtils.toIntegerObject((boolean)false));
    }

    public void test_toIntegerObject_Boolean() {
        BooleanUtilsTest.assertEquals((Object)new Integer(1), (Object)BooleanUtils.toIntegerObject((Boolean)Boolean.TRUE));
        BooleanUtilsTest.assertEquals((Object)new Integer(0), (Object)BooleanUtils.toIntegerObject((Boolean)Boolean.FALSE));
        BooleanUtilsTest.assertEquals(null, (Object)BooleanUtils.toIntegerObject((Boolean)null));
    }

    public void test_toInteger_boolean_int_int() {
        BooleanUtilsTest.assertEquals((int)6, (int)BooleanUtils.toInteger((boolean)true, (int)6, (int)7));
        BooleanUtilsTest.assertEquals((int)7, (int)BooleanUtils.toInteger((boolean)false, (int)6, (int)7));
    }

    public void test_toInteger_Boolean_int_int_int() {
        BooleanUtilsTest.assertEquals((int)6, (int)BooleanUtils.toInteger((Boolean)Boolean.TRUE, (int)6, (int)7, (int)8));
        BooleanUtilsTest.assertEquals((int)7, (int)BooleanUtils.toInteger((Boolean)Boolean.FALSE, (int)6, (int)7, (int)8));
        BooleanUtilsTest.assertEquals((int)8, (int)BooleanUtils.toInteger(null, (int)6, (int)7, (int)8));
    }

    public void test_toIntegerObject_boolean_Integer_Integer() {
        Integer six = new Integer(6);
        Integer seven = new Integer(7);
        BooleanUtilsTest.assertEquals((Object)six, (Object)BooleanUtils.toIntegerObject((boolean)true, (Integer)six, (Integer)seven));
        BooleanUtilsTest.assertEquals((Object)seven, (Object)BooleanUtils.toIntegerObject((boolean)false, (Integer)six, (Integer)seven));
    }

    public void test_toIntegerObject_Boolean_Integer_Integer_Integer() {
        Integer six = new Integer(6);
        Integer seven = new Integer(7);
        Integer eight = new Integer(8);
        BooleanUtilsTest.assertEquals((Object)six, (Object)BooleanUtils.toIntegerObject((Boolean)Boolean.TRUE, (Integer)six, (Integer)seven, (Integer)eight));
        BooleanUtilsTest.assertEquals((Object)seven, (Object)BooleanUtils.toIntegerObject((Boolean)Boolean.FALSE, (Integer)six, (Integer)seven, (Integer)eight));
        BooleanUtilsTest.assertEquals((Object)eight, (Object)BooleanUtils.toIntegerObject((Boolean)null, (Integer)six, (Integer)seven, (Integer)eight));
        BooleanUtilsTest.assertEquals(null, (Object)BooleanUtils.toIntegerObject((Boolean)null, (Integer)six, (Integer)seven, null));
    }

    public void test_toBooleanObject_String() {
        BooleanUtilsTest.assertEquals(null, (Object)BooleanUtils.toBooleanObject((String)null));
        BooleanUtilsTest.assertEquals(null, (Object)BooleanUtils.toBooleanObject((String)""));
        BooleanUtilsTest.assertEquals((Object)Boolean.FALSE, (Object)BooleanUtils.toBooleanObject((String)"false"));
        BooleanUtilsTest.assertEquals((Object)Boolean.FALSE, (Object)BooleanUtils.toBooleanObject((String)"no"));
        BooleanUtilsTest.assertEquals((Object)Boolean.FALSE, (Object)BooleanUtils.toBooleanObject((String)"off"));
        BooleanUtilsTest.assertEquals((Object)Boolean.FALSE, (Object)BooleanUtils.toBooleanObject((String)"FALSE"));
        BooleanUtilsTest.assertEquals((Object)Boolean.FALSE, (Object)BooleanUtils.toBooleanObject((String)"NO"));
        BooleanUtilsTest.assertEquals((Object)Boolean.FALSE, (Object)BooleanUtils.toBooleanObject((String)"OFF"));
        BooleanUtilsTest.assertEquals(null, (Object)BooleanUtils.toBooleanObject((String)"oof"));
        BooleanUtilsTest.assertEquals((Object)Boolean.TRUE, (Object)BooleanUtils.toBooleanObject((String)"true"));
        BooleanUtilsTest.assertEquals((Object)Boolean.TRUE, (Object)BooleanUtils.toBooleanObject((String)"yes"));
        BooleanUtilsTest.assertEquals((Object)Boolean.TRUE, (Object)BooleanUtils.toBooleanObject((String)"on"));
        BooleanUtilsTest.assertEquals((Object)Boolean.TRUE, (Object)BooleanUtils.toBooleanObject((String)"TRUE"));
        BooleanUtilsTest.assertEquals((Object)Boolean.TRUE, (Object)BooleanUtils.toBooleanObject((String)"ON"));
        BooleanUtilsTest.assertEquals((Object)Boolean.TRUE, (Object)BooleanUtils.toBooleanObject((String)"YES"));
        BooleanUtilsTest.assertEquals((Object)Boolean.TRUE, (Object)BooleanUtils.toBooleanObject((String)"TruE"));
        BooleanUtilsTest.assertEquals((Object)Boolean.TRUE, (Object)BooleanUtils.toBooleanObject((String)"TruE"));
        BooleanUtilsTest.assertEquals((Object)Boolean.TRUE, (Object)BooleanUtils.toBooleanObject((String)"y"));
        BooleanUtilsTest.assertEquals((Object)Boolean.TRUE, (Object)BooleanUtils.toBooleanObject((String)"Y"));
        BooleanUtilsTest.assertEquals((Object)Boolean.TRUE, (Object)BooleanUtils.toBooleanObject((String)"t"));
        BooleanUtilsTest.assertEquals((Object)Boolean.TRUE, (Object)BooleanUtils.toBooleanObject((String)"T"));
        BooleanUtilsTest.assertEquals((Object)Boolean.FALSE, (Object)BooleanUtils.toBooleanObject((String)"f"));
        BooleanUtilsTest.assertEquals((Object)Boolean.FALSE, (Object)BooleanUtils.toBooleanObject((String)"F"));
        BooleanUtilsTest.assertEquals((Object)Boolean.FALSE, (Object)BooleanUtils.toBooleanObject((String)"n"));
        BooleanUtilsTest.assertEquals((Object)Boolean.FALSE, (Object)BooleanUtils.toBooleanObject((String)"N"));
        BooleanUtilsTest.assertEquals(null, (Object)BooleanUtils.toBooleanObject((String)"z"));
        BooleanUtilsTest.assertEquals(null, (Object)BooleanUtils.toBooleanObject((String)"ab"));
        BooleanUtilsTest.assertEquals(null, (Object)BooleanUtils.toBooleanObject((String)"yoo"));
    }

    public void test_toBooleanObject_String_String_String_String() {
        BooleanUtilsTest.assertSame((Object)Boolean.TRUE, (Object)BooleanUtils.toBooleanObject((String)null, null, (String)"N", (String)"U"));
        BooleanUtilsTest.assertSame((Object)Boolean.FALSE, (Object)BooleanUtils.toBooleanObject((String)null, (String)"Y", null, (String)"U"));
        BooleanUtilsTest.assertSame(null, (Object)BooleanUtils.toBooleanObject((String)null, (String)"Y", (String)"N", null));
        try {
            BooleanUtils.toBooleanObject((String)null, (String)"Y", (String)"N", (String)"U");
            BooleanUtilsTest.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        BooleanUtilsTest.assertEquals((Object)Boolean.TRUE, (Object)BooleanUtils.toBooleanObject((String)"Y", (String)"Y", (String)"N", (String)"U"));
        BooleanUtilsTest.assertEquals((Object)Boolean.FALSE, (Object)BooleanUtils.toBooleanObject((String)"N", (String)"Y", (String)"N", (String)"U"));
        BooleanUtilsTest.assertEquals(null, (Object)BooleanUtils.toBooleanObject((String)"U", (String)"Y", (String)"N", (String)"U"));
        try {
            BooleanUtils.toBooleanObject(null, (String)"Y", (String)"N", (String)"U");
            BooleanUtilsTest.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            BooleanUtils.toBooleanObject((String)"X", (String)"Y", (String)"N", (String)"U");
            BooleanUtilsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void test_toBoolean_String() {
        BooleanUtilsTest.assertEquals((boolean)false, (boolean)BooleanUtils.toBoolean((String)null));
        BooleanUtilsTest.assertEquals((boolean)false, (boolean)BooleanUtils.toBoolean((String)""));
        BooleanUtilsTest.assertEquals((boolean)false, (boolean)BooleanUtils.toBoolean((String)"off"));
        BooleanUtilsTest.assertEquals((boolean)false, (boolean)BooleanUtils.toBoolean((String)"oof"));
        BooleanUtilsTest.assertEquals((boolean)false, (boolean)BooleanUtils.toBoolean((String)"yep"));
        BooleanUtilsTest.assertEquals((boolean)false, (boolean)BooleanUtils.toBoolean((String)"trux"));
        BooleanUtilsTest.assertEquals((boolean)false, (boolean)BooleanUtils.toBoolean((String)"false"));
        BooleanUtilsTest.assertEquals((boolean)false, (boolean)BooleanUtils.toBoolean((String)"a"));
        BooleanUtilsTest.assertEquals((boolean)true, (boolean)BooleanUtils.toBoolean((String)"true"));
        BooleanUtilsTest.assertEquals((boolean)true, (boolean)BooleanUtils.toBoolean((String)new StringBuffer("tr").append("ue").toString()));
        BooleanUtilsTest.assertEquals((boolean)true, (boolean)BooleanUtils.toBoolean((String)"truE"));
        BooleanUtilsTest.assertEquals((boolean)true, (boolean)BooleanUtils.toBoolean((String)"trUe"));
        BooleanUtilsTest.assertEquals((boolean)true, (boolean)BooleanUtils.toBoolean((String)"trUE"));
        BooleanUtilsTest.assertEquals((boolean)true, (boolean)BooleanUtils.toBoolean((String)"tRue"));
        BooleanUtilsTest.assertEquals((boolean)true, (boolean)BooleanUtils.toBoolean((String)"tRuE"));
        BooleanUtilsTest.assertEquals((boolean)true, (boolean)BooleanUtils.toBoolean((String)"tRUe"));
        BooleanUtilsTest.assertEquals((boolean)true, (boolean)BooleanUtils.toBoolean((String)"tRUE"));
        BooleanUtilsTest.assertEquals((boolean)true, (boolean)BooleanUtils.toBoolean((String)"TRUE"));
        BooleanUtilsTest.assertEquals((boolean)true, (boolean)BooleanUtils.toBoolean((String)"TRUe"));
        BooleanUtilsTest.assertEquals((boolean)true, (boolean)BooleanUtils.toBoolean((String)"TRuE"));
        BooleanUtilsTest.assertEquals((boolean)true, (boolean)BooleanUtils.toBoolean((String)"TRue"));
        BooleanUtilsTest.assertEquals((boolean)true, (boolean)BooleanUtils.toBoolean((String)"TrUE"));
        BooleanUtilsTest.assertEquals((boolean)true, (boolean)BooleanUtils.toBoolean((String)"TrUe"));
        BooleanUtilsTest.assertEquals((boolean)true, (boolean)BooleanUtils.toBoolean((String)"TruE"));
        BooleanUtilsTest.assertEquals((boolean)true, (boolean)BooleanUtils.toBoolean((String)"True"));
        BooleanUtilsTest.assertEquals((boolean)true, (boolean)BooleanUtils.toBoolean((String)"on"));
        BooleanUtilsTest.assertEquals((boolean)true, (boolean)BooleanUtils.toBoolean((String)"oN"));
        BooleanUtilsTest.assertEquals((boolean)true, (boolean)BooleanUtils.toBoolean((String)"On"));
        BooleanUtilsTest.assertEquals((boolean)true, (boolean)BooleanUtils.toBoolean((String)"ON"));
        BooleanUtilsTest.assertEquals((boolean)true, (boolean)BooleanUtils.toBoolean((String)"yes"));
        BooleanUtilsTest.assertEquals((boolean)true, (boolean)BooleanUtils.toBoolean((String)"yeS"));
        BooleanUtilsTest.assertEquals((boolean)true, (boolean)BooleanUtils.toBoolean((String)"yEs"));
        BooleanUtilsTest.assertEquals((boolean)true, (boolean)BooleanUtils.toBoolean((String)"yES"));
        BooleanUtilsTest.assertEquals((boolean)true, (boolean)BooleanUtils.toBoolean((String)"Yes"));
        BooleanUtilsTest.assertEquals((boolean)true, (boolean)BooleanUtils.toBoolean((String)"YeS"));
        BooleanUtilsTest.assertEquals((boolean)true, (boolean)BooleanUtils.toBoolean((String)"YEs"));
        BooleanUtilsTest.assertEquals((boolean)true, (boolean)BooleanUtils.toBoolean((String)"YES"));
        BooleanUtilsTest.assertEquals((boolean)false, (boolean)BooleanUtils.toBoolean((String)"yes?"));
        BooleanUtilsTest.assertEquals((boolean)false, (boolean)BooleanUtils.toBoolean((String)"tru"));
        BooleanUtilsTest.assertEquals((boolean)false, (boolean)BooleanUtils.toBoolean((String)"no"));
        BooleanUtilsTest.assertEquals((boolean)false, (boolean)BooleanUtils.toBoolean((String)"off"));
        BooleanUtilsTest.assertEquals((boolean)false, (boolean)BooleanUtils.toBoolean((String)"yoo"));
    }

    public void test_toBoolean_String_String_String() {
        BooleanUtilsTest.assertEquals((boolean)true, (boolean)BooleanUtils.toBoolean((String)null, null, (String)"N"));
        BooleanUtilsTest.assertEquals((boolean)false, (boolean)BooleanUtils.toBoolean((String)null, (String)"Y", null));
        BooleanUtilsTest.assertEquals((boolean)true, (boolean)BooleanUtils.toBoolean((String)"Y", (String)"Y", (String)"N"));
        BooleanUtilsTest.assertEquals((boolean)true, (boolean)BooleanUtils.toBoolean((String)"Y", (String)new String("Y"), (String)new String("N")));
        BooleanUtilsTest.assertEquals((boolean)false, (boolean)BooleanUtils.toBoolean((String)"N", (String)"Y", (String)"N"));
        BooleanUtilsTest.assertEquals((boolean)false, (boolean)BooleanUtils.toBoolean((String)"N", (String)new String("Y"), (String)new String("N")));
        try {
            BooleanUtils.toBoolean(null, (String)"Y", (String)"N");
            BooleanUtilsTest.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            BooleanUtils.toBoolean((String)"X", (String)"Y", (String)"N");
            BooleanUtilsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        BooleanUtilsTest.assertEquals((boolean)true, (boolean)BooleanUtils.toBoolean((String)null, null, null));
        BooleanUtilsTest.assertEquals((boolean)true, (boolean)BooleanUtils.toBoolean((String)"Y", (String)"Y", (String)"Y"));
        BooleanUtilsTest.assertEquals((boolean)true, (boolean)BooleanUtils.toBoolean((String)"Y", (String)new String("Y"), (String)new String("Y")));
    }

    public void test_toStringTrueFalse_Boolean() {
        BooleanUtilsTest.assertEquals(null, (String)BooleanUtils.toStringTrueFalse((Boolean)null));
        BooleanUtilsTest.assertEquals((String)"true", (String)BooleanUtils.toStringTrueFalse((Boolean)Boolean.TRUE));
        BooleanUtilsTest.assertEquals((String)"false", (String)BooleanUtils.toStringTrueFalse((Boolean)Boolean.FALSE));
    }

    public void test_toStringOnOff_Boolean() {
        BooleanUtilsTest.assertEquals(null, (String)BooleanUtils.toStringOnOff((Boolean)null));
        BooleanUtilsTest.assertEquals((String)"on", (String)BooleanUtils.toStringOnOff((Boolean)Boolean.TRUE));
        BooleanUtilsTest.assertEquals((String)"off", (String)BooleanUtils.toStringOnOff((Boolean)Boolean.FALSE));
    }

    public void test_toStringYesNo_Boolean() {
        BooleanUtilsTest.assertEquals(null, (String)BooleanUtils.toStringYesNo((Boolean)null));
        BooleanUtilsTest.assertEquals((String)"yes", (String)BooleanUtils.toStringYesNo((Boolean)Boolean.TRUE));
        BooleanUtilsTest.assertEquals((String)"no", (String)BooleanUtils.toStringYesNo((Boolean)Boolean.FALSE));
    }

    public void test_toString_Boolean_String_String_String() {
        BooleanUtilsTest.assertEquals((String)"U", (String)BooleanUtils.toString((Boolean)null, (String)"Y", (String)"N", (String)"U"));
        BooleanUtilsTest.assertEquals((String)"Y", (String)BooleanUtils.toString((Boolean)Boolean.TRUE, (String)"Y", (String)"N", (String)"U"));
        BooleanUtilsTest.assertEquals((String)"N", (String)BooleanUtils.toString((Boolean)Boolean.FALSE, (String)"Y", (String)"N", (String)"U"));
    }

    public void test_toStringTrueFalse_boolean() {
        BooleanUtilsTest.assertEquals((String)"true", (String)BooleanUtils.toStringTrueFalse((boolean)true));
        BooleanUtilsTest.assertEquals((String)"false", (String)BooleanUtils.toStringTrueFalse((boolean)false));
    }

    public void test_toStringOnOff_boolean() {
        BooleanUtilsTest.assertEquals((String)"on", (String)BooleanUtils.toStringOnOff((boolean)true));
        BooleanUtilsTest.assertEquals((String)"off", (String)BooleanUtils.toStringOnOff((boolean)false));
    }

    public void test_toStringYesNo_boolean() {
        BooleanUtilsTest.assertEquals((String)"yes", (String)BooleanUtils.toStringYesNo((boolean)true));
        BooleanUtilsTest.assertEquals((String)"no", (String)BooleanUtils.toStringYesNo((boolean)false));
    }

    public void test_toString_boolean_String_String_String() {
        BooleanUtilsTest.assertEquals((String)"Y", (String)BooleanUtils.toString((boolean)true, (String)"Y", (String)"N"));
        BooleanUtilsTest.assertEquals((String)"N", (String)BooleanUtils.toString((boolean)false, (String)"Y", (String)"N"));
    }

    public void testXor_primitive_nullInput() {
        boolean[] b = null;
        try {
            BooleanUtils.xor(b);
            BooleanUtilsTest.fail((String)"Exception was not thrown for null input.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testXor_primitive_emptyInput() {
        try {
            BooleanUtils.xor((boolean[])new boolean[0]);
            BooleanUtilsTest.fail((String)"Exception was not thrown for empty input.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testXor_primitive_validInput_2items() {
        BooleanUtilsTest.assertTrue((String)"True result for (true, true)", (!BooleanUtils.xor((boolean[])new boolean[]{true, true}) ? 1 : 0) != 0);
        BooleanUtilsTest.assertTrue((String)"True result for (false, false)", (!BooleanUtils.xor((boolean[])new boolean[]{false, false}) ? 1 : 0) != 0);
        BooleanUtilsTest.assertTrue((String)"False result for (true, false)", (boolean)BooleanUtils.xor((boolean[])new boolean[]{true, false}));
        BooleanUtilsTest.assertTrue((String)"False result for (false, true)", (boolean)BooleanUtils.xor((boolean[])new boolean[]{false, true}));
    }

    public void testXor_primitive_validInput_3items() {
        BooleanUtilsTest.assertTrue((String)"False result for (false, false, true)", (boolean)BooleanUtils.xor((boolean[])new boolean[]{false, false, true}));
        BooleanUtilsTest.assertTrue((String)"False result for (false, true, false)", (boolean)BooleanUtils.xor((boolean[])new boolean[]{false, true, false}));
        BooleanUtilsTest.assertTrue((String)"False result for (true, false, false)", (boolean)BooleanUtils.xor((boolean[])new boolean[]{true, false, false}));
        BooleanUtilsTest.assertTrue((String)"True result for (true, true, true)", (!BooleanUtils.xor((boolean[])new boolean[]{true, true, true}) ? 1 : 0) != 0);
        BooleanUtilsTest.assertTrue((String)"True result for (false, false)", (!BooleanUtils.xor((boolean[])new boolean[]{false, false, false}) ? 1 : 0) != 0);
        BooleanUtilsTest.assertTrue((String)"True result for (true, true, false)", (!BooleanUtils.xor((boolean[])new boolean[]{true, true, false}) ? 1 : 0) != 0);
        BooleanUtilsTest.assertTrue((String)"True result for (true, false, true)", (!BooleanUtils.xor((boolean[])new boolean[]{true, false, true}) ? 1 : 0) != 0);
        BooleanUtilsTest.assertTrue((String)"False result for (false, true, true)", (!BooleanUtils.xor((boolean[])new boolean[]{false, true, true}) ? 1 : 0) != 0);
    }

    public void testXor_object_nullInput() {
        Boolean[] b = null;
        try {
            BooleanUtils.xor(b);
            BooleanUtilsTest.fail((String)"Exception was not thrown for null input.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testXor_object_emptyInput() {
        try {
            BooleanUtils.xor((Boolean[])new Boolean[0]);
            BooleanUtilsTest.fail((String)"Exception was not thrown for empty input.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testXor_object_nullElementInput() {
        try {
            BooleanUtils.xor((Boolean[])new Boolean[]{null});
            BooleanUtilsTest.fail((String)"Exception was not thrown for null element input.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testXor_object_validInput_2items() {
        BooleanUtilsTest.assertTrue((String)"True result for (true, true)", (BooleanUtils.xor((Boolean[])new Boolean[]{Boolean.TRUE, Boolean.TRUE}) == false ? 1 : 0) != 0);
        BooleanUtilsTest.assertTrue((String)"True result for (false, false)", (BooleanUtils.xor((Boolean[])new Boolean[]{Boolean.FALSE, Boolean.FALSE}) == false ? 1 : 0) != 0);
        BooleanUtilsTest.assertTrue((String)"False result for (true, false)", (boolean)BooleanUtils.xor((Boolean[])new Boolean[]{Boolean.TRUE, Boolean.FALSE}));
        BooleanUtilsTest.assertTrue((String)"False result for (false, true)", (boolean)BooleanUtils.xor((Boolean[])new Boolean[]{Boolean.FALSE, Boolean.TRUE}));
    }

    public void testXor_object_validInput_3items() {
        BooleanUtilsTest.assertTrue((String)"False result for (false, false, true)", (boolean)BooleanUtils.xor((Boolean[])new Boolean[]{Boolean.FALSE, Boolean.FALSE, Boolean.TRUE}));
        BooleanUtilsTest.assertTrue((String)"False result for (false, true, false)", (boolean)BooleanUtils.xor((Boolean[])new Boolean[]{Boolean.FALSE, Boolean.TRUE, Boolean.FALSE}));
        BooleanUtilsTest.assertTrue((String)"False result for (true, false, false)", (boolean)BooleanUtils.xor((Boolean[])new Boolean[]{Boolean.TRUE, Boolean.FALSE, Boolean.FALSE}));
        BooleanUtilsTest.assertTrue((String)"True result for (true, true, true)", (BooleanUtils.xor((Boolean[])new Boolean[]{Boolean.TRUE, Boolean.TRUE, Boolean.TRUE}) == false ? 1 : 0) != 0);
        BooleanUtilsTest.assertTrue((String)"True result for (false, false)", (BooleanUtils.xor((Boolean[])new Boolean[]{Boolean.FALSE, Boolean.FALSE, Boolean.FALSE}) == false ? 1 : 0) != 0);
        BooleanUtilsTest.assertTrue((String)"True result for (true, true, false)", (BooleanUtils.xor((Boolean[])new Boolean[]{Boolean.TRUE, Boolean.TRUE, Boolean.FALSE}) == false ? 1 : 0) != 0);
        BooleanUtilsTest.assertTrue((String)"True result for (true, false, true)", (BooleanUtils.xor((Boolean[])new Boolean[]{Boolean.TRUE, Boolean.FALSE, Boolean.TRUE}) == false ? 1 : 0) != 0);
        BooleanUtilsTest.assertTrue((String)"False result for (false, true, true)", (BooleanUtils.xor((Boolean[])new Boolean[]{Boolean.FALSE, Boolean.TRUE, Boolean.TRUE}) == false ? 1 : 0) != 0);
    }
}

