/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import junit.framework.TestCase;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.CharUtils;

public class CharUtilsTest
extends TestCase {
    private static final Character CHARACTER_A = new Character('A');
    private static final Character CHARACTER_B = new Character('B');
    private static final char CHAR_COPY = '\u00a9';

    public CharUtilsTest(String name) {
        super(name);
    }

    public void testConstructor() {
        CharUtilsTest.assertNotNull((Object)new CharUtils());
        Constructor<?>[] cons = CharUtils.class.getDeclaredConstructors();
        CharUtilsTest.assertEquals((int)1, (int)cons.length);
        CharUtilsTest.assertEquals((boolean)true, (boolean)Modifier.isPublic(cons[0].getModifiers()));
        CharUtilsTest.assertEquals((boolean)true, (boolean)Modifier.isPublic(BooleanUtils.class.getModifiers()));
        CharUtilsTest.assertEquals((boolean)false, (boolean)Modifier.isFinal(BooleanUtils.class.getModifiers()));
    }

    public void testToCharacterObject_char() {
        Character ch2;
        Character ch;
        int i;
        CharUtilsTest.assertEquals((Object)new Character('a'), (Object)CharUtils.toCharacterObject((char)'a'));
        CharUtilsTest.assertSame((Object)CharUtils.toCharacterObject((char)'a'), (Object)CharUtils.toCharacterObject((char)'a'));
        for (i = 0; i < 128; ++i) {
            ch = CharUtils.toCharacterObject((char)((char)i));
            ch2 = CharUtils.toCharacterObject((char)((char)i));
            CharUtilsTest.assertSame((Object)ch, (Object)ch2);
            CharUtilsTest.assertEquals((int)i, (int)ch.charValue());
        }
        for (i = 128; i < 196; ++i) {
            ch = CharUtils.toCharacterObject((char)((char)i));
            ch2 = CharUtils.toCharacterObject((char)((char)i));
            CharUtilsTest.assertEquals((Object)ch, (Object)ch2);
            CharUtilsTest.assertTrue((ch != ch2 ? 1 : 0) != 0);
            CharUtilsTest.assertEquals((int)i, (int)ch.charValue());
            CharUtilsTest.assertEquals((int)i, (int)ch2.charValue());
        }
    }

    public void testToCharacterObject_String() {
        CharUtilsTest.assertEquals(null, (Object)CharUtils.toCharacterObject(null));
        CharUtilsTest.assertEquals(null, (Object)CharUtils.toCharacterObject((String)""));
        CharUtilsTest.assertEquals((Object)new Character('a'), (Object)CharUtils.toCharacterObject((String)"a"));
        CharUtilsTest.assertEquals((Object)new Character('a'), (Object)CharUtils.toCharacterObject((String)"abc"));
        CharUtilsTest.assertSame((Object)CharUtils.toCharacterObject((String)"a"), (Object)CharUtils.toCharacterObject((String)"a"));
        CharUtilsTest.assertSame((Object)CharUtils.toCharacterObject((String)"a"), (Object)CharUtils.toCharacterObject((char)'a'));
    }

    public void testToChar_Character() {
        CharUtilsTest.assertEquals((char)'A', (char)CharUtils.toChar((Character)CHARACTER_A));
        CharUtilsTest.assertEquals((char)'B', (char)CharUtils.toChar((Character)CHARACTER_B));
        try {
            CharUtils.toChar((Character)null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testToChar_Character_char() {
        CharUtilsTest.assertEquals((char)'A', (char)CharUtils.toChar((Character)CHARACTER_A, (char)'X'));
        CharUtilsTest.assertEquals((char)'B', (char)CharUtils.toChar((Character)CHARACTER_B, (char)'X'));
        CharUtilsTest.assertEquals((char)'X', (char)CharUtils.toChar((Character)null, (char)'X'));
    }

    public void testToChar_String() {
        CharUtilsTest.assertEquals((char)'A', (char)CharUtils.toChar((String)"A"));
        CharUtilsTest.assertEquals((char)'B', (char)CharUtils.toChar((String)"BA"));
        try {
            CharUtils.toChar((String)null);
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            CharUtils.toChar((String)"");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testToChar_String_char() {
        CharUtilsTest.assertEquals((char)'A', (char)CharUtils.toChar((String)"A", (char)'X'));
        CharUtilsTest.assertEquals((char)'B', (char)CharUtils.toChar((String)"BA", (char)'X'));
        CharUtilsTest.assertEquals((char)'X', (char)CharUtils.toChar((String)"", (char)'X'));
        CharUtilsTest.assertEquals((char)'X', (char)CharUtils.toChar((String)null, (char)'X'));
    }

    public void testToIntValue_char() {
        CharUtilsTest.assertEquals((int)0, (int)CharUtils.toIntValue((char)'0'));
        CharUtilsTest.assertEquals((int)1, (int)CharUtils.toIntValue((char)'1'));
        CharUtilsTest.assertEquals((int)2, (int)CharUtils.toIntValue((char)'2'));
        CharUtilsTest.assertEquals((int)3, (int)CharUtils.toIntValue((char)'3'));
        CharUtilsTest.assertEquals((int)4, (int)CharUtils.toIntValue((char)'4'));
        CharUtilsTest.assertEquals((int)5, (int)CharUtils.toIntValue((char)'5'));
        CharUtilsTest.assertEquals((int)6, (int)CharUtils.toIntValue((char)'6'));
        CharUtilsTest.assertEquals((int)7, (int)CharUtils.toIntValue((char)'7'));
        CharUtilsTest.assertEquals((int)8, (int)CharUtils.toIntValue((char)'8'));
        CharUtilsTest.assertEquals((int)9, (int)CharUtils.toIntValue((char)'9'));
        try {
            CharUtils.toIntValue((char)'a');
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testToIntValue_char_int() {
        CharUtilsTest.assertEquals((int)0, (int)CharUtils.toIntValue((char)'0', (int)-1));
        CharUtilsTest.assertEquals((int)3, (int)CharUtils.toIntValue((char)'3', (int)-1));
        CharUtilsTest.assertEquals((int)-1, (int)CharUtils.toIntValue((char)'a', (int)-1));
    }

    public void testToIntValue_Character() {
        CharUtilsTest.assertEquals((int)0, (int)CharUtils.toIntValue((Character)new Character('0')));
        CharUtilsTest.assertEquals((int)3, (int)CharUtils.toIntValue((Character)new Character('3')));
        try {
            CharUtils.toIntValue(null);
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            CharUtils.toIntValue((Character)CHARACTER_A);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testToIntValue_Character_int() {
        CharUtilsTest.assertEquals((int)0, (int)CharUtils.toIntValue((Character)new Character('0'), (int)-1));
        CharUtilsTest.assertEquals((int)3, (int)CharUtils.toIntValue((Character)new Character('3'), (int)-1));
        CharUtilsTest.assertEquals((int)-1, (int)CharUtils.toIntValue((Character)new Character('A'), (int)-1));
        CharUtilsTest.assertEquals((int)-1, (int)CharUtils.toIntValue(null, (int)-1));
    }

    public void testToString_char() {
        String str2;
        String str;
        int i;
        CharUtilsTest.assertEquals((String)"a", (String)CharUtils.toString((char)'a'));
        CharUtilsTest.assertSame((Object)CharUtils.toString((char)'a'), (Object)CharUtils.toString((char)'a'));
        for (i = 0; i < 128; ++i) {
            str = CharUtils.toString((char)((char)i));
            str2 = CharUtils.toString((char)((char)i));
            CharUtilsTest.assertSame((Object)str, (Object)str2);
            CharUtilsTest.assertEquals((int)1, (int)str.length());
            CharUtilsTest.assertEquals((int)i, (int)str.charAt(0));
        }
        for (i = 128; i < 196; ++i) {
            str = CharUtils.toString((char)((char)i));
            str2 = CharUtils.toString((char)((char)i));
            CharUtilsTest.assertEquals((String)str, (String)str2);
            CharUtilsTest.assertTrue((str != str2 ? 1 : 0) != 0);
            CharUtilsTest.assertEquals((int)1, (int)str.length());
            CharUtilsTest.assertEquals((int)i, (int)str.charAt(0));
            CharUtilsTest.assertEquals((int)1, (int)str2.length());
            CharUtilsTest.assertEquals((int)i, (int)str2.charAt(0));
        }
    }

    public void testToString_Character() {
        CharUtilsTest.assertEquals(null, (String)CharUtils.toString(null));
        CharUtilsTest.assertEquals((String)"A", (String)CharUtils.toString((Character)CHARACTER_A));
        CharUtilsTest.assertSame((Object)CharUtils.toString((Character)CHARACTER_A), (Object)CharUtils.toString((Character)CHARACTER_A));
    }

    public void testToUnicodeEscaped_char() {
        CharUtilsTest.assertEquals((String)"\\u0041", (String)CharUtils.unicodeEscaped((char)'A'));
        for (int i = 0; i < 196; ++i) {
            String str = CharUtils.unicodeEscaped((char)((char)i));
            CharUtilsTest.assertEquals((int)6, (int)str.length());
            int val = Integer.parseInt(str.substring(2), 16);
            CharUtilsTest.assertEquals((int)i, (int)val);
        }
        CharUtilsTest.assertEquals((String)"\\u0999", (String)CharUtils.unicodeEscaped((char)'\u0999'));
        CharUtilsTest.assertEquals((String)"\\u1001", (String)CharUtils.unicodeEscaped((char)'\u1001'));
    }

    public void testToUnicodeEscaped_Character() {
        CharUtilsTest.assertEquals(null, (String)CharUtils.unicodeEscaped(null));
        CharUtilsTest.assertEquals((String)"\\u0041", (String)CharUtils.unicodeEscaped((Character)CHARACTER_A));
    }

    public void testIsAscii_char() {
        CharUtilsTest.assertEquals((boolean)true, (boolean)CharUtils.isAscii((char)'a'));
        CharUtilsTest.assertEquals((boolean)true, (boolean)CharUtils.isAscii((char)'A'));
        CharUtilsTest.assertEquals((boolean)true, (boolean)CharUtils.isAscii((char)'3'));
        CharUtilsTest.assertEquals((boolean)true, (boolean)CharUtils.isAscii((char)'-'));
        CharUtilsTest.assertEquals((boolean)true, (boolean)CharUtils.isAscii((char)'\n'));
        CharUtilsTest.assertEquals((boolean)false, (boolean)CharUtils.isAscii((char)'\u00a9'));
        for (int i = 0; i < 128; ++i) {
            if (i < 128) {
                CharUtilsTest.assertEquals((boolean)true, (boolean)CharUtils.isAscii((char)((char)i)));
                continue;
            }
            CharUtilsTest.assertEquals((boolean)false, (boolean)CharUtils.isAscii((char)((char)i)));
        }
    }

    public void testIsAsciiPrintable_char() {
        CharUtilsTest.assertEquals((boolean)true, (boolean)CharUtils.isAsciiPrintable((char)'a'));
        CharUtilsTest.assertEquals((boolean)true, (boolean)CharUtils.isAsciiPrintable((char)'A'));
        CharUtilsTest.assertEquals((boolean)true, (boolean)CharUtils.isAsciiPrintable((char)'3'));
        CharUtilsTest.assertEquals((boolean)true, (boolean)CharUtils.isAsciiPrintable((char)'-'));
        CharUtilsTest.assertEquals((boolean)false, (boolean)CharUtils.isAsciiPrintable((char)'\n'));
        CharUtilsTest.assertEquals((boolean)false, (boolean)CharUtils.isAscii((char)'\u00a9'));
        for (int i = 0; i < 196; ++i) {
            if (i >= 32 && i <= 126) {
                CharUtilsTest.assertEquals((boolean)true, (boolean)CharUtils.isAsciiPrintable((char)((char)i)));
                continue;
            }
            CharUtilsTest.assertEquals((boolean)false, (boolean)CharUtils.isAsciiPrintable((char)((char)i)));
        }
    }

    public void testIsAsciiControl_char() {
        CharUtilsTest.assertEquals((boolean)false, (boolean)CharUtils.isAsciiControl((char)'a'));
        CharUtilsTest.assertEquals((boolean)false, (boolean)CharUtils.isAsciiControl((char)'A'));
        CharUtilsTest.assertEquals((boolean)false, (boolean)CharUtils.isAsciiControl((char)'3'));
        CharUtilsTest.assertEquals((boolean)false, (boolean)CharUtils.isAsciiControl((char)'-'));
        CharUtilsTest.assertEquals((boolean)true, (boolean)CharUtils.isAsciiControl((char)'\n'));
        CharUtilsTest.assertEquals((boolean)false, (boolean)CharUtils.isAsciiControl((char)'\u00a9'));
        for (int i = 0; i < 196; ++i) {
            if (i < 32 || i == 127) {
                CharUtilsTest.assertEquals((boolean)true, (boolean)CharUtils.isAsciiControl((char)((char)i)));
                continue;
            }
            CharUtilsTest.assertEquals((boolean)false, (boolean)CharUtils.isAsciiControl((char)((char)i)));
        }
    }

    public void testIsAsciiAlpha_char() {
        CharUtilsTest.assertEquals((boolean)true, (boolean)CharUtils.isAsciiAlpha((char)'a'));
        CharUtilsTest.assertEquals((boolean)true, (boolean)CharUtils.isAsciiAlpha((char)'A'));
        CharUtilsTest.assertEquals((boolean)false, (boolean)CharUtils.isAsciiAlpha((char)'3'));
        CharUtilsTest.assertEquals((boolean)false, (boolean)CharUtils.isAsciiAlpha((char)'-'));
        CharUtilsTest.assertEquals((boolean)false, (boolean)CharUtils.isAsciiAlpha((char)'\n'));
        CharUtilsTest.assertEquals((boolean)false, (boolean)CharUtils.isAsciiAlpha((char)'\u00a9'));
        for (int i = 0; i < 196; ++i) {
            if (i >= 65 && i <= 90 || i >= 97 && i <= 122) {
                CharUtilsTest.assertEquals((boolean)true, (boolean)CharUtils.isAsciiAlpha((char)((char)i)));
                continue;
            }
            CharUtilsTest.assertEquals((boolean)false, (boolean)CharUtils.isAsciiAlpha((char)((char)i)));
        }
    }

    public void testIsAsciiAlphaUpper_char() {
        CharUtilsTest.assertEquals((boolean)false, (boolean)CharUtils.isAsciiAlphaUpper((char)'a'));
        CharUtilsTest.assertEquals((boolean)true, (boolean)CharUtils.isAsciiAlphaUpper((char)'A'));
        CharUtilsTest.assertEquals((boolean)false, (boolean)CharUtils.isAsciiAlphaUpper((char)'3'));
        CharUtilsTest.assertEquals((boolean)false, (boolean)CharUtils.isAsciiAlphaUpper((char)'-'));
        CharUtilsTest.assertEquals((boolean)false, (boolean)CharUtils.isAsciiAlphaUpper((char)'\n'));
        CharUtilsTest.assertEquals((boolean)false, (boolean)CharUtils.isAsciiAlphaUpper((char)'\u00a9'));
        for (int i = 0; i < 196; ++i) {
            if (i >= 65 && i <= 90) {
                CharUtilsTest.assertEquals((boolean)true, (boolean)CharUtils.isAsciiAlphaUpper((char)((char)i)));
                continue;
            }
            CharUtilsTest.assertEquals((boolean)false, (boolean)CharUtils.isAsciiAlphaUpper((char)((char)i)));
        }
    }

    public void testIsAsciiAlphaLower_char() {
        CharUtilsTest.assertEquals((boolean)true, (boolean)CharUtils.isAsciiAlphaLower((char)'a'));
        CharUtilsTest.assertEquals((boolean)false, (boolean)CharUtils.isAsciiAlphaLower((char)'A'));
        CharUtilsTest.assertEquals((boolean)false, (boolean)CharUtils.isAsciiAlphaLower((char)'3'));
        CharUtilsTest.assertEquals((boolean)false, (boolean)CharUtils.isAsciiAlphaLower((char)'-'));
        CharUtilsTest.assertEquals((boolean)false, (boolean)CharUtils.isAsciiAlphaLower((char)'\n'));
        CharUtilsTest.assertEquals((boolean)false, (boolean)CharUtils.isAsciiAlphaLower((char)'\u00a9'));
        for (int i = 0; i < 196; ++i) {
            if (i >= 97 && i <= 122) {
                CharUtilsTest.assertEquals((boolean)true, (boolean)CharUtils.isAsciiAlphaLower((char)((char)i)));
                continue;
            }
            CharUtilsTest.assertEquals((boolean)false, (boolean)CharUtils.isAsciiAlphaLower((char)((char)i)));
        }
    }

    public void testIsAsciiNumeric_char() {
        CharUtilsTest.assertEquals((boolean)false, (boolean)CharUtils.isAsciiNumeric((char)'a'));
        CharUtilsTest.assertEquals((boolean)false, (boolean)CharUtils.isAsciiNumeric((char)'A'));
        CharUtilsTest.assertEquals((boolean)true, (boolean)CharUtils.isAsciiNumeric((char)'3'));
        CharUtilsTest.assertEquals((boolean)false, (boolean)CharUtils.isAsciiNumeric((char)'-'));
        CharUtilsTest.assertEquals((boolean)false, (boolean)CharUtils.isAsciiNumeric((char)'\n'));
        CharUtilsTest.assertEquals((boolean)false, (boolean)CharUtils.isAsciiNumeric((char)'\u00a9'));
        for (int i = 0; i < 196; ++i) {
            if (i >= 48 && i <= 57) {
                CharUtilsTest.assertEquals((boolean)true, (boolean)CharUtils.isAsciiNumeric((char)((char)i)));
                continue;
            }
            CharUtilsTest.assertEquals((boolean)false, (boolean)CharUtils.isAsciiNumeric((char)((char)i)));
        }
    }

    public void testIsAsciiAlphanumeric_char() {
        CharUtilsTest.assertEquals((boolean)true, (boolean)CharUtils.isAsciiAlphanumeric((char)'a'));
        CharUtilsTest.assertEquals((boolean)true, (boolean)CharUtils.isAsciiAlphanumeric((char)'A'));
        CharUtilsTest.assertEquals((boolean)true, (boolean)CharUtils.isAsciiAlphanumeric((char)'3'));
        CharUtilsTest.assertEquals((boolean)false, (boolean)CharUtils.isAsciiAlphanumeric((char)'-'));
        CharUtilsTest.assertEquals((boolean)false, (boolean)CharUtils.isAsciiAlphanumeric((char)'\n'));
        CharUtilsTest.assertEquals((boolean)false, (boolean)CharUtils.isAsciiAlphanumeric((char)'\u00a9'));
        for (int i = 0; i < 196; ++i) {
            if (i >= 65 && i <= 90 || i >= 97 && i <= 122 || i >= 48 && i <= 57) {
                CharUtilsTest.assertEquals((boolean)true, (boolean)CharUtils.isAsciiAlphanumeric((char)((char)i)));
                continue;
            }
            CharUtilsTest.assertEquals((boolean)false, (boolean)CharUtils.isAsciiAlphanumeric((char)((char)i)));
        }
    }
}

