/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.Traffic;

public class EnumUtilsTest
extends TestCase {
    public void testConstructable() {
        new EnumUtils();
    }

    public void test_getEnumMap() {
        Map test = EnumUtils.getEnumMap(Traffic.class);
        EnumUtilsTest.assertEquals((String)"getEnumMap not created correctly", (String)"{RED=RED, AMBER=AMBER, GREEN=GREEN}", (String)test.toString());
        EnumUtilsTest.assertEquals((int)3, (int)test.size());
        EnumUtilsTest.assertEquals((boolean)true, (boolean)test.containsKey("RED"));
        EnumUtilsTest.assertEquals((Object)((Object)Traffic.RED), test.get("RED"));
        EnumUtilsTest.assertEquals((boolean)true, (boolean)test.containsKey("AMBER"));
        EnumUtilsTest.assertEquals((Object)((Object)Traffic.AMBER), test.get("AMBER"));
        EnumUtilsTest.assertEquals((boolean)true, (boolean)test.containsKey("GREEN"));
        EnumUtilsTest.assertEquals((Object)((Object)Traffic.GREEN), test.get("GREEN"));
        EnumUtilsTest.assertEquals((boolean)false, (boolean)test.containsKey("PURPLE"));
    }

    public void test_getEnumList() {
        List test = EnumUtils.getEnumList(Traffic.class);
        EnumUtilsTest.assertEquals((int)3, (int)test.size());
        EnumUtilsTest.assertEquals((Object)((Object)Traffic.RED), test.get(0));
        EnumUtilsTest.assertEquals((Object)((Object)Traffic.AMBER), test.get(1));
        EnumUtilsTest.assertEquals((Object)((Object)Traffic.GREEN), test.get(2));
    }

    public void test_isEnum() {
        EnumUtilsTest.assertEquals((boolean)true, (boolean)EnumUtils.isValidEnum(Traffic.class, (String)"RED"));
        EnumUtilsTest.assertEquals((boolean)true, (boolean)EnumUtils.isValidEnum(Traffic.class, (String)"AMBER"));
        EnumUtilsTest.assertEquals((boolean)true, (boolean)EnumUtils.isValidEnum(Traffic.class, (String)"GREEN"));
        EnumUtilsTest.assertEquals((boolean)false, (boolean)EnumUtils.isValidEnum(Traffic.class, (String)"PURPLE"));
        EnumUtilsTest.assertEquals((boolean)false, (boolean)EnumUtils.isValidEnum(Traffic.class, null));
    }

    public void test_isEnum_nullClass() {
        try {
            EnumUtils.isValidEnum((Class)null, (String)"PURPLE");
            EnumUtilsTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void test_getEnum() {
        EnumUtilsTest.assertEquals((Object)((Object)Traffic.RED), (Object)EnumUtils.getEnum(Traffic.class, (String)"RED"));
        EnumUtilsTest.assertEquals((Object)((Object)Traffic.AMBER), (Object)EnumUtils.getEnum(Traffic.class, (String)"AMBER"));
        EnumUtilsTest.assertEquals((Object)((Object)Traffic.GREEN), (Object)EnumUtils.getEnum(Traffic.class, (String)"GREEN"));
        EnumUtilsTest.assertEquals(null, (Object)EnumUtils.getEnum(Traffic.class, (String)"PURPLE"));
        EnumUtilsTest.assertEquals(null, (Object)EnumUtils.getEnum(Traffic.class, null));
    }

    public void test_getEnum_nullClass() {
        try {
            EnumUtils.getEnum((Class)null, (String)"PURPLE");
            EnumUtilsTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

