/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import junit.framework.TestCase;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.exception.CloneFailedException;
import org.apache.commons.lang3.mutable.MutableObject;

public class ObjectUtilsTest
extends TestCase {
    private static final String FOO = "foo";
    private static final String BAR = "bar";

    public ObjectUtilsTest(String name) {
        super(name);
    }

    public void testConstructor() {
        ObjectUtilsTest.assertNotNull((Object)new ObjectUtils());
        Constructor<?>[] cons = ObjectUtils.class.getDeclaredConstructors();
        ObjectUtilsTest.assertEquals((int)1, (int)cons.length);
        ObjectUtilsTest.assertEquals((boolean)true, (boolean)Modifier.isPublic(cons[0].getModifiers()));
        ObjectUtilsTest.assertEquals((boolean)true, (boolean)Modifier.isPublic(ObjectUtils.class.getModifiers()));
        ObjectUtilsTest.assertEquals((boolean)false, (boolean)Modifier.isFinal(ObjectUtils.class.getModifiers()));
    }

    public void testIsNull() {
        String o = FOO;
        String dflt = BAR;
        ObjectUtilsTest.assertSame((String)"dflt was not returned when o was null", (Object)dflt, (Object)ObjectUtils.defaultIfNull(null, (Object)dflt));
        ObjectUtilsTest.assertSame((String)"dflt was returned when o was not null", (Object)o, (Object)ObjectUtils.defaultIfNull((Object)o, (Object)dflt));
    }

    public void testFirstNonNull() {
        ObjectUtilsTest.assertEquals(null, (Object)ObjectUtils.firstNonNull((Object[])new Object[]{null, null}));
        ObjectUtilsTest.assertEquals((String)"", (String)((String)ObjectUtils.firstNonNull((Object[])new String[]{null, ""})));
        String firstNonNullGenerics = (String)ObjectUtils.firstNonNull((Object[])new String[]{null, null, "123", "456"});
        ObjectUtilsTest.assertEquals((String)"123", (String)firstNonNullGenerics);
        ObjectUtilsTest.assertEquals((String)"123", (String)((String)ObjectUtils.firstNonNull((Object[])new String[]{"123", null, "456", null})));
        ObjectUtilsTest.assertEquals(null, (Object)ObjectUtils.firstNonNull((Object[])new Object[0]));
        ObjectUtilsTest.assertSame((Object)Boolean.TRUE, (Object)ObjectUtils.firstNonNull((Object[])new Boolean[]{Boolean.TRUE}));
        ObjectUtilsTest.assertNull((Object)ObjectUtils.firstNonNull((Object[])new Object[0]));
        ObjectUtilsTest.assertNull((Object)ObjectUtils.firstNonNull((Object[])new Object[]{null, null}));
        ObjectUtilsTest.assertNull((Object)ObjectUtils.firstNonNull((Object[])new Object[]{null}));
        ObjectUtilsTest.assertNull((Object)ObjectUtils.firstNonNull((Object[])null));
    }

    public void testEquals() {
        ObjectUtilsTest.assertTrue((String)"ObjectUtils.equals(null, null) returned false", (boolean)ObjectUtils.equals(null, null));
        ObjectUtilsTest.assertTrue((String)"ObjectUtils.equals(\"foo\", null) returned true", (!ObjectUtils.equals((Object)FOO, null) ? 1 : 0) != 0);
        ObjectUtilsTest.assertTrue((String)"ObjectUtils.equals(null, \"bar\") returned true", (!ObjectUtils.equals(null, (Object)BAR) ? 1 : 0) != 0);
        ObjectUtilsTest.assertTrue((String)"ObjectUtils.equals(\"foo\", \"bar\") returned true", (!ObjectUtils.equals((Object)FOO, (Object)BAR) ? 1 : 0) != 0);
        ObjectUtilsTest.assertTrue((String)"ObjectUtils.equals(\"foo\", \"foo\") returned false", (boolean)ObjectUtils.equals((Object)FOO, (Object)FOO));
    }

    public void testNotEqual() {
        ObjectUtilsTest.assertFalse((String)"ObjectUtils.notEqual(null, null) returned false", (boolean)ObjectUtils.notEqual(null, null));
        ObjectUtilsTest.assertTrue((String)"ObjectUtils.notEqual(\"foo\", null) returned true", (boolean)ObjectUtils.notEqual((Object)FOO, null));
        ObjectUtilsTest.assertTrue((String)"ObjectUtils.notEqual(null, \"bar\") returned true", (boolean)ObjectUtils.notEqual(null, (Object)BAR));
        ObjectUtilsTest.assertTrue((String)"ObjectUtils.notEqual(\"foo\", \"bar\") returned true", (boolean)ObjectUtils.notEqual((Object)FOO, (Object)BAR));
        ObjectUtilsTest.assertFalse((String)"ObjectUtils.notEqual(\"foo\", \"foo\") returned false", (boolean)ObjectUtils.notEqual((Object)FOO, (Object)FOO));
    }

    public void testHashCode() {
        ObjectUtilsTest.assertEquals((int)0, (int)ObjectUtils.hashCode(null));
        ObjectUtilsTest.assertEquals((int)"a".hashCode(), (int)ObjectUtils.hashCode((Object)"a"));
    }

    public void testHashCodeMulti_multiple_emptyArray() {
        Object[] array = new Object[]{};
        ObjectUtilsTest.assertEquals((int)1, (int)ObjectUtils.hashCodeMulti((Object[])array));
    }

    public void testHashCodeMulti_multiple_nullArray() {
        Object[] array = null;
        ObjectUtilsTest.assertEquals((int)1, (int)ObjectUtils.hashCodeMulti(array));
    }

    public void testHashCodeMulti_multiple_likeList() {
        ArrayList<Object> list0 = new ArrayList<Object>(Arrays.asList(new Object[0]));
        ObjectUtilsTest.assertEquals((int)((Object)list0).hashCode(), (int)ObjectUtils.hashCodeMulti((Object[])new Object[0]));
        ArrayList<String> list1 = new ArrayList<String>(Arrays.asList("a"));
        ObjectUtilsTest.assertEquals((int)((Object)list1).hashCode(), (int)ObjectUtils.hashCodeMulti((Object[])new Object[]{"a"}));
        ArrayList<String> list2 = new ArrayList<String>(Arrays.asList("a", "b"));
        ObjectUtilsTest.assertEquals((int)((Object)list2).hashCode(), (int)ObjectUtils.hashCodeMulti((Object[])new Object[]{"a", "b"}));
        ArrayList<String> list3 = new ArrayList<String>(Arrays.asList("a", "b", "c"));
        ObjectUtilsTest.assertEquals((int)((Object)list3).hashCode(), (int)ObjectUtils.hashCodeMulti((Object[])new Object[]{"a", "b", "c"}));
    }

    public void testIdentityToString() {
        ObjectUtilsTest.assertEquals(null, (String)ObjectUtils.identityToString(null));
        ObjectUtilsTest.assertEquals((String)("java.lang.String@" + Integer.toHexString(System.identityHashCode(FOO))), (String)ObjectUtils.identityToString((Object)FOO));
        Integer i = new Integer(90);
        String expected = "java.lang.Integer@" + Integer.toHexString(System.identityHashCode(i));
        ObjectUtilsTest.assertEquals((String)expected, (String)ObjectUtils.identityToString((Object)i));
        StringBuffer buffer = new StringBuffer();
        ObjectUtils.identityToString((StringBuffer)buffer, (Object)i);
        ObjectUtilsTest.assertEquals((String)expected, (String)buffer.toString());
        try {
            ObjectUtils.identityToString(null, (Object)"tmp");
            ObjectUtilsTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        try {
            ObjectUtils.identityToString((StringBuffer)new StringBuffer(), null);
            ObjectUtilsTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
    }

    public void testToString_Object() {
        ObjectUtilsTest.assertEquals((String)"", (String)ObjectUtils.toString((Object)null));
        ObjectUtilsTest.assertEquals((String)Boolean.TRUE.toString(), (String)ObjectUtils.toString((Object)Boolean.TRUE));
    }

    public void testToString_ObjectString() {
        ObjectUtilsTest.assertEquals((String)BAR, (String)ObjectUtils.toString((Object)null, (String)BAR));
        ObjectUtilsTest.assertEquals((String)Boolean.TRUE.toString(), (String)ObjectUtils.toString((Object)Boolean.TRUE, (String)BAR));
    }

    public void testNull() {
        ObjectUtilsTest.assertNotNull((Object)ObjectUtils.NULL);
        ObjectUtilsTest.assertTrue((boolean)(ObjectUtils.NULL instanceof ObjectUtils.Null));
        ObjectUtilsTest.assertSame((Object)ObjectUtils.NULL, (Object)SerializationUtils.clone((Serializable)ObjectUtils.NULL));
    }

    public void testMax() {
        Calendar calendar = Calendar.getInstance();
        Date nonNullComparable1 = calendar.getTime();
        Date nonNullComparable2 = calendar.getTime();
        Comparable[] nullAray = null;
        calendar.set(1, calendar.get(1) - 1);
        Date minComparable = calendar.getTime();
        ObjectUtilsTest.assertNotSame((Object)nonNullComparable1, (Object)nonNullComparable2);
        ObjectUtilsTest.assertNull((Object)ObjectUtils.max((Comparable[])new String[]{null}));
        ObjectUtilsTest.assertNull((Object)ObjectUtils.max(nullAray));
        ObjectUtilsTest.assertSame((Object)nonNullComparable1, (Object)ObjectUtils.max((Comparable[])new Date[]{null, nonNullComparable1}));
        ObjectUtilsTest.assertSame((Object)nonNullComparable1, (Object)ObjectUtils.max((Comparable[])new Date[]{nonNullComparable1, null}));
        ObjectUtilsTest.assertSame((Object)nonNullComparable1, (Object)ObjectUtils.max((Comparable[])new Date[]{null, nonNullComparable1, null}));
        ObjectUtilsTest.assertSame((Object)nonNullComparable1, (Object)ObjectUtils.max((Comparable[])new Date[]{nonNullComparable1, nonNullComparable2}));
        ObjectUtilsTest.assertSame((Object)nonNullComparable2, (Object)ObjectUtils.max((Comparable[])new Date[]{nonNullComparable2, nonNullComparable1}));
        ObjectUtilsTest.assertSame((Object)nonNullComparable1, (Object)ObjectUtils.max((Comparable[])new Date[]{nonNullComparable1, minComparable}));
        ObjectUtilsTest.assertSame((Object)nonNullComparable1, (Object)ObjectUtils.max((Comparable[])new Date[]{minComparable, nonNullComparable1}));
        ObjectUtilsTest.assertSame((Object)nonNullComparable1, (Object)ObjectUtils.max((Comparable[])new Date[]{null, minComparable, null, nonNullComparable1}));
        ObjectUtilsTest.assertNull((Object)ObjectUtils.max((Comparable[])new String[]{null, null}));
    }

    public void testMin() {
        Calendar calendar = Calendar.getInstance();
        Date nonNullComparable1 = calendar.getTime();
        Date nonNullComparable2 = calendar.getTime();
        Comparable[] nullAray = null;
        calendar.set(1, calendar.get(1) - 1);
        Date minComparable = calendar.getTime();
        ObjectUtilsTest.assertNotSame((Object)nonNullComparable1, (Object)nonNullComparable2);
        ObjectUtilsTest.assertNull((Object)ObjectUtils.min((Comparable[])new String[]{null}));
        ObjectUtilsTest.assertNull((Object)ObjectUtils.min(nullAray));
        ObjectUtilsTest.assertSame((Object)nonNullComparable1, (Object)ObjectUtils.min((Comparable[])new Date[]{null, nonNullComparable1}));
        ObjectUtilsTest.assertSame((Object)nonNullComparable1, (Object)ObjectUtils.min((Comparable[])new Date[]{nonNullComparable1, null}));
        ObjectUtilsTest.assertSame((Object)nonNullComparable1, (Object)ObjectUtils.min((Comparable[])new Date[]{null, nonNullComparable1, null}));
        ObjectUtilsTest.assertSame((Object)nonNullComparable1, (Object)ObjectUtils.min((Comparable[])new Date[]{nonNullComparable1, nonNullComparable2}));
        ObjectUtilsTest.assertSame((Object)nonNullComparable2, (Object)ObjectUtils.min((Comparable[])new Date[]{nonNullComparable2, nonNullComparable1}));
        ObjectUtilsTest.assertSame((Object)minComparable, (Object)ObjectUtils.min((Comparable[])new Date[]{nonNullComparable1, minComparable}));
        ObjectUtilsTest.assertSame((Object)minComparable, (Object)ObjectUtils.min((Comparable[])new Date[]{minComparable, nonNullComparable1}));
        ObjectUtilsTest.assertSame((Object)minComparable, (Object)ObjectUtils.min((Comparable[])new Date[]{null, nonNullComparable1, null, minComparable}));
        ObjectUtilsTest.assertNull((Object)ObjectUtils.min((Comparable[])new String[]{null, null}));
    }

    public void testCompare() {
        Integer one = 1;
        Integer two = 2;
        Comparable nullValue = null;
        ObjectUtilsTest.assertEquals((String)"Null Null false", (int)0, (int)ObjectUtils.compare(nullValue, nullValue));
        ObjectUtilsTest.assertEquals((String)"Null Null true", (int)0, (int)ObjectUtils.compare(nullValue, nullValue, (boolean)true));
        ObjectUtilsTest.assertEquals((String)"Null one false", (int)-1, (int)ObjectUtils.compare(nullValue, (Comparable)one));
        ObjectUtilsTest.assertEquals((String)"Null one true", (int)1, (int)ObjectUtils.compare(nullValue, (Comparable)one, (boolean)true));
        ObjectUtilsTest.assertEquals((String)"one Null false", (int)1, (int)ObjectUtils.compare((Comparable)one, nullValue));
        ObjectUtilsTest.assertEquals((String)"one Null true", (int)-1, (int)ObjectUtils.compare((Comparable)one, nullValue, (boolean)true));
        ObjectUtilsTest.assertEquals((String)"one two false", (int)-1, (int)ObjectUtils.compare((Comparable)one, (Comparable)two));
        ObjectUtilsTest.assertEquals((String)"one two true", (int)-1, (int)ObjectUtils.compare((Comparable)one, (Comparable)two, (boolean)true));
    }

    public void testCloneOfCloneable() {
        CloneableString string = new CloneableString("apache");
        CloneableString stringClone = (CloneableString)ObjectUtils.clone((Object)string);
        ObjectUtilsTest.assertEquals((String)"apache", (String)((String)stringClone.getValue()));
    }

    public void testCloneOfNotCloneable() {
        String string = new String("apache");
        ObjectUtilsTest.assertNull((Object)ObjectUtils.clone((Object)string));
    }

    public void testCloneOfUncloneable() {
        UncloneableString string = new UncloneableString("apache");
        try {
            ObjectUtils.clone((Object)string);
            ObjectUtilsTest.fail((String)("Thrown " + CloneFailedException.class.getName() + " expected"));
        }
        catch (CloneFailedException e) {
            ObjectUtilsTest.assertEquals(NoSuchMethodException.class, e.getCause().getClass());
        }
    }

    public void testCloneOfStringArray() {
        ObjectUtilsTest.assertTrue((boolean)Arrays.deepEquals(new String[]{"string"}, (Object[])ObjectUtils.clone((Object)new String[]{"string"})));
    }

    public void testCloneOfPrimitiveArray() {
        ObjectUtilsTest.assertTrue((boolean)Arrays.equals(new int[]{1}, (int[])ObjectUtils.clone((Object)new int[]{1})));
    }

    public void testPossibleCloneOfCloneable() {
        CloneableString string = new CloneableString("apache");
        CloneableString stringClone = (CloneableString)ObjectUtils.cloneIfPossible((Object)string);
        ObjectUtilsTest.assertEquals((String)"apache", (String)((String)stringClone.getValue()));
    }

    public void testPossibleCloneOfNotCloneable() {
        String string = new String("apache");
        ObjectUtilsTest.assertSame((Object)string, (Object)ObjectUtils.cloneIfPossible((Object)string));
    }

    public void testPossibleCloneOfUncloneable() {
        UncloneableString string = new UncloneableString("apache");
        try {
            ObjectUtils.cloneIfPossible((Object)string);
            ObjectUtilsTest.fail((String)("Thrown " + CloneFailedException.class.getName() + " expected"));
        }
        catch (CloneFailedException e) {
            ObjectUtilsTest.assertEquals(NoSuchMethodException.class, e.getCause().getClass());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class UncloneableString
    extends MutableObject<String>
    implements Cloneable {
        private static final long serialVersionUID = 1L;

        UncloneableString(String s) {
            super((Object)s);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class CloneableString
    extends MutableObject<String>
    implements Cloneable {
        private static final long serialVersionUID = 1L;

        CloneableString(String s) {
            super((Object)s);
        }

        public CloneableString clone() throws CloneNotSupportedException {
            return (CloneableString)super.clone();
        }
    }
}

