/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.Comparator;
import junit.framework.TestCase;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.SerializationUtils;

public class RangeTest
extends TestCase {
    private Range<Byte> byteRange;
    private Range<Byte> byteRange2;
    private Range<Byte> byteRange3;
    private Range<Integer> intRange;
    private Range<Long> longRange;
    private Range<Float> floatRange;
    private Range<Double> doubleRange;

    public void setUp() {
        this.byteRange = Range.between((Comparable)Byte.valueOf((byte)0), (Comparable)Byte.valueOf((byte)5));
        this.byteRange2 = Range.between((Comparable)Byte.valueOf((byte)0), (Comparable)Byte.valueOf((byte)5));
        this.byteRange3 = Range.between((Comparable)Byte.valueOf((byte)0), (Comparable)Byte.valueOf((byte)10));
        this.intRange = Range.between((Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(20));
        this.longRange = Range.between((Comparable)Long.valueOf(10L), (Comparable)Long.valueOf(20L));
        this.floatRange = Range.between((Comparable)Float.valueOf(10.0f), (Comparable)Float.valueOf(20.0f));
        this.doubleRange = Range.between((Comparable)Double.valueOf(10.0), (Comparable)Double.valueOf(20.0));
    }

    public void testComparableConstructors() {
        Comparable c = new Comparable(){

            public int compareTo(Object other) {
                return 1;
            }
        };
        Range r1 = Range.is((Comparable)c);
        Range r2 = Range.between((Comparable)c, (Comparable)c);
        RangeTest.assertEquals((boolean)true, (boolean)r1.isNaturalOrdering());
        RangeTest.assertEquals((boolean)true, (boolean)r2.isNaturalOrdering());
    }

    public void testIsWithCompare() {
        Comparator<Integer> c = new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return 0;
            }
        };
        Range ri = Range.is((Comparable)Integer.valueOf(10));
        RangeTest.assertFalse((String)"should not contain null", (boolean)ri.contains(null));
        RangeTest.assertTrue((String)"should contain 10", (boolean)ri.contains((Object)10));
        RangeTest.assertFalse((String)"should not contain 11", (boolean)ri.contains((Object)11));
        ri = Range.is((Object)10, (Comparator)c);
        RangeTest.assertFalse((String)"should not contain null", (boolean)ri.contains(null));
        RangeTest.assertTrue((String)"should contain 10", (boolean)ri.contains((Object)10));
        RangeTest.assertTrue((String)"should contain 11", (boolean)ri.contains((Object)11));
    }

    public void testBetweenWithCompare() {
        Comparator<Integer> c = new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return 0;
            }
        };
        Range rb = Range.between((Comparable)Integer.valueOf(-10), (Comparable)Integer.valueOf(20));
        RangeTest.assertFalse((String)"should not contain null", (boolean)rb.contains(null));
        RangeTest.assertTrue((String)"should contain 10", (boolean)rb.contains((Object)10));
        RangeTest.assertTrue((String)"should contain -10", (boolean)rb.contains((Object)-10));
        RangeTest.assertFalse((String)"should not contain 21", (boolean)rb.contains((Object)21));
        RangeTest.assertFalse((String)"should not contain -11", (boolean)rb.contains((Object)-11));
        rb = Range.between((Object)-10, (Object)20, (Comparator)c);
        RangeTest.assertFalse((String)"should not contain null", (boolean)rb.contains(null));
        RangeTest.assertTrue((String)"should contain 10", (boolean)rb.contains((Object)10));
        RangeTest.assertTrue((String)"should contain -10", (boolean)rb.contains((Object)-10));
        RangeTest.assertTrue((String)"should contain 21", (boolean)rb.contains((Object)21));
        RangeTest.assertTrue((String)"should contain -11", (boolean)rb.contains((Object)-11));
    }

    public void testRangeOfChars() {
        Range chars = Range.between((Comparable)Character.valueOf('a'), (Comparable)Character.valueOf('z'));
        RangeTest.assertTrue((boolean)chars.contains((Object)Character.valueOf('b')));
        RangeTest.assertFalse((boolean)chars.contains((Object)Character.valueOf('B')));
    }

    public void testEqualsObject() {
        RangeTest.assertEquals(this.byteRange, this.byteRange);
        RangeTest.assertEquals(this.byteRange, this.byteRange2);
        RangeTest.assertEquals(this.byteRange2, this.byteRange2);
        RangeTest.assertTrue((boolean)this.byteRange.equals(this.byteRange));
        RangeTest.assertTrue((boolean)this.byteRange2.equals(this.byteRange2));
        RangeTest.assertTrue((boolean)this.byteRange3.equals(this.byteRange3));
        RangeTest.assertFalse((boolean)this.byteRange2.equals(this.byteRange3));
        RangeTest.assertFalse((boolean)this.byteRange2.equals(null));
        RangeTest.assertFalse((boolean)this.byteRange2.equals((Object)"Ni!"));
    }

    public void testHashCode() {
        RangeTest.assertEquals((int)this.byteRange.hashCode(), (int)this.byteRange2.hashCode());
        RangeTest.assertFalse((this.byteRange.hashCode() == this.byteRange3.hashCode() ? 1 : 0) != 0);
        RangeTest.assertEquals((int)this.intRange.hashCode(), (int)this.intRange.hashCode());
        RangeTest.assertTrue((this.intRange.hashCode() != 0 ? 1 : 0) != 0);
    }

    public void testToString() {
        RangeTest.assertNotNull((Object)this.byteRange.toString());
        String str = this.intRange.toString();
        RangeTest.assertEquals((String)"[10..20]", (String)str);
        RangeTest.assertEquals((String)"[-20..-10]", (String)Range.between((Comparable)Integer.valueOf(-20), (Comparable)Integer.valueOf(-10)).toString());
    }

    public void testToStringFormat() {
        String str = this.intRange.toString("From %1$s to %2$s");
        RangeTest.assertEquals((String)"From 10 to 20", (String)str);
    }

    public void testGetMinimum() {
        RangeTest.assertEquals((int)10, (int)((Integer)this.intRange.getMinimum()));
        RangeTest.assertEquals((long)10L, (long)((Long)this.longRange.getMinimum()));
        RangeTest.assertEquals((float)10.0f, (float)((Float)this.floatRange.getMinimum()).floatValue(), (float)1.0E-5f);
        RangeTest.assertEquals((double)10.0, (double)((Double)this.doubleRange.getMinimum()), (double)1.0E-5);
    }

    public void testGetMaximum() {
        RangeTest.assertEquals((int)20, (int)((Integer)this.intRange.getMaximum()));
        RangeTest.assertEquals((long)20L, (long)((Long)this.longRange.getMaximum()));
        RangeTest.assertEquals((float)20.0f, (float)((Float)this.floatRange.getMaximum()).floatValue(), (float)1.0E-5f);
        RangeTest.assertEquals((double)20.0, (double)((Double)this.doubleRange.getMaximum()), (double)1.0E-5);
    }

    public void testContains() {
        RangeTest.assertFalse((boolean)this.intRange.contains(null));
        RangeTest.assertFalse((boolean)this.intRange.contains((Object)5));
        RangeTest.assertTrue((boolean)this.intRange.contains((Object)10));
        RangeTest.assertTrue((boolean)this.intRange.contains((Object)15));
        RangeTest.assertTrue((boolean)this.intRange.contains((Object)20));
        RangeTest.assertFalse((boolean)this.intRange.contains((Object)25));
    }

    public void testIsAfter() {
        RangeTest.assertFalse((boolean)this.intRange.isAfter(null));
        RangeTest.assertTrue((boolean)this.intRange.isAfter((Object)5));
        RangeTest.assertFalse((boolean)this.intRange.isAfter((Object)10));
        RangeTest.assertFalse((boolean)this.intRange.isAfter((Object)15));
        RangeTest.assertFalse((boolean)this.intRange.isAfter((Object)20));
        RangeTest.assertFalse((boolean)this.intRange.isAfter((Object)25));
    }

    public void testIsStartedBy() {
        RangeTest.assertFalse((boolean)this.intRange.isStartedBy(null));
        RangeTest.assertFalse((boolean)this.intRange.isStartedBy((Object)5));
        RangeTest.assertTrue((boolean)this.intRange.isStartedBy((Object)10));
        RangeTest.assertFalse((boolean)this.intRange.isStartedBy((Object)15));
        RangeTest.assertFalse((boolean)this.intRange.isStartedBy((Object)20));
        RangeTest.assertFalse((boolean)this.intRange.isStartedBy((Object)25));
    }

    public void testIsEndedBy() {
        RangeTest.assertFalse((boolean)this.intRange.isEndedBy(null));
        RangeTest.assertFalse((boolean)this.intRange.isEndedBy((Object)5));
        RangeTest.assertFalse((boolean)this.intRange.isEndedBy((Object)10));
        RangeTest.assertFalse((boolean)this.intRange.isEndedBy((Object)15));
        RangeTest.assertTrue((boolean)this.intRange.isEndedBy((Object)20));
        RangeTest.assertFalse((boolean)this.intRange.isEndedBy((Object)25));
    }

    public void testIsBefore() {
        RangeTest.assertFalse((boolean)this.intRange.isBefore(null));
        RangeTest.assertFalse((boolean)this.intRange.isBefore((Object)5));
        RangeTest.assertFalse((boolean)this.intRange.isBefore((Object)10));
        RangeTest.assertFalse((boolean)this.intRange.isBefore((Object)15));
        RangeTest.assertFalse((boolean)this.intRange.isBefore((Object)20));
        RangeTest.assertTrue((boolean)this.intRange.isBefore((Object)25));
    }

    public void testElementCompareTo() {
        try {
            this.intRange.elementCompareTo(null);
            RangeTest.fail((String)"NullPointerException should have been thrown");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        RangeTest.assertEquals((int)-1, (int)this.intRange.elementCompareTo((Object)5));
        RangeTest.assertEquals((int)0, (int)this.intRange.elementCompareTo((Object)10));
        RangeTest.assertEquals((int)0, (int)this.intRange.elementCompareTo((Object)15));
        RangeTest.assertEquals((int)0, (int)this.intRange.elementCompareTo((Object)20));
        RangeTest.assertEquals((int)1, (int)this.intRange.elementCompareTo((Object)25));
    }

    public void testContainsRange() {
        RangeTest.assertFalse((boolean)this.intRange.containsRange(null));
        RangeTest.assertTrue((boolean)this.intRange.containsRange(Range.between((Comparable)Integer.valueOf(12), (Comparable)Integer.valueOf(18))));
        RangeTest.assertFalse((boolean)this.intRange.containsRange(Range.between((Comparable)Integer.valueOf(32), (Comparable)Integer.valueOf(45))));
        RangeTest.assertFalse((boolean)this.intRange.containsRange(Range.between((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(8))));
        RangeTest.assertTrue((boolean)this.intRange.containsRange(Range.between((Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(20))));
        RangeTest.assertFalse((boolean)this.intRange.containsRange(Range.between((Comparable)Integer.valueOf(9), (Comparable)Integer.valueOf(14))));
        RangeTest.assertFalse((boolean)this.intRange.containsRange(Range.between((Comparable)Integer.valueOf(16), (Comparable)Integer.valueOf(21))));
        RangeTest.assertTrue((boolean)this.intRange.containsRange(Range.between((Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(19))));
        RangeTest.assertFalse((boolean)this.intRange.containsRange(Range.between((Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(21))));
        RangeTest.assertTrue((boolean)this.intRange.containsRange(Range.between((Comparable)Integer.valueOf(11), (Comparable)Integer.valueOf(20))));
        RangeTest.assertFalse((boolean)this.intRange.containsRange(Range.between((Comparable)Integer.valueOf(9), (Comparable)Integer.valueOf(20))));
        RangeTest.assertFalse((boolean)this.intRange.containsRange(Range.between((Comparable)Integer.valueOf(-11), (Comparable)Integer.valueOf(-18))));
    }

    public void testIsAfterRange() {
        RangeTest.assertFalse((boolean)this.intRange.isAfterRange(null));
        RangeTest.assertTrue((boolean)this.intRange.isAfterRange(Range.between((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(9))));
        RangeTest.assertFalse((boolean)this.intRange.isAfterRange(Range.between((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(10))));
        RangeTest.assertFalse((boolean)this.intRange.isAfterRange(Range.between((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(20))));
        RangeTest.assertFalse((boolean)this.intRange.isAfterRange(Range.between((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(25))));
        RangeTest.assertFalse((boolean)this.intRange.isAfterRange(Range.between((Comparable)Integer.valueOf(15), (Comparable)Integer.valueOf(25))));
        RangeTest.assertFalse((boolean)this.intRange.isAfterRange(Range.between((Comparable)Integer.valueOf(21), (Comparable)Integer.valueOf(25))));
        RangeTest.assertFalse((boolean)this.intRange.isAfterRange(Range.between((Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(20))));
    }

    public void testIsOverlappedBy() {
        RangeTest.assertFalse((boolean)this.intRange.isOverlappedBy(null));
        RangeTest.assertTrue((boolean)this.intRange.isOverlappedBy(Range.between((Comparable)Integer.valueOf(12), (Comparable)Integer.valueOf(18))));
        RangeTest.assertFalse((boolean)this.intRange.isOverlappedBy(Range.between((Comparable)Integer.valueOf(32), (Comparable)Integer.valueOf(45))));
        RangeTest.assertFalse((boolean)this.intRange.isOverlappedBy(Range.between((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(8))));
        RangeTest.assertTrue((boolean)this.intRange.isOverlappedBy(Range.between((Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(20))));
        RangeTest.assertTrue((boolean)this.intRange.isOverlappedBy(Range.between((Comparable)Integer.valueOf(9), (Comparable)Integer.valueOf(14))));
        RangeTest.assertTrue((boolean)this.intRange.isOverlappedBy(Range.between((Comparable)Integer.valueOf(16), (Comparable)Integer.valueOf(21))));
        RangeTest.assertTrue((boolean)this.intRange.isOverlappedBy(Range.between((Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(19))));
        RangeTest.assertTrue((boolean)this.intRange.isOverlappedBy(Range.between((Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(21))));
        RangeTest.assertTrue((boolean)this.intRange.isOverlappedBy(Range.between((Comparable)Integer.valueOf(11), (Comparable)Integer.valueOf(20))));
        RangeTest.assertTrue((boolean)this.intRange.isOverlappedBy(Range.between((Comparable)Integer.valueOf(9), (Comparable)Integer.valueOf(20))));
        RangeTest.assertFalse((boolean)this.intRange.isOverlappedBy(Range.between((Comparable)Integer.valueOf(-11), (Comparable)Integer.valueOf(-18))));
    }

    public void testIsBeforeRange() {
        RangeTest.assertFalse((boolean)this.intRange.isBeforeRange(null));
        RangeTest.assertFalse((boolean)this.intRange.isBeforeRange(Range.between((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(9))));
        RangeTest.assertFalse((boolean)this.intRange.isBeforeRange(Range.between((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(10))));
        RangeTest.assertFalse((boolean)this.intRange.isBeforeRange(Range.between((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(20))));
        RangeTest.assertFalse((boolean)this.intRange.isBeforeRange(Range.between((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(25))));
        RangeTest.assertFalse((boolean)this.intRange.isBeforeRange(Range.between((Comparable)Integer.valueOf(15), (Comparable)Integer.valueOf(25))));
        RangeTest.assertTrue((boolean)this.intRange.isBeforeRange(Range.between((Comparable)Integer.valueOf(21), (Comparable)Integer.valueOf(25))));
        RangeTest.assertFalse((boolean)this.intRange.isBeforeRange(Range.between((Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(20))));
    }

    public void testSerializing() {
        SerializationUtils.clone(this.intRange);
    }
}

