/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import junit.framework.TestCase;
import org.apache.commons.lang3.ClassNotFoundSerialization;
import org.apache.commons.lang3.SerializationException;
import org.apache.commons.lang3.SerializationUtils;

public class SerializationUtilsTest
extends TestCase {
    static final String CLASS_NOT_FOUND_MESSAGE = "ClassNotFoundSerialization.readObject fake exception";
    protected static final String SERIALIZE_IO_EXCEPTION_MESSAGE = "Anonymous OutputStream I/O exception";
    private String iString;
    private Integer iInteger;
    private HashMap<Object, Object> iMap;

    public SerializationUtilsTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.iString = "foo";
        this.iInteger = new Integer(7);
        this.iMap = new HashMap();
        this.iMap.put("FOO", this.iString);
        this.iMap.put("BAR", this.iInteger);
    }

    public void testConstructor() {
        SerializationUtilsTest.assertNotNull((Object)new SerializationUtils());
        Constructor<?>[] cons = SerializationUtils.class.getDeclaredConstructors();
        SerializationUtilsTest.assertEquals((int)1, (int)cons.length);
        SerializationUtilsTest.assertEquals((boolean)true, (boolean)Modifier.isPublic(cons[0].getModifiers()));
        SerializationUtilsTest.assertEquals((boolean)true, (boolean)Modifier.isPublic(SerializationUtils.class.getModifiers()));
        SerializationUtilsTest.assertEquals((boolean)false, (boolean)Modifier.isFinal(SerializationUtils.class.getModifiers()));
    }

    public void testException() {
        Exception ex = new Exception();
        SerializationException serEx = new SerializationException();
        SerializationUtilsTest.assertSame(null, (Object)serEx.getMessage());
        SerializationUtilsTest.assertSame(null, (Object)serEx.getCause());
        serEx = new SerializationException("Message");
        SerializationUtilsTest.assertSame((Object)"Message", (Object)serEx.getMessage());
        SerializationUtilsTest.assertSame(null, (Object)serEx.getCause());
        serEx = new SerializationException((Throwable)ex);
        SerializationUtilsTest.assertEquals((String)"java.lang.Exception", (String)serEx.getMessage());
        SerializationUtilsTest.assertSame((Object)ex, (Object)serEx.getCause());
        serEx = new SerializationException("Message", (Throwable)ex);
        SerializationUtilsTest.assertSame((Object)"Message", (Object)serEx.getMessage());
        SerializationUtilsTest.assertSame((Object)ex, (Object)serEx.getCause());
    }

    public void testSerializeStream() throws Exception {
        ByteArrayOutputStream streamTest = new ByteArrayOutputStream();
        SerializationUtils.serialize(this.iMap, (OutputStream)streamTest);
        ByteArrayOutputStream streamReal = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(streamReal);
        oos.writeObject(this.iMap);
        oos.flush();
        oos.close();
        byte[] testBytes = streamTest.toByteArray();
        byte[] realBytes = streamReal.toByteArray();
        SerializationUtilsTest.assertEquals((int)testBytes.length, (int)realBytes.length);
        for (int i = 0; i < realBytes.length; ++i) {
            SerializationUtilsTest.assertEquals((byte)realBytes[i], (byte)testBytes[i]);
        }
    }

    public void testSerializeStreamUnserializable() throws Exception {
        ByteArrayOutputStream streamTest = new ByteArrayOutputStream();
        try {
            this.iMap.put(new Object(), new Object());
            SerializationUtils.serialize(this.iMap, (OutputStream)streamTest);
        }
        catch (SerializationException ex) {
            return;
        }
        SerializationUtilsTest.fail();
    }

    public void testSerializeStreamNullObj() throws Exception {
        ByteArrayOutputStream streamTest = new ByteArrayOutputStream();
        SerializationUtils.serialize(null, (OutputStream)streamTest);
        ByteArrayOutputStream streamReal = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(streamReal);
        oos.writeObject(null);
        oos.flush();
        oos.close();
        byte[] testBytes = streamTest.toByteArray();
        byte[] realBytes = streamReal.toByteArray();
        SerializationUtilsTest.assertEquals((int)testBytes.length, (int)realBytes.length);
        for (int i = 0; i < realBytes.length; ++i) {
            SerializationUtilsTest.assertEquals((byte)realBytes[i], (byte)testBytes[i]);
        }
    }

    public void testSerializeStreamObjNull() throws Exception {
        try {
            SerializationUtils.serialize(this.iMap, null);
        }
        catch (IllegalArgumentException ex) {
            return;
        }
        SerializationUtilsTest.fail();
    }

    public void testSerializeStreamNullNull() throws Exception {
        try {
            SerializationUtils.serialize(null, null);
        }
        catch (IllegalArgumentException ex) {
            return;
        }
        SerializationUtilsTest.fail();
    }

    public void testSerializeIOException() throws Exception {
        OutputStream streamTest = new OutputStream(){

            public void write(int arg0) throws IOException {
                throw new IOException(SerializationUtilsTest.SERIALIZE_IO_EXCEPTION_MESSAGE);
            }
        };
        try {
            SerializationUtils.serialize(this.iMap, (OutputStream)streamTest);
        }
        catch (SerializationException e) {
            SerializationUtilsTest.assertEquals((String)"java.io.IOException: Anonymous OutputStream I/O exception", (String)e.getMessage());
        }
    }

    public void testDeserializeStream() throws Exception {
        ByteArrayOutputStream streamReal = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(streamReal);
        oos.writeObject(this.iMap);
        oos.flush();
        oos.close();
        ByteArrayInputStream inTest = new ByteArrayInputStream(streamReal.toByteArray());
        Object test = SerializationUtils.deserialize((InputStream)inTest);
        SerializationUtilsTest.assertNotNull((Object)test);
        SerializationUtilsTest.assertTrue((boolean)(test instanceof HashMap));
        SerializationUtilsTest.assertTrue((test != this.iMap ? 1 : 0) != 0);
        HashMap testMap = (HashMap)test;
        SerializationUtilsTest.assertEquals((Object)this.iString, testMap.get("FOO"));
        SerializationUtilsTest.assertTrue((this.iString != testMap.get("FOO") ? 1 : 0) != 0);
        SerializationUtilsTest.assertEquals((Object)this.iInteger, testMap.get("BAR"));
        SerializationUtilsTest.assertTrue((this.iInteger != testMap.get("BAR") ? 1 : 0) != 0);
        SerializationUtilsTest.assertEquals(this.iMap, (Object)testMap);
    }

    public void testDeserializeStreamOfNull() throws Exception {
        ByteArrayOutputStream streamReal = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(streamReal);
        oos.writeObject(null);
        oos.flush();
        oos.close();
        ByteArrayInputStream inTest = new ByteArrayInputStream(streamReal.toByteArray());
        Object test = SerializationUtils.deserialize((InputStream)inTest);
        SerializationUtilsTest.assertNull((Object)test);
    }

    public void testDeserializeStreamNull() throws Exception {
        try {
            SerializationUtils.deserialize((InputStream)null);
        }
        catch (IllegalArgumentException ex) {
            return;
        }
        SerializationUtilsTest.fail();
    }

    public void testDeserializeStreamBadStream() throws Exception {
        try {
            SerializationUtils.deserialize((InputStream)new ByteArrayInputStream(new byte[0]));
        }
        catch (SerializationException ex) {
            return;
        }
        SerializationUtilsTest.fail();
    }

    public void testDeserializeStreamClassNotFound() throws Exception {
        ByteArrayOutputStream streamReal = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(streamReal);
        oos.writeObject(new ClassNotFoundSerialization());
        oos.flush();
        oos.close();
        ByteArrayInputStream inTest = new ByteArrayInputStream(streamReal.toByteArray());
        try {
            Object test = SerializationUtils.deserialize((InputStream)inTest);
        }
        catch (SerializationException se) {
            SerializationUtilsTest.assertEquals((String)"java.lang.ClassNotFoundException: ClassNotFoundSerialization.readObject fake exception", (String)se.getMessage());
        }
    }

    public void testSerializeBytes() throws Exception {
        byte[] testBytes = SerializationUtils.serialize(this.iMap);
        ByteArrayOutputStream streamReal = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(streamReal);
        oos.writeObject(this.iMap);
        oos.flush();
        oos.close();
        byte[] realBytes = streamReal.toByteArray();
        SerializationUtilsTest.assertEquals((int)testBytes.length, (int)realBytes.length);
        for (int i = 0; i < realBytes.length; ++i) {
            SerializationUtilsTest.assertEquals((byte)realBytes[i], (byte)testBytes[i]);
        }
    }

    public void testSerializeBytesUnserializable() throws Exception {
        try {
            this.iMap.put(new Object(), new Object());
            SerializationUtils.serialize(this.iMap);
        }
        catch (SerializationException ex) {
            return;
        }
        SerializationUtilsTest.fail();
    }

    public void testSerializeBytesNull() throws Exception {
        byte[] testBytes = SerializationUtils.serialize(null);
        ByteArrayOutputStream streamReal = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(streamReal);
        oos.writeObject(null);
        oos.flush();
        oos.close();
        byte[] realBytes = streamReal.toByteArray();
        SerializationUtilsTest.assertEquals((int)testBytes.length, (int)realBytes.length);
        for (int i = 0; i < realBytes.length; ++i) {
            SerializationUtilsTest.assertEquals((byte)realBytes[i], (byte)testBytes[i]);
        }
    }

    public void testDeserializeBytes() throws Exception {
        ByteArrayOutputStream streamReal = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(streamReal);
        oos.writeObject(this.iMap);
        oos.flush();
        oos.close();
        Object test = SerializationUtils.deserialize((byte[])streamReal.toByteArray());
        SerializationUtilsTest.assertNotNull((Object)test);
        SerializationUtilsTest.assertTrue((boolean)(test instanceof HashMap));
        SerializationUtilsTest.assertTrue((test != this.iMap ? 1 : 0) != 0);
        HashMap testMap = (HashMap)test;
        SerializationUtilsTest.assertEquals((Object)this.iString, testMap.get("FOO"));
        SerializationUtilsTest.assertTrue((this.iString != testMap.get("FOO") ? 1 : 0) != 0);
        SerializationUtilsTest.assertEquals((Object)this.iInteger, testMap.get("BAR"));
        SerializationUtilsTest.assertTrue((this.iInteger != testMap.get("BAR") ? 1 : 0) != 0);
        SerializationUtilsTest.assertEquals(this.iMap, (Object)testMap);
    }

    public void testDeserializeBytesOfNull() throws Exception {
        ByteArrayOutputStream streamReal = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(streamReal);
        oos.writeObject(null);
        oos.flush();
        oos.close();
        Object test = SerializationUtils.deserialize((byte[])streamReal.toByteArray());
        SerializationUtilsTest.assertNull((Object)test);
    }

    public void testDeserializeBytesNull() throws Exception {
        try {
            SerializationUtils.deserialize((byte[])null);
        }
        catch (IllegalArgumentException ex) {
            return;
        }
        SerializationUtilsTest.fail();
    }

    public void testDeserializeBytesBadStream() throws Exception {
        try {
            SerializationUtils.deserialize((byte[])new byte[0]);
        }
        catch (SerializationException ex) {
            return;
        }
        SerializationUtilsTest.fail();
    }

    public void testClone() throws Exception {
        Serializable test = SerializationUtils.clone(this.iMap);
        SerializationUtilsTest.assertNotNull((Object)test);
        SerializationUtilsTest.assertTrue((boolean)(test instanceof HashMap));
        SerializationUtilsTest.assertTrue((test != this.iMap ? 1 : 0) != 0);
        HashMap testMap = (HashMap)test;
        SerializationUtilsTest.assertEquals((Object)this.iString, testMap.get("FOO"));
        SerializationUtilsTest.assertTrue((this.iString != testMap.get("FOO") ? 1 : 0) != 0);
        SerializationUtilsTest.assertEquals((Object)this.iInteger, testMap.get("BAR"));
        SerializationUtilsTest.assertTrue((this.iInteger != testMap.get("BAR") ? 1 : 0) != 0);
        SerializationUtilsTest.assertEquals(this.iMap, (Object)testMap);
    }

    public void testCloneNull() throws Exception {
        Serializable test = SerializationUtils.clone(null);
        SerializationUtilsTest.assertNull((Object)test);
    }

    public void testCloneUnserializable() throws Exception {
        try {
            this.iMap.put(new Object(), new Object());
            SerializationUtils.clone(this.iMap);
        }
        catch (SerializationException ex) {
            return;
        }
        SerializationUtilsTest.fail();
    }
}

