/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import junit.framework.TestCase;
import org.apache.commons.lang3.StringEscapeUtils;

public class StringEscapeUtilsTest
extends TestCase {
    private static final String FOO = "foo";
    String[][] htmlEscapes = new String[][]{{"no escaping", "plain text", "plain text"}, {"no escaping", "plain text", "plain text"}, {"empty string", "", ""}, {"null", null, null}, {"ampersand", "bread &amp; butter", "bread & butter"}, {"quotes", "&quot;bread&quot; &amp; butter", "\"bread\" & butter"}, {"final character only", "greater than &gt;", "greater than >"}, {"first character only", "&lt; less than", "< less than"}, {"apostrophe", "Huntington's chorea", "Huntington's chorea"}, {"languages", "English,Fran&ccedil;ais,\u65e5\u672c\u8a9e (nihongo)", "English,Fran\u00e7ais,\u65e5\u672c\u8a9e (nihongo)"}, {"8-bit ascii shouldn't number-escape", "\u0080\u009f", "\u0080\u009f"}};

    public StringEscapeUtilsTest(String name) {
        super(name);
    }

    public void testConstructor() {
        StringEscapeUtilsTest.assertNotNull((Object)new StringEscapeUtils());
        Constructor<?>[] cons = StringEscapeUtils.class.getDeclaredConstructors();
        StringEscapeUtilsTest.assertEquals((int)1, (int)cons.length);
        StringEscapeUtilsTest.assertEquals((boolean)true, (boolean)Modifier.isPublic(cons[0].getModifiers()));
        StringEscapeUtilsTest.assertEquals((boolean)true, (boolean)Modifier.isPublic(StringEscapeUtils.class.getModifiers()));
        StringEscapeUtilsTest.assertEquals((boolean)false, (boolean)Modifier.isFinal(StringEscapeUtils.class.getModifiers()));
    }

    public void testEscapeJava() throws IOException {
        StringEscapeUtilsTest.assertEquals(null, (String)StringEscapeUtils.escapeJava(null));
        try {
            StringEscapeUtils.ESCAPE_JAVA.translate(null, null);
            StringEscapeUtilsTest.fail();
        }
        catch (IOException ex) {
            StringEscapeUtilsTest.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            StringEscapeUtils.ESCAPE_JAVA.translate((CharSequence)"", null);
            StringEscapeUtilsTest.fail();
        }
        catch (IOException ex) {
            StringEscapeUtilsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.assertEscapeJava("empty string", "", "");
        this.assertEscapeJava(FOO, FOO);
        this.assertEscapeJava("tab", "\\t", "\t");
        this.assertEscapeJava("backslash", "\\\\", "\\");
        this.assertEscapeJava("single quote should not be escaped", "'", "'");
        this.assertEscapeJava("\\\\\\b\\t\\r", "\\\b\t\r");
        this.assertEscapeJava("\\u1234", "\u1234");
        this.assertEscapeJava("\\u0234", "\u0234");
        this.assertEscapeJava("\\u00EF", "\u00ef");
        this.assertEscapeJava("\\u0001", "\u0001");
        this.assertEscapeJava("Should use capitalized unicode hex", "\\uABCD", "\uabcd");
        this.assertEscapeJava("He didn't say, \\\"stop!\\\"", "He didn't say, \"stop!\"");
        this.assertEscapeJava("non-breaking space", "This space is non-breaking:\\u00A0", "This space is non-breaking:\u00a0");
        this.assertEscapeJava("\\uABCD\\u1234\\u012C", "\uabcd\u1234\u012c");
    }

    public void testEscapeJavaWithSlash() {
        String input = "String with a slash (/) in it";
        String expected = "String with a slash (/) in it";
        String actual = StringEscapeUtils.escapeJava((String)"String with a slash (/) in it");
        StringEscapeUtilsTest.assertEquals((String)"String with a slash (/) in it", (String)actual);
    }

    private void assertEscapeJava(String escaped, String original) throws IOException {
        this.assertEscapeJava(null, escaped, original);
    }

    private void assertEscapeJava(String message, String expected, String original) throws IOException {
        String converted = StringEscapeUtils.escapeJava((String)original);
        message = "escapeJava(String) failed" + (message == null ? "" : ": " + message);
        StringEscapeUtilsTest.assertEquals((String)message, (String)expected, (String)converted);
        StringWriter writer = new StringWriter();
        StringEscapeUtils.ESCAPE_JAVA.translate((CharSequence)original, (Writer)writer);
        StringEscapeUtilsTest.assertEquals((String)expected, (String)writer.toString());
    }

    public void testUnescapeJava() throws IOException {
        StringEscapeUtilsTest.assertEquals(null, (String)StringEscapeUtils.unescapeJava(null));
        try {
            StringEscapeUtils.UNESCAPE_JAVA.translate(null, null);
            StringEscapeUtilsTest.fail();
        }
        catch (IOException ex) {
            StringEscapeUtilsTest.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            StringEscapeUtils.UNESCAPE_JAVA.translate((CharSequence)"", null);
            StringEscapeUtilsTest.fail();
        }
        catch (IOException ex) {
            StringEscapeUtilsTest.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            StringEscapeUtils.unescapeJava((String)"\\u02-3");
            StringEscapeUtilsTest.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.assertUnescapeJava("", "");
        this.assertUnescapeJava("test", "test");
        this.assertUnescapeJava("\ntest\b", "\\ntest\\b");
        this.assertUnescapeJava("\u123425foo\ntest\b", "\\u123425foo\\ntest\\b");
        this.assertUnescapeJava("'\foo\teste\r", "\\'\\foo\\teste\\r");
        this.assertUnescapeJava("", "\\");
        this.assertUnescapeJava("lowercase unicode", "\uabcdx", "\\uabcdx");
        this.assertUnescapeJava("uppercase unicode", "\uabcdx", "\\uABCDx");
        this.assertUnescapeJava("unicode as final character", "\uabcd", "\\uabcd");
    }

    private void assertUnescapeJava(String unescaped, String original) throws IOException {
        this.assertUnescapeJava(null, unescaped, original);
    }

    private void assertUnescapeJava(String message, String unescaped, String original) throws IOException {
        String expected = unescaped;
        String actual = StringEscapeUtils.unescapeJava((String)original);
        StringEscapeUtilsTest.assertEquals((String)("unescape(String) failed" + (message == null ? "" : ": " + message) + ": expected '" + StringEscapeUtils.escapeJava((String)expected) + "' actual '" + StringEscapeUtils.escapeJava((String)actual) + "'"), (String)expected, (String)actual);
        StringWriter writer = new StringWriter();
        StringEscapeUtils.UNESCAPE_JAVA.translate((CharSequence)original, (Writer)writer);
        StringEscapeUtilsTest.assertEquals((String)unescaped, (String)writer.toString());
    }

    public void testEscapeEcmaScript() {
        StringEscapeUtilsTest.assertEquals(null, (String)StringEscapeUtils.escapeEcmaScript(null));
        try {
            StringEscapeUtils.ESCAPE_ECMASCRIPT.translate(null, null);
            StringEscapeUtilsTest.fail();
        }
        catch (IOException ex) {
            StringEscapeUtilsTest.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            StringEscapeUtils.ESCAPE_ECMASCRIPT.translate((CharSequence)"", null);
            StringEscapeUtilsTest.fail();
        }
        catch (IOException ex) {
            StringEscapeUtilsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        StringEscapeUtilsTest.assertEquals((String)"He didn\\'t say, \\\"stop!\\\"", (String)StringEscapeUtils.escapeEcmaScript((String)"He didn't say, \"stop!\""));
        StringEscapeUtilsTest.assertEquals((String)"document.getElementById(\\\"test\\\").value = \\'<script>alert(\\'aaa\\');<\\/script>\\';", (String)StringEscapeUtils.escapeEcmaScript((String)"document.getElementById(\"test\").value = '<script>alert('aaa');</script>';"));
    }

    public void testEscapeHtml() {
        for (int i = 0; i < this.htmlEscapes.length; ++i) {
            String message = this.htmlEscapes[i][0];
            String expected = this.htmlEscapes[i][1];
            String original = this.htmlEscapes[i][2];
            StringEscapeUtilsTest.assertEquals((String)message, (String)expected, (String)StringEscapeUtils.escapeHtml4((String)original));
            StringWriter sw = new StringWriter();
            try {
                StringEscapeUtils.ESCAPE_HTML4.translate((CharSequence)original, (Writer)sw);
            }
            catch (IOException e) {
                // empty catch block
            }
            String actual = original == null ? null : sw.toString();
            StringEscapeUtilsTest.assertEquals((String)message, (String)expected, (String)actual);
        }
    }

    public void testUnescapeHtml4() {
        for (int i = 0; i < this.htmlEscapes.length; ++i) {
            String message = this.htmlEscapes[i][0];
            String expected = this.htmlEscapes[i][2];
            String original = this.htmlEscapes[i][1];
            StringEscapeUtilsTest.assertEquals((String)message, (String)expected, (String)StringEscapeUtils.unescapeHtml4((String)original));
            StringWriter sw = new StringWriter();
            try {
                StringEscapeUtils.UNESCAPE_HTML4.translate((CharSequence)original, (Writer)sw);
            }
            catch (IOException e) {
                // empty catch block
            }
            String actual = original == null ? null : sw.toString();
            StringEscapeUtilsTest.assertEquals((String)message, (String)expected, (String)actual);
        }
        StringEscapeUtilsTest.assertEquals((String)"funny chars pass through OK", (String)"Fran\u00e7ais", (String)StringEscapeUtils.unescapeHtml4((String)"Fran\u00e7ais"));
        StringEscapeUtilsTest.assertEquals((String)"Hello&;World", (String)StringEscapeUtils.unescapeHtml4((String)"Hello&;World"));
        StringEscapeUtilsTest.assertEquals((String)"Hello&#;World", (String)StringEscapeUtils.unescapeHtml4((String)"Hello&#;World"));
        StringEscapeUtilsTest.assertEquals((String)"Hello&# ;World", (String)StringEscapeUtils.unescapeHtml4((String)"Hello&# ;World"));
        StringEscapeUtilsTest.assertEquals((String)"Hello&##;World", (String)StringEscapeUtils.unescapeHtml4((String)"Hello&##;World"));
    }

    public void testUnescapeHexCharsHtml() {
        StringEscapeUtilsTest.assertEquals((String)"hex number unescape", (String)"\u0080\u009f", (String)StringEscapeUtils.unescapeHtml4((String)"&#x80;&#x9F;"));
        StringEscapeUtilsTest.assertEquals((String)"hex number unescape", (String)"\u0080\u009f", (String)StringEscapeUtils.unescapeHtml4((String)"&#X80;&#X9F;"));
        for (char i = '\u0000'; i < '\uffff'; i = (char)(i + '\u0001')) {
            Character c1 = new Character(i);
            Character c2 = new Character((char)(i + '\u0001'));
            String expected = c1.toString() + c2.toString();
            String escapedC1 = "&#x" + Integer.toHexString(c1.charValue()) + ";";
            String escapedC2 = "&#x" + Integer.toHexString(c2.charValue()) + ";";
            StringEscapeUtilsTest.assertEquals((String)("hex number unescape index " + i), (String)expected, (String)StringEscapeUtils.unescapeHtml4((String)(escapedC1 + escapedC2)));
        }
    }

    public void testUnescapeUnknownEntity() throws Exception {
        StringEscapeUtilsTest.assertEquals((String)"&zzzz;", (String)StringEscapeUtils.unescapeHtml4((String)"&zzzz;"));
    }

    public void testEscapeHtmlVersions() throws Exception {
        StringEscapeUtilsTest.assertEquals((String)"&Beta;", (String)StringEscapeUtils.escapeHtml4((String)"\u0392"));
        StringEscapeUtilsTest.assertEquals((String)"\u0392", (String)StringEscapeUtils.unescapeHtml4((String)"&Beta;"));
    }

    public void testEscapeXml() throws Exception {
        StringEscapeUtilsTest.assertEquals((String)"&lt;abc&gt;", (String)StringEscapeUtils.escapeXml((String)"<abc>"));
        StringEscapeUtilsTest.assertEquals((String)"<abc>", (String)StringEscapeUtils.unescapeXml((String)"&lt;abc&gt;"));
        StringEscapeUtilsTest.assertEquals((String)"XML should not escape >0x7f values", (String)"\u00a1", (String)StringEscapeUtils.escapeXml((String)"\u00a1"));
        StringEscapeUtilsTest.assertEquals((String)"XML should be able to unescape >0x7f values", (String)"\u00a0", (String)StringEscapeUtils.unescapeXml((String)"&#160;"));
        StringEscapeUtilsTest.assertEquals((String)"ain't", (String)StringEscapeUtils.unescapeXml((String)"ain&apos;t"));
        StringEscapeUtilsTest.assertEquals((String)"ain&apos;t", (String)StringEscapeUtils.escapeXml((String)"ain't"));
        StringEscapeUtilsTest.assertEquals((String)"", (String)StringEscapeUtils.escapeXml((String)""));
        StringEscapeUtilsTest.assertEquals(null, (String)StringEscapeUtils.escapeXml(null));
        StringEscapeUtilsTest.assertEquals(null, (String)StringEscapeUtils.unescapeXml(null));
        StringWriter sw = new StringWriter();
        try {
            StringEscapeUtils.ESCAPE_XML.translate((CharSequence)"<abc>", (Writer)sw);
        }
        catch (IOException e) {
            // empty catch block
        }
        StringEscapeUtilsTest.assertEquals((String)"XML was escaped incorrectly", (String)"&lt;abc&gt;", (String)sw.toString());
        sw = new StringWriter();
        try {
            StringEscapeUtils.UNESCAPE_XML.translate((CharSequence)"&lt;abc&gt;", (Writer)sw);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        StringEscapeUtilsTest.assertEquals((String)"XML was unescaped incorrectly", (String)"<abc>", (String)sw.toString());
    }

    public void testStandaloneAmphersand() {
        StringEscapeUtilsTest.assertEquals((String)"<P&O>", (String)StringEscapeUtils.unescapeHtml4((String)"&lt;P&O&gt;"));
        StringEscapeUtilsTest.assertEquals((String)"test & <", (String)StringEscapeUtils.unescapeHtml4((String)"test & &lt;"));
        StringEscapeUtilsTest.assertEquals((String)"<P&O>", (String)StringEscapeUtils.unescapeXml((String)"&lt;P&O&gt;"));
        StringEscapeUtilsTest.assertEquals((String)"test & <", (String)StringEscapeUtils.unescapeXml((String)"test & &lt;"));
    }

    public void testLang313() {
        StringEscapeUtilsTest.assertEquals((String)"& &", (String)StringEscapeUtils.unescapeHtml4((String)"& &amp;"));
    }

    public void testEscapeCsvString() throws Exception {
        StringEscapeUtilsTest.assertEquals((String)"foo.bar", (String)StringEscapeUtils.escapeCsv((String)"foo.bar"));
        StringEscapeUtilsTest.assertEquals((String)"\"foo,bar\"", (String)StringEscapeUtils.escapeCsv((String)"foo,bar"));
        StringEscapeUtilsTest.assertEquals((String)"\"foo\nbar\"", (String)StringEscapeUtils.escapeCsv((String)"foo\nbar"));
        StringEscapeUtilsTest.assertEquals((String)"\"foo\rbar\"", (String)StringEscapeUtils.escapeCsv((String)"foo\rbar"));
        StringEscapeUtilsTest.assertEquals((String)"\"foo\"\"bar\"", (String)StringEscapeUtils.escapeCsv((String)"foo\"bar"));
        StringEscapeUtilsTest.assertEquals((String)"", (String)StringEscapeUtils.escapeCsv((String)""));
        StringEscapeUtilsTest.assertEquals(null, (String)StringEscapeUtils.escapeCsv(null));
    }

    public void testEscapeCsvWriter() throws Exception {
        this.checkCsvEscapeWriter("foo.bar", "foo.bar");
        this.checkCsvEscapeWriter("\"foo,bar\"", "foo,bar");
        this.checkCsvEscapeWriter("\"foo\nbar\"", "foo\nbar");
        this.checkCsvEscapeWriter("\"foo\rbar\"", "foo\rbar");
        this.checkCsvEscapeWriter("\"foo\"\"bar\"", "foo\"bar");
        this.checkCsvEscapeWriter("", null);
        this.checkCsvEscapeWriter("", "");
    }

    private void checkCsvEscapeWriter(String expected, String value) {
        try {
            StringWriter writer = new StringWriter();
            StringEscapeUtils.ESCAPE_CSV.translate((CharSequence)value, (Writer)writer);
            StringEscapeUtilsTest.assertEquals((String)expected, (String)writer.toString());
        }
        catch (IOException e) {
            StringEscapeUtilsTest.fail((String)("Threw: " + e));
        }
    }

    public void testUnescapeCsvString() throws Exception {
        StringEscapeUtilsTest.assertEquals((String)"foo.bar", (String)StringEscapeUtils.unescapeCsv((String)"foo.bar"));
        StringEscapeUtilsTest.assertEquals((String)"foo,bar", (String)StringEscapeUtils.unescapeCsv((String)"\"foo,bar\""));
        StringEscapeUtilsTest.assertEquals((String)"foo\nbar", (String)StringEscapeUtils.unescapeCsv((String)"\"foo\nbar\""));
        StringEscapeUtilsTest.assertEquals((String)"foo\rbar", (String)StringEscapeUtils.unescapeCsv((String)"\"foo\rbar\""));
        StringEscapeUtilsTest.assertEquals((String)"foo\"bar", (String)StringEscapeUtils.unescapeCsv((String)"\"foo\"\"bar\""));
        StringEscapeUtilsTest.assertEquals((String)"", (String)StringEscapeUtils.unescapeCsv((String)""));
        StringEscapeUtilsTest.assertEquals(null, (String)StringEscapeUtils.unescapeCsv(null));
        StringEscapeUtilsTest.assertEquals((String)"\"foo.bar\"", (String)StringEscapeUtils.unescapeCsv((String)"\"foo.bar\""));
    }

    public void testUnescapeCsvWriter() throws Exception {
        this.checkCsvUnescapeWriter("foo.bar", "foo.bar");
        this.checkCsvUnescapeWriter("foo,bar", "\"foo,bar\"");
        this.checkCsvUnescapeWriter("foo\nbar", "\"foo\nbar\"");
        this.checkCsvUnescapeWriter("foo\rbar", "\"foo\rbar\"");
        this.checkCsvUnescapeWriter("foo\"bar", "\"foo\"\"bar\"");
        this.checkCsvUnescapeWriter("", null);
        this.checkCsvUnescapeWriter("", "");
        this.checkCsvUnescapeWriter("\"foo.bar\"", "\"foo.bar\"");
    }

    private void checkCsvUnescapeWriter(String expected, String value) {
        try {
            StringWriter writer = new StringWriter();
            StringEscapeUtils.UNESCAPE_CSV.translate((CharSequence)value, (Writer)writer);
            StringEscapeUtilsTest.assertEquals((String)expected, (String)writer.toString());
        }
        catch (IOException e) {
            StringEscapeUtilsTest.fail((String)("Threw: " + e));
        }
    }

    public void testEscapeHtmlHighUnicode() throws UnsupportedEncodingException {
        byte[] data = new byte[]{-16, -99, -115, -94};
        String original = new String(data, "UTF8");
        String escaped = StringEscapeUtils.escapeHtml4((String)original);
        StringEscapeUtilsTest.assertEquals((String)"High unicode should not have been escaped", (String)original, (String)escaped);
        String unescaped = StringEscapeUtils.unescapeHtml4((String)escaped);
        StringEscapeUtilsTest.assertEquals((String)"High unicode should have been unchanged", (String)original, (String)unescaped);
    }

    public void testEscapeHiragana() {
        String original = "\u304b\u304c\u3068";
        String escaped = StringEscapeUtils.escapeHtml4((String)original);
        StringEscapeUtilsTest.assertEquals((String)"Hiragana character unicode behaviour should not be being escaped by escapeHtml4", (String)original, (String)escaped);
        String unescaped = StringEscapeUtils.unescapeHtml4((String)escaped);
        StringEscapeUtilsTest.assertEquals((String)"Hiragana character unicode behaviour has changed - expected no unescaping", (String)escaped, (String)unescaped);
    }
}

