/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import junit.framework.TestCase;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.StringUtilsTest;

public class StringUtilsIsTest
extends TestCase {
    public StringUtilsIsTest(String name) {
        super(name);
    }

    public void testIsAlpha() {
        StringUtilsIsTest.assertEquals((boolean)false, (boolean)StringUtils.isAlpha(null));
        StringUtilsIsTest.assertEquals((boolean)false, (boolean)StringUtils.isAlpha((CharSequence)""));
        StringUtilsIsTest.assertEquals((boolean)false, (boolean)StringUtils.isAlpha((CharSequence)" "));
        StringUtilsIsTest.assertEquals((boolean)true, (boolean)StringUtils.isAlpha((CharSequence)"a"));
        StringUtilsIsTest.assertEquals((boolean)true, (boolean)StringUtils.isAlpha((CharSequence)"A"));
        StringUtilsIsTest.assertEquals((boolean)true, (boolean)StringUtils.isAlpha((CharSequence)"kgKgKgKgkgkGkjkjlJlOKLgHdGdHgl"));
        StringUtilsIsTest.assertEquals((boolean)false, (boolean)StringUtils.isAlpha((CharSequence)"ham kso"));
        StringUtilsIsTest.assertEquals((boolean)false, (boolean)StringUtils.isAlpha((CharSequence)"1"));
        StringUtilsIsTest.assertEquals((boolean)false, (boolean)StringUtils.isAlpha((CharSequence)"hkHKHik6iUGHKJgU7tUJgKJGI87GIkug"));
        StringUtilsIsTest.assertEquals((boolean)false, (boolean)StringUtils.isAlpha((CharSequence)"_"));
        StringUtilsIsTest.assertEquals((boolean)false, (boolean)StringUtils.isAlpha((CharSequence)"hkHKHik*khbkuh"));
    }

    public void testIsAlphanumeric() {
        StringUtilsIsTest.assertEquals((boolean)false, (boolean)StringUtils.isAlphanumeric(null));
        StringUtilsIsTest.assertEquals((boolean)false, (boolean)StringUtils.isAlphanumeric((CharSequence)""));
        StringUtilsIsTest.assertEquals((boolean)false, (boolean)StringUtils.isAlphanumeric((CharSequence)" "));
        StringUtilsIsTest.assertEquals((boolean)true, (boolean)StringUtils.isAlphanumeric((CharSequence)"a"));
        StringUtilsIsTest.assertEquals((boolean)true, (boolean)StringUtils.isAlphanumeric((CharSequence)"A"));
        StringUtilsIsTest.assertEquals((boolean)true, (boolean)StringUtils.isAlphanumeric((CharSequence)"kgKgKgKgkgkGkjkjlJlOKLgHdGdHgl"));
        StringUtilsIsTest.assertEquals((boolean)false, (boolean)StringUtils.isAlphanumeric((CharSequence)"ham kso"));
        StringUtilsIsTest.assertEquals((boolean)true, (boolean)StringUtils.isAlphanumeric((CharSequence)"1"));
        StringUtilsIsTest.assertEquals((boolean)true, (boolean)StringUtils.isAlphanumeric((CharSequence)"hkHKHik6iUGHKJgU7tUJgKJGI87GIkug"));
        StringUtilsIsTest.assertEquals((boolean)false, (boolean)StringUtils.isAlphanumeric((CharSequence)"_"));
        StringUtilsIsTest.assertEquals((boolean)false, (boolean)StringUtils.isAlphanumeric((CharSequence)"hkHKHik*khbkuh"));
    }

    public void testIsWhitespace() {
        StringUtilsIsTest.assertEquals((boolean)false, (boolean)StringUtils.isWhitespace(null));
        StringUtilsIsTest.assertEquals((boolean)true, (boolean)StringUtils.isWhitespace((CharSequence)""));
        StringUtilsIsTest.assertEquals((boolean)true, (boolean)StringUtils.isWhitespace((CharSequence)" "));
        StringUtilsIsTest.assertEquals((boolean)true, (boolean)StringUtils.isWhitespace((CharSequence)"\t \n \t"));
        StringUtilsIsTest.assertEquals((boolean)false, (boolean)StringUtils.isWhitespace((CharSequence)"\t aa\n \t"));
        StringUtilsIsTest.assertEquals((boolean)true, (boolean)StringUtils.isWhitespace((CharSequence)" "));
        StringUtilsIsTest.assertEquals((boolean)false, (boolean)StringUtils.isWhitespace((CharSequence)" a "));
        StringUtilsIsTest.assertEquals((boolean)false, (boolean)StringUtils.isWhitespace((CharSequence)"a  "));
        StringUtilsIsTest.assertEquals((boolean)false, (boolean)StringUtils.isWhitespace((CharSequence)"  a"));
        StringUtilsIsTest.assertEquals((boolean)false, (boolean)StringUtils.isWhitespace((CharSequence)"aba"));
        StringUtilsIsTest.assertEquals((boolean)true, (boolean)StringUtils.isWhitespace((CharSequence)StringUtilsTest.WHITESPACE));
        StringUtilsIsTest.assertEquals((boolean)false, (boolean)StringUtils.isWhitespace((CharSequence)StringUtilsTest.NON_WHITESPACE));
    }

    public void testIsAlphaspace() {
        StringUtilsIsTest.assertEquals((boolean)false, (boolean)StringUtils.isAlphaSpace(null));
        StringUtilsIsTest.assertEquals((boolean)true, (boolean)StringUtils.isAlphaSpace((CharSequence)""));
        StringUtilsIsTest.assertEquals((boolean)true, (boolean)StringUtils.isAlphaSpace((CharSequence)" "));
        StringUtilsIsTest.assertEquals((boolean)true, (boolean)StringUtils.isAlphaSpace((CharSequence)"a"));
        StringUtilsIsTest.assertEquals((boolean)true, (boolean)StringUtils.isAlphaSpace((CharSequence)"A"));
        StringUtilsIsTest.assertEquals((boolean)true, (boolean)StringUtils.isAlphaSpace((CharSequence)"kgKgKgKgkgkGkjkjlJlOKLgHdGdHgl"));
        StringUtilsIsTest.assertEquals((boolean)true, (boolean)StringUtils.isAlphaSpace((CharSequence)"ham kso"));
        StringUtilsIsTest.assertEquals((boolean)false, (boolean)StringUtils.isAlphaSpace((CharSequence)"1"));
        StringUtilsIsTest.assertEquals((boolean)false, (boolean)StringUtils.isAlphaSpace((CharSequence)"hkHKHik6iUGHKJgU7tUJgKJGI87GIkug"));
        StringUtilsIsTest.assertEquals((boolean)false, (boolean)StringUtils.isAlphaSpace((CharSequence)"_"));
        StringUtilsIsTest.assertEquals((boolean)false, (boolean)StringUtils.isAlphaSpace((CharSequence)"hkHKHik*khbkuh"));
    }

    public void testIsAlphanumericSpace() {
        StringUtilsIsTest.assertEquals((boolean)false, (boolean)StringUtils.isAlphanumericSpace(null));
        StringUtilsIsTest.assertEquals((boolean)true, (boolean)StringUtils.isAlphanumericSpace((CharSequence)""));
        StringUtilsIsTest.assertEquals((boolean)true, (boolean)StringUtils.isAlphanumericSpace((CharSequence)" "));
        StringUtilsIsTest.assertEquals((boolean)true, (boolean)StringUtils.isAlphanumericSpace((CharSequence)"a"));
        StringUtilsIsTest.assertEquals((boolean)true, (boolean)StringUtils.isAlphanumericSpace((CharSequence)"A"));
        StringUtilsIsTest.assertEquals((boolean)true, (boolean)StringUtils.isAlphanumericSpace((CharSequence)"kgKgKgKgkgkGkjkjlJlOKLgHdGdHgl"));
        StringUtilsIsTest.assertEquals((boolean)true, (boolean)StringUtils.isAlphanumericSpace((CharSequence)"ham kso"));
        StringUtilsIsTest.assertEquals((boolean)true, (boolean)StringUtils.isAlphanumericSpace((CharSequence)"1"));
        StringUtilsIsTest.assertEquals((boolean)true, (boolean)StringUtils.isAlphanumericSpace((CharSequence)"hkHKHik6iUGHKJgU7tUJgKJGI87GIkug"));
        StringUtilsIsTest.assertEquals((boolean)false, (boolean)StringUtils.isAlphanumericSpace((CharSequence)"_"));
        StringUtilsIsTest.assertEquals((boolean)false, (boolean)StringUtils.isAlphanumericSpace((CharSequence)"hkHKHik*khbkuh"));
    }

    public void testIsAsciiPrintable_String() {
        StringUtilsIsTest.assertEquals((boolean)false, (boolean)StringUtils.isAsciiPrintable(null));
        StringUtilsIsTest.assertEquals((boolean)true, (boolean)StringUtils.isAsciiPrintable((CharSequence)""));
        StringUtilsIsTest.assertEquals((boolean)true, (boolean)StringUtils.isAsciiPrintable((CharSequence)" "));
        StringUtilsIsTest.assertEquals((boolean)true, (boolean)StringUtils.isAsciiPrintable((CharSequence)"a"));
        StringUtilsIsTest.assertEquals((boolean)true, (boolean)StringUtils.isAsciiPrintable((CharSequence)"A"));
        StringUtilsIsTest.assertEquals((boolean)true, (boolean)StringUtils.isAsciiPrintable((CharSequence)"1"));
        StringUtilsIsTest.assertEquals((boolean)true, (boolean)StringUtils.isAsciiPrintable((CharSequence)"Ceki"));
        StringUtilsIsTest.assertEquals((boolean)true, (boolean)StringUtils.isAsciiPrintable((CharSequence)"!ab2c~"));
        StringUtilsIsTest.assertEquals((boolean)true, (boolean)StringUtils.isAsciiPrintable((CharSequence)"1000"));
        StringUtilsIsTest.assertEquals((boolean)true, (boolean)StringUtils.isAsciiPrintable((CharSequence)"10 00"));
        StringUtilsIsTest.assertEquals((boolean)false, (boolean)StringUtils.isAsciiPrintable((CharSequence)"10\t00"));
        StringUtilsIsTest.assertEquals((boolean)true, (boolean)StringUtils.isAsciiPrintable((CharSequence)"10.00"));
        StringUtilsIsTest.assertEquals((boolean)true, (boolean)StringUtils.isAsciiPrintable((CharSequence)"10,00"));
        StringUtilsIsTest.assertEquals((boolean)true, (boolean)StringUtils.isAsciiPrintable((CharSequence)"!ab-c~"));
        StringUtilsIsTest.assertEquals((boolean)true, (boolean)StringUtils.isAsciiPrintable((CharSequence)"hkHK=Hik6i?UGH_KJgU7.tUJgKJ*GI87GI,kug"));
        StringUtilsIsTest.assertEquals((boolean)true, (boolean)StringUtils.isAsciiPrintable((CharSequence)" "));
        StringUtilsIsTest.assertEquals((boolean)true, (boolean)StringUtils.isAsciiPrintable((CharSequence)"!"));
        StringUtilsIsTest.assertEquals((boolean)true, (boolean)StringUtils.isAsciiPrintable((CharSequence)"~"));
        StringUtilsIsTest.assertEquals((boolean)false, (boolean)StringUtils.isAsciiPrintable((CharSequence)"\u007f"));
        StringUtilsIsTest.assertEquals((boolean)true, (boolean)StringUtils.isAsciiPrintable((CharSequence)"G?lc?"));
        StringUtilsIsTest.assertEquals((boolean)true, (boolean)StringUtils.isAsciiPrintable((CharSequence)"=?iso-8859-1?Q?G=FClc=FC?="));
        StringUtilsIsTest.assertEquals((boolean)false, (boolean)StringUtils.isAsciiPrintable((CharSequence)"G\u00fclc\u00fc"));
    }

    public void testIsNumeric() {
        StringUtilsIsTest.assertEquals((boolean)false, (boolean)StringUtils.isNumeric(null));
        StringUtilsIsTest.assertEquals((boolean)false, (boolean)StringUtils.isNumeric((CharSequence)""));
        StringUtilsIsTest.assertEquals((boolean)false, (boolean)StringUtils.isNumeric((CharSequence)" "));
        StringUtilsIsTest.assertEquals((boolean)false, (boolean)StringUtils.isNumeric((CharSequence)"a"));
        StringUtilsIsTest.assertEquals((boolean)false, (boolean)StringUtils.isNumeric((CharSequence)"A"));
        StringUtilsIsTest.assertEquals((boolean)false, (boolean)StringUtils.isNumeric((CharSequence)"kgKgKgKgkgkGkjkjlJlOKLgHdGdHgl"));
        StringUtilsIsTest.assertEquals((boolean)false, (boolean)StringUtils.isNumeric((CharSequence)"ham kso"));
        StringUtilsIsTest.assertEquals((boolean)true, (boolean)StringUtils.isNumeric((CharSequence)"1"));
        StringUtilsIsTest.assertEquals((boolean)true, (boolean)StringUtils.isNumeric((CharSequence)"1000"));
        StringUtilsIsTest.assertEquals((boolean)false, (boolean)StringUtils.isNumeric((CharSequence)"2.3"));
        StringUtilsIsTest.assertEquals((boolean)false, (boolean)StringUtils.isNumeric((CharSequence)"10 00"));
        StringUtilsIsTest.assertEquals((boolean)false, (boolean)StringUtils.isNumeric((CharSequence)"hkHKHik6iUGHKJgU7tUJgKJGI87GIkug"));
        StringUtilsIsTest.assertEquals((boolean)false, (boolean)StringUtils.isNumeric((CharSequence)"_"));
        StringUtilsIsTest.assertEquals((boolean)false, (boolean)StringUtils.isNumeric((CharSequence)"hkHKHik*khbkuh"));
    }

    public void testIsNumericSpace() {
        StringUtilsIsTest.assertEquals((boolean)false, (boolean)StringUtils.isNumericSpace(null));
        StringUtilsIsTest.assertEquals((boolean)true, (boolean)StringUtils.isNumericSpace((CharSequence)""));
        StringUtilsIsTest.assertEquals((boolean)true, (boolean)StringUtils.isNumericSpace((CharSequence)" "));
        StringUtilsIsTest.assertEquals((boolean)false, (boolean)StringUtils.isNumericSpace((CharSequence)"a"));
        StringUtilsIsTest.assertEquals((boolean)false, (boolean)StringUtils.isNumericSpace((CharSequence)"A"));
        StringUtilsIsTest.assertEquals((boolean)false, (boolean)StringUtils.isNumericSpace((CharSequence)"kgKgKgKgkgkGkjkjlJlOKLgHdGdHgl"));
        StringUtilsIsTest.assertEquals((boolean)false, (boolean)StringUtils.isNumericSpace((CharSequence)"ham kso"));
        StringUtilsIsTest.assertEquals((boolean)true, (boolean)StringUtils.isNumericSpace((CharSequence)"1"));
        StringUtilsIsTest.assertEquals((boolean)true, (boolean)StringUtils.isNumericSpace((CharSequence)"1000"));
        StringUtilsIsTest.assertEquals((boolean)false, (boolean)StringUtils.isNumericSpace((CharSequence)"2.3"));
        StringUtilsIsTest.assertEquals((boolean)true, (boolean)StringUtils.isNumericSpace((CharSequence)"10 00"));
        StringUtilsIsTest.assertEquals((boolean)false, (boolean)StringUtils.isNumericSpace((CharSequence)"hkHKHik6iUGHKJgU7tUJgKJGI87GIkug"));
        StringUtilsIsTest.assertEquals((boolean)false, (boolean)StringUtils.isNumericSpace((CharSequence)"_"));
        StringUtilsIsTest.assertEquals((boolean)false, (boolean)StringUtils.isNumericSpace((CharSequence)"hkHKHik*khbkuh"));
    }
}

