/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import junit.framework.TestCase;
import org.apache.commons.lang3.StringUtils;

public class StringUtilsSubstringTest
extends TestCase {
    private static final String FOO = "foo";
    private static final String BAR = "bar";
    private static final String BAZ = "baz";
    private static final String FOOBAR = "foobar";
    private static final String SENTENCE = "foo bar baz";

    public StringUtilsSubstringTest(String name) {
        super(name);
    }

    public void testSubstring_StringInt() {
        StringUtilsSubstringTest.assertEquals(null, (String)StringUtils.substring(null, (int)0));
        StringUtilsSubstringTest.assertEquals((String)"", (String)StringUtils.substring((String)"", (int)0));
        StringUtilsSubstringTest.assertEquals((String)"", (String)StringUtils.substring((String)"", (int)2));
        StringUtilsSubstringTest.assertEquals((String)"", (String)StringUtils.substring((String)SENTENCE, (int)80));
        StringUtilsSubstringTest.assertEquals((String)BAZ, (String)StringUtils.substring((String)SENTENCE, (int)8));
        StringUtilsSubstringTest.assertEquals((String)BAZ, (String)StringUtils.substring((String)SENTENCE, (int)-3));
        StringUtilsSubstringTest.assertEquals((String)SENTENCE, (String)StringUtils.substring((String)SENTENCE, (int)0));
        StringUtilsSubstringTest.assertEquals((String)"abc", (String)StringUtils.substring((String)"abc", (int)-4));
        StringUtilsSubstringTest.assertEquals((String)"abc", (String)StringUtils.substring((String)"abc", (int)-3));
        StringUtilsSubstringTest.assertEquals((String)"bc", (String)StringUtils.substring((String)"abc", (int)-2));
        StringUtilsSubstringTest.assertEquals((String)"c", (String)StringUtils.substring((String)"abc", (int)-1));
        StringUtilsSubstringTest.assertEquals((String)"abc", (String)StringUtils.substring((String)"abc", (int)0));
        StringUtilsSubstringTest.assertEquals((String)"bc", (String)StringUtils.substring((String)"abc", (int)1));
        StringUtilsSubstringTest.assertEquals((String)"c", (String)StringUtils.substring((String)"abc", (int)2));
        StringUtilsSubstringTest.assertEquals((String)"", (String)StringUtils.substring((String)"abc", (int)3));
        StringUtilsSubstringTest.assertEquals((String)"", (String)StringUtils.substring((String)"abc", (int)4));
    }

    public void testSubstring_StringIntInt() {
        StringUtilsSubstringTest.assertEquals(null, (String)StringUtils.substring(null, (int)0, (int)0));
        StringUtilsSubstringTest.assertEquals(null, (String)StringUtils.substring(null, (int)1, (int)2));
        StringUtilsSubstringTest.assertEquals((String)"", (String)StringUtils.substring((String)"", (int)0, (int)0));
        StringUtilsSubstringTest.assertEquals((String)"", (String)StringUtils.substring((String)"", (int)1, (int)2));
        StringUtilsSubstringTest.assertEquals((String)"", (String)StringUtils.substring((String)"", (int)-2, (int)-1));
        StringUtilsSubstringTest.assertEquals((String)"", (String)StringUtils.substring((String)SENTENCE, (int)8, (int)6));
        StringUtilsSubstringTest.assertEquals((String)FOO, (String)StringUtils.substring((String)SENTENCE, (int)0, (int)3));
        StringUtilsSubstringTest.assertEquals((String)"o", (String)StringUtils.substring((String)SENTENCE, (int)-9, (int)3));
        StringUtilsSubstringTest.assertEquals((String)FOO, (String)StringUtils.substring((String)SENTENCE, (int)0, (int)-8));
        StringUtilsSubstringTest.assertEquals((String)"o", (String)StringUtils.substring((String)SENTENCE, (int)-9, (int)-8));
        StringUtilsSubstringTest.assertEquals((String)SENTENCE, (String)StringUtils.substring((String)SENTENCE, (int)0, (int)80));
        StringUtilsSubstringTest.assertEquals((String)"", (String)StringUtils.substring((String)SENTENCE, (int)2, (int)2));
        StringUtilsSubstringTest.assertEquals((String)"b", (String)StringUtils.substring((String)"abc", (int)-2, (int)-1));
    }

    public void testLeft_String() {
        StringUtilsSubstringTest.assertSame(null, (Object)StringUtils.left(null, (int)-1));
        StringUtilsSubstringTest.assertSame(null, (Object)StringUtils.left(null, (int)0));
        StringUtilsSubstringTest.assertSame(null, (Object)StringUtils.left(null, (int)2));
        StringUtilsSubstringTest.assertEquals((String)"", (String)StringUtils.left((String)"", (int)-1));
        StringUtilsSubstringTest.assertEquals((String)"", (String)StringUtils.left((String)"", (int)0));
        StringUtilsSubstringTest.assertEquals((String)"", (String)StringUtils.left((String)"", (int)2));
        StringUtilsSubstringTest.assertEquals((String)"", (String)StringUtils.left((String)FOOBAR, (int)-1));
        StringUtilsSubstringTest.assertEquals((String)"", (String)StringUtils.left((String)FOOBAR, (int)0));
        StringUtilsSubstringTest.assertEquals((String)FOO, (String)StringUtils.left((String)FOOBAR, (int)3));
        StringUtilsSubstringTest.assertSame((Object)FOOBAR, (Object)StringUtils.left((String)FOOBAR, (int)80));
    }

    public void testRight_String() {
        StringUtilsSubstringTest.assertSame(null, (Object)StringUtils.right(null, (int)-1));
        StringUtilsSubstringTest.assertSame(null, (Object)StringUtils.right(null, (int)0));
        StringUtilsSubstringTest.assertSame(null, (Object)StringUtils.right(null, (int)2));
        StringUtilsSubstringTest.assertEquals((String)"", (String)StringUtils.right((String)"", (int)-1));
        StringUtilsSubstringTest.assertEquals((String)"", (String)StringUtils.right((String)"", (int)0));
        StringUtilsSubstringTest.assertEquals((String)"", (String)StringUtils.right((String)"", (int)2));
        StringUtilsSubstringTest.assertEquals((String)"", (String)StringUtils.right((String)FOOBAR, (int)-1));
        StringUtilsSubstringTest.assertEquals((String)"", (String)StringUtils.right((String)FOOBAR, (int)0));
        StringUtilsSubstringTest.assertEquals((String)BAR, (String)StringUtils.right((String)FOOBAR, (int)3));
        StringUtilsSubstringTest.assertSame((Object)FOOBAR, (Object)StringUtils.right((String)FOOBAR, (int)80));
    }

    public void testMid_String() {
        StringUtilsSubstringTest.assertSame(null, (Object)StringUtils.mid(null, (int)-1, (int)0));
        StringUtilsSubstringTest.assertSame(null, (Object)StringUtils.mid(null, (int)0, (int)-1));
        StringUtilsSubstringTest.assertSame(null, (Object)StringUtils.mid(null, (int)3, (int)0));
        StringUtilsSubstringTest.assertSame(null, (Object)StringUtils.mid(null, (int)3, (int)2));
        StringUtilsSubstringTest.assertEquals((String)"", (String)StringUtils.mid((String)"", (int)0, (int)-1));
        StringUtilsSubstringTest.assertEquals((String)"", (String)StringUtils.mid((String)"", (int)0, (int)0));
        StringUtilsSubstringTest.assertEquals((String)"", (String)StringUtils.mid((String)"", (int)0, (int)2));
        StringUtilsSubstringTest.assertEquals((String)"", (String)StringUtils.mid((String)FOOBAR, (int)3, (int)-1));
        StringUtilsSubstringTest.assertEquals((String)"", (String)StringUtils.mid((String)FOOBAR, (int)3, (int)0));
        StringUtilsSubstringTest.assertEquals((String)"b", (String)StringUtils.mid((String)FOOBAR, (int)3, (int)1));
        StringUtilsSubstringTest.assertEquals((String)FOO, (String)StringUtils.mid((String)FOOBAR, (int)0, (int)3));
        StringUtilsSubstringTest.assertEquals((String)BAR, (String)StringUtils.mid((String)FOOBAR, (int)3, (int)3));
        StringUtilsSubstringTest.assertEquals((String)FOOBAR, (String)StringUtils.mid((String)FOOBAR, (int)0, (int)80));
        StringUtilsSubstringTest.assertEquals((String)BAR, (String)StringUtils.mid((String)FOOBAR, (int)3, (int)80));
        StringUtilsSubstringTest.assertEquals((String)"", (String)StringUtils.mid((String)FOOBAR, (int)9, (int)3));
        StringUtilsSubstringTest.assertEquals((String)FOO, (String)StringUtils.mid((String)FOOBAR, (int)-1, (int)3));
    }

    public void testSubstringBefore_StringString() {
        StringUtilsSubstringTest.assertEquals((String)FOO, (String)StringUtils.substringBefore((String)"fooXXbarXXbaz", (String)"XX"));
        StringUtilsSubstringTest.assertEquals(null, (String)StringUtils.substringBefore(null, null));
        StringUtilsSubstringTest.assertEquals(null, (String)StringUtils.substringBefore(null, (String)""));
        StringUtilsSubstringTest.assertEquals(null, (String)StringUtils.substringBefore(null, (String)"XX"));
        StringUtilsSubstringTest.assertEquals((String)"", (String)StringUtils.substringBefore((String)"", null));
        StringUtilsSubstringTest.assertEquals((String)"", (String)StringUtils.substringBefore((String)"", (String)""));
        StringUtilsSubstringTest.assertEquals((String)"", (String)StringUtils.substringBefore((String)"", (String)"XX"));
        StringUtilsSubstringTest.assertEquals((String)FOO, (String)StringUtils.substringBefore((String)FOO, null));
        StringUtilsSubstringTest.assertEquals((String)FOO, (String)StringUtils.substringBefore((String)FOO, (String)"b"));
        StringUtilsSubstringTest.assertEquals((String)"f", (String)StringUtils.substringBefore((String)"foot", (String)"o"));
        StringUtilsSubstringTest.assertEquals((String)"", (String)StringUtils.substringBefore((String)"abc", (String)"a"));
        StringUtilsSubstringTest.assertEquals((String)"a", (String)StringUtils.substringBefore((String)"abcba", (String)"b"));
        StringUtilsSubstringTest.assertEquals((String)"ab", (String)StringUtils.substringBefore((String)"abc", (String)"c"));
        StringUtilsSubstringTest.assertEquals((String)"", (String)StringUtils.substringBefore((String)"abc", (String)""));
    }

    public void testSubstringAfter_StringString() {
        StringUtilsSubstringTest.assertEquals((String)"barXXbaz", (String)StringUtils.substringAfter((String)"fooXXbarXXbaz", (String)"XX"));
        StringUtilsSubstringTest.assertEquals(null, (String)StringUtils.substringAfter(null, null));
        StringUtilsSubstringTest.assertEquals(null, (String)StringUtils.substringAfter(null, (String)""));
        StringUtilsSubstringTest.assertEquals(null, (String)StringUtils.substringAfter(null, (String)"XX"));
        StringUtilsSubstringTest.assertEquals((String)"", (String)StringUtils.substringAfter((String)"", null));
        StringUtilsSubstringTest.assertEquals((String)"", (String)StringUtils.substringAfter((String)"", (String)""));
        StringUtilsSubstringTest.assertEquals((String)"", (String)StringUtils.substringAfter((String)"", (String)"XX"));
        StringUtilsSubstringTest.assertEquals((String)"", (String)StringUtils.substringAfter((String)FOO, null));
        StringUtilsSubstringTest.assertEquals((String)"ot", (String)StringUtils.substringAfter((String)"foot", (String)"o"));
        StringUtilsSubstringTest.assertEquals((String)"bc", (String)StringUtils.substringAfter((String)"abc", (String)"a"));
        StringUtilsSubstringTest.assertEquals((String)"cba", (String)StringUtils.substringAfter((String)"abcba", (String)"b"));
        StringUtilsSubstringTest.assertEquals((String)"", (String)StringUtils.substringAfter((String)"abc", (String)"c"));
        StringUtilsSubstringTest.assertEquals((String)"abc", (String)StringUtils.substringAfter((String)"abc", (String)""));
        StringUtilsSubstringTest.assertEquals((String)"", (String)StringUtils.substringAfter((String)"abc", (String)"d"));
    }

    public void testSubstringBeforeLast_StringString() {
        StringUtilsSubstringTest.assertEquals((String)"fooXXbar", (String)StringUtils.substringBeforeLast((String)"fooXXbarXXbaz", (String)"XX"));
        StringUtilsSubstringTest.assertEquals(null, (String)StringUtils.substringBeforeLast(null, null));
        StringUtilsSubstringTest.assertEquals(null, (String)StringUtils.substringBeforeLast(null, (String)""));
        StringUtilsSubstringTest.assertEquals(null, (String)StringUtils.substringBeforeLast(null, (String)"XX"));
        StringUtilsSubstringTest.assertEquals((String)"", (String)StringUtils.substringBeforeLast((String)"", null));
        StringUtilsSubstringTest.assertEquals((String)"", (String)StringUtils.substringBeforeLast((String)"", (String)""));
        StringUtilsSubstringTest.assertEquals((String)"", (String)StringUtils.substringBeforeLast((String)"", (String)"XX"));
        StringUtilsSubstringTest.assertEquals((String)FOO, (String)StringUtils.substringBeforeLast((String)FOO, null));
        StringUtilsSubstringTest.assertEquals((String)FOO, (String)StringUtils.substringBeforeLast((String)FOO, (String)"b"));
        StringUtilsSubstringTest.assertEquals((String)"fo", (String)StringUtils.substringBeforeLast((String)FOO, (String)"o"));
        StringUtilsSubstringTest.assertEquals((String)"abc\r\n", (String)StringUtils.substringBeforeLast((String)"abc\r\n", (String)"d"));
        StringUtilsSubstringTest.assertEquals((String)"abc", (String)StringUtils.substringBeforeLast((String)"abcdabc", (String)"d"));
        StringUtilsSubstringTest.assertEquals((String)"abcdabc", (String)StringUtils.substringBeforeLast((String)"abcdabcd", (String)"d"));
        StringUtilsSubstringTest.assertEquals((String)"a", (String)StringUtils.substringBeforeLast((String)"abc", (String)"b"));
        StringUtilsSubstringTest.assertEquals((String)"abc ", (String)StringUtils.substringBeforeLast((String)"abc \n", (String)"\n"));
        StringUtilsSubstringTest.assertEquals((String)"a", (String)StringUtils.substringBeforeLast((String)"a", null));
        StringUtilsSubstringTest.assertEquals((String)"a", (String)StringUtils.substringBeforeLast((String)"a", (String)""));
        StringUtilsSubstringTest.assertEquals((String)"", (String)StringUtils.substringBeforeLast((String)"a", (String)"a"));
    }

    public void testSubstringAfterLast_StringString() {
        StringUtilsSubstringTest.assertEquals((String)BAZ, (String)StringUtils.substringAfterLast((String)"fooXXbarXXbaz", (String)"XX"));
        StringUtilsSubstringTest.assertEquals(null, (String)StringUtils.substringAfterLast(null, null));
        StringUtilsSubstringTest.assertEquals(null, (String)StringUtils.substringAfterLast(null, (String)""));
        StringUtilsSubstringTest.assertEquals(null, (String)StringUtils.substringAfterLast(null, (String)"XX"));
        StringUtilsSubstringTest.assertEquals((String)"", (String)StringUtils.substringAfterLast((String)"", null));
        StringUtilsSubstringTest.assertEquals((String)"", (String)StringUtils.substringAfterLast((String)"", (String)""));
        StringUtilsSubstringTest.assertEquals((String)"", (String)StringUtils.substringAfterLast((String)"", (String)"a"));
        StringUtilsSubstringTest.assertEquals((String)"", (String)StringUtils.substringAfterLast((String)FOO, null));
        StringUtilsSubstringTest.assertEquals((String)"", (String)StringUtils.substringAfterLast((String)FOO, (String)"b"));
        StringUtilsSubstringTest.assertEquals((String)"t", (String)StringUtils.substringAfterLast((String)"foot", (String)"o"));
        StringUtilsSubstringTest.assertEquals((String)"bc", (String)StringUtils.substringAfterLast((String)"abc", (String)"a"));
        StringUtilsSubstringTest.assertEquals((String)"a", (String)StringUtils.substringAfterLast((String)"abcba", (String)"b"));
        StringUtilsSubstringTest.assertEquals((String)"", (String)StringUtils.substringAfterLast((String)"abc", (String)"c"));
        StringUtilsSubstringTest.assertEquals((String)"", (String)StringUtils.substringAfterLast((String)"", (String)"d"));
        StringUtilsSubstringTest.assertEquals((String)"", (String)StringUtils.substringAfterLast((String)"abc", (String)""));
    }

    public void testSubstringBetween_StringString() {
        StringUtilsSubstringTest.assertEquals(null, (String)StringUtils.substringBetween(null, (String)"tag"));
        StringUtilsSubstringTest.assertEquals((String)"", (String)StringUtils.substringBetween((String)"", (String)""));
        StringUtilsSubstringTest.assertEquals(null, (String)StringUtils.substringBetween((String)"", (String)"abc"));
        StringUtilsSubstringTest.assertEquals((String)"", (String)StringUtils.substringBetween((String)"    ", (String)" "));
        StringUtilsSubstringTest.assertEquals(null, (String)StringUtils.substringBetween((String)"abc", null));
        StringUtilsSubstringTest.assertEquals((String)"", (String)StringUtils.substringBetween((String)"abc", (String)""));
        StringUtilsSubstringTest.assertEquals(null, (String)StringUtils.substringBetween((String)"abc", (String)"a"));
        StringUtilsSubstringTest.assertEquals((String)"bc", (String)StringUtils.substringBetween((String)"abca", (String)"a"));
        StringUtilsSubstringTest.assertEquals((String)"bc", (String)StringUtils.substringBetween((String)"abcabca", (String)"a"));
        StringUtilsSubstringTest.assertEquals((String)BAR, (String)StringUtils.substringBetween((String)"\nbar\n", (String)"\n"));
    }

    public void testSubstringBetween_StringStringString() {
        StringUtilsSubstringTest.assertEquals(null, (String)StringUtils.substringBetween(null, (String)"", (String)""));
        StringUtilsSubstringTest.assertEquals(null, (String)StringUtils.substringBetween((String)"", null, (String)""));
        StringUtilsSubstringTest.assertEquals(null, (String)StringUtils.substringBetween((String)"", (String)"", null));
        StringUtilsSubstringTest.assertEquals((String)"", (String)StringUtils.substringBetween((String)"", (String)"", (String)""));
        StringUtilsSubstringTest.assertEquals((String)"", (String)StringUtils.substringBetween((String)FOO, (String)"", (String)""));
        StringUtilsSubstringTest.assertEquals(null, (String)StringUtils.substringBetween((String)FOO, (String)"", (String)"]"));
        StringUtilsSubstringTest.assertEquals(null, (String)StringUtils.substringBetween((String)FOO, (String)"[", (String)"]"));
        StringUtilsSubstringTest.assertEquals((String)"", (String)StringUtils.substringBetween((String)"    ", (String)" ", (String)"  "));
        StringUtilsSubstringTest.assertEquals((String)BAR, (String)StringUtils.substringBetween((String)"<foo>bar</foo>", (String)"<foo>", (String)"</foo>"));
    }

    public void testSubstringsBetween_StringStringString() {
        String[] results = StringUtils.substringsBetween((String)"[one], [two], [three]", (String)"[", (String)"]");
        StringUtilsSubstringTest.assertEquals((int)3, (int)results.length);
        StringUtilsSubstringTest.assertEquals((String)"one", (String)results[0]);
        StringUtilsSubstringTest.assertEquals((String)"two", (String)results[1]);
        StringUtilsSubstringTest.assertEquals((String)"three", (String)results[2]);
        results = StringUtils.substringsBetween((String)"[one], [two], three", (String)"[", (String)"]");
        StringUtilsSubstringTest.assertEquals((int)2, (int)results.length);
        StringUtilsSubstringTest.assertEquals((String)"one", (String)results[0]);
        StringUtilsSubstringTest.assertEquals((String)"two", (String)results[1]);
        results = StringUtils.substringsBetween((String)"[one], [two], three]", (String)"[", (String)"]");
        StringUtilsSubstringTest.assertEquals((int)2, (int)results.length);
        StringUtilsSubstringTest.assertEquals((String)"one", (String)results[0]);
        StringUtilsSubstringTest.assertEquals((String)"two", (String)results[1]);
        results = StringUtils.substringsBetween((String)"[one], two], three]", (String)"[", (String)"]");
        StringUtilsSubstringTest.assertEquals((int)1, (int)results.length);
        StringUtilsSubstringTest.assertEquals((String)"one", (String)results[0]);
        results = StringUtils.substringsBetween((String)"one], two], [three]", (String)"[", (String)"]");
        StringUtilsSubstringTest.assertEquals((int)1, (int)results.length);
        StringUtilsSubstringTest.assertEquals((String)"three", (String)results[0]);
        results = StringUtils.substringsBetween((String)"aabhellobabnonba", (String)"ab", (String)"ba");
        StringUtilsSubstringTest.assertEquals((int)1, (int)results.length);
        StringUtilsSubstringTest.assertEquals((String)"hello", (String)results[0]);
        results = StringUtils.substringsBetween((String)"one, two, three", (String)"[", (String)"]");
        StringUtilsSubstringTest.assertNull((Object)results);
        results = StringUtils.substringsBetween((String)"[one, two, three", (String)"[", (String)"]");
        StringUtilsSubstringTest.assertNull((Object)results);
        results = StringUtils.substringsBetween((String)"one, two, three]", (String)"[", (String)"]");
        StringUtilsSubstringTest.assertNull((Object)results);
        results = StringUtils.substringsBetween((String)"[one], [two], [three]", (String)"[", null);
        StringUtilsSubstringTest.assertNull((Object)results);
        results = StringUtils.substringsBetween((String)"[one], [two], [three]", null, (String)"]");
        StringUtilsSubstringTest.assertNull((Object)results);
        results = StringUtils.substringsBetween((String)"[one], [two], [three]", (String)"", (String)"");
        StringUtilsSubstringTest.assertNull((Object)results);
        results = StringUtils.substringsBetween(null, (String)"[", (String)"]");
        StringUtilsSubstringTest.assertNull((Object)results);
        results = StringUtils.substringsBetween((String)"", (String)"[", (String)"]");
        StringUtilsSubstringTest.assertEquals((int)0, (int)results.length);
    }

    public void testCountMatches_String() {
        StringUtilsSubstringTest.assertEquals((int)0, (int)StringUtils.countMatches(null, null));
        StringUtilsSubstringTest.assertEquals((int)0, (int)StringUtils.countMatches((CharSequence)"blah", null));
        StringUtilsSubstringTest.assertEquals((int)0, (int)StringUtils.countMatches(null, (CharSequence)"DD"));
        StringUtilsSubstringTest.assertEquals((int)0, (int)StringUtils.countMatches((CharSequence)"x", (CharSequence)""));
        StringUtilsSubstringTest.assertEquals((int)0, (int)StringUtils.countMatches((CharSequence)"", (CharSequence)""));
        StringUtilsSubstringTest.assertEquals((int)3, (int)StringUtils.countMatches((CharSequence)"one long someone sentence of one", (CharSequence)"one"));
        StringUtilsSubstringTest.assertEquals((int)0, (int)StringUtils.countMatches((CharSequence)"one long someone sentence of one", (CharSequence)"two"));
        StringUtilsSubstringTest.assertEquals((int)4, (int)StringUtils.countMatches((CharSequence)"oooooooooooo", (CharSequence)"ooo"));
    }
}

