/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import java.util.ArrayList;
import java.util.HashMap;
import junit.framework.TestCase;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.lang3.builder.ToStringStyleTest;

public class DefaultToStringStyleTest
extends TestCase {
    private final Integer base = new Integer(5);
    private final String baseStr = this.base.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(this.base));

    public DefaultToStringStyleTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        ToStringBuilder.setDefaultStyle((ToStringStyle)ToStringStyle.DEFAULT_STYLE);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        ToStringBuilder.setDefaultStyle((ToStringStyle)ToStringStyle.DEFAULT_STYLE);
    }

    public void testBlank() {
        DefaultToStringStyleTest.assertEquals((String)(this.baseStr + "[]"), (String)new ToStringBuilder((Object)this.base).toString());
    }

    public void testAppendSuper() {
        DefaultToStringStyleTest.assertEquals((String)(this.baseStr + "[]"), (String)new ToStringBuilder((Object)this.base).appendSuper("Integer@8888[]").toString());
        DefaultToStringStyleTest.assertEquals((String)(this.baseStr + "[<null>]"), (String)new ToStringBuilder((Object)this.base).appendSuper("Integer@8888[<null>]").toString());
        DefaultToStringStyleTest.assertEquals((String)(this.baseStr + "[a=hello]"), (String)new ToStringBuilder((Object)this.base).appendSuper("Integer@8888[]").append("a", (Object)"hello").toString());
        DefaultToStringStyleTest.assertEquals((String)(this.baseStr + "[<null>,a=hello]"), (String)new ToStringBuilder((Object)this.base).appendSuper("Integer@8888[<null>]").append("a", (Object)"hello").toString());
        DefaultToStringStyleTest.assertEquals((String)(this.baseStr + "[a=hello]"), (String)new ToStringBuilder((Object)this.base).appendSuper(null).append("a", (Object)"hello").toString());
    }

    public void testObject() {
        Integer i3 = new Integer(3);
        Integer i4 = new Integer(4);
        DefaultToStringStyleTest.assertEquals((String)(this.baseStr + "[<null>]"), (String)new ToStringBuilder((Object)this.base).append((Object)null).toString());
        DefaultToStringStyleTest.assertEquals((String)(this.baseStr + "[3]"), (String)new ToStringBuilder((Object)this.base).append((Object)i3).toString());
        DefaultToStringStyleTest.assertEquals((String)(this.baseStr + "[a=<null>]"), (String)new ToStringBuilder((Object)this.base).append("a", (Object)null).toString());
        DefaultToStringStyleTest.assertEquals((String)(this.baseStr + "[a=3]"), (String)new ToStringBuilder((Object)this.base).append("a", (Object)i3).toString());
        DefaultToStringStyleTest.assertEquals((String)(this.baseStr + "[a=3,b=4]"), (String)new ToStringBuilder((Object)this.base).append("a", (Object)i3).append("b", (Object)i4).toString());
        DefaultToStringStyleTest.assertEquals((String)(this.baseStr + "[a=<Integer>]"), (String)new ToStringBuilder((Object)this.base).append("a", (Object)i3, false).toString());
        DefaultToStringStyleTest.assertEquals((String)(this.baseStr + "[a=<size=0>]"), (String)new ToStringBuilder((Object)this.base).append("a", new ArrayList(), false).toString());
        DefaultToStringStyleTest.assertEquals((String)(this.baseStr + "[a=[]]"), (String)new ToStringBuilder((Object)this.base).append("a", new ArrayList(), true).toString());
        DefaultToStringStyleTest.assertEquals((String)(this.baseStr + "[a=<size=0>]"), (String)new ToStringBuilder((Object)this.base).append("a", new HashMap(), false).toString());
        DefaultToStringStyleTest.assertEquals((String)(this.baseStr + "[a={}]"), (String)new ToStringBuilder((Object)this.base).append("a", new HashMap(), true).toString());
        DefaultToStringStyleTest.assertEquals((String)(this.baseStr + "[a=<size=0>]"), (String)new ToStringBuilder((Object)this.base).append("a", (Object)new String[0], false).toString());
        DefaultToStringStyleTest.assertEquals((String)(this.baseStr + "[a={}]"), (String)new ToStringBuilder((Object)this.base).append("a", (Object)new String[0], true).toString());
    }

    public void testPerson() {
        ToStringStyleTest.Person p = new ToStringStyleTest.Person();
        p.name = "John Doe";
        p.age = 33;
        p.smoker = false;
        String pBaseStr = p.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(p));
        DefaultToStringStyleTest.assertEquals((String)(pBaseStr + "[name=John Doe,age=33,smoker=false]"), (String)new ToStringBuilder((Object)p).append("name", (Object)p.name).append("age", p.age).append("smoker", p.smoker).toString());
    }

    public void testLong() {
        DefaultToStringStyleTest.assertEquals((String)(this.baseStr + "[3]"), (String)new ToStringBuilder((Object)this.base).append(3L).toString());
        DefaultToStringStyleTest.assertEquals((String)(this.baseStr + "[a=3]"), (String)new ToStringBuilder((Object)this.base).append("a", 3L).toString());
        DefaultToStringStyleTest.assertEquals((String)(this.baseStr + "[a=3,b=4]"), (String)new ToStringBuilder((Object)this.base).append("a", 3L).append("b", 4L).toString());
    }

    public void testObjectArray() {
        Object[] array = new Object[]{null, this.base, new int[]{3, 6}};
        DefaultToStringStyleTest.assertEquals((String)(this.baseStr + "[{<null>,5,{3,6}}]"), (String)new ToStringBuilder((Object)this.base).append(array).toString());
        DefaultToStringStyleTest.assertEquals((String)(this.baseStr + "[{<null>,5,{3,6}}]"), (String)new ToStringBuilder((Object)this.base).append((Object)array).toString());
        array = null;
        DefaultToStringStyleTest.assertEquals((String)(this.baseStr + "[<null>]"), (String)new ToStringBuilder((Object)this.base).append(array).toString());
        DefaultToStringStyleTest.assertEquals((String)(this.baseStr + "[<null>]"), (String)new ToStringBuilder((Object)this.base).append((Object)array).toString());
    }

    public void testLongArray() {
        long[] array = new long[]{1L, 2L, -3L, 4L};
        DefaultToStringStyleTest.assertEquals((String)(this.baseStr + "[{1,2,-3,4}]"), (String)new ToStringBuilder((Object)this.base).append(array).toString());
        DefaultToStringStyleTest.assertEquals((String)(this.baseStr + "[{1,2,-3,4}]"), (String)new ToStringBuilder((Object)this.base).append((Object)array).toString());
        array = null;
        DefaultToStringStyleTest.assertEquals((String)(this.baseStr + "[<null>]"), (String)new ToStringBuilder((Object)this.base).append(array).toString());
        DefaultToStringStyleTest.assertEquals((String)(this.baseStr + "[<null>]"), (String)new ToStringBuilder((Object)this.base).append((Object)array).toString());
    }

    public void testLongArrayArray() {
        Object array = new long[][]{{1L, 2L}, null, {5L}};
        DefaultToStringStyleTest.assertEquals((String)(this.baseStr + "[{{1,2},<null>,{5}}]"), (String)new ToStringBuilder((Object)this.base).append((Object[])array).toString());
        DefaultToStringStyleTest.assertEquals((String)(this.baseStr + "[{{1,2},<null>,{5}}]"), (String)new ToStringBuilder((Object)this.base).append(array).toString());
        array = null;
        DefaultToStringStyleTest.assertEquals((String)(this.baseStr + "[<null>]"), (String)new ToStringBuilder((Object)this.base).append((Object[])array).toString());
        DefaultToStringStyleTest.assertEquals((String)(this.baseStr + "[<null>]"), (String)new ToStringBuilder((Object)this.base).append(array).toString());
    }
}

