/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import junit.framework.TestCase;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class HashCodeBuilderAndEqualsBuilderTest
extends TestCase {
    public HashCodeBuilderAndEqualsBuilderTest(String name) {
        super(name);
    }

    public void testInteger(boolean testTransients) {
        Integer i1 = new Integer(12345);
        Integer i2 = new Integer(12345);
        this.assertEqualsAndHashCodeContract(i1, i2, testTransients);
    }

    public void testInteger() {
        this.testInteger(false);
    }

    public void testIntegerWithTransients() {
        this.testInteger(true);
    }

    public void testFixture() {
        this.testFixture(false);
    }

    public void testFixtureWithTransients() {
        this.testFixture(true);
    }

    public void testFixture(boolean testTransients) {
        this.assertEqualsAndHashCodeContract(new TestFixture(2, 'c', "Test", 2), new TestFixture(2, 'c', "Test", 2), testTransients);
        this.assertEqualsAndHashCodeContract(new AllTransientFixture(2, 'c', "Test", 2), new AllTransientFixture(2, 'c', "Test", 2), testTransients);
        this.assertEqualsAndHashCodeContract(new SubTestFixture(2, 'c', "Test", 2, "Same"), new SubTestFixture(2, 'c', "Test", 2, "Same"), testTransients);
        this.assertEqualsAndHashCodeContract(new SubAllTransientFixture(2, 'c', "Test", 2, "Same"), new SubAllTransientFixture(2, 'c', "Test", 2, "Same"), testTransients);
    }

    public void assertEqualsAndHashCodeContract(Object lhs, Object rhs, boolean testTransients) {
        if (EqualsBuilder.reflectionEquals((Object)lhs, (Object)rhs, (boolean)testTransients)) {
            HashCodeBuilderAndEqualsBuilderTest.assertEquals((int)HashCodeBuilder.reflectionHashCode((Object)lhs, (boolean)testTransients), (int)HashCodeBuilder.reflectionHashCode((Object)rhs, (boolean)testTransients));
            HashCodeBuilderAndEqualsBuilderTest.assertEquals((int)HashCodeBuilder.reflectionHashCode((Object)lhs, (boolean)testTransients), (int)HashCodeBuilder.reflectionHashCode((Object)rhs, (boolean)testTransients));
            HashCodeBuilderAndEqualsBuilderTest.assertEquals((int)HashCodeBuilder.reflectionHashCode((Object)lhs, (boolean)testTransients), (int)HashCodeBuilder.reflectionHashCode((Object)rhs, (boolean)testTransients));
        }
    }

    static class SubAllTransientFixture
    extends AllTransientFixture {
        transient String tString;

        SubAllTransientFixture(int i, char c, String string, short s, String tString) {
            super(i, c, string, s);
            this.tString = tString;
        }
    }

    static class AllTransientFixture {
        transient int i;
        transient char c;
        transient String string;
        transient short s;

        AllTransientFixture(int i, char c, String string, short s) {
            this.i = i;
            this.c = c;
            this.string = string;
            this.s = s;
        }
    }

    static class SubTestFixture
    extends TestFixture {
        transient String tString;

        SubTestFixture(int i, char c, String string, short s, String tString) {
            super(i, c, string, s);
            this.tString = tString;
        }
    }

    static class TestFixture {
        int i;
        char c;
        String string;
        short s;

        TestFixture(int i, char c, String string, short s) {
            this.i = i;
            this.c = c;
            this.string = string;
            this.s = s;
        }
    }
}

