/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import java.util.ArrayList;
import java.util.Collection;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

public class ReflectionToStringBuilderExcludeTest
extends TestCase {
    private static final String NOT_SECRET_FIELD = "showField";
    private static final String NOT_SECRET_VALUE = "Hello World!";
    private static final String SECRET_FIELD = "secretField";
    private static final String SECRET_VALUE = "secret value";

    public void test_toStringExclude() {
        String toString = ReflectionToStringBuilder.toStringExclude((Object)new TestFixture(), (String[])new String[]{SECRET_FIELD});
        this.validateSecretFieldAbsent(toString);
    }

    public void test_toStringExcludeArray() {
        String toString = ReflectionToStringBuilder.toStringExclude((Object)new TestFixture(), (String[])new String[]{SECRET_FIELD});
        this.validateSecretFieldAbsent(toString);
    }

    public void test_toStringExcludeArrayWithNull() {
        String toString = ReflectionToStringBuilder.toStringExclude((Object)new TestFixture(), (String[])new String[]{null});
        this.validateSecretFieldPresent(toString);
    }

    public void test_toStringExcludeArrayWithNulls() {
        String toString = ReflectionToStringBuilder.toStringExclude((Object)new TestFixture(), (String[])new String[]{null, null});
        this.validateSecretFieldPresent(toString);
    }

    public void test_toStringExcludeCollection() {
        ArrayList<String> excludeList = new ArrayList<String>();
        excludeList.add(SECRET_FIELD);
        String toString = ReflectionToStringBuilder.toStringExclude((Object)new TestFixture(), excludeList);
        this.validateSecretFieldAbsent(toString);
    }

    public void test_toStringExcludeCollectionWithNull() {
        ArrayList<Object> excludeList = new ArrayList<Object>();
        excludeList.add(null);
        String toString = ReflectionToStringBuilder.toStringExclude((Object)new TestFixture(), excludeList);
        this.validateSecretFieldPresent(toString);
    }

    public void test_toStringExcludeCollectionWithNulls() {
        ArrayList<Object> excludeList = new ArrayList<Object>();
        excludeList.add(null);
        excludeList.add(null);
        String toString = ReflectionToStringBuilder.toStringExclude((Object)new TestFixture(), excludeList);
        this.validateSecretFieldPresent(toString);
    }

    public void test_toStringExcludeEmptyArray() {
        String toString = ReflectionToStringBuilder.toStringExclude((Object)new TestFixture(), (String[])ArrayUtils.EMPTY_STRING_ARRAY);
        this.validateSecretFieldPresent(toString);
    }

    public void test_toStringExcludeEmptyCollection() {
        String toString = ReflectionToStringBuilder.toStringExclude((Object)new TestFixture(), new ArrayList());
        this.validateSecretFieldPresent(toString);
    }

    public void test_toStringExcludeNullArray() {
        String toString = ReflectionToStringBuilder.toStringExclude((Object)new TestFixture(), (String[])null);
        this.validateSecretFieldPresent(toString);
    }

    public void test_toStringExcludeNullCollection() {
        String toString = ReflectionToStringBuilder.toStringExclude((Object)new TestFixture(), (Collection)null);
        this.validateSecretFieldPresent(toString);
    }

    private void validateNonSecretField(String toString) {
        Assert.assertTrue((toString.indexOf(NOT_SECRET_FIELD) > -1 ? 1 : 0) != 0);
        Assert.assertTrue((toString.indexOf(NOT_SECRET_VALUE) > -1 ? 1 : 0) != 0);
    }

    private void validateSecretFieldAbsent(String toString) {
        Assert.assertEquals((int)-1, (int)toString.indexOf(SECRET_VALUE));
        this.validateNonSecretField(toString);
    }

    private void validateSecretFieldPresent(String toString) {
        Assert.assertTrue((toString.indexOf(SECRET_VALUE) > 0 ? 1 : 0) != 0);
        this.validateNonSecretField(toString);
    }

    class TestFixture {
        private String secretField = "secret value";
        private String showField = "Hello World!";

        TestFixture() {
        }
    }
}

