/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import java.util.ArrayList;
import java.util.HashMap;
import junit.framework.TestCase;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class ToStringBuilderTest
extends TestCase {
    private final Integer base = new Integer(5);
    private final String baseStr = this.base.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(this.base));

    public ToStringBuilderTest(String name) {
        super(name);
    }

    public void testConstructorEx1() {
        ToStringBuilderTest.assertEquals((String)"<null>", (String)new ToStringBuilder(null).toString());
    }

    public void testConstructorEx2() {
        ToStringBuilderTest.assertEquals((String)"<null>", (String)new ToStringBuilder(null, null).toString());
        new ToStringBuilder((Object)this.base, null).toString();
    }

    public void testConstructorEx3() {
        ToStringBuilderTest.assertEquals((String)"<null>", (String)new ToStringBuilder(null, null, null).toString());
        new ToStringBuilder((Object)this.base, null, null);
        new ToStringBuilder((Object)this.base, ToStringStyle.DEFAULT_STYLE, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetSetDefault() {
        try {
            ToStringBuilder.setDefaultStyle((ToStringStyle)ToStringStyle.NO_FIELD_NAMES_STYLE);
            ToStringBuilderTest.assertSame((Object)ToStringStyle.NO_FIELD_NAMES_STYLE, (Object)ToStringBuilder.getDefaultStyle());
        }
        finally {
            ToStringBuilder.setDefaultStyle((ToStringStyle)ToStringStyle.DEFAULT_STYLE);
        }
    }

    public void testSetDefaultEx() {
        try {
            ToStringBuilder.setDefaultStyle(null);
        }
        catch (IllegalArgumentException ex) {
            return;
        }
        ToStringBuilderTest.fail();
    }

    public void testBlank() {
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[]"), (String)new ToStringBuilder((Object)this.base).toString());
    }

    public void testReflectionInteger() {
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[value=5]"), (String)ToStringBuilder.reflectionToString((Object)this.base));
    }

    public void testReflectionCharacter() {
        Character c = new Character('A');
        ToStringBuilderTest.assertEquals((String)(this.toBaseString(c) + "[value=A]"), (String)ToStringBuilder.reflectionToString((Object)c));
    }

    public void testReflectionBoolean() {
        Boolean b = Boolean.TRUE;
        ToStringBuilderTest.assertEquals((String)(this.toBaseString(b) + "[value=true]"), (String)ToStringBuilder.reflectionToString((Object)b));
        b = Boolean.FALSE;
        ToStringBuilderTest.assertEquals((String)(this.toBaseString(b) + "[value=false]"), (String)ToStringBuilder.reflectionToString((Object)b));
    }

    private String toBaseString(Object o) {
        return o.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(o));
    }

    public void assertReflectionArray(String expected, Object actual) {
        if (actual == null) {
            return;
        }
        ToStringBuilderTest.assertEquals((String)expected, (String)ToStringBuilder.reflectionToString((Object)actual));
        ToStringBuilderTest.assertEquals((String)expected, (String)ToStringBuilder.reflectionToString((Object)actual, null));
        ToStringBuilderTest.assertEquals((String)expected, (String)ToStringBuilder.reflectionToString((Object)actual, null, (boolean)true));
        ToStringBuilderTest.assertEquals((String)expected, (String)ToStringBuilder.reflectionToString((Object)actual, null, (boolean)false));
    }

    public void testReflectionObjectArray() {
        Object[] array = new Object[]{null, this.base, new int[]{3, 6}};
        String baseStr = this.toBaseString(array);
        ToStringBuilderTest.assertEquals((String)(baseStr + "[{<null>,5,{3,6}}]"), (String)ToStringBuilder.reflectionToString((Object)array));
        array = null;
        this.assertReflectionArray("<null>", array);
        this.validateNullToStringStyleRegistry();
    }

    public void testReflectionLongArray() {
        long[] array = new long[]{1L, 2L, -3L, 4L};
        String baseStr = this.toBaseString(array);
        ToStringBuilderTest.assertEquals((String)(baseStr + "[{1,2,-3,4}]"), (String)ToStringBuilder.reflectionToString((Object)array));
        array = null;
        this.assertReflectionArray("<null>", array);
        this.validateNullToStringStyleRegistry();
    }

    public void testReflectionIntArray() {
        int[] array = new int[]{1, 2, -3, 4};
        String baseStr = this.toBaseString(array);
        ToStringBuilderTest.assertEquals((String)(baseStr + "[{1,2,-3,4}]"), (String)ToStringBuilder.reflectionToString((Object)array));
        array = null;
        this.assertReflectionArray("<null>", array);
        this.validateNullToStringStyleRegistry();
    }

    public void testReflectionShortArray() {
        short[] array = new short[]{1, 2, -3, 4};
        String baseStr = this.toBaseString(array);
        ToStringBuilderTest.assertEquals((String)(baseStr + "[{1,2,-3,4}]"), (String)ToStringBuilder.reflectionToString((Object)array));
        array = null;
        this.assertReflectionArray("<null>", array);
        this.validateNullToStringStyleRegistry();
    }

    public void testReflectionyteArray() {
        byte[] array = new byte[]{1, 2, -3, 4};
        String baseStr = this.toBaseString(array);
        ToStringBuilderTest.assertEquals((String)(baseStr + "[{1,2,-3,4}]"), (String)ToStringBuilder.reflectionToString((Object)array));
        array = null;
        this.assertReflectionArray("<null>", array);
        this.validateNullToStringStyleRegistry();
    }

    public void testReflectionCharArray() {
        char[] array = new char[]{'A', '2', '_', 'D'};
        String baseStr = this.toBaseString(array);
        ToStringBuilderTest.assertEquals((String)(baseStr + "[{A,2,_,D}]"), (String)ToStringBuilder.reflectionToString((Object)array));
        array = null;
        this.assertReflectionArray("<null>", array);
        this.validateNullToStringStyleRegistry();
    }

    public void testReflectionDoubleArray() {
        double[] array = new double[]{1.0, 2.9876, -3.00001, 4.3};
        String baseStr = this.toBaseString(array);
        ToStringBuilderTest.assertEquals((String)(baseStr + "[{1.0,2.9876,-3.00001,4.3}]"), (String)ToStringBuilder.reflectionToString((Object)array));
        array = null;
        this.assertReflectionArray("<null>", array);
        this.validateNullToStringStyleRegistry();
    }

    public void testReflectionFloatArray() {
        float[] array = new float[]{1.0f, 2.9876f, -3.00001f, 4.3f};
        String baseStr = this.toBaseString(array);
        ToStringBuilderTest.assertEquals((String)(baseStr + "[{1.0,2.9876,-3.00001,4.3}]"), (String)ToStringBuilder.reflectionToString((Object)array));
        array = null;
        this.assertReflectionArray("<null>", array);
        this.validateNullToStringStyleRegistry();
    }

    public void testReflectionBooleanArray() {
        boolean[] array = new boolean[]{true, false, false};
        String baseStr = this.toBaseString(array);
        ToStringBuilderTest.assertEquals((String)(baseStr + "[{true,false,false}]"), (String)ToStringBuilder.reflectionToString((Object)array));
        array = null;
        this.assertReflectionArray("<null>", array);
        this.validateNullToStringStyleRegistry();
    }

    public void testReflectionFloatArrayArray() {
        Object array = new float[][]{{1.0f, 2.29686f}, null, {Float.NaN}};
        String baseStr = this.toBaseString(array);
        ToStringBuilderTest.assertEquals((String)(baseStr + "[{{1.0,2.29686},<null>,{NaN}}]"), (String)ToStringBuilder.reflectionToString((Object)array));
        array = null;
        this.assertReflectionArray("<null>", array);
        this.validateNullToStringStyleRegistry();
    }

    public void testReflectionLongArrayArray() {
        Object array = new long[][]{{1L, 2L}, null, {5L}};
        String baseStr = this.toBaseString(array);
        ToStringBuilderTest.assertEquals((String)(baseStr + "[{{1,2},<null>,{5}}]"), (String)ToStringBuilder.reflectionToString((Object)array));
        array = null;
        this.assertReflectionArray("<null>", array);
        this.validateNullToStringStyleRegistry();
    }

    public void testReflectionIntArrayArray() {
        Object array = new int[][]{{1, 2}, null, {5}};
        String baseStr = this.toBaseString(array);
        ToStringBuilderTest.assertEquals((String)(baseStr + "[{{1,2},<null>,{5}}]"), (String)ToStringBuilder.reflectionToString((Object)array));
        array = null;
        this.assertReflectionArray("<null>", array);
        this.validateNullToStringStyleRegistry();
    }

    public void testReflectionhortArrayArray() {
        Object array = new short[][]{{1, 2}, null, {5}};
        String baseStr = this.toBaseString(array);
        ToStringBuilderTest.assertEquals((String)(baseStr + "[{{1,2},<null>,{5}}]"), (String)ToStringBuilder.reflectionToString((Object)array));
        array = null;
        this.assertReflectionArray("<null>", array);
        this.validateNullToStringStyleRegistry();
    }

    public void testReflectionByteArrayArray() {
        Object array = new byte[][]{{1, 2}, null, {5}};
        String baseStr = this.toBaseString(array);
        ToStringBuilderTest.assertEquals((String)(baseStr + "[{{1,2},<null>,{5}}]"), (String)ToStringBuilder.reflectionToString((Object)array));
        array = null;
        this.assertReflectionArray("<null>", array);
        this.validateNullToStringStyleRegistry();
    }

    public void testReflectionCharArrayArray() {
        Object array = new char[][]{{'A', 'B'}, null, {'p'}};
        String baseStr = this.toBaseString(array);
        ToStringBuilderTest.assertEquals((String)(baseStr + "[{{A,B},<null>,{p}}]"), (String)ToStringBuilder.reflectionToString((Object)array));
        array = null;
        this.assertReflectionArray("<null>", array);
        this.validateNullToStringStyleRegistry();
    }

    public void testReflectionDoubleArrayArray() {
        Object array = new double[][]{{1.0, 2.29686}, null, {Double.NaN}};
        String baseStr = this.toBaseString(array);
        ToStringBuilderTest.assertEquals((String)(baseStr + "[{{1.0,2.29686},<null>,{NaN}}]"), (String)ToStringBuilder.reflectionToString((Object)array));
        array = null;
        this.assertReflectionArray("<null>", array);
        this.validateNullToStringStyleRegistry();
    }

    public void testReflectionBooleanArrayArray() {
        Object array = new boolean[][]{{true, false}, null, {false}};
        String baseStr = this.toBaseString(array);
        ToStringBuilderTest.assertEquals((String)(baseStr + "[{{true,false},<null>,{false}}]"), (String)ToStringBuilder.reflectionToString((Object)array));
        ToStringBuilderTest.assertEquals((String)(baseStr + "[{{true,false},<null>,{false}}]"), (String)ToStringBuilder.reflectionToString((Object)array));
        array = null;
        this.assertReflectionArray("<null>", array);
        this.validateNullToStringStyleRegistry();
    }

    public void testReflectionHierarchyArrayList() {
        ArrayList base = new ArrayList();
        String baseStr = this.toBaseString(base);
        ToStringBuilderTest.assertEquals((String)(baseStr + "[elementData={<null>,<null>,<null>,<null>,<null>,<null>,<null>,<null>,<null>,<null>},size=0,modCount=0]"), (String)ToStringBuilder.reflectionToString(base, null, (boolean)true));
        ToStringBuilderTest.assertEquals((String)(baseStr + "[size=0]"), (String)ToStringBuilder.reflectionToString(base, null, (boolean)false));
        this.validateNullToStringStyleRegistry();
    }

    public void testReflectionHierarchy() {
        ReflectionTestFixtureA baseA = new ReflectionTestFixtureA();
        String baseStr = this.toBaseString(baseA);
        ToStringBuilderTest.assertEquals((String)(baseStr + "[a=a]"), (String)ToStringBuilder.reflectionToString((Object)baseA));
        ToStringBuilderTest.assertEquals((String)(baseStr + "[a=a]"), (String)ToStringBuilder.reflectionToString((Object)baseA, null));
        ToStringBuilderTest.assertEquals((String)(baseStr + "[a=a]"), (String)ToStringBuilder.reflectionToString((Object)baseA, null, (boolean)false));
        ToStringBuilderTest.assertEquals((String)(baseStr + "[a=a,transientA=t]"), (String)ToStringBuilder.reflectionToString((Object)baseA, null, (boolean)true));
        ToStringBuilderTest.assertEquals((String)(baseStr + "[a=a]"), (String)ToStringBuilder.reflectionToString((Object)baseA, null, (boolean)false, null));
        ToStringBuilderTest.assertEquals((String)(baseStr + "[a=a]"), (String)ToStringBuilder.reflectionToString((Object)baseA, null, (boolean)false, Object.class));
        ToStringBuilderTest.assertEquals((String)(baseStr + "[a=a]"), (String)ToStringBuilder.reflectionToString((Object)baseA, null, (boolean)false, ReflectionTestFixtureA.class));
        ReflectionTestFixtureB baseB = new ReflectionTestFixtureB();
        baseStr = this.toBaseString(baseB);
        ToStringBuilderTest.assertEquals((String)(baseStr + "[b=b,a=a]"), (String)ToStringBuilder.reflectionToString((Object)baseB));
        ToStringBuilderTest.assertEquals((String)(baseStr + "[b=b,a=a]"), (String)ToStringBuilder.reflectionToString((Object)baseB));
        ToStringBuilderTest.assertEquals((String)(baseStr + "[b=b,a=a]"), (String)ToStringBuilder.reflectionToString((Object)baseB, null));
        ToStringBuilderTest.assertEquals((String)(baseStr + "[b=b,a=a]"), (String)ToStringBuilder.reflectionToString((Object)baseB, null, (boolean)false));
        ToStringBuilderTest.assertEquals((String)(baseStr + "[b=b,transientB=t,a=a,transientA=t]"), (String)ToStringBuilder.reflectionToString((Object)baseB, null, (boolean)true));
        ToStringBuilderTest.assertEquals((String)(baseStr + "[b=b,a=a]"), (String)ToStringBuilder.reflectionToString((Object)baseB, null, (boolean)false, null));
        ToStringBuilderTest.assertEquals((String)(baseStr + "[b=b,a=a]"), (String)ToStringBuilder.reflectionToString((Object)baseB, null, (boolean)false, Object.class));
        ToStringBuilderTest.assertEquals((String)(baseStr + "[b=b,a=a]"), (String)ToStringBuilder.reflectionToString((Object)baseB, null, (boolean)false, ReflectionTestFixtureA.class));
        ToStringBuilderTest.assertEquals((String)(baseStr + "[b=b]"), (String)ToStringBuilder.reflectionToString((Object)baseB, null, (boolean)false, ReflectionTestFixtureB.class));
        this.validateNullToStringStyleRegistry();
    }

    public void testInnerClassReflection() {
        Outer outer = new Outer();
        ToStringBuilderTest.assertEquals((String)(this.toBaseString(outer) + "[inner=" + this.toBaseString(outer.inner) + "[]]"), (String)outer.toString());
    }

    public void testReflectionArrayCycle() throws Exception {
        Object[] objects;
        objects[0] = objects = new Object[1];
        ToStringBuilderTest.assertEquals((String)(this.toBaseString(objects) + "[{" + this.toBaseString(objects) + "}]"), (String)ToStringBuilder.reflectionToString((Object)objects));
        this.validateNullToStringStyleRegistry();
    }

    public void testReflectionArrayCycleLevel2() throws Exception {
        Object[] objectsLevel2 = new Object[1];
        Object[] objects = new Object[]{objectsLevel2};
        objectsLevel2[0] = objects;
        ToStringBuilderTest.assertEquals((String)(this.toBaseString(objects) + "[{{" + this.toBaseString(objects) + "}}]"), (String)ToStringBuilder.reflectionToString((Object)objects));
        ToStringBuilderTest.assertEquals((String)(this.toBaseString(objectsLevel2) + "[{{" + this.toBaseString(objectsLevel2) + "}}]"), (String)ToStringBuilder.reflectionToString((Object)objectsLevel2));
        this.validateNullToStringStyleRegistry();
    }

    public void testReflectionArrayArrayCycle() throws Exception {
        Object[][] objects;
        objects[0][0] = objects = new Object[2][2];
        objects[0][1] = objects;
        objects[1][0] = objects;
        objects[1][1] = objects;
        String basicToString = this.toBaseString(objects);
        ToStringBuilderTest.assertEquals((String)(basicToString + "[{{" + basicToString + "," + basicToString + "},{" + basicToString + "," + basicToString + "}}]"), (String)ToStringBuilder.reflectionToString((Object)objects));
        this.validateNullToStringStyleRegistry();
    }

    public void testSimpleReflectionObjectCycle() throws Exception {
        SimpleReflectionTestFixture simple = new SimpleReflectionTestFixture();
        simple.o = simple;
        ToStringBuilderTest.assertEquals((String)(this.toBaseString(simple) + "[o=" + this.toBaseString(simple) + "]"), (String)simple.toString());
        this.validateNullToStringStyleRegistry();
    }

    public void testSelfInstanceVarReflectionObjectCycle() throws Exception {
        SelfInstanceVarReflectionTestFixture test = new SelfInstanceVarReflectionTestFixture();
        ToStringBuilderTest.assertEquals((String)(this.toBaseString(test) + "[typeIsSelf=" + this.toBaseString(test) + "]"), (String)test.toString());
        this.validateNullToStringStyleRegistry();
    }

    public void testSelfInstanceTwoVarsReflectionObjectCycle() throws Exception {
        SelfInstanceTwoVarsReflectionTestFixture test = new SelfInstanceTwoVarsReflectionTestFixture();
        ToStringBuilderTest.assertEquals((String)(this.toBaseString(test) + "[typeIsSelf=" + this.toBaseString(test) + ",otherType=" + test.getOtherType().toString() + "]"), (String)test.toString());
        this.validateNullToStringStyleRegistry();
    }

    public void testReflectionObjectCycle() throws Exception {
        ReflectionTestCycleB b;
        ReflectionTestCycleA a = new ReflectionTestCycleA();
        a.b = b = new ReflectionTestCycleB();
        b.a = a;
        ToStringBuilderTest.assertEquals((String)(this.toBaseString(a) + "[b=" + this.toBaseString(b) + "[a=" + this.toBaseString(a) + "]]"), (String)a.toString());
        this.validateNullToStringStyleRegistry();
    }

    public void testReflectionArrayAndObjectCycle() throws Exception {
        Object[] objects = new Object[1];
        SimpleReflectionTestFixture simple = new SimpleReflectionTestFixture(objects);
        objects[0] = simple;
        ToStringBuilderTest.assertEquals((String)(this.toBaseString(objects) + "[{" + this.toBaseString(simple) + "[o=" + this.toBaseString(objects) + "]" + "}]"), (String)ToStringBuilder.reflectionToString((Object)objects));
        ToStringBuilderTest.assertEquals((String)(this.toBaseString(simple) + "[o={" + this.toBaseString(simple) + "}]"), (String)ToStringBuilder.reflectionToString((Object)simple));
        this.validateNullToStringStyleRegistry();
    }

    void validateNullToStringStyleRegistry() {
        if (ToStringStyle.getRegistry() != null) {
            System.out.println(ToStringStyle.getRegistry());
        }
        ToStringBuilderTest.assertNull((Object)ToStringStyle.getRegistry());
    }

    public void testAppendSuper() {
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[]"), (String)new ToStringBuilder((Object)this.base).appendSuper("Integer@8888[]").toString());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[<null>]"), (String)new ToStringBuilder((Object)this.base).appendSuper("Integer@8888[<null>]").toString());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[a=hello]"), (String)new ToStringBuilder((Object)this.base).appendSuper("Integer@8888[]").append("a", (Object)"hello").toString());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[<null>,a=hello]"), (String)new ToStringBuilder((Object)this.base).appendSuper("Integer@8888[<null>]").append("a", (Object)"hello").toString());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[a=hello]"), (String)new ToStringBuilder((Object)this.base).appendSuper(null).append("a", (Object)"hello").toString());
    }

    public void testAppendToString() {
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[]"), (String)new ToStringBuilder((Object)this.base).appendToString("Integer@8888[]").toString());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[<null>]"), (String)new ToStringBuilder((Object)this.base).appendToString("Integer@8888[<null>]").toString());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[a=hello]"), (String)new ToStringBuilder((Object)this.base).appendToString("Integer@8888[]").append("a", (Object)"hello").toString());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[<null>,a=hello]"), (String)new ToStringBuilder((Object)this.base).appendToString("Integer@8888[<null>]").append("a", (Object)"hello").toString());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[a=hello]"), (String)new ToStringBuilder((Object)this.base).appendToString(null).append("a", (Object)"hello").toString());
    }

    public void testObject() {
        Integer i3 = new Integer(3);
        Integer i4 = new Integer(4);
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[<null>]"), (String)new ToStringBuilder((Object)this.base).append((Object)null).toString());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[3]"), (String)new ToStringBuilder((Object)this.base).append((Object)i3).toString());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[a=<null>]"), (String)new ToStringBuilder((Object)this.base).append("a", (Object)null).toString());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[a=3]"), (String)new ToStringBuilder((Object)this.base).append("a", (Object)i3).toString());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[a=3,b=4]"), (String)new ToStringBuilder((Object)this.base).append("a", (Object)i3).append("b", (Object)i4).toString());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[a=<Integer>]"), (String)new ToStringBuilder((Object)this.base).append("a", (Object)i3, false).toString());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[a=<size=0>]"), (String)new ToStringBuilder((Object)this.base).append("a", new ArrayList(), false).toString());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[a=[]]"), (String)new ToStringBuilder((Object)this.base).append("a", new ArrayList(), true).toString());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[a=<size=0>]"), (String)new ToStringBuilder((Object)this.base).append("a", new HashMap(), false).toString());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[a={}]"), (String)new ToStringBuilder((Object)this.base).append("a", new HashMap(), true).toString());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[a=<size=0>]"), (String)new ToStringBuilder((Object)this.base).append("a", (Object)new String[0], false).toString());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[a={}]"), (String)new ToStringBuilder((Object)this.base).append("a", (Object)new String[0], true).toString());
    }

    public void testObjectBuild() {
        Integer i3 = new Integer(3);
        Integer i4 = new Integer(4);
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[<null>]"), (String)new ToStringBuilder((Object)this.base).append((Object)null).build());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[3]"), (String)new ToStringBuilder((Object)this.base).append((Object)i3).build());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[a=<null>]"), (String)new ToStringBuilder((Object)this.base).append("a", (Object)null).build());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[a=3]"), (String)new ToStringBuilder((Object)this.base).append("a", (Object)i3).build());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[a=3,b=4]"), (String)new ToStringBuilder((Object)this.base).append("a", (Object)i3).append("b", (Object)i4).build());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[a=<Integer>]"), (String)new ToStringBuilder((Object)this.base).append("a", (Object)i3, false).build());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[a=<size=0>]"), (String)new ToStringBuilder((Object)this.base).append("a", new ArrayList(), false).build());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[a=[]]"), (String)new ToStringBuilder((Object)this.base).append("a", new ArrayList(), true).build());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[a=<size=0>]"), (String)new ToStringBuilder((Object)this.base).append("a", new HashMap(), false).build());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[a={}]"), (String)new ToStringBuilder((Object)this.base).append("a", new HashMap(), true).build());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[a=<size=0>]"), (String)new ToStringBuilder((Object)this.base).append("a", (Object)new String[0], false).build());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[a={}]"), (String)new ToStringBuilder((Object)this.base).append("a", (Object)new String[0], true).build());
    }

    public void testLong() {
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[3]"), (String)new ToStringBuilder((Object)this.base).append(3L).toString());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[a=3]"), (String)new ToStringBuilder((Object)this.base).append("a", 3L).toString());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[a=3,b=4]"), (String)new ToStringBuilder((Object)this.base).append("a", 3L).append("b", 4L).toString());
    }

    public void testInt() {
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[3]"), (String)new ToStringBuilder((Object)this.base).append(3).toString());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[a=3]"), (String)new ToStringBuilder((Object)this.base).append("a", 3).toString());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[a=3,b=4]"), (String)new ToStringBuilder((Object)this.base).append("a", 3).append("b", 4).toString());
    }

    public void testShort() {
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[3]"), (String)new ToStringBuilder((Object)this.base).append((short)3).toString());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[a=3]"), (String)new ToStringBuilder((Object)this.base).append("a", (short)3).toString());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[a=3,b=4]"), (String)new ToStringBuilder((Object)this.base).append("a", (short)3).append("b", (short)4).toString());
    }

    public void testChar() {
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[A]"), (String)new ToStringBuilder((Object)this.base).append('A').toString());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[a=A]"), (String)new ToStringBuilder((Object)this.base).append("a", 'A').toString());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[a=A,b=B]"), (String)new ToStringBuilder((Object)this.base).append("a", 'A').append("b", 'B').toString());
    }

    public void testByte() {
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[3]"), (String)new ToStringBuilder((Object)this.base).append((byte)3).toString());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[a=3]"), (String)new ToStringBuilder((Object)this.base).append("a", (byte)3).toString());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[a=3,b=4]"), (String)new ToStringBuilder((Object)this.base).append("a", (byte)3).append("b", (byte)4).toString());
    }

    public void testDouble() {
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[3.2]"), (String)new ToStringBuilder((Object)this.base).append(3.2).toString());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[a=3.2]"), (String)new ToStringBuilder((Object)this.base).append("a", 3.2).toString());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[a=3.2,b=4.3]"), (String)new ToStringBuilder((Object)this.base).append("a", 3.2).append("b", 4.3).toString());
    }

    public void testFloat() {
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[3.2]"), (String)new ToStringBuilder((Object)this.base).append(3.2f).toString());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[a=3.2]"), (String)new ToStringBuilder((Object)this.base).append("a", 3.2f).toString());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[a=3.2,b=4.3]"), (String)new ToStringBuilder((Object)this.base).append("a", 3.2f).append("b", 4.3f).toString());
    }

    public void testBoolean() {
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[true]"), (String)new ToStringBuilder((Object)this.base).append(true).toString());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[a=true]"), (String)new ToStringBuilder((Object)this.base).append("a", true).toString());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[a=true,b=false]"), (String)new ToStringBuilder((Object)this.base).append("a", true).append("b", false).toString());
    }

    public void testObjectArray() {
        Object[] array = new Object[]{null, this.base, new int[]{3, 6}};
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[{<null>,5,{3,6}}]"), (String)new ToStringBuilder((Object)this.base).append(array).toString());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[{<null>,5,{3,6}}]"), (String)new ToStringBuilder((Object)this.base).append((Object)array).toString());
        array = null;
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[<null>]"), (String)new ToStringBuilder((Object)this.base).append(array).toString());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[<null>]"), (String)new ToStringBuilder((Object)this.base).append((Object)array).toString());
    }

    public void testLongArray() {
        long[] array = new long[]{1L, 2L, -3L, 4L};
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[{1,2,-3,4}]"), (String)new ToStringBuilder((Object)this.base).append(array).toString());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[{1,2,-3,4}]"), (String)new ToStringBuilder((Object)this.base).append((Object)array).toString());
        array = null;
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[<null>]"), (String)new ToStringBuilder((Object)this.base).append(array).toString());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[<null>]"), (String)new ToStringBuilder((Object)this.base).append((Object)array).toString());
    }

    public void testIntArray() {
        int[] array = new int[]{1, 2, -3, 4};
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[{1,2,-3,4}]"), (String)new ToStringBuilder((Object)this.base).append(array).toString());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[{1,2,-3,4}]"), (String)new ToStringBuilder((Object)this.base).append((Object)array).toString());
        array = null;
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[<null>]"), (String)new ToStringBuilder((Object)this.base).append(array).toString());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[<null>]"), (String)new ToStringBuilder((Object)this.base).append((Object)array).toString());
    }

    public void testShortArray() {
        short[] array = new short[]{1, 2, -3, 4};
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[{1,2,-3,4}]"), (String)new ToStringBuilder((Object)this.base).append(array).toString());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[{1,2,-3,4}]"), (String)new ToStringBuilder((Object)this.base).append((Object)array).toString());
        array = null;
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[<null>]"), (String)new ToStringBuilder((Object)this.base).append(array).toString());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[<null>]"), (String)new ToStringBuilder((Object)this.base).append((Object)array).toString());
    }

    public void testByteArray() {
        byte[] array = new byte[]{1, 2, -3, 4};
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[{1,2,-3,4}]"), (String)new ToStringBuilder((Object)this.base).append(array).toString());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[{1,2,-3,4}]"), (String)new ToStringBuilder((Object)this.base).append((Object)array).toString());
        array = null;
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[<null>]"), (String)new ToStringBuilder((Object)this.base).append(array).toString());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[<null>]"), (String)new ToStringBuilder((Object)this.base).append((Object)array).toString());
    }

    public void testCharArray() {
        char[] array = new char[]{'A', '2', '_', 'D'};
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[{A,2,_,D}]"), (String)new ToStringBuilder((Object)this.base).append(array).toString());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[{A,2,_,D}]"), (String)new ToStringBuilder((Object)this.base).append((Object)array).toString());
        array = null;
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[<null>]"), (String)new ToStringBuilder((Object)this.base).append(array).toString());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[<null>]"), (String)new ToStringBuilder((Object)this.base).append((Object)array).toString());
    }

    public void testDoubleArray() {
        double[] array = new double[]{1.0, 2.9876, -3.00001, 4.3};
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[{1.0,2.9876,-3.00001,4.3}]"), (String)new ToStringBuilder((Object)this.base).append(array).toString());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[{1.0,2.9876,-3.00001,4.3}]"), (String)new ToStringBuilder((Object)this.base).append((Object)array).toString());
        array = null;
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[<null>]"), (String)new ToStringBuilder((Object)this.base).append(array).toString());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[<null>]"), (String)new ToStringBuilder((Object)this.base).append((Object)array).toString());
    }

    public void testFloatArray() {
        float[] array = new float[]{1.0f, 2.9876f, -3.00001f, 4.3f};
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[{1.0,2.9876,-3.00001,4.3}]"), (String)new ToStringBuilder((Object)this.base).append(array).toString());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[{1.0,2.9876,-3.00001,4.3}]"), (String)new ToStringBuilder((Object)this.base).append((Object)array).toString());
        array = null;
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[<null>]"), (String)new ToStringBuilder((Object)this.base).append(array).toString());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[<null>]"), (String)new ToStringBuilder((Object)this.base).append((Object)array).toString());
    }

    public void testBooleanArray() {
        boolean[] array = new boolean[]{true, false, false};
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[{true,false,false}]"), (String)new ToStringBuilder((Object)this.base).append(array).toString());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[{true,false,false}]"), (String)new ToStringBuilder((Object)this.base).append((Object)array).toString());
        array = null;
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[<null>]"), (String)new ToStringBuilder((Object)this.base).append(array).toString());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[<null>]"), (String)new ToStringBuilder((Object)this.base).append((Object)array).toString());
    }

    public void testLongArrayArray() {
        Object array = new long[][]{{1L, 2L}, null, {5L}};
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[{{1,2},<null>,{5}}]"), (String)new ToStringBuilder((Object)this.base).append((Object[])array).toString());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[{{1,2},<null>,{5}}]"), (String)new ToStringBuilder((Object)this.base).append(array).toString());
        array = null;
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[<null>]"), (String)new ToStringBuilder((Object)this.base).append((Object[])array).toString());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[<null>]"), (String)new ToStringBuilder((Object)this.base).append(array).toString());
    }

    public void testIntArrayArray() {
        Object array = new int[][]{{1, 2}, null, {5}};
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[{{1,2},<null>,{5}}]"), (String)new ToStringBuilder((Object)this.base).append((Object[])array).toString());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[{{1,2},<null>,{5}}]"), (String)new ToStringBuilder((Object)this.base).append(array).toString());
        array = null;
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[<null>]"), (String)new ToStringBuilder((Object)this.base).append((Object[])array).toString());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[<null>]"), (String)new ToStringBuilder((Object)this.base).append(array).toString());
    }

    public void testShortArrayArray() {
        Object array = new short[][]{{1, 2}, null, {5}};
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[{{1,2},<null>,{5}}]"), (String)new ToStringBuilder((Object)this.base).append((Object[])array).toString());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[{{1,2},<null>,{5}}]"), (String)new ToStringBuilder((Object)this.base).append(array).toString());
        array = null;
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[<null>]"), (String)new ToStringBuilder((Object)this.base).append((Object[])array).toString());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[<null>]"), (String)new ToStringBuilder((Object)this.base).append(array).toString());
    }

    public void testByteArrayArray() {
        Object array = new byte[][]{{1, 2}, null, {5}};
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[{{1,2},<null>,{5}}]"), (String)new ToStringBuilder((Object)this.base).append((Object[])array).toString());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[{{1,2},<null>,{5}}]"), (String)new ToStringBuilder((Object)this.base).append(array).toString());
        array = null;
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[<null>]"), (String)new ToStringBuilder((Object)this.base).append((Object[])array).toString());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[<null>]"), (String)new ToStringBuilder((Object)this.base).append(array).toString());
    }

    public void testCharArrayArray() {
        Object array = new char[][]{{'A', 'B'}, null, {'p'}};
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[{{A,B},<null>,{p}}]"), (String)new ToStringBuilder((Object)this.base).append((Object[])array).toString());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[{{A,B},<null>,{p}}]"), (String)new ToStringBuilder((Object)this.base).append(array).toString());
        array = null;
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[<null>]"), (String)new ToStringBuilder((Object)this.base).append((Object[])array).toString());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[<null>]"), (String)new ToStringBuilder((Object)this.base).append(array).toString());
    }

    public void testDoubleArrayArray() {
        Object array = new double[][]{{1.0, 2.29686}, null, {Double.NaN}};
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[{{1.0,2.29686},<null>,{NaN}}]"), (String)new ToStringBuilder((Object)this.base).append((Object[])array).toString());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[{{1.0,2.29686},<null>,{NaN}}]"), (String)new ToStringBuilder((Object)this.base).append(array).toString());
        array = null;
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[<null>]"), (String)new ToStringBuilder((Object)this.base).append((Object[])array).toString());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[<null>]"), (String)new ToStringBuilder((Object)this.base).append(array).toString());
    }

    public void testFloatArrayArray() {
        Object array = new float[][]{{1.0f, 2.29686f}, null, {Float.NaN}};
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[{{1.0,2.29686},<null>,{NaN}}]"), (String)new ToStringBuilder((Object)this.base).append((Object[])array).toString());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[{{1.0,2.29686},<null>,{NaN}}]"), (String)new ToStringBuilder((Object)this.base).append(array).toString());
        array = null;
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[<null>]"), (String)new ToStringBuilder((Object)this.base).append((Object[])array).toString());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[<null>]"), (String)new ToStringBuilder((Object)this.base).append(array).toString());
    }

    public void testBooleanArrayArray() {
        Object array = new boolean[][]{{true, false}, null, {false}};
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[{{true,false},<null>,{false}}]"), (String)new ToStringBuilder((Object)this.base).append((Object[])array).toString());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[{{true,false},<null>,{false}}]"), (String)new ToStringBuilder((Object)this.base).append(array).toString());
        array = null;
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[<null>]"), (String)new ToStringBuilder((Object)this.base).append((Object[])array).toString());
        ToStringBuilderTest.assertEquals((String)(this.baseStr + "[<null>]"), (String)new ToStringBuilder((Object)this.base).append(array).toString());
    }

    public void testObjectCycle() {
        ObjectCycle a = new ObjectCycle();
        ObjectCycle b = new ObjectCycle();
        a.obj = b;
        b.obj = a;
        String expected = this.toBaseString(a) + "[" + this.toBaseString(b) + "[" + this.toBaseString(a) + "]]";
        ToStringBuilderTest.assertEquals((String)expected, (String)a.toString());
        this.validateNullToStringStyleRegistry();
    }

    public void testSimpleReflectionStatics() {
        SimpleReflectionStaticFieldsFixture instance1 = new SimpleReflectionStaticFieldsFixture();
        ToStringBuilderTest.assertEquals((String)(this.toBaseString(instance1) + "[staticString=staticString,staticInt=12345]"), (String)ReflectionToStringBuilder.toString((Object)instance1, null, (boolean)false, (boolean)true, SimpleReflectionStaticFieldsFixture.class));
        ToStringBuilderTest.assertEquals((String)(this.toBaseString(instance1) + "[staticString=staticString,staticInt=12345]"), (String)ReflectionToStringBuilder.toString((Object)instance1, null, (boolean)true, (boolean)true, SimpleReflectionStaticFieldsFixture.class));
        ToStringBuilderTest.assertEquals((Object)(this.toBaseString(instance1) + "[staticString=staticString,staticInt=12345]"), (Object)this.toStringWithStatics(instance1, null, SimpleReflectionStaticFieldsFixture.class));
        ToStringBuilderTest.assertEquals((Object)(this.toBaseString(instance1) + "[staticString=staticString,staticInt=12345]"), (Object)this.toStringWithStatics(instance1, null, SimpleReflectionStaticFieldsFixture.class));
    }

    public void testReflectionStatics() {
        ReflectionStaticFieldsFixture instance1 = new ReflectionStaticFieldsFixture();
        ToStringBuilderTest.assertEquals((String)(this.toBaseString(instance1) + "[staticString=staticString,staticInt=12345,instanceString=instanceString,instanceInt=67890]"), (String)ReflectionToStringBuilder.toString((Object)instance1, null, (boolean)false, (boolean)true, ReflectionStaticFieldsFixture.class));
        ToStringBuilderTest.assertEquals((String)(this.toBaseString(instance1) + "[staticString=staticString,staticInt=12345,staticTransientString=staticTransientString,staticTransientInt=54321,instanceString=instanceString,instanceInt=67890,transientString=transientString,transientInt=98765]"), (String)ReflectionToStringBuilder.toString((Object)instance1, null, (boolean)true, (boolean)true, ReflectionStaticFieldsFixture.class));
        ToStringBuilderTest.assertEquals((Object)(this.toBaseString(instance1) + "[staticString=staticString,staticInt=12345,instanceString=instanceString,instanceInt=67890]"), (Object)this.toStringWithStatics(instance1, null, ReflectionStaticFieldsFixture.class));
        ToStringBuilderTest.assertEquals((Object)(this.toBaseString(instance1) + "[staticString=staticString,staticInt=12345,instanceString=instanceString,instanceInt=67890]"), (Object)this.toStringWithStatics(instance1, null, ReflectionStaticFieldsFixture.class));
    }

    public void testInheritedReflectionStatics() {
        InheritedReflectionStaticFieldsFixture instance1 = new InheritedReflectionStaticFieldsFixture();
        ToStringBuilderTest.assertEquals((String)(this.toBaseString(instance1) + "[staticString2=staticString2,staticInt2=67890]"), (String)ReflectionToStringBuilder.toString((Object)instance1, null, (boolean)false, (boolean)true, InheritedReflectionStaticFieldsFixture.class));
        ToStringBuilderTest.assertEquals((String)(this.toBaseString(instance1) + "[staticString2=staticString2,staticInt2=67890,staticString=staticString,staticInt=12345]"), (String)ReflectionToStringBuilder.toString((Object)instance1, null, (boolean)false, (boolean)true, SimpleReflectionStaticFieldsFixture.class));
        ToStringBuilderTest.assertEquals((Object)(this.toBaseString(instance1) + "[staticString2=staticString2,staticInt2=67890,staticString=staticString,staticInt=12345]"), (Object)this.toStringWithStatics(instance1, null, SimpleReflectionStaticFieldsFixture.class));
        ToStringBuilderTest.assertEquals((Object)(this.toBaseString(instance1) + "[staticString2=staticString2,staticInt2=67890,staticString=staticString,staticInt=12345]"), (Object)this.toStringWithStatics(instance1, null, SimpleReflectionStaticFieldsFixture.class));
    }

    public Object toStringWithStatics(Object object, ToStringStyle style, Class reflectUpToClass) {
        return ReflectionToStringBuilder.toString((Object)object, (ToStringStyle)style, (boolean)false, (boolean)true, (Class)reflectUpToClass);
    }

    public void test_setUpToClass_valid() {
        Integer val = new Integer(5);
        ReflectionToStringBuilder test = new ReflectionToStringBuilder((Object)val);
        test.setUpToClass(Number.class);
    }

    public void test_setUpToClass_invalid() {
        Integer val = new Integer(5);
        ReflectionToStringBuilder test = new ReflectionToStringBuilder((Object)val);
        try {
            test.setUpToClass(String.class);
            ToStringBuilderTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testReflectionNull() {
        ToStringBuilderTest.assertEquals((String)"<null>", (String)ReflectionToStringBuilder.toString(null));
    }

    public void testAppendToStringUsingMultiLineStyle() {
        MultiLineTestObject obj = new MultiLineTestObject();
        ToStringBuilder testBuilder = new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).appendToString(obj.toString());
        ToStringBuilderTest.assertEquals((int)testBuilder.toString().indexOf("testInt=31337"), (int)-1);
    }

    class MultiLineTestObject {
        Integer i = new Integer(31337);

        MultiLineTestObject() {
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("testInt", (Object)this.i).toString();
        }
    }

    class InheritedReflectionStaticFieldsFixture
    extends SimpleReflectionStaticFieldsFixture {
        static final String staticString2 = "staticString2";
        static final int staticInt2 = 67890;

        InheritedReflectionStaticFieldsFixture() {
        }
    }

    class SimpleReflectionStaticFieldsFixture {
        static final String staticString = "staticString";
        static final int staticInt = 12345;

        SimpleReflectionStaticFieldsFixture() {
        }
    }

    class ReflectionStaticFieldsFixture {
        static final String staticString = "staticString";
        static final int staticInt = 12345;
        static final transient String staticTransientString = "staticTransientString";
        static final transient int staticTransientInt = 54321;
        String instanceString = "instanceString";
        int instanceInt = 67890;
        transient String transientString = "transientString";
        transient int transientInt = 98765;

        ReflectionStaticFieldsFixture() {
        }
    }

    static class ObjectCycle {
        Object obj;

        ObjectCycle() {
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append(this.obj).toString();
        }
    }

    private static class SelfInstanceTwoVarsReflectionTestFixture {
        private SelfInstanceTwoVarsReflectionTestFixture typeIsSelf = this;
        private String otherType = "The Other Type";

        public String getOtherType() {
            return this.otherType;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this);
        }
    }

    private static class SelfInstanceVarReflectionTestFixture {
        private SelfInstanceVarReflectionTestFixture typeIsSelf = this;

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this);
        }
    }

    static class SimpleReflectionTestFixture {
        Object o;

        public SimpleReflectionTestFixture() {
        }

        public SimpleReflectionTestFixture(Object o) {
            this.o = o;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this);
        }
    }

    static class ReflectionTestCycleB {
        ReflectionTestCycleA a;

        ReflectionTestCycleB() {
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this);
        }
    }

    static class ReflectionTestCycleA {
        ReflectionTestCycleB b;

        ReflectionTestCycleA() {
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this);
        }
    }

    static class Outer {
        Inner inner = new Inner();

        Outer() {
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this);
        }

        class Inner {
            Inner() {
            }

            public String toString() {
                return ToStringBuilder.reflectionToString((Object)this);
            }
        }
    }

    static class ReflectionTestFixtureB
    extends ReflectionTestFixtureA {
        private char b = (char)98;
        private transient char transientB = (char)116;

        ReflectionTestFixtureB() {
        }
    }

    static class ReflectionTestFixtureA {
        private char a = (char)97;
        private transient char transientA = (char)116;

        ReflectionTestFixtureA() {
        }
    }
}

