/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import junit.framework.TestCase;
import org.apache.commons.lang3.concurrent.CallableBackgroundInitializer;

public class CallableBackgroundInitializerTest
extends TestCase {
    private static final Integer RESULT = 42;

    public void testInitNullCallable() {
        try {
            new CallableBackgroundInitializer(null);
            CallableBackgroundInitializerTest.fail((String)"Could create instance without a Callable!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testInitExecutor() {
        ExecutorService exec = Executors.newSingleThreadExecutor();
        CallableBackgroundInitializer init = new CallableBackgroundInitializer((Callable)new TestCallable(), exec);
        CallableBackgroundInitializerTest.assertEquals((String)"Executor not set", (Object)exec, (Object)init.getExternalExecutor());
    }

    public void testInitExecutorNullCallable() {
        ExecutorService exec = Executors.newSingleThreadExecutor();
        try {
            new CallableBackgroundInitializer(null, exec);
            CallableBackgroundInitializerTest.fail((String)"Could create instance without a Callable!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testInitialize() throws Exception {
        TestCallable call = new TestCallable();
        CallableBackgroundInitializer init = new CallableBackgroundInitializer((Callable)call);
        CallableBackgroundInitializerTest.assertEquals((String)"Wrong result", (Object)RESULT, (Object)init.initialize());
        CallableBackgroundInitializerTest.assertEquals((String)"Wrong number of invocations", (int)1, (int)call.callCount);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TestCallable
    implements Callable<Integer> {
        int callCount;

        private TestCallable() {
        }

        @Override
        public Integer call() throws Exception {
            ++this.callCount;
            return RESULT;
        }
    }
}

