/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.ConcurrentInitializer;
import org.apache.commons.lang3.concurrent.ConcurrentRuntimeException;
import org.apache.commons.lang3.concurrent.ConcurrentUtils;
import org.apache.commons.lang3.concurrent.ConstantInitializer;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class ConcurrentUtilsTest {
    @Test(expected=IllegalArgumentException.class)
    public void testConcurrentExceptionCauseUnchecked() {
        new ConcurrentException((Throwable)new RuntimeException());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConcurrentExceptionCauseError() {
        new ConcurrentException("An error", (Throwable)new Error());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConcurrentExceptionCauseNull() {
        new ConcurrentException(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConcurrentRuntimeExceptionCauseUnchecked() {
        new ConcurrentRuntimeException((Throwable)new RuntimeException());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConcurrentRuntimeExceptionCauseError() {
        new ConcurrentRuntimeException("An error", (Throwable)new Error());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConcurrentRuntimeExceptionCauseNull() {
        new ConcurrentRuntimeException(null);
    }

    @Test
    public void testExtractCauseNull() {
        Assert.assertNull((String)"Non null result", (Object)((Object)ConcurrentUtils.extractCause(null)));
    }

    @Test
    public void testExtractCauseNullCause() {
        Assert.assertNull((String)"Non null result", (Object)((Object)ConcurrentUtils.extractCause((ExecutionException)new ExecutionException("Test", null))));
    }

    @Test
    public void testExtractCauseError() {
        AssertionError err = new AssertionError((Object)"Test");
        try {
            ConcurrentUtils.extractCause((ExecutionException)new ExecutionException((Throwable)((Object)err)));
            Assert.fail((String)"Error not thrown!");
        }
        catch (Error e) {
            Assert.assertEquals((String)"Wrong error", (Object)err, (Object)e);
        }
    }

    @Test
    public void testExtractCauseUncheckedException() {
        RuntimeException rex = new RuntimeException("Test");
        try {
            ConcurrentUtils.extractCause((ExecutionException)new ExecutionException(rex));
            Assert.fail((String)"Runtime exception not thrown!");
        }
        catch (RuntimeException r) {
            Assert.assertEquals((String)"Wrong exception", (Object)rex, (Object)r);
        }
    }

    @Test
    public void testExtractCauseChecked() {
        Exception ex = new Exception("Test");
        ConcurrentException cex = ConcurrentUtils.extractCause((ExecutionException)new ExecutionException(ex));
        Assert.assertSame((String)"Wrong cause", (Object)ex, (Object)cex.getCause());
    }

    @Test
    public void testExtractCauseUncheckedNull() {
        Assert.assertNull((String)"Non null result", (Object)ConcurrentUtils.extractCauseUnchecked(null));
    }

    @Test
    public void testExtractCauseUncheckedNullCause() {
        Assert.assertNull((String)"Non null result", (Object)ConcurrentUtils.extractCauseUnchecked((ExecutionException)new ExecutionException("Test", null)));
    }

    @Test
    public void testExtractCauseUncheckedError() {
        AssertionError err = new AssertionError((Object)"Test");
        try {
            ConcurrentUtils.extractCauseUnchecked((ExecutionException)new ExecutionException((Throwable)((Object)err)));
            Assert.fail((String)"Error not thrown!");
        }
        catch (Error e) {
            Assert.assertEquals((String)"Wrong error", (Object)err, (Object)e);
        }
    }

    @Test
    public void testExtractCauseUncheckedUncheckedException() {
        RuntimeException rex = new RuntimeException("Test");
        try {
            ConcurrentUtils.extractCauseUnchecked((ExecutionException)new ExecutionException(rex));
            Assert.fail((String)"Runtime exception not thrown!");
        }
        catch (RuntimeException r) {
            Assert.assertEquals((String)"Wrong exception", (Object)rex, (Object)r);
        }
    }

    @Test
    public void testExtractCauseUncheckedChecked() {
        Exception ex = new Exception("Test");
        ConcurrentRuntimeException cex = ConcurrentUtils.extractCauseUnchecked((ExecutionException)new ExecutionException(ex));
        Assert.assertSame((String)"Wrong cause", (Object)ex, (Object)cex.getCause());
    }

    @Test
    public void testHandleCauseError() throws ConcurrentException {
        AssertionError err = new AssertionError((Object)"Test");
        try {
            ConcurrentUtils.handleCause((ExecutionException)new ExecutionException((Throwable)((Object)err)));
            Assert.fail((String)"Error not thrown!");
        }
        catch (Error e) {
            Assert.assertEquals((String)"Wrong error", (Object)err, (Object)e);
        }
    }

    @Test
    public void testHandleCauseUncheckedException() throws ConcurrentException {
        RuntimeException rex = new RuntimeException("Test");
        try {
            ConcurrentUtils.handleCause((ExecutionException)new ExecutionException(rex));
            Assert.fail((String)"Runtime exception not thrown!");
        }
        catch (RuntimeException r) {
            Assert.assertEquals((String)"Wrong exception", (Object)rex, (Object)r);
        }
    }

    @Test
    public void testHandleCauseChecked() {
        Exception ex = new Exception("Test");
        try {
            ConcurrentUtils.handleCause((ExecutionException)new ExecutionException(ex));
            Assert.fail((String)"ConcurrentException not thrown!");
        }
        catch (ConcurrentException cex) {
            Assert.assertEquals((String)"Wrong cause", (Object)ex, (Object)cex.getCause());
        }
    }

    @Test
    public void testHandleCauseNull() throws ConcurrentException {
        ConcurrentUtils.handleCause(null);
        ConcurrentUtils.handleCause((ExecutionException)new ExecutionException("Test", null));
    }

    @Test
    public void testHandleCauseUncheckedError() {
        AssertionError err = new AssertionError((Object)"Test");
        try {
            ConcurrentUtils.handleCauseUnchecked((ExecutionException)new ExecutionException((Throwable)((Object)err)));
            Assert.fail((String)"Error not thrown!");
        }
        catch (Error e) {
            Assert.assertEquals((String)"Wrong error", (Object)err, (Object)e);
        }
    }

    @Test
    public void testHandleCauseUncheckedUncheckedException() {
        RuntimeException rex = new RuntimeException("Test");
        try {
            ConcurrentUtils.handleCauseUnchecked((ExecutionException)new ExecutionException(rex));
            Assert.fail((String)"Runtime exception not thrown!");
        }
        catch (RuntimeException r) {
            Assert.assertEquals((String)"Wrong exception", (Object)rex, (Object)r);
        }
    }

    @Test
    public void testHandleCauseUncheckedChecked() {
        Exception ex = new Exception("Test");
        try {
            ConcurrentUtils.handleCauseUnchecked((ExecutionException)new ExecutionException(ex));
            Assert.fail((String)"ConcurrentRuntimeException not thrown!");
        }
        catch (ConcurrentRuntimeException crex) {
            Assert.assertEquals((String)"Wrong cause", (Object)ex, (Object)crex.getCause());
        }
    }

    @Test
    public void testHandleCauseUncheckedNull() {
        ConcurrentUtils.handleCauseUnchecked(null);
        ConcurrentUtils.handleCauseUnchecked((ExecutionException)new ExecutionException("Test", null));
    }

    @Test
    public void testInitializeNull() throws ConcurrentException {
        Assert.assertNull((String)"Got a result", (Object)ConcurrentUtils.initialize(null));
    }

    @Test
    public void testInitialize() throws ConcurrentException {
        ConcurrentInitializer init = (ConcurrentInitializer)EasyMock.createMock(ConcurrentInitializer.class);
        Object result = new Object();
        EasyMock.expect((Object)init.get()).andReturn(result);
        EasyMock.replay((Object[])new Object[]{init});
        Assert.assertSame((String)"Wrong result object", (Object)result, (Object)ConcurrentUtils.initialize((ConcurrentInitializer)init));
        EasyMock.verify((Object[])new Object[]{init});
    }

    @Test
    public void testInitializeUncheckedNull() {
        Assert.assertNull((String)"Got a result", (Object)ConcurrentUtils.initializeUnchecked(null));
    }

    @Test
    public void testInitializeUnchecked() throws ConcurrentException {
        ConcurrentInitializer init = (ConcurrentInitializer)EasyMock.createMock(ConcurrentInitializer.class);
        Object result = new Object();
        EasyMock.expect((Object)init.get()).andReturn(result);
        EasyMock.replay((Object[])new Object[]{init});
        Assert.assertSame((String)"Wrong result object", (Object)result, (Object)ConcurrentUtils.initializeUnchecked((ConcurrentInitializer)init));
        EasyMock.verify((Object[])new Object[]{init});
    }

    @Test
    public void testInitializeUncheckedEx() throws ConcurrentException {
        ConcurrentInitializer init = (ConcurrentInitializer)EasyMock.createMock(ConcurrentInitializer.class);
        Exception cause = new Exception();
        EasyMock.expect((Object)init.get()).andThrow((Throwable)new ConcurrentException((Throwable)cause));
        EasyMock.replay((Object[])new Object[]{init});
        try {
            ConcurrentUtils.initializeUnchecked((ConcurrentInitializer)init);
            Assert.fail((String)"Exception not thrown!");
        }
        catch (ConcurrentRuntimeException crex) {
            Assert.assertSame((String)"Wrong cause", (Object)cause, (Object)crex.getCause());
        }
        EasyMock.verify((Object[])new Object[]{init});
    }

    @Test
    public void testConstantFuture_Integer() throws Exception {
        Integer value = new Integer(5);
        Future test = ConcurrentUtils.constantFuture((Object)value);
        Assert.assertTrue((boolean)test.isDone());
        Assert.assertSame((Object)value, test.get());
        Assert.assertSame((Object)value, test.get(1000L, TimeUnit.SECONDS));
        Assert.assertSame((Object)value, test.get(1000L, null));
        Assert.assertFalse((boolean)test.isCancelled());
        Assert.assertFalse((boolean)test.cancel(true));
        Assert.assertFalse((boolean)test.cancel(false));
    }

    @Test
    public void testConstantFuture_null() throws Exception {
        Object value = null;
        Future test = ConcurrentUtils.constantFuture(value);
        Assert.assertTrue((boolean)test.isDone());
        Assert.assertSame(value, test.get());
        Assert.assertSame(value, test.get(1000L, TimeUnit.SECONDS));
        Assert.assertSame(value, test.get(1000L, null));
        Assert.assertFalse((boolean)test.isCancelled());
        Assert.assertFalse((boolean)test.cancel(true));
        Assert.assertFalse((boolean)test.cancel(false));
    }

    @Test
    public void testPutIfAbsentKeyPresent() {
        String key = "testKey";
        Integer value = 42;
        ConcurrentHashMap<String, Integer> map = new ConcurrentHashMap<String, Integer>();
        map.put("testKey", value);
        Assert.assertEquals((String)"Wrong result", (Object)value, (Object)ConcurrentUtils.putIfAbsent(map, (Object)"testKey", (Object)0));
        Assert.assertEquals((String)"Wrong value in map", (Object)value, map.get("testKey"));
    }

    @Test
    public void testPutIfAbsentKeyNotPresent() {
        String key = "testKey";
        Integer value = 42;
        ConcurrentHashMap map = new ConcurrentHashMap();
        Assert.assertEquals((String)"Wrong result", (Object)value, (Object)ConcurrentUtils.putIfAbsent(map, (Object)"testKey", (Object)value));
        Assert.assertEquals((String)"Wrong value in map", (Object)value, map.get("testKey"));
    }

    @Test
    public void testPutIfAbsentNullMap() {
        Assert.assertNull((String)"Wrong result", (Object)ConcurrentUtils.putIfAbsent(null, (Object)"test", (Object)100));
    }

    @Test
    public void testCreateIfAbsentKeyPresent() throws ConcurrentException {
        ConcurrentInitializer init = (ConcurrentInitializer)EasyMock.createMock(ConcurrentInitializer.class);
        EasyMock.replay((Object[])new Object[]{init});
        String key = "testKey";
        Integer value = 42;
        ConcurrentHashMap<String, Integer> map = new ConcurrentHashMap<String, Integer>();
        map.put("testKey", value);
        Assert.assertEquals((String)"Wrong result", (Object)value, (Object)ConcurrentUtils.createIfAbsent(map, (Object)"testKey", (ConcurrentInitializer)init));
        Assert.assertEquals((String)"Wrong value in map", (Object)value, map.get("testKey"));
        EasyMock.verify((Object[])new Object[]{init});
    }

    @Test
    public void testCreateIfAbsentKeyNotPresent() throws ConcurrentException {
        ConcurrentInitializer init = (ConcurrentInitializer)EasyMock.createMock(ConcurrentInitializer.class);
        String key = "testKey";
        Integer value = 42;
        EasyMock.expect((Object)init.get()).andReturn((Object)value);
        EasyMock.replay((Object[])new Object[]{init});
        ConcurrentHashMap map = new ConcurrentHashMap();
        Assert.assertEquals((String)"Wrong result", (Object)value, (Object)ConcurrentUtils.createIfAbsent(map, (Object)"testKey", (ConcurrentInitializer)init));
        Assert.assertEquals((String)"Wrong value in map", (Object)value, map.get("testKey"));
        EasyMock.verify((Object[])new Object[]{init});
    }

    @Test
    public void testCreateIfAbsentNullMap() throws ConcurrentException {
        ConcurrentInitializer init = (ConcurrentInitializer)EasyMock.createMock(ConcurrentInitializer.class);
        EasyMock.replay((Object[])new Object[]{init});
        Assert.assertNull((String)"Wrong result", (Object)ConcurrentUtils.createIfAbsent(null, (Object)"test", (ConcurrentInitializer)init));
        EasyMock.verify((Object[])new Object[]{init});
    }

    @Test
    public void testCreateIfAbsentNullInit() throws ConcurrentException {
        ConcurrentHashMap<String, Integer> map = new ConcurrentHashMap<String, Integer>();
        String key = "testKey";
        Integer value = 42;
        map.put("testKey", value);
        Assert.assertNull((String)"Wrong result", (Object)ConcurrentUtils.createIfAbsent(map, (Object)"testKey", null));
        Assert.assertEquals((String)"Map was changed", (Object)value, map.get("testKey"));
    }

    @Test
    public void testCreateIfAbsentUncheckedSuccess() {
        String key = "testKey";
        Integer value = 42;
        ConcurrentHashMap map = new ConcurrentHashMap();
        Assert.assertEquals((String)"Wrong result", (Object)value, (Object)ConcurrentUtils.createIfAbsentUnchecked(map, (Object)"testKey", (ConcurrentInitializer)new ConstantInitializer((Object)value)));
        Assert.assertEquals((String)"Wrong value in map", (Object)value, map.get("testKey"));
    }

    @Test
    public void testCreateIfAbsentUncheckedException() throws ConcurrentException {
        ConcurrentInitializer init = (ConcurrentInitializer)EasyMock.createMock(ConcurrentInitializer.class);
        Exception ex = new Exception();
        EasyMock.expect((Object)init.get()).andThrow((Throwable)new ConcurrentException((Throwable)ex));
        EasyMock.replay((Object[])new Object[]{init});
        try {
            ConcurrentUtils.createIfAbsentUnchecked(new ConcurrentHashMap(), (Object)"test", (ConcurrentInitializer)init);
            Assert.fail((String)"Exception not thrown!");
        }
        catch (ConcurrentRuntimeException crex) {
            Assert.assertEquals((String)"Wrong cause", (Object)ex, (Object)crex.getCause());
        }
        EasyMock.verify((Object[])new Object[]{init});
    }
}

