/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.exception;

import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.AbstractExceptionContextTest;
import org.apache.commons.lang3.exception.ContextedRuntimeException;
import org.apache.commons.lang3.exception.DefaultExceptionContext;
import org.apache.commons.lang3.exception.ExceptionContext;
import org.apache.commons.lang3.exception.ExceptionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextedRuntimeExceptionTest
extends AbstractExceptionContextTest<ContextedRuntimeException> {
    @Override
    protected void setUp() throws Exception {
        this.exceptionContext = new ContextedRuntimeException((Throwable)new Exception("Test Message"));
        super.setUp();
    }

    public void testContextedException() {
        this.exceptionContext = new ContextedRuntimeException();
        String message = ((ContextedRuntimeException)this.exceptionContext).getMessage();
        String trace = ExceptionUtils.getStackTrace((Throwable)((Throwable)this.exceptionContext));
        ContextedRuntimeExceptionTest.assertTrue((trace.indexOf("ContextedException") >= 0 ? 1 : 0) != 0);
        ContextedRuntimeExceptionTest.assertTrue((boolean)StringUtils.isEmpty((CharSequence)message));
    }

    public void testContextedExceptionString() {
        this.exceptionContext = new ContextedRuntimeException("Test Message");
        ContextedRuntimeExceptionTest.assertEquals((String)"Test Message", (String)((ContextedRuntimeException)this.exceptionContext).getMessage());
        String trace = ExceptionUtils.getStackTrace((Throwable)((Throwable)this.exceptionContext));
        ContextedRuntimeExceptionTest.assertTrue((trace.indexOf("Test Message") >= 0 ? 1 : 0) != 0);
    }

    public void testContextedExceptionThrowable() {
        this.exceptionContext = new ContextedRuntimeException((Throwable)new Exception("Test Message"));
        String message = ((ContextedRuntimeException)this.exceptionContext).getMessage();
        String trace = ExceptionUtils.getStackTrace((Throwable)((Throwable)this.exceptionContext));
        ContextedRuntimeExceptionTest.assertTrue((trace.indexOf("ContextedException") >= 0 ? 1 : 0) != 0);
        ContextedRuntimeExceptionTest.assertTrue((trace.indexOf("Test Message") >= 0 ? 1 : 0) != 0);
        ContextedRuntimeExceptionTest.assertTrue((message.indexOf("Test Message") >= 0 ? 1 : 0) != 0);
    }

    public void testContextedExceptionStringThrowable() {
        this.exceptionContext = new ContextedRuntimeException("This is monotonous", (Throwable)new Exception("Test Message"));
        String message = ((ContextedRuntimeException)this.exceptionContext).getMessage();
        String trace = ExceptionUtils.getStackTrace((Throwable)((Throwable)this.exceptionContext));
        ContextedRuntimeExceptionTest.assertTrue((trace.indexOf("ContextedException") >= 0 ? 1 : 0) != 0);
        ContextedRuntimeExceptionTest.assertTrue((trace.indexOf("Test Message") >= 0 ? 1 : 0) != 0);
        ContextedRuntimeExceptionTest.assertTrue((trace.indexOf("This is monotonous") >= 0 ? 1 : 0) != 0);
        ContextedRuntimeExceptionTest.assertTrue((message.indexOf("This is monotonous") >= 0 ? 1 : 0) != 0);
    }

    public void testContextedExceptionStringThrowableContext() {
        this.exceptionContext = new ContextedRuntimeException("This is monotonous", (Throwable)new Exception("Test Message"), (ExceptionContext)new DefaultExceptionContext(){});
        String message = ((ContextedRuntimeException)this.exceptionContext).getMessage();
        String trace = ExceptionUtils.getStackTrace((Throwable)((Throwable)this.exceptionContext));
        ContextedRuntimeExceptionTest.assertTrue((trace.indexOf("ContextedException") >= 0 ? 1 : 0) != 0);
        ContextedRuntimeExceptionTest.assertTrue((trace.indexOf("Test Message") >= 0 ? 1 : 0) != 0);
        ContextedRuntimeExceptionTest.assertTrue((trace.indexOf("This is monotonous") >= 0 ? 1 : 0) != 0);
        ContextedRuntimeExceptionTest.assertTrue((message.indexOf("This is monotonous") >= 0 ? 1 : 0) != 0);
    }

    public void testNullExceptionPassing() {
        this.exceptionContext = new ContextedRuntimeException("This is monotonous", (Throwable)new Exception("Test Message"), null).addContextValue("test1", null).addContextValue("test2", (Object)"some value").addContextValue("test Date", (Object)new Date()).addContextValue("test Nbr", (Object)new Integer(5)).addContextValue("test Poorly written obj", (Object)new AbstractExceptionContextTest.ObjectWithFaultyToString());
        String message = ((ContextedRuntimeException)this.exceptionContext).getMessage();
        ContextedRuntimeExceptionTest.assertTrue((message != null ? 1 : 0) != 0);
    }
}

