/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.math;

import junit.framework.TestCase;
import org.apache.commons.lang3.math.Fraction;

public class FractionTest
extends TestCase {
    private static final int SKIP = 500;

    public FractionTest(String name) {
        super(name);
    }

    public void testConstants() {
        FractionTest.assertEquals((int)0, (int)Fraction.ZERO.getNumerator());
        FractionTest.assertEquals((int)1, (int)Fraction.ZERO.getDenominator());
        FractionTest.assertEquals((int)1, (int)Fraction.ONE.getNumerator());
        FractionTest.assertEquals((int)1, (int)Fraction.ONE.getDenominator());
        FractionTest.assertEquals((int)1, (int)Fraction.ONE_HALF.getNumerator());
        FractionTest.assertEquals((int)2, (int)Fraction.ONE_HALF.getDenominator());
        FractionTest.assertEquals((int)1, (int)Fraction.ONE_THIRD.getNumerator());
        FractionTest.assertEquals((int)3, (int)Fraction.ONE_THIRD.getDenominator());
        FractionTest.assertEquals((int)2, (int)Fraction.TWO_THIRDS.getNumerator());
        FractionTest.assertEquals((int)3, (int)Fraction.TWO_THIRDS.getDenominator());
        FractionTest.assertEquals((int)1, (int)Fraction.ONE_QUARTER.getNumerator());
        FractionTest.assertEquals((int)4, (int)Fraction.ONE_QUARTER.getDenominator());
        FractionTest.assertEquals((int)2, (int)Fraction.TWO_QUARTERS.getNumerator());
        FractionTest.assertEquals((int)4, (int)Fraction.TWO_QUARTERS.getDenominator());
        FractionTest.assertEquals((int)3, (int)Fraction.THREE_QUARTERS.getNumerator());
        FractionTest.assertEquals((int)4, (int)Fraction.THREE_QUARTERS.getDenominator());
        FractionTest.assertEquals((int)1, (int)Fraction.ONE_FIFTH.getNumerator());
        FractionTest.assertEquals((int)5, (int)Fraction.ONE_FIFTH.getDenominator());
        FractionTest.assertEquals((int)2, (int)Fraction.TWO_FIFTHS.getNumerator());
        FractionTest.assertEquals((int)5, (int)Fraction.TWO_FIFTHS.getDenominator());
        FractionTest.assertEquals((int)3, (int)Fraction.THREE_FIFTHS.getNumerator());
        FractionTest.assertEquals((int)5, (int)Fraction.THREE_FIFTHS.getDenominator());
        FractionTest.assertEquals((int)4, (int)Fraction.FOUR_FIFTHS.getNumerator());
        FractionTest.assertEquals((int)5, (int)Fraction.FOUR_FIFTHS.getDenominator());
    }

    public void testFactory_int_int() {
        Fraction f = null;
        f = Fraction.getFraction((int)0, (int)1);
        FractionTest.assertEquals((int)0, (int)f.getNumerator());
        FractionTest.assertEquals((int)1, (int)f.getDenominator());
        f = Fraction.getFraction((int)0, (int)2);
        FractionTest.assertEquals((int)0, (int)f.getNumerator());
        FractionTest.assertEquals((int)2, (int)f.getDenominator());
        f = Fraction.getFraction((int)1, (int)1);
        FractionTest.assertEquals((int)1, (int)f.getNumerator());
        FractionTest.assertEquals((int)1, (int)f.getDenominator());
        f = Fraction.getFraction((int)2, (int)1);
        FractionTest.assertEquals((int)2, (int)f.getNumerator());
        FractionTest.assertEquals((int)1, (int)f.getDenominator());
        f = Fraction.getFraction((int)23, (int)345);
        FractionTest.assertEquals((int)23, (int)f.getNumerator());
        FractionTest.assertEquals((int)345, (int)f.getDenominator());
        f = Fraction.getFraction((int)22, (int)7);
        FractionTest.assertEquals((int)22, (int)f.getNumerator());
        FractionTest.assertEquals((int)7, (int)f.getDenominator());
        f = Fraction.getFraction((int)-6, (int)10);
        FractionTest.assertEquals((int)-6, (int)f.getNumerator());
        FractionTest.assertEquals((int)10, (int)f.getDenominator());
        f = Fraction.getFraction((int)6, (int)-10);
        FractionTest.assertEquals((int)-6, (int)f.getNumerator());
        FractionTest.assertEquals((int)10, (int)f.getDenominator());
        f = Fraction.getFraction((int)-6, (int)-10);
        FractionTest.assertEquals((int)6, (int)f.getNumerator());
        FractionTest.assertEquals((int)10, (int)f.getDenominator());
        try {
            f = Fraction.getFraction((int)1, (int)0);
            FractionTest.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        try {
            f = Fraction.getFraction((int)2, (int)0);
            FractionTest.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        try {
            f = Fraction.getFraction((int)-3, (int)0);
            FractionTest.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        try {
            f = Fraction.getFraction((int)4, (int)Integer.MIN_VALUE);
            FractionTest.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        try {
            f = Fraction.getFraction((int)1, (int)Integer.MIN_VALUE);
            FractionTest.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
    }

    public void testFactory_int_int_int() {
        Fraction f = null;
        f = Fraction.getFraction((int)0, (int)0, (int)2);
        FractionTest.assertEquals((int)0, (int)f.getNumerator());
        FractionTest.assertEquals((int)2, (int)f.getDenominator());
        f = Fraction.getFraction((int)2, (int)0, (int)2);
        FractionTest.assertEquals((int)4, (int)f.getNumerator());
        FractionTest.assertEquals((int)2, (int)f.getDenominator());
        f = Fraction.getFraction((int)0, (int)1, (int)2);
        FractionTest.assertEquals((int)1, (int)f.getNumerator());
        FractionTest.assertEquals((int)2, (int)f.getDenominator());
        f = Fraction.getFraction((int)1, (int)1, (int)2);
        FractionTest.assertEquals((int)3, (int)f.getNumerator());
        FractionTest.assertEquals((int)2, (int)f.getDenominator());
        try {
            f = Fraction.getFraction((int)1, (int)-6, (int)-10);
            FractionTest.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        try {
            f = Fraction.getFraction((int)1, (int)-6, (int)-10);
            FractionTest.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        try {
            f = Fraction.getFraction((int)1, (int)-6, (int)-10);
            FractionTest.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        f = Fraction.getFraction((int)-1, (int)6, (int)10);
        FractionTest.assertEquals((int)-16, (int)f.getNumerator());
        FractionTest.assertEquals((int)10, (int)f.getDenominator());
        try {
            f = Fraction.getFraction((int)-1, (int)-6, (int)10);
            FractionTest.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        try {
            f = Fraction.getFraction((int)-1, (int)6, (int)-10);
            FractionTest.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        try {
            f = Fraction.getFraction((int)-1, (int)-6, (int)-10);
            FractionTest.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        try {
            f = Fraction.getFraction((int)0, (int)1, (int)0);
            FractionTest.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        try {
            f = Fraction.getFraction((int)1, (int)2, (int)0);
            FractionTest.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        try {
            f = Fraction.getFraction((int)-1, (int)-3, (int)0);
            FractionTest.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        try {
            f = Fraction.getFraction((int)Integer.MAX_VALUE, (int)1, (int)2);
            FractionTest.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        try {
            f = Fraction.getFraction((int)-2147483647, (int)1, (int)2);
            FractionTest.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        f = Fraction.getFraction((int)-1, (int)0, (int)Integer.MAX_VALUE);
        FractionTest.assertEquals((int)-2147483647, (int)f.getNumerator());
        FractionTest.assertEquals((int)Integer.MAX_VALUE, (int)f.getDenominator());
        try {
            f = Fraction.getFraction((int)0, (int)4, (int)Integer.MIN_VALUE);
            FractionTest.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        try {
            f = Fraction.getFraction((int)1, (int)1, (int)Integer.MAX_VALUE);
            FractionTest.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        try {
            f = Fraction.getFraction((int)-1, (int)2, (int)Integer.MAX_VALUE);
            FractionTest.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
    }

    public void testReducedFactory_int_int() {
        Fraction f = null;
        f = Fraction.getReducedFraction((int)0, (int)1);
        FractionTest.assertEquals((int)0, (int)f.getNumerator());
        FractionTest.assertEquals((int)1, (int)f.getDenominator());
        f = Fraction.getReducedFraction((int)1, (int)1);
        FractionTest.assertEquals((int)1, (int)f.getNumerator());
        FractionTest.assertEquals((int)1, (int)f.getDenominator());
        f = Fraction.getReducedFraction((int)2, (int)1);
        FractionTest.assertEquals((int)2, (int)f.getNumerator());
        FractionTest.assertEquals((int)1, (int)f.getDenominator());
        f = Fraction.getReducedFraction((int)22, (int)7);
        FractionTest.assertEquals((int)22, (int)f.getNumerator());
        FractionTest.assertEquals((int)7, (int)f.getDenominator());
        f = Fraction.getReducedFraction((int)-6, (int)10);
        FractionTest.assertEquals((int)-3, (int)f.getNumerator());
        FractionTest.assertEquals((int)5, (int)f.getDenominator());
        f = Fraction.getReducedFraction((int)6, (int)-10);
        FractionTest.assertEquals((int)-3, (int)f.getNumerator());
        FractionTest.assertEquals((int)5, (int)f.getDenominator());
        f = Fraction.getReducedFraction((int)-6, (int)-10);
        FractionTest.assertEquals((int)3, (int)f.getNumerator());
        FractionTest.assertEquals((int)5, (int)f.getDenominator());
        try {
            f = Fraction.getReducedFraction((int)1, (int)0);
            FractionTest.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        try {
            f = Fraction.getReducedFraction((int)2, (int)0);
            FractionTest.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        try {
            f = Fraction.getReducedFraction((int)-3, (int)0);
            FractionTest.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        f = Fraction.getReducedFraction((int)0, (int)2);
        FractionTest.assertEquals((int)0, (int)f.getNumerator());
        FractionTest.assertEquals((int)1, (int)f.getDenominator());
        f = Fraction.getReducedFraction((int)2, (int)2);
        FractionTest.assertEquals((int)1, (int)f.getNumerator());
        FractionTest.assertEquals((int)1, (int)f.getDenominator());
        f = Fraction.getReducedFraction((int)2, (int)4);
        FractionTest.assertEquals((int)1, (int)f.getNumerator());
        FractionTest.assertEquals((int)2, (int)f.getDenominator());
        f = Fraction.getReducedFraction((int)15, (int)10);
        FractionTest.assertEquals((int)3, (int)f.getNumerator());
        FractionTest.assertEquals((int)2, (int)f.getDenominator());
        f = Fraction.getReducedFraction((int)121, (int)22);
        FractionTest.assertEquals((int)11, (int)f.getNumerator());
        FractionTest.assertEquals((int)2, (int)f.getDenominator());
        f = Fraction.getReducedFraction((int)-2, (int)Integer.MIN_VALUE);
        FractionTest.assertEquals((int)1, (int)f.getNumerator());
        FractionTest.assertEquals((int)0x40000000, (int)f.getDenominator());
        try {
            f = Fraction.getReducedFraction((int)-7, (int)Integer.MIN_VALUE);
            FractionTest.fail((String)"Expecting ArithmeticException");
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        f = Fraction.getReducedFraction((int)Integer.MIN_VALUE, (int)2);
        FractionTest.assertEquals((int)-1073741824, (int)f.getNumerator());
        FractionTest.assertEquals((int)1, (int)f.getDenominator());
    }

    public void testFactory_double() {
        int j;
        int i;
        Fraction f = null;
        try {
            f = Fraction.getFraction((double)Double.NaN);
            FractionTest.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        try {
            f = Fraction.getFraction((double)Double.POSITIVE_INFINITY);
            FractionTest.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        try {
            f = Fraction.getFraction((double)Double.NEGATIVE_INFINITY);
            FractionTest.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        try {
            f = Fraction.getFraction((double)2.147483648E9);
            FractionTest.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        f = Fraction.getFraction((double)0.0);
        FractionTest.assertEquals((int)0, (int)f.getNumerator());
        FractionTest.assertEquals((int)1, (int)f.getDenominator());
        f = Fraction.getFraction((double)1.0);
        FractionTest.assertEquals((int)1, (int)f.getNumerator());
        FractionTest.assertEquals((int)1, (int)f.getDenominator());
        f = Fraction.getFraction((double)0.5);
        FractionTest.assertEquals((int)1, (int)f.getNumerator());
        FractionTest.assertEquals((int)2, (int)f.getDenominator());
        f = Fraction.getFraction((double)-0.875);
        FractionTest.assertEquals((int)-7, (int)f.getNumerator());
        FractionTest.assertEquals((int)8, (int)f.getDenominator());
        f = Fraction.getFraction((double)1.25);
        FractionTest.assertEquals((int)5, (int)f.getNumerator());
        FractionTest.assertEquals((int)4, (int)f.getDenominator());
        f = Fraction.getFraction((double)0.66666);
        FractionTest.assertEquals((int)2, (int)f.getNumerator());
        FractionTest.assertEquals((int)3, (int)f.getDenominator());
        f = Fraction.getFraction((double)9.999000099990002E-5);
        FractionTest.assertEquals((int)0, (int)f.getNumerator());
        FractionTest.assertEquals((int)1, (int)f.getDenominator());
        Fraction f2 = null;
        for (i = 1; i <= 100; ++i) {
            for (j = 1; j <= i; ++j) {
                try {
                    f = Fraction.getFraction((double)((double)j / (double)i));
                }
                catch (ArithmeticException ex) {
                    System.err.println(j + " " + i);
                    throw ex;
                }
                f2 = Fraction.getReducedFraction((int)j, (int)i);
                FractionTest.assertEquals((int)f2.getNumerator(), (int)f.getNumerator());
                FractionTest.assertEquals((int)f2.getDenominator(), (int)f.getDenominator());
            }
        }
        for (i = 1001; i <= 10000; i += 500) {
            for (j = 1; j <= i; ++j) {
                try {
                    f = Fraction.getFraction((double)((double)j / (double)i));
                }
                catch (ArithmeticException ex) {
                    System.err.println(j + " " + i);
                    throw ex;
                }
                f2 = Fraction.getReducedFraction((int)j, (int)i);
                FractionTest.assertEquals((int)f2.getNumerator(), (int)f.getNumerator());
                FractionTest.assertEquals((int)f2.getDenominator(), (int)f.getDenominator());
            }
        }
    }

    public void testFactory_String() {
        try {
            Fraction.getFraction(null);
            FractionTest.fail((String)"expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testFactory_String_double() {
        Fraction f = null;
        f = Fraction.getFraction((String)"0.0");
        FractionTest.assertEquals((int)0, (int)f.getNumerator());
        FractionTest.assertEquals((int)1, (int)f.getDenominator());
        f = Fraction.getFraction((String)"0.2");
        FractionTest.assertEquals((int)1, (int)f.getNumerator());
        FractionTest.assertEquals((int)5, (int)f.getDenominator());
        f = Fraction.getFraction((String)"0.5");
        FractionTest.assertEquals((int)1, (int)f.getNumerator());
        FractionTest.assertEquals((int)2, (int)f.getDenominator());
        f = Fraction.getFraction((String)"0.66666");
        FractionTest.assertEquals((int)2, (int)f.getNumerator());
        FractionTest.assertEquals((int)3, (int)f.getDenominator());
        try {
            f = Fraction.getFraction((String)"2.3R");
            FractionTest.fail((String)"Expecting NumberFormatException");
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        try {
            f = Fraction.getFraction((String)"2147483648");
            FractionTest.fail((String)"Expecting NumberFormatException");
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        try {
            f = Fraction.getFraction((String)".");
            FractionTest.fail((String)"Expecting NumberFormatException");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void testFactory_String_proper() {
        Fraction f = null;
        f = Fraction.getFraction((String)"0 0/1");
        FractionTest.assertEquals((int)0, (int)f.getNumerator());
        FractionTest.assertEquals((int)1, (int)f.getDenominator());
        f = Fraction.getFraction((String)"1 1/5");
        FractionTest.assertEquals((int)6, (int)f.getNumerator());
        FractionTest.assertEquals((int)5, (int)f.getDenominator());
        f = Fraction.getFraction((String)"7 1/2");
        FractionTest.assertEquals((int)15, (int)f.getNumerator());
        FractionTest.assertEquals((int)2, (int)f.getDenominator());
        f = Fraction.getFraction((String)"1 2/4");
        FractionTest.assertEquals((int)6, (int)f.getNumerator());
        FractionTest.assertEquals((int)4, (int)f.getDenominator());
        f = Fraction.getFraction((String)"-7 1/2");
        FractionTest.assertEquals((int)-15, (int)f.getNumerator());
        FractionTest.assertEquals((int)2, (int)f.getDenominator());
        f = Fraction.getFraction((String)"-1 2/4");
        FractionTest.assertEquals((int)-6, (int)f.getNumerator());
        FractionTest.assertEquals((int)4, (int)f.getDenominator());
        try {
            f = Fraction.getFraction((String)"2 3");
            FractionTest.fail((String)"expecting NumberFormatException");
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        try {
            f = Fraction.getFraction((String)"a 3");
            FractionTest.fail((String)"expecting NumberFormatException");
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        try {
            f = Fraction.getFraction((String)"2 b/4");
            FractionTest.fail((String)"expecting NumberFormatException");
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        try {
            f = Fraction.getFraction((String)"2 ");
            FractionTest.fail((String)"expecting NumberFormatException");
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        try {
            f = Fraction.getFraction((String)" 3");
            FractionTest.fail((String)"expecting NumberFormatException");
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        try {
            f = Fraction.getFraction((String)" ");
            FractionTest.fail((String)"expecting NumberFormatException");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void testFactory_String_improper() {
        Fraction f = null;
        f = Fraction.getFraction((String)"0/1");
        FractionTest.assertEquals((int)0, (int)f.getNumerator());
        FractionTest.assertEquals((int)1, (int)f.getDenominator());
        f = Fraction.getFraction((String)"1/5");
        FractionTest.assertEquals((int)1, (int)f.getNumerator());
        FractionTest.assertEquals((int)5, (int)f.getDenominator());
        f = Fraction.getFraction((String)"1/2");
        FractionTest.assertEquals((int)1, (int)f.getNumerator());
        FractionTest.assertEquals((int)2, (int)f.getDenominator());
        f = Fraction.getFraction((String)"2/3");
        FractionTest.assertEquals((int)2, (int)f.getNumerator());
        FractionTest.assertEquals((int)3, (int)f.getDenominator());
        f = Fraction.getFraction((String)"7/3");
        FractionTest.assertEquals((int)7, (int)f.getNumerator());
        FractionTest.assertEquals((int)3, (int)f.getDenominator());
        f = Fraction.getFraction((String)"2/4");
        FractionTest.assertEquals((int)2, (int)f.getNumerator());
        FractionTest.assertEquals((int)4, (int)f.getDenominator());
        try {
            f = Fraction.getFraction((String)"2/d");
            FractionTest.fail((String)"expecting NumberFormatException");
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        try {
            f = Fraction.getFraction((String)"2e/3");
            FractionTest.fail((String)"expecting NumberFormatException");
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        try {
            f = Fraction.getFraction((String)"2/");
            FractionTest.fail((String)"expecting NumberFormatException");
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        try {
            f = Fraction.getFraction((String)"/");
            FractionTest.fail((String)"expecting NumberFormatException");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void testGets() {
        Fraction f = null;
        f = Fraction.getFraction((int)3, (int)5, (int)6);
        FractionTest.assertEquals((int)23, (int)f.getNumerator());
        FractionTest.assertEquals((int)3, (int)f.getProperWhole());
        FractionTest.assertEquals((int)5, (int)f.getProperNumerator());
        FractionTest.assertEquals((int)6, (int)f.getDenominator());
        f = Fraction.getFraction((int)-3, (int)5, (int)6);
        FractionTest.assertEquals((int)-23, (int)f.getNumerator());
        FractionTest.assertEquals((int)-3, (int)f.getProperWhole());
        FractionTest.assertEquals((int)5, (int)f.getProperNumerator());
        FractionTest.assertEquals((int)6, (int)f.getDenominator());
        f = Fraction.getFraction((int)Integer.MIN_VALUE, (int)0, (int)1);
        FractionTest.assertEquals((int)Integer.MIN_VALUE, (int)f.getNumerator());
        FractionTest.assertEquals((int)Integer.MIN_VALUE, (int)f.getProperWhole());
        FractionTest.assertEquals((int)0, (int)f.getProperNumerator());
        FractionTest.assertEquals((int)1, (int)f.getDenominator());
    }

    public void testConversions() {
        Fraction f = null;
        f = Fraction.getFraction((int)3, (int)7, (int)8);
        FractionTest.assertEquals((int)3, (int)f.intValue());
        FractionTest.assertEquals((long)3L, (long)f.longValue());
        FractionTest.assertEquals((float)3.875f, (float)f.floatValue(), (float)1.0E-5f);
        FractionTest.assertEquals((double)3.875, (double)f.doubleValue(), (double)1.0E-5);
    }

    public void testReduce() {
        Fraction f = null;
        f = Fraction.getFraction((int)50, (int)75);
        Fraction result = f.reduce();
        FractionTest.assertEquals((int)2, (int)result.getNumerator());
        FractionTest.assertEquals((int)3, (int)result.getDenominator());
        f = Fraction.getFraction((int)-2, (int)-3);
        result = f.reduce();
        FractionTest.assertEquals((int)2, (int)result.getNumerator());
        FractionTest.assertEquals((int)3, (int)result.getDenominator());
        f = Fraction.getFraction((int)2, (int)-3);
        result = f.reduce();
        FractionTest.assertEquals((int)-2, (int)result.getNumerator());
        FractionTest.assertEquals((int)3, (int)result.getDenominator());
        f = Fraction.getFraction((int)-2, (int)3);
        result = f.reduce();
        FractionTest.assertEquals((int)-2, (int)result.getNumerator());
        FractionTest.assertEquals((int)3, (int)result.getDenominator());
        FractionTest.assertSame((Object)f, (Object)result);
        f = Fraction.getFraction((int)2, (int)3);
        result = f.reduce();
        FractionTest.assertEquals((int)2, (int)result.getNumerator());
        FractionTest.assertEquals((int)3, (int)result.getDenominator());
        FractionTest.assertSame((Object)f, (Object)result);
        f = Fraction.getFraction((int)0, (int)1);
        result = f.reduce();
        FractionTest.assertEquals((int)0, (int)result.getNumerator());
        FractionTest.assertEquals((int)1, (int)result.getDenominator());
        FractionTest.assertSame((Object)f, (Object)result);
        f = Fraction.getFraction((int)0, (int)100);
        result = f.reduce();
        FractionTest.assertEquals((int)0, (int)result.getNumerator());
        FractionTest.assertEquals((int)1, (int)result.getDenominator());
        FractionTest.assertSame((Object)result, (Object)Fraction.ZERO);
        f = Fraction.getFraction((int)Integer.MIN_VALUE, (int)2);
        result = f.reduce();
        FractionTest.assertEquals((int)-1073741824, (int)result.getNumerator());
        FractionTest.assertEquals((int)1, (int)result.getDenominator());
    }

    public void testInvert() {
        Fraction f = null;
        f = Fraction.getFraction((int)50, (int)75);
        f = f.invert();
        FractionTest.assertEquals((int)75, (int)f.getNumerator());
        FractionTest.assertEquals((int)50, (int)f.getDenominator());
        f = Fraction.getFraction((int)4, (int)3);
        f = f.invert();
        FractionTest.assertEquals((int)3, (int)f.getNumerator());
        FractionTest.assertEquals((int)4, (int)f.getDenominator());
        f = Fraction.getFraction((int)-15, (int)47);
        f = f.invert();
        FractionTest.assertEquals((int)-47, (int)f.getNumerator());
        FractionTest.assertEquals((int)15, (int)f.getDenominator());
        f = Fraction.getFraction((int)0, (int)3);
        try {
            f = f.invert();
            FractionTest.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        f = Fraction.getFraction((int)Integer.MIN_VALUE, (int)1);
        try {
            f = f.invert();
            FractionTest.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        f = Fraction.getFraction((int)Integer.MAX_VALUE, (int)1);
        f = f.invert();
        FractionTest.assertEquals((int)1, (int)f.getNumerator());
        FractionTest.assertEquals((int)Integer.MAX_VALUE, (int)f.getDenominator());
    }

    public void testNegate() {
        Fraction f = null;
        f = Fraction.getFraction((int)50, (int)75);
        f = f.negate();
        FractionTest.assertEquals((int)-50, (int)f.getNumerator());
        FractionTest.assertEquals((int)75, (int)f.getDenominator());
        f = Fraction.getFraction((int)-50, (int)75);
        f = f.negate();
        FractionTest.assertEquals((int)50, (int)f.getNumerator());
        FractionTest.assertEquals((int)75, (int)f.getDenominator());
        f = Fraction.getFraction((int)0x7FFFFFFE, (int)Integer.MAX_VALUE);
        f = f.negate();
        FractionTest.assertEquals((int)-2147483646, (int)f.getNumerator());
        FractionTest.assertEquals((int)Integer.MAX_VALUE, (int)f.getDenominator());
        f = Fraction.getFraction((int)Integer.MIN_VALUE, (int)1);
        try {
            f = f.negate();
            FractionTest.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
    }

    public void testAbs() {
        Fraction f = null;
        f = Fraction.getFraction((int)50, (int)75);
        f = f.abs();
        FractionTest.assertEquals((int)50, (int)f.getNumerator());
        FractionTest.assertEquals((int)75, (int)f.getDenominator());
        f = Fraction.getFraction((int)-50, (int)75);
        f = f.abs();
        FractionTest.assertEquals((int)50, (int)f.getNumerator());
        FractionTest.assertEquals((int)75, (int)f.getDenominator());
        f = Fraction.getFraction((int)Integer.MAX_VALUE, (int)1);
        f = f.abs();
        FractionTest.assertEquals((int)Integer.MAX_VALUE, (int)f.getNumerator());
        FractionTest.assertEquals((int)1, (int)f.getDenominator());
        f = Fraction.getFraction((int)Integer.MAX_VALUE, (int)-1);
        f = f.abs();
        FractionTest.assertEquals((int)Integer.MAX_VALUE, (int)f.getNumerator());
        FractionTest.assertEquals((int)1, (int)f.getDenominator());
        f = Fraction.getFraction((int)Integer.MIN_VALUE, (int)1);
        try {
            f = f.abs();
            FractionTest.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
    }

    public void testPow() {
        Fraction f = null;
        f = Fraction.getFraction((int)3, (int)5);
        FractionTest.assertEquals((Object)Fraction.ONE, (Object)f.pow(0));
        f = Fraction.getFraction((int)3, (int)5);
        FractionTest.assertSame((Object)f, (Object)f.pow(1));
        FractionTest.assertEquals((Object)f, (Object)f.pow(1));
        f = Fraction.getFraction((int)3, (int)5);
        f = f.pow(2);
        FractionTest.assertEquals((int)9, (int)f.getNumerator());
        FractionTest.assertEquals((int)25, (int)f.getDenominator());
        f = Fraction.getFraction((int)3, (int)5);
        f = f.pow(3);
        FractionTest.assertEquals((int)27, (int)f.getNumerator());
        FractionTest.assertEquals((int)125, (int)f.getDenominator());
        f = Fraction.getFraction((int)3, (int)5);
        f = f.pow(-1);
        FractionTest.assertEquals((int)5, (int)f.getNumerator());
        FractionTest.assertEquals((int)3, (int)f.getDenominator());
        f = Fraction.getFraction((int)3, (int)5);
        f = f.pow(-2);
        FractionTest.assertEquals((int)25, (int)f.getNumerator());
        FractionTest.assertEquals((int)9, (int)f.getDenominator());
        f = Fraction.getFraction((int)6, (int)10);
        FractionTest.assertEquals((Object)Fraction.ONE, (Object)f.pow(0));
        f = Fraction.getFraction((int)6, (int)10);
        FractionTest.assertEquals((Object)f, (Object)f.pow(1));
        FractionTest.assertFalse((boolean)f.pow(1).equals((Object)Fraction.getFraction((int)3, (int)5)));
        f = Fraction.getFraction((int)6, (int)10);
        f = f.pow(2);
        FractionTest.assertEquals((int)9, (int)f.getNumerator());
        FractionTest.assertEquals((int)25, (int)f.getDenominator());
        f = Fraction.getFraction((int)6, (int)10);
        f = f.pow(3);
        FractionTest.assertEquals((int)27, (int)f.getNumerator());
        FractionTest.assertEquals((int)125, (int)f.getDenominator());
        f = Fraction.getFraction((int)6, (int)10);
        f = f.pow(-1);
        FractionTest.assertEquals((int)10, (int)f.getNumerator());
        FractionTest.assertEquals((int)6, (int)f.getDenominator());
        f = Fraction.getFraction((int)6, (int)10);
        f = f.pow(-2);
        FractionTest.assertEquals((int)25, (int)f.getNumerator());
        FractionTest.assertEquals((int)9, (int)f.getDenominator());
        f = Fraction.getFraction((int)0, (int)1231);
        f = f.pow(1);
        FractionTest.assertTrue((0 == f.compareTo(Fraction.ZERO) ? 1 : 0) != 0);
        FractionTest.assertEquals((int)0, (int)f.getNumerator());
        FractionTest.assertEquals((int)1231, (int)f.getDenominator());
        f = f.pow(2);
        FractionTest.assertTrue((0 == f.compareTo(Fraction.ZERO) ? 1 : 0) != 0);
        FractionTest.assertEquals((int)0, (int)f.getNumerator());
        FractionTest.assertEquals((int)1, (int)f.getDenominator());
        try {
            f = f.pow(-1);
            FractionTest.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        try {
            f = f.pow(Integer.MIN_VALUE);
            FractionTest.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        f = Fraction.getFraction((int)1, (int)1);
        f = f.pow(0);
        FractionTest.assertEquals((Object)f, (Object)Fraction.ONE);
        f = f.pow(1);
        FractionTest.assertEquals((Object)f, (Object)Fraction.ONE);
        f = f.pow(-1);
        FractionTest.assertEquals((Object)f, (Object)Fraction.ONE);
        f = f.pow(Integer.MAX_VALUE);
        FractionTest.assertEquals((Object)f, (Object)Fraction.ONE);
        f = f.pow(Integer.MIN_VALUE);
        FractionTest.assertEquals((Object)f, (Object)Fraction.ONE);
        f = Fraction.getFraction((int)Integer.MAX_VALUE, (int)1);
        try {
            f = f.pow(2);
            FractionTest.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        f = Fraction.getFraction((int)Integer.MIN_VALUE, (int)1);
        try {
            f = f.pow(3);
            FractionTest.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        f = Fraction.getFraction((int)65536, (int)1);
        try {
            f = f.pow(2);
            FractionTest.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
    }

    public void testAdd() {
        Fraction f = null;
        Fraction f1 = null;
        Fraction f2 = null;
        f1 = Fraction.getFraction((int)3, (int)5);
        f2 = Fraction.getFraction((int)1, (int)5);
        f = f1.add(f2);
        FractionTest.assertEquals((int)4, (int)f.getNumerator());
        FractionTest.assertEquals((int)5, (int)f.getDenominator());
        f1 = Fraction.getFraction((int)3, (int)5);
        f2 = Fraction.getFraction((int)2, (int)5);
        f = f1.add(f2);
        FractionTest.assertEquals((int)1, (int)f.getNumerator());
        FractionTest.assertEquals((int)1, (int)f.getDenominator());
        f1 = Fraction.getFraction((int)3, (int)5);
        f2 = Fraction.getFraction((int)3, (int)5);
        f = f1.add(f2);
        FractionTest.assertEquals((int)6, (int)f.getNumerator());
        FractionTest.assertEquals((int)5, (int)f.getDenominator());
        f1 = Fraction.getFraction((int)3, (int)5);
        f2 = Fraction.getFraction((int)-4, (int)5);
        f = f1.add(f2);
        FractionTest.assertEquals((int)-1, (int)f.getNumerator());
        FractionTest.assertEquals((int)5, (int)f.getDenominator());
        f1 = Fraction.getFraction((int)0x7FFFFFFE, (int)1);
        f2 = Fraction.ONE;
        f = f1.add(f2);
        FractionTest.assertEquals((int)Integer.MAX_VALUE, (int)f.getNumerator());
        FractionTest.assertEquals((int)1, (int)f.getDenominator());
        f1 = Fraction.getFraction((int)3, (int)5);
        f2 = Fraction.getFraction((int)1, (int)2);
        f = f1.add(f2);
        FractionTest.assertEquals((int)11, (int)f.getNumerator());
        FractionTest.assertEquals((int)10, (int)f.getDenominator());
        f1 = Fraction.getFraction((int)3, (int)8);
        f2 = Fraction.getFraction((int)1, (int)6);
        f = f1.add(f2);
        FractionTest.assertEquals((int)13, (int)f.getNumerator());
        FractionTest.assertEquals((int)24, (int)f.getDenominator());
        f1 = Fraction.getFraction((int)0, (int)5);
        f2 = Fraction.getFraction((int)1, (int)5);
        f = f1.add(f2);
        FractionTest.assertSame((Object)f2, (Object)f);
        f = f2.add(f1);
        FractionTest.assertSame((Object)f2, (Object)f);
        f1 = Fraction.getFraction((int)-1, (int)676);
        f2 = Fraction.getFraction((int)-2, (int)442);
        f = f1.add(f2);
        FractionTest.assertEquals((int)11492, (int)f.getDenominator());
        FractionTest.assertEquals((int)-69, (int)f.getNumerator());
        try {
            f.add(null);
            FractionTest.fail((String)"expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        f1 = Fraction.getFraction((int)1, (int)98304);
        f2 = Fraction.getFraction((int)1, (int)59049);
        f = f1.add(f2);
        FractionTest.assertEquals((int)52451, (int)f.getNumerator());
        FractionTest.assertEquals((int)1934917632, (int)f.getDenominator());
        f1 = Fraction.getFraction((int)Integer.MIN_VALUE, (int)3);
        f2 = Fraction.ONE_THIRD;
        f = f1.add(f2);
        FractionTest.assertEquals((int)-2147483647, (int)f.getNumerator());
        FractionTest.assertEquals((int)3, (int)f.getDenominator());
        f1 = Fraction.getFraction((int)0x7FFFFFFE, (int)1);
        f2 = Fraction.ONE;
        f = f1.add(f2);
        FractionTest.assertEquals((int)Integer.MAX_VALUE, (int)f.getNumerator());
        FractionTest.assertEquals((int)1, (int)f.getDenominator());
        try {
            f = f.add(Fraction.ONE);
            FractionTest.fail((String)("expecting ArithmeticException but got: " + f.toString()));
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        f1 = Fraction.getFraction((int)Integer.MIN_VALUE, (int)5);
        f2 = Fraction.getFraction((int)-1, (int)5);
        try {
            f = f1.add(f2);
            FractionTest.fail((String)("expecting ArithmeticException but got: " + f.toString()));
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        try {
            f = Fraction.getFraction((int)-2147483647, (int)1);
            f = f.add(f);
            FractionTest.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        try {
            f = Fraction.getFraction((int)-2147483647, (int)1);
            f = f.add(f);
            FractionTest.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        f1 = Fraction.getFraction((int)3, (int)327680);
        f2 = Fraction.getFraction((int)2, (int)59049);
        try {
            f = f1.add(f2);
            FractionTest.fail((String)("expecting ArithmeticException but got: " + f.toString()));
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
    }

    public void testSubtract() {
        Fraction f = null;
        Fraction f1 = null;
        Fraction f2 = null;
        f1 = Fraction.getFraction((int)3, (int)5);
        f2 = Fraction.getFraction((int)1, (int)5);
        f = f1.subtract(f2);
        FractionTest.assertEquals((int)2, (int)f.getNumerator());
        FractionTest.assertEquals((int)5, (int)f.getDenominator());
        f1 = Fraction.getFraction((int)7, (int)5);
        f2 = Fraction.getFraction((int)2, (int)5);
        f = f1.subtract(f2);
        FractionTest.assertEquals((int)1, (int)f.getNumerator());
        FractionTest.assertEquals((int)1, (int)f.getDenominator());
        f1 = Fraction.getFraction((int)3, (int)5);
        f2 = Fraction.getFraction((int)3, (int)5);
        f = f1.subtract(f2);
        FractionTest.assertEquals((int)0, (int)f.getNumerator());
        FractionTest.assertEquals((int)1, (int)f.getDenominator());
        f1 = Fraction.getFraction((int)3, (int)5);
        f2 = Fraction.getFraction((int)-4, (int)5);
        f = f1.subtract(f2);
        FractionTest.assertEquals((int)7, (int)f.getNumerator());
        FractionTest.assertEquals((int)5, (int)f.getDenominator());
        f1 = Fraction.getFraction((int)0, (int)5);
        f2 = Fraction.getFraction((int)4, (int)5);
        f = f1.subtract(f2);
        FractionTest.assertEquals((int)-4, (int)f.getNumerator());
        FractionTest.assertEquals((int)5, (int)f.getDenominator());
        f1 = Fraction.getFraction((int)0, (int)5);
        f2 = Fraction.getFraction((int)-4, (int)5);
        f = f1.subtract(f2);
        FractionTest.assertEquals((int)4, (int)f.getNumerator());
        FractionTest.assertEquals((int)5, (int)f.getDenominator());
        f1 = Fraction.getFraction((int)3, (int)5);
        f2 = Fraction.getFraction((int)1, (int)2);
        f = f1.subtract(f2);
        FractionTest.assertEquals((int)1, (int)f.getNumerator());
        FractionTest.assertEquals((int)10, (int)f.getDenominator());
        f1 = Fraction.getFraction((int)0, (int)5);
        f2 = Fraction.getFraction((int)1, (int)5);
        f = f2.subtract(f1);
        FractionTest.assertSame((Object)f2, (Object)f);
        try {
            f.subtract(null);
            FractionTest.fail((String)"expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        f1 = Fraction.getFraction((int)1, (int)98304);
        f2 = Fraction.getFraction((int)1, (int)59049);
        f = f1.subtract(f2);
        FractionTest.assertEquals((int)-13085, (int)f.getNumerator());
        FractionTest.assertEquals((int)1934917632, (int)f.getDenominator());
        f1 = Fraction.getFraction((int)Integer.MIN_VALUE, (int)3);
        f2 = Fraction.ONE_THIRD.negate();
        f = f1.subtract(f2);
        FractionTest.assertEquals((int)-2147483647, (int)f.getNumerator());
        FractionTest.assertEquals((int)3, (int)f.getDenominator());
        f1 = Fraction.getFraction((int)Integer.MAX_VALUE, (int)1);
        f2 = Fraction.ONE;
        f = f1.subtract(f2);
        FractionTest.assertEquals((int)0x7FFFFFFE, (int)f.getNumerator());
        FractionTest.assertEquals((int)1, (int)f.getDenominator());
        try {
            f1 = Fraction.getFraction((int)1, (int)Integer.MAX_VALUE);
            f2 = Fraction.getFraction((int)1, (int)0x7FFFFFFE);
            f = f1.subtract(f2);
            FractionTest.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        f1 = Fraction.getFraction((int)Integer.MIN_VALUE, (int)5);
        f2 = Fraction.getFraction((int)1, (int)5);
        try {
            f = f1.subtract(f2);
            FractionTest.fail((String)("expecting ArithmeticException but got: " + f.toString()));
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        try {
            f = Fraction.getFraction((int)Integer.MIN_VALUE, (int)1);
            f = f.subtract(Fraction.ONE);
            FractionTest.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        try {
            f = Fraction.getFraction((int)Integer.MAX_VALUE, (int)1);
            f = f.subtract(Fraction.ONE.negate());
            FractionTest.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        f1 = Fraction.getFraction((int)3, (int)327680);
        f2 = Fraction.getFraction((int)2, (int)59049);
        try {
            f = f1.subtract(f2);
            FractionTest.fail((String)("expecting ArithmeticException but got: " + f.toString()));
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
    }

    public void testMultiply() {
        Fraction f = null;
        Fraction f1 = null;
        Fraction f2 = null;
        f1 = Fraction.getFraction((int)3, (int)5);
        f2 = Fraction.getFraction((int)2, (int)5);
        f = f1.multiplyBy(f2);
        FractionTest.assertEquals((int)6, (int)f.getNumerator());
        FractionTest.assertEquals((int)25, (int)f.getDenominator());
        f1 = Fraction.getFraction((int)6, (int)10);
        f2 = Fraction.getFraction((int)6, (int)10);
        f = f1.multiplyBy(f2);
        FractionTest.assertEquals((int)9, (int)f.getNumerator());
        FractionTest.assertEquals((int)25, (int)f.getDenominator());
        f = f.multiplyBy(f2);
        FractionTest.assertEquals((int)27, (int)f.getNumerator());
        FractionTest.assertEquals((int)125, (int)f.getDenominator());
        f1 = Fraction.getFraction((int)3, (int)5);
        f2 = Fraction.getFraction((int)-2, (int)5);
        f = f1.multiplyBy(f2);
        FractionTest.assertEquals((int)-6, (int)f.getNumerator());
        FractionTest.assertEquals((int)25, (int)f.getDenominator());
        f1 = Fraction.getFraction((int)-3, (int)5);
        f2 = Fraction.getFraction((int)-2, (int)5);
        f = f1.multiplyBy(f2);
        FractionTest.assertEquals((int)6, (int)f.getNumerator());
        FractionTest.assertEquals((int)25, (int)f.getDenominator());
        f1 = Fraction.getFraction((int)0, (int)5);
        f2 = Fraction.getFraction((int)2, (int)7);
        f = f1.multiplyBy(f2);
        FractionTest.assertSame((Object)Fraction.ZERO, (Object)f);
        f1 = Fraction.getFraction((int)2, (int)7);
        f2 = Fraction.ONE;
        f = f1.multiplyBy(f2);
        FractionTest.assertEquals((int)2, (int)f.getNumerator());
        FractionTest.assertEquals((int)7, (int)f.getDenominator());
        f1 = Fraction.getFraction((int)Integer.MAX_VALUE, (int)1);
        f2 = Fraction.getFraction((int)Integer.MIN_VALUE, (int)Integer.MAX_VALUE);
        f = f1.multiplyBy(f2);
        FractionTest.assertEquals((int)Integer.MIN_VALUE, (int)f.getNumerator());
        FractionTest.assertEquals((int)1, (int)f.getDenominator());
        try {
            f.multiplyBy(null);
            FractionTest.fail((String)"expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            f1 = Fraction.getFraction((int)1, (int)Integer.MAX_VALUE);
            f = f1.multiplyBy(f1);
            FractionTest.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        try {
            f1 = Fraction.getFraction((int)1, (int)-2147483647);
            f = f1.multiplyBy(f1);
            FractionTest.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
    }

    public void testDivide() {
        Fraction f = null;
        Fraction f1 = null;
        Fraction f2 = null;
        f1 = Fraction.getFraction((int)3, (int)5);
        f2 = Fraction.getFraction((int)2, (int)5);
        f = f1.divideBy(f2);
        FractionTest.assertEquals((int)3, (int)f.getNumerator());
        FractionTest.assertEquals((int)2, (int)f.getDenominator());
        f1 = Fraction.getFraction((int)3, (int)5);
        f2 = Fraction.ZERO;
        try {
            f = f1.divideBy(f2);
            FractionTest.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        f1 = Fraction.getFraction((int)0, (int)5);
        f2 = Fraction.getFraction((int)2, (int)7);
        f = f1.divideBy(f2);
        FractionTest.assertSame((Object)Fraction.ZERO, (Object)f);
        f1 = Fraction.getFraction((int)2, (int)7);
        f2 = Fraction.ONE;
        f = f1.divideBy(f2);
        FractionTest.assertEquals((int)2, (int)f.getNumerator());
        FractionTest.assertEquals((int)7, (int)f.getDenominator());
        f1 = Fraction.getFraction((int)1, (int)Integer.MAX_VALUE);
        f = f1.divideBy(f1);
        FractionTest.assertEquals((int)1, (int)f.getNumerator());
        FractionTest.assertEquals((int)1, (int)f.getDenominator());
        f1 = Fraction.getFraction((int)Integer.MIN_VALUE, (int)Integer.MAX_VALUE);
        f2 = Fraction.getFraction((int)1, (int)Integer.MAX_VALUE);
        f = f1.divideBy(f2);
        FractionTest.assertEquals((int)Integer.MIN_VALUE, (int)f.getNumerator());
        FractionTest.assertEquals((int)1, (int)f.getDenominator());
        try {
            f.divideBy(null);
            FractionTest.fail((String)"IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            f1 = Fraction.getFraction((int)1, (int)Integer.MAX_VALUE);
            f = f1.divideBy(f1.invert());
            FractionTest.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        try {
            f1 = Fraction.getFraction((int)1, (int)-2147483647);
            f = f1.divideBy(f1.invert());
            FractionTest.fail((String)"expecting ArithmeticException");
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
    }

    public void testEquals() {
        Fraction f1 = null;
        Fraction f2 = null;
        f1 = Fraction.getFraction((int)3, (int)5);
        FractionTest.assertEquals((boolean)false, (boolean)f1.equals(null));
        FractionTest.assertEquals((boolean)false, (boolean)f1.equals(new Object()));
        FractionTest.assertEquals((boolean)false, (boolean)f1.equals((Object)new Integer(6)));
        f1 = Fraction.getFraction((int)3, (int)5);
        f2 = Fraction.getFraction((int)2, (int)5);
        FractionTest.assertEquals((boolean)false, (boolean)f1.equals((Object)f2));
        FractionTest.assertEquals((boolean)true, (boolean)f1.equals((Object)f1));
        FractionTest.assertEquals((boolean)true, (boolean)f2.equals((Object)f2));
        f2 = Fraction.getFraction((int)3, (int)5);
        FractionTest.assertEquals((boolean)true, (boolean)f1.equals((Object)f2));
        f2 = Fraction.getFraction((int)6, (int)10);
        FractionTest.assertEquals((boolean)false, (boolean)f1.equals((Object)f2));
    }

    public void testHashCode() {
        Fraction f1 = Fraction.getFraction((int)3, (int)5);
        Fraction f2 = Fraction.getFraction((int)3, (int)5);
        FractionTest.assertTrue((f1.hashCode() == f2.hashCode() ? 1 : 0) != 0);
        f2 = Fraction.getFraction((int)2, (int)5);
        FractionTest.assertTrue((f1.hashCode() != f2.hashCode() ? 1 : 0) != 0);
        f2 = Fraction.getFraction((int)6, (int)10);
        FractionTest.assertTrue((f1.hashCode() != f2.hashCode() ? 1 : 0) != 0);
    }

    public void testCompareTo() {
        Fraction f1 = null;
        Fraction f2 = null;
        f1 = Fraction.getFraction((int)3, (int)5);
        FractionTest.assertTrue((f1.compareTo(f1) == 0 ? 1 : 0) != 0);
        try {
            f1.compareTo(null);
            FractionTest.fail((String)"expecting NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        f2 = Fraction.getFraction((int)2, (int)5);
        FractionTest.assertTrue((f1.compareTo(f2) > 0 ? 1 : 0) != 0);
        FractionTest.assertTrue((f2.compareTo(f2) == 0 ? 1 : 0) != 0);
        f2 = Fraction.getFraction((int)4, (int)5);
        FractionTest.assertTrue((f1.compareTo(f2) < 0 ? 1 : 0) != 0);
        FractionTest.assertTrue((f2.compareTo(f2) == 0 ? 1 : 0) != 0);
        f2 = Fraction.getFraction((int)3, (int)5);
        FractionTest.assertTrue((f1.compareTo(f2) == 0 ? 1 : 0) != 0);
        FractionTest.assertTrue((f2.compareTo(f2) == 0 ? 1 : 0) != 0);
        f2 = Fraction.getFraction((int)6, (int)10);
        FractionTest.assertTrue((f1.compareTo(f2) == 0 ? 1 : 0) != 0);
        FractionTest.assertTrue((f2.compareTo(f2) == 0 ? 1 : 0) != 0);
        f2 = Fraction.getFraction((int)-1, (int)1, (int)Integer.MAX_VALUE);
        FractionTest.assertTrue((f1.compareTo(f2) > 0 ? 1 : 0) != 0);
        FractionTest.assertTrue((f2.compareTo(f2) == 0 ? 1 : 0) != 0);
    }

    public void testToString() {
        Fraction f = null;
        f = Fraction.getFraction((int)3, (int)5);
        String str = f.toString();
        FractionTest.assertEquals((String)"3/5", (String)str);
        FractionTest.assertSame((Object)str, (Object)f.toString());
        f = Fraction.getFraction((int)7, (int)5);
        FractionTest.assertEquals((String)"7/5", (String)f.toString());
        f = Fraction.getFraction((int)4, (int)2);
        FractionTest.assertEquals((String)"4/2", (String)f.toString());
        f = Fraction.getFraction((int)0, (int)2);
        FractionTest.assertEquals((String)"0/2", (String)f.toString());
        f = Fraction.getFraction((int)2, (int)2);
        FractionTest.assertEquals((String)"2/2", (String)f.toString());
        f = Fraction.getFraction((int)Integer.MIN_VALUE, (int)0, (int)1);
        FractionTest.assertEquals((String)"-2147483648/1", (String)f.toString());
        f = Fraction.getFraction((int)-1, (int)1, (int)Integer.MAX_VALUE);
        FractionTest.assertEquals((String)"-2147483648/2147483647", (String)f.toString());
    }

    public void testToProperString() {
        Fraction f = null;
        f = Fraction.getFraction((int)3, (int)5);
        String str = f.toProperString();
        FractionTest.assertEquals((String)"3/5", (String)str);
        FractionTest.assertSame((Object)str, (Object)f.toProperString());
        f = Fraction.getFraction((int)7, (int)5);
        FractionTest.assertEquals((String)"1 2/5", (String)f.toProperString());
        f = Fraction.getFraction((int)14, (int)10);
        FractionTest.assertEquals((String)"1 4/10", (String)f.toProperString());
        f = Fraction.getFraction((int)4, (int)2);
        FractionTest.assertEquals((String)"2", (String)f.toProperString());
        f = Fraction.getFraction((int)0, (int)2);
        FractionTest.assertEquals((String)"0", (String)f.toProperString());
        f = Fraction.getFraction((int)2, (int)2);
        FractionTest.assertEquals((String)"1", (String)f.toProperString());
        f = Fraction.getFraction((int)-7, (int)5);
        FractionTest.assertEquals((String)"-1 2/5", (String)f.toProperString());
        f = Fraction.getFraction((int)Integer.MIN_VALUE, (int)0, (int)1);
        FractionTest.assertEquals((String)"-2147483648", (String)f.toProperString());
        f = Fraction.getFraction((int)-1, (int)1, (int)Integer.MAX_VALUE);
        FractionTest.assertEquals((String)"-1 1/2147483647", (String)f.toProperString());
        FractionTest.assertEquals((String)"-1", (String)Fraction.getFraction((double)-1.0).toProperString());
    }
}

