/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.math;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import junit.framework.TestCase;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class NumberUtilsTest
extends TestCase {
    public NumberUtilsTest(String name) {
        super(name);
    }

    public void testConstructor() {
        NumberUtilsTest.assertNotNull((Object)new NumberUtils());
        Constructor<?>[] cons = NumberUtils.class.getDeclaredConstructors();
        NumberUtilsTest.assertEquals((int)1, (int)cons.length);
        NumberUtilsTest.assertEquals((boolean)true, (boolean)Modifier.isPublic(cons[0].getModifiers()));
        NumberUtilsTest.assertEquals((boolean)true, (boolean)Modifier.isPublic(NumberUtils.class.getModifiers()));
        NumberUtilsTest.assertEquals((boolean)false, (boolean)Modifier.isFinal(NumberUtils.class.getModifiers()));
    }

    public void testToIntString() {
        NumberUtilsTest.assertTrue((String)"toInt(String) 1 failed", (NumberUtils.toInt((String)"12345") == 12345 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((String)"toInt(String) 2 failed", (NumberUtils.toInt((String)"abc") == 0 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((String)"toInt(empty) failed", (NumberUtils.toInt((String)"") == 0 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((String)"toInt(null) failed", (NumberUtils.toInt(null) == 0 ? 1 : 0) != 0);
    }

    public void testToIntStringI() {
        NumberUtilsTest.assertTrue((String)"toInt(String,int) 1 failed", (NumberUtils.toInt((String)"12345", (int)5) == 12345 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((String)"toInt(String,int) 2 failed", (NumberUtils.toInt((String)"1234.5", (int)5) == 5 ? 1 : 0) != 0);
    }

    public void testToLongString() {
        NumberUtilsTest.assertTrue((String)"toLong(String) 1 failed", (NumberUtils.toLong((String)"12345") == 12345L ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((String)"toLong(String) 2 failed", (NumberUtils.toLong((String)"abc") == 0L ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((String)"toLong(String) 3 failed", (NumberUtils.toLong((String)"1L") == 0L ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((String)"toLong(String) 4 failed", (NumberUtils.toLong((String)"1l") == 0L ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((String)"toLong(Long.MAX_VALUE) failed", (NumberUtils.toLong((String)"9223372036854775807") == Long.MAX_VALUE ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((String)"toLong(Long.MIN_VALUE) failed", (NumberUtils.toLong((String)"-9223372036854775808") == Long.MIN_VALUE ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((String)"toLong(empty) failed", (NumberUtils.toLong((String)"") == 0L ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((String)"toLong(null) failed", (NumberUtils.toLong(null) == 0L ? 1 : 0) != 0);
    }

    public void testToLongStringL() {
        NumberUtilsTest.assertTrue((String)"toLong(String,long) 1 failed", (NumberUtils.toLong((String)"12345", (long)5L) == 12345L ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((String)"toLong(String,long) 2 failed", (NumberUtils.toLong((String)"1234.5", (long)5L) == 5L ? 1 : 0) != 0);
    }

    public void testToFloatString() {
        NumberUtilsTest.assertTrue((String)"toFloat(String) 1 failed", (NumberUtils.toFloat((String)"-1.2345") == -1.2345f ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((String)"toFloat(String) 2 failed", (NumberUtils.toFloat((String)"1.2345") == 1.2345f ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((String)"toFloat(String) 3 failed", (NumberUtils.toFloat((String)"abc") == 0.0f ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((String)"toFloat(Float.MAX_VALUE) failed", (NumberUtils.toFloat((String)"3.4028235E38") == Float.MAX_VALUE ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((String)"toFloat(Float.MIN_VALUE) failed", (NumberUtils.toFloat((String)"1.4E-45") == Float.MIN_VALUE ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((String)"toFloat(empty) failed", (NumberUtils.toFloat((String)"") == 0.0f ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((String)"toFloat(null) failed", (NumberUtils.toFloat(null) == 0.0f ? 1 : 0) != 0);
    }

    public void testToFloatStringF() {
        NumberUtilsTest.assertTrue((String)"toFloat(String,int) 1 failed", (NumberUtils.toFloat((String)"1.2345", (float)5.1f) == 1.2345f ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((String)"toFloat(String,int) 2 failed", (NumberUtils.toFloat((String)"a", (float)5.0f) == 5.0f ? 1 : 0) != 0);
    }

    public void testStringToDoubleString() {
        NumberUtilsTest.assertTrue((String)"toDouble(String) 1 failed", (NumberUtils.toDouble((String)"-1.2345") == -1.2345 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((String)"toDouble(String) 2 failed", (NumberUtils.toDouble((String)"1.2345") == 1.2345 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((String)"toDouble(String) 3 failed", (NumberUtils.toDouble((String)"abc") == 0.0 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((String)"toDouble(Double.MAX_VALUE) failed", (NumberUtils.toDouble((String)"1.7976931348623157E308") == Double.MAX_VALUE ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((String)"toDouble(Double.MIN_VALUE) failed", (NumberUtils.toDouble((String)"4.9E-324") == Double.MIN_VALUE ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((String)"toDouble(empty) failed", (NumberUtils.toDouble((String)"") == 0.0 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((String)"toDouble(null) failed", (NumberUtils.toDouble(null) == 0.0 ? 1 : 0) != 0);
    }

    public void testStringToDoubleStringD() {
        NumberUtilsTest.assertTrue((String)"toDouble(String,int) 1 failed", (NumberUtils.toDouble((String)"1.2345", (double)5.1) == 1.2345 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((String)"toDouble(String,int) 2 failed", (NumberUtils.toDouble((String)"a", (double)5.0) == 5.0 ? 1 : 0) != 0);
    }

    public void testToByteString() {
        NumberUtilsTest.assertTrue((String)"toByte(String) 1 failed", (NumberUtils.toByte((String)"123") == 123 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((String)"toByte(String) 2 failed", (NumberUtils.toByte((String)"abc") == 0 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((String)"toByte(empty) failed", (NumberUtils.toByte((String)"") == 0 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((String)"toByte(null) failed", (NumberUtils.toByte(null) == 0 ? 1 : 0) != 0);
    }

    public void testToByteStringI() {
        NumberUtilsTest.assertTrue((String)"toByte(String,byte) 1 failed", (NumberUtils.toByte((String)"123", (byte)5) == 123 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((String)"toByte(String,byte) 2 failed", (NumberUtils.toByte((String)"12.3", (byte)5) == 5 ? 1 : 0) != 0);
    }

    public void testToShortString() {
        NumberUtilsTest.assertTrue((String)"toShort(String) 1 failed", (NumberUtils.toShort((String)"12345") == 12345 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((String)"toShort(String) 2 failed", (NumberUtils.toShort((String)"abc") == 0 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((String)"toShort(empty) failed", (NumberUtils.toShort((String)"") == 0 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((String)"toShort(null) failed", (NumberUtils.toShort(null) == 0 ? 1 : 0) != 0);
    }

    public void testToShortStringI() {
        NumberUtilsTest.assertTrue((String)"toShort(String,short) 1 failed", (NumberUtils.toShort((String)"12345", (short)5) == 12345 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((String)"toShort(String,short) 2 failed", (NumberUtils.toShort((String)"1234.5", (short)5) == 5 ? 1 : 0) != 0);
    }

    public void testCreateNumber() {
        NumberUtilsTest.assertEquals((String)"createNumber(String) 1 failed", (Object)new Float("1234.5"), (Object)NumberUtils.createNumber((String)"1234.5"));
        NumberUtilsTest.assertEquals((String)"createNumber(String) 2 failed", (Object)new Integer("12345"), (Object)NumberUtils.createNumber((String)"12345"));
        NumberUtilsTest.assertEquals((String)"createNumber(String) 3 failed", (Object)new Double("1234.5"), (Object)NumberUtils.createNumber((String)"1234.5D"));
        NumberUtilsTest.assertEquals((String)"createNumber(String) 3 failed", (Object)new Double("1234.5"), (Object)NumberUtils.createNumber((String)"1234.5d"));
        NumberUtilsTest.assertEquals((String)"createNumber(String) 4 failed", (Object)new Float("1234.5"), (Object)NumberUtils.createNumber((String)"1234.5F"));
        NumberUtilsTest.assertEquals((String)"createNumber(String) 4 failed", (Object)new Float("1234.5"), (Object)NumberUtils.createNumber((String)"1234.5f"));
        NumberUtilsTest.assertEquals((String)"createNumber(String) 5 failed", (Object)new Long(0x80000000L), (Object)NumberUtils.createNumber((String)"2147483648"));
        NumberUtilsTest.assertEquals((String)"createNumber(String) 6 failed", (Object)new Long(12345L), (Object)NumberUtils.createNumber((String)"12345L"));
        NumberUtilsTest.assertEquals((String)"createNumber(String) 6 failed", (Object)new Long(12345L), (Object)NumberUtils.createNumber((String)"12345l"));
        NumberUtilsTest.assertEquals((String)"createNumber(String) 7 failed", (Object)new Float("-1234.5"), (Object)NumberUtils.createNumber((String)"-1234.5"));
        NumberUtilsTest.assertEquals((String)"createNumber(String) 8 failed", (Object)new Integer("-12345"), (Object)NumberUtils.createNumber((String)"-12345"));
        NumberUtilsTest.assertTrue((String)"createNumber(String) 9 failed", (64222 == NumberUtils.createNumber((String)"0xFADE").intValue() ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((String)"createNumber(String) 10 failed", (-64222 == NumberUtils.createNumber((String)"-0xFADE").intValue() ? 1 : 0) != 0);
        NumberUtilsTest.assertEquals((String)"createNumber(String) 11 failed", (Object)new Double("1.1E200"), (Object)NumberUtils.createNumber((String)"1.1E200"));
        NumberUtilsTest.assertEquals((String)"createNumber(String) 12 failed", (Object)new Float("1.1E20"), (Object)NumberUtils.createNumber((String)"1.1E20"));
        NumberUtilsTest.assertEquals((String)"createNumber(String) 13 failed", (Object)new Double("-1.1E200"), (Object)NumberUtils.createNumber((String)"-1.1E200"));
        NumberUtilsTest.assertEquals((String)"createNumber(String) 14 failed", (Object)new Double("1.1E-200"), (Object)NumberUtils.createNumber((String)"1.1E-200"));
        NumberUtilsTest.assertEquals((String)"createNumber(null) failed", null, (Object)NumberUtils.createNumber(null));
        NumberUtilsTest.assertEquals((String)"createNumber(String) failed", (Object)new BigInteger("12345678901234567890"), (Object)NumberUtils.createNumber((String)"12345678901234567890L"));
        if (SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_3)) {
            NumberUtilsTest.assertEquals((String)"createNumber(String) 15 failed", (Object)new BigDecimal("1.1E-700"), (Object)NumberUtils.createNumber((String)"1.1E-700F"));
        }
        NumberUtilsTest.assertEquals((String)"createNumber(String) 16 failed", (Object)new Long("102147483647"), (Object)NumberUtils.createNumber((String)"102147483647L"));
        NumberUtilsTest.assertEquals((String)"createNumber(String) 17 failed", (Object)new Long("102147483647"), (Object)NumberUtils.createNumber((String)"102147483647"));
        NumberUtilsTest.assertEquals((String)"createNumber(String) 18 failed", (Object)new BigInteger("109223372036854775807"), (Object)NumberUtils.createNumber((String)"109223372036854775807"));
        NumberUtilsTest.assertEquals((String)"createNumber(String) LANG-521 failed", (Object)new Float("2."), (Object)NumberUtils.createNumber((String)"2."));
        NumberUtilsTest.assertFalse((String)"createNumber(String) succeeded", (boolean)this.checkCreateNumber("1eE"));
        NumberUtilsTest.assertEquals((String)"createNumber(String) LANG-693 failed", (Object)Double.MAX_VALUE, (Object)NumberUtils.createNumber((String)"1.7976931348623157E308"));
    }

    public void testCreateFloat() {
        NumberUtilsTest.assertEquals((String)"createFloat(String) failed", (Object)new Float("1234.5"), (Object)NumberUtils.createFloat((String)"1234.5"));
        NumberUtilsTest.assertEquals((String)"createFloat(null) failed", null, (Object)NumberUtils.createFloat(null));
        this.testCreateFloatFailure("");
        this.testCreateFloatFailure(" ");
        this.testCreateFloatFailure("\b\t\n\f\r");
        this.testCreateFloatFailure("\u00a0\ufeff\u000b\f\u001c\u001d\u001e\u001f");
    }

    protected void testCreateFloatFailure(String str) {
        try {
            Float value = NumberUtils.createFloat((String)str);
            NumberUtilsTest.fail((String)("createFloat(blank) failed: " + value));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void testCreateDouble() {
        NumberUtilsTest.assertEquals((String)"createDouble(String) failed", (Object)new Double("1234.5"), (Object)NumberUtils.createDouble((String)"1234.5"));
        NumberUtilsTest.assertEquals((String)"createDouble(null) failed", null, (Object)NumberUtils.createDouble(null));
        this.testCreateDoubleFailure("");
        this.testCreateDoubleFailure(" ");
        this.testCreateDoubleFailure("\b\t\n\f\r");
        this.testCreateDoubleFailure("\u00a0\ufeff\u000b\f\u001c\u001d\u001e\u001f");
    }

    protected void testCreateDoubleFailure(String str) {
        try {
            Double value = NumberUtils.createDouble((String)str);
            NumberUtilsTest.fail((String)("createDouble(blank) failed: " + value));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void testCreateInteger() {
        NumberUtilsTest.assertEquals((String)"createInteger(String) failed", (Object)new Integer("12345"), (Object)NumberUtils.createInteger((String)"12345"));
        NumberUtilsTest.assertEquals((String)"createInteger(null) failed", null, (Object)NumberUtils.createInteger(null));
        this.testCreateIntegerFailure("");
        this.testCreateIntegerFailure(" ");
        this.testCreateIntegerFailure("\b\t\n\f\r");
        this.testCreateIntegerFailure("\u00a0\ufeff\u000b\f\u001c\u001d\u001e\u001f");
    }

    protected void testCreateIntegerFailure(String str) {
        try {
            Integer value = NumberUtils.createInteger((String)str);
            NumberUtilsTest.fail((String)("createInteger(blank) failed: " + value));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void testCreateLong() {
        NumberUtilsTest.assertEquals((String)"createLong(String) failed", (Object)new Long("12345"), (Object)NumberUtils.createLong((String)"12345"));
        NumberUtilsTest.assertEquals((String)"createLong(null) failed", null, (Object)NumberUtils.createLong(null));
        this.testCreateLongFailure("");
        this.testCreateLongFailure(" ");
        this.testCreateLongFailure("\b\t\n\f\r");
        this.testCreateLongFailure("\u00a0\ufeff\u000b\f\u001c\u001d\u001e\u001f");
    }

    protected void testCreateLongFailure(String str) {
        try {
            Long value = NumberUtils.createLong((String)str);
            NumberUtilsTest.fail((String)("createLong(blank) failed: " + value));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void testCreateBigInteger() {
        NumberUtilsTest.assertEquals((String)"createBigInteger(String) failed", (Object)new BigInteger("12345"), (Object)NumberUtils.createBigInteger((String)"12345"));
        NumberUtilsTest.assertEquals((String)"createBigInteger(null) failed", null, (Object)NumberUtils.createBigInteger(null));
        this.testCreateBigIntegerFailure("");
        this.testCreateBigIntegerFailure(" ");
        this.testCreateBigIntegerFailure("\b\t\n\f\r");
        this.testCreateBigIntegerFailure("\u00a0\ufeff\u000b\f\u001c\u001d\u001e\u001f");
    }

    protected void testCreateBigIntegerFailure(String str) {
        try {
            BigInteger value = NumberUtils.createBigInteger((String)str);
            NumberUtilsTest.fail((String)("createBigInteger(blank) failed: " + value));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void testCreateBigDecimal() {
        NumberUtilsTest.assertEquals((String)"createBigDecimal(String) failed", (Object)new BigDecimal("1234.5"), (Object)NumberUtils.createBigDecimal((String)"1234.5"));
        NumberUtilsTest.assertEquals((String)"createBigDecimal(null) failed", null, (Object)NumberUtils.createBigDecimal(null));
        this.testCreateBigDecimalFailure("");
        this.testCreateBigDecimalFailure(" ");
        this.testCreateBigDecimalFailure("\b\t\n\f\r");
        this.testCreateBigDecimalFailure("\u00a0\ufeff\u000b\f\u001c\u001d\u001e\u001f");
    }

    protected void testCreateBigDecimalFailure(String str) {
        try {
            BigDecimal value = NumberUtils.createBigDecimal((String)str);
            NumberUtilsTest.fail((String)("createBigDecimal(blank) failed: " + value));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void testMinLong() {
        long[] l = null;
        try {
            NumberUtils.min(l);
            NumberUtilsTest.fail((String)"No exception was thrown for null input.");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            NumberUtils.min((long[])new long[0]);
            NumberUtilsTest.fail((String)"No exception was thrown for empty input.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        NumberUtilsTest.assertEquals((String)"min(long[]) failed for array length 1", (long)5L, (long)NumberUtils.min((long[])new long[]{5L}));
        NumberUtilsTest.assertEquals((String)"min(long[]) failed for array length 2", (long)6L, (long)NumberUtils.min((long[])new long[]{6L, 9L}));
        NumberUtilsTest.assertEquals((long)-10L, (long)NumberUtils.min((long[])new long[]{-10L, -5L, 0L, 5L, 10L}));
        NumberUtilsTest.assertEquals((long)-10L, (long)NumberUtils.min((long[])new long[]{-5L, 0L, -10L, 5L, 10L}));
    }

    public void testMinInt() {
        int[] i = null;
        try {
            NumberUtils.min(i);
            NumberUtilsTest.fail((String)"No exception was thrown for null input.");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            NumberUtils.min((int[])new int[0]);
            NumberUtilsTest.fail((String)"No exception was thrown for empty input.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        NumberUtilsTest.assertEquals((String)"min(int[]) failed for array length 1", (int)5, (int)NumberUtils.min((int[])new int[]{5}));
        NumberUtilsTest.assertEquals((String)"min(int[]) failed for array length 2", (int)6, (int)NumberUtils.min((int[])new int[]{6, 9}));
        NumberUtilsTest.assertEquals((int)-10, (int)NumberUtils.min((int[])new int[]{-10, -5, 0, 5, 10}));
        NumberUtilsTest.assertEquals((int)-10, (int)NumberUtils.min((int[])new int[]{-5, 0, -10, 5, 10}));
    }

    public void testMinShort() {
        short[] s = null;
        try {
            NumberUtils.min(s);
            NumberUtilsTest.fail((String)"No exception was thrown for null input.");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            NumberUtils.min((short[])new short[0]);
            NumberUtilsTest.fail((String)"No exception was thrown for empty input.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        NumberUtilsTest.assertEquals((String)"min(short[]) failed for array length 1", (int)5, (int)NumberUtils.min((short[])new short[]{5}));
        NumberUtilsTest.assertEquals((String)"min(short[]) failed for array length 2", (int)6, (int)NumberUtils.min((short[])new short[]{6, 9}));
        NumberUtilsTest.assertEquals((int)-10, (int)NumberUtils.min((short[])new short[]{-10, -5, 0, 5, 10}));
        NumberUtilsTest.assertEquals((int)-10, (int)NumberUtils.min((short[])new short[]{-5, 0, -10, 5, 10}));
    }

    public void testMinByte() {
        byte[] b = null;
        try {
            NumberUtils.min(b);
            NumberUtilsTest.fail((String)"No exception was thrown for null input.");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            NumberUtils.min((byte[])new byte[0]);
            NumberUtilsTest.fail((String)"No exception was thrown for empty input.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        NumberUtilsTest.assertEquals((String)"min(byte[]) failed for array length 1", (int)5, (int)NumberUtils.min((byte[])new byte[]{5}));
        NumberUtilsTest.assertEquals((String)"min(byte[]) failed for array length 2", (int)6, (int)NumberUtils.min((byte[])new byte[]{6, 9}));
        NumberUtilsTest.assertEquals((int)-10, (int)NumberUtils.min((byte[])new byte[]{-10, -5, 0, 5, 10}));
        NumberUtilsTest.assertEquals((int)-10, (int)NumberUtils.min((byte[])new byte[]{-5, 0, -10, 5, 10}));
    }

    public void testMinDouble() {
        double[] d = null;
        try {
            NumberUtils.min(d);
            NumberUtilsTest.fail((String)"No exception was thrown for null input.");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            NumberUtils.min((double[])new double[0]);
            NumberUtilsTest.fail((String)"No exception was thrown for empty input.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        NumberUtilsTest.assertEquals((String)"min(double[]) failed for array length 1", (double)5.12, (double)NumberUtils.min((double[])new double[]{5.12}), (double)0.0);
        NumberUtilsTest.assertEquals((String)"min(double[]) failed for array length 2", (double)6.23, (double)NumberUtils.min((double[])new double[]{6.23, 9.34}), (double)0.0);
        NumberUtilsTest.assertEquals((String)"min(double[]) failed for array length 5", (double)-10.45, (double)NumberUtils.min((double[])new double[]{-10.45, -5.56, 0.0, 5.67, 10.78}), (double)0.0);
        NumberUtilsTest.assertEquals((double)-10.0, (double)NumberUtils.min((double[])new double[]{-10.0, -5.0, 0.0, 5.0, 10.0}), (double)1.0E-4);
        NumberUtilsTest.assertEquals((double)-10.0, (double)NumberUtils.min((double[])new double[]{-5.0, 0.0, -10.0, 5.0, 10.0}), (double)1.0E-4);
    }

    public void testMinFloat() {
        float[] f = null;
        try {
            NumberUtils.min(f);
            NumberUtilsTest.fail((String)"No exception was thrown for null input.");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            NumberUtils.min((float[])new float[0]);
            NumberUtilsTest.fail((String)"No exception was thrown for empty input.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        NumberUtilsTest.assertEquals((String)"min(float[]) failed for array length 1", (float)5.9f, (float)NumberUtils.min((float[])new float[]{5.9f}), (float)0.0f);
        NumberUtilsTest.assertEquals((String)"min(float[]) failed for array length 2", (float)6.8f, (float)NumberUtils.min((float[])new float[]{6.8f, 9.7f}), (float)0.0f);
        NumberUtilsTest.assertEquals((String)"min(float[]) failed for array length 5", (float)-10.6f, (float)NumberUtils.min((float[])new float[]{-10.6f, -5.5f, 0.0f, 5.4f, 10.3f}), (float)0.0f);
        NumberUtilsTest.assertEquals((float)-10.0f, (float)NumberUtils.min((float[])new float[]{-10.0f, -5.0f, 0.0f, 5.0f, 10.0f}), (float)1.0E-4f);
        NumberUtilsTest.assertEquals((float)-10.0f, (float)NumberUtils.min((float[])new float[]{-5.0f, 0.0f, -10.0f, 5.0f, 10.0f}), (float)1.0E-4f);
    }

    public void testMaxLong() {
        long[] l = null;
        try {
            NumberUtils.max(l);
            NumberUtilsTest.fail((String)"No exception was thrown for null input.");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            NumberUtils.max((long[])new long[0]);
            NumberUtilsTest.fail((String)"No exception was thrown for empty input.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        NumberUtilsTest.assertEquals((String)"max(long[]) failed for array length 1", (long)5L, (long)NumberUtils.max((long[])new long[]{5L}));
        NumberUtilsTest.assertEquals((String)"max(long[]) failed for array length 2", (long)9L, (long)NumberUtils.max((long[])new long[]{6L, 9L}));
        NumberUtilsTest.assertEquals((String)"max(long[]) failed for array length 5", (long)10L, (long)NumberUtils.max((long[])new long[]{-10L, -5L, 0L, 5L, 10L}));
        NumberUtilsTest.assertEquals((long)10L, (long)NumberUtils.max((long[])new long[]{-10L, -5L, 0L, 5L, 10L}));
        NumberUtilsTest.assertEquals((long)10L, (long)NumberUtils.max((long[])new long[]{-5L, 0L, 10L, 5L, -10L}));
    }

    public void testMaxInt() {
        int[] i = null;
        try {
            NumberUtils.max(i);
            NumberUtilsTest.fail((String)"No exception was thrown for null input.");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            NumberUtils.max((int[])new int[0]);
            NumberUtilsTest.fail((String)"No exception was thrown for empty input.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        NumberUtilsTest.assertEquals((String)"max(int[]) failed for array length 1", (int)5, (int)NumberUtils.max((int[])new int[]{5}));
        NumberUtilsTest.assertEquals((String)"max(int[]) failed for array length 2", (int)9, (int)NumberUtils.max((int[])new int[]{6, 9}));
        NumberUtilsTest.assertEquals((String)"max(int[]) failed for array length 5", (int)10, (int)NumberUtils.max((int[])new int[]{-10, -5, 0, 5, 10}));
        NumberUtilsTest.assertEquals((int)10, (int)NumberUtils.max((int[])new int[]{-10, -5, 0, 5, 10}));
        NumberUtilsTest.assertEquals((int)10, (int)NumberUtils.max((int[])new int[]{-5, 0, 10, 5, -10}));
    }

    public void testMaxShort() {
        short[] s = null;
        try {
            NumberUtils.max(s);
            NumberUtilsTest.fail((String)"No exception was thrown for null input.");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            NumberUtils.max((short[])new short[0]);
            NumberUtilsTest.fail((String)"No exception was thrown for empty input.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        NumberUtilsTest.assertEquals((String)"max(short[]) failed for array length 1", (int)5, (int)NumberUtils.max((short[])new short[]{5}));
        NumberUtilsTest.assertEquals((String)"max(short[]) failed for array length 2", (int)9, (int)NumberUtils.max((short[])new short[]{6, 9}));
        NumberUtilsTest.assertEquals((String)"max(short[]) failed for array length 5", (int)10, (int)NumberUtils.max((short[])new short[]{-10, -5, 0, 5, 10}));
        NumberUtilsTest.assertEquals((int)10, (int)NumberUtils.max((short[])new short[]{-10, -5, 0, 5, 10}));
        NumberUtilsTest.assertEquals((int)10, (int)NumberUtils.max((short[])new short[]{-5, 0, 10, 5, -10}));
    }

    public void testMaxByte() {
        byte[] b = null;
        try {
            NumberUtils.max(b);
            NumberUtilsTest.fail((String)"No exception was thrown for null input.");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            NumberUtils.max((byte[])new byte[0]);
            NumberUtilsTest.fail((String)"No exception was thrown for empty input.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        NumberUtilsTest.assertEquals((String)"max(byte[]) failed for array length 1", (int)5, (int)NumberUtils.max((byte[])new byte[]{5}));
        NumberUtilsTest.assertEquals((String)"max(byte[]) failed for array length 2", (int)9, (int)NumberUtils.max((byte[])new byte[]{6, 9}));
        NumberUtilsTest.assertEquals((String)"max(byte[]) failed for array length 5", (int)10, (int)NumberUtils.max((byte[])new byte[]{-10, -5, 0, 5, 10}));
        NumberUtilsTest.assertEquals((int)10, (int)NumberUtils.max((byte[])new byte[]{-10, -5, 0, 5, 10}));
        NumberUtilsTest.assertEquals((int)10, (int)NumberUtils.max((byte[])new byte[]{-5, 0, 10, 5, -10}));
    }

    public void testMaxDouble() {
        double[] d = null;
        try {
            NumberUtils.max(d);
            NumberUtilsTest.fail((String)"No exception was thrown for null input.");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            NumberUtils.max((double[])new double[0]);
            NumberUtilsTest.fail((String)"No exception was thrown for empty input.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        NumberUtilsTest.assertEquals((String)"max(double[]) failed for array length 1", (double)5.1f, (double)NumberUtils.max((double[])new double[]{5.1f}), (double)0.0);
        NumberUtilsTest.assertEquals((String)"max(double[]) failed for array length 2", (double)9.2f, (double)NumberUtils.max((double[])new double[]{6.3f, 9.2f}), (double)0.0);
        NumberUtilsTest.assertEquals((String)"max(double[]) failed for float length 5", (double)10.4f, (double)NumberUtils.max((double[])new double[]{-10.5, -5.6f, 0.0, 5.7f, 10.4f}), (double)0.0);
        NumberUtilsTest.assertEquals((double)10.0, (double)NumberUtils.max((double[])new double[]{-10.0, -5.0, 0.0, 5.0, 10.0}), (double)1.0E-4);
        NumberUtilsTest.assertEquals((double)10.0, (double)NumberUtils.max((double[])new double[]{-5.0, 0.0, 10.0, 5.0, -10.0}), (double)1.0E-4);
    }

    public void testMaxFloat() {
        float[] f = null;
        try {
            NumberUtils.max(f);
            NumberUtilsTest.fail((String)"No exception was thrown for null input.");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            NumberUtils.max((float[])new float[0]);
            NumberUtilsTest.fail((String)"No exception was thrown for empty input.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        NumberUtilsTest.assertEquals((String)"max(float[]) failed for array length 1", (float)5.1f, (float)NumberUtils.max((float[])new float[]{5.1f}), (float)0.0f);
        NumberUtilsTest.assertEquals((String)"max(float[]) failed for array length 2", (float)9.2f, (float)NumberUtils.max((float[])new float[]{6.3f, 9.2f}), (float)0.0f);
        NumberUtilsTest.assertEquals((String)"max(float[]) failed for float length 5", (float)10.4f, (float)NumberUtils.max((float[])new float[]{-10.5f, -5.6f, 0.0f, 5.7f, 10.4f}), (float)0.0f);
        NumberUtilsTest.assertEquals((float)10.0f, (float)NumberUtils.max((float[])new float[]{-10.0f, -5.0f, 0.0f, 5.0f, 10.0f}), (float)1.0E-4f);
        NumberUtilsTest.assertEquals((float)10.0f, (float)NumberUtils.max((float[])new float[]{-5.0f, 0.0f, 10.0f, 5.0f, -10.0f}), (float)1.0E-4f);
    }

    public void testMinimumLong() {
        NumberUtilsTest.assertEquals((String)"minimum(long,long,long) 1 failed", (long)12345L, (long)NumberUtils.min((long)12345L, (long)12346L, (long)12347L));
        NumberUtilsTest.assertEquals((String)"minimum(long,long,long) 2 failed", (long)12345L, (long)NumberUtils.min((long)12346L, (long)12345L, (long)12347L));
        NumberUtilsTest.assertEquals((String)"minimum(long,long,long) 3 failed", (long)12345L, (long)NumberUtils.min((long)12346L, (long)12347L, (long)12345L));
        NumberUtilsTest.assertEquals((String)"minimum(long,long,long) 4 failed", (long)12345L, (long)NumberUtils.min((long)12346L, (long)12345L, (long)12345L));
        NumberUtilsTest.assertEquals((String)"minimum(long,long,long) 5 failed", (long)12345L, (long)NumberUtils.min((long)12345L, (long)12345L, (long)12345L));
    }

    public void testMinimumInt() {
        NumberUtilsTest.assertEquals((String)"minimum(int,int,int) 1 failed", (int)12345, (int)NumberUtils.min((int)12345, (int)12346, (int)12347));
        NumberUtilsTest.assertEquals((String)"minimum(int,int,int) 2 failed", (int)12345, (int)NumberUtils.min((int)12346, (int)12345, (int)12347));
        NumberUtilsTest.assertEquals((String)"minimum(int,int,int) 3 failed", (int)12345, (int)NumberUtils.min((int)12346, (int)12347, (int)12345));
        NumberUtilsTest.assertEquals((String)"minimum(int,int,int) 4 failed", (int)12345, (int)NumberUtils.min((int)12346, (int)12345, (int)12345));
        NumberUtilsTest.assertEquals((String)"minimum(int,int,int) 5 failed", (int)12345, (int)NumberUtils.min((int)12345, (int)12345, (int)12345));
    }

    public void testMinimumShort() {
        short low = 1234;
        short mid = 1235;
        short high = 1236;
        NumberUtilsTest.assertEquals((String)"minimum(short,short,short) 1 failed", (short)low, (short)NumberUtils.min((short)low, (short)mid, (short)high));
        NumberUtilsTest.assertEquals((String)"minimum(short,short,short) 1 failed", (short)low, (short)NumberUtils.min((short)mid, (short)low, (short)high));
        NumberUtilsTest.assertEquals((String)"minimum(short,short,short) 1 failed", (short)low, (short)NumberUtils.min((short)mid, (short)high, (short)low));
        NumberUtilsTest.assertEquals((String)"minimum(short,short,short) 1 failed", (short)low, (short)NumberUtils.min((short)low, (short)mid, (short)low));
    }

    public void testMinimumByte() {
        byte low = 123;
        byte mid = 124;
        byte high = 125;
        NumberUtilsTest.assertEquals((String)"minimum(byte,byte,byte) 1 failed", (byte)low, (byte)NumberUtils.min((byte)low, (byte)mid, (byte)high));
        NumberUtilsTest.assertEquals((String)"minimum(byte,byte,byte) 1 failed", (byte)low, (byte)NumberUtils.min((byte)mid, (byte)low, (byte)high));
        NumberUtilsTest.assertEquals((String)"minimum(byte,byte,byte) 1 failed", (byte)low, (byte)NumberUtils.min((byte)mid, (byte)high, (byte)low));
        NumberUtilsTest.assertEquals((String)"minimum(byte,byte,byte) 1 failed", (byte)low, (byte)NumberUtils.min((byte)low, (byte)mid, (byte)low));
    }

    public void testMinimumDouble() {
        double low = 12.3;
        double mid = 13.3;
        double high = 14.3;
        NumberUtilsTest.assertEquals((double)low, (double)NumberUtils.min((double)low, (double)mid, (double)high), (double)1.0E-4);
        NumberUtilsTest.assertEquals((double)low, (double)NumberUtils.min((double)mid, (double)low, (double)high), (double)1.0E-4);
        NumberUtilsTest.assertEquals((double)low, (double)NumberUtils.min((double)mid, (double)high, (double)low), (double)1.0E-4);
        NumberUtilsTest.assertEquals((double)low, (double)NumberUtils.min((double)low, (double)mid, (double)low), (double)1.0E-4);
        NumberUtilsTest.assertEquals((double)mid, (double)NumberUtils.min((double)high, (double)mid, (double)high), (double)1.0E-4);
    }

    public void testMinimumFloat() {
        float low = 12.3f;
        float mid = 13.3f;
        float high = 14.3f;
        NumberUtilsTest.assertEquals((float)low, (float)NumberUtils.min((float)low, (float)mid, (float)high), (float)1.0E-4f);
        NumberUtilsTest.assertEquals((float)low, (float)NumberUtils.min((float)mid, (float)low, (float)high), (float)1.0E-4f);
        NumberUtilsTest.assertEquals((float)low, (float)NumberUtils.min((float)mid, (float)high, (float)low), (float)1.0E-4f);
        NumberUtilsTest.assertEquals((float)low, (float)NumberUtils.min((float)low, (float)mid, (float)low), (float)1.0E-4f);
        NumberUtilsTest.assertEquals((float)mid, (float)NumberUtils.min((float)high, (float)mid, (float)high), (float)1.0E-4f);
    }

    public void testMaximumLong() {
        NumberUtilsTest.assertEquals((String)"maximum(long,long,long) 1 failed", (long)12345L, (long)NumberUtils.max((long)12345L, (long)12344L, (long)12343L));
        NumberUtilsTest.assertEquals((String)"maximum(long,long,long) 2 failed", (long)12345L, (long)NumberUtils.max((long)12344L, (long)12345L, (long)12343L));
        NumberUtilsTest.assertEquals((String)"maximum(long,long,long) 3 failed", (long)12345L, (long)NumberUtils.max((long)12344L, (long)12343L, (long)12345L));
        NumberUtilsTest.assertEquals((String)"maximum(long,long,long) 4 failed", (long)12345L, (long)NumberUtils.max((long)12344L, (long)12345L, (long)12345L));
        NumberUtilsTest.assertEquals((String)"maximum(long,long,long) 5 failed", (long)12345L, (long)NumberUtils.max((long)12345L, (long)12345L, (long)12345L));
    }

    public void testMaximumInt() {
        NumberUtilsTest.assertEquals((String)"maximum(int,int,int) 1 failed", (int)12345, (int)NumberUtils.max((int)12345, (int)12344, (int)12343));
        NumberUtilsTest.assertEquals((String)"maximum(int,int,int) 2 failed", (int)12345, (int)NumberUtils.max((int)12344, (int)12345, (int)12343));
        NumberUtilsTest.assertEquals((String)"maximum(int,int,int) 3 failed", (int)12345, (int)NumberUtils.max((int)12344, (int)12343, (int)12345));
        NumberUtilsTest.assertEquals((String)"maximum(int,int,int) 4 failed", (int)12345, (int)NumberUtils.max((int)12344, (int)12345, (int)12345));
        NumberUtilsTest.assertEquals((String)"maximum(int,int,int) 5 failed", (int)12345, (int)NumberUtils.max((int)12345, (int)12345, (int)12345));
    }

    public void testMaximumShort() {
        short low = 1234;
        short mid = 1235;
        short high = 1236;
        NumberUtilsTest.assertEquals((String)"maximum(short,short,short) 1 failed", (short)high, (short)NumberUtils.max((short)low, (short)mid, (short)high));
        NumberUtilsTest.assertEquals((String)"maximum(short,short,short) 1 failed", (short)high, (short)NumberUtils.max((short)mid, (short)low, (short)high));
        NumberUtilsTest.assertEquals((String)"maximum(short,short,short) 1 failed", (short)high, (short)NumberUtils.max((short)mid, (short)high, (short)low));
        NumberUtilsTest.assertEquals((String)"maximum(short,short,short) 1 failed", (short)high, (short)NumberUtils.max((short)high, (short)mid, (short)high));
    }

    public void testMaximumByte() {
        byte low = 123;
        byte mid = 124;
        byte high = 125;
        NumberUtilsTest.assertEquals((String)"maximum(byte,byte,byte) 1 failed", (byte)high, (byte)NumberUtils.max((byte)low, (byte)mid, (byte)high));
        NumberUtilsTest.assertEquals((String)"maximum(byte,byte,byte) 1 failed", (byte)high, (byte)NumberUtils.max((byte)mid, (byte)low, (byte)high));
        NumberUtilsTest.assertEquals((String)"maximum(byte,byte,byte) 1 failed", (byte)high, (byte)NumberUtils.max((byte)mid, (byte)high, (byte)low));
        NumberUtilsTest.assertEquals((String)"maximum(byte,byte,byte) 1 failed", (byte)high, (byte)NumberUtils.max((byte)high, (byte)mid, (byte)high));
    }

    public void testMaximumDouble() {
        double low = 12.3;
        double mid = 13.3;
        double high = 14.3;
        NumberUtilsTest.assertEquals((double)high, (double)NumberUtils.max((double)low, (double)mid, (double)high), (double)1.0E-4);
        NumberUtilsTest.assertEquals((double)high, (double)NumberUtils.max((double)mid, (double)low, (double)high), (double)1.0E-4);
        NumberUtilsTest.assertEquals((double)high, (double)NumberUtils.max((double)mid, (double)high, (double)low), (double)1.0E-4);
        NumberUtilsTest.assertEquals((double)mid, (double)NumberUtils.max((double)low, (double)mid, (double)low), (double)1.0E-4);
        NumberUtilsTest.assertEquals((double)high, (double)NumberUtils.max((double)high, (double)mid, (double)high), (double)1.0E-4);
    }

    public void testMaximumFloat() {
        float low = 12.3f;
        float mid = 13.3f;
        float high = 14.3f;
        NumberUtilsTest.assertEquals((float)high, (float)NumberUtils.max((float)low, (float)mid, (float)high), (float)1.0E-4f);
        NumberUtilsTest.assertEquals((float)high, (float)NumberUtils.max((float)mid, (float)low, (float)high), (float)1.0E-4f);
        NumberUtilsTest.assertEquals((float)high, (float)NumberUtils.max((float)mid, (float)high, (float)low), (float)1.0E-4f);
        NumberUtilsTest.assertEquals((float)mid, (float)NumberUtils.max((float)low, (float)mid, (float)low), (float)1.0E-4f);
        NumberUtilsTest.assertEquals((float)high, (float)NumberUtils.max((float)high, (float)mid, (float)high), (float)1.0E-4f);
    }

    public void testCompareDouble() {
        NumberUtilsTest.assertTrue((Double.compare(Double.NaN, Double.NaN) == 0 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(Double.NaN, Double.POSITIVE_INFINITY) == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(Double.NaN, Double.MAX_VALUE) == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(Double.NaN, 1.2) == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(Double.NaN, 0.0) == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(Double.NaN, -0.0) == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(Double.NaN, -1.2) == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(Double.NaN, -1.7976931348623157E308) == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(Double.NaN, Double.NEGATIVE_INFINITY) == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(Double.POSITIVE_INFINITY, Double.NaN) == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY) == 0 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(Double.POSITIVE_INFINITY, Double.MAX_VALUE) == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(Double.POSITIVE_INFINITY, 1.2) == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(Double.POSITIVE_INFINITY, 0.0) == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(Double.POSITIVE_INFINITY, -0.0) == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(Double.POSITIVE_INFINITY, -1.2) == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(Double.POSITIVE_INFINITY, -1.7976931348623157E308) == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY) == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(Double.MAX_VALUE, Double.NaN) == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(Double.MAX_VALUE, Double.POSITIVE_INFINITY) == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(Double.MAX_VALUE, Double.MAX_VALUE) == 0 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(Double.MAX_VALUE, 1.2) == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(Double.MAX_VALUE, 0.0) == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(Double.MAX_VALUE, -0.0) == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(Double.MAX_VALUE, -1.2) == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(Double.MAX_VALUE, -1.7976931348623157E308) == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(Double.MAX_VALUE, Double.NEGATIVE_INFINITY) == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(1.2, Double.NaN) == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(1.2, Double.POSITIVE_INFINITY) == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(1.2, Double.MAX_VALUE) == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(1.2, 1.2) == 0 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(1.2, 0.0) == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(1.2, -0.0) == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(1.2, -1.2) == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(1.2, -1.7976931348623157E308) == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(1.2, Double.NEGATIVE_INFINITY) == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(0.0, Double.NaN) == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(0.0, Double.POSITIVE_INFINITY) == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(0.0, Double.MAX_VALUE) == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(0.0, 1.2) == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(0.0, 0.0) == 0 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(0.0, -0.0) == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(0.0, -1.2) == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(0.0, -1.7976931348623157E308) == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(0.0, Double.NEGATIVE_INFINITY) == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(-0.0, Double.NaN) == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(-0.0, Double.POSITIVE_INFINITY) == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(-0.0, Double.MAX_VALUE) == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(-0.0, 1.2) == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(-0.0, 0.0) == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(-0.0, -0.0) == 0 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(-0.0, -1.2) == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(-0.0, -1.7976931348623157E308) == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(-0.0, Double.NEGATIVE_INFINITY) == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(-1.2, Double.NaN) == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(-1.2, Double.POSITIVE_INFINITY) == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(-1.2, Double.MAX_VALUE) == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(-1.2, 1.2) == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(-1.2, 0.0) == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(-1.2, -0.0) == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(-1.2, -1.2) == 0 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(-1.2, -1.7976931348623157E308) == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(-1.2, Double.NEGATIVE_INFINITY) == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(-1.7976931348623157E308, Double.NaN) == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(-1.7976931348623157E308, Double.POSITIVE_INFINITY) == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(-1.7976931348623157E308, Double.MAX_VALUE) == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(-1.7976931348623157E308, 1.2) == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(-1.7976931348623157E308, 0.0) == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(-1.7976931348623157E308, -0.0) == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(-1.7976931348623157E308, -1.2) == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(-1.7976931348623157E308, -1.7976931348623157E308) == 0 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(-1.7976931348623157E308, Double.NEGATIVE_INFINITY) == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(Double.NEGATIVE_INFINITY, Double.NaN) == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY) == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(Double.NEGATIVE_INFINITY, Double.MAX_VALUE) == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(Double.NEGATIVE_INFINITY, 1.2) == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(Double.NEGATIVE_INFINITY, 0.0) == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(Double.NEGATIVE_INFINITY, -0.0) == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(Double.NEGATIVE_INFINITY, -1.2) == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(Double.NEGATIVE_INFINITY, -1.7976931348623157E308) == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Double.compare(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY) == 0 ? 1 : 0) != 0);
    }

    public void testCompareFloat() {
        NumberUtilsTest.assertTrue((Float.compare(Float.NaN, Float.NaN) == 0 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(Float.NaN, Float.POSITIVE_INFINITY) == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(Float.NaN, Float.MAX_VALUE) == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(Float.NaN, 1.2f) == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(Float.NaN, 0.0f) == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(Float.NaN, -0.0f) == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(Float.NaN, -1.2f) == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(Float.NaN, -3.4028235E38f) == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(Float.NaN, Float.NEGATIVE_INFINITY) == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(Float.POSITIVE_INFINITY, Float.NaN) == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY) == 0 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(Float.POSITIVE_INFINITY, Float.MAX_VALUE) == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(Float.POSITIVE_INFINITY, 1.2f) == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(Float.POSITIVE_INFINITY, 0.0f) == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(Float.POSITIVE_INFINITY, -0.0f) == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(Float.POSITIVE_INFINITY, -1.2f) == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(Float.POSITIVE_INFINITY, -3.4028235E38f) == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(Float.POSITIVE_INFINITY, Float.NEGATIVE_INFINITY) == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(Float.MAX_VALUE, Float.NaN) == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(Float.MAX_VALUE, Float.POSITIVE_INFINITY) == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(Float.MAX_VALUE, Float.MAX_VALUE) == 0 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(Float.MAX_VALUE, 1.2f) == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(Float.MAX_VALUE, 0.0f) == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(Float.MAX_VALUE, -0.0f) == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(Float.MAX_VALUE, -1.2f) == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(Float.MAX_VALUE, -3.4028235E38f) == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(Float.MAX_VALUE, Float.NEGATIVE_INFINITY) == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(1.2f, Float.NaN) == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(1.2f, Float.POSITIVE_INFINITY) == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(1.2f, Float.MAX_VALUE) == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(1.2f, 1.2f) == 0 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(1.2f, 0.0f) == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(1.2f, -0.0f) == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(1.2f, -1.2f) == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(1.2f, -3.4028235E38f) == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(1.2f, Float.NEGATIVE_INFINITY) == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(0.0f, Float.NaN) == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(0.0f, Float.POSITIVE_INFINITY) == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(0.0f, Float.MAX_VALUE) == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(0.0f, 1.2f) == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(0.0f, 0.0f) == 0 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(0.0f, -0.0f) == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(0.0f, -1.2f) == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(0.0f, -3.4028235E38f) == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(0.0f, Float.NEGATIVE_INFINITY) == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(-0.0f, Float.NaN) == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(-0.0f, Float.POSITIVE_INFINITY) == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(-0.0f, Float.MAX_VALUE) == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(-0.0f, 1.2f) == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(-0.0f, 0.0f) == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(-0.0f, -0.0f) == 0 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(-0.0f, -1.2f) == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(-0.0f, -3.4028235E38f) == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(-0.0f, Float.NEGATIVE_INFINITY) == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(-1.2f, Float.NaN) == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(-1.2f, Float.POSITIVE_INFINITY) == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(-1.2f, Float.MAX_VALUE) == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(-1.2f, 1.2f) == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(-1.2f, 0.0f) == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(-1.2f, -0.0f) == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(-1.2f, -1.2f) == 0 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(-1.2f, -3.4028235E38f) == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(-1.2f, Float.NEGATIVE_INFINITY) == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(-3.4028235E38f, Float.NaN) == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(-3.4028235E38f, Float.POSITIVE_INFINITY) == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(-3.4028235E38f, Float.MAX_VALUE) == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(-3.4028235E38f, 1.2f) == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(-3.4028235E38f, 0.0f) == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(-3.4028235E38f, -0.0f) == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(-3.4028235E38f, -1.2f) == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(-3.4028235E38f, -3.4028235E38f) == 0 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(-3.4028235E38f, Float.NEGATIVE_INFINITY) == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(Float.NEGATIVE_INFINITY, Float.NaN) == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY) == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(Float.NEGATIVE_INFINITY, Float.MAX_VALUE) == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(Float.NEGATIVE_INFINITY, 1.2f) == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(Float.NEGATIVE_INFINITY, 0.0f) == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(Float.NEGATIVE_INFINITY, -0.0f) == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(Float.NEGATIVE_INFINITY, -1.2f) == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(Float.NEGATIVE_INFINITY, -3.4028235E38f) == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((Float.compare(Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY) == 0 ? 1 : 0) != 0);
    }

    public void testIsDigits() {
        NumberUtilsTest.assertEquals((String)"isDigits(null) failed", (boolean)false, (boolean)NumberUtils.isDigits(null));
        NumberUtilsTest.assertEquals((String)"isDigits('') failed", (boolean)false, (boolean)NumberUtils.isDigits((String)""));
        NumberUtilsTest.assertEquals((String)"isDigits(String) failed", (boolean)true, (boolean)NumberUtils.isDigits((String)"12345"));
        NumberUtilsTest.assertEquals((String)"isDigits(String) neg 1 failed", (boolean)false, (boolean)NumberUtils.isDigits((String)"1234.5"));
        NumberUtilsTest.assertEquals((String)"isDigits(String) neg 3 failed", (boolean)false, (boolean)NumberUtils.isDigits((String)"1ab"));
        NumberUtilsTest.assertEquals((String)"isDigits(String) neg 4 failed", (boolean)false, (boolean)NumberUtils.isDigits((String)"abc"));
    }

    public void testIsNumber() {
        String val = "12345";
        NumberUtilsTest.assertTrue((String)"isNumber(String) 1 failed", (boolean)NumberUtils.isNumber((String)val));
        NumberUtilsTest.assertTrue((String)"isNumber(String)/createNumber(String) 1 failed", (boolean)this.checkCreateNumber(val));
        val = "1234.5";
        NumberUtilsTest.assertTrue((String)"isNumber(String) 2 failed", (boolean)NumberUtils.isNumber((String)val));
        NumberUtilsTest.assertTrue((String)"isNumber(String)/createNumber(String) 2 failed", (boolean)this.checkCreateNumber(val));
        val = ".12345";
        NumberUtilsTest.assertTrue((String)"isNumber(String) 3 failed", (boolean)NumberUtils.isNumber((String)val));
        NumberUtilsTest.assertTrue((String)"isNumber(String)/createNumber(String) 3 failed", (boolean)this.checkCreateNumber(val));
        val = "1234E5";
        NumberUtilsTest.assertTrue((String)"isNumber(String) 4 failed", (boolean)NumberUtils.isNumber((String)val));
        NumberUtilsTest.assertTrue((String)"isNumber(String)/createNumber(String) 4 failed", (boolean)this.checkCreateNumber(val));
        val = "1234E+5";
        NumberUtilsTest.assertTrue((String)"isNumber(String) 5 failed", (boolean)NumberUtils.isNumber((String)val));
        NumberUtilsTest.assertTrue((String)"isNumber(String)/createNumber(String) 5 failed", (boolean)this.checkCreateNumber(val));
        val = "1234E-5";
        NumberUtilsTest.assertTrue((String)"isNumber(String) 6 failed", (boolean)NumberUtils.isNumber((String)val));
        NumberUtilsTest.assertTrue((String)"isNumber(String)/createNumber(String) 6 failed", (boolean)this.checkCreateNumber(val));
        val = "123.4E5";
        NumberUtilsTest.assertTrue((String)"isNumber(String) 7 failed", (boolean)NumberUtils.isNumber((String)val));
        NumberUtilsTest.assertTrue((String)"isNumber(String)/createNumber(String) 7 failed", (boolean)this.checkCreateNumber(val));
        val = "-1234";
        NumberUtilsTest.assertTrue((String)"isNumber(String) 8 failed", (boolean)NumberUtils.isNumber((String)val));
        NumberUtilsTest.assertTrue((String)"isNumber(String)/createNumber(String) 8 failed", (boolean)this.checkCreateNumber(val));
        val = "-1234.5";
        NumberUtilsTest.assertTrue((String)"isNumber(String) 9 failed", (boolean)NumberUtils.isNumber((String)val));
        NumberUtilsTest.assertTrue((String)"isNumber(String)/createNumber(String) 9 failed", (boolean)this.checkCreateNumber(val));
        val = "-.12345";
        NumberUtilsTest.assertTrue((String)"isNumber(String) 10 failed", (boolean)NumberUtils.isNumber((String)val));
        NumberUtilsTest.assertTrue((String)"isNumber(String)/createNumber(String) 10 failed", (boolean)this.checkCreateNumber(val));
        val = "-1234E5";
        NumberUtilsTest.assertTrue((String)"isNumber(String) 11 failed", (boolean)NumberUtils.isNumber((String)val));
        NumberUtilsTest.assertTrue((String)"isNumber(String)/createNumber(String) 11 failed", (boolean)this.checkCreateNumber(val));
        val = "0";
        NumberUtilsTest.assertTrue((String)"isNumber(String) 12 failed", (boolean)NumberUtils.isNumber((String)val));
        NumberUtilsTest.assertTrue((String)"isNumber(String)/createNumber(String) 12 failed", (boolean)this.checkCreateNumber(val));
        val = "-0";
        NumberUtilsTest.assertTrue((String)"isNumber(String) 13 failed", (boolean)NumberUtils.isNumber((String)val));
        NumberUtilsTest.assertTrue((String)"isNumber(String)/createNumber(String) 13 failed", (boolean)this.checkCreateNumber(val));
        val = "01234";
        NumberUtilsTest.assertTrue((String)"isNumber(String) 14 failed", (boolean)NumberUtils.isNumber((String)val));
        NumberUtilsTest.assertTrue((String)"isNumber(String)/createNumber(String) 14 failed", (boolean)this.checkCreateNumber(val));
        val = "-01234";
        NumberUtilsTest.assertTrue((String)"isNumber(String) 15 failed", (boolean)NumberUtils.isNumber((String)val));
        NumberUtilsTest.assertTrue((String)"isNumber(String)/createNumber(String) 15 failed", (boolean)this.checkCreateNumber(val));
        val = "0xABC123";
        NumberUtilsTest.assertTrue((String)"isNumber(String) 16 failed", (boolean)NumberUtils.isNumber((String)val));
        NumberUtilsTest.assertTrue((String)"isNumber(String)/createNumber(String) 16 failed", (boolean)this.checkCreateNumber(val));
        val = "0x0";
        NumberUtilsTest.assertTrue((String)"isNumber(String) 17 failed", (boolean)NumberUtils.isNumber((String)val));
        NumberUtilsTest.assertTrue((String)"isNumber(String)/createNumber(String) 17 failed", (boolean)this.checkCreateNumber(val));
        val = "123.4E21D";
        NumberUtilsTest.assertTrue((String)"isNumber(String) 19 failed", (boolean)NumberUtils.isNumber((String)val));
        NumberUtilsTest.assertTrue((String)"isNumber(String)/createNumber(String) 19 failed", (boolean)this.checkCreateNumber(val));
        val = "-221.23F";
        NumberUtilsTest.assertTrue((String)"isNumber(String) 20 failed", (boolean)NumberUtils.isNumber((String)val));
        NumberUtilsTest.assertTrue((String)"isNumber(String)/createNumber(String) 20 failed", (boolean)this.checkCreateNumber(val));
        val = "22338L";
        NumberUtilsTest.assertTrue((String)"isNumber(String) 21 failed", (boolean)NumberUtils.isNumber((String)val));
        NumberUtilsTest.assertTrue((String)"isNumber(String)/createNumber(String) 21 failed", (boolean)this.checkCreateNumber(val));
        val = null;
        NumberUtilsTest.assertTrue((String)"isNumber(String) 1 Neg failed", (!NumberUtils.isNumber((String)val) ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((String)"isNumber(String)/createNumber(String) 1 Neg failed", (!this.checkCreateNumber(val) ? 1 : 0) != 0);
        val = "";
        NumberUtilsTest.assertTrue((String)"isNumber(String) 2 Neg failed", (!NumberUtils.isNumber((String)val) ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((String)"isNumber(String)/createNumber(String) 2 Neg failed", (!this.checkCreateNumber(val) ? 1 : 0) != 0);
        val = "--2.3";
        NumberUtilsTest.assertTrue((String)"isNumber(String) 3 Neg failed", (!NumberUtils.isNumber((String)val) ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((String)"isNumber(String)/createNumber(String) 3 Neg failed", (!this.checkCreateNumber(val) ? 1 : 0) != 0);
        val = ".12.3";
        NumberUtilsTest.assertTrue((String)"isNumber(String) 4 Neg failed", (!NumberUtils.isNumber((String)val) ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((String)"isNumber(String)/createNumber(String) 4 Neg failed", (!this.checkCreateNumber(val) ? 1 : 0) != 0);
        val = "-123E";
        NumberUtilsTest.assertTrue((String)"isNumber(String) 5 Neg failed", (!NumberUtils.isNumber((String)val) ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((String)"isNumber(String)/createNumber(String) 5 Neg failed", (!this.checkCreateNumber(val) ? 1 : 0) != 0);
        val = "-123E+-212";
        NumberUtilsTest.assertTrue((String)"isNumber(String) 6 Neg failed", (!NumberUtils.isNumber((String)val) ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((String)"isNumber(String)/createNumber(String) 6 Neg failed", (!this.checkCreateNumber(val) ? 1 : 0) != 0);
        val = "-123E2.12";
        NumberUtilsTest.assertTrue((String)"isNumber(String) 7 Neg failed", (!NumberUtils.isNumber((String)val) ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((String)"isNumber(String)/createNumber(String) 7 Neg failed", (!this.checkCreateNumber(val) ? 1 : 0) != 0);
        val = "0xGF";
        NumberUtilsTest.assertTrue((String)"isNumber(String) 8 Neg failed", (!NumberUtils.isNumber((String)val) ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((String)"isNumber(String)/createNumber(String) 8 Neg failed", (!this.checkCreateNumber(val) ? 1 : 0) != 0);
        val = "0xFAE-1";
        NumberUtilsTest.assertTrue((String)"isNumber(String) 9 Neg failed", (!NumberUtils.isNumber((String)val) ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((String)"isNumber(String)/createNumber(String) 9 Neg failed", (!this.checkCreateNumber(val) ? 1 : 0) != 0);
        val = ".";
        NumberUtilsTest.assertTrue((String)"isNumber(String) 10 Neg failed", (!NumberUtils.isNumber((String)val) ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((String)"isNumber(String)/createNumber(String) 10 Neg failed", (!this.checkCreateNumber(val) ? 1 : 0) != 0);
        val = "-0ABC123";
        NumberUtilsTest.assertTrue((String)"isNumber(String) 11 Neg failed", (!NumberUtils.isNumber((String)val) ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((String)"isNumber(String)/createNumber(String) 11 Neg failed", (!this.checkCreateNumber(val) ? 1 : 0) != 0);
        val = "123.4E-D";
        NumberUtilsTest.assertTrue((String)"isNumber(String) 12 Neg failed", (!NumberUtils.isNumber((String)val) ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((String)"isNumber(String)/createNumber(String) 12 Neg failed", (!this.checkCreateNumber(val) ? 1 : 0) != 0);
        val = "123.4ED";
        NumberUtilsTest.assertTrue((String)"isNumber(String) 13 Neg failed", (!NumberUtils.isNumber((String)val) ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((String)"isNumber(String)/createNumber(String) 13 Neg failed", (!this.checkCreateNumber(val) ? 1 : 0) != 0);
        val = "1234E5l";
        NumberUtilsTest.assertTrue((String)"isNumber(String) 14 Neg failed", (!NumberUtils.isNumber((String)val) ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((String)"isNumber(String)/createNumber(String) 14 Neg failed", (!this.checkCreateNumber(val) ? 1 : 0) != 0);
        val = "11a";
        NumberUtilsTest.assertTrue((String)"isNumber(String) 15 Neg failed", (!NumberUtils.isNumber((String)val) ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((String)"isNumber(String)/createNumber(String) 15 Neg failed", (!this.checkCreateNumber(val) ? 1 : 0) != 0);
        val = "1a";
        NumberUtilsTest.assertTrue((String)"isNumber(String) 16 Neg failed", (!NumberUtils.isNumber((String)val) ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((String)"isNumber(String)/createNumber(String) 16 Neg failed", (!this.checkCreateNumber(val) ? 1 : 0) != 0);
        val = "a";
        NumberUtilsTest.assertTrue((String)"isNumber(String) 17 Neg failed", (!NumberUtils.isNumber((String)val) ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((String)"isNumber(String)/createNumber(String) 17 Neg failed", (!this.checkCreateNumber(val) ? 1 : 0) != 0);
        val = "11g";
        NumberUtilsTest.assertTrue((String)"isNumber(String) 18 Neg failed", (!NumberUtils.isNumber((String)val) ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((String)"isNumber(String)/createNumber(String) 18 Neg failed", (!this.checkCreateNumber(val) ? 1 : 0) != 0);
        val = "11z";
        NumberUtilsTest.assertTrue((String)"isNumber(String) 19 Neg failed", (!NumberUtils.isNumber((String)val) ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((String)"isNumber(String)/createNumber(String) 19 Neg failed", (!this.checkCreateNumber(val) ? 1 : 0) != 0);
        val = "11def";
        NumberUtilsTest.assertTrue((String)"isNumber(String) 20 Neg failed", (!NumberUtils.isNumber((String)val) ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((String)"isNumber(String)/createNumber(String) 20 Neg failed", (!this.checkCreateNumber(val) ? 1 : 0) != 0);
        val = "11d11";
        NumberUtilsTest.assertTrue((String)"isNumber(String) 21 Neg failed", (!NumberUtils.isNumber((String)val) ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((String)"isNumber(String)/createNumber(String) 21 Neg failed", (!this.checkCreateNumber(val) ? 1 : 0) != 0);
        val = "11 11";
        NumberUtilsTest.assertTrue((String)"isNumber(String) 22 Neg failed", (!NumberUtils.isNumber((String)val) ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((String)"isNumber(String)/createNumber(String) 22 Neg failed", (!this.checkCreateNumber(val) ? 1 : 0) != 0);
        val = " 1111";
        NumberUtilsTest.assertTrue((String)"isNumber(String) 23 Neg failed", (!NumberUtils.isNumber((String)val) ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((String)"isNumber(String)/createNumber(String) 23 Neg failed", (!this.checkCreateNumber(val) ? 1 : 0) != 0);
        val = "1111 ";
        NumberUtilsTest.assertTrue((String)"isNumber(String) 24 Neg failed", (!NumberUtils.isNumber((String)val) ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((String)"isNumber(String)/createNumber(String) 24 Neg failed", (!this.checkCreateNumber(val) ? 1 : 0) != 0);
        val = "2.";
        NumberUtilsTest.assertTrue((String)"isNumber(String) LANG-521 failed", (boolean)NumberUtils.isNumber((String)val));
        val = "1.1L";
        NumberUtilsTest.assertFalse((String)"isNumber(String) LANG-664 failed", (boolean)NumberUtils.isNumber((String)val));
    }

    private boolean checkCreateNumber(String val) {
        try {
            Number obj = NumberUtils.createNumber((String)val);
            return obj != null;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public void testConstants() {
        NumberUtilsTest.assertTrue((boolean)(NumberUtils.LONG_ZERO instanceof Long));
        NumberUtilsTest.assertTrue((boolean)(NumberUtils.LONG_ONE instanceof Long));
        NumberUtilsTest.assertTrue((boolean)(NumberUtils.LONG_MINUS_ONE instanceof Long));
        NumberUtilsTest.assertTrue((boolean)(NumberUtils.INTEGER_ZERO instanceof Integer));
        NumberUtilsTest.assertTrue((boolean)(NumberUtils.INTEGER_ONE instanceof Integer));
        NumberUtilsTest.assertTrue((boolean)(NumberUtils.INTEGER_MINUS_ONE instanceof Integer));
        NumberUtilsTest.assertTrue((boolean)(NumberUtils.SHORT_ZERO instanceof Short));
        NumberUtilsTest.assertTrue((boolean)(NumberUtils.SHORT_ONE instanceof Short));
        NumberUtilsTest.assertTrue((boolean)(NumberUtils.SHORT_MINUS_ONE instanceof Short));
        NumberUtilsTest.assertTrue((boolean)(NumberUtils.BYTE_ZERO instanceof Byte));
        NumberUtilsTest.assertTrue((boolean)(NumberUtils.BYTE_ONE instanceof Byte));
        NumberUtilsTest.assertTrue((boolean)(NumberUtils.BYTE_MINUS_ONE instanceof Byte));
        NumberUtilsTest.assertTrue((boolean)(NumberUtils.DOUBLE_ZERO instanceof Double));
        NumberUtilsTest.assertTrue((boolean)(NumberUtils.DOUBLE_ONE instanceof Double));
        NumberUtilsTest.assertTrue((boolean)(NumberUtils.DOUBLE_MINUS_ONE instanceof Double));
        NumberUtilsTest.assertTrue((boolean)(NumberUtils.FLOAT_ZERO instanceof Float));
        NumberUtilsTest.assertTrue((boolean)(NumberUtils.FLOAT_ONE instanceof Float));
        NumberUtilsTest.assertTrue((boolean)(NumberUtils.FLOAT_MINUS_ONE instanceof Float));
        NumberUtilsTest.assertTrue((NumberUtils.LONG_ZERO == 0L ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((NumberUtils.LONG_ONE == 1L ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((NumberUtils.LONG_MINUS_ONE == -1L ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((NumberUtils.INTEGER_ZERO == 0 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((NumberUtils.INTEGER_ONE == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((NumberUtils.INTEGER_MINUS_ONE == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((NumberUtils.SHORT_ZERO == 0 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((NumberUtils.SHORT_ONE == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((NumberUtils.SHORT_MINUS_ONE == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((NumberUtils.BYTE_ZERO == 0 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((NumberUtils.BYTE_ONE == 1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((NumberUtils.BYTE_MINUS_ONE == -1 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((NumberUtils.DOUBLE_ZERO == 0.0 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((NumberUtils.DOUBLE_ONE == 1.0 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((NumberUtils.DOUBLE_MINUS_ONE == -1.0 ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((NumberUtils.FLOAT_ZERO.floatValue() == 0.0f ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((NumberUtils.FLOAT_ONE.floatValue() == 1.0f ? 1 : 0) != 0);
        NumberUtilsTest.assertTrue((NumberUtils.FLOAT_MINUS_ONE.floatValue() == -1.0f ? 1 : 0) != 0);
    }

    public void testLang300() {
        NumberUtils.createNumber((String)"-1l");
        NumberUtils.createNumber((String)"01l");
        NumberUtils.createNumber((String)"1l");
    }

    public void testLang381() {
        NumberUtilsTest.assertTrue((boolean)Double.isNaN(NumberUtils.min((double)1.2, (double)2.5, (double)Double.NaN)));
        NumberUtilsTest.assertTrue((boolean)Double.isNaN(NumberUtils.max((double)1.2, (double)2.5, (double)Double.NaN)));
        NumberUtilsTest.assertTrue((boolean)Float.isNaN(NumberUtils.min((float)1.2f, (float)2.5f, (float)Float.NaN)));
        NumberUtilsTest.assertTrue((boolean)Float.isNaN(NumberUtils.max((float)1.2f, (float)2.5f, (float)Float.NaN)));
        double[] a = new double[]{1.2, Double.NaN, 3.7, 27.0, 42.0, Double.NaN};
        NumberUtilsTest.assertTrue((boolean)Double.isNaN(NumberUtils.max((double[])a)));
        NumberUtilsTest.assertTrue((boolean)Double.isNaN(NumberUtils.min((double[])a)));
        double[] b = new double[]{Double.NaN, 1.2, Double.NaN, 3.7, 27.0, 42.0, Double.NaN};
        NumberUtilsTest.assertTrue((boolean)Double.isNaN(NumberUtils.max((double[])b)));
        NumberUtilsTest.assertTrue((boolean)Double.isNaN(NumberUtils.min((double[])b)));
        float[] aF = new float[]{1.2f, Float.NaN, 3.7f, 27.0f, 42.0f, Float.NaN};
        NumberUtilsTest.assertTrue((boolean)Float.isNaN(NumberUtils.max((float[])aF)));
        float[] bF = new float[]{Float.NaN, 1.2f, Float.NaN, 3.7f, 27.0f, 42.0f, Float.NaN};
        NumberUtilsTest.assertTrue((boolean)Float.isNaN(NumberUtils.max((float[])bF)));
    }
}

