/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.mutable;

import junit.framework.TestCase;
import org.apache.commons.lang3.mutable.MutableDouble;

public class MutableDoubleTest
extends TestCase {
    public MutableDoubleTest(String testName) {
        super(testName);
    }

    public void testConstructors() {
        MutableDoubleTest.assertEquals((double)0.0, (double)new MutableDouble().doubleValue(), (double)1.0E-4);
        MutableDoubleTest.assertEquals((double)1.0, (double)new MutableDouble(1.0).doubleValue(), (double)1.0E-4);
        MutableDoubleTest.assertEquals((double)2.0, (double)new MutableDouble((Number)new Double(2.0)).doubleValue(), (double)1.0E-4);
        MutableDoubleTest.assertEquals((double)3.0, (double)new MutableDouble((Number)new MutableDouble(3.0)).doubleValue(), (double)1.0E-4);
        MutableDoubleTest.assertEquals((double)2.0, (double)new MutableDouble("2.0").doubleValue(), (double)1.0E-4);
        try {
            new MutableDouble((Number)null);
            MutableDoubleTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testGetSet() {
        MutableDouble mutNum = new MutableDouble(0.0);
        MutableDoubleTest.assertEquals((double)0.0, (double)new MutableDouble().doubleValue(), (double)1.0E-4);
        MutableDoubleTest.assertEquals((Object)new Double(0.0), (Object)new MutableDouble().getValue());
        mutNum.setValue(1.0);
        MutableDoubleTest.assertEquals((double)1.0, (double)mutNum.doubleValue(), (double)1.0E-4);
        MutableDoubleTest.assertEquals((Object)new Double(1.0), (Object)mutNum.getValue());
        mutNum.setValue((Number)new Double(2.0));
        MutableDoubleTest.assertEquals((double)2.0, (double)mutNum.doubleValue(), (double)1.0E-4);
        MutableDoubleTest.assertEquals((Object)new Double(2.0), (Object)mutNum.getValue());
        mutNum.setValue((Number)new MutableDouble(3.0));
        MutableDoubleTest.assertEquals((double)3.0, (double)mutNum.doubleValue(), (double)1.0E-4);
        MutableDoubleTest.assertEquals((Object)new Double(3.0), (Object)mutNum.getValue());
        try {
            mutNum.setValue(null);
            MutableDoubleTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testNanInfinite() {
        MutableDouble mutNum = new MutableDouble(Double.NaN);
        MutableDoubleTest.assertEquals((boolean)true, (boolean)mutNum.isNaN());
        mutNum = new MutableDouble(Double.POSITIVE_INFINITY);
        MutableDoubleTest.assertEquals((boolean)true, (boolean)mutNum.isInfinite());
        mutNum = new MutableDouble(Double.NEGATIVE_INFINITY);
        MutableDoubleTest.assertEquals((boolean)true, (boolean)mutNum.isInfinite());
    }

    public void testEquals() {
        MutableDouble mutNumA = new MutableDouble(0.0);
        MutableDouble mutNumB = new MutableDouble(0.0);
        MutableDouble mutNumC = new MutableDouble(1.0);
        MutableDoubleTest.assertEquals((boolean)true, (boolean)mutNumA.equals((Object)mutNumA));
        MutableDoubleTest.assertEquals((boolean)true, (boolean)mutNumA.equals((Object)mutNumB));
        MutableDoubleTest.assertEquals((boolean)true, (boolean)mutNumB.equals((Object)mutNumA));
        MutableDoubleTest.assertEquals((boolean)true, (boolean)mutNumB.equals((Object)mutNumB));
        MutableDoubleTest.assertEquals((boolean)false, (boolean)mutNumA.equals((Object)mutNumC));
        MutableDoubleTest.assertEquals((boolean)false, (boolean)mutNumB.equals((Object)mutNumC));
        MutableDoubleTest.assertEquals((boolean)true, (boolean)mutNumC.equals((Object)mutNumC));
        MutableDoubleTest.assertEquals((boolean)false, (boolean)mutNumA.equals(null));
        MutableDoubleTest.assertEquals((boolean)false, (boolean)mutNumA.equals((Object)new Double(0.0)));
        MutableDoubleTest.assertEquals((boolean)false, (boolean)mutNumA.equals((Object)"0"));
    }

    public void testHashCode() {
        MutableDouble mutNumA = new MutableDouble(0.0);
        MutableDouble mutNumB = new MutableDouble(0.0);
        MutableDouble mutNumC = new MutableDouble(1.0);
        MutableDoubleTest.assertEquals((boolean)true, (mutNumA.hashCode() == mutNumA.hashCode() ? 1 : 0) != 0);
        MutableDoubleTest.assertEquals((boolean)true, (mutNumA.hashCode() == mutNumB.hashCode() ? 1 : 0) != 0);
        MutableDoubleTest.assertEquals((boolean)false, (mutNumA.hashCode() == mutNumC.hashCode() ? 1 : 0) != 0);
        MutableDoubleTest.assertEquals((boolean)true, (mutNumA.hashCode() == new Double(0.0).hashCode() ? 1 : 0) != 0);
    }

    public void testCompareTo() {
        MutableDouble mutNum = new MutableDouble(0.0);
        MutableDoubleTest.assertEquals((int)0, (int)mutNum.compareTo(new MutableDouble(0.0)));
        MutableDoubleTest.assertEquals((int)1, (int)mutNum.compareTo(new MutableDouble(-1.0)));
        MutableDoubleTest.assertEquals((int)-1, (int)mutNum.compareTo(new MutableDouble(1.0)));
        try {
            mutNum.compareTo(null);
            MutableDoubleTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testPrimitiveValues() {
        MutableDouble mutNum = new MutableDouble(1.7);
        MutableDoubleTest.assertEquals((float)1.7f, (float)mutNum.floatValue(), (float)0.0f);
        MutableDoubleTest.assertEquals((double)1.7, (double)mutNum.doubleValue(), (double)0.0);
        MutableDoubleTest.assertEquals((byte)1, (byte)mutNum.byteValue());
        MutableDoubleTest.assertEquals((short)1, (short)mutNum.shortValue());
        MutableDoubleTest.assertEquals((int)1, (int)mutNum.intValue());
        MutableDoubleTest.assertEquals((long)1L, (long)mutNum.longValue());
    }

    public void testToDouble() {
        MutableDoubleTest.assertEquals((Object)new Double(0.0), (Object)new MutableDouble(0.0).toDouble());
        MutableDoubleTest.assertEquals((Object)new Double(12.3), (Object)new MutableDouble(12.3).toDouble());
    }

    public void testIncrement() {
        MutableDouble mutNum = new MutableDouble(1.0);
        mutNum.increment();
        MutableDoubleTest.assertEquals((int)2, (int)mutNum.intValue());
        MutableDoubleTest.assertEquals((long)2L, (long)mutNum.longValue());
    }

    public void testDecrement() {
        MutableDouble mutNum = new MutableDouble(1.0);
        mutNum.decrement();
        MutableDoubleTest.assertEquals((int)0, (int)mutNum.intValue());
        MutableDoubleTest.assertEquals((long)0L, (long)mutNum.longValue());
    }

    public void testAddValuePrimitive() {
        MutableDouble mutNum = new MutableDouble(1.0);
        mutNum.add(1.1);
        MutableDoubleTest.assertEquals((double)2.1, (double)mutNum.doubleValue(), (double)0.01);
    }

    public void testAddValueObject() {
        MutableDouble mutNum = new MutableDouble(1.0);
        mutNum.add((Number)new Double(1.1));
        MutableDoubleTest.assertEquals((double)2.1, (double)mutNum.doubleValue(), (double)0.01);
    }

    public void testSubtractValuePrimitive() {
        MutableDouble mutNum = new MutableDouble(1.0);
        mutNum.subtract(0.9);
        MutableDoubleTest.assertEquals((double)0.1, (double)mutNum.doubleValue(), (double)0.01);
    }

    public void testSubtractValueObject() {
        MutableDouble mutNum = new MutableDouble(1.0);
        mutNum.subtract((Number)new Double(0.9));
        MutableDoubleTest.assertEquals((double)0.1, (double)mutNum.doubleValue(), (double)0.01);
    }

    public void testToString() {
        MutableDoubleTest.assertEquals((String)"0.0", (String)new MutableDouble(0.0).toString());
        MutableDoubleTest.assertEquals((String)"10.0", (String)new MutableDouble(10.0).toString());
        MutableDoubleTest.assertEquals((String)"-123.0", (String)new MutableDouble(-123.0).toString());
    }
}

