/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.mutable;

import junit.framework.TestCase;
import org.apache.commons.lang3.mutable.MutableFloat;

public class MutableFloatTest
extends TestCase {
    public MutableFloatTest(String testName) {
        super(testName);
    }

    public void testConstructors() {
        MutableFloatTest.assertEquals((float)0.0f, (float)new MutableFloat().floatValue(), (float)1.0E-4f);
        MutableFloatTest.assertEquals((float)1.0f, (float)new MutableFloat(1.0f).floatValue(), (float)1.0E-4f);
        MutableFloatTest.assertEquals((float)2.0f, (float)new MutableFloat((Number)new Float(2.0f)).floatValue(), (float)1.0E-4f);
        MutableFloatTest.assertEquals((float)3.0f, (float)new MutableFloat((Number)new MutableFloat(3.0f)).floatValue(), (float)1.0E-4f);
        MutableFloatTest.assertEquals((float)2.0f, (float)new MutableFloat("2.0").floatValue(), (float)1.0E-4f);
        try {
            new MutableFloat((Number)null);
            MutableFloatTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testGetSet() {
        MutableFloat mutNum = new MutableFloat(0.0f);
        MutableFloatTest.assertEquals((float)0.0f, (float)new MutableFloat().floatValue(), (float)1.0E-4f);
        MutableFloatTest.assertEquals((Object)new Float(0.0f), (Object)new MutableFloat().getValue());
        mutNum.setValue(1.0f);
        MutableFloatTest.assertEquals((float)1.0f, (float)mutNum.floatValue(), (float)1.0E-4f);
        MutableFloatTest.assertEquals((Object)new Float(1.0f), (Object)mutNum.getValue());
        mutNum.setValue((Number)new Float(2.0f));
        MutableFloatTest.assertEquals((float)2.0f, (float)mutNum.floatValue(), (float)1.0E-4f);
        MutableFloatTest.assertEquals((Object)new Float(2.0f), (Object)mutNum.getValue());
        mutNum.setValue((Number)new MutableFloat(3.0f));
        MutableFloatTest.assertEquals((float)3.0f, (float)mutNum.floatValue(), (float)1.0E-4f);
        MutableFloatTest.assertEquals((Object)new Float(3.0f), (Object)mutNum.getValue());
        try {
            mutNum.setValue(null);
            MutableFloatTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testNanInfinite() {
        MutableFloat mutNum = new MutableFloat(Float.NaN);
        MutableFloatTest.assertEquals((boolean)true, (boolean)mutNum.isNaN());
        mutNum = new MutableFloat(Float.POSITIVE_INFINITY);
        MutableFloatTest.assertEquals((boolean)true, (boolean)mutNum.isInfinite());
        mutNum = new MutableFloat(Float.NEGATIVE_INFINITY);
        MutableFloatTest.assertEquals((boolean)true, (boolean)mutNum.isInfinite());
    }

    public void testEquals() {
        MutableFloat mutNumA = new MutableFloat(0.0f);
        MutableFloat mutNumB = new MutableFloat(0.0f);
        MutableFloat mutNumC = new MutableFloat(1.0f);
        MutableFloatTest.assertEquals((boolean)true, (boolean)mutNumA.equals((Object)mutNumA));
        MutableFloatTest.assertEquals((boolean)true, (boolean)mutNumA.equals((Object)mutNumB));
        MutableFloatTest.assertEquals((boolean)true, (boolean)mutNumB.equals((Object)mutNumA));
        MutableFloatTest.assertEquals((boolean)true, (boolean)mutNumB.equals((Object)mutNumB));
        MutableFloatTest.assertEquals((boolean)false, (boolean)mutNumA.equals((Object)mutNumC));
        MutableFloatTest.assertEquals((boolean)false, (boolean)mutNumB.equals((Object)mutNumC));
        MutableFloatTest.assertEquals((boolean)true, (boolean)mutNumC.equals((Object)mutNumC));
        MutableFloatTest.assertEquals((boolean)false, (boolean)mutNumA.equals(null));
        MutableFloatTest.assertEquals((boolean)false, (boolean)mutNumA.equals((Object)new Float(0.0f)));
        MutableFloatTest.assertEquals((boolean)false, (boolean)mutNumA.equals((Object)"0"));
    }

    public void testHashCode() {
        MutableFloat mutNumA = new MutableFloat(0.0f);
        MutableFloat mutNumB = new MutableFloat(0.0f);
        MutableFloat mutNumC = new MutableFloat(1.0f);
        MutableFloatTest.assertEquals((boolean)true, (mutNumA.hashCode() == mutNumA.hashCode() ? 1 : 0) != 0);
        MutableFloatTest.assertEquals((boolean)true, (mutNumA.hashCode() == mutNumB.hashCode() ? 1 : 0) != 0);
        MutableFloatTest.assertEquals((boolean)false, (mutNumA.hashCode() == mutNumC.hashCode() ? 1 : 0) != 0);
        MutableFloatTest.assertEquals((boolean)true, (mutNumA.hashCode() == new Float(0.0f).hashCode() ? 1 : 0) != 0);
    }

    public void testCompareTo() {
        MutableFloat mutNum = new MutableFloat(0.0f);
        MutableFloatTest.assertEquals((int)0, (int)mutNum.compareTo(new MutableFloat(0.0f)));
        MutableFloatTest.assertEquals((int)1, (int)mutNum.compareTo(new MutableFloat(-1.0f)));
        MutableFloatTest.assertEquals((int)-1, (int)mutNum.compareTo(new MutableFloat(1.0f)));
        try {
            mutNum.compareTo(null);
            MutableFloatTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testPrimitiveValues() {
        MutableFloat mutNum = new MutableFloat(1.7f);
        MutableFloatTest.assertEquals((int)1, (int)mutNum.intValue());
        MutableFloatTest.assertEquals((double)1.7, (double)mutNum.doubleValue(), (double)1.0E-5);
        MutableFloatTest.assertEquals((byte)1, (byte)mutNum.byteValue());
        MutableFloatTest.assertEquals((short)1, (short)mutNum.shortValue());
        MutableFloatTest.assertEquals((int)1, (int)mutNum.intValue());
        MutableFloatTest.assertEquals((long)1L, (long)mutNum.longValue());
    }

    public void testToFloat() {
        MutableFloatTest.assertEquals((Object)new Float(0.0f), (Object)new MutableFloat(0.0f).toFloat());
        MutableFloatTest.assertEquals((Object)new Float(12.3f), (Object)new MutableFloat(12.3f).toFloat());
    }

    public void testIncrement() {
        MutableFloat mutNum = new MutableFloat(1.0f);
        mutNum.increment();
        MutableFloatTest.assertEquals((int)2, (int)mutNum.intValue());
        MutableFloatTest.assertEquals((long)2L, (long)mutNum.longValue());
    }

    public void testDecrement() {
        MutableFloat mutNum = new MutableFloat(1.0f);
        mutNum.decrement();
        MutableFloatTest.assertEquals((int)0, (int)mutNum.intValue());
        MutableFloatTest.assertEquals((long)0L, (long)mutNum.longValue());
    }

    public void testAddValuePrimitive() {
        MutableFloat mutNum = new MutableFloat(1.0f);
        mutNum.add(1.1f);
        MutableFloatTest.assertEquals((float)2.1f, (float)mutNum.floatValue(), (float)0.01f);
    }

    public void testAddValueObject() {
        MutableFloat mutNum = new MutableFloat(1.0f);
        mutNum.add((Number)new Float(1.1f));
        MutableFloatTest.assertEquals((float)2.1f, (float)mutNum.floatValue(), (float)0.01f);
    }

    public void testSubtractValuePrimitive() {
        MutableFloat mutNum = new MutableFloat(1.0f);
        mutNum.subtract(0.9f);
        MutableFloatTest.assertEquals((float)0.1f, (float)mutNum.floatValue(), (float)0.01f);
    }

    public void testSubtractValueObject() {
        MutableFloat mutNum = new MutableFloat(1.0f);
        mutNum.subtract((Number)new Float(0.9f));
        MutableFloatTest.assertEquals((float)0.1f, (float)mutNum.floatValue(), (float)0.01f);
    }

    public void testToString() {
        MutableFloatTest.assertEquals((String)"0.0", (String)new MutableFloat(0.0f).toString());
        MutableFloatTest.assertEquals((String)"10.0", (String)new MutableFloat(10.0f).toString());
        MutableFloatTest.assertEquals((String)"-123.0", (String)new MutableFloat(-123.0f).toString());
    }
}

