/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.mutable;

import junit.framework.TestCase;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableLong;

public class MutableIntTest
extends TestCase {
    public MutableIntTest(String testName) {
        super(testName);
    }

    public void testConstructors() {
        MutableIntTest.assertEquals((int)0, (int)new MutableInt().intValue());
        MutableIntTest.assertEquals((int)1, (int)new MutableInt(1).intValue());
        MutableIntTest.assertEquals((int)2, (int)new MutableInt((Number)new Integer(2)).intValue());
        MutableIntTest.assertEquals((int)3, (int)new MutableInt((Number)new MutableLong(3L)).intValue());
        MutableIntTest.assertEquals((int)2, (int)new MutableInt("2").intValue());
        try {
            new MutableInt((Number)null);
            MutableIntTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testGetSet() {
        MutableInt mutNum = new MutableInt(0);
        MutableIntTest.assertEquals((int)0, (int)new MutableInt().intValue());
        MutableIntTest.assertEquals((Object)new Integer(0), (Object)new MutableInt().getValue());
        mutNum.setValue(1);
        MutableIntTest.assertEquals((int)1, (int)mutNum.intValue());
        MutableIntTest.assertEquals((Object)new Integer(1), (Object)mutNum.getValue());
        mutNum.setValue((Number)new Integer(2));
        MutableIntTest.assertEquals((int)2, (int)mutNum.intValue());
        MutableIntTest.assertEquals((Object)new Integer(2), (Object)mutNum.getValue());
        mutNum.setValue((Number)new MutableLong(3L));
        MutableIntTest.assertEquals((int)3, (int)mutNum.intValue());
        MutableIntTest.assertEquals((Object)new Integer(3), (Object)mutNum.getValue());
        try {
            mutNum.setValue(null);
            MutableIntTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testEquals() {
        this.testEquals((Number)new MutableInt(0), (Number)new MutableInt(0), (Number)new MutableInt(1));
    }

    void testEquals(Number numA, Number numB, Number numC) {
        MutableIntTest.assertEquals((boolean)true, (boolean)numA.equals(numA));
        MutableIntTest.assertEquals((boolean)true, (boolean)numA.equals(numB));
        MutableIntTest.assertEquals((boolean)true, (boolean)numB.equals(numA));
        MutableIntTest.assertEquals((boolean)true, (boolean)numB.equals(numB));
        MutableIntTest.assertEquals((boolean)false, (boolean)numA.equals(numC));
        MutableIntTest.assertEquals((boolean)false, (boolean)numB.equals(numC));
        MutableIntTest.assertEquals((boolean)true, (boolean)numC.equals(numC));
        MutableIntTest.assertEquals((boolean)false, (boolean)numA.equals(null));
        MutableIntTest.assertEquals((boolean)false, (boolean)numA.equals(new Integer(0)));
        MutableIntTest.assertEquals((boolean)false, (boolean)numA.equals("0"));
    }

    public void testHashCode() {
        MutableInt mutNumA = new MutableInt(0);
        MutableInt mutNumB = new MutableInt(0);
        MutableInt mutNumC = new MutableInt(1);
        MutableIntTest.assertEquals((boolean)true, (mutNumA.hashCode() == mutNumA.hashCode() ? 1 : 0) != 0);
        MutableIntTest.assertEquals((boolean)true, (mutNumA.hashCode() == mutNumB.hashCode() ? 1 : 0) != 0);
        MutableIntTest.assertEquals((boolean)false, (mutNumA.hashCode() == mutNumC.hashCode() ? 1 : 0) != 0);
        MutableIntTest.assertEquals((boolean)true, (mutNumA.hashCode() == new Integer(0).hashCode() ? 1 : 0) != 0);
    }

    public void testCompareTo() {
        MutableInt mutNum = new MutableInt(0);
        MutableIntTest.assertEquals((int)0, (int)mutNum.compareTo(new MutableInt(0)));
        MutableIntTest.assertEquals((int)1, (int)mutNum.compareTo(new MutableInt(-1)));
        MutableIntTest.assertEquals((int)-1, (int)mutNum.compareTo(new MutableInt(1)));
        try {
            mutNum.compareTo(null);
            MutableIntTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testPrimitiveValues() {
        MutableInt mutNum = new MutableInt(1);
        MutableIntTest.assertEquals((byte)1, (byte)mutNum.byteValue());
        MutableIntTest.assertEquals((short)1, (short)mutNum.shortValue());
        MutableIntTest.assertEquals((float)1.0f, (float)mutNum.floatValue(), (float)0.0f);
        MutableIntTest.assertEquals((double)1.0, (double)mutNum.doubleValue(), (double)0.0);
        MutableIntTest.assertEquals((long)1L, (long)mutNum.longValue());
    }

    public void testToInteger() {
        MutableIntTest.assertEquals((Object)new Integer(0), (Object)new MutableInt(0).toInteger());
        MutableIntTest.assertEquals((Object)new Integer(123), (Object)new MutableInt(123).toInteger());
    }

    public void testIncrement() {
        MutableInt mutNum = new MutableInt(1);
        mutNum.increment();
        MutableIntTest.assertEquals((int)2, (int)mutNum.intValue());
        MutableIntTest.assertEquals((long)2L, (long)mutNum.longValue());
    }

    public void testDecrement() {
        MutableInt mutNum = new MutableInt(1);
        mutNum.decrement();
        MutableIntTest.assertEquals((int)0, (int)mutNum.intValue());
        MutableIntTest.assertEquals((long)0L, (long)mutNum.longValue());
    }

    public void testAddValuePrimitive() {
        MutableInt mutNum = new MutableInt(1);
        mutNum.add(1);
        MutableIntTest.assertEquals((int)2, (int)mutNum.intValue());
        MutableIntTest.assertEquals((long)2L, (long)mutNum.longValue());
    }

    public void testAddValueObject() {
        MutableInt mutNum = new MutableInt(1);
        mutNum.add((Number)new Integer(1));
        MutableIntTest.assertEquals((int)2, (int)mutNum.intValue());
        MutableIntTest.assertEquals((long)2L, (long)mutNum.longValue());
    }

    public void testSubtractValuePrimitive() {
        MutableInt mutNum = new MutableInt(1);
        mutNum.subtract(1);
        MutableIntTest.assertEquals((int)0, (int)mutNum.intValue());
        MutableIntTest.assertEquals((long)0L, (long)mutNum.longValue());
    }

    public void testSubtractValueObject() {
        MutableInt mutNum = new MutableInt(1);
        mutNum.subtract((Number)new Integer(1));
        MutableIntTest.assertEquals((int)0, (int)mutNum.intValue());
        MutableIntTest.assertEquals((long)0L, (long)mutNum.longValue());
    }

    public void testToString() {
        MutableIntTest.assertEquals((String)"0", (String)new MutableInt(0).toString());
        MutableIntTest.assertEquals((String)"10", (String)new MutableInt(10).toString());
        MutableIntTest.assertEquals((String)"-123", (String)new MutableInt(-123).toString());
    }
}

