/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.mutable;

import junit.framework.TestCase;
import org.apache.commons.lang3.mutable.MutableObject;

public class MutableObjectTest
extends TestCase {
    public MutableObjectTest(String testName) {
        super(testName);
    }

    public void testConstructors() {
        MutableObjectTest.assertEquals(null, (String)((String)new MutableObject().getValue()));
        Integer i = new Integer(6);
        MutableObjectTest.assertSame((Object)i, (Object)new MutableObject((Object)i).getValue());
        MutableObjectTest.assertSame((Object)"HI", (Object)new MutableObject((Object)"HI").getValue());
        MutableObjectTest.assertSame(null, (Object)new MutableObject(null).getValue());
    }

    public void testGetSet() {
        MutableObject mutNum = new MutableObject();
        MutableObjectTest.assertEquals(null, (Object)new MutableObject().getValue());
        mutNum.setValue((Object)"HELLO");
        MutableObjectTest.assertSame((Object)"HELLO", (Object)mutNum.getValue());
        mutNum.setValue(null);
        MutableObjectTest.assertSame(null, (Object)mutNum.getValue());
    }

    public void testEquals() {
        MutableObject mutNumA = new MutableObject((Object)"ALPHA");
        MutableObject mutNumB = new MutableObject((Object)"ALPHA");
        MutableObject mutNumC = new MutableObject((Object)"BETA");
        MutableObject mutNumD = new MutableObject(null);
        MutableObjectTest.assertEquals((boolean)true, (boolean)mutNumA.equals((Object)mutNumA));
        MutableObjectTest.assertEquals((boolean)true, (boolean)mutNumA.equals((Object)mutNumB));
        MutableObjectTest.assertEquals((boolean)true, (boolean)mutNumB.equals((Object)mutNumA));
        MutableObjectTest.assertEquals((boolean)true, (boolean)mutNumB.equals((Object)mutNumB));
        MutableObjectTest.assertEquals((boolean)false, (boolean)mutNumA.equals((Object)mutNumC));
        MutableObjectTest.assertEquals((boolean)false, (boolean)mutNumB.equals((Object)mutNumC));
        MutableObjectTest.assertEquals((boolean)true, (boolean)mutNumC.equals((Object)mutNumC));
        MutableObjectTest.assertEquals((boolean)false, (boolean)mutNumA.equals((Object)mutNumD));
        MutableObjectTest.assertEquals((boolean)true, (boolean)mutNumD.equals((Object)mutNumD));
        MutableObjectTest.assertEquals((boolean)false, (boolean)mutNumA.equals(null));
        MutableObjectTest.assertEquals((boolean)false, (boolean)mutNumA.equals(new Object()));
        MutableObjectTest.assertEquals((boolean)false, (boolean)mutNumA.equals((Object)"0"));
    }

    public void testHashCode() {
        MutableObject mutNumA = new MutableObject((Object)"ALPHA");
        MutableObject mutNumB = new MutableObject((Object)"ALPHA");
        MutableObject mutNumC = new MutableObject((Object)"BETA");
        MutableObject mutNumD = new MutableObject(null);
        MutableObjectTest.assertEquals((boolean)true, (mutNumA.hashCode() == mutNumA.hashCode() ? 1 : 0) != 0);
        MutableObjectTest.assertEquals((boolean)true, (mutNumA.hashCode() == mutNumB.hashCode() ? 1 : 0) != 0);
        MutableObjectTest.assertEquals((boolean)false, (mutNumA.hashCode() == mutNumC.hashCode() ? 1 : 0) != 0);
        MutableObjectTest.assertEquals((boolean)false, (mutNumA.hashCode() == mutNumD.hashCode() ? 1 : 0) != 0);
        MutableObjectTest.assertEquals((boolean)true, (mutNumA.hashCode() == "ALPHA".hashCode() ? 1 : 0) != 0);
        MutableObjectTest.assertEquals((int)0, (int)mutNumD.hashCode());
    }

    public void testToString() {
        MutableObjectTest.assertEquals((String)"HI", (String)new MutableObject((Object)"HI").toString());
        MutableObjectTest.assertEquals((String)"10.0", (String)new MutableObject((Object)new Double(10.0)).toString());
        MutableObjectTest.assertEquals((String)"null", (String)new MutableObject(null).toString());
    }
}

