/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.mutable;

import junit.framework.TestCase;
import org.apache.commons.lang3.mutable.MutableShort;

public class MutableShortTest
extends TestCase {
    public MutableShortTest(String testName) {
        super(testName);
    }

    public void testConstructors() {
        MutableShortTest.assertEquals((short)0, (short)new MutableShort().shortValue());
        MutableShortTest.assertEquals((short)1, (short)new MutableShort(1).shortValue());
        MutableShortTest.assertEquals((short)2, (short)new MutableShort((Number)new Short(2)).shortValue());
        MutableShortTest.assertEquals((short)3, (short)new MutableShort((Number)new MutableShort(3)).shortValue());
        MutableShortTest.assertEquals((short)2, (short)new MutableShort("2").shortValue());
        try {
            new MutableShort((Number)null);
            MutableShortTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testGetSet() {
        MutableShort mutNum = new MutableShort(0);
        MutableShortTest.assertEquals((short)0, (short)new MutableShort().shortValue());
        MutableShortTest.assertEquals((Object)new Short(0), (Object)new MutableShort().getValue());
        mutNum.setValue((short)1);
        MutableShortTest.assertEquals((short)1, (short)mutNum.shortValue());
        MutableShortTest.assertEquals((Object)new Short(1), (Object)mutNum.getValue());
        mutNum.setValue((Number)new Short(2));
        MutableShortTest.assertEquals((short)2, (short)mutNum.shortValue());
        MutableShortTest.assertEquals((Object)new Short(2), (Object)mutNum.getValue());
        mutNum.setValue((Number)new MutableShort(3));
        MutableShortTest.assertEquals((short)3, (short)mutNum.shortValue());
        MutableShortTest.assertEquals((Object)new Short(3), (Object)mutNum.getValue());
        try {
            mutNum.setValue(null);
            MutableShortTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testEquals() {
        MutableShort mutNumA = new MutableShort(0);
        MutableShort mutNumB = new MutableShort(0);
        MutableShort mutNumC = new MutableShort(1);
        MutableShortTest.assertEquals((boolean)true, (boolean)mutNumA.equals((Object)mutNumA));
        MutableShortTest.assertEquals((boolean)true, (boolean)mutNumA.equals((Object)mutNumB));
        MutableShortTest.assertEquals((boolean)true, (boolean)mutNumB.equals((Object)mutNumA));
        MutableShortTest.assertEquals((boolean)true, (boolean)mutNumB.equals((Object)mutNumB));
        MutableShortTest.assertEquals((boolean)false, (boolean)mutNumA.equals((Object)mutNumC));
        MutableShortTest.assertEquals((boolean)false, (boolean)mutNumB.equals((Object)mutNumC));
        MutableShortTest.assertEquals((boolean)true, (boolean)mutNumC.equals((Object)mutNumC));
        MutableShortTest.assertEquals((boolean)false, (boolean)mutNumA.equals(null));
        MutableShortTest.assertEquals((boolean)false, (boolean)mutNumA.equals((Object)new Short(0)));
        MutableShortTest.assertEquals((boolean)false, (boolean)mutNumA.equals((Object)"0"));
    }

    public void testHashCode() {
        MutableShort mutNumA = new MutableShort(0);
        MutableShort mutNumB = new MutableShort(0);
        MutableShort mutNumC = new MutableShort(1);
        MutableShortTest.assertEquals((boolean)true, (mutNumA.hashCode() == mutNumA.hashCode() ? 1 : 0) != 0);
        MutableShortTest.assertEquals((boolean)true, (mutNumA.hashCode() == mutNumB.hashCode() ? 1 : 0) != 0);
        MutableShortTest.assertEquals((boolean)false, (mutNumA.hashCode() == mutNumC.hashCode() ? 1 : 0) != 0);
        MutableShortTest.assertEquals((boolean)true, (mutNumA.hashCode() == new Short(0).hashCode() ? 1 : 0) != 0);
    }

    public void testCompareTo() {
        MutableShort mutNum = new MutableShort(0);
        MutableShortTest.assertEquals((int)0, (int)mutNum.compareTo(new MutableShort(0)));
        MutableShortTest.assertEquals((int)1, (int)mutNum.compareTo(new MutableShort(-1)));
        MutableShortTest.assertEquals((int)-1, (int)mutNum.compareTo(new MutableShort(1)));
        try {
            mutNum.compareTo(null);
            MutableShortTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testPrimitiveValues() {
        MutableShort mutNum = new MutableShort(1);
        MutableShortTest.assertEquals((float)1.0f, (float)mutNum.floatValue(), (float)0.0f);
        MutableShortTest.assertEquals((double)1.0, (double)mutNum.doubleValue(), (double)0.0);
        MutableShortTest.assertEquals((byte)1, (byte)mutNum.byteValue());
        MutableShortTest.assertEquals((short)1, (short)mutNum.shortValue());
        MutableShortTest.assertEquals((int)1, (int)mutNum.intValue());
        MutableShortTest.assertEquals((long)1L, (long)mutNum.longValue());
    }

    public void testToShort() {
        MutableShortTest.assertEquals((Object)new Short(0), (Object)new MutableShort(0).toShort());
        MutableShortTest.assertEquals((Object)new Short(123), (Object)new MutableShort(123).toShort());
    }

    public void testIncrement() {
        MutableShort mutNum = new MutableShort(1);
        mutNum.increment();
        MutableShortTest.assertEquals((int)2, (int)mutNum.intValue());
        MutableShortTest.assertEquals((long)2L, (long)mutNum.longValue());
    }

    public void testDecrement() {
        MutableShort mutNum = new MutableShort(1);
        mutNum.decrement();
        MutableShortTest.assertEquals((int)0, (int)mutNum.intValue());
        MutableShortTest.assertEquals((long)0L, (long)mutNum.longValue());
    }

    public void testAddValuePrimitive() {
        MutableShort mutNum = new MutableShort(1);
        mutNum.add((short)1);
        MutableShortTest.assertEquals((short)2, (short)mutNum.shortValue());
    }

    public void testAddValueObject() {
        MutableShort mutNum = new MutableShort(1);
        mutNum.add((Number)new Short(1));
        MutableShortTest.assertEquals((short)2, (short)mutNum.shortValue());
    }

    public void testSubtractValuePrimitive() {
        MutableShort mutNum = new MutableShort(1);
        mutNum.subtract((short)1);
        MutableShortTest.assertEquals((short)0, (short)mutNum.shortValue());
    }

    public void testSubtractValueObject() {
        MutableShort mutNum = new MutableShort(1);
        mutNum.subtract((Number)new Short(1));
        MutableShortTest.assertEquals((short)0, (short)mutNum.shortValue());
    }

    public void testToString() {
        MutableShortTest.assertEquals((String)"0", (String)new MutableShort(0).toString());
        MutableShortTest.assertEquals((String)"10", (String)new MutableShort(10).toString());
        MutableShortTest.assertEquals((String)"-123", (String)new MutableShort(-123).toString());
    }
}

