/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.text;

import java.text.ChoiceFormat;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.text.ExtendedMessageFormat;
import org.apache.commons.lang3.text.FormatFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedMessageFormatTest
extends TestCase {
    private final Map<String, FormatFactory> registry = new HashMap<String, FormatFactory>();

    public ExtendedMessageFormatTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.registry.put("lower", new LowerCaseFormatFactory());
        this.registry.put("upper", new UpperCaseFormatFactory());
    }

    public void testExtendedFormats() {
        String pattern = "Lower: {0,lower} Upper: {1,upper}";
        ExtendedMessageFormat emf = new ExtendedMessageFormat(pattern, this.registry);
        this.assertPatternsEqual("TOPATTERN", pattern, emf.toPattern());
        ExtendedMessageFormatTest.assertEquals((String)"Lower: foo Upper: BAR", (String)emf.format((Object)new Object[]{"foo", "bar"}));
        ExtendedMessageFormatTest.assertEquals((String)"Lower: foo Upper: BAR", (String)emf.format((Object)new Object[]{"Foo", "Bar"}));
        ExtendedMessageFormatTest.assertEquals((String)"Lower: foo Upper: BAR", (String)emf.format((Object)new Object[]{"FOO", "BAR"}));
        ExtendedMessageFormatTest.assertEquals((String)"Lower: foo Upper: BAR", (String)emf.format((Object)new Object[]{"FOO", "bar"}));
        ExtendedMessageFormatTest.assertEquals((String)"Lower: foo Upper: BAR", (String)emf.format((Object)new Object[]{"foo", "BAR"}));
    }

    public void testEscapedQuote_LANG_477() {
        String pattern = "it''s a {0,lower} 'test'!";
        ExtendedMessageFormat emf = new ExtendedMessageFormat(pattern, this.registry);
        ExtendedMessageFormatTest.assertEquals((String)"it's a dummy test!", (String)emf.format((Object)new Object[]{"DUMMY"}));
    }

    public void testExtendedAndBuiltInFormats() {
        Calendar cal = Calendar.getInstance();
        cal.set(2007, 0, 23, 18, 33, 5);
        Object[] args = new Object[]{"John Doe", cal.getTime(), new Double("12345.67")};
        String builtinsPattern = "DOB: {1,date,short} Salary: {2,number,currency}";
        String extendedPattern = "Name: {0,upper} ";
        String pattern = extendedPattern + builtinsPattern;
        HashSet<Locale> testLocales = new HashSet<Locale>();
        testLocales.addAll(Arrays.asList(DateFormat.getAvailableLocales()));
        testLocales.retainAll(Arrays.asList(NumberFormat.getAvailableLocales()));
        testLocales.add(null);
        for (Locale locale : testLocales) {
            MessageFormat builtins = this.createMessageFormat(builtinsPattern, locale);
            String expectedPattern = extendedPattern + builtins.toPattern();
            DateFormat df = null;
            NumberFormat nf = null;
            ExtendedMessageFormat emf = null;
            if (locale == null) {
                df = DateFormat.getDateInstance(3);
                nf = NumberFormat.getCurrencyInstance();
                emf = new ExtendedMessageFormat(pattern, this.registry);
            } else {
                df = DateFormat.getDateInstance(3, locale);
                nf = NumberFormat.getCurrencyInstance(locale);
                emf = new ExtendedMessageFormat(pattern, locale, this.registry);
            }
            StringBuffer expected = new StringBuffer();
            expected.append("Name: ");
            expected.append(args[0].toString().toUpperCase());
            expected.append(" DOB: ");
            expected.append(df.format(args[1]));
            expected.append(" Salary: ");
            expected.append(nf.format(args[2]));
            this.assertPatternsEqual("pattern comparison for locale " + locale, expectedPattern, emf.toPattern());
            ExtendedMessageFormatTest.assertEquals((String)String.valueOf(locale), (String)expected.toString(), (String)emf.format((Object)args));
        }
    }

    public void testBuiltInChoiceFormat() {
        Number[] values = new Number[]{new Integer(1), new Double("2.2"), new Double("1234.5")};
        String choicePattern = null;
        Locale[] availableLocales = ChoiceFormat.getAvailableLocales();
        choicePattern = "{0,choice,1#One|2#Two|3#Many {0,number}}";
        for (Number value : values) {
            this.checkBuiltInFormat(value + ": " + choicePattern, new Object[]{value}, availableLocales);
        }
        choicePattern = "{0,choice,1#''One''|2#\"Two\"|3#''{Many}'' {0,number}}";
        for (Number value : values) {
            this.checkBuiltInFormat(value + ": " + choicePattern, new Object[]{value}, availableLocales);
        }
    }

    public void testBuiltInDateTimeFormat() {
        Calendar cal = Calendar.getInstance();
        cal.set(2007, 0, 23, 18, 33, 5);
        Object[] args = new Object[]{cal.getTime()};
        Locale[] availableLocales = DateFormat.getAvailableLocales();
        this.checkBuiltInFormat("1: {0,date,short}", args, availableLocales);
        this.checkBuiltInFormat("2: {0,date,medium}", args, availableLocales);
        this.checkBuiltInFormat("3: {0,date,long}", args, availableLocales);
        this.checkBuiltInFormat("4: {0,date,full}", args, availableLocales);
        this.checkBuiltInFormat("5: {0,date,d MMM yy}", args, availableLocales);
        this.checkBuiltInFormat("6: {0,time,short}", args, availableLocales);
        this.checkBuiltInFormat("7: {0,time,medium}", args, availableLocales);
        this.checkBuiltInFormat("8: {0,time,long}", args, availableLocales);
        this.checkBuiltInFormat("9: {0,time,full}", args, availableLocales);
        this.checkBuiltInFormat("10: {0,time,HH:mm}", args, availableLocales);
        this.checkBuiltInFormat("11: {0,date}", args, availableLocales);
        this.checkBuiltInFormat("12: {0,time}", args, availableLocales);
    }

    public void testOverriddenBuiltinFormat() {
        Calendar cal = Calendar.getInstance();
        cal.set(2007, 0, 23);
        Object[] args = new Object[]{cal.getTime()};
        Locale[] availableLocales = DateFormat.getAvailableLocales();
        Map<String, OverrideShortDateFormatFactory> registry = Collections.singletonMap("date", new OverrideShortDateFormatFactory());
        this.checkBuiltInFormat("1: {0,date}", registry, args, availableLocales);
        this.checkBuiltInFormat("2: {0,date,medium}", registry, args, availableLocales);
        this.checkBuiltInFormat("3: {0,date,long}", registry, args, availableLocales);
        this.checkBuiltInFormat("4: {0,date,full}", registry, args, availableLocales);
        this.checkBuiltInFormat("5: {0,date,d MMM yy}", registry, args, availableLocales);
        for (int i = -1; i < availableLocales.length; ++i) {
            Locale locale = i < 0 ? null : availableLocales[i];
            MessageFormat dateDefault = this.createMessageFormat("{0,date}", locale);
            String pattern = "{0,date,short}";
            ExtendedMessageFormat dateShort = new ExtendedMessageFormat(pattern, locale, registry);
            ExtendedMessageFormatTest.assertEquals((String)"overridden date,short format", (String)dateDefault.format(args), (String)dateShort.format((Object)args));
            ExtendedMessageFormatTest.assertEquals((String)"overridden date,short pattern", (String)pattern, (String)dateShort.toPattern());
        }
    }

    public void testBuiltInNumberFormat() {
        Object[] args = new Object[]{new Double("6543.21")};
        Locale[] availableLocales = NumberFormat.getAvailableLocales();
        this.checkBuiltInFormat("1: {0,number}", args, availableLocales);
        this.checkBuiltInFormat("2: {0,number,integer}", args, availableLocales);
        this.checkBuiltInFormat("3: {0,number,currency}", args, availableLocales);
        this.checkBuiltInFormat("4: {0,number,percent}", args, availableLocales);
        this.checkBuiltInFormat("5: {0,number,00000.000}", args, availableLocales);
    }

    public void testEqualsHashcode() {
        Map<String, LowerCaseFormatFactory> registry = Collections.singletonMap("testfmt", new LowerCaseFormatFactory());
        Map<String, UpperCaseFormatFactory> otherRegitry = Collections.singletonMap("testfmt", new UpperCaseFormatFactory());
        String pattern = "Pattern: {0,testfmt}";
        ExtendedMessageFormat emf = new ExtendedMessageFormat(pattern, Locale.US, registry);
        ExtendedMessageFormat other = null;
        ExtendedMessageFormatTest.assertTrue((String)"same, equals()", (boolean)emf.equals((Object)emf));
        ExtendedMessageFormatTest.assertTrue((String)"same, hashcode()", (emf.hashCode() == emf.hashCode() ? 1 : 0) != 0);
        other = new ExtendedMessageFormat(pattern, Locale.US, registry);
        ExtendedMessageFormatTest.assertTrue((String)"equal, equals()", (boolean)emf.equals((Object)other));
        ExtendedMessageFormatTest.assertTrue((String)"equal, hashcode()", (emf.hashCode() == other.hashCode() ? 1 : 0) != 0);
        other = new OtherExtendedMessageFormat(pattern, Locale.US, registry);
        ExtendedMessageFormatTest.assertFalse((String)"class, equals()", (boolean)emf.equals((Object)other));
        ExtendedMessageFormatTest.assertTrue((String)"class, hashcode()", (emf.hashCode() == other.hashCode() ? 1 : 0) != 0);
        other = new ExtendedMessageFormat("X" + pattern, Locale.US, registry);
        ExtendedMessageFormatTest.assertFalse((String)"pattern, equals()", (boolean)emf.equals((Object)other));
        ExtendedMessageFormatTest.assertFalse((String)"pattern, hashcode()", (emf.hashCode() == other.hashCode() ? 1 : 0) != 0);
        other = new ExtendedMessageFormat(pattern, Locale.US, otherRegitry);
        ExtendedMessageFormatTest.assertFalse((String)"registry, equals()", (boolean)emf.equals((Object)other));
        ExtendedMessageFormatTest.assertFalse((String)"registry, hashcode()", (emf.hashCode() == other.hashCode() ? 1 : 0) != 0);
        other = new ExtendedMessageFormat(pattern, Locale.FRANCE, registry);
        ExtendedMessageFormatTest.assertFalse((String)"locale, equals()", (boolean)emf.equals((Object)other));
        ExtendedMessageFormatTest.assertTrue((String)"locale, hashcode()", (emf.hashCode() == other.hashCode() ? 1 : 0) != 0);
    }

    private void checkBuiltInFormat(String pattern, Object[] args, Locale[] locales) {
        this.checkBuiltInFormat(pattern, null, args, locales);
    }

    private void checkBuiltInFormat(String pattern, Map<String, ?> registry, Object[] args, Locale[] locales) {
        this.checkBuiltInFormat(pattern, registry, args, (Locale)null);
        for (Locale locale : locales) {
            this.checkBuiltInFormat(pattern, registry, args, locale);
        }
    }

    private void checkBuiltInFormat(String pattern, Map<String, ?> registry, Object[] args, Locale locale) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Pattern=[");
        buffer.append(pattern);
        buffer.append("], locale=[");
        buffer.append(locale);
        buffer.append("]");
        MessageFormat mf = this.createMessageFormat(pattern, locale);
        ExtendedMessageFormat emf = null;
        emf = locale == null ? new ExtendedMessageFormat(pattern) : new ExtendedMessageFormat(pattern, locale);
        ExtendedMessageFormatTest.assertEquals((String)("format " + buffer.toString()), (String)mf.format(args), (String)emf.format((Object)args));
        this.assertPatternsEqual("toPattern " + buffer.toString(), mf.toPattern(), emf.toPattern());
    }

    private void assertPatternsEqual(String message, String expected, String actual) {
        if (SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_4)) {
            ExtendedMessageFormatTest.assertEquals((String)message, (String)expected, (String)actual);
        }
    }

    private MessageFormat createMessageFormat(String pattern, Locale locale) {
        MessageFormat result = new MessageFormat(pattern);
        if (locale != null) {
            result.setLocale(locale);
            result.applyPattern(pattern);
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OtherExtendedMessageFormat
    extends ExtendedMessageFormat {
        public OtherExtendedMessageFormat(String pattern, Locale locale, Map<String, ? extends FormatFactory> registry) {
            super(pattern, locale, registry);
        }
    }

    private static class OverrideShortDateFormatFactory
    implements FormatFactory {
        private OverrideShortDateFormatFactory() {
        }

        public Format getFormat(String name, String arguments, Locale locale) {
            return !"short".equals(arguments) ? null : (locale == null ? DateFormat.getDateInstance(2) : DateFormat.getDateInstance(2, locale));
        }
    }

    private static class UpperCaseFormatFactory
    implements FormatFactory {
        private static final Format UPPER_INSTANCE = new UpperCaseFormat();

        private UpperCaseFormatFactory() {
        }

        public Format getFormat(String name, String arguments, Locale locale) {
            return UPPER_INSTANCE;
        }
    }

    private static class LowerCaseFormatFactory
    implements FormatFactory {
        private static final Format LOWER_INSTANCE = new LowerCaseFormat();

        private LowerCaseFormatFactory() {
        }

        public Format getFormat(String name, String arguments, Locale locale) {
            return LOWER_INSTANCE;
        }
    }

    private static class UpperCaseFormat
    extends Format {
        private UpperCaseFormat() {
        }

        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            return toAppendTo.append(((String)obj).toUpperCase());
        }

        public Object parseObject(String source, ParsePosition pos) {
            throw new UnsupportedOperationException();
        }
    }

    private static class LowerCaseFormat
    extends Format {
        private LowerCaseFormat() {
        }

        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            return toAppendTo.append(((String)obj).toLowerCase());
        }

        public Object parseObject(String source, ParsePosition pos) {
            throw new UnsupportedOperationException();
        }
    }
}

