/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.util.Calendar;
import java.util.Date;
import junit.framework.TestCase;
import org.apache.commons.lang3.time.DateUtils;

public class DateUtilsFragmentTest
extends TestCase {
    private static final int months = 7;
    private static final int days = 23;
    private static final int hours = 19;
    private static final int minutes = 53;
    private static final int seconds = 47;
    private static final int millis = 991;
    private Date aDate;
    private Calendar aCalendar;

    protected void setUp() {
        this.aCalendar = Calendar.getInstance();
        this.aCalendar.set(2005, 7, 23, 19, 53, 47);
        this.aCalendar.set(14, 991);
        this.aDate = this.aCalendar.getTime();
    }

    public void testNullDate() {
        try {
            DateUtils.getFragmentInMilliseconds((Date)null, (int)14);
            DateUtilsFragmentTest.fail();
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            DateUtils.getFragmentInSeconds((Date)null, (int)14);
            DateUtilsFragmentTest.fail();
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            DateUtils.getFragmentInMinutes((Date)null, (int)14);
            DateUtilsFragmentTest.fail();
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            DateUtils.getFragmentInHours((Date)null, (int)14);
            DateUtilsFragmentTest.fail();
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            DateUtils.getFragmentInDays((Date)null, (int)14);
            DateUtilsFragmentTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testNullCalendar() {
        try {
            DateUtils.getFragmentInMilliseconds((Calendar)null, (int)14);
            DateUtilsFragmentTest.fail();
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            DateUtils.getFragmentInSeconds((Calendar)null, (int)14);
            DateUtilsFragmentTest.fail();
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            DateUtils.getFragmentInMinutes((Calendar)null, (int)14);
            DateUtilsFragmentTest.fail();
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            DateUtils.getFragmentInHours((Calendar)null, (int)14);
            DateUtilsFragmentTest.fail();
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            DateUtils.getFragmentInDays((Calendar)null, (int)14);
            DateUtilsFragmentTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testInvalidFragmentWithDate() {
        try {
            DateUtils.getFragmentInMilliseconds((Date)this.aDate, (int)0);
            DateUtilsFragmentTest.fail();
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            DateUtils.getFragmentInSeconds((Date)this.aDate, (int)0);
            DateUtilsFragmentTest.fail();
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            DateUtils.getFragmentInMinutes((Date)this.aDate, (int)0);
            DateUtilsFragmentTest.fail();
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            DateUtils.getFragmentInHours((Date)this.aDate, (int)0);
            DateUtilsFragmentTest.fail();
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            DateUtils.getFragmentInDays((Date)this.aDate, (int)0);
            DateUtilsFragmentTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testInvalidFragmentWithCalendar() {
        try {
            DateUtils.getFragmentInMilliseconds((Calendar)this.aCalendar, (int)0);
            DateUtilsFragmentTest.fail();
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            DateUtils.getFragmentInSeconds((Calendar)this.aCalendar, (int)0);
            DateUtilsFragmentTest.fail();
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            DateUtils.getFragmentInMinutes((Calendar)this.aCalendar, (int)0);
            DateUtilsFragmentTest.fail();
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            DateUtils.getFragmentInHours((Calendar)this.aCalendar, (int)0);
            DateUtilsFragmentTest.fail();
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            DateUtils.getFragmentInDays((Calendar)this.aCalendar, (int)0);
            DateUtilsFragmentTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testMillisecondFragmentInLargerUnitWithDate() {
        DateUtilsFragmentTest.assertEquals((long)0L, (long)DateUtils.getFragmentInMilliseconds((Date)this.aDate, (int)14));
        DateUtilsFragmentTest.assertEquals((long)0L, (long)DateUtils.getFragmentInSeconds((Date)this.aDate, (int)14));
        DateUtilsFragmentTest.assertEquals((long)0L, (long)DateUtils.getFragmentInMinutes((Date)this.aDate, (int)14));
        DateUtilsFragmentTest.assertEquals((long)0L, (long)DateUtils.getFragmentInHours((Date)this.aDate, (int)14));
        DateUtilsFragmentTest.assertEquals((long)0L, (long)DateUtils.getFragmentInDays((Date)this.aDate, (int)14));
    }

    public void testMillisecondFragmentInLargerUnitWithCalendar() {
        DateUtilsFragmentTest.assertEquals((long)0L, (long)DateUtils.getFragmentInMilliseconds((Calendar)this.aCalendar, (int)14));
        DateUtilsFragmentTest.assertEquals((long)0L, (long)DateUtils.getFragmentInSeconds((Calendar)this.aCalendar, (int)14));
        DateUtilsFragmentTest.assertEquals((long)0L, (long)DateUtils.getFragmentInMinutes((Calendar)this.aCalendar, (int)14));
        DateUtilsFragmentTest.assertEquals((long)0L, (long)DateUtils.getFragmentInHours((Calendar)this.aCalendar, (int)14));
        DateUtilsFragmentTest.assertEquals((long)0L, (long)DateUtils.getFragmentInDays((Calendar)this.aCalendar, (int)14));
    }

    public void testSecondFragmentInLargerUnitWithDate() {
        DateUtilsFragmentTest.assertEquals((long)0L, (long)DateUtils.getFragmentInSeconds((Date)this.aDate, (int)13));
        DateUtilsFragmentTest.assertEquals((long)0L, (long)DateUtils.getFragmentInMinutes((Date)this.aDate, (int)13));
        DateUtilsFragmentTest.assertEquals((long)0L, (long)DateUtils.getFragmentInHours((Date)this.aDate, (int)13));
        DateUtilsFragmentTest.assertEquals((long)0L, (long)DateUtils.getFragmentInDays((Date)this.aDate, (int)13));
    }

    public void testSecondFragmentInLargerUnitWithCalendar() {
        DateUtilsFragmentTest.assertEquals((long)0L, (long)DateUtils.getFragmentInSeconds((Calendar)this.aCalendar, (int)13));
        DateUtilsFragmentTest.assertEquals((long)0L, (long)DateUtils.getFragmentInMinutes((Calendar)this.aCalendar, (int)13));
        DateUtilsFragmentTest.assertEquals((long)0L, (long)DateUtils.getFragmentInHours((Calendar)this.aCalendar, (int)13));
        DateUtilsFragmentTest.assertEquals((long)0L, (long)DateUtils.getFragmentInDays((Calendar)this.aCalendar, (int)13));
    }

    public void testMinuteFragmentInLargerUnitWithDate() {
        DateUtilsFragmentTest.assertEquals((long)0L, (long)DateUtils.getFragmentInMinutes((Date)this.aDate, (int)12));
        DateUtilsFragmentTest.assertEquals((long)0L, (long)DateUtils.getFragmentInHours((Date)this.aDate, (int)12));
        DateUtilsFragmentTest.assertEquals((long)0L, (long)DateUtils.getFragmentInDays((Date)this.aDate, (int)12));
    }

    public void testMinuteFragmentInLargerUnitWithCalendar() {
        DateUtilsFragmentTest.assertEquals((long)0L, (long)DateUtils.getFragmentInMinutes((Calendar)this.aCalendar, (int)12));
        DateUtilsFragmentTest.assertEquals((long)0L, (long)DateUtils.getFragmentInHours((Calendar)this.aCalendar, (int)12));
        DateUtilsFragmentTest.assertEquals((long)0L, (long)DateUtils.getFragmentInDays((Calendar)this.aCalendar, (int)12));
    }

    public void testHourOfDayFragmentInLargerUnitWithDate() {
        DateUtilsFragmentTest.assertEquals((long)0L, (long)DateUtils.getFragmentInHours((Date)this.aDate, (int)11));
        DateUtilsFragmentTest.assertEquals((long)0L, (long)DateUtils.getFragmentInDays((Date)this.aDate, (int)11));
    }

    public void testHourOfDayFragmentInLargerUnitWithCalendar() {
        DateUtilsFragmentTest.assertEquals((long)0L, (long)DateUtils.getFragmentInHours((Calendar)this.aCalendar, (int)11));
        DateUtilsFragmentTest.assertEquals((long)0L, (long)DateUtils.getFragmentInDays((Calendar)this.aCalendar, (int)11));
    }

    public void testDayOfYearFragmentInLargerUnitWithDate() {
        DateUtilsFragmentTest.assertEquals((long)0L, (long)DateUtils.getFragmentInDays((Date)this.aDate, (int)6));
    }

    public void testDayOfYearFragmentInLargerUnitWithCalendar() {
        DateUtilsFragmentTest.assertEquals((long)0L, (long)DateUtils.getFragmentInDays((Calendar)this.aCalendar, (int)6));
    }

    public void testDateFragmentInLargerUnitWithDate() {
        DateUtilsFragmentTest.assertEquals((long)0L, (long)DateUtils.getFragmentInDays((Date)this.aDate, (int)5));
    }

    public void testDateFragmentInLargerUnitWithCalendar() {
        DateUtilsFragmentTest.assertEquals((long)0L, (long)DateUtils.getFragmentInDays((Calendar)this.aCalendar, (int)5));
    }

    public void testMillisecondsOfSecondWithDate() {
        long testResult = DateUtils.getFragmentInMilliseconds((Date)this.aDate, (int)13);
        DateUtilsFragmentTest.assertEquals((long)991L, (long)testResult);
    }

    public void testMillisecondsOfSecondWithCalendar() {
        long testResult = DateUtils.getFragmentInMilliseconds((Calendar)this.aCalendar, (int)13);
        DateUtilsFragmentTest.assertEquals((long)991L, (long)testResult);
        DateUtilsFragmentTest.assertEquals((long)this.aCalendar.get(14), (long)testResult);
    }

    public void testMillisecondsOfMinuteWithDate() {
        long testResult = DateUtils.getFragmentInMilliseconds((Date)this.aDate, (int)12);
        DateUtilsFragmentTest.assertEquals((long)47991L, (long)testResult);
    }

    public void testMillisecondsOfMinuteWithCalender() {
        long testResult = DateUtils.getFragmentInMilliseconds((Calendar)this.aCalendar, (int)12);
        DateUtilsFragmentTest.assertEquals((long)47991L, (long)testResult);
    }

    public void testSecondsofMinuteWithDate() {
        long testResult = DateUtils.getFragmentInSeconds((Date)this.aDate, (int)12);
        DateUtilsFragmentTest.assertEquals((long)47L, (long)testResult);
    }

    public void testSecondsofMinuteWithCalendar() {
        long testResult = DateUtils.getFragmentInSeconds((Calendar)this.aCalendar, (int)12);
        DateUtilsFragmentTest.assertEquals((long)47L, (long)testResult);
        DateUtilsFragmentTest.assertEquals((long)this.aCalendar.get(13), (long)testResult);
    }

    public void testMillisecondsOfHourWithDate() {
        long testResult = DateUtils.getFragmentInMilliseconds((Date)this.aDate, (int)11);
        DateUtilsFragmentTest.assertEquals((long)3227991L, (long)testResult);
    }

    public void testMillisecondsOfHourWithCalendar() {
        long testResult = DateUtils.getFragmentInMilliseconds((Calendar)this.aCalendar, (int)11);
        DateUtilsFragmentTest.assertEquals((long)3227991L, (long)testResult);
    }

    public void testSecondsofHourWithDate() {
        long testResult = DateUtils.getFragmentInSeconds((Date)this.aDate, (int)11);
        DateUtilsFragmentTest.assertEquals((long)3227L, (long)testResult);
    }

    public void testSecondsofHourWithCalendar() {
        long testResult = DateUtils.getFragmentInSeconds((Calendar)this.aCalendar, (int)11);
        DateUtilsFragmentTest.assertEquals((long)3227L, (long)testResult);
    }

    public void testMinutesOfHourWithDate() {
        long testResult = DateUtils.getFragmentInMinutes((Date)this.aDate, (int)11);
        DateUtilsFragmentTest.assertEquals((long)53L, (long)testResult);
    }

    public void testMinutesOfHourWithCalendar() {
        long testResult = DateUtils.getFragmentInMinutes((Calendar)this.aCalendar, (int)11);
        DateUtilsFragmentTest.assertEquals((long)53L, (long)testResult);
    }

    public void testMillisecondsOfDayWithDate() {
        long testresult = DateUtils.getFragmentInMilliseconds((Date)this.aDate, (int)5);
        long expectedValue = 71627991L;
        DateUtilsFragmentTest.assertEquals((long)expectedValue, (long)testresult);
        testresult = DateUtils.getFragmentInMilliseconds((Date)this.aDate, (int)6);
        DateUtilsFragmentTest.assertEquals((long)expectedValue, (long)testresult);
    }

    public void testMillisecondsOfDayWithCalendar() {
        long testresult = DateUtils.getFragmentInMilliseconds((Calendar)this.aCalendar, (int)5);
        long expectedValue = 71627991L;
        DateUtilsFragmentTest.assertEquals((long)expectedValue, (long)testresult);
        testresult = DateUtils.getFragmentInMilliseconds((Calendar)this.aCalendar, (int)6);
        DateUtilsFragmentTest.assertEquals((long)expectedValue, (long)testresult);
    }

    public void testSecondsOfDayWithDate() {
        long testresult = DateUtils.getFragmentInSeconds((Date)this.aDate, (int)5);
        long expectedValue = 71627L;
        DateUtilsFragmentTest.assertEquals((long)expectedValue, (long)testresult);
        testresult = DateUtils.getFragmentInSeconds((Date)this.aDate, (int)6);
        DateUtilsFragmentTest.assertEquals((long)expectedValue, (long)testresult);
    }

    public void testSecondsOfDayWithCalendar() {
        long testresult = DateUtils.getFragmentInSeconds((Calendar)this.aCalendar, (int)5);
        long expectedValue = 71627L;
        DateUtilsFragmentTest.assertEquals((long)expectedValue, (long)testresult);
        testresult = DateUtils.getFragmentInSeconds((Calendar)this.aCalendar, (int)6);
        DateUtilsFragmentTest.assertEquals((long)expectedValue, (long)testresult);
    }

    public void testMinutesOfDayWithDate() {
        long testResult = DateUtils.getFragmentInMinutes((Date)this.aDate, (int)5);
        long expectedValue = 1193L;
        DateUtilsFragmentTest.assertEquals((long)expectedValue, (long)testResult);
        testResult = DateUtils.getFragmentInMinutes((Date)this.aDate, (int)6);
        DateUtilsFragmentTest.assertEquals((long)expectedValue, (long)testResult);
    }

    public void testMinutesOfDayWithCalendar() {
        long testResult = DateUtils.getFragmentInMinutes((Calendar)this.aCalendar, (int)5);
        long expectedValue = 1193L;
        DateUtilsFragmentTest.assertEquals((long)expectedValue, (long)testResult);
        testResult = DateUtils.getFragmentInMinutes((Calendar)this.aCalendar, (int)6);
        DateUtilsFragmentTest.assertEquals((long)expectedValue, (long)testResult);
    }

    public void testHoursOfDayWithDate() {
        long testResult = DateUtils.getFragmentInHours((Date)this.aDate, (int)5);
        long expectedValue = 19L;
        DateUtilsFragmentTest.assertEquals((long)expectedValue, (long)testResult);
        testResult = DateUtils.getFragmentInHours((Date)this.aDate, (int)6);
        DateUtilsFragmentTest.assertEquals((long)expectedValue, (long)testResult);
    }

    public void testHoursOfDayWithCalendar() {
        long testResult = DateUtils.getFragmentInHours((Calendar)this.aCalendar, (int)5);
        long expectedValue = 19L;
        DateUtilsFragmentTest.assertEquals((long)expectedValue, (long)testResult);
        testResult = DateUtils.getFragmentInHours((Calendar)this.aCalendar, (int)6);
        DateUtilsFragmentTest.assertEquals((long)expectedValue, (long)testResult);
    }

    public void testMillisecondsOfMonthWithDate() {
        long testResult = DateUtils.getFragmentInMilliseconds((Date)this.aDate, (int)2);
        DateUtilsFragmentTest.assertEquals((long)2058827991L, (long)testResult);
    }

    public void testMillisecondsOfMonthWithCalendar() {
        long testResult = DateUtils.getFragmentInMilliseconds((Calendar)this.aCalendar, (int)2);
        DateUtilsFragmentTest.assertEquals((long)2058827991L, (long)testResult);
    }

    public void testSecondsOfMonthWithDate() {
        long testResult = DateUtils.getFragmentInSeconds((Date)this.aDate, (int)2);
        DateUtilsFragmentTest.assertEquals((long)2058827L, (long)testResult);
    }

    public void testSecondsOfMonthWithCalendar() {
        long testResult = DateUtils.getFragmentInSeconds((Calendar)this.aCalendar, (int)2);
        DateUtilsFragmentTest.assertEquals((long)2058827L, (long)testResult);
    }

    public void testMinutesOfMonthWithDate() {
        long testResult = DateUtils.getFragmentInMinutes((Date)this.aDate, (int)2);
        DateUtilsFragmentTest.assertEquals((long)34313L, (long)testResult);
    }

    public void testMinutesOfMonthWithCalendar() {
        long testResult = DateUtils.getFragmentInMinutes((Calendar)this.aCalendar, (int)2);
        DateUtilsFragmentTest.assertEquals((long)34313L, (long)testResult);
    }

    public void testHoursOfMonthWithDate() {
        long testResult = DateUtils.getFragmentInHours((Date)this.aDate, (int)2);
        DateUtilsFragmentTest.assertEquals((long)571L, (long)testResult);
    }

    public void testHoursOfMonthWithCalendar() {
        long testResult = DateUtils.getFragmentInHours((Calendar)this.aCalendar, (int)2);
        DateUtilsFragmentTest.assertEquals((long)571L, (long)testResult);
    }

    public void testMillisecondsOfYearWithDate() {
        long testResult = DateUtils.getFragmentInMilliseconds((Date)this.aDate, (int)1);
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.aDate);
        DateUtilsFragmentTest.assertEquals((long)(71627991L + (long)cal.get(6) * 86400000L), (long)testResult);
    }

    public void testMillisecondsOfYearWithCalendar() {
        long testResult = DateUtils.getFragmentInMilliseconds((Calendar)this.aCalendar, (int)1);
        DateUtilsFragmentTest.assertEquals((long)(71627991L + (long)this.aCalendar.get(6) * 86400000L), (long)testResult);
    }

    public void testSecondsOfYearWithDate() {
        long testResult = DateUtils.getFragmentInSeconds((Date)this.aDate, (int)1);
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.aDate);
        DateUtilsFragmentTest.assertEquals((long)(47L + (71580000L + (long)cal.get(6) * 86400000L) / 1000L), (long)testResult);
    }

    public void testSecondsOfYearWithCalendar() {
        long testResult = DateUtils.getFragmentInSeconds((Calendar)this.aCalendar, (int)1);
        DateUtilsFragmentTest.assertEquals((long)(47L + (71580000L + (long)this.aCalendar.get(6) * 86400000L) / 1000L), (long)testResult);
    }

    public void testMinutesOfYearWithDate() {
        long testResult = DateUtils.getFragmentInMinutes((Date)this.aDate, (int)1);
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.aDate);
        DateUtilsFragmentTest.assertEquals((long)(53L + (68400000L + (long)cal.get(6) * 86400000L) / 60000L), (long)testResult);
    }

    public void testMinutesOfYearWithCalendar() {
        long testResult = DateUtils.getFragmentInMinutes((Calendar)this.aCalendar, (int)1);
        DateUtilsFragmentTest.assertEquals((long)(53L + (68400000L + (long)this.aCalendar.get(6) * 86400000L) / 60000L), (long)testResult);
    }

    public void testHoursOfYearWithDate() {
        long testResult = DateUtils.getFragmentInHours((Date)this.aDate, (int)1);
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.aDate);
        DateUtilsFragmentTest.assertEquals((long)(19L + (long)cal.get(6) * 86400000L / 3600000L), (long)testResult);
    }

    public void testHoursOfYearWithCalendar() {
        long testResult = DateUtils.getFragmentInHours((Calendar)this.aCalendar, (int)1);
        DateUtilsFragmentTest.assertEquals((long)(19L + (long)this.aCalendar.get(6) * 86400000L / 3600000L), (long)testResult);
    }
}

