/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.junit.Assert;
import org.junit.Test;

public class ArrayUtilsRemoveMultipleTest {
    @Test
    public void testRemoveAllObjectArray() {
        Object[] array = ArrayUtils.removeAll((Object[])new Object[]{"a"}, (int[])new int[]{0});
        Assert.assertArrayEquals((Object[])ArrayUtils.EMPTY_OBJECT_ARRAY, (Object[])array);
        Assert.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((Object[])new Object[]{"a", "b"}, (int[])new int[]{0, 1});
        Assert.assertArrayEquals((Object[])ArrayUtils.EMPTY_OBJECT_ARRAY, (Object[])array);
        Assert.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((Object[])new Object[]{"a", "b", "c"}, (int[])new int[]{1, 2});
        Assert.assertArrayEquals((Object[])new Object[]{"a"}, (Object[])array);
        Assert.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((Object[])new Object[]{"a", "b", "c", "d"}, (int[])new int[]{1, 2});
        Assert.assertArrayEquals((Object[])new Object[]{"a", "d"}, (Object[])array);
        Assert.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((Object[])new Object[]{"a", "b", "c", "d"}, (int[])new int[]{0, 3});
        Assert.assertArrayEquals((Object[])new Object[]{"b", "c"}, (Object[])array);
        Assert.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((Object[])new Object[]{"a", "b", "c", "d"}, (int[])new int[]{0, 1, 3});
        Assert.assertArrayEquals((Object[])new Object[]{"c"}, (Object[])array);
        Assert.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((Object[])new Object[]{"a", "b", "c", "d", "e"}, (int[])new int[]{0, 1, 3});
        Assert.assertArrayEquals((Object[])new Object[]{"c", "e"}, (Object[])array);
        Assert.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((Object[])new Object[]{"a", "b", "c", "d", "e"}, (int[])new int[]{0, 2, 4});
        Assert.assertArrayEquals((Object[])new Object[]{"b", "d"}, (Object[])array);
        Assert.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((Object[])new Object[]{"a", "b", "c", "d"}, (int[])new int[]{0, 1, 3, 0, 1, 3});
        Assert.assertArrayEquals((Object[])new Object[]{"c"}, (Object[])array);
        Assert.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((Object[])new Object[]{"a", "b", "c", "d"}, (int[])new int[]{2, 1, 0, 3});
        Assert.assertArrayEquals((Object[])ArrayUtils.EMPTY_OBJECT_ARRAY, (Object[])array);
        Assert.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((Object[])new Object[]{"a", "b", "c", "d"}, (int[])new int[]{2, 0, 1, 3, 0, 2, 1, 3});
        Assert.assertArrayEquals((Object[])ArrayUtils.EMPTY_OBJECT_ARRAY, (Object[])array);
        Assert.assertEquals(Object.class, array.getClass().getComponentType());
    }

    @Test
    public void testRemoveAllObjectArrayRemoveNone() {
        Object[] array1 = new Object[]{"foo", "bar", "baz"};
        Object[] array2 = ArrayUtils.removeAll((Object[])array1, (int[])new int[0]);
        Assert.assertNotSame((Object)array1, (Object)array2);
        Assert.assertArrayEquals((Object[])array1, (Object[])array2);
        Assert.assertEquals(Object.class, array2.getClass().getComponentType());
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testRemoveAllObjectArrayNegativeIndex() {
        ArrayUtils.removeAll((Object[])new Object[]{"a", "b"}, (int[])new int[]{-1});
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testRemoveAllObjectArrayOutOfBoundsIndex() {
        ArrayUtils.removeAll((Object[])new Object[]{"a", "b"}, (int[])new int[]{2});
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testRemoveAllNullObjectArray() {
        ArrayUtils.remove((Object[])null, (int)0);
    }

    @Test
    public void testRemoveAllNumberArray() {
        Object[] inarray = new Number[]{1, 2L, (byte)3};
        Assert.assertEquals((long)3L, (long)inarray.length);
        Object[] outarray = (Number[])ArrayUtils.removeAll((Object[])inarray, (int[])new int[]{1});
        Assert.assertArrayEquals((Object[])new Number[]{1, (byte)3}, (Object[])outarray);
        Assert.assertEquals(Number.class, outarray.getClass().getComponentType());
        outarray = (Number[])ArrayUtils.removeAll((Object[])outarray, (int[])new int[]{1});
        Assert.assertArrayEquals((Object[])new Number[]{1}, (Object[])outarray);
        Assert.assertEquals(Number.class, outarray.getClass().getComponentType());
        outarray = (Number[])ArrayUtils.removeAll((Object[])outarray, (int[])new int[]{0});
        Assert.assertEquals((long)0L, (long)outarray.length);
        Assert.assertEquals(Number.class, outarray.getClass().getComponentType());
        outarray = (Number[])ArrayUtils.removeAll((Object[])inarray, (int[])new int[]{0, 1});
        Assert.assertArrayEquals((Object[])new Number[]{(byte)3}, (Object[])outarray);
        Assert.assertEquals(Number.class, outarray.getClass().getComponentType());
        outarray = (Number[])ArrayUtils.removeAll((Object[])inarray, (int[])new int[]{0, 2});
        Assert.assertArrayEquals((Object[])new Number[]{2L}, (Object[])outarray);
        Assert.assertEquals(Number.class, outarray.getClass().getComponentType());
        outarray = (Number[])ArrayUtils.removeAll((Object[])inarray, (int[])new int[]{1, 2});
        Assert.assertArrayEquals((Object[])new Number[]{1}, (Object[])outarray);
        Assert.assertEquals(Number.class, outarray.getClass().getComponentType());
    }

    @Test
    public void testRemoveAllBooleanArray() {
        boolean[] array = ArrayUtils.removeAll((boolean[])new boolean[]{true}, (int[])new int[]{0});
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_BOOLEAN_ARRAY, array));
        Assert.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((boolean[])new boolean[]{true, false}, (int[])new int[]{0});
        Assert.assertTrue((boolean)Arrays.equals(new boolean[]{false}, array));
        Assert.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((boolean[])new boolean[]{true, false}, (int[])new int[]{1});
        Assert.assertTrue((boolean)Arrays.equals(new boolean[]{true}, array));
        Assert.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((boolean[])new boolean[]{true, false, true}, (int[])new int[]{1});
        Assert.assertTrue((boolean)Arrays.equals(new boolean[]{true, true}, array));
        Assert.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((boolean[])new boolean[]{true, false}, (int[])new int[]{0, 1});
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_BOOLEAN_ARRAY, array));
        Assert.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((boolean[])new boolean[]{true, false, false}, (int[])new int[]{0, 1});
        Assert.assertTrue((boolean)Arrays.equals(new boolean[]{false}, array));
        Assert.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((boolean[])new boolean[]{true, false, false}, (int[])new int[]{0, 2});
        Assert.assertTrue((boolean)Arrays.equals(new boolean[]{false}, array));
        Assert.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((boolean[])new boolean[]{true, false, false}, (int[])new int[]{1, 2});
        Assert.assertTrue((boolean)Arrays.equals(new boolean[]{true}, array));
        Assert.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((boolean[])new boolean[]{true, false, true, false, true}, (int[])new int[]{0, 2, 4});
        Assert.assertTrue((boolean)Arrays.equals(new boolean[]{false, false}, array));
        Assert.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((boolean[])new boolean[]{true, false, true, false, true}, (int[])new int[]{1, 3});
        Assert.assertTrue((boolean)Arrays.equals(new boolean[]{true, true, true}, array));
        Assert.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((boolean[])new boolean[]{true, false, true, false, true}, (int[])new int[]{1, 3, 4});
        Assert.assertTrue((boolean)Arrays.equals(new boolean[]{true, true}, array));
        Assert.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((boolean[])new boolean[]{true, false, true, false, true, false, true}, (int[])new int[]{0, 2, 4, 6});
        Assert.assertTrue((boolean)Arrays.equals(new boolean[]{false, false, false}, array));
        Assert.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((boolean[])new boolean[]{true, false, true, false, true, false, true}, (int[])new int[]{1, 3, 5});
        Assert.assertTrue((boolean)Arrays.equals(new boolean[]{true, true, true, true}, array));
        Assert.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((boolean[])new boolean[]{true, false, true, false, true, false, true}, (int[])new int[]{0, 1, 2});
        Assert.assertTrue((boolean)Arrays.equals(new boolean[]{false, true, false, true}, array));
        Assert.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
    }

    @Test
    public void testRemoveAllBooleanArrayRemoveNone() {
        boolean[] array1 = new boolean[]{true, false};
        boolean[] array2 = ArrayUtils.removeAll((boolean[])array1, (int[])new int[0]);
        Assert.assertNotSame((Object)array1, (Object)array2);
        Assert.assertTrue((boolean)Arrays.equals(array1, array2));
        Assert.assertEquals(Boolean.TYPE, array2.getClass().getComponentType());
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testRemoveAllBooleanArrayNegativeIndex() {
        ArrayUtils.removeAll((boolean[])new boolean[]{true, false}, (int[])new int[]{-1});
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testRemoveAllBooleanArrayOutOfBoundsIndex() {
        ArrayUtils.removeAll((boolean[])new boolean[]{true, false}, (int[])new int[]{2});
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testRemoveAllNullBooleanArray() {
        ArrayUtils.removeAll((boolean[])null, (int[])new int[]{0});
    }

    @Test
    public void testRemoveAllByteArray() {
        byte[] array = ArrayUtils.removeAll((byte[])new byte[]{1}, (int[])new int[]{0});
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_BYTE_ARRAY, array));
        Assert.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((byte[])new byte[]{1, 2}, (int[])new int[]{0});
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{2}, array));
        Assert.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((byte[])new byte[]{1, 2}, (int[])new int[]{1});
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{1}, array));
        Assert.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((byte[])new byte[]{1, 2, 1}, (int[])new int[]{1});
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{1, 1}, array));
        Assert.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((byte[])new byte[]{1, 2}, (int[])new int[]{0, 1});
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_BYTE_ARRAY, array));
        Assert.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((byte[])new byte[]{1, 2, 3}, (int[])new int[]{0, 1});
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{3}, array));
        Assert.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((byte[])new byte[]{1, 2, 3}, (int[])new int[]{1, 2});
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{1}, array));
        Assert.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((byte[])new byte[]{1, 2, 3}, (int[])new int[]{0, 2});
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{2}, array));
        Assert.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((byte[])new byte[]{1, 2, 3, 4, 5}, (int[])new int[]{1, 3});
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{1, 3, 5}, array));
        Assert.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((byte[])new byte[]{1, 2, 3, 4, 5}, (int[])new int[]{0, 2, 4});
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{2, 4}, array));
        Assert.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((byte[])new byte[]{1, 2, 3, 4, 5, 6, 7}, (int[])new int[]{1, 3, 5});
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{1, 3, 5, 7}, array));
        Assert.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((byte[])new byte[]{1, 2, 3, 4, 5, 6, 7}, (int[])new int[]{0, 2, 4, 6});
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{2, 4, 6}, array));
        Assert.assertEquals(Byte.TYPE, array.getClass().getComponentType());
    }

    @Test
    public void testRemoveAllByteArrayRemoveNone() {
        byte[] array1 = new byte[]{1, 2};
        byte[] array2 = ArrayUtils.removeAll((byte[])array1, (int[])new int[0]);
        Assert.assertNotSame((Object)array1, (Object)array2);
        Assert.assertArrayEquals((byte[])array1, (byte[])array2);
        Assert.assertEquals(Byte.TYPE, array2.getClass().getComponentType());
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testRemoveAllByteArrayNegativeIndex() {
        ArrayUtils.removeAll((byte[])new byte[]{1, 2}, (int[])new int[]{-1});
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testRemoveAllByteArrayOutOfBoundsIndex() {
        ArrayUtils.removeAll((byte[])new byte[]{1, 2}, (int[])new int[]{2});
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testRemoveAllNullByteArray() {
        ArrayUtils.removeAll((byte[])null, (int[])new int[]{0});
    }

    @Test
    public void testRemoveAllCharArray() {
        char[] array = ArrayUtils.removeAll((char[])new char[]{'a'}, (int[])new int[]{0});
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_CHAR_ARRAY, array));
        Assert.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((char[])new char[]{'a', 'b'}, (int[])new int[]{0});
        Assert.assertTrue((boolean)Arrays.equals(new char[]{'b'}, array));
        Assert.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((char[])new char[]{'a', 'b'}, (int[])new int[]{1});
        Assert.assertTrue((boolean)Arrays.equals(new char[]{'a'}, array));
        Assert.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((char[])new char[]{'a', 'b', 'c'}, (int[])new int[]{1});
        Assert.assertTrue((boolean)Arrays.equals(new char[]{'a', 'c'}, array));
        Assert.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((char[])new char[]{'a', 'b'}, (int[])new int[]{0, 1});
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_CHAR_ARRAY, array));
        Assert.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((char[])new char[]{'a', 'b', 'c'}, (int[])new int[]{0, 1});
        Assert.assertTrue((boolean)Arrays.equals(new char[]{'c'}, array));
        Assert.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((char[])new char[]{'a', 'b', 'c'}, (int[])new int[]{1, 2});
        Assert.assertTrue((boolean)Arrays.equals(new char[]{'a'}, array));
        Assert.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((char[])new char[]{'a', 'b', 'c'}, (int[])new int[]{0, 2});
        Assert.assertTrue((boolean)Arrays.equals(new char[]{'b'}, array));
        Assert.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((char[])new char[]{'a', 'b', 'c', 'd', 'e'}, (int[])new int[]{1, 3});
        Assert.assertTrue((boolean)Arrays.equals(new char[]{'a', 'c', 'e'}, array));
        Assert.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((char[])new char[]{'a', 'b', 'c', 'd', 'e'}, (int[])new int[]{0, 2, 4});
        Assert.assertTrue((boolean)Arrays.equals(new char[]{'b', 'd'}, array));
        Assert.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((char[])new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g'}, (int[])new int[]{1, 3, 5});
        Assert.assertTrue((boolean)Arrays.equals(new char[]{'a', 'c', 'e', 'g'}, array));
        Assert.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((char[])new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g'}, (int[])new int[]{0, 2, 4, 6});
        Assert.assertTrue((boolean)Arrays.equals(new char[]{'b', 'd', 'f'}, array));
        Assert.assertEquals(Character.TYPE, array.getClass().getComponentType());
    }

    @Test
    public void testRemoveAllCharArrayRemoveNone() {
        char[] array1 = new char[]{'a', 'b'};
        char[] array2 = ArrayUtils.removeAll((char[])array1, (int[])new int[0]);
        Assert.assertNotSame((Object)array1, (Object)array2);
        Assert.assertArrayEquals((char[])array1, (char[])array2);
        Assert.assertEquals(Character.TYPE, array2.getClass().getComponentType());
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testRemoveAllCharArrayNegativeIndex() {
        ArrayUtils.removeAll((char[])new char[]{'a', 'b'}, (int[])new int[]{-1});
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testRemoveAllCharArrayOutOfBoundsIndex() {
        ArrayUtils.removeAll((char[])new char[]{'a', 'b'}, (int[])new int[]{2});
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testRemoveAllNullCharArray() {
        ArrayUtils.removeAll((char[])null, (int[])new int[]{0});
    }

    @Test
    public void testRemoveAllDoubleArray() {
        double[] array = ArrayUtils.removeAll((double[])new double[]{1.0}, (int[])new int[]{0});
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_DOUBLE_ARRAY, array));
        Assert.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((double[])new double[]{1.0, 2.0}, (int[])new int[]{0});
        Assert.assertTrue((boolean)Arrays.equals(new double[]{2.0}, array));
        Assert.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((double[])new double[]{1.0, 2.0}, (int[])new int[]{1});
        Assert.assertTrue((boolean)Arrays.equals(new double[]{1.0}, array));
        Assert.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((double[])new double[]{1.0, 2.0, 1.0}, (int[])new int[]{1});
        Assert.assertTrue((boolean)Arrays.equals(new double[]{1.0, 1.0}, array));
        Assert.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((double[])new double[]{1.0, 2.0}, (int[])new int[]{0, 1});
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_DOUBLE_ARRAY, array));
        Assert.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((double[])new double[]{1.0, 2.0, 3.0}, (int[])new int[]{0, 1});
        Assert.assertTrue((boolean)Arrays.equals(new double[]{3.0}, array));
        Assert.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((double[])new double[]{1.0, 2.0, 3.0}, (int[])new int[]{1, 2});
        Assert.assertTrue((boolean)Arrays.equals(new double[]{1.0}, array));
        Assert.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((double[])new double[]{1.0, 2.0, 3.0}, (int[])new int[]{0, 2});
        Assert.assertTrue((boolean)Arrays.equals(new double[]{2.0}, array));
        Assert.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((double[])new double[]{1.0, 2.0, 3.0, 4.0, 5.0}, (int[])new int[]{1, 3});
        Assert.assertTrue((boolean)Arrays.equals(new double[]{1.0, 3.0, 5.0}, array));
        Assert.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((double[])new double[]{1.0, 2.0, 3.0, 4.0, 5.0}, (int[])new int[]{0, 2, 4});
        Assert.assertTrue((boolean)Arrays.equals(new double[]{2.0, 4.0}, array));
        Assert.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((double[])new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0}, (int[])new int[]{1, 3, 5});
        Assert.assertTrue((boolean)Arrays.equals(new double[]{1.0, 3.0, 5.0, 7.0}, array));
        Assert.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((double[])new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0}, (int[])new int[]{0, 2, 4, 6});
        Assert.assertTrue((boolean)Arrays.equals(new double[]{2.0, 4.0, 6.0}, array));
        Assert.assertEquals(Double.TYPE, array.getClass().getComponentType());
    }

    @Test
    public void testRemoveAllDoubleArrayRemoveNone() {
        double[] array1 = new double[]{1.0, 2.0};
        double[] array2 = ArrayUtils.removeAll((double[])array1, (int[])new int[0]);
        Assert.assertNotSame((Object)array1, (Object)array2);
        Assert.assertTrue((boolean)Arrays.equals(array1, array2));
        Assert.assertEquals(Double.TYPE, array2.getClass().getComponentType());
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testRemoveAllDoubleArrayNegativeIndex() {
        ArrayUtils.removeAll((double[])new double[]{1.0, 2.0}, (int[])new int[]{-1});
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testRemoveAllDoubleArrayOutOfBoundsIndex() {
        ArrayUtils.removeAll((double[])new double[]{1.0, 2.0}, (int[])new int[]{2});
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testRemoveAllNullDoubleArray() {
        ArrayUtils.removeAll((double[])null, (int[])new int[]{0});
    }

    @Test
    public void testRemoveAllFloatArray() {
        float[] array = ArrayUtils.removeAll((float[])new float[]{1.0f}, (int[])new int[]{0});
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_FLOAT_ARRAY, array));
        Assert.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((float[])new float[]{1.0f, 2.0f}, (int[])new int[]{0});
        Assert.assertTrue((boolean)Arrays.equals(new float[]{2.0f}, array));
        Assert.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((float[])new float[]{1.0f, 2.0f}, (int[])new int[]{1});
        Assert.assertTrue((boolean)Arrays.equals(new float[]{1.0f}, array));
        Assert.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((float[])new float[]{1.0f, 2.0f, 1.0f}, (int[])new int[]{1});
        Assert.assertTrue((boolean)Arrays.equals(new float[]{1.0f, 1.0f}, array));
        Assert.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((float[])new float[]{1.0f, 2.0f}, (int[])new int[]{0, 1});
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_FLOAT_ARRAY, array));
        Assert.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((float[])new float[]{1.0f, 2.0f, 3.0f}, (int[])new int[]{0, 1});
        Assert.assertTrue((boolean)Arrays.equals(new float[]{3.0f}, array));
        Assert.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((float[])new float[]{1.0f, 2.0f, 3.0f}, (int[])new int[]{1, 2});
        Assert.assertTrue((boolean)Arrays.equals(new float[]{1.0f}, array));
        Assert.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((float[])new float[]{1.0f, 2.0f, 3.0f}, (int[])new int[]{0, 2});
        Assert.assertTrue((boolean)Arrays.equals(new float[]{2.0f}, array));
        Assert.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((float[])new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f}, (int[])new int[]{1, 3});
        Assert.assertTrue((boolean)Arrays.equals(new float[]{1.0f, 3.0f, 5.0f}, array));
        Assert.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((float[])new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f}, (int[])new int[]{0, 2, 4});
        Assert.assertTrue((boolean)Arrays.equals(new float[]{2.0f, 4.0f}, array));
        Assert.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((float[])new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f}, (int[])new int[]{1, 3, 5});
        Assert.assertTrue((boolean)Arrays.equals(new float[]{1.0f, 3.0f, 5.0f, 7.0f}, array));
        Assert.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((float[])new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f}, (int[])new int[]{0, 2, 4, 6});
        Assert.assertTrue((boolean)Arrays.equals(new float[]{2.0f, 4.0f, 6.0f}, array));
        Assert.assertEquals(Float.TYPE, array.getClass().getComponentType());
    }

    @Test
    public void testRemoveAllFloatArrayRemoveNone() {
        float[] array1 = new float[]{1.0f, 2.0f};
        float[] array2 = ArrayUtils.removeAll((float[])array1, (int[])new int[0]);
        Assert.assertNotSame((Object)array1, (Object)array2);
        Assert.assertTrue((boolean)Arrays.equals(array1, array2));
        Assert.assertEquals(Float.TYPE, array2.getClass().getComponentType());
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testRemoveAllFloatArrayNegativeIndex() {
        ArrayUtils.removeAll((float[])new float[]{1.0f, 2.0f}, (int[])new int[]{-1});
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testRemoveAllFloatArrayOutOfBoundsIndex() {
        ArrayUtils.removeAll((float[])new float[]{1.0f, 2.0f}, (int[])new int[]{2});
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testRemoveAllNullFloatArray() {
        ArrayUtils.removeAll((float[])null, (int[])new int[]{0});
    }

    @Test
    public void testRemoveAllIntArray() {
        int[] array = ArrayUtils.removeAll((int[])new int[]{1}, (int[])new int[]{0});
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_INT_ARRAY, array));
        Assert.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((int[])new int[]{1, 2}, (int[])new int[]{0});
        Assert.assertTrue((boolean)Arrays.equals(new int[]{2}, array));
        Assert.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((int[])new int[]{1, 2}, (int[])new int[]{1});
        Assert.assertTrue((boolean)Arrays.equals(new int[]{1}, array));
        Assert.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((int[])new int[]{1, 2, 1}, (int[])new int[]{1});
        Assert.assertTrue((boolean)Arrays.equals(new int[]{1, 1}, array));
        Assert.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((int[])new int[]{1, 2}, (int[])new int[]{0, 1});
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_INT_ARRAY, array));
        Assert.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((int[])new int[]{1, 2, 3}, (int[])new int[]{0, 1});
        Assert.assertTrue((boolean)Arrays.equals(new int[]{3}, array));
        Assert.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((int[])new int[]{1, 2, 3}, (int[])new int[]{1, 2});
        Assert.assertTrue((boolean)Arrays.equals(new int[]{1}, array));
        Assert.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((int[])new int[]{1, 2, 3}, (int[])new int[]{0, 2});
        Assert.assertTrue((boolean)Arrays.equals(new int[]{2}, array));
        Assert.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((int[])new int[]{1, 2, 3, 4, 5}, (int[])new int[]{1, 3});
        Assert.assertTrue((boolean)Arrays.equals(new int[]{1, 3, 5}, array));
        Assert.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((int[])new int[]{1, 2, 3, 4, 5}, (int[])new int[]{0, 2, 4});
        Assert.assertTrue((boolean)Arrays.equals(new int[]{2, 4}, array));
        Assert.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((int[])new int[]{1, 2, 3, 4, 5, 6, 7}, (int[])new int[]{1, 3, 5});
        Assert.assertTrue((boolean)Arrays.equals(new int[]{1, 3, 5, 7}, array));
        Assert.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((int[])new int[]{1, 2, 3, 4, 5, 6, 7}, (int[])new int[]{0, 2, 4, 6});
        Assert.assertTrue((boolean)Arrays.equals(new int[]{2, 4, 6}, array));
        Assert.assertEquals(Integer.TYPE, array.getClass().getComponentType());
    }

    @Test
    public void testRemoveAllIntArrayRemoveNone() {
        int[] array1 = new int[]{1, 2};
        int[] array2 = ArrayUtils.removeAll((int[])array1, (int[])new int[0]);
        Assert.assertNotSame((Object)array1, (Object)array2);
        Assert.assertArrayEquals((int[])array1, (int[])array2);
        Assert.assertEquals(Integer.TYPE, array2.getClass().getComponentType());
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testRemoveAllIntArrayNegativeIndex() {
        ArrayUtils.removeAll((int[])new int[]{1, 2}, (int[])new int[]{-1});
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testRemoveAllIntArrayOutOfBoundsIndex() {
        ArrayUtils.removeAll((int[])new int[]{1, 2}, (int[])new int[]{2});
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testRemoveAllNullIntArray() {
        ArrayUtils.removeAll((int[])null, (int[])new int[]{0});
    }

    @Test
    public void testRemoveAllLongArray() {
        long[] array = ArrayUtils.removeAll((long[])new long[]{1L}, (int[])new int[]{0});
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_LONG_ARRAY, array));
        Assert.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((long[])new long[]{1L, 2L}, (int[])new int[]{0});
        Assert.assertTrue((boolean)Arrays.equals(new long[]{2L}, array));
        Assert.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((long[])new long[]{1L, 2L}, (int[])new int[]{1});
        Assert.assertTrue((boolean)Arrays.equals(new long[]{1L}, array));
        Assert.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((long[])new long[]{1L, 2L, 1L}, (int[])new int[]{1});
        Assert.assertTrue((boolean)Arrays.equals(new long[]{1L, 1L}, array));
        Assert.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((long[])new long[]{1L, 2L}, (int[])new int[]{0, 1});
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_LONG_ARRAY, array));
        Assert.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((long[])new long[]{1L, 2L, 3L}, (int[])new int[]{0, 1});
        Assert.assertTrue((boolean)Arrays.equals(new long[]{3L}, array));
        Assert.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((long[])new long[]{1L, 2L, 3L}, (int[])new int[]{1, 2});
        Assert.assertTrue((boolean)Arrays.equals(new long[]{1L}, array));
        Assert.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((long[])new long[]{1L, 2L, 3L}, (int[])new int[]{0, 2});
        Assert.assertTrue((boolean)Arrays.equals(new long[]{2L}, array));
        Assert.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((long[])new long[]{1L, 2L, 3L, 4L, 5L}, (int[])new int[]{1, 3});
        Assert.assertTrue((boolean)Arrays.equals(new long[]{1L, 3L, 5L}, array));
        Assert.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((long[])new long[]{1L, 2L, 3L, 4L, 5L}, (int[])new int[]{0, 2, 4});
        Assert.assertTrue((boolean)Arrays.equals(new long[]{2L, 4L}, array));
        Assert.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((long[])new long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L}, (int[])new int[]{1, 3, 5});
        Assert.assertTrue((boolean)Arrays.equals(new long[]{1L, 3L, 5L, 7L}, array));
        Assert.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((long[])new long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L}, (int[])new int[]{0, 2, 4, 6});
        Assert.assertTrue((boolean)Arrays.equals(new long[]{2L, 4L, 6L}, array));
        Assert.assertEquals(Long.TYPE, array.getClass().getComponentType());
    }

    @Test
    public void testRemoveAllLongArrayRemoveNone() {
        long[] array1 = new long[]{1L, 2L};
        long[] array2 = ArrayUtils.removeAll((long[])array1, (int[])new int[0]);
        Assert.assertNotSame((Object)array1, (Object)array2);
        Assert.assertArrayEquals((long[])array1, (long[])array2);
        Assert.assertEquals(Long.TYPE, array2.getClass().getComponentType());
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testRemoveAllLongArrayNegativeIndex() {
        ArrayUtils.removeAll((long[])new long[]{1L, 2L}, (int[])new int[]{-1});
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testRemoveAllLongArrayOutOfBoundsIndex() {
        ArrayUtils.removeAll((long[])new long[]{1L, 2L}, (int[])new int[]{2});
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testRemoveAllNullLongArray() {
        ArrayUtils.removeAll((long[])null, (int[])new int[]{0});
    }

    @Test
    public void testRemoveAllShortArray() {
        short[] array = ArrayUtils.removeAll((short[])new short[]{1}, (int[])new int[]{0});
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_SHORT_ARRAY, array));
        Assert.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((short[])new short[]{1, 2}, (int[])new int[]{0});
        Assert.assertTrue((boolean)Arrays.equals(new short[]{2}, array));
        Assert.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((short[])new short[]{1, 2}, (int[])new int[]{1});
        Assert.assertTrue((boolean)Arrays.equals(new short[]{1}, array));
        Assert.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((short[])new short[]{1, 2, 1}, (int[])new int[]{1});
        Assert.assertTrue((boolean)Arrays.equals(new short[]{1, 1}, array));
        Assert.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((short[])new short[]{1, 2}, (int[])new int[]{0, 1});
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_SHORT_ARRAY, array));
        Assert.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((short[])new short[]{1, 2, 3}, (int[])new int[]{0, 1});
        Assert.assertTrue((boolean)Arrays.equals(new short[]{3}, array));
        Assert.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((short[])new short[]{1, 2, 3}, (int[])new int[]{1, 2});
        Assert.assertTrue((boolean)Arrays.equals(new short[]{1}, array));
        Assert.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((short[])new short[]{1, 2, 3}, (int[])new int[]{0, 2});
        Assert.assertTrue((boolean)Arrays.equals(new short[]{2}, array));
        Assert.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((short[])new short[]{1, 2, 3, 4, 5}, (int[])new int[]{1, 3});
        Assert.assertTrue((boolean)Arrays.equals(new short[]{1, 3, 5}, array));
        Assert.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((short[])new short[]{1, 2, 3, 4, 5}, (int[])new int[]{0, 2, 4});
        Assert.assertTrue((boolean)Arrays.equals(new short[]{2, 4}, array));
        Assert.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((short[])new short[]{1, 2, 3, 4, 5, 6, 7}, (int[])new int[]{1, 3, 5});
        Assert.assertTrue((boolean)Arrays.equals(new short[]{1, 3, 5, 7}, array));
        Assert.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((short[])new short[]{1, 2, 3, 4, 5, 6, 7}, (int[])new int[]{0, 2, 4, 6});
        Assert.assertTrue((boolean)Arrays.equals(new short[]{2, 4, 6}, array));
        Assert.assertEquals(Short.TYPE, array.getClass().getComponentType());
    }

    @Test
    public void testRemoveAllShortArrayRemoveNone() {
        short[] array1 = new short[]{1, 2};
        short[] array2 = ArrayUtils.removeAll((short[])array1, (int[])new int[0]);
        Assert.assertNotSame((Object)array1, (Object)array2);
        Assert.assertArrayEquals((short[])array1, (short[])array2);
        Assert.assertEquals(Short.TYPE, array2.getClass().getComponentType());
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testRemoveAllShortArrayNegativeIndex() {
        ArrayUtils.removeAll((short[])new short[]{1, 2}, (int[])new int[]{-1, 0});
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testRemoveAllShortArrayOutOfBoundsIndex() {
        ArrayUtils.removeAll((short[])new short[]{1, 2}, (int[])new int[]{2, 0});
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testRemoveAllNullShortArray() {
        ArrayUtils.removeAll((short[])null, (int[])new int[]{0});
    }

    @Test
    public void testRemoveElementsObjectArray() {
        Object[] array = ArrayUtils.removeElements((Object[])null, (Object[])new Object[]{"a"});
        Assert.assertNull((Object)array);
        array = ArrayUtils.removeElements((Object[])ArrayUtils.EMPTY_OBJECT_ARRAY, (Object[])new Object[]{"a"});
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_OBJECT_ARRAY, array));
        Assert.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((Object[])new Object[]{"a"}, (Object[])new Object[]{"a"});
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_OBJECT_ARRAY, array));
        Assert.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((Object[])new Object[]{"a", "b"}, (Object[])new Object[]{"a"});
        Assert.assertTrue((boolean)Arrays.equals(new Object[]{"b"}, array));
        Assert.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((Object[])new Object[]{"a", "b", "a"}, (Object[])new Object[]{"a"});
        Assert.assertTrue((boolean)Arrays.equals(new Object[]{"b", "a"}, array));
        Assert.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((Object[])null, (Object[])new Object[]{"a", "b"});
        Assert.assertNull((Object)array);
        array = ArrayUtils.removeElements((Object[])ArrayUtils.EMPTY_OBJECT_ARRAY, (Object[])new Object[]{"a", "b"});
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_OBJECT_ARRAY, array));
        Assert.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((Object[])new Object[]{"a"}, (Object[])new Object[]{"a", "b"});
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_OBJECT_ARRAY, array));
        Assert.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((Object[])new Object[]{"a", "b"}, (Object[])new Object[]{"a", "c"});
        Assert.assertTrue((boolean)Arrays.equals(new Object[]{"b"}, array));
        Assert.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((Object[])new Object[]{"a", "b", "a"}, (Object[])new Object[]{"a"});
        Assert.assertTrue((boolean)Arrays.equals(new Object[]{"b", "a"}, array));
        Assert.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((Object[])new Object[]{"a", "b", "a"}, (Object[])new Object[]{"a", "b"});
        Assert.assertTrue((boolean)Arrays.equals(new Object[]{"a"}, array));
        Assert.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((Object[])new Object[]{"a", "b", "a"}, (Object[])new Object[]{"a", "a"});
        Assert.assertTrue((boolean)Arrays.equals(new Object[]{"b"}, array));
        Assert.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((Object[])new Object[]{"a", "b", "a"}, (Object[])new Object[]{"a", "a", "a", "a"});
        Assert.assertTrue((boolean)Arrays.equals(new Object[]{"b"}, array));
        Assert.assertEquals(Object.class, array.getClass().getComponentType());
    }

    @Test
    public void testRemoveElementBooleanArray() {
        boolean[] array = ArrayUtils.removeElements((boolean[])null, (boolean[])new boolean[]{true});
        Assert.assertNull((Object)array);
        array = ArrayUtils.removeElements((boolean[])ArrayUtils.EMPTY_BOOLEAN_ARRAY, (boolean[])new boolean[]{true});
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_BOOLEAN_ARRAY, array));
        Assert.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((boolean[])new boolean[]{true}, (boolean[])new boolean[]{true});
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_BOOLEAN_ARRAY, array));
        Assert.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((boolean[])new boolean[]{true, false}, (boolean[])new boolean[]{true});
        Assert.assertTrue((boolean)Arrays.equals(new boolean[]{false}, array));
        Assert.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((boolean[])new boolean[]{true, false, true}, (boolean[])new boolean[]{true});
        Assert.assertTrue((boolean)Arrays.equals(new boolean[]{false, true}, array));
        Assert.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((boolean[])null, (boolean[])new boolean[]{true, false});
        Assert.assertNull((Object)array);
        array = ArrayUtils.removeElements((boolean[])ArrayUtils.EMPTY_BOOLEAN_ARRAY, (boolean[])new boolean[]{true, false});
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_BOOLEAN_ARRAY, array));
        Assert.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((boolean[])new boolean[]{true}, (boolean[])new boolean[]{true, false});
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_BOOLEAN_ARRAY, array));
        Assert.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((boolean[])new boolean[]{true, false}, (boolean[])new boolean[]{true, false});
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_BOOLEAN_ARRAY, array));
        Assert.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((boolean[])new boolean[]{true, false}, (boolean[])new boolean[]{true, true});
        Assert.assertTrue((boolean)Arrays.equals(new boolean[]{false}, array));
        Assert.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((boolean[])new boolean[]{true, false, true}, (boolean[])new boolean[]{true, false});
        Assert.assertTrue((boolean)Arrays.equals(new boolean[]{true}, array));
        Assert.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((boolean[])new boolean[]{true, false, true}, (boolean[])new boolean[]{true, true});
        Assert.assertTrue((boolean)Arrays.equals(new boolean[]{false}, array));
        Assert.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((boolean[])new boolean[]{true, false, true}, (boolean[])new boolean[]{true, true, true, true});
        Assert.assertTrue((boolean)Arrays.equals(new boolean[]{false}, array));
        Assert.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
    }

    @Test
    public void testRemoveElementByteArray() {
        byte[] array = ArrayUtils.removeElements((byte[])null, (byte[])new byte[]{1});
        Assert.assertNull((Object)array);
        array = ArrayUtils.removeElements((byte[])ArrayUtils.EMPTY_BYTE_ARRAY, (byte[])new byte[]{1});
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_BYTE_ARRAY, array));
        Assert.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((byte[])new byte[]{1}, (byte[])new byte[]{1});
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_BYTE_ARRAY, array));
        Assert.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((byte[])new byte[]{1, 2}, (byte[])new byte[]{1});
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{2}, array));
        Assert.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((byte[])new byte[]{1, 2, 1}, (byte[])new byte[]{1});
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{2, 1}, array));
        Assert.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((byte[])null, (byte[])new byte[]{1, 2});
        Assert.assertNull((Object)array);
        array = ArrayUtils.removeElements((byte[])ArrayUtils.EMPTY_BYTE_ARRAY, (byte[])new byte[]{1, 2});
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_BYTE_ARRAY, array));
        Assert.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((byte[])new byte[]{1}, (byte[])new byte[]{1, 2});
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_BYTE_ARRAY, array));
        Assert.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((byte[])new byte[]{1, 2}, (byte[])new byte[]{1, 2});
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_BYTE_ARRAY, array));
        Assert.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((byte[])new byte[]{1, 2}, (byte[])new byte[]{1, 1});
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{2}, array));
        Assert.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((byte[])new byte[]{1, 2, 1}, (byte[])new byte[]{1, 2});
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{1}, array));
        Assert.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((byte[])new byte[]{1, 2, 1}, (byte[])new byte[]{1, 1});
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{2}, array));
        Assert.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((byte[])new byte[]{1, 2, 1}, (byte[])new byte[]{1, 1, 1, 1});
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{2}, array));
        Assert.assertEquals(Byte.TYPE, array.getClass().getComponentType());
    }

    @Test
    public void testRemoveElementCharArray() {
        char[] array = ArrayUtils.removeElements((char[])null, (char[])new char[]{'a'});
        Assert.assertNull((Object)array);
        array = ArrayUtils.removeElements((char[])ArrayUtils.EMPTY_CHAR_ARRAY, (char[])new char[]{'a'});
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_CHAR_ARRAY, array));
        Assert.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((char[])new char[]{'a'}, (char[])new char[]{'a'});
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_CHAR_ARRAY, array));
        Assert.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((char[])new char[]{'a', 'b'}, (char[])new char[]{'a'});
        Assert.assertTrue((boolean)Arrays.equals(new char[]{'b'}, array));
        Assert.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((char[])new char[]{'a', 'b', 'a'}, (char[])new char[]{'a'});
        Assert.assertTrue((boolean)Arrays.equals(new char[]{'b', 'a'}, array));
        Assert.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((char[])null, (char[])new char[]{'a', 'b'});
        Assert.assertNull((Object)array);
        array = ArrayUtils.removeElements((char[])ArrayUtils.EMPTY_CHAR_ARRAY, (char[])new char[]{'a', 'b'});
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_CHAR_ARRAY, array));
        Assert.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((char[])new char[]{'a'}, (char[])new char[]{'a', 'b'});
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_CHAR_ARRAY, array));
        Assert.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((char[])new char[]{'a', 'b'}, (char[])new char[]{'a', 'b'});
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_CHAR_ARRAY, array));
        Assert.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((char[])new char[]{'a', 'b'}, (char[])new char[]{'a', 'a'});
        Assert.assertTrue((boolean)Arrays.equals(new char[]{'b'}, array));
        Assert.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((char[])new char[]{'a', 'b', 'a'}, (char[])new char[]{'a', 'b'});
        Assert.assertTrue((boolean)Arrays.equals(new char[]{'a'}, array));
        Assert.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((char[])new char[]{'a', 'b', 'a'}, (char[])new char[]{'a', 'a'});
        Assert.assertTrue((boolean)Arrays.equals(new char[]{'b'}, array));
        Assert.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((char[])new char[]{'a', 'b', 'a'}, (char[])new char[]{'a', 'a', 'a', 'a'});
        Assert.assertTrue((boolean)Arrays.equals(new char[]{'b'}, array));
        Assert.assertEquals(Character.TYPE, array.getClass().getComponentType());
    }

    @Test
    public void testRemoveElementDoubleArray() {
        double[] array = ArrayUtils.removeElements((double[])null, (double[])new double[]{1.0});
        Assert.assertNull((Object)array);
        array = ArrayUtils.removeElements((double[])ArrayUtils.EMPTY_DOUBLE_ARRAY, (double[])new double[]{1.0});
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_DOUBLE_ARRAY, array));
        Assert.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((double[])new double[]{1.0}, (double[])new double[]{1.0});
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_DOUBLE_ARRAY, array));
        Assert.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((double[])new double[]{1.0, 2.0}, (double[])new double[]{1.0});
        Assert.assertTrue((boolean)Arrays.equals(new double[]{2.0}, array));
        Assert.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((double[])new double[]{1.0, 2.0, 1.0}, (double[])new double[]{1.0});
        Assert.assertTrue((boolean)Arrays.equals(new double[]{2.0, 1.0}, array));
        Assert.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((double[])null, (double[])new double[]{1.0, 2.0});
        Assert.assertNull((Object)array);
        array = ArrayUtils.removeElements((double[])ArrayUtils.EMPTY_DOUBLE_ARRAY, (double[])new double[]{1.0, 2.0});
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_DOUBLE_ARRAY, array));
        Assert.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((double[])new double[]{1.0}, (double[])new double[]{1.0, 2.0});
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_DOUBLE_ARRAY, array));
        Assert.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((double[])new double[]{1.0, 2.0}, (double[])new double[]{1.0, 2.0});
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_DOUBLE_ARRAY, array));
        Assert.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((double[])new double[]{1.0, 2.0}, (double[])new double[]{1.0, 1.0});
        Assert.assertTrue((boolean)Arrays.equals(new double[]{2.0}, array));
        Assert.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((double[])new double[]{1.0, 2.0, 1.0}, (double[])new double[]{1.0, 2.0});
        Assert.assertTrue((boolean)Arrays.equals(new double[]{1.0}, array));
        Assert.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((double[])new double[]{1.0, 2.0, 1.0}, (double[])new double[]{1.0, 1.0});
        Assert.assertTrue((boolean)Arrays.equals(new double[]{2.0}, array));
        Assert.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((double[])new double[]{1.0, 2.0, 1.0}, (double[])new double[]{1.0, 1.0, 1.0, 1.0});
        Assert.assertTrue((boolean)Arrays.equals(new double[]{2.0}, array));
        Assert.assertEquals(Double.TYPE, array.getClass().getComponentType());
    }

    @Test
    public void testRemoveElementFloatArray() {
        float[] array = ArrayUtils.removeElements((float[])null, (float[])new float[]{1.0f});
        Assert.assertNull((Object)array);
        array = ArrayUtils.removeElements((float[])ArrayUtils.EMPTY_FLOAT_ARRAY, (float[])new float[]{1.0f});
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_FLOAT_ARRAY, array));
        Assert.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((float[])new float[]{1.0f}, (float[])new float[]{1.0f});
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_FLOAT_ARRAY, array));
        Assert.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((float[])new float[]{1.0f, 2.0f}, (float[])new float[]{1.0f});
        Assert.assertTrue((boolean)Arrays.equals(new float[]{2.0f}, array));
        Assert.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((float[])new float[]{1.0f, 2.0f, 1.0f}, (float[])new float[]{1.0f});
        Assert.assertTrue((boolean)Arrays.equals(new float[]{2.0f, 1.0f}, array));
        Assert.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((float[])null, (float[])new float[]{1.0f, 1.0f});
        Assert.assertNull((Object)array);
        array = ArrayUtils.removeElements((float[])ArrayUtils.EMPTY_FLOAT_ARRAY, (float[])new float[]{1.0f, 1.0f});
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_FLOAT_ARRAY, array));
        Assert.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((float[])new float[]{1.0f}, (float[])new float[]{1.0f, 1.0f});
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_FLOAT_ARRAY, array));
        Assert.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((float[])new float[]{1.0f, 2.0f}, (float[])new float[]{1.0f, 2.0f});
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_FLOAT_ARRAY, array));
        Assert.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((float[])new float[]{1.0f, 2.0f}, (float[])new float[]{1.0f, 1.0f});
        Assert.assertTrue((boolean)Arrays.equals(new float[]{2.0f}, array));
        Assert.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((float[])new float[]{1.0f, 2.0f, 1.0f}, (float[])new float[]{1.0f, 1.0f});
        Assert.assertTrue((boolean)Arrays.equals(new float[]{2.0f}, array));
        Assert.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((float[])new float[]{1.0f, 2.0f, 1.0f}, (float[])new float[]{1.0f, 2.0f});
        Assert.assertTrue((boolean)Arrays.equals(new float[]{1.0f}, array));
        Assert.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((float[])new float[]{1.0f, 2.0f, 1.0f}, (float[])new float[]{1.0f, 1.0f, 1.0f, 1.0f});
        Assert.assertTrue((boolean)Arrays.equals(new float[]{2.0f}, array));
        Assert.assertEquals(Float.TYPE, array.getClass().getComponentType());
    }

    @Test
    public void testRemoveElementIntArray() {
        int[] array = ArrayUtils.removeElements((int[])null, (int[])new int[]{1});
        Assert.assertNull((Object)array);
        array = ArrayUtils.removeElements((int[])ArrayUtils.EMPTY_INT_ARRAY, (int[])new int[]{1});
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_INT_ARRAY, array));
        Assert.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((int[])new int[]{1}, (int[])new int[]{1});
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_INT_ARRAY, array));
        Assert.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((int[])new int[]{1, 2}, (int[])new int[]{1});
        Assert.assertTrue((boolean)Arrays.equals(new int[]{2}, array));
        Assert.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((int[])new int[]{1, 2, 1}, (int[])new int[]{1});
        Assert.assertTrue((boolean)Arrays.equals(new int[]{2, 1}, array));
        Assert.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((int[])null, (int[])new int[]{1});
        Assert.assertNull((Object)array);
        array = ArrayUtils.removeElements((int[])ArrayUtils.EMPTY_INT_ARRAY, (int[])new int[]{1, 1});
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_INT_ARRAY, array));
        Assert.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((int[])new int[]{1}, (int[])new int[]{1, 1});
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_INT_ARRAY, array));
        Assert.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((int[])new int[]{1, 2}, (int[])new int[]{1, 2});
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_INT_ARRAY, array));
        Assert.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((int[])new int[]{1, 2}, (int[])new int[]{1, 1});
        Assert.assertTrue((boolean)Arrays.equals(new int[]{2}, array));
        Assert.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((int[])new int[]{1, 2, 1}, (int[])new int[]{1, 2});
        Assert.assertTrue((boolean)Arrays.equals(new int[]{1}, array));
        Assert.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((int[])new int[]{1, 2, 1}, (int[])new int[]{1, 1});
        Assert.assertTrue((boolean)Arrays.equals(new int[]{2}, array));
        Assert.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((int[])new int[]{1, 2, 1}, (int[])new int[]{1, 1, 1, 1});
        Assert.assertTrue((boolean)Arrays.equals(new int[]{2}, array));
        Assert.assertEquals(Integer.TYPE, array.getClass().getComponentType());
    }

    @Test
    public void testRemoveElementLongArray() {
        long[] array = ArrayUtils.removeElements((long[])null, (long[])new long[]{1L});
        Assert.assertNull((Object)array);
        array = ArrayUtils.removeElements((long[])ArrayUtils.EMPTY_LONG_ARRAY, (long[])new long[]{1L});
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_LONG_ARRAY, array));
        Assert.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((long[])new long[]{1L}, (long[])new long[]{1L});
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_LONG_ARRAY, array));
        Assert.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((long[])new long[]{1L, 2L}, (long[])new long[]{1L});
        Assert.assertTrue((boolean)Arrays.equals(new long[]{2L}, array));
        Assert.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((long[])new long[]{1L, 2L, 1L}, (long[])new long[]{1L});
        Assert.assertTrue((boolean)Arrays.equals(new long[]{2L, 1L}, array));
        Assert.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((long[])null, (long[])new long[]{1L, 1L});
        Assert.assertNull((Object)array);
        array = ArrayUtils.removeElements((long[])ArrayUtils.EMPTY_LONG_ARRAY, (long[])new long[]{1L, 1L});
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_LONG_ARRAY, array));
        Assert.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((long[])new long[]{1L}, (long[])new long[]{1L, 1L});
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_LONG_ARRAY, array));
        Assert.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((long[])new long[]{1L, 2L}, (long[])new long[]{1L, 2L});
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_LONG_ARRAY, array));
        Assert.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((long[])new long[]{1L, 2L}, (long[])new long[]{1L, 1L});
        Assert.assertTrue((boolean)Arrays.equals(new long[]{2L}, array));
        Assert.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((long[])new long[]{1L, 2L, 1L}, (long[])new long[]{1L, 1L});
        Assert.assertTrue((boolean)Arrays.equals(new long[]{2L}, array));
        Assert.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((long[])new long[]{1L, 2L, 1L}, (long[])new long[]{1L, 2L});
        Assert.assertTrue((boolean)Arrays.equals(new long[]{1L}, array));
        Assert.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((long[])new long[]{1L, 2L, 1L}, (long[])new long[]{1L, 1L, 1L, 1L});
        Assert.assertTrue((boolean)Arrays.equals(new long[]{2L}, array));
        Assert.assertEquals(Long.TYPE, array.getClass().getComponentType());
    }

    @Test
    public void testRemoveElementShortArray() {
        short[] array = ArrayUtils.removeElements((short[])null, (short[])new short[]{1});
        Assert.assertNull((Object)array);
        array = ArrayUtils.removeElements((short[])ArrayUtils.EMPTY_SHORT_ARRAY, (short[])new short[]{1});
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_SHORT_ARRAY, array));
        Assert.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((short[])new short[]{1}, (short[])new short[]{1});
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_SHORT_ARRAY, array));
        Assert.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((short[])new short[]{1, 2}, (short[])new short[]{1});
        Assert.assertTrue((boolean)Arrays.equals(new short[]{2}, array));
        Assert.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((short[])new short[]{1, 2, 1}, (short[])new short[]{1});
        Assert.assertTrue((boolean)Arrays.equals(new short[]{2, 1}, array));
        Assert.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((short[])null, (short[])new short[]{1, 1});
        Assert.assertNull((Object)array);
        array = ArrayUtils.removeElements((short[])ArrayUtils.EMPTY_SHORT_ARRAY, (short[])new short[]{1, 1});
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_SHORT_ARRAY, array));
        Assert.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((short[])new short[]{1}, (short[])new short[]{1, 1});
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_SHORT_ARRAY, array));
        Assert.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((short[])new short[]{1, 2}, (short[])new short[]{1, 2});
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_SHORT_ARRAY, array));
        Assert.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((short[])new short[]{1, 2}, (short[])new short[]{1, 1});
        Assert.assertTrue((boolean)Arrays.equals(new short[]{2}, array));
        Assert.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((short[])new short[]{1, 2, 1}, (short[])new short[]{1, 1});
        Assert.assertTrue((boolean)Arrays.equals(new short[]{2}, array));
        Assert.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((short[])new short[]{1, 2, 1}, (short[])new short[]{1, 2});
        Assert.assertTrue((boolean)Arrays.equals(new short[]{1}, array));
        Assert.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((short[])new short[]{1, 2, 1}, (short[])new short[]{1, 1, 1, 1});
        Assert.assertTrue((boolean)Arrays.equals(new short[]{2}, array));
        Assert.assertEquals(Short.TYPE, array.getClass().getComponentType());
    }
}

