/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.Arrays;
import junit.framework.TestCase;
import org.apache.commons.lang3.ArrayUtils;

public class ArrayUtilsRemoveTest
extends TestCase {
    public void testRemoveObjectArray() {
        Object[] array = ArrayUtils.remove((Object[])new Object[]{"a"}, (int)0);
        ArrayUtilsRemoveTest.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_OBJECT_ARRAY, array));
        ArrayUtilsRemoveTest.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.remove((Object[])new Object[]{"a", "b"}, (int)0);
        ArrayUtilsRemoveTest.assertTrue((boolean)Arrays.equals(new Object[]{"b"}, array));
        ArrayUtilsRemoveTest.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.remove((Object[])new Object[]{"a", "b"}, (int)1);
        ArrayUtilsRemoveTest.assertTrue((boolean)Arrays.equals(new Object[]{"a"}, array));
        ArrayUtilsRemoveTest.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.remove((Object[])new Object[]{"a", "b", "c"}, (int)1);
        ArrayUtilsRemoveTest.assertTrue((boolean)Arrays.equals(new Object[]{"a", "c"}, array));
        ArrayUtilsRemoveTest.assertEquals(Object.class, array.getClass().getComponentType());
        try {
            ArrayUtils.remove((Object[])new Object[]{"a", "b"}, (int)-1);
            ArrayUtilsRemoveTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            ArrayUtils.remove((Object[])new Object[]{"a", "b"}, (int)2);
            ArrayUtilsRemoveTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            ArrayUtils.remove((Object[])null, (int)0);
            ArrayUtilsRemoveTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testRemoveNumberArray() {
        Object[] inarray = new Number[]{1, 2L, (byte)3};
        ArrayUtilsRemoveTest.assertEquals((int)3, (int)inarray.length);
        Object[] outarray = (Number[])ArrayUtils.remove((Object[])inarray, (int)1);
        ArrayUtilsRemoveTest.assertEquals((int)2, (int)outarray.length);
        ArrayUtilsRemoveTest.assertEquals(Number.class, outarray.getClass().getComponentType());
        outarray = (Number[])ArrayUtils.remove((Object[])outarray, (int)1);
        ArrayUtilsRemoveTest.assertEquals((int)1, (int)outarray.length);
        ArrayUtilsRemoveTest.assertEquals(Number.class, outarray.getClass().getComponentType());
        outarray = (Number[])ArrayUtils.remove((Object[])outarray, (int)0);
        ArrayUtilsRemoveTest.assertEquals((int)0, (int)outarray.length);
        ArrayUtilsRemoveTest.assertEquals(Number.class, outarray.getClass().getComponentType());
    }

    public void testRemoveBooleanArray() {
        boolean[] array = ArrayUtils.remove((boolean[])new boolean[]{true}, (int)0);
        ArrayUtilsRemoveTest.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_BOOLEAN_ARRAY, array));
        ArrayUtilsRemoveTest.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.remove((boolean[])new boolean[]{true, false}, (int)0);
        ArrayUtilsRemoveTest.assertTrue((boolean)Arrays.equals(new boolean[]{false}, array));
        ArrayUtilsRemoveTest.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.remove((boolean[])new boolean[]{true, false}, (int)1);
        ArrayUtilsRemoveTest.assertTrue((boolean)Arrays.equals(new boolean[]{true}, array));
        ArrayUtilsRemoveTest.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.remove((boolean[])new boolean[]{true, false, true}, (int)1);
        ArrayUtilsRemoveTest.assertTrue((boolean)Arrays.equals(new boolean[]{true, true}, array));
        ArrayUtilsRemoveTest.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        try {
            ArrayUtils.remove((boolean[])new boolean[]{true, false}, (int)-1);
            ArrayUtilsRemoveTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            ArrayUtils.remove((boolean[])new boolean[]{true, false}, (int)2);
            ArrayUtilsRemoveTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            ArrayUtils.remove((boolean[])null, (int)0);
            ArrayUtilsRemoveTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testRemoveByteArray() {
        byte[] array = ArrayUtils.remove((byte[])new byte[]{1}, (int)0);
        ArrayUtilsRemoveTest.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_BYTE_ARRAY, array));
        ArrayUtilsRemoveTest.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.remove((byte[])new byte[]{1, 2}, (int)0);
        ArrayUtilsRemoveTest.assertTrue((boolean)Arrays.equals(new byte[]{2}, array));
        ArrayUtilsRemoveTest.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.remove((byte[])new byte[]{1, 2}, (int)1);
        ArrayUtilsRemoveTest.assertTrue((boolean)Arrays.equals(new byte[]{1}, array));
        ArrayUtilsRemoveTest.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.remove((byte[])new byte[]{1, 2, 1}, (int)1);
        ArrayUtilsRemoveTest.assertTrue((boolean)Arrays.equals(new byte[]{1, 1}, array));
        ArrayUtilsRemoveTest.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        try {
            ArrayUtils.remove((byte[])new byte[]{1, 2}, (int)-1);
            ArrayUtilsRemoveTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            ArrayUtils.remove((byte[])new byte[]{1, 2}, (int)2);
            ArrayUtilsRemoveTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            ArrayUtils.remove((byte[])null, (int)0);
            ArrayUtilsRemoveTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testRemoveCharArray() {
        char[] array = ArrayUtils.remove((char[])new char[]{'a'}, (int)0);
        ArrayUtilsRemoveTest.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_CHAR_ARRAY, array));
        ArrayUtilsRemoveTest.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.remove((char[])new char[]{'a', 'b'}, (int)0);
        ArrayUtilsRemoveTest.assertTrue((boolean)Arrays.equals(new char[]{'b'}, array));
        ArrayUtilsRemoveTest.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.remove((char[])new char[]{'a', 'b'}, (int)1);
        ArrayUtilsRemoveTest.assertTrue((boolean)Arrays.equals(new char[]{'a'}, array));
        ArrayUtilsRemoveTest.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.remove((char[])new char[]{'a', 'b', 'c'}, (int)1);
        ArrayUtilsRemoveTest.assertTrue((boolean)Arrays.equals(new char[]{'a', 'c'}, array));
        ArrayUtilsRemoveTest.assertEquals(Character.TYPE, array.getClass().getComponentType());
        try {
            ArrayUtils.remove((char[])new char[]{'a', 'b'}, (int)-1);
            ArrayUtilsRemoveTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            ArrayUtils.remove((char[])new char[]{'a', 'b'}, (int)2);
            ArrayUtilsRemoveTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            ArrayUtils.remove((char[])null, (int)0);
            ArrayUtilsRemoveTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testRemoveDoubleArray() {
        double[] array = ArrayUtils.remove((double[])new double[]{1.0}, (int)0);
        ArrayUtilsRemoveTest.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_DOUBLE_ARRAY, array));
        ArrayUtilsRemoveTest.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.remove((double[])new double[]{1.0, 2.0}, (int)0);
        ArrayUtilsRemoveTest.assertTrue((boolean)Arrays.equals(new double[]{2.0}, array));
        ArrayUtilsRemoveTest.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.remove((double[])new double[]{1.0, 2.0}, (int)1);
        ArrayUtilsRemoveTest.assertTrue((boolean)Arrays.equals(new double[]{1.0}, array));
        ArrayUtilsRemoveTest.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.remove((double[])new double[]{1.0, 2.0, 1.0}, (int)1);
        ArrayUtilsRemoveTest.assertTrue((boolean)Arrays.equals(new double[]{1.0, 1.0}, array));
        ArrayUtilsRemoveTest.assertEquals(Double.TYPE, array.getClass().getComponentType());
        try {
            ArrayUtils.remove((double[])new double[]{1.0, 2.0}, (int)-1);
            ArrayUtilsRemoveTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            ArrayUtils.remove((double[])new double[]{1.0, 2.0}, (int)2);
            ArrayUtilsRemoveTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            ArrayUtils.remove((double[])null, (int)0);
            ArrayUtilsRemoveTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testRemoveFloatArray() {
        float[] array = ArrayUtils.remove((float[])new float[]{1.0f}, (int)0);
        ArrayUtilsRemoveTest.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_FLOAT_ARRAY, array));
        ArrayUtilsRemoveTest.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.remove((float[])new float[]{1.0f, 2.0f}, (int)0);
        ArrayUtilsRemoveTest.assertTrue((boolean)Arrays.equals(new float[]{2.0f}, array));
        ArrayUtilsRemoveTest.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.remove((float[])new float[]{1.0f, 2.0f}, (int)1);
        ArrayUtilsRemoveTest.assertTrue((boolean)Arrays.equals(new float[]{1.0f}, array));
        ArrayUtilsRemoveTest.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.remove((float[])new float[]{1.0f, 2.0f, 1.0f}, (int)1);
        ArrayUtilsRemoveTest.assertTrue((boolean)Arrays.equals(new float[]{1.0f, 1.0f}, array));
        ArrayUtilsRemoveTest.assertEquals(Float.TYPE, array.getClass().getComponentType());
        try {
            ArrayUtils.remove((float[])new float[]{1.0f, 2.0f}, (int)-1);
            ArrayUtilsRemoveTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            ArrayUtils.remove((float[])new float[]{1.0f, 2.0f}, (int)2);
            ArrayUtilsRemoveTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            ArrayUtils.remove((float[])null, (int)0);
            ArrayUtilsRemoveTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testRemoveIntArray() {
        int[] array = ArrayUtils.remove((int[])new int[]{1}, (int)0);
        ArrayUtilsRemoveTest.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_INT_ARRAY, array));
        ArrayUtilsRemoveTest.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.remove((int[])new int[]{1, 2}, (int)0);
        ArrayUtilsRemoveTest.assertTrue((boolean)Arrays.equals(new int[]{2}, array));
        ArrayUtilsRemoveTest.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.remove((int[])new int[]{1, 2}, (int)1);
        ArrayUtilsRemoveTest.assertTrue((boolean)Arrays.equals(new int[]{1}, array));
        ArrayUtilsRemoveTest.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.remove((int[])new int[]{1, 2, 1}, (int)1);
        ArrayUtilsRemoveTest.assertTrue((boolean)Arrays.equals(new int[]{1, 1}, array));
        ArrayUtilsRemoveTest.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        try {
            ArrayUtils.remove((int[])new int[]{1, 2}, (int)-1);
            ArrayUtilsRemoveTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            ArrayUtils.remove((int[])new int[]{1, 2}, (int)2);
            ArrayUtilsRemoveTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            ArrayUtils.remove((int[])null, (int)0);
            ArrayUtilsRemoveTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testRemoveLongArray() {
        long[] array = ArrayUtils.remove((long[])new long[]{1L}, (int)0);
        ArrayUtilsRemoveTest.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_LONG_ARRAY, array));
        ArrayUtilsRemoveTest.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.remove((long[])new long[]{1L, 2L}, (int)0);
        ArrayUtilsRemoveTest.assertTrue((boolean)Arrays.equals(new long[]{2L}, array));
        ArrayUtilsRemoveTest.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.remove((long[])new long[]{1L, 2L}, (int)1);
        ArrayUtilsRemoveTest.assertTrue((boolean)Arrays.equals(new long[]{1L}, array));
        ArrayUtilsRemoveTest.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.remove((long[])new long[]{1L, 2L, 1L}, (int)1);
        ArrayUtilsRemoveTest.assertTrue((boolean)Arrays.equals(new long[]{1L, 1L}, array));
        ArrayUtilsRemoveTest.assertEquals(Long.TYPE, array.getClass().getComponentType());
        try {
            ArrayUtils.remove((long[])new long[]{1L, 2L}, (int)-1);
            ArrayUtilsRemoveTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            ArrayUtils.remove((long[])new long[]{1L, 2L}, (int)2);
            ArrayUtilsRemoveTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            ArrayUtils.remove((long[])null, (int)0);
            ArrayUtilsRemoveTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testRemoveShortArray() {
        short[] array = ArrayUtils.remove((short[])new short[]{1}, (int)0);
        ArrayUtilsRemoveTest.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_SHORT_ARRAY, array));
        ArrayUtilsRemoveTest.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.remove((short[])new short[]{1, 2}, (int)0);
        ArrayUtilsRemoveTest.assertTrue((boolean)Arrays.equals(new short[]{2}, array));
        ArrayUtilsRemoveTest.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.remove((short[])new short[]{1, 2}, (int)1);
        ArrayUtilsRemoveTest.assertTrue((boolean)Arrays.equals(new short[]{1}, array));
        ArrayUtilsRemoveTest.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.remove((short[])new short[]{1, 2, 1}, (int)1);
        ArrayUtilsRemoveTest.assertTrue((boolean)Arrays.equals(new short[]{1, 1}, array));
        ArrayUtilsRemoveTest.assertEquals(Short.TYPE, array.getClass().getComponentType());
        try {
            ArrayUtils.remove((short[])new short[]{1, 2}, (int)-1);
            ArrayUtilsRemoveTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            ArrayUtils.remove((short[])new short[]{1, 2}, (int)2);
            ArrayUtilsRemoveTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            ArrayUtils.remove((short[])null, (int)0);
            ArrayUtilsRemoveTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testRemoveElementObjectArray() {
        Object[] array = ArrayUtils.removeElement((Object[])null, (Object)"a");
        ArrayUtilsRemoveTest.assertNull((Object)array);
        array = ArrayUtils.removeElement((Object[])ArrayUtils.EMPTY_OBJECT_ARRAY, (Object)"a");
        ArrayUtilsRemoveTest.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_OBJECT_ARRAY, array));
        ArrayUtilsRemoveTest.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((Object[])new Object[]{"a"}, (Object)"a");
        ArrayUtilsRemoveTest.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_OBJECT_ARRAY, array));
        ArrayUtilsRemoveTest.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((Object[])new Object[]{"a", "b"}, (Object)"a");
        ArrayUtilsRemoveTest.assertTrue((boolean)Arrays.equals(new Object[]{"b"}, array));
        ArrayUtilsRemoveTest.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((Object[])new Object[]{"a", "b", "a"}, (Object)"a");
        ArrayUtilsRemoveTest.assertTrue((boolean)Arrays.equals(new Object[]{"b", "a"}, array));
        ArrayUtilsRemoveTest.assertEquals(Object.class, array.getClass().getComponentType());
    }

    public void testRemoveElementBooleanArray() {
        boolean[] array = ArrayUtils.removeElement((boolean[])null, (boolean)true);
        ArrayUtilsRemoveTest.assertNull((Object)array);
        array = ArrayUtils.removeElement((boolean[])ArrayUtils.EMPTY_BOOLEAN_ARRAY, (boolean)true);
        ArrayUtilsRemoveTest.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_BOOLEAN_ARRAY, array));
        ArrayUtilsRemoveTest.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((boolean[])new boolean[]{true}, (boolean)true);
        ArrayUtilsRemoveTest.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_BOOLEAN_ARRAY, array));
        ArrayUtilsRemoveTest.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((boolean[])new boolean[]{true, false}, (boolean)true);
        ArrayUtilsRemoveTest.assertTrue((boolean)Arrays.equals(new boolean[]{false}, array));
        ArrayUtilsRemoveTest.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((boolean[])new boolean[]{true, false, true}, (boolean)true);
        ArrayUtilsRemoveTest.assertTrue((boolean)Arrays.equals(new boolean[]{false, true}, array));
        ArrayUtilsRemoveTest.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
    }

    public void testRemoveElementByteArray() {
        byte[] array = ArrayUtils.removeElement((byte[])null, (byte)1);
        ArrayUtilsRemoveTest.assertNull((Object)array);
        array = ArrayUtils.removeElement((byte[])ArrayUtils.EMPTY_BYTE_ARRAY, (byte)1);
        ArrayUtilsRemoveTest.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_BYTE_ARRAY, array));
        ArrayUtilsRemoveTest.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((byte[])new byte[]{1}, (byte)1);
        ArrayUtilsRemoveTest.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_BYTE_ARRAY, array));
        ArrayUtilsRemoveTest.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((byte[])new byte[]{1, 2}, (byte)1);
        ArrayUtilsRemoveTest.assertTrue((boolean)Arrays.equals(new byte[]{2}, array));
        ArrayUtilsRemoveTest.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((byte[])new byte[]{1, 2, 1}, (byte)1);
        ArrayUtilsRemoveTest.assertTrue((boolean)Arrays.equals(new byte[]{2, 1}, array));
        ArrayUtilsRemoveTest.assertEquals(Byte.TYPE, array.getClass().getComponentType());
    }

    public void testRemoveElementCharArray() {
        char[] array = ArrayUtils.removeElement((char[])null, (char)'a');
        ArrayUtilsRemoveTest.assertNull((Object)array);
        array = ArrayUtils.removeElement((char[])ArrayUtils.EMPTY_CHAR_ARRAY, (char)'a');
        ArrayUtilsRemoveTest.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_CHAR_ARRAY, array));
        ArrayUtilsRemoveTest.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((char[])new char[]{'a'}, (char)'a');
        ArrayUtilsRemoveTest.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_CHAR_ARRAY, array));
        ArrayUtilsRemoveTest.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((char[])new char[]{'a', 'b'}, (char)'a');
        ArrayUtilsRemoveTest.assertTrue((boolean)Arrays.equals(new char[]{'b'}, array));
        ArrayUtilsRemoveTest.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((char[])new char[]{'a', 'b', 'a'}, (char)'a');
        ArrayUtilsRemoveTest.assertTrue((boolean)Arrays.equals(new char[]{'b', 'a'}, array));
        ArrayUtilsRemoveTest.assertEquals(Character.TYPE, array.getClass().getComponentType());
    }

    public void testRemoveElementDoubleArray() {
        double[] array = ArrayUtils.removeElement((double[])null, (double)1.0);
        ArrayUtilsRemoveTest.assertNull((Object)array);
        array = ArrayUtils.removeElement((double[])ArrayUtils.EMPTY_DOUBLE_ARRAY, (double)1.0);
        ArrayUtilsRemoveTest.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_DOUBLE_ARRAY, array));
        ArrayUtilsRemoveTest.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((double[])new double[]{1.0}, (double)1.0);
        ArrayUtilsRemoveTest.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_DOUBLE_ARRAY, array));
        ArrayUtilsRemoveTest.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((double[])new double[]{1.0, 2.0}, (double)1.0);
        ArrayUtilsRemoveTest.assertTrue((boolean)Arrays.equals(new double[]{2.0}, array));
        ArrayUtilsRemoveTest.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((double[])new double[]{1.0, 2.0, 1.0}, (double)1.0);
        ArrayUtilsRemoveTest.assertTrue((boolean)Arrays.equals(new double[]{2.0, 1.0}, array));
        ArrayUtilsRemoveTest.assertEquals(Double.TYPE, array.getClass().getComponentType());
    }

    public void testRemoveElementFloatArray() {
        float[] array = ArrayUtils.removeElement((float[])null, (float)1.0f);
        ArrayUtilsRemoveTest.assertNull((Object)array);
        array = ArrayUtils.removeElement((float[])ArrayUtils.EMPTY_FLOAT_ARRAY, (float)1.0f);
        ArrayUtilsRemoveTest.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_FLOAT_ARRAY, array));
        ArrayUtilsRemoveTest.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((float[])new float[]{1.0f}, (float)1.0f);
        ArrayUtilsRemoveTest.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_FLOAT_ARRAY, array));
        ArrayUtilsRemoveTest.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((float[])new float[]{1.0f, 2.0f}, (float)1.0f);
        ArrayUtilsRemoveTest.assertTrue((boolean)Arrays.equals(new float[]{2.0f}, array));
        ArrayUtilsRemoveTest.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((float[])new float[]{1.0f, 2.0f, 1.0f}, (float)1.0f);
        ArrayUtilsRemoveTest.assertTrue((boolean)Arrays.equals(new float[]{2.0f, 1.0f}, array));
        ArrayUtilsRemoveTest.assertEquals(Float.TYPE, array.getClass().getComponentType());
    }

    public void testRemoveElementIntArray() {
        int[] array = ArrayUtils.removeElement((int[])null, (int)1);
        ArrayUtilsRemoveTest.assertNull((Object)array);
        array = ArrayUtils.removeElement((int[])ArrayUtils.EMPTY_INT_ARRAY, (int)1);
        ArrayUtilsRemoveTest.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_INT_ARRAY, array));
        ArrayUtilsRemoveTest.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((int[])new int[]{1}, (int)1);
        ArrayUtilsRemoveTest.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_INT_ARRAY, array));
        ArrayUtilsRemoveTest.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((int[])new int[]{1, 2}, (int)1);
        ArrayUtilsRemoveTest.assertTrue((boolean)Arrays.equals(new int[]{2}, array));
        ArrayUtilsRemoveTest.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((int[])new int[]{1, 2, 1}, (int)1);
        ArrayUtilsRemoveTest.assertTrue((boolean)Arrays.equals(new int[]{2, 1}, array));
        ArrayUtilsRemoveTest.assertEquals(Integer.TYPE, array.getClass().getComponentType());
    }

    public void testRemoveElementLongArray() {
        long[] array = ArrayUtils.removeElement((long[])null, (long)1L);
        ArrayUtilsRemoveTest.assertNull((Object)array);
        array = ArrayUtils.removeElement((long[])ArrayUtils.EMPTY_LONG_ARRAY, (long)1L);
        ArrayUtilsRemoveTest.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_LONG_ARRAY, array));
        ArrayUtilsRemoveTest.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((long[])new long[]{1L}, (long)1L);
        ArrayUtilsRemoveTest.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_LONG_ARRAY, array));
        ArrayUtilsRemoveTest.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((long[])new long[]{1L, 2L}, (long)1L);
        ArrayUtilsRemoveTest.assertTrue((boolean)Arrays.equals(new long[]{2L}, array));
        ArrayUtilsRemoveTest.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((long[])new long[]{1L, 2L, 1L}, (long)1L);
        ArrayUtilsRemoveTest.assertTrue((boolean)Arrays.equals(new long[]{2L, 1L}, array));
        ArrayUtilsRemoveTest.assertEquals(Long.TYPE, array.getClass().getComponentType());
    }

    public void testRemoveElementShortArray() {
        short[] array = ArrayUtils.removeElement((short[])null, (short)1);
        ArrayUtilsRemoveTest.assertNull((Object)array);
        array = ArrayUtils.removeElement((short[])ArrayUtils.EMPTY_SHORT_ARRAY, (short)1);
        ArrayUtilsRemoveTest.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_SHORT_ARRAY, array));
        ArrayUtilsRemoveTest.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((short[])new short[]{1}, (short)1);
        ArrayUtilsRemoveTest.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_SHORT_ARRAY, array));
        ArrayUtilsRemoveTest.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((short[])new short[]{1, 2}, (short)1);
        ArrayUtilsRemoveTest.assertTrue((boolean)Arrays.equals(new short[]{2}, array));
        ArrayUtilsRemoveTest.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((short[])new short[]{1, 2, 1}, (short)1);
        ArrayUtilsRemoveTest.assertTrue((boolean)Arrays.equals(new short[]{2, 1}, array));
        ArrayUtilsRemoveTest.assertEquals(Short.TYPE, array.getClass().getComponentType());
    }
}

