/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.text.NumberFormat;
import java.util.Calendar;
import org.apache.commons.lang3.CharSet;
import org.apache.commons.lang3.CharUtils;

public class CharUtilsPerfRun {
    static final String VERSION = "$Id: CharUtilsPerfRun.java 1144929 2011-07-10 18:26:16Z ggregory $";
    static final int WARM_UP = 100;
    static final int COUNT = 5000;
    static final char[] CHAR_SAMPLES = new char[65535];

    public static void main(String[] args) {
        new CharUtilsPerfRun().run();
    }

    private void printSysInfo() {
        System.out.println(VERSION);
        System.out.println("Now: " + Calendar.getInstance().getTime());
        System.out.println(System.getProperty("java.vendor") + " " + System.getProperty("java.runtime.name") + " " + System.getProperty("java.runtime.version"));
        System.out.println(System.getProperty("java.vm.vendor") + " " + System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version"));
        System.out.println(System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch") + " " + System.getProperty("sun.cpu.isalist"));
    }

    private void run() {
        this.printSysInfo();
        long start = System.currentTimeMillis();
        this.printlnTotal("Do nohting", start);
        this.run_CharUtils_isAsciiNumeric(100);
        start = System.currentTimeMillis();
        this.run_CharUtils_isAsciiNumeric(5000);
        this.printlnTotal("run_CharUtils_isAsciiNumeric", start);
        this.run_inlined_CharUtils_isAsciiNumeric(100);
        start = System.currentTimeMillis();
        this.run_inlined_CharUtils_isAsciiNumeric(5000);
        this.printlnTotal("run_inlined_CharUtils_isAsciiNumeric", start);
        this.run_CharSet(100);
        start = System.currentTimeMillis();
        this.run_CharSet(5000);
        this.printlnTotal("run_CharSet", start);
    }

    private int run_CharSet(int loopCount) {
        int t = 0;
        for (int i = 0; i < loopCount; ++i) {
            for (char ch : CHAR_SAMPLES) {
                boolean b = CharSet.ASCII_NUMERIC.contains(ch);
                t += b ? 1 : 0;
            }
        }
        return t;
    }

    private int run_CharUtils_isAsciiNumeric(int loopCount) {
        int t = 0;
        for (int i = 0; i < loopCount; ++i) {
            for (char ch : CHAR_SAMPLES) {
                boolean b = CharUtils.isAsciiNumeric((char)ch);
                t += b ? 1 : 0;
            }
        }
        return t;
    }

    private int run_inlined_CharUtils_isAsciiNumeric(int loopCount) {
        int t = 0;
        for (int i = 0; i < loopCount; ++i) {
            for (char ch : CHAR_SAMPLES) {
                boolean b = ch >= '0' && ch <= '9';
                t += b ? 1 : 0;
            }
        }
        return t;
    }

    private void printlnTotal(String prefix, long start) {
        long total = System.currentTimeMillis() - start;
        System.out.println(prefix + ": " + NumberFormat.getInstance().format(total) + " milliseconds.");
    }

    static {
        for (int i = 0; i < 65535; i = (int)((char)(i + 1))) {
            CharUtilsPerfRun.CHAR_SAMPLES[i] = i;
        }
    }
}

