/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.text.translate.CharSequenceTranslator;
import org.apache.commons.lang3.text.translate.NumericEntityEscaper;
import org.junit.Assert;
import org.junit.Test;

public class StringEscapeUtilsTest {
    private static final String FOO = "foo";
    private static final String[][] HTML_ESCAPES = new String[][]{{"no escaping", "plain text", "plain text"}, {"no escaping", "plain text", "plain text"}, {"empty string", "", ""}, {"null", null, null}, {"ampersand", "bread &amp; butter", "bread & butter"}, {"quotes", "&quot;bread&quot; &amp; butter", "\"bread\" & butter"}, {"final character only", "greater than &gt;", "greater than >"}, {"first character only", "&lt; less than", "< less than"}, {"apostrophe", "Huntington's chorea", "Huntington's chorea"}, {"languages", "English,Fran&ccedil;ais,\u65e5\u672c\u8a9e (nihongo)", "English,Fran\u00e7ais,\u65e5\u672c\u8a9e (nihongo)"}, {"8-bit ascii shouldn't number-escape", "\u0080\u009f", "\u0080\u009f"}};

    @Test
    public void testConstructor() {
        Assert.assertNotNull((Object)new StringEscapeUtils());
        Constructor<?>[] cons = StringEscapeUtils.class.getDeclaredConstructors();
        Assert.assertEquals((long)1L, (long)cons.length);
        Assert.assertEquals((Object)true, (Object)Modifier.isPublic(cons[0].getModifiers()));
        Assert.assertEquals((Object)true, (Object)Modifier.isPublic(StringEscapeUtils.class.getModifiers()));
        Assert.assertEquals((Object)false, (Object)Modifier.isFinal(StringEscapeUtils.class.getModifiers()));
    }

    @Test
    public void testEscapeJava() throws IOException {
        Assert.assertEquals(null, (Object)StringEscapeUtils.escapeJava(null));
        try {
            StringEscapeUtils.ESCAPE_JAVA.translate(null, null);
            Assert.fail();
        }
        catch (IOException ex) {
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            StringEscapeUtils.ESCAPE_JAVA.translate((CharSequence)"", null);
            Assert.fail();
        }
        catch (IOException ex) {
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.assertEscapeJava("empty string", "", "");
        this.assertEscapeJava(FOO, FOO);
        this.assertEscapeJava("tab", "\\t", "\t");
        this.assertEscapeJava("backslash", "\\\\", "\\");
        this.assertEscapeJava("single quote should not be escaped", "'", "'");
        this.assertEscapeJava("\\\\\\b\\t\\r", "\\\b\t\r");
        this.assertEscapeJava("\\u1234", "\u1234");
        this.assertEscapeJava("\\u0234", "\u0234");
        this.assertEscapeJava("\\u00EF", "\u00ef");
        this.assertEscapeJava("\\u0001", "\u0001");
        this.assertEscapeJava("Should use capitalized Unicode hex", "\\uABCD", "\uabcd");
        this.assertEscapeJava("He didn't say, \\\"stop!\\\"", "He didn't say, \"stop!\"");
        this.assertEscapeJava("non-breaking space", "This space is non-breaking:\\u00A0", "This space is non-breaking:\u00a0");
        this.assertEscapeJava("\\uABCD\\u1234\\u012C", "\uabcd\u1234\u012c");
    }

    @Test
    public void testEscapeJavaWithSlash() {
        String input = "String with a slash (/) in it";
        String expected = "String with a slash (/) in it";
        String actual = StringEscapeUtils.escapeJava((String)"String with a slash (/) in it");
        Assert.assertEquals((Object)"String with a slash (/) in it", (Object)actual);
    }

    private void assertEscapeJava(String escaped, String original) throws IOException {
        this.assertEscapeJava(null, escaped, original);
    }

    private void assertEscapeJava(String message, String expected, String original) throws IOException {
        String converted = StringEscapeUtils.escapeJava((String)original);
        message = "escapeJava(String) failed" + (message == null ? "" : ": " + message);
        Assert.assertEquals((String)message, (Object)expected, (Object)converted);
        StringWriter writer = new StringWriter();
        StringEscapeUtils.ESCAPE_JAVA.translate((CharSequence)original, (Writer)writer);
        Assert.assertEquals((Object)expected, (Object)writer.toString());
    }

    @Test
    public void testUnescapeJava() throws IOException {
        Assert.assertEquals(null, (Object)StringEscapeUtils.unescapeJava(null));
        try {
            StringEscapeUtils.UNESCAPE_JAVA.translate(null, null);
            Assert.fail();
        }
        catch (IOException ex) {
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            StringEscapeUtils.UNESCAPE_JAVA.translate((CharSequence)"", null);
            Assert.fail();
        }
        catch (IOException ex) {
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            StringEscapeUtils.unescapeJava((String)"\\u02-3");
            Assert.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.assertUnescapeJava("", "");
        this.assertUnescapeJava("test", "test");
        this.assertUnescapeJava("\ntest\b", "\\ntest\\b");
        this.assertUnescapeJava("\u123425foo\ntest\b", "\\u123425foo\\ntest\\b");
        this.assertUnescapeJava("'\foo\teste\r", "\\'\\foo\\teste\\r");
        this.assertUnescapeJava("", "\\");
        this.assertUnescapeJava("lowercase Unicode", "\uabcdx", "\\uabcdx");
        this.assertUnescapeJava("uppercase Unicode", "\uabcdx", "\\uABCDx");
        this.assertUnescapeJava("Unicode as final character", "\uabcd", "\\uabcd");
    }

    private void assertUnescapeJava(String unescaped, String original) throws IOException {
        this.assertUnescapeJava(null, unescaped, original);
    }

    private void assertUnescapeJava(String message, String unescaped, String original) throws IOException {
        String expected = unescaped;
        String actual = StringEscapeUtils.unescapeJava((String)original);
        Assert.assertEquals((String)("unescape(String) failed" + (message == null ? "" : ": " + message) + ": expected '" + StringEscapeUtils.escapeJava((String)expected) + "' actual '" + StringEscapeUtils.escapeJava((String)actual) + "'"), (Object)expected, (Object)actual);
        StringWriter writer = new StringWriter();
        StringEscapeUtils.UNESCAPE_JAVA.translate((CharSequence)original, (Writer)writer);
        Assert.assertEquals((Object)unescaped, (Object)writer.toString());
    }

    @Test
    public void testEscapeEcmaScript() {
        Assert.assertEquals(null, (Object)StringEscapeUtils.escapeEcmaScript(null));
        try {
            StringEscapeUtils.ESCAPE_ECMASCRIPT.translate(null, null);
            Assert.fail();
        }
        catch (IOException ex) {
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            StringEscapeUtils.ESCAPE_ECMASCRIPT.translate((CharSequence)"", null);
            Assert.fail();
        }
        catch (IOException ex) {
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((Object)"He didn\\'t say, \\\"stop!\\\"", (Object)StringEscapeUtils.escapeEcmaScript((String)"He didn't say, \"stop!\""));
        Assert.assertEquals((Object)"document.getElementById(\\\"test\\\").value = \\'<script>alert(\\'aaa\\');<\\/script>\\';", (Object)StringEscapeUtils.escapeEcmaScript((String)"document.getElementById(\"test\").value = '<script>alert('aaa');</script>';"));
    }

    @Test
    public void testEscapeHtml() {
        for (int i = 0; i < HTML_ESCAPES.length; ++i) {
            String message = HTML_ESCAPES[i][0];
            String expected = HTML_ESCAPES[i][1];
            String original = HTML_ESCAPES[i][2];
            Assert.assertEquals((String)message, (Object)expected, (Object)StringEscapeUtils.escapeHtml4((String)original));
            StringWriter sw = new StringWriter();
            try {
                StringEscapeUtils.ESCAPE_HTML4.translate((CharSequence)original, (Writer)sw);
            }
            catch (IOException e) {
                // empty catch block
            }
            String actual = original == null ? null : sw.toString();
            Assert.assertEquals((String)message, (Object)expected, (Object)actual);
        }
    }

    @Test
    public void testUnescapeHtml4() {
        for (int i = 0; i < HTML_ESCAPES.length; ++i) {
            String message = HTML_ESCAPES[i][0];
            String expected = HTML_ESCAPES[i][2];
            String original = HTML_ESCAPES[i][1];
            Assert.assertEquals((String)message, (Object)expected, (Object)StringEscapeUtils.unescapeHtml4((String)original));
            StringWriter sw = new StringWriter();
            try {
                StringEscapeUtils.UNESCAPE_HTML4.translate((CharSequence)original, (Writer)sw);
            }
            catch (IOException e) {
                // empty catch block
            }
            String actual = original == null ? null : sw.toString();
            Assert.assertEquals((String)message, (Object)expected, (Object)actual);
        }
        Assert.assertEquals((String)"funny chars pass through OK", (Object)"Fran\u00e7ais", (Object)StringEscapeUtils.unescapeHtml4((String)"Fran\u00e7ais"));
        Assert.assertEquals((Object)"Hello&;World", (Object)StringEscapeUtils.unescapeHtml4((String)"Hello&;World"));
        Assert.assertEquals((Object)"Hello&#;World", (Object)StringEscapeUtils.unescapeHtml4((String)"Hello&#;World"));
        Assert.assertEquals((Object)"Hello&# ;World", (Object)StringEscapeUtils.unescapeHtml4((String)"Hello&# ;World"));
        Assert.assertEquals((Object)"Hello&##;World", (Object)StringEscapeUtils.unescapeHtml4((String)"Hello&##;World"));
    }

    @Test
    public void testUnescapeHexCharsHtml() {
        Assert.assertEquals((String)"hex number unescape", (Object)"\u0080\u009f", (Object)StringEscapeUtils.unescapeHtml4((String)"&#x80;&#x9F;"));
        Assert.assertEquals((String)"hex number unescape", (Object)"\u0080\u009f", (Object)StringEscapeUtils.unescapeHtml4((String)"&#X80;&#X9F;"));
        for (char i = '\u0000'; i < '\uffff'; i = (char)(i + '\u0001')) {
            Character c1 = new Character(i);
            Character c2 = new Character((char)(i + '\u0001'));
            String expected = c1.toString() + c2.toString();
            String escapedC1 = "&#x" + Integer.toHexString(c1.charValue()) + ";";
            String escapedC2 = "&#x" + Integer.toHexString(c2.charValue()) + ";";
            Assert.assertEquals((String)("hex number unescape index " + i), (Object)expected, (Object)StringEscapeUtils.unescapeHtml4((String)(escapedC1 + escapedC2)));
        }
    }

    @Test
    public void testUnescapeUnknownEntity() throws Exception {
        Assert.assertEquals((Object)"&zzzz;", (Object)StringEscapeUtils.unescapeHtml4((String)"&zzzz;"));
    }

    @Test
    public void testEscapeHtmlVersions() throws Exception {
        Assert.assertEquals((Object)"&Beta;", (Object)StringEscapeUtils.escapeHtml4((String)"\u0392"));
        Assert.assertEquals((Object)"\u0392", (Object)StringEscapeUtils.unescapeHtml4((String)"&Beta;"));
    }

    @Test
    public void testEscapeXml() throws Exception {
        Assert.assertEquals((Object)"&lt;abc&gt;", (Object)StringEscapeUtils.escapeXml((String)"<abc>"));
        Assert.assertEquals((Object)"<abc>", (Object)StringEscapeUtils.unescapeXml((String)"&lt;abc&gt;"));
        Assert.assertEquals((String)"XML should not escape >0x7f values", (Object)"\u00a1", (Object)StringEscapeUtils.escapeXml((String)"\u00a1"));
        Assert.assertEquals((String)"XML should be able to unescape >0x7f values", (Object)"\u00a0", (Object)StringEscapeUtils.unescapeXml((String)"&#160;"));
        Assert.assertEquals((String)"XML should be able to unescape >0x7f values with one leading 0", (Object)"\u00a0", (Object)StringEscapeUtils.unescapeXml((String)"&#0160;"));
        Assert.assertEquals((String)"XML should be able to unescape >0x7f values with two leading 0s", (Object)"\u00a0", (Object)StringEscapeUtils.unescapeXml((String)"&#00160;"));
        Assert.assertEquals((String)"XML should be able to unescape >0x7f values with three leading 0s", (Object)"\u00a0", (Object)StringEscapeUtils.unescapeXml((String)"&#000160;"));
        Assert.assertEquals((Object)"ain't", (Object)StringEscapeUtils.unescapeXml((String)"ain&apos;t"));
        Assert.assertEquals((Object)"ain&apos;t", (Object)StringEscapeUtils.escapeXml((String)"ain't"));
        Assert.assertEquals((Object)"", (Object)StringEscapeUtils.escapeXml((String)""));
        Assert.assertEquals(null, (Object)StringEscapeUtils.escapeXml(null));
        Assert.assertEquals(null, (Object)StringEscapeUtils.unescapeXml(null));
        StringWriter sw = new StringWriter();
        try {
            StringEscapeUtils.ESCAPE_XML.translate((CharSequence)"<abc>", (Writer)sw);
        }
        catch (IOException e) {
            // empty catch block
        }
        Assert.assertEquals((String)"XML was escaped incorrectly", (Object)"&lt;abc&gt;", (Object)sw.toString());
        sw = new StringWriter();
        try {
            StringEscapeUtils.UNESCAPE_XML.translate((CharSequence)"&lt;abc&gt;", (Writer)sw);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assert.assertEquals((String)"XML was unescaped incorrectly", (Object)"<abc>", (Object)sw.toString());
    }

    @Test
    public void testEscapeXmlSupplementaryCharacters() {
        CharSequenceTranslator escapeXml = StringEscapeUtils.ESCAPE_XML.with(new CharSequenceTranslator[]{NumericEntityEscaper.between((int)127, (int)Integer.MAX_VALUE)});
        Assert.assertEquals((String)"Supplementary character must be represented using a single escape", (Object)"&#144308;", (Object)escapeXml.translate((CharSequence)"\ud84c\udfb4"));
    }

    @Test
    public void testUnescapeXmlSupplementaryCharacters() {
        Assert.assertEquals((String)"Supplementary character must be represented using a single escape", (Object)"\ud84c\udfb4", (Object)StringEscapeUtils.unescapeXml((String)"&#144308;"));
    }

    @Test
    public void testStandaloneAmphersand() {
        Assert.assertEquals((Object)"<P&O>", (Object)StringEscapeUtils.unescapeHtml4((String)"&lt;P&O&gt;"));
        Assert.assertEquals((Object)"test & <", (Object)StringEscapeUtils.unescapeHtml4((String)"test & &lt;"));
        Assert.assertEquals((Object)"<P&O>", (Object)StringEscapeUtils.unescapeXml((String)"&lt;P&O&gt;"));
        Assert.assertEquals((Object)"test & <", (Object)StringEscapeUtils.unescapeXml((String)"test & &lt;"));
    }

    @Test
    public void testLang313() {
        Assert.assertEquals((Object)"& &", (Object)StringEscapeUtils.unescapeHtml4((String)"& &amp;"));
    }

    @Test
    public void testEscapeCsvString() throws Exception {
        Assert.assertEquals((Object)"foo.bar", (Object)StringEscapeUtils.escapeCsv((String)"foo.bar"));
        Assert.assertEquals((Object)"\"foo,bar\"", (Object)StringEscapeUtils.escapeCsv((String)"foo,bar"));
        Assert.assertEquals((Object)"\"foo\nbar\"", (Object)StringEscapeUtils.escapeCsv((String)"foo\nbar"));
        Assert.assertEquals((Object)"\"foo\rbar\"", (Object)StringEscapeUtils.escapeCsv((String)"foo\rbar"));
        Assert.assertEquals((Object)"\"foo\"\"bar\"", (Object)StringEscapeUtils.escapeCsv((String)"foo\"bar"));
        Assert.assertEquals((Object)"", (Object)StringEscapeUtils.escapeCsv((String)""));
        Assert.assertEquals(null, (Object)StringEscapeUtils.escapeCsv(null));
    }

    @Test
    public void testEscapeCsvWriter() throws Exception {
        this.checkCsvEscapeWriter("foo.bar", "foo.bar");
        this.checkCsvEscapeWriter("\"foo,bar\"", "foo,bar");
        this.checkCsvEscapeWriter("\"foo\nbar\"", "foo\nbar");
        this.checkCsvEscapeWriter("\"foo\rbar\"", "foo\rbar");
        this.checkCsvEscapeWriter("\"foo\"\"bar\"", "foo\"bar");
        this.checkCsvEscapeWriter("", null);
        this.checkCsvEscapeWriter("", "");
    }

    private void checkCsvEscapeWriter(String expected, String value) {
        try {
            StringWriter writer = new StringWriter();
            StringEscapeUtils.ESCAPE_CSV.translate((CharSequence)value, (Writer)writer);
            Assert.assertEquals((Object)expected, (Object)writer.toString());
        }
        catch (IOException e) {
            Assert.fail((String)("Threw: " + e));
        }
    }

    @Test
    public void testUnescapeCsvString() throws Exception {
        Assert.assertEquals((Object)"foo.bar", (Object)StringEscapeUtils.unescapeCsv((String)"foo.bar"));
        Assert.assertEquals((Object)"foo,bar", (Object)StringEscapeUtils.unescapeCsv((String)"\"foo,bar\""));
        Assert.assertEquals((Object)"foo\nbar", (Object)StringEscapeUtils.unescapeCsv((String)"\"foo\nbar\""));
        Assert.assertEquals((Object)"foo\rbar", (Object)StringEscapeUtils.unescapeCsv((String)"\"foo\rbar\""));
        Assert.assertEquals((Object)"foo\"bar", (Object)StringEscapeUtils.unescapeCsv((String)"\"foo\"\"bar\""));
        Assert.assertEquals((Object)"", (Object)StringEscapeUtils.unescapeCsv((String)""));
        Assert.assertEquals(null, (Object)StringEscapeUtils.unescapeCsv(null));
        Assert.assertEquals((Object)"\"foo.bar\"", (Object)StringEscapeUtils.unescapeCsv((String)"\"foo.bar\""));
    }

    @Test
    public void testUnescapeCsvWriter() throws Exception {
        this.checkCsvUnescapeWriter("foo.bar", "foo.bar");
        this.checkCsvUnescapeWriter("foo,bar", "\"foo,bar\"");
        this.checkCsvUnescapeWriter("foo\nbar", "\"foo\nbar\"");
        this.checkCsvUnescapeWriter("foo\rbar", "\"foo\rbar\"");
        this.checkCsvUnescapeWriter("foo\"bar", "\"foo\"\"bar\"");
        this.checkCsvUnescapeWriter("", null);
        this.checkCsvUnescapeWriter("", "");
        this.checkCsvUnescapeWriter("\"foo.bar\"", "\"foo.bar\"");
    }

    private void checkCsvUnescapeWriter(String expected, String value) {
        try {
            StringWriter writer = new StringWriter();
            StringEscapeUtils.UNESCAPE_CSV.translate((CharSequence)value, (Writer)writer);
            Assert.assertEquals((Object)expected, (Object)writer.toString());
        }
        catch (IOException e) {
            Assert.fail((String)("Threw: " + e));
        }
    }

    @Test
    public void testEscapeHtmlHighUnicode() throws UnsupportedEncodingException {
        byte[] data = new byte[]{-16, -99, -115, -94};
        String original = new String(data, "UTF8");
        String escaped = StringEscapeUtils.escapeHtml4((String)original);
        Assert.assertEquals((String)"High Unicode should not have been escaped", (Object)original, (Object)escaped);
        String unescaped = StringEscapeUtils.unescapeHtml4((String)escaped);
        Assert.assertEquals((String)"High Unicode should have been unchanged", (Object)original, (Object)unescaped);
    }

    @Test
    public void testEscapeHiragana() {
        String original = "\u304b\u304c\u3068";
        String escaped = StringEscapeUtils.escapeHtml4((String)original);
        Assert.assertEquals((String)"Hiragana character Unicode behaviour should not be being escaped by escapeHtml4", (Object)original, (Object)escaped);
        String unescaped = StringEscapeUtils.unescapeHtml4((String)escaped);
        Assert.assertEquals((String)"Hiragana character Unicode behaviour has changed - expected no unescaping", (Object)escaped, (Object)unescaped);
    }

    @Test
    public void testLang708() throws IOException {
        String input = IOUtils.toString((InputStream)new FileInputStream("src/test/resources/lang-708-input.txt"), (String)"UTF-8");
        String escaped = StringEscapeUtils.escapeEcmaScript((String)input);
        Assert.assertTrue((String)escaped, (boolean)escaped.endsWith("}]"));
        Assert.assertTrue((String)escaped, (boolean)escaped.endsWith("\"valueCode\\\":\\\"\\\"}]"));
    }

    @Test
    public void testLang720() {
        String input = "\ud842\udfb7" + "A";
        String escaped = StringEscapeUtils.escapeXml((String)input);
        Assert.assertEquals((Object)input, (Object)escaped);
    }
}

