/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.Locale;
import junit.framework.TestCase;
import org.apache.commons.lang3.StringUtils;

public class StringUtilsEqualsIndexOfTest
extends TestCase {
    private static final String BAR = "bar";
    private static final String CharU20000 = "\ud840\udc00";
    private static final String CharU20001 = "\ud840\udc01";
    private static final String CharUSuppCharHigh = "\udc00";
    private static final String CharUSuppCharLow = "\ud840";
    private static final String FOO = "foo";
    private static final String FOOBAR = "foobar";
    private static final String[] FOOBAR_SUB_ARRAY = new String[]{"ob", "ba"};

    public StringUtilsEqualsIndexOfTest(String name) {
        super(name);
    }

    public void testContains_Char() {
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)false, (boolean)StringUtils.contains(null, (int)32));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)false, (boolean)StringUtils.contains((CharSequence)"", (int)32));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)false, (boolean)StringUtils.contains((CharSequence)"", null));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)false, (boolean)StringUtils.contains(null, null));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.contains((CharSequence)"abc", (int)97));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.contains((CharSequence)"abc", (int)98));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.contains((CharSequence)"abc", (int)99));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)false, (boolean)StringUtils.contains((CharSequence)"abc", (int)122));
    }

    public void testContains_String() {
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)false, (boolean)StringUtils.contains(null, null));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)false, (boolean)StringUtils.contains(null, (CharSequence)""));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)false, (boolean)StringUtils.contains(null, (CharSequence)"a"));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)false, (boolean)StringUtils.contains((CharSequence)"", null));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.contains((CharSequence)"", (CharSequence)""));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)false, (boolean)StringUtils.contains((CharSequence)"", (CharSequence)"a"));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.contains((CharSequence)"abc", (CharSequence)"a"));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.contains((CharSequence)"abc", (CharSequence)"b"));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.contains((CharSequence)"abc", (CharSequence)"c"));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.contains((CharSequence)"abc", (CharSequence)"abc"));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)false, (boolean)StringUtils.contains((CharSequence)"abc", (CharSequence)"z"));
    }

    public void testContains_StringWithBadSupplementaryChars() {
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)false, (boolean)StringUtils.contains((CharSequence)CharUSuppCharHigh, (CharSequence)CharU20001));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)false, (boolean)StringUtils.contains((CharSequence)CharUSuppCharLow, (CharSequence)CharU20001));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)false, (boolean)StringUtils.contains((CharSequence)CharU20001, (CharSequence)CharUSuppCharHigh));
        StringUtilsEqualsIndexOfTest.assertEquals((int)0, (int)CharU20001.indexOf(CharUSuppCharLow));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.contains((CharSequence)CharU20001, (CharSequence)CharUSuppCharLow));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.contains((CharSequence)"\ud840\udc01\ud840a", (CharSequence)"a"));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.contains((CharSequence)"\ud840\udc01\udc00a", (CharSequence)"a"));
    }

    public void testContains_StringWithSupplementaryChars() {
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.contains((CharSequence)"\ud840\udc00\ud840\udc01", (CharSequence)CharU20000));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.contains((CharSequence)"\ud840\udc00\ud840\udc01", (CharSequence)CharU20001));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.contains((CharSequence)CharU20000, (CharSequence)CharU20000));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)false, (boolean)StringUtils.contains((CharSequence)CharU20000, (CharSequence)CharU20001));
    }

    public void testContainsAny_StringCharArray() {
        StringUtilsEqualsIndexOfTest.assertFalse((boolean)StringUtils.containsAny(null, (char[])null));
        StringUtilsEqualsIndexOfTest.assertFalse((boolean)StringUtils.containsAny(null, (char[])new char[0]));
        StringUtilsEqualsIndexOfTest.assertFalse((boolean)StringUtils.containsAny(null, (char[])new char[]{'a', 'b'}));
        StringUtilsEqualsIndexOfTest.assertFalse((boolean)StringUtils.containsAny((CharSequence)"", (char[])null));
        StringUtilsEqualsIndexOfTest.assertFalse((boolean)StringUtils.containsAny((CharSequence)"", (char[])new char[0]));
        StringUtilsEqualsIndexOfTest.assertFalse((boolean)StringUtils.containsAny((CharSequence)"", (char[])new char[]{'a', 'b'}));
        StringUtilsEqualsIndexOfTest.assertFalse((boolean)StringUtils.containsAny((CharSequence)"zzabyycdxx", (char[])null));
        StringUtilsEqualsIndexOfTest.assertFalse((boolean)StringUtils.containsAny((CharSequence)"zzabyycdxx", (char[])new char[0]));
        StringUtilsEqualsIndexOfTest.assertTrue((boolean)StringUtils.containsAny((CharSequence)"zzabyycdxx", (char[])new char[]{'z', 'a'}));
        StringUtilsEqualsIndexOfTest.assertTrue((boolean)StringUtils.containsAny((CharSequence)"zzabyycdxx", (char[])new char[]{'b', 'y'}));
        StringUtilsEqualsIndexOfTest.assertFalse((boolean)StringUtils.containsAny((CharSequence)"ab", (char[])new char[]{'z'}));
    }

    public void testContainsAny_StringCharArrayWithBadSupplementaryChars() {
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)false, (boolean)StringUtils.containsAny((CharSequence)CharUSuppCharHigh, (char[])CharU20001.toCharArray()));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)false, (boolean)StringUtils.containsAny((CharSequence)"abc\udc00xyz", (char[])CharU20001.toCharArray()));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)CharUSuppCharLow.indexOf(CharU20001));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)false, (boolean)StringUtils.containsAny((CharSequence)CharUSuppCharLow, (char[])CharU20001.toCharArray()));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)false, (boolean)StringUtils.containsAny((CharSequence)CharU20001, (char[])CharUSuppCharHigh.toCharArray()));
        StringUtilsEqualsIndexOfTest.assertEquals((int)0, (int)CharU20001.indexOf(CharUSuppCharLow));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.containsAny((CharSequence)CharU20001, (char[])CharUSuppCharLow.toCharArray()));
    }

    public void testContainsAny_StringCharArrayWithSupplementaryChars() {
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.containsAny((CharSequence)"\ud840\udc00\ud840\udc01", (char[])CharU20000.toCharArray()));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.containsAny((CharSequence)"a\ud840\udc00\ud840\udc01", (char[])"a".toCharArray()));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.containsAny((CharSequence)"\ud840\udc00a\ud840\udc01", (char[])"a".toCharArray()));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.containsAny((CharSequence)"\ud840\udc00\ud840\udc01a", (char[])"a".toCharArray()));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.containsAny((CharSequence)"\ud840\udc00\ud840\udc01", (char[])CharU20001.toCharArray()));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.containsAny((CharSequence)CharU20000, (char[])CharU20000.toCharArray()));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)CharU20000.indexOf(CharU20001));
        StringUtilsEqualsIndexOfTest.assertEquals((int)0, (int)CharU20000.indexOf(CharU20001.charAt(0)));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)CharU20000.indexOf(CharU20001.charAt(1)));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)false, (boolean)StringUtils.containsAny((CharSequence)CharU20000, (char[])CharU20001.toCharArray()));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)false, (boolean)StringUtils.containsAny((CharSequence)CharU20001, (char[])CharU20000.toCharArray()));
    }

    public void testContainsAny_StringString() {
        StringUtilsEqualsIndexOfTest.assertFalse((boolean)StringUtils.containsAny(null, (CharSequence)null));
        StringUtilsEqualsIndexOfTest.assertFalse((boolean)StringUtils.containsAny(null, (CharSequence)""));
        StringUtilsEqualsIndexOfTest.assertFalse((boolean)StringUtils.containsAny(null, (CharSequence)"ab"));
        StringUtilsEqualsIndexOfTest.assertFalse((boolean)StringUtils.containsAny((CharSequence)"", (CharSequence)null));
        StringUtilsEqualsIndexOfTest.assertFalse((boolean)StringUtils.containsAny((CharSequence)"", (CharSequence)""));
        StringUtilsEqualsIndexOfTest.assertFalse((boolean)StringUtils.containsAny((CharSequence)"", (CharSequence)"ab"));
        StringUtilsEqualsIndexOfTest.assertFalse((boolean)StringUtils.containsAny((CharSequence)"zzabyycdxx", (CharSequence)null));
        StringUtilsEqualsIndexOfTest.assertFalse((boolean)StringUtils.containsAny((CharSequence)"zzabyycdxx", (CharSequence)""));
        StringUtilsEqualsIndexOfTest.assertTrue((boolean)StringUtils.containsAny((CharSequence)"zzabyycdxx", (CharSequence)"za"));
        StringUtilsEqualsIndexOfTest.assertTrue((boolean)StringUtils.containsAny((CharSequence)"zzabyycdxx", (CharSequence)"by"));
        StringUtilsEqualsIndexOfTest.assertFalse((boolean)StringUtils.containsAny((CharSequence)"ab", (CharSequence)"z"));
    }

    public void testContainsAny_StringWithBadSupplementaryChars() {
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)false, (boolean)StringUtils.containsAny((CharSequence)CharUSuppCharHigh, (CharSequence)CharU20001));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)CharUSuppCharLow.indexOf(CharU20001));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)false, (boolean)StringUtils.containsAny((CharSequence)CharUSuppCharLow, (CharSequence)CharU20001));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)false, (boolean)StringUtils.containsAny((CharSequence)CharU20001, (CharSequence)CharUSuppCharHigh));
        StringUtilsEqualsIndexOfTest.assertEquals((int)0, (int)CharU20001.indexOf(CharUSuppCharLow));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.containsAny((CharSequence)CharU20001, (CharSequence)CharUSuppCharLow));
    }

    public void testContainsAny_StringWithSupplementaryChars() {
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.containsAny((CharSequence)"\ud840\udc00\ud840\udc01", (CharSequence)CharU20000));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.containsAny((CharSequence)"\ud840\udc00\ud840\udc01", (CharSequence)CharU20001));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.containsAny((CharSequence)CharU20000, (CharSequence)CharU20000));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)CharU20000.indexOf(CharU20001));
        StringUtilsEqualsIndexOfTest.assertEquals((int)0, (int)CharU20000.indexOf(CharU20001.charAt(0)));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)CharU20000.indexOf(CharU20001.charAt(1)));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)false, (boolean)StringUtils.containsAny((CharSequence)CharU20000, (CharSequence)CharU20001));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)false, (boolean)StringUtils.containsAny((CharSequence)CharU20001, (CharSequence)CharU20000));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testContainsIgnoreCase_LocaleIndependence() {
        Locale orig = Locale.getDefault();
        Locale[] locales = new Locale[]{Locale.ENGLISH, new Locale("tr"), Locale.getDefault()};
        String[][] tdata = new String[][]{{"i", "I"}, {"I", "i"}, {"\u03c2", "\u03c3"}, {"\u03a3", "\u03c2"}, {"\u03a3", "\u03c3"}};
        String[][] fdata = new String[][]{{"\u00df", "SS"}};
        try {
            for (Locale locale : locales) {
                int j;
                Locale.setDefault(locale);
                for (j = 0; j < tdata.length; ++j) {
                    StringUtilsEqualsIndexOfTest.assertTrue((String)(Locale.getDefault() + ": " + j + " " + tdata[j][0] + " " + tdata[j][1]), (boolean)StringUtils.containsIgnoreCase((CharSequence)tdata[j][0], (CharSequence)tdata[j][1]));
                }
                for (j = 0; j < fdata.length; ++j) {
                    StringUtilsEqualsIndexOfTest.assertFalse((String)(Locale.getDefault() + ": " + j + " " + fdata[j][0] + " " + fdata[j][1]), (boolean)StringUtils.containsIgnoreCase((CharSequence)fdata[j][0], (CharSequence)fdata[j][1]));
                }
            }
        }
        finally {
            Locale.setDefault(orig);
        }
    }

    public void testContainsIgnoreCase_StringString() {
        StringUtilsEqualsIndexOfTest.assertFalse((boolean)StringUtils.containsIgnoreCase(null, null));
        StringUtilsEqualsIndexOfTest.assertFalse((boolean)StringUtils.containsIgnoreCase(null, (CharSequence)""));
        StringUtilsEqualsIndexOfTest.assertFalse((boolean)StringUtils.containsIgnoreCase(null, (CharSequence)"a"));
        StringUtilsEqualsIndexOfTest.assertFalse((boolean)StringUtils.containsIgnoreCase(null, (CharSequence)"abc"));
        StringUtilsEqualsIndexOfTest.assertFalse((boolean)StringUtils.containsIgnoreCase((CharSequence)"", null));
        StringUtilsEqualsIndexOfTest.assertFalse((boolean)StringUtils.containsIgnoreCase((CharSequence)"a", null));
        StringUtilsEqualsIndexOfTest.assertFalse((boolean)StringUtils.containsIgnoreCase((CharSequence)"abc", null));
        StringUtilsEqualsIndexOfTest.assertTrue((boolean)StringUtils.containsIgnoreCase((CharSequence)"", (CharSequence)""));
        StringUtilsEqualsIndexOfTest.assertTrue((boolean)StringUtils.containsIgnoreCase((CharSequence)"a", (CharSequence)""));
        StringUtilsEqualsIndexOfTest.assertTrue((boolean)StringUtils.containsIgnoreCase((CharSequence)"abc", (CharSequence)""));
        StringUtilsEqualsIndexOfTest.assertFalse((boolean)StringUtils.containsIgnoreCase((CharSequence)"", (CharSequence)"a"));
        StringUtilsEqualsIndexOfTest.assertTrue((boolean)StringUtils.containsIgnoreCase((CharSequence)"a", (CharSequence)"a"));
        StringUtilsEqualsIndexOfTest.assertTrue((boolean)StringUtils.containsIgnoreCase((CharSequence)"abc", (CharSequence)"a"));
        StringUtilsEqualsIndexOfTest.assertFalse((boolean)StringUtils.containsIgnoreCase((CharSequence)"", (CharSequence)"A"));
        StringUtilsEqualsIndexOfTest.assertTrue((boolean)StringUtils.containsIgnoreCase((CharSequence)"a", (CharSequence)"A"));
        StringUtilsEqualsIndexOfTest.assertTrue((boolean)StringUtils.containsIgnoreCase((CharSequence)"abc", (CharSequence)"A"));
        StringUtilsEqualsIndexOfTest.assertFalse((boolean)StringUtils.containsIgnoreCase((CharSequence)"", (CharSequence)"abc"));
        StringUtilsEqualsIndexOfTest.assertFalse((boolean)StringUtils.containsIgnoreCase((CharSequence)"a", (CharSequence)"abc"));
        StringUtilsEqualsIndexOfTest.assertTrue((boolean)StringUtils.containsIgnoreCase((CharSequence)"xabcz", (CharSequence)"abc"));
        StringUtilsEqualsIndexOfTest.assertFalse((boolean)StringUtils.containsIgnoreCase((CharSequence)"", (CharSequence)"ABC"));
        StringUtilsEqualsIndexOfTest.assertFalse((boolean)StringUtils.containsIgnoreCase((CharSequence)"a", (CharSequence)"ABC"));
        StringUtilsEqualsIndexOfTest.assertTrue((boolean)StringUtils.containsIgnoreCase((CharSequence)"xabcz", (CharSequence)"ABC"));
    }

    public void testContainsNone_CharArray() {
        String str1 = "a";
        String str2 = "b";
        String str3 = "ab.";
        char[] chars1 = new char[]{'b'};
        char[] chars2 = new char[]{'.'};
        char[] chars3 = new char[]{'c', 'd'};
        char[] emptyChars = new char[]{};
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.containsNone(null, (char[])null));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.containsNone((CharSequence)"", (char[])null));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.containsNone(null, (char[])emptyChars));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.containsNone((CharSequence)str1, (char[])emptyChars));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.containsNone((CharSequence)"", (char[])emptyChars));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.containsNone((CharSequence)"", (char[])chars1));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.containsNone((CharSequence)str1, (char[])chars1));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.containsNone((CharSequence)str1, (char[])chars2));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.containsNone((CharSequence)str1, (char[])chars3));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)false, (boolean)StringUtils.containsNone((CharSequence)str2, (char[])chars1));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.containsNone((CharSequence)str2, (char[])chars2));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.containsNone((CharSequence)str2, (char[])chars3));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)false, (boolean)StringUtils.containsNone((CharSequence)str3, (char[])chars1));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)false, (boolean)StringUtils.containsNone((CharSequence)str3, (char[])chars2));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.containsNone((CharSequence)str3, (char[])chars3));
    }

    public void testContainsNone_CharArrayWithBadSupplementaryChars() {
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.containsNone((CharSequence)CharUSuppCharHigh, (char[])CharU20001.toCharArray()));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)CharUSuppCharLow.indexOf(CharU20001));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.containsNone((CharSequence)CharUSuppCharLow, (char[])CharU20001.toCharArray()));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)CharU20001.indexOf(CharUSuppCharHigh));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.containsNone((CharSequence)CharU20001, (char[])CharUSuppCharHigh.toCharArray()));
        StringUtilsEqualsIndexOfTest.assertEquals((int)0, (int)CharU20001.indexOf(CharUSuppCharLow));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)false, (boolean)StringUtils.containsNone((CharSequence)CharU20001, (char[])CharUSuppCharLow.toCharArray()));
    }

    public void testContainsNone_CharArrayWithSupplementaryChars() {
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)false, (boolean)StringUtils.containsNone((CharSequence)"\ud840\udc00\ud840\udc01", (char[])CharU20000.toCharArray()));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)false, (boolean)StringUtils.containsNone((CharSequence)"\ud840\udc00\ud840\udc01", (char[])CharU20001.toCharArray()));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)false, (boolean)StringUtils.containsNone((CharSequence)CharU20000, (char[])CharU20000.toCharArray()));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)CharU20000.indexOf(CharU20001));
        StringUtilsEqualsIndexOfTest.assertEquals((int)0, (int)CharU20000.indexOf(CharU20001.charAt(0)));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)CharU20000.indexOf(CharU20001.charAt(1)));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.containsNone((CharSequence)CharU20000, (char[])CharU20001.toCharArray()));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.containsNone((CharSequence)CharU20001, (char[])CharU20000.toCharArray()));
    }

    public void testContainsNone_String() {
        String str1 = "a";
        String str2 = "b";
        String str3 = "ab.";
        String chars1 = "b";
        String chars2 = ".";
        String chars3 = "cd";
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.containsNone(null, (String)null));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.containsNone((CharSequence)"", (String)null));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.containsNone(null, (String)""));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.containsNone((CharSequence)str1, (String)""));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.containsNone((CharSequence)"", (String)""));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.containsNone((CharSequence)"", (String)chars1));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.containsNone((CharSequence)str1, (String)chars1));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.containsNone((CharSequence)str1, (String)chars2));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.containsNone((CharSequence)str1, (String)chars3));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)false, (boolean)StringUtils.containsNone((CharSequence)str2, (String)chars1));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.containsNone((CharSequence)str2, (String)chars2));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.containsNone((CharSequence)str2, (String)chars3));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)false, (boolean)StringUtils.containsNone((CharSequence)str3, (String)chars1));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)false, (boolean)StringUtils.containsNone((CharSequence)str3, (String)chars2));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.containsNone((CharSequence)str3, (String)chars3));
    }

    public void testContainsNone_StringWithBadSupplementaryChars() {
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.containsNone((CharSequence)CharUSuppCharHigh, (String)CharU20001));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)CharUSuppCharLow.indexOf(CharU20001));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.containsNone((CharSequence)CharUSuppCharLow, (String)CharU20001));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)CharU20001.indexOf(CharUSuppCharHigh));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.containsNone((CharSequence)CharU20001, (String)CharUSuppCharHigh));
        StringUtilsEqualsIndexOfTest.assertEquals((int)0, (int)CharU20001.indexOf(CharUSuppCharLow));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)false, (boolean)StringUtils.containsNone((CharSequence)CharU20001, (String)CharUSuppCharLow));
    }

    public void testContainsNone_StringWithSupplementaryChars() {
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)false, (boolean)StringUtils.containsNone((CharSequence)"\ud840\udc00\ud840\udc01", (String)CharU20000));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)false, (boolean)StringUtils.containsNone((CharSequence)"\ud840\udc00\ud840\udc01", (String)CharU20001));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)false, (boolean)StringUtils.containsNone((CharSequence)CharU20000, (String)CharU20000));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)CharU20000.indexOf(CharU20001));
        StringUtilsEqualsIndexOfTest.assertEquals((int)0, (int)CharU20000.indexOf(CharU20001.charAt(0)));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)CharU20000.indexOf(CharU20001.charAt(1)));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.containsNone((CharSequence)CharU20000, (String)CharU20001));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.containsNone((CharSequence)CharU20001, (String)CharU20000));
    }

    public void testContainsOnly_CharArray() {
        String str1 = "a";
        String str2 = "b";
        String str3 = "ab";
        char[] chars1 = new char[]{'b'};
        char[] chars2 = new char[]{'a'};
        char[] chars3 = new char[]{'a', 'b'};
        char[] emptyChars = new char[]{};
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)false, (boolean)StringUtils.containsOnly(null, (char[])null));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)false, (boolean)StringUtils.containsOnly((CharSequence)"", (char[])null));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)false, (boolean)StringUtils.containsOnly(null, (char[])emptyChars));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)false, (boolean)StringUtils.containsOnly((CharSequence)str1, (char[])emptyChars));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.containsOnly((CharSequence)"", (char[])emptyChars));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.containsOnly((CharSequence)"", (char[])chars1));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)false, (boolean)StringUtils.containsOnly((CharSequence)str1, (char[])chars1));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.containsOnly((CharSequence)str1, (char[])chars2));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.containsOnly((CharSequence)str1, (char[])chars3));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.containsOnly((CharSequence)str2, (char[])chars1));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)false, (boolean)StringUtils.containsOnly((CharSequence)str2, (char[])chars2));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.containsOnly((CharSequence)str2, (char[])chars3));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)false, (boolean)StringUtils.containsOnly((CharSequence)str3, (char[])chars1));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)false, (boolean)StringUtils.containsOnly((CharSequence)str3, (char[])chars2));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.containsOnly((CharSequence)str3, (char[])chars3));
    }

    public void testContainsOnly_String() {
        String str1 = "a";
        String str2 = "b";
        String str3 = "ab";
        String chars1 = "b";
        String chars2 = "a";
        String chars3 = "ab";
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)false, (boolean)StringUtils.containsOnly(null, (String)null));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)false, (boolean)StringUtils.containsOnly((CharSequence)"", (String)null));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)false, (boolean)StringUtils.containsOnly(null, (String)""));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)false, (boolean)StringUtils.containsOnly((CharSequence)str1, (String)""));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.containsOnly((CharSequence)"", (String)""));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.containsOnly((CharSequence)"", (String)chars1));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)false, (boolean)StringUtils.containsOnly((CharSequence)str1, (String)chars1));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.containsOnly((CharSequence)str1, (String)chars2));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.containsOnly((CharSequence)str1, (String)chars3));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.containsOnly((CharSequence)str2, (String)chars1));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)false, (boolean)StringUtils.containsOnly((CharSequence)str2, (String)chars2));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.containsOnly((CharSequence)str2, (String)chars3));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)false, (boolean)StringUtils.containsOnly((CharSequence)str3, (String)chars1));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)false, (boolean)StringUtils.containsOnly((CharSequence)str3, (String)chars2));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.containsOnly((CharSequence)str3, (String)chars3));
    }

    public void testContainsWhitespace() {
        StringUtilsEqualsIndexOfTest.assertFalse((boolean)StringUtils.containsWhitespace((CharSequence)""));
        StringUtilsEqualsIndexOfTest.assertTrue((boolean)StringUtils.containsWhitespace((CharSequence)" "));
        StringUtilsEqualsIndexOfTest.assertFalse((boolean)StringUtils.containsWhitespace((CharSequence)"a"));
        StringUtilsEqualsIndexOfTest.assertTrue((boolean)StringUtils.containsWhitespace((CharSequence)"a "));
        StringUtilsEqualsIndexOfTest.assertTrue((boolean)StringUtils.containsWhitespace((CharSequence)" a"));
        StringUtilsEqualsIndexOfTest.assertTrue((boolean)StringUtils.containsWhitespace((CharSequence)"a\t"));
        StringUtilsEqualsIndexOfTest.assertTrue((boolean)StringUtils.containsWhitespace((CharSequence)"\n"));
    }

    public void testEquals() {
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.equals(null, null));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.equals((CharSequence)FOO, (CharSequence)FOO));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.equals((CharSequence)FOO, (CharSequence)new String(new char[]{'f', 'o', 'o'})));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)false, (boolean)StringUtils.equals((CharSequence)FOO, (CharSequence)new String(new char[]{'f', 'O', 'O'})));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)false, (boolean)StringUtils.equals((CharSequence)FOO, (CharSequence)BAR));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)false, (boolean)StringUtils.equals((CharSequence)FOO, null));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)false, (boolean)StringUtils.equals(null, (CharSequence)FOO));
    }

    public void testEqualsIgnoreCase() {
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.equalsIgnoreCase(null, null));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.equalsIgnoreCase((CharSequence)FOO, (CharSequence)FOO));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.equalsIgnoreCase((CharSequence)FOO, (CharSequence)new String(new char[]{'f', 'o', 'o'})));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)true, (boolean)StringUtils.equalsIgnoreCase((CharSequence)FOO, (CharSequence)new String(new char[]{'f', 'O', 'O'})));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)false, (boolean)StringUtils.equalsIgnoreCase((CharSequence)FOO, (CharSequence)BAR));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)false, (boolean)StringUtils.equalsIgnoreCase((CharSequence)FOO, null));
        StringUtilsEqualsIndexOfTest.assertEquals((boolean)false, (boolean)StringUtils.equalsIgnoreCase(null, (CharSequence)FOO));
    }

    public void testIndexOf_char() {
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOf(null, (int)32));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOf((CharSequence)"", (int)32));
        StringUtilsEqualsIndexOfTest.assertEquals((int)0, (int)StringUtils.indexOf((CharSequence)"aabaabaa", (int)97));
        StringUtilsEqualsIndexOfTest.assertEquals((int)2, (int)StringUtils.indexOf((CharSequence)"aabaabaa", (int)98));
        StringUtilsEqualsIndexOfTest.assertEquals((int)2, (int)StringUtils.indexOf((CharSequence)new StringBuilder("aabaabaa"), (int)98));
    }

    public void testIndexOf_charInt() {
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOf(null, (int)32, (int)0));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOf(null, (int)32, (int)-1));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOf((CharSequence)"", (int)32, (int)0));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOf((CharSequence)"", (int)32, (int)-1));
        StringUtilsEqualsIndexOfTest.assertEquals((int)0, (int)StringUtils.indexOf((CharSequence)"aabaabaa", (int)97, (int)0));
        StringUtilsEqualsIndexOfTest.assertEquals((int)2, (int)StringUtils.indexOf((CharSequence)"aabaabaa", (int)98, (int)0));
        StringUtilsEqualsIndexOfTest.assertEquals((int)5, (int)StringUtils.indexOf((CharSequence)"aabaabaa", (int)98, (int)3));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOf((CharSequence)"aabaabaa", (int)98, (int)9));
        StringUtilsEqualsIndexOfTest.assertEquals((int)2, (int)StringUtils.indexOf((CharSequence)"aabaabaa", (int)98, (int)-1));
        StringUtilsEqualsIndexOfTest.assertEquals((int)5, (int)StringUtils.indexOf((CharSequence)new StringBuilder("aabaabaa"), (int)98, (int)3));
    }

    public void testIndexOf_String() {
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOf(null, null));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOf((CharSequence)"", null));
        StringUtilsEqualsIndexOfTest.assertEquals((int)0, (int)StringUtils.indexOf((CharSequence)"", (CharSequence)""));
        StringUtilsEqualsIndexOfTest.assertEquals((int)0, (int)StringUtils.indexOf((CharSequence)"aabaabaa", (CharSequence)"a"));
        StringUtilsEqualsIndexOfTest.assertEquals((int)2, (int)StringUtils.indexOf((CharSequence)"aabaabaa", (CharSequence)"b"));
        StringUtilsEqualsIndexOfTest.assertEquals((int)1, (int)StringUtils.indexOf((CharSequence)"aabaabaa", (CharSequence)"ab"));
        StringUtilsEqualsIndexOfTest.assertEquals((int)0, (int)StringUtils.indexOf((CharSequence)"aabaabaa", (CharSequence)""));
        StringUtilsEqualsIndexOfTest.assertEquals((int)2, (int)StringUtils.indexOf((CharSequence)new StringBuilder("aabaabaa"), (CharSequence)"b"));
    }

    public void testIndexOf_StringInt() {
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOf(null, null, (int)0));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOf(null, null, (int)-1));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOf(null, (CharSequence)"", (int)0));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOf(null, (CharSequence)"", (int)-1));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOf((CharSequence)"", null, (int)0));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOf((CharSequence)"", null, (int)-1));
        StringUtilsEqualsIndexOfTest.assertEquals((int)0, (int)StringUtils.indexOf((CharSequence)"", (CharSequence)"", (int)0));
        StringUtilsEqualsIndexOfTest.assertEquals((int)0, (int)StringUtils.indexOf((CharSequence)"", (CharSequence)"", (int)-1));
        StringUtilsEqualsIndexOfTest.assertEquals((int)0, (int)StringUtils.indexOf((CharSequence)"", (CharSequence)"", (int)9));
        StringUtilsEqualsIndexOfTest.assertEquals((int)0, (int)StringUtils.indexOf((CharSequence)"abc", (CharSequence)"", (int)0));
        StringUtilsEqualsIndexOfTest.assertEquals((int)0, (int)StringUtils.indexOf((CharSequence)"abc", (CharSequence)"", (int)-1));
        StringUtilsEqualsIndexOfTest.assertEquals((int)3, (int)StringUtils.indexOf((CharSequence)"abc", (CharSequence)"", (int)9));
        StringUtilsEqualsIndexOfTest.assertEquals((int)3, (int)StringUtils.indexOf((CharSequence)"abc", (CharSequence)"", (int)3));
        StringUtilsEqualsIndexOfTest.assertEquals((int)0, (int)StringUtils.indexOf((CharSequence)"aabaabaa", (CharSequence)"a", (int)0));
        StringUtilsEqualsIndexOfTest.assertEquals((int)2, (int)StringUtils.indexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)0));
        StringUtilsEqualsIndexOfTest.assertEquals((int)1, (int)StringUtils.indexOf((CharSequence)"aabaabaa", (CharSequence)"ab", (int)0));
        StringUtilsEqualsIndexOfTest.assertEquals((int)5, (int)StringUtils.indexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)3));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)9));
        StringUtilsEqualsIndexOfTest.assertEquals((int)2, (int)StringUtils.indexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)-1));
        StringUtilsEqualsIndexOfTest.assertEquals((int)2, (int)StringUtils.indexOf((CharSequence)"aabaabaa", (CharSequence)"", (int)2));
        StringUtilsEqualsIndexOfTest.assertEquals((int)5, (int)StringUtils.indexOf((CharSequence)new StringBuilder("aabaabaa"), (CharSequence)"b", (int)3));
    }

    public void testIndexOfAny_StringCharArray() {
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOfAny(null, (char[])null));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOfAny(null, (char[])new char[0]));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOfAny(null, (char[])new char[]{'a', 'b'}));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOfAny((CharSequence)"", (char[])null));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOfAny((CharSequence)"", (char[])new char[0]));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOfAny((CharSequence)"", (char[])new char[]{'a', 'b'}));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOfAny((CharSequence)"zzabyycdxx", (char[])null));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOfAny((CharSequence)"zzabyycdxx", (char[])new char[0]));
        StringUtilsEqualsIndexOfTest.assertEquals((int)0, (int)StringUtils.indexOfAny((CharSequence)"zzabyycdxx", (char[])new char[]{'z', 'a'}));
        StringUtilsEqualsIndexOfTest.assertEquals((int)3, (int)StringUtils.indexOfAny((CharSequence)"zzabyycdxx", (char[])new char[]{'b', 'y'}));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOfAny((CharSequence)"ab", (char[])new char[]{'z'}));
    }

    public void testIndexOfAny_StringCharArrayWithSupplementaryChars() {
        StringUtilsEqualsIndexOfTest.assertEquals((int)0, (int)StringUtils.indexOfAny((CharSequence)"\ud840\udc00\ud840\udc01", (char[])CharU20000.toCharArray()));
        StringUtilsEqualsIndexOfTest.assertEquals((int)2, (int)StringUtils.indexOfAny((CharSequence)"\ud840\udc00\ud840\udc01", (char[])CharU20001.toCharArray()));
        StringUtilsEqualsIndexOfTest.assertEquals((int)0, (int)StringUtils.indexOfAny((CharSequence)CharU20000, (char[])CharU20000.toCharArray()));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOfAny((CharSequence)CharU20000, (char[])CharU20001.toCharArray()));
    }

    public void testIndexOfAny_StringString() {
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOfAny(null, (String)null));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOfAny(null, (String)""));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOfAny(null, (String)"ab"));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOfAny((CharSequence)"", (String)null));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOfAny((CharSequence)"", (String)""));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOfAny((CharSequence)"", (String)"ab"));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOfAny((CharSequence)"zzabyycdxx", (String)null));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOfAny((CharSequence)"zzabyycdxx", (String)""));
        StringUtilsEqualsIndexOfTest.assertEquals((int)0, (int)StringUtils.indexOfAny((CharSequence)"zzabyycdxx", (String)"za"));
        StringUtilsEqualsIndexOfTest.assertEquals((int)3, (int)StringUtils.indexOfAny((CharSequence)"zzabyycdxx", (String)"by"));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOfAny((CharSequence)"ab", (String)"z"));
    }

    public void testIndexOfAny_StringStringArray() {
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOfAny(null, (CharSequence[])null));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOfAny(null, (CharSequence[])FOOBAR_SUB_ARRAY));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOfAny((CharSequence)FOOBAR, (CharSequence[])null));
        StringUtilsEqualsIndexOfTest.assertEquals((int)2, (int)StringUtils.indexOfAny((CharSequence)FOOBAR, (CharSequence[])FOOBAR_SUB_ARRAY));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOfAny((CharSequence)FOOBAR, (CharSequence[])new String[0]));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOfAny(null, (CharSequence[])new String[0]));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOfAny((CharSequence)"", (CharSequence[])new String[0]));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOfAny((CharSequence)FOOBAR, (CharSequence[])new String[]{"llll"}));
        StringUtilsEqualsIndexOfTest.assertEquals((int)0, (int)StringUtils.indexOfAny((CharSequence)FOOBAR, (CharSequence[])new String[]{""}));
        StringUtilsEqualsIndexOfTest.assertEquals((int)0, (int)StringUtils.indexOfAny((CharSequence)"", (CharSequence[])new String[]{""}));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOfAny((CharSequence)"", (CharSequence[])new String[]{"a"}));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOfAny((CharSequence)"", (CharSequence[])new String[]{null}));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOfAny((CharSequence)FOOBAR, (CharSequence[])new String[]{null}));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOfAny(null, (CharSequence[])new String[]{null}));
    }

    public void testIndexOfAny_StringStringWithSupplementaryChars() {
        StringUtilsEqualsIndexOfTest.assertEquals((int)0, (int)StringUtils.indexOfAny((CharSequence)"\ud840\udc00\ud840\udc01", (String)CharU20000));
        StringUtilsEqualsIndexOfTest.assertEquals((int)2, (int)StringUtils.indexOfAny((CharSequence)"\ud840\udc00\ud840\udc01", (String)CharU20001));
        StringUtilsEqualsIndexOfTest.assertEquals((int)0, (int)StringUtils.indexOfAny((CharSequence)CharU20000, (String)CharU20000));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOfAny((CharSequence)CharU20000, (String)CharU20001));
    }

    public void testIndexOfAnyBut_StringCharArray() {
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOfAnyBut(null, (char[])null));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOfAnyBut(null, (char[])new char[0]));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOfAnyBut(null, (char[])new char[]{'a', 'b'}));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOfAnyBut((CharSequence)"", (char[])null));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOfAnyBut((CharSequence)"", (char[])new char[0]));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOfAnyBut((CharSequence)"", (char[])new char[]{'a', 'b'}));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOfAnyBut((CharSequence)"zzabyycdxx", (char[])null));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOfAnyBut((CharSequence)"zzabyycdxx", (char[])new char[0]));
        StringUtilsEqualsIndexOfTest.assertEquals((int)3, (int)StringUtils.indexOfAnyBut((CharSequence)"zzabyycdxx", (char[])new char[]{'z', 'a'}));
        StringUtilsEqualsIndexOfTest.assertEquals((int)0, (int)StringUtils.indexOfAnyBut((CharSequence)"zzabyycdxx", (char[])new char[]{'b', 'y'}));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOfAnyBut((CharSequence)"aba", (char[])new char[]{'a', 'b'}));
        StringUtilsEqualsIndexOfTest.assertEquals((int)0, (int)StringUtils.indexOfAnyBut((CharSequence)"aba", (char[])new char[]{'z'}));
    }

    public void testIndexOfAnyBut_StringCharArrayWithSupplementaryChars() {
        StringUtilsEqualsIndexOfTest.assertEquals((int)2, (int)StringUtils.indexOfAnyBut((CharSequence)"\ud840\udc00\ud840\udc01", (char[])CharU20000.toCharArray()));
        StringUtilsEqualsIndexOfTest.assertEquals((int)0, (int)StringUtils.indexOfAnyBut((CharSequence)"\ud840\udc00\ud840\udc01", (char[])CharU20001.toCharArray()));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOfAnyBut((CharSequence)CharU20000, (char[])CharU20000.toCharArray()));
        StringUtilsEqualsIndexOfTest.assertEquals((int)0, (int)StringUtils.indexOfAnyBut((CharSequence)CharU20000, (char[])CharU20001.toCharArray()));
    }

    public void testIndexOfAnyBut_StringString() {
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOfAnyBut(null, (CharSequence)null));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOfAnyBut(null, (CharSequence)""));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOfAnyBut(null, (CharSequence)"ab"));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOfAnyBut((CharSequence)"", (CharSequence)null));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOfAnyBut((CharSequence)"", (CharSequence)""));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOfAnyBut((CharSequence)"", (CharSequence)"ab"));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOfAnyBut((CharSequence)"zzabyycdxx", (CharSequence)null));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOfAnyBut((CharSequence)"zzabyycdxx", (CharSequence)""));
        StringUtilsEqualsIndexOfTest.assertEquals((int)3, (int)StringUtils.indexOfAnyBut((CharSequence)"zzabyycdxx", (CharSequence)"za"));
        StringUtilsEqualsIndexOfTest.assertEquals((int)0, (int)StringUtils.indexOfAnyBut((CharSequence)"zzabyycdxx", (CharSequence)"by"));
        StringUtilsEqualsIndexOfTest.assertEquals((int)0, (int)StringUtils.indexOfAnyBut((CharSequence)"ab", (CharSequence)"z"));
    }

    public void testIndexOfAnyBut_StringStringWithSupplementaryChars() {
        StringUtilsEqualsIndexOfTest.assertEquals((int)2, (int)StringUtils.indexOfAnyBut((CharSequence)"\ud840\udc00\ud840\udc01", (CharSequence)CharU20000));
        StringUtilsEqualsIndexOfTest.assertEquals((int)0, (int)StringUtils.indexOfAnyBut((CharSequence)"\ud840\udc00\ud840\udc01", (CharSequence)CharU20001));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOfAnyBut((CharSequence)CharU20000, (CharSequence)CharU20000));
        StringUtilsEqualsIndexOfTest.assertEquals((int)0, (int)StringUtils.indexOfAnyBut((CharSequence)CharU20000, (CharSequence)CharU20001));
    }

    public void testIndexOfIgnoreCase_String() {
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOfIgnoreCase(null, null));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOfIgnoreCase(null, (CharSequence)""));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOfIgnoreCase((CharSequence)"", null));
        StringUtilsEqualsIndexOfTest.assertEquals((int)0, (int)StringUtils.indexOfIgnoreCase((CharSequence)"", (CharSequence)""));
        StringUtilsEqualsIndexOfTest.assertEquals((int)0, (int)StringUtils.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"a"));
        StringUtilsEqualsIndexOfTest.assertEquals((int)0, (int)StringUtils.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"A"));
        StringUtilsEqualsIndexOfTest.assertEquals((int)2, (int)StringUtils.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"b"));
        StringUtilsEqualsIndexOfTest.assertEquals((int)2, (int)StringUtils.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"B"));
        StringUtilsEqualsIndexOfTest.assertEquals((int)1, (int)StringUtils.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"ab"));
        StringUtilsEqualsIndexOfTest.assertEquals((int)1, (int)StringUtils.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"AB"));
        StringUtilsEqualsIndexOfTest.assertEquals((int)0, (int)StringUtils.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)""));
    }

    public void testIndexOfIgnoreCase_StringInt() {
        StringUtilsEqualsIndexOfTest.assertEquals((int)1, (int)StringUtils.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"AB", (int)-1));
        StringUtilsEqualsIndexOfTest.assertEquals((int)1, (int)StringUtils.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"AB", (int)0));
        StringUtilsEqualsIndexOfTest.assertEquals((int)1, (int)StringUtils.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"AB", (int)1));
        StringUtilsEqualsIndexOfTest.assertEquals((int)4, (int)StringUtils.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"AB", (int)2));
        StringUtilsEqualsIndexOfTest.assertEquals((int)4, (int)StringUtils.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"AB", (int)3));
        StringUtilsEqualsIndexOfTest.assertEquals((int)4, (int)StringUtils.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"AB", (int)4));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"AB", (int)5));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"AB", (int)6));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"AB", (int)7));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"AB", (int)8));
        StringUtilsEqualsIndexOfTest.assertEquals((int)1, (int)StringUtils.indexOfIgnoreCase((CharSequence)"aab", (CharSequence)"AB", (int)1));
        StringUtilsEqualsIndexOfTest.assertEquals((int)5, (int)StringUtils.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"", (int)5));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOfIgnoreCase((CharSequence)"ab", (CharSequence)"AAB", (int)0));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.indexOfIgnoreCase((CharSequence)"aab", (CharSequence)"AAB", (int)1));
    }

    public void testLastIndexOf_char() {
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.lastIndexOf(null, (int)32));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.lastIndexOf((CharSequence)"", (int)32));
        StringUtilsEqualsIndexOfTest.assertEquals((int)7, (int)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (int)97));
        StringUtilsEqualsIndexOfTest.assertEquals((int)5, (int)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (int)98));
        StringUtilsEqualsIndexOfTest.assertEquals((int)5, (int)StringUtils.lastIndexOf((CharSequence)new StringBuilder("aabaabaa"), (int)98));
    }

    public void testLastIndexOf_charInt() {
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.lastIndexOf(null, (int)32, (int)0));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.lastIndexOf(null, (int)32, (int)-1));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.lastIndexOf((CharSequence)"", (int)32, (int)0));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.lastIndexOf((CharSequence)"", (int)32, (int)-1));
        StringUtilsEqualsIndexOfTest.assertEquals((int)7, (int)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (int)97, (int)8));
        StringUtilsEqualsIndexOfTest.assertEquals((int)5, (int)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (int)98, (int)8));
        StringUtilsEqualsIndexOfTest.assertEquals((int)2, (int)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (int)98, (int)3));
        StringUtilsEqualsIndexOfTest.assertEquals((int)5, (int)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (int)98, (int)9));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (int)98, (int)-1));
        StringUtilsEqualsIndexOfTest.assertEquals((int)0, (int)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (int)97, (int)0));
        StringUtilsEqualsIndexOfTest.assertEquals((int)2, (int)StringUtils.lastIndexOf((CharSequence)new StringBuilder("aabaabaa"), (int)98, (int)2));
    }

    public void testLastIndexOf_String() {
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.lastIndexOf(null, null));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.lastIndexOf((CharSequence)"", null));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.lastIndexOf((CharSequence)"", (CharSequence)"a"));
        StringUtilsEqualsIndexOfTest.assertEquals((int)0, (int)StringUtils.lastIndexOf((CharSequence)"", (CharSequence)""));
        StringUtilsEqualsIndexOfTest.assertEquals((int)8, (int)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (CharSequence)""));
        StringUtilsEqualsIndexOfTest.assertEquals((int)7, (int)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (CharSequence)"a"));
        StringUtilsEqualsIndexOfTest.assertEquals((int)5, (int)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (CharSequence)"b"));
        StringUtilsEqualsIndexOfTest.assertEquals((int)4, (int)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (CharSequence)"ab"));
        StringUtilsEqualsIndexOfTest.assertEquals((int)4, (int)StringUtils.lastIndexOf((CharSequence)new StringBuilder("aabaabaa"), (CharSequence)"ab"));
    }

    public void testLastIndexOf_StringInt() {
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.lastIndexOf(null, null, (int)0));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.lastIndexOf(null, null, (int)-1));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.lastIndexOf(null, (CharSequence)"", (int)0));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.lastIndexOf(null, (CharSequence)"", (int)-1));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.lastIndexOf((CharSequence)"", null, (int)0));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.lastIndexOf((CharSequence)"", null, (int)-1));
        StringUtilsEqualsIndexOfTest.assertEquals((int)0, (int)StringUtils.lastIndexOf((CharSequence)"", (CharSequence)"", (int)0));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.lastIndexOf((CharSequence)"", (CharSequence)"", (int)-1));
        StringUtilsEqualsIndexOfTest.assertEquals((int)0, (int)StringUtils.lastIndexOf((CharSequence)"", (CharSequence)"", (int)9));
        StringUtilsEqualsIndexOfTest.assertEquals((int)0, (int)StringUtils.lastIndexOf((CharSequence)"abc", (CharSequence)"", (int)0));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.lastIndexOf((CharSequence)"abc", (CharSequence)"", (int)-1));
        StringUtilsEqualsIndexOfTest.assertEquals((int)3, (int)StringUtils.lastIndexOf((CharSequence)"abc", (CharSequence)"", (int)9));
        StringUtilsEqualsIndexOfTest.assertEquals((int)7, (int)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (CharSequence)"a", (int)8));
        StringUtilsEqualsIndexOfTest.assertEquals((int)5, (int)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)8));
        StringUtilsEqualsIndexOfTest.assertEquals((int)4, (int)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (CharSequence)"ab", (int)8));
        StringUtilsEqualsIndexOfTest.assertEquals((int)2, (int)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)3));
        StringUtilsEqualsIndexOfTest.assertEquals((int)5, (int)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)9));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)-1));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)0));
        StringUtilsEqualsIndexOfTest.assertEquals((int)0, (int)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (CharSequence)"a", (int)0));
        StringUtilsEqualsIndexOfTest.assertEquals((int)2, (int)StringUtils.lastIndexOf((CharSequence)new StringBuilder("aabaabaa"), (CharSequence)"b", (int)3));
    }

    public void testLastIndexOfAny_StringStringArray() {
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.lastIndexOfAny(null, (CharSequence[])new CharSequence[]{null}));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.lastIndexOfAny(null, (CharSequence[])null));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.lastIndexOfAny(null, (CharSequence[])new CharSequence[0]));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.lastIndexOfAny(null, (CharSequence[])FOOBAR_SUB_ARRAY));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.lastIndexOfAny((CharSequence)FOOBAR, (CharSequence[])new CharSequence[]{null}));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.lastIndexOfAny((CharSequence)FOOBAR, (CharSequence[])null));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.lastIndexOfAny((CharSequence)FOOBAR, (CharSequence[])new CharSequence[0]));
        StringUtilsEqualsIndexOfTest.assertEquals((int)3, (int)StringUtils.lastIndexOfAny((CharSequence)FOOBAR, (CharSequence[])FOOBAR_SUB_ARRAY));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.lastIndexOfAny((CharSequence)FOOBAR, (CharSequence[])new String[0]));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.lastIndexOfAny(null, (CharSequence[])new String[0]));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.lastIndexOfAny((CharSequence)"", (CharSequence[])new String[0]));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.lastIndexOfAny((CharSequence)FOOBAR, (CharSequence[])new String[]{"llll"}));
        StringUtilsEqualsIndexOfTest.assertEquals((int)6, (int)StringUtils.lastIndexOfAny((CharSequence)FOOBAR, (CharSequence[])new String[]{""}));
        StringUtilsEqualsIndexOfTest.assertEquals((int)0, (int)StringUtils.lastIndexOfAny((CharSequence)"", (CharSequence[])new String[]{""}));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.lastIndexOfAny((CharSequence)"", (CharSequence[])new String[]{"a"}));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.lastIndexOfAny((CharSequence)"", (CharSequence[])new String[]{null}));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.lastIndexOfAny((CharSequence)FOOBAR, (CharSequence[])new String[]{null}));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.lastIndexOfAny(null, (CharSequence[])new String[]{null}));
    }

    public void testLastIndexOfIgnoreCase_String() {
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.lastIndexOfIgnoreCase(null, null));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.lastIndexOfIgnoreCase((CharSequence)"", null));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.lastIndexOfIgnoreCase(null, (CharSequence)""));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.lastIndexOfIgnoreCase((CharSequence)"", (CharSequence)"a"));
        StringUtilsEqualsIndexOfTest.assertEquals((int)0, (int)StringUtils.lastIndexOfIgnoreCase((CharSequence)"", (CharSequence)""));
        StringUtilsEqualsIndexOfTest.assertEquals((int)8, (int)StringUtils.lastIndexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)""));
        StringUtilsEqualsIndexOfTest.assertEquals((int)7, (int)StringUtils.lastIndexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"a"));
        StringUtilsEqualsIndexOfTest.assertEquals((int)7, (int)StringUtils.lastIndexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"A"));
        StringUtilsEqualsIndexOfTest.assertEquals((int)5, (int)StringUtils.lastIndexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"b"));
        StringUtilsEqualsIndexOfTest.assertEquals((int)5, (int)StringUtils.lastIndexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"B"));
        StringUtilsEqualsIndexOfTest.assertEquals((int)4, (int)StringUtils.lastIndexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"ab"));
        StringUtilsEqualsIndexOfTest.assertEquals((int)4, (int)StringUtils.lastIndexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"AB"));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.lastIndexOfIgnoreCase((CharSequence)"ab", (CharSequence)"AAB"));
        StringUtilsEqualsIndexOfTest.assertEquals((int)0, (int)StringUtils.lastIndexOfIgnoreCase((CharSequence)"aab", (CharSequence)"AAB"));
    }

    public void testLastIndexOfIgnoreCase_StringInt() {
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.lastIndexOfIgnoreCase(null, null, (int)0));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.lastIndexOfIgnoreCase(null, null, (int)-1));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.lastIndexOfIgnoreCase(null, (CharSequence)"", (int)0));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.lastIndexOfIgnoreCase(null, (CharSequence)"", (int)-1));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.lastIndexOfIgnoreCase((CharSequence)"", null, (int)0));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.lastIndexOfIgnoreCase((CharSequence)"", null, (int)-1));
        StringUtilsEqualsIndexOfTest.assertEquals((int)0, (int)StringUtils.lastIndexOfIgnoreCase((CharSequence)"", (CharSequence)"", (int)0));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.lastIndexOfIgnoreCase((CharSequence)"", (CharSequence)"", (int)-1));
        StringUtilsEqualsIndexOfTest.assertEquals((int)0, (int)StringUtils.lastIndexOfIgnoreCase((CharSequence)"", (CharSequence)"", (int)9));
        StringUtilsEqualsIndexOfTest.assertEquals((int)0, (int)StringUtils.lastIndexOfIgnoreCase((CharSequence)"abc", (CharSequence)"", (int)0));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.lastIndexOfIgnoreCase((CharSequence)"abc", (CharSequence)"", (int)-1));
        StringUtilsEqualsIndexOfTest.assertEquals((int)3, (int)StringUtils.lastIndexOfIgnoreCase((CharSequence)"abc", (CharSequence)"", (int)9));
        StringUtilsEqualsIndexOfTest.assertEquals((int)7, (int)StringUtils.lastIndexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"A", (int)8));
        StringUtilsEqualsIndexOfTest.assertEquals((int)5, (int)StringUtils.lastIndexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"B", (int)8));
        StringUtilsEqualsIndexOfTest.assertEquals((int)4, (int)StringUtils.lastIndexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"AB", (int)8));
        StringUtilsEqualsIndexOfTest.assertEquals((int)2, (int)StringUtils.lastIndexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"B", (int)3));
        StringUtilsEqualsIndexOfTest.assertEquals((int)5, (int)StringUtils.lastIndexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"B", (int)9));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.lastIndexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"B", (int)-1));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.lastIndexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"B", (int)0));
        StringUtilsEqualsIndexOfTest.assertEquals((int)0, (int)StringUtils.lastIndexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"A", (int)0));
        StringUtilsEqualsIndexOfTest.assertEquals((int)1, (int)StringUtils.lastIndexOfIgnoreCase((CharSequence)"aab", (CharSequence)"AB", (int)1));
    }

    public void testLastOrdinalIndexOf() {
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.lastOrdinalIndexOf(null, (CharSequence)"*", (int)42));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.lastOrdinalIndexOf((CharSequence)"*", null, (int)42));
        StringUtilsEqualsIndexOfTest.assertEquals((int)0, (int)StringUtils.lastOrdinalIndexOf((CharSequence)"", (CharSequence)"", (int)42));
        StringUtilsEqualsIndexOfTest.assertEquals((int)7, (int)StringUtils.lastOrdinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"a", (int)1));
        StringUtilsEqualsIndexOfTest.assertEquals((int)6, (int)StringUtils.lastOrdinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"a", (int)2));
        StringUtilsEqualsIndexOfTest.assertEquals((int)5, (int)StringUtils.lastOrdinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)1));
        StringUtilsEqualsIndexOfTest.assertEquals((int)2, (int)StringUtils.lastOrdinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)2));
        StringUtilsEqualsIndexOfTest.assertEquals((int)4, (int)StringUtils.lastOrdinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"ab", (int)1));
        StringUtilsEqualsIndexOfTest.assertEquals((int)1, (int)StringUtils.lastOrdinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"ab", (int)2));
        StringUtilsEqualsIndexOfTest.assertEquals((int)8, (int)StringUtils.lastOrdinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"", (int)1));
        StringUtilsEqualsIndexOfTest.assertEquals((int)8, (int)StringUtils.lastOrdinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"", (int)2));
    }

    public void testOrdinalIndexOf() {
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.ordinalIndexOf(null, null, (int)Integer.MIN_VALUE));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.ordinalIndexOf((CharSequence)"", null, (int)Integer.MIN_VALUE));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.ordinalIndexOf((CharSequence)"", (CharSequence)"", (int)Integer.MIN_VALUE));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"a", (int)Integer.MIN_VALUE));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)Integer.MIN_VALUE));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"ab", (int)Integer.MIN_VALUE));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"", (int)Integer.MIN_VALUE));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.ordinalIndexOf(null, null, (int)-1));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.ordinalIndexOf((CharSequence)"", null, (int)-1));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.ordinalIndexOf((CharSequence)"", (CharSequence)"", (int)-1));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"a", (int)-1));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)-1));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"ab", (int)-1));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"", (int)-1));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.ordinalIndexOf(null, null, (int)0));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.ordinalIndexOf((CharSequence)"", null, (int)0));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.ordinalIndexOf((CharSequence)"", (CharSequence)"", (int)0));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"a", (int)0));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)0));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"ab", (int)0));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"", (int)0));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.ordinalIndexOf(null, null, (int)1));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.ordinalIndexOf((CharSequence)"", null, (int)1));
        StringUtilsEqualsIndexOfTest.assertEquals((int)0, (int)StringUtils.ordinalIndexOf((CharSequence)"", (CharSequence)"", (int)1));
        StringUtilsEqualsIndexOfTest.assertEquals((int)0, (int)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"a", (int)1));
        StringUtilsEqualsIndexOfTest.assertEquals((int)2, (int)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)1));
        StringUtilsEqualsIndexOfTest.assertEquals((int)1, (int)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"ab", (int)1));
        StringUtilsEqualsIndexOfTest.assertEquals((int)0, (int)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"", (int)1));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.ordinalIndexOf(null, null, (int)2));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.ordinalIndexOf((CharSequence)"", null, (int)2));
        StringUtilsEqualsIndexOfTest.assertEquals((int)0, (int)StringUtils.ordinalIndexOf((CharSequence)"", (CharSequence)"", (int)2));
        StringUtilsEqualsIndexOfTest.assertEquals((int)1, (int)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"a", (int)2));
        StringUtilsEqualsIndexOfTest.assertEquals((int)5, (int)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)2));
        StringUtilsEqualsIndexOfTest.assertEquals((int)4, (int)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"ab", (int)2));
        StringUtilsEqualsIndexOfTest.assertEquals((int)0, (int)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"", (int)2));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.ordinalIndexOf(null, null, (int)Integer.MAX_VALUE));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.ordinalIndexOf((CharSequence)"", null, (int)Integer.MAX_VALUE));
        StringUtilsEqualsIndexOfTest.assertEquals((int)0, (int)StringUtils.ordinalIndexOf((CharSequence)"", (CharSequence)"", (int)Integer.MAX_VALUE));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"a", (int)Integer.MAX_VALUE));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)Integer.MAX_VALUE));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"ab", (int)Integer.MAX_VALUE));
        StringUtilsEqualsIndexOfTest.assertEquals((int)0, (int)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"", (int)Integer.MAX_VALUE));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.ordinalIndexOf((CharSequence)"aaaaaaaaa", (CharSequence)"a", (int)0));
        StringUtilsEqualsIndexOfTest.assertEquals((int)0, (int)StringUtils.ordinalIndexOf((CharSequence)"aaaaaaaaa", (CharSequence)"a", (int)1));
        StringUtilsEqualsIndexOfTest.assertEquals((int)1, (int)StringUtils.ordinalIndexOf((CharSequence)"aaaaaaaaa", (CharSequence)"a", (int)2));
        StringUtilsEqualsIndexOfTest.assertEquals((int)2, (int)StringUtils.ordinalIndexOf((CharSequence)"aaaaaaaaa", (CharSequence)"a", (int)3));
        StringUtilsEqualsIndexOfTest.assertEquals((int)3, (int)StringUtils.ordinalIndexOf((CharSequence)"aaaaaaaaa", (CharSequence)"a", (int)4));
        StringUtilsEqualsIndexOfTest.assertEquals((int)4, (int)StringUtils.ordinalIndexOf((CharSequence)"aaaaaaaaa", (CharSequence)"a", (int)5));
        StringUtilsEqualsIndexOfTest.assertEquals((int)5, (int)StringUtils.ordinalIndexOf((CharSequence)"aaaaaaaaa", (CharSequence)"a", (int)6));
        StringUtilsEqualsIndexOfTest.assertEquals((int)6, (int)StringUtils.ordinalIndexOf((CharSequence)"aaaaaaaaa", (CharSequence)"a", (int)7));
        StringUtilsEqualsIndexOfTest.assertEquals((int)7, (int)StringUtils.ordinalIndexOf((CharSequence)"aaaaaaaaa", (CharSequence)"a", (int)8));
        StringUtilsEqualsIndexOfTest.assertEquals((int)8, (int)StringUtils.ordinalIndexOf((CharSequence)"aaaaaaaaa", (CharSequence)"a", (int)9));
        StringUtilsEqualsIndexOfTest.assertEquals((int)-1, (int)StringUtils.ordinalIndexOf((CharSequence)"aaaaaaaaa", (CharSequence)"a", (int)10));
    }
}

