/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.CharBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import junit.framework.TestCase;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;

public class StringUtilsTest
extends TestCase {
    static final String WHITESPACE;
    static final String NON_WHITESPACE;
    static final String TRIMMABLE;
    static final String NON_TRIMMABLE;
    private static final String[] ARRAY_LIST;
    private static final String[] EMPTY_ARRAY_LIST;
    private static final String[] NULL_ARRAY_LIST;
    private static final Object[] NULL_TO_STRING_LIST;
    private static final String[] MIXED_ARRAY_LIST;
    private static final Object[] MIXED_TYPE_LIST;
    private static final String SEPARATOR = ",";
    private static final char SEPARATOR_CHAR = ';';
    private static final String TEXT_LIST = "foo,bar,baz";
    private static final String TEXT_LIST_CHAR = "foo;bar;baz";
    private static final String TEXT_LIST_NOSEP = "foobarbaz";
    private static final String FOO_UNCAP = "foo";
    private static final String FOO_CAP = "Foo";
    private static final String SENTENCE_UNCAP = "foo bar baz";
    private static final String SENTENCE_CAP = "Foo Bar Baz";

    public StringUtilsTest(String name) {
        super(name);
    }

    public void testConstructor() {
        StringUtilsTest.assertNotNull((Object)new StringUtils());
        Constructor<?>[] cons = StringUtils.class.getDeclaredConstructors();
        StringUtilsTest.assertEquals((int)1, (int)cons.length);
        StringUtilsTest.assertEquals((boolean)true, (boolean)Modifier.isPublic(cons[0].getModifiers()));
        StringUtilsTest.assertEquals((boolean)true, (boolean)Modifier.isPublic(StringUtils.class.getModifiers()));
        StringUtilsTest.assertEquals((boolean)false, (boolean)Modifier.isFinal(StringUtils.class.getModifiers()));
    }

    public void testCaseFunctions() {
        StringUtilsTest.assertEquals(null, (String)StringUtils.upperCase(null));
        StringUtilsTest.assertEquals(null, (String)StringUtils.upperCase(null, (Locale)Locale.ENGLISH));
        StringUtilsTest.assertEquals(null, (String)StringUtils.lowerCase(null));
        StringUtilsTest.assertEquals(null, (String)StringUtils.lowerCase(null, (Locale)Locale.ENGLISH));
        StringUtilsTest.assertEquals(null, (String)StringUtils.capitalize(null));
        StringUtilsTest.assertEquals(null, (String)StringUtils.uncapitalize(null));
        StringUtilsTest.assertEquals((String)"capitalize(empty-string) failed", (String)"", (String)StringUtils.capitalize((String)""));
        StringUtilsTest.assertEquals((String)"capitalize(single-char-string) failed", (String)"X", (String)StringUtils.capitalize((String)"x"));
        StringUtilsTest.assertEquals((String)"uncapitalize(String) failed", (String)FOO_UNCAP, (String)StringUtils.uncapitalize((String)FOO_CAP));
        StringUtilsTest.assertEquals((String)"uncapitalize(empty-string) failed", (String)"", (String)StringUtils.uncapitalize((String)""));
        StringUtilsTest.assertEquals((String)"uncapitalize(single-char-string) failed", (String)"x", (String)StringUtils.uncapitalize((String)"X"));
        StringUtilsTest.assertEquals((String)"uncapitalize(capitalize(String)) failed", (String)SENTENCE_UNCAP, (String)StringUtils.uncapitalize((String)StringUtils.capitalize((String)SENTENCE_UNCAP)));
        StringUtilsTest.assertEquals((String)"capitalize(uncapitalize(String)) failed", (String)SENTENCE_CAP, (String)StringUtils.capitalize((String)StringUtils.uncapitalize((String)SENTENCE_CAP)));
        StringUtilsTest.assertEquals((String)"uncapitalize(capitalize(String)) failed", (String)FOO_UNCAP, (String)StringUtils.uncapitalize((String)StringUtils.capitalize((String)FOO_UNCAP)));
        StringUtilsTest.assertEquals((String)"capitalize(uncapitalize(String)) failed", (String)FOO_CAP, (String)StringUtils.capitalize((String)StringUtils.uncapitalize((String)FOO_CAP)));
        StringUtilsTest.assertEquals((String)"upperCase(String) failed", (String)"FOO TEST THING", (String)StringUtils.upperCase((String)"fOo test THING"));
        StringUtilsTest.assertEquals((String)"upperCase(empty-string) failed", (String)"", (String)StringUtils.upperCase((String)""));
        StringUtilsTest.assertEquals((String)"lowerCase(String) failed", (String)"foo test thing", (String)StringUtils.lowerCase((String)"fOo test THING"));
        StringUtilsTest.assertEquals((String)"lowerCase(empty-string) failed", (String)"", (String)StringUtils.lowerCase((String)""));
        StringUtilsTest.assertEquals((String)"upperCase(String, Locale) failed", (String)"FOO TEST THING", (String)StringUtils.upperCase((String)"fOo test THING", (Locale)Locale.ENGLISH));
        StringUtilsTest.assertEquals((String)"upperCase(empty-string, Locale) failed", (String)"", (String)StringUtils.upperCase((String)"", (Locale)Locale.ENGLISH));
        StringUtilsTest.assertEquals((String)"lowerCase(String, Locale) failed", (String)"foo test thing", (String)StringUtils.lowerCase((String)"fOo test THING", (Locale)Locale.ENGLISH));
        StringUtilsTest.assertEquals((String)"lowerCase(empty-string, Locale) failed", (String)"", (String)StringUtils.lowerCase((String)"", (Locale)Locale.ENGLISH));
    }

    public void testSwapCase_String() {
        StringUtilsTest.assertEquals(null, (String)StringUtils.swapCase(null));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.swapCase((String)""));
        StringUtilsTest.assertEquals((String)"  ", (String)StringUtils.swapCase((String)"  "));
        StringUtilsTest.assertEquals((String)"i", (String)WordUtils.swapCase((String)"I"));
        StringUtilsTest.assertEquals((String)"I", (String)WordUtils.swapCase((String)"i"));
        StringUtilsTest.assertEquals((String)"I AM HERE 123", (String)StringUtils.swapCase((String)"i am here 123"));
        StringUtilsTest.assertEquals((String)"i aM hERE 123", (String)StringUtils.swapCase((String)"I Am Here 123"));
        StringUtilsTest.assertEquals((String)"I AM here 123", (String)StringUtils.swapCase((String)"i am HERE 123"));
        StringUtilsTest.assertEquals((String)"i am here 123", (String)StringUtils.swapCase((String)"I AM HERE 123"));
        String test = "This String contains a TitleCase character: \u01c8";
        String expect = "tHIS sTRING CONTAINS A tITLEcASE CHARACTER: \u01c9";
        StringUtilsTest.assertEquals((String)expect, (String)WordUtils.swapCase((String)test));
    }

    public void testJoin_Objects() {
        StringUtilsTest.assertEquals((String)"abc", (String)StringUtils.join((Object[])new String[]{"a", "b", "c"}));
        StringUtilsTest.assertEquals((String)"a", (String)StringUtils.join((Object[])new String[]{null, "", "a"}));
        StringUtilsTest.assertEquals(null, (String)StringUtils.join((Object[])null));
    }

    public void testJoin_Objectarray() {
        StringUtilsTest.assertEquals(null, (String)StringUtils.join((Object[])null));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.join((Object[])new Object[0]));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.join((Object[])new Object[]{null}));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.join((Object[])EMPTY_ARRAY_LIST));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.join((Object[])NULL_ARRAY_LIST));
        StringUtilsTest.assertEquals((String)"null", (String)StringUtils.join((Object[])NULL_TO_STRING_LIST));
        StringUtilsTest.assertEquals((String)"abc", (String)StringUtils.join((Object[])new String[]{"a", "b", "c"}));
        StringUtilsTest.assertEquals((String)"a", (String)StringUtils.join((Object[])new String[]{null, "a", ""}));
        StringUtilsTest.assertEquals((String)FOO_UNCAP, (String)StringUtils.join((Object[])MIXED_ARRAY_LIST));
        StringUtilsTest.assertEquals((String)"foo2", (String)StringUtils.join((Object[])MIXED_TYPE_LIST));
    }

    public void testJoin_ArrayChar() {
        StringUtilsTest.assertEquals(null, (String)StringUtils.join((Object[])null, (char)','));
        StringUtilsTest.assertEquals((String)TEXT_LIST_CHAR, (String)StringUtils.join((Object[])ARRAY_LIST, (char)';'));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.join((Object[])EMPTY_ARRAY_LIST, (char)';'));
        StringUtilsTest.assertEquals((String)";;foo", (String)StringUtils.join((Object[])MIXED_ARRAY_LIST, (char)';'));
        StringUtilsTest.assertEquals((String)"foo;2", (String)StringUtils.join((Object[])MIXED_TYPE_LIST, (char)';'));
        StringUtilsTest.assertEquals((String)"/", (String)StringUtils.join((Object[])MIXED_ARRAY_LIST, (char)'/', (int)0, (int)(MIXED_ARRAY_LIST.length - 1)));
        StringUtilsTest.assertEquals((String)FOO_UNCAP, (String)StringUtils.join((Object[])MIXED_TYPE_LIST, (char)'/', (int)0, (int)1));
        StringUtilsTest.assertEquals((String)"null", (String)StringUtils.join((Object[])NULL_TO_STRING_LIST, (char)'/', (int)0, (int)1));
        StringUtilsTest.assertEquals((String)"foo/2", (String)StringUtils.join((Object[])MIXED_TYPE_LIST, (char)'/', (int)0, (int)2));
        StringUtilsTest.assertEquals((String)"2", (String)StringUtils.join((Object[])MIXED_TYPE_LIST, (char)'/', (int)1, (int)2));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.join((Object[])MIXED_TYPE_LIST, (char)'/', (int)2, (int)1));
    }

    public void testJoin_ArrayString() {
        StringUtilsTest.assertEquals(null, (String)StringUtils.join((Object[])null, null));
        StringUtilsTest.assertEquals((String)TEXT_LIST_NOSEP, (String)StringUtils.join((Object[])ARRAY_LIST, null));
        StringUtilsTest.assertEquals((String)TEXT_LIST_NOSEP, (String)StringUtils.join((Object[])ARRAY_LIST, (String)""));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.join((Object[])NULL_ARRAY_LIST, null));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.join((Object[])EMPTY_ARRAY_LIST, null));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.join((Object[])EMPTY_ARRAY_LIST, (String)""));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.join((Object[])EMPTY_ARRAY_LIST, (String)SEPARATOR));
        StringUtilsTest.assertEquals((String)TEXT_LIST, (String)StringUtils.join((Object[])ARRAY_LIST, (String)SEPARATOR));
        StringUtilsTest.assertEquals((String)",,foo", (String)StringUtils.join((Object[])MIXED_ARRAY_LIST, (String)SEPARATOR));
        StringUtilsTest.assertEquals((String)"foo,2", (String)StringUtils.join((Object[])MIXED_TYPE_LIST, (String)SEPARATOR));
        StringUtilsTest.assertEquals((String)"/", (String)StringUtils.join((Object[])MIXED_ARRAY_LIST, (String)"/", (int)0, (int)(MIXED_ARRAY_LIST.length - 1)));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.join((Object[])MIXED_ARRAY_LIST, (String)"", (int)0, (int)(MIXED_ARRAY_LIST.length - 1)));
        StringUtilsTest.assertEquals((String)FOO_UNCAP, (String)StringUtils.join((Object[])MIXED_TYPE_LIST, (String)"/", (int)0, (int)1));
        StringUtilsTest.assertEquals((String)"foo/2", (String)StringUtils.join((Object[])MIXED_TYPE_LIST, (String)"/", (int)0, (int)2));
        StringUtilsTest.assertEquals((String)"2", (String)StringUtils.join((Object[])MIXED_TYPE_LIST, (String)"/", (int)1, (int)2));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.join((Object[])MIXED_TYPE_LIST, (String)"/", (int)2, (int)1));
    }

    public void testJoin_IteratorChar() {
        StringUtilsTest.assertEquals(null, (String)StringUtils.join((Iterator)null, (char)','));
        StringUtilsTest.assertEquals((String)TEXT_LIST_CHAR, (String)StringUtils.join(Arrays.asList(ARRAY_LIST).iterator(), (char)';'));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.join(Arrays.asList(NULL_ARRAY_LIST).iterator(), (char)';'));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.join(Arrays.asList(EMPTY_ARRAY_LIST).iterator(), (char)';'));
        StringUtilsTest.assertEquals((String)FOO_UNCAP, (String)StringUtils.join(Collections.singleton(FOO_UNCAP).iterator(), (char)'x'));
    }

    public void testJoin_IteratorString() {
        StringUtilsTest.assertEquals(null, (String)StringUtils.join((Iterator)null, null));
        StringUtilsTest.assertEquals((String)TEXT_LIST_NOSEP, (String)StringUtils.join(Arrays.asList(ARRAY_LIST).iterator(), null));
        StringUtilsTest.assertEquals((String)TEXT_LIST_NOSEP, (String)StringUtils.join(Arrays.asList(ARRAY_LIST).iterator(), (String)""));
        StringUtilsTest.assertEquals((String)FOO_UNCAP, (String)StringUtils.join(Collections.singleton(FOO_UNCAP).iterator(), (String)"x"));
        StringUtilsTest.assertEquals((String)FOO_UNCAP, (String)StringUtils.join(Collections.singleton(FOO_UNCAP).iterator(), null));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.join(Arrays.asList(NULL_ARRAY_LIST).iterator(), null));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.join(Arrays.asList(EMPTY_ARRAY_LIST).iterator(), null));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.join(Arrays.asList(EMPTY_ARRAY_LIST).iterator(), (String)""));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.join(Arrays.asList(EMPTY_ARRAY_LIST).iterator(), (String)SEPARATOR));
        StringUtilsTest.assertEquals((String)TEXT_LIST, (String)StringUtils.join(Arrays.asList(ARRAY_LIST).iterator(), (String)SEPARATOR));
    }

    public void testJoin_IterableChar() {
        StringUtilsTest.assertEquals(null, (String)StringUtils.join((Iterable)null, (char)','));
        StringUtilsTest.assertEquals((String)TEXT_LIST_CHAR, (String)StringUtils.join(Arrays.asList(ARRAY_LIST), (char)';'));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.join(Arrays.asList(NULL_ARRAY_LIST), (char)';'));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.join(Arrays.asList(EMPTY_ARRAY_LIST), (char)';'));
        StringUtilsTest.assertEquals((String)FOO_UNCAP, (String)StringUtils.join(Collections.singleton(FOO_UNCAP), (char)'x'));
    }

    public void testJoin_IterableString() {
        StringUtilsTest.assertEquals(null, (String)StringUtils.join((Iterable)null, null));
        StringUtilsTest.assertEquals((String)TEXT_LIST_NOSEP, (String)StringUtils.join(Arrays.asList(ARRAY_LIST), null));
        StringUtilsTest.assertEquals((String)TEXT_LIST_NOSEP, (String)StringUtils.join(Arrays.asList(ARRAY_LIST), (String)""));
        StringUtilsTest.assertEquals((String)FOO_UNCAP, (String)StringUtils.join(Collections.singleton(FOO_UNCAP), (String)"x"));
        StringUtilsTest.assertEquals((String)FOO_UNCAP, (String)StringUtils.join(Collections.singleton(FOO_UNCAP), null));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.join(Arrays.asList(NULL_ARRAY_LIST), null));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.join(Arrays.asList(EMPTY_ARRAY_LIST), null));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.join(Arrays.asList(EMPTY_ARRAY_LIST), (String)""));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.join(Arrays.asList(EMPTY_ARRAY_LIST), (String)SEPARATOR));
        StringUtilsTest.assertEquals((String)TEXT_LIST, (String)StringUtils.join(Arrays.asList(ARRAY_LIST), (String)SEPARATOR));
    }

    public void testSplit_String() {
        StringUtilsTest.assertEquals(null, (Object)StringUtils.split(null));
        StringUtilsTest.assertEquals((int)0, (int)StringUtils.split((String)"").length);
        String str = "a b  .c";
        String[] res = StringUtils.split((String)str);
        StringUtilsTest.assertEquals((int)3, (int)res.length);
        StringUtilsTest.assertEquals((String)"a", (String)res[0]);
        StringUtilsTest.assertEquals((String)"b", (String)res[1]);
        StringUtilsTest.assertEquals((String)".c", (String)res[2]);
        str = " a ";
        res = StringUtils.split((String)str);
        StringUtilsTest.assertEquals((int)1, (int)res.length);
        StringUtilsTest.assertEquals((String)"a", (String)res[0]);
        str = "a" + WHITESPACE + "b" + NON_WHITESPACE + "c";
        res = StringUtils.split((String)str);
        StringUtilsTest.assertEquals((int)2, (int)res.length);
        StringUtilsTest.assertEquals((String)"a", (String)res[0]);
        StringUtilsTest.assertEquals((String)("b" + NON_WHITESPACE + "c"), (String)res[1]);
    }

    public void testSplit_StringChar() {
        StringUtilsTest.assertEquals(null, (Object)StringUtils.split(null, (char)'.'));
        StringUtilsTest.assertEquals((int)0, (int)StringUtils.split((String)"", (char)'.').length);
        String str = "a.b.. c";
        String[] res = StringUtils.split((String)str, (char)'.');
        StringUtilsTest.assertEquals((int)3, (int)res.length);
        StringUtilsTest.assertEquals((String)"a", (String)res[0]);
        StringUtilsTest.assertEquals((String)"b", (String)res[1]);
        StringUtilsTest.assertEquals((String)" c", (String)res[2]);
        str = ".a.";
        res = StringUtils.split((String)str, (char)'.');
        StringUtilsTest.assertEquals((int)1, (int)res.length);
        StringUtilsTest.assertEquals((String)"a", (String)res[0]);
        str = "a b c";
        res = StringUtils.split((String)str, (char)' ');
        StringUtilsTest.assertEquals((int)3, (int)res.length);
        StringUtilsTest.assertEquals((String)"a", (String)res[0]);
        StringUtilsTest.assertEquals((String)"b", (String)res[1]);
        StringUtilsTest.assertEquals((String)"c", (String)res[2]);
    }

    public void testSplit_StringString_StringStringInt() {
        StringUtilsTest.assertEquals(null, (Object)StringUtils.split(null, (String)"."));
        StringUtilsTest.assertEquals(null, (Object)StringUtils.split(null, (String)".", (int)3));
        StringUtilsTest.assertEquals((int)0, (int)StringUtils.split((String)"", (String)".").length);
        StringUtilsTest.assertEquals((int)0, (int)StringUtils.split((String)"", (String)".", (int)3).length);
        this.innerTestSplit('.', ".", ' ');
        this.innerTestSplit('.', ".", ',');
        this.innerTestSplit('.', ".,", 'x');
        for (int i = 0; i < WHITESPACE.length(); ++i) {
            for (int j = 0; j < NON_WHITESPACE.length(); ++j) {
                this.innerTestSplit(WHITESPACE.charAt(i), null, NON_WHITESPACE.charAt(j));
                this.innerTestSplit(WHITESPACE.charAt(i), String.valueOf(WHITESPACE.charAt(i)), NON_WHITESPACE.charAt(j));
            }
        }
        String[] expectedResults = new String[]{"ab", "de fg"};
        String[] results = StringUtils.split((String)"ab   de fg", null, (int)2);
        StringUtilsTest.assertEquals((int)expectedResults.length, (int)results.length);
        for (int i = 0; i < expectedResults.length; ++i) {
            StringUtilsTest.assertEquals((String)expectedResults[i], (String)results[i]);
        }
        String[] expectedResults2 = new String[]{"ab", "cd:ef"};
        results = StringUtils.split((String)"ab:cd:ef", (String)":", (int)2);
        StringUtilsTest.assertEquals((int)expectedResults2.length, (int)results.length);
        for (int i = 0; i < expectedResults2.length; ++i) {
            StringUtilsTest.assertEquals((String)expectedResults2[i], (String)results[i]);
        }
    }

    private void innerTestSplit(char separator, String sepStr, char noMatch) {
        String msg = "Failed on separator hex(" + Integer.toHexString(separator) + "), noMatch hex(" + Integer.toHexString(noMatch) + "), sepStr(" + sepStr + ")";
        String str = "a" + separator + "b" + separator + separator + noMatch + "c";
        String[] res = StringUtils.split((String)str, (String)sepStr);
        StringUtilsTest.assertEquals((String)msg, (int)3, (int)res.length);
        StringUtilsTest.assertEquals((String)msg, (String)"a", (String)res[0]);
        StringUtilsTest.assertEquals((String)msg, (String)"b", (String)res[1]);
        StringUtilsTest.assertEquals((String)msg, (String)(noMatch + "c"), (String)res[2]);
        String str2 = separator + "a" + separator;
        res = StringUtils.split((String)str2, (String)sepStr);
        StringUtilsTest.assertEquals((String)msg, (int)1, (int)res.length);
        StringUtilsTest.assertEquals((String)msg, (String)"a", (String)res[0]);
        res = StringUtils.split((String)str, (String)sepStr, (int)-1);
        StringUtilsTest.assertEquals((String)msg, (int)3, (int)res.length);
        StringUtilsTest.assertEquals((String)msg, (String)"a", (String)res[0]);
        StringUtilsTest.assertEquals((String)msg, (String)"b", (String)res[1]);
        StringUtilsTest.assertEquals((String)msg, (String)(noMatch + "c"), (String)res[2]);
        res = StringUtils.split((String)str, (String)sepStr, (int)0);
        StringUtilsTest.assertEquals((String)msg, (int)3, (int)res.length);
        StringUtilsTest.assertEquals((String)msg, (String)"a", (String)res[0]);
        StringUtilsTest.assertEquals((String)msg, (String)"b", (String)res[1]);
        StringUtilsTest.assertEquals((String)msg, (String)(noMatch + "c"), (String)res[2]);
        res = StringUtils.split((String)str, (String)sepStr, (int)1);
        StringUtilsTest.assertEquals((String)msg, (int)1, (int)res.length);
        StringUtilsTest.assertEquals((String)msg, (String)str, (String)res[0]);
        res = StringUtils.split((String)str, (String)sepStr, (int)2);
        StringUtilsTest.assertEquals((String)msg, (int)2, (int)res.length);
        StringUtilsTest.assertEquals((String)msg, (String)"a", (String)res[0]);
        StringUtilsTest.assertEquals((String)msg, (String)str.substring(2), (String)res[1]);
    }

    public void testSplitByWholeString_StringStringBoolean() {
        StringUtilsTest.assertEquals(null, (Object)StringUtils.splitByWholeSeparator(null, (String)"."));
        StringUtilsTest.assertEquals((int)0, (int)StringUtils.splitByWholeSeparator((String)"", (String)".").length);
        String stringToSplitOnNulls = "ab   de fg";
        String[] splitOnNullExpectedResults = new String[]{"ab", "de", "fg"};
        String[] splitOnNullResults = StringUtils.splitByWholeSeparator((String)stringToSplitOnNulls, null);
        StringUtilsTest.assertEquals((int)splitOnNullExpectedResults.length, (int)splitOnNullResults.length);
        for (int i = 0; i < splitOnNullExpectedResults.length; ++i) {
            StringUtilsTest.assertEquals((String)splitOnNullExpectedResults[i], (String)splitOnNullResults[i]);
        }
        String stringToSplitOnCharactersAndString = "abstemiouslyaeiouyabstemiously";
        String[] splitOnStringExpectedResults = new String[]{"abstemiously", "abstemiously"};
        String[] splitOnStringResults = StringUtils.splitByWholeSeparator((String)stringToSplitOnCharactersAndString, (String)"aeiouy");
        StringUtilsTest.assertEquals((int)splitOnStringExpectedResults.length, (int)splitOnStringResults.length);
        for (int i = 0; i < splitOnStringExpectedResults.length; ++i) {
            StringUtilsTest.assertEquals((String)splitOnStringExpectedResults[i], (String)splitOnStringResults[i]);
        }
        String[] splitWithMultipleSeparatorExpectedResults = new String[]{"ab", "cd", "ef"};
        String[] splitWithMultipleSeparator = StringUtils.splitByWholeSeparator((String)"ab:cd::ef", (String)":");
        StringUtilsTest.assertEquals((int)splitWithMultipleSeparatorExpectedResults.length, (int)splitWithMultipleSeparator.length);
        for (int i = 0; i < splitWithMultipleSeparatorExpectedResults.length; ++i) {
            StringUtilsTest.assertEquals((String)splitWithMultipleSeparatorExpectedResults[i], (String)splitWithMultipleSeparator[i]);
        }
    }

    public void testSplitByWholeString_StringStringBooleanInt() {
        StringUtilsTest.assertEquals(null, (Object)StringUtils.splitByWholeSeparator(null, (String)".", (int)3));
        StringUtilsTest.assertEquals((int)0, (int)StringUtils.splitByWholeSeparator((String)"", (String)".", (int)3).length);
        String stringToSplitOnNulls = "ab   de fg";
        String[] splitOnNullExpectedResults = new String[]{"ab", "de fg"};
        String[] splitOnNullResults = StringUtils.splitByWholeSeparator((String)stringToSplitOnNulls, null, (int)2);
        StringUtilsTest.assertEquals((int)splitOnNullExpectedResults.length, (int)splitOnNullResults.length);
        for (int i = 0; i < splitOnNullExpectedResults.length; ++i) {
            StringUtilsTest.assertEquals((String)splitOnNullExpectedResults[i], (String)splitOnNullResults[i]);
        }
        String stringToSplitOnCharactersAndString = "abstemiouslyaeiouyabstemiouslyaeiouyabstemiously";
        String[] splitOnStringExpectedResults = new String[]{"abstemiously", "abstemiouslyaeiouyabstemiously"};
        String[] splitOnStringResults = StringUtils.splitByWholeSeparator((String)stringToSplitOnCharactersAndString, (String)"aeiouy", (int)2);
        StringUtilsTest.assertEquals((int)splitOnStringExpectedResults.length, (int)splitOnStringResults.length);
        for (int i = 0; i < splitOnStringExpectedResults.length; ++i) {
            StringUtilsTest.assertEquals((String)splitOnStringExpectedResults[i], (String)splitOnStringResults[i]);
        }
    }

    public void testSplitByWholeSeparatorPreserveAllTokens_StringStringInt() {
        int i;
        StringUtilsTest.assertEquals(null, (Object)StringUtils.splitByWholeSeparatorPreserveAllTokens(null, (String)".", (int)-1));
        StringUtilsTest.assertEquals((int)0, (int)StringUtils.splitByWholeSeparatorPreserveAllTokens((String)"", (String)".", (int)-1).length);
        String input = "ab   de fg";
        String[] expected = new String[]{"ab", "", "", "de", "fg"};
        String[] actual = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)input, null, (int)-1);
        StringUtilsTest.assertEquals((int)expected.length, (int)actual.length);
        for (i = 0; i < actual.length; ++i) {
            StringUtilsTest.assertEquals((String)expected[i], (String)actual[i]);
        }
        input = "1::2:::3::::4";
        expected = new String[]{"1", "", "2", "", "", "3", "", "", "", "4"};
        actual = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)input, (String)":", (int)-1);
        StringUtilsTest.assertEquals((int)expected.length, (int)actual.length);
        for (i = 0; i < actual.length; ++i) {
            StringUtilsTest.assertEquals((String)expected[i], (String)actual[i]);
        }
        input = "1::2:::3::::4";
        expected = new String[]{"1", "2", ":3", "", "4"};
        actual = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)input, (String)"::", (int)-1);
        StringUtilsTest.assertEquals((int)expected.length, (int)actual.length);
        for (i = 0; i < actual.length; ++i) {
            StringUtilsTest.assertEquals((String)expected[i], (String)actual[i]);
        }
        input = "1::2::3:4";
        expected = new String[]{"1", "", "2", ":3:4"};
        actual = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)input, (String)":", (int)4);
        StringUtilsTest.assertEquals((int)expected.length, (int)actual.length);
        for (i = 0; i < actual.length; ++i) {
            StringUtilsTest.assertEquals((String)expected[i], (String)actual[i]);
        }
    }

    public void testSplitPreserveAllTokens_String() {
        StringUtilsTest.assertEquals(null, (Object)StringUtils.splitPreserveAllTokens(null));
        StringUtilsTest.assertEquals((int)0, (int)StringUtils.splitPreserveAllTokens((String)"").length);
        String str = "abc def";
        String[] res = StringUtils.splitPreserveAllTokens((String)str);
        StringUtilsTest.assertEquals((int)2, (int)res.length);
        StringUtilsTest.assertEquals((String)"abc", (String)res[0]);
        StringUtilsTest.assertEquals((String)"def", (String)res[1]);
        str = "abc  def";
        res = StringUtils.splitPreserveAllTokens((String)str);
        StringUtilsTest.assertEquals((int)3, (int)res.length);
        StringUtilsTest.assertEquals((String)"abc", (String)res[0]);
        StringUtilsTest.assertEquals((String)"", (String)res[1]);
        StringUtilsTest.assertEquals((String)"def", (String)res[2]);
        str = " abc ";
        res = StringUtils.splitPreserveAllTokens((String)str);
        StringUtilsTest.assertEquals((int)3, (int)res.length);
        StringUtilsTest.assertEquals((String)"", (String)res[0]);
        StringUtilsTest.assertEquals((String)"abc", (String)res[1]);
        StringUtilsTest.assertEquals((String)"", (String)res[2]);
        str = "a b .c";
        res = StringUtils.splitPreserveAllTokens((String)str);
        StringUtilsTest.assertEquals((int)3, (int)res.length);
        StringUtilsTest.assertEquals((String)"a", (String)res[0]);
        StringUtilsTest.assertEquals((String)"b", (String)res[1]);
        StringUtilsTest.assertEquals((String)".c", (String)res[2]);
        str = " a b .c";
        res = StringUtils.splitPreserveAllTokens((String)str);
        StringUtilsTest.assertEquals((int)4, (int)res.length);
        StringUtilsTest.assertEquals((String)"", (String)res[0]);
        StringUtilsTest.assertEquals((String)"a", (String)res[1]);
        StringUtilsTest.assertEquals((String)"b", (String)res[2]);
        StringUtilsTest.assertEquals((String)".c", (String)res[3]);
        str = "a  b  .c";
        res = StringUtils.splitPreserveAllTokens((String)str);
        StringUtilsTest.assertEquals((int)5, (int)res.length);
        StringUtilsTest.assertEquals((String)"a", (String)res[0]);
        StringUtilsTest.assertEquals((String)"", (String)res[1]);
        StringUtilsTest.assertEquals((String)"b", (String)res[2]);
        StringUtilsTest.assertEquals((String)"", (String)res[3]);
        StringUtilsTest.assertEquals((String)".c", (String)res[4]);
        str = " a  ";
        res = StringUtils.splitPreserveAllTokens((String)str);
        StringUtilsTest.assertEquals((int)4, (int)res.length);
        StringUtilsTest.assertEquals((String)"", (String)res[0]);
        StringUtilsTest.assertEquals((String)"a", (String)res[1]);
        StringUtilsTest.assertEquals((String)"", (String)res[2]);
        StringUtilsTest.assertEquals((String)"", (String)res[3]);
        str = " a  b";
        res = StringUtils.splitPreserveAllTokens((String)str);
        StringUtilsTest.assertEquals((int)4, (int)res.length);
        StringUtilsTest.assertEquals((String)"", (String)res[0]);
        StringUtilsTest.assertEquals((String)"a", (String)res[1]);
        StringUtilsTest.assertEquals((String)"", (String)res[2]);
        StringUtilsTest.assertEquals((String)"b", (String)res[3]);
        str = "a" + WHITESPACE + "b" + NON_WHITESPACE + "c";
        res = StringUtils.splitPreserveAllTokens((String)str);
        StringUtilsTest.assertEquals((int)(WHITESPACE.length() + 1), (int)res.length);
        StringUtilsTest.assertEquals((String)"a", (String)res[0]);
        for (int i = 1; i < WHITESPACE.length() - 1; ++i) {
            StringUtilsTest.assertEquals((String)"", (String)res[i]);
        }
        StringUtilsTest.assertEquals((String)("b" + NON_WHITESPACE + "c"), (String)res[WHITESPACE.length()]);
    }

    public void testSplitPreserveAllTokens_StringChar() {
        StringUtilsTest.assertEquals(null, (Object)StringUtils.splitPreserveAllTokens(null, (char)'.'));
        StringUtilsTest.assertEquals((int)0, (int)StringUtils.splitPreserveAllTokens((String)"", (char)'.').length);
        String str = "a.b. c";
        String[] res = StringUtils.splitPreserveAllTokens((String)str, (char)'.');
        StringUtilsTest.assertEquals((int)3, (int)res.length);
        StringUtilsTest.assertEquals((String)"a", (String)res[0]);
        StringUtilsTest.assertEquals((String)"b", (String)res[1]);
        StringUtilsTest.assertEquals((String)" c", (String)res[2]);
        str = "a.b.. c";
        res = StringUtils.splitPreserveAllTokens((String)str, (char)'.');
        StringUtilsTest.assertEquals((int)4, (int)res.length);
        StringUtilsTest.assertEquals((String)"a", (String)res[0]);
        StringUtilsTest.assertEquals((String)"b", (String)res[1]);
        StringUtilsTest.assertEquals((String)"", (String)res[2]);
        StringUtilsTest.assertEquals((String)" c", (String)res[3]);
        str = ".a.";
        res = StringUtils.splitPreserveAllTokens((String)str, (char)'.');
        StringUtilsTest.assertEquals((int)3, (int)res.length);
        StringUtilsTest.assertEquals((String)"", (String)res[0]);
        StringUtilsTest.assertEquals((String)"a", (String)res[1]);
        StringUtilsTest.assertEquals((String)"", (String)res[2]);
        str = ".a..";
        res = StringUtils.splitPreserveAllTokens((String)str, (char)'.');
        StringUtilsTest.assertEquals((int)4, (int)res.length);
        StringUtilsTest.assertEquals((String)"", (String)res[0]);
        StringUtilsTest.assertEquals((String)"a", (String)res[1]);
        StringUtilsTest.assertEquals((String)"", (String)res[2]);
        StringUtilsTest.assertEquals((String)"", (String)res[3]);
        str = "..a.";
        res = StringUtils.splitPreserveAllTokens((String)str, (char)'.');
        StringUtilsTest.assertEquals((int)4, (int)res.length);
        StringUtilsTest.assertEquals((String)"", (String)res[0]);
        StringUtilsTest.assertEquals((String)"", (String)res[1]);
        StringUtilsTest.assertEquals((String)"a", (String)res[2]);
        StringUtilsTest.assertEquals((String)"", (String)res[3]);
        str = "..a";
        res = StringUtils.splitPreserveAllTokens((String)str, (char)'.');
        StringUtilsTest.assertEquals((int)3, (int)res.length);
        StringUtilsTest.assertEquals((String)"", (String)res[0]);
        StringUtilsTest.assertEquals((String)"", (String)res[1]);
        StringUtilsTest.assertEquals((String)"a", (String)res[2]);
        str = "a b c";
        res = StringUtils.splitPreserveAllTokens((String)str, (char)' ');
        StringUtilsTest.assertEquals((int)3, (int)res.length);
        StringUtilsTest.assertEquals((String)"a", (String)res[0]);
        StringUtilsTest.assertEquals((String)"b", (String)res[1]);
        StringUtilsTest.assertEquals((String)"c", (String)res[2]);
        str = "a  b  c";
        res = StringUtils.splitPreserveAllTokens((String)str, (char)' ');
        StringUtilsTest.assertEquals((int)5, (int)res.length);
        StringUtilsTest.assertEquals((String)"a", (String)res[0]);
        StringUtilsTest.assertEquals((String)"", (String)res[1]);
        StringUtilsTest.assertEquals((String)"b", (String)res[2]);
        StringUtilsTest.assertEquals((String)"", (String)res[3]);
        StringUtilsTest.assertEquals((String)"c", (String)res[4]);
        str = " a b c";
        res = StringUtils.splitPreserveAllTokens((String)str, (char)' ');
        StringUtilsTest.assertEquals((int)4, (int)res.length);
        StringUtilsTest.assertEquals((String)"", (String)res[0]);
        StringUtilsTest.assertEquals((String)"a", (String)res[1]);
        StringUtilsTest.assertEquals((String)"b", (String)res[2]);
        StringUtilsTest.assertEquals((String)"c", (String)res[3]);
        str = "  a b c";
        res = StringUtils.splitPreserveAllTokens((String)str, (char)' ');
        StringUtilsTest.assertEquals((int)5, (int)res.length);
        StringUtilsTest.assertEquals((String)"", (String)res[0]);
        StringUtilsTest.assertEquals((String)"", (String)res[1]);
        StringUtilsTest.assertEquals((String)"a", (String)res[2]);
        StringUtilsTest.assertEquals((String)"b", (String)res[3]);
        StringUtilsTest.assertEquals((String)"c", (String)res[4]);
        str = "a b c ";
        res = StringUtils.splitPreserveAllTokens((String)str, (char)' ');
        StringUtilsTest.assertEquals((int)4, (int)res.length);
        StringUtilsTest.assertEquals((String)"a", (String)res[0]);
        StringUtilsTest.assertEquals((String)"b", (String)res[1]);
        StringUtilsTest.assertEquals((String)"c", (String)res[2]);
        StringUtilsTest.assertEquals((String)"", (String)res[3]);
        str = "a b c  ";
        res = StringUtils.splitPreserveAllTokens((String)str, (char)' ');
        StringUtilsTest.assertEquals((int)5, (int)res.length);
        StringUtilsTest.assertEquals((String)"a", (String)res[0]);
        StringUtilsTest.assertEquals((String)"b", (String)res[1]);
        StringUtilsTest.assertEquals((String)"c", (String)res[2]);
        StringUtilsTest.assertEquals((String)"", (String)res[3]);
        StringUtilsTest.assertEquals((String)"", (String)res[3]);
        String[] expectedResults = new String[]{"a", "", "b", "c"};
        String[] results = StringUtils.splitPreserveAllTokens((String)"a..b.c", (char)'.');
        StringUtilsTest.assertEquals((int)expectedResults.length, (int)results.length);
        for (int i = 0; i < expectedResults.length; ++i) {
            StringUtilsTest.assertEquals((String)expectedResults[i], (String)results[i]);
        }
    }

    public void testSplitPreserveAllTokens_StringString_StringStringInt() {
        int i;
        StringUtilsTest.assertEquals(null, (Object)StringUtils.splitPreserveAllTokens(null, (String)"."));
        StringUtilsTest.assertEquals(null, (Object)StringUtils.splitPreserveAllTokens(null, (String)".", (int)3));
        StringUtilsTest.assertEquals((int)0, (int)StringUtils.splitPreserveAllTokens((String)"", (String)".").length);
        StringUtilsTest.assertEquals((int)0, (int)StringUtils.splitPreserveAllTokens((String)"", (String)".", (int)3).length);
        this.innerTestSplitPreserveAllTokens('.', ".", ' ');
        this.innerTestSplitPreserveAllTokens('.', ".", ',');
        this.innerTestSplitPreserveAllTokens('.', ".,", 'x');
        for (int i2 = 0; i2 < WHITESPACE.length(); ++i2) {
            for (int j = 0; j < NON_WHITESPACE.length(); ++j) {
                this.innerTestSplitPreserveAllTokens(WHITESPACE.charAt(i2), null, NON_WHITESPACE.charAt(j));
                this.innerTestSplitPreserveAllTokens(WHITESPACE.charAt(i2), String.valueOf(WHITESPACE.charAt(i2)), NON_WHITESPACE.charAt(j));
            }
        }
        String[] expectedResults = new String[]{"ab", "de fg"};
        String[] results = StringUtils.splitPreserveAllTokens((String)"ab de fg", null, (int)2);
        StringUtilsTest.assertEquals((int)expectedResults.length, (int)results.length);
        for (i = 0; i < expectedResults.length; ++i) {
            StringUtilsTest.assertEquals((String)expectedResults[i], (String)results[i]);
        }
        expectedResults = new String[]{"ab", "  de fg"};
        results = StringUtils.splitPreserveAllTokens((String)"ab   de fg", null, (int)2);
        StringUtilsTest.assertEquals((int)expectedResults.length, (int)results.length);
        for (i = 0; i < expectedResults.length; ++i) {
            StringUtilsTest.assertEquals((String)expectedResults[i], (String)results[i]);
        }
        expectedResults = new String[]{"ab", "::de:fg"};
        results = StringUtils.splitPreserveAllTokens((String)"ab:::de:fg", (String)":", (int)2);
        StringUtilsTest.assertEquals((int)expectedResults.length, (int)results.length);
        for (i = 0; i < expectedResults.length; ++i) {
            StringUtilsTest.assertEquals((String)expectedResults[i], (String)results[i]);
        }
        expectedResults = new String[]{"ab", "", " de fg"};
        results = StringUtils.splitPreserveAllTokens((String)"ab   de fg", null, (int)3);
        StringUtilsTest.assertEquals((int)expectedResults.length, (int)results.length);
        for (i = 0; i < expectedResults.length; ++i) {
            StringUtilsTest.assertEquals((String)expectedResults[i], (String)results[i]);
        }
        expectedResults = new String[]{"ab", "", "", "de fg"};
        results = StringUtils.splitPreserveAllTokens((String)"ab   de fg", null, (int)4);
        StringUtilsTest.assertEquals((int)expectedResults.length, (int)results.length);
        for (i = 0; i < expectedResults.length; ++i) {
            StringUtilsTest.assertEquals((String)expectedResults[i], (String)results[i]);
        }
        String[] expectedResults2 = new String[]{"ab", "cd:ef"};
        String[] results2 = StringUtils.splitPreserveAllTokens((String)"ab:cd:ef", (String)":", (int)2);
        StringUtilsTest.assertEquals((int)expectedResults2.length, (int)results2.length);
        for (i = 0; i < expectedResults2.length; ++i) {
            StringUtilsTest.assertEquals((String)expectedResults2[i], (String)results2[i]);
        }
        expectedResults = new String[]{"ab", ":cd:ef"};
        results = StringUtils.splitPreserveAllTokens((String)"ab::cd:ef", (String)":", (int)2);
        StringUtilsTest.assertEquals((int)expectedResults.length, (int)results.length);
        for (i = 0; i < expectedResults.length; ++i) {
            StringUtilsTest.assertEquals((String)expectedResults[i], (String)results[i]);
        }
        expectedResults = new String[]{"ab", "", ":cd:ef"};
        results = StringUtils.splitPreserveAllTokens((String)"ab:::cd:ef", (String)":", (int)3);
        StringUtilsTest.assertEquals((int)expectedResults.length, (int)results.length);
        for (i = 0; i < expectedResults.length; ++i) {
            StringUtilsTest.assertEquals((String)expectedResults[i], (String)results[i]);
        }
        expectedResults = new String[]{"ab", "", "", "cd:ef"};
        results = StringUtils.splitPreserveAllTokens((String)"ab:::cd:ef", (String)":", (int)4);
        StringUtilsTest.assertEquals((int)expectedResults.length, (int)results.length);
        for (i = 0; i < expectedResults.length; ++i) {
            StringUtilsTest.assertEquals((String)expectedResults[i], (String)results[i]);
        }
        expectedResults = new String[]{"", "ab", "", "", "cd:ef"};
        results = StringUtils.splitPreserveAllTokens((String)":ab:::cd:ef", (String)":", (int)5);
        StringUtilsTest.assertEquals((int)expectedResults.length, (int)results.length);
        for (i = 0; i < expectedResults.length; ++i) {
            StringUtilsTest.assertEquals((String)expectedResults[i], (String)results[i]);
        }
        expectedResults = new String[]{"", "", "ab", "", "", "cd:ef"};
        results = StringUtils.splitPreserveAllTokens((String)"::ab:::cd:ef", (String)":", (int)6);
        StringUtilsTest.assertEquals((int)expectedResults.length, (int)results.length);
        for (i = 0; i < expectedResults.length; ++i) {
            StringUtilsTest.assertEquals((String)expectedResults[i], (String)results[i]);
        }
    }

    private void innerTestSplitPreserveAllTokens(char separator, String sepStr, char noMatch) {
        String msg = "Failed on separator hex(" + Integer.toHexString(separator) + "), noMatch hex(" + Integer.toHexString(noMatch) + "), sepStr(" + sepStr + ")";
        String str = "a" + separator + "b" + separator + separator + noMatch + "c";
        String[] res = StringUtils.splitPreserveAllTokens((String)str, (String)sepStr);
        StringUtilsTest.assertEquals((String)msg, (int)4, (int)res.length);
        StringUtilsTest.assertEquals((String)msg, (String)"a", (String)res[0]);
        StringUtilsTest.assertEquals((String)msg, (String)"b", (String)res[1]);
        StringUtilsTest.assertEquals((String)msg, (String)"", (String)res[2]);
        StringUtilsTest.assertEquals((String)msg, (String)(noMatch + "c"), (String)res[3]);
        String str2 = separator + "a" + separator;
        res = StringUtils.splitPreserveAllTokens((String)str2, (String)sepStr);
        StringUtilsTest.assertEquals((String)msg, (int)3, (int)res.length);
        StringUtilsTest.assertEquals((String)msg, (String)"", (String)res[0]);
        StringUtilsTest.assertEquals((String)msg, (String)"a", (String)res[1]);
        StringUtilsTest.assertEquals((String)msg, (String)"", (String)res[2]);
        res = StringUtils.splitPreserveAllTokens((String)str, (String)sepStr, (int)-1);
        StringUtilsTest.assertEquals((String)msg, (int)4, (int)res.length);
        StringUtilsTest.assertEquals((String)msg, (String)"a", (String)res[0]);
        StringUtilsTest.assertEquals((String)msg, (String)"b", (String)res[1]);
        StringUtilsTest.assertEquals((String)msg, (String)"", (String)res[2]);
        StringUtilsTest.assertEquals((String)msg, (String)(noMatch + "c"), (String)res[3]);
        res = StringUtils.splitPreserveAllTokens((String)str, (String)sepStr, (int)0);
        StringUtilsTest.assertEquals((String)msg, (int)4, (int)res.length);
        StringUtilsTest.assertEquals((String)msg, (String)"a", (String)res[0]);
        StringUtilsTest.assertEquals((String)msg, (String)"b", (String)res[1]);
        StringUtilsTest.assertEquals((String)msg, (String)"", (String)res[2]);
        StringUtilsTest.assertEquals((String)msg, (String)(noMatch + "c"), (String)res[3]);
        res = StringUtils.splitPreserveAllTokens((String)str, (String)sepStr, (int)1);
        StringUtilsTest.assertEquals((String)msg, (int)1, (int)res.length);
        StringUtilsTest.assertEquals((String)msg, (String)str, (String)res[0]);
        res = StringUtils.splitPreserveAllTokens((String)str, (String)sepStr, (int)2);
        StringUtilsTest.assertEquals((String)msg, (int)2, (int)res.length);
        StringUtilsTest.assertEquals((String)msg, (String)"a", (String)res[0]);
        StringUtilsTest.assertEquals((String)msg, (String)str.substring(2), (String)res[1]);
    }

    public void testSplitByCharacterType() {
        StringUtilsTest.assertNull((Object)StringUtils.splitByCharacterType(null));
        StringUtilsTest.assertEquals((int)0, (int)StringUtils.splitByCharacterType((String)"").length);
        StringUtilsTest.assertTrue((boolean)ArrayUtils.isEquals((Object)new String[]{"ab", " ", "de", " ", "fg"}, (Object)StringUtils.splitByCharacterType((String)"ab de fg")));
        StringUtilsTest.assertTrue((boolean)ArrayUtils.isEquals((Object)new String[]{"ab", "   ", "de", " ", "fg"}, (Object)StringUtils.splitByCharacterType((String)"ab   de fg")));
        StringUtilsTest.assertTrue((boolean)ArrayUtils.isEquals((Object)new String[]{"ab", ":", "cd", ":", "ef"}, (Object)StringUtils.splitByCharacterType((String)"ab:cd:ef")));
        StringUtilsTest.assertTrue((boolean)ArrayUtils.isEquals((Object)new String[]{"number", "5"}, (Object)StringUtils.splitByCharacterType((String)"number5")));
        StringUtilsTest.assertTrue((boolean)ArrayUtils.isEquals((Object)new String[]{FOO_UNCAP, "B", "ar"}, (Object)StringUtils.splitByCharacterType((String)"fooBar")));
        StringUtilsTest.assertTrue((boolean)ArrayUtils.isEquals((Object)new String[]{FOO_UNCAP, "200", "B", "ar"}, (Object)StringUtils.splitByCharacterType((String)"foo200Bar")));
        StringUtilsTest.assertTrue((boolean)ArrayUtils.isEquals((Object)new String[]{"ASFR", "ules"}, (Object)StringUtils.splitByCharacterType((String)"ASFRules")));
    }

    public void testSplitByCharacterTypeCamelCase() {
        StringUtilsTest.assertNull((Object)StringUtils.splitByCharacterTypeCamelCase(null));
        StringUtilsTest.assertEquals((int)0, (int)StringUtils.splitByCharacterTypeCamelCase((String)"").length);
        StringUtilsTest.assertTrue((boolean)ArrayUtils.isEquals((Object)new String[]{"ab", " ", "de", " ", "fg"}, (Object)StringUtils.splitByCharacterTypeCamelCase((String)"ab de fg")));
        StringUtilsTest.assertTrue((boolean)ArrayUtils.isEquals((Object)new String[]{"ab", "   ", "de", " ", "fg"}, (Object)StringUtils.splitByCharacterTypeCamelCase((String)"ab   de fg")));
        StringUtilsTest.assertTrue((boolean)ArrayUtils.isEquals((Object)new String[]{"ab", ":", "cd", ":", "ef"}, (Object)StringUtils.splitByCharacterTypeCamelCase((String)"ab:cd:ef")));
        StringUtilsTest.assertTrue((boolean)ArrayUtils.isEquals((Object)new String[]{"number", "5"}, (Object)StringUtils.splitByCharacterTypeCamelCase((String)"number5")));
        StringUtilsTest.assertTrue((boolean)ArrayUtils.isEquals((Object)new String[]{FOO_UNCAP, "Bar"}, (Object)StringUtils.splitByCharacterTypeCamelCase((String)"fooBar")));
        StringUtilsTest.assertTrue((boolean)ArrayUtils.isEquals((Object)new String[]{FOO_UNCAP, "200", "Bar"}, (Object)StringUtils.splitByCharacterTypeCamelCase((String)"foo200Bar")));
        StringUtilsTest.assertTrue((boolean)ArrayUtils.isEquals((Object)new String[]{"ASF", "Rules"}, (Object)StringUtils.splitByCharacterTypeCamelCase((String)"ASFRules")));
    }

    public void testDeleteWhitespace_String() {
        StringUtilsTest.assertEquals(null, (String)StringUtils.deleteWhitespace(null));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.deleteWhitespace((String)""));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.deleteWhitespace((String)"  \f  \t\t\u001f\n\n \u000b  "));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.deleteWhitespace((String)WHITESPACE));
        StringUtilsTest.assertEquals((String)NON_WHITESPACE, (String)StringUtils.deleteWhitespace((String)NON_WHITESPACE));
        StringUtilsTest.assertEquals((String)"\u00a0\u202f", (String)StringUtils.deleteWhitespace((String)"  \u00a0  \t\t\n\n \u202f  "));
        StringUtilsTest.assertEquals((String)"\u00a0\u202f", (String)StringUtils.deleteWhitespace((String)"\u00a0\u202f"));
        StringUtilsTest.assertEquals((String)"test", (String)StringUtils.deleteWhitespace((String)"\u000bt  \t\n\te\rs\n\n   \tt"));
    }

    public void testLang623() {
        StringUtilsTest.assertEquals((String)"t", (String)StringUtils.replaceChars((String)"\u00de", (char)'\u00de', (char)'t'));
        StringUtilsTest.assertEquals((String)"t", (String)StringUtils.replaceChars((String)"\u00fe", (char)'\u00fe', (char)'t'));
    }

    public void testReplace_StringStringString() {
        StringUtilsTest.assertEquals(null, (String)StringUtils.replace(null, null, null));
        StringUtilsTest.assertEquals(null, (String)StringUtils.replace(null, null, (String)"any"));
        StringUtilsTest.assertEquals(null, (String)StringUtils.replace(null, (String)"any", null));
        StringUtilsTest.assertEquals(null, (String)StringUtils.replace(null, (String)"any", (String)"any"));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.replace((String)"", null, null));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.replace((String)"", null, (String)"any"));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.replace((String)"", (String)"any", null));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.replace((String)"", (String)"any", (String)"any"));
        StringUtilsTest.assertEquals((String)"FOO", (String)StringUtils.replace((String)"FOO", (String)"", (String)"any"));
        StringUtilsTest.assertEquals((String)"FOO", (String)StringUtils.replace((String)"FOO", null, (String)"any"));
        StringUtilsTest.assertEquals((String)"FOO", (String)StringUtils.replace((String)"FOO", (String)"F", null));
        StringUtilsTest.assertEquals((String)"FOO", (String)StringUtils.replace((String)"FOO", null, null));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.replace((String)"foofoofoo", (String)FOO_UNCAP, (String)""));
        StringUtilsTest.assertEquals((String)"barbarbar", (String)StringUtils.replace((String)"foofoofoo", (String)FOO_UNCAP, (String)"bar"));
        StringUtilsTest.assertEquals((String)"farfarfar", (String)StringUtils.replace((String)"foofoofoo", (String)"oo", (String)"ar"));
    }

    public void testReplace_StringStringStringInt() {
        StringUtilsTest.assertEquals(null, (String)StringUtils.replace(null, null, null, (int)2));
        StringUtilsTest.assertEquals(null, (String)StringUtils.replace(null, null, (String)"any", (int)2));
        StringUtilsTest.assertEquals(null, (String)StringUtils.replace(null, (String)"any", null, (int)2));
        StringUtilsTest.assertEquals(null, (String)StringUtils.replace(null, (String)"any", (String)"any", (int)2));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.replace((String)"", null, null, (int)2));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.replace((String)"", null, (String)"any", (int)2));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.replace((String)"", (String)"any", null, (int)2));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.replace((String)"", (String)"any", (String)"any", (int)2));
        String str = new String(new char[]{'o', 'o', 'f', 'o', 'o'});
        StringUtilsTest.assertSame((Object)str, (Object)StringUtils.replace((String)str, (String)"x", (String)"", (int)-1));
        StringUtilsTest.assertEquals((String)"f", (String)StringUtils.replace((String)"oofoo", (String)"o", (String)"", (int)-1));
        StringUtilsTest.assertEquals((String)"oofoo", (String)StringUtils.replace((String)"oofoo", (String)"o", (String)"", (int)0));
        StringUtilsTest.assertEquals((String)"ofoo", (String)StringUtils.replace((String)"oofoo", (String)"o", (String)"", (int)1));
        StringUtilsTest.assertEquals((String)FOO_UNCAP, (String)StringUtils.replace((String)"oofoo", (String)"o", (String)"", (int)2));
        StringUtilsTest.assertEquals((String)"fo", (String)StringUtils.replace((String)"oofoo", (String)"o", (String)"", (int)3));
        StringUtilsTest.assertEquals((String)"f", (String)StringUtils.replace((String)"oofoo", (String)"o", (String)"", (int)4));
        StringUtilsTest.assertEquals((String)"f", (String)StringUtils.replace((String)"oofoo", (String)"o", (String)"", (int)-5));
        StringUtilsTest.assertEquals((String)"f", (String)StringUtils.replace((String)"oofoo", (String)"o", (String)"", (int)1000));
    }

    public void testReplaceOnce_StringStringString() {
        StringUtilsTest.assertEquals(null, (String)StringUtils.replaceOnce(null, null, null));
        StringUtilsTest.assertEquals(null, (String)StringUtils.replaceOnce(null, null, (String)"any"));
        StringUtilsTest.assertEquals(null, (String)StringUtils.replaceOnce(null, (String)"any", null));
        StringUtilsTest.assertEquals(null, (String)StringUtils.replaceOnce(null, (String)"any", (String)"any"));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.replaceOnce((String)"", null, null));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.replaceOnce((String)"", null, (String)"any"));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.replaceOnce((String)"", (String)"any", null));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.replaceOnce((String)"", (String)"any", (String)"any"));
        StringUtilsTest.assertEquals((String)"FOO", (String)StringUtils.replaceOnce((String)"FOO", (String)"", (String)"any"));
        StringUtilsTest.assertEquals((String)"FOO", (String)StringUtils.replaceOnce((String)"FOO", null, (String)"any"));
        StringUtilsTest.assertEquals((String)"FOO", (String)StringUtils.replaceOnce((String)"FOO", (String)"F", null));
        StringUtilsTest.assertEquals((String)"FOO", (String)StringUtils.replaceOnce((String)"FOO", null, null));
        StringUtilsTest.assertEquals((String)"foofoo", (String)StringUtils.replaceOnce((String)"foofoofoo", (String)FOO_UNCAP, (String)""));
    }

    public void testReplace_StringStringArrayStringArray() {
        StringUtilsTest.assertNull((Object)StringUtils.replaceEach(null, (String[])new String[]{"a"}, (String[])new String[]{"b"}));
        StringUtilsTest.assertEquals((String)StringUtils.replaceEach((String)"", (String[])new String[]{"a"}, (String[])new String[]{"b"}), (String)"");
        StringUtilsTest.assertEquals((String)StringUtils.replaceEach((String)"aba", null, null), (String)"aba");
        StringUtilsTest.assertEquals((String)StringUtils.replaceEach((String)"aba", (String[])new String[0], null), (String)"aba");
        StringUtilsTest.assertEquals((String)StringUtils.replaceEach((String)"aba", null, (String[])new String[0]), (String)"aba");
        StringUtilsTest.assertEquals((String)StringUtils.replaceEach((String)"aba", (String[])new String[]{"a"}, null), (String)"aba");
        StringUtilsTest.assertEquals((String)StringUtils.replaceEach((String)"aba", (String[])new String[]{"a"}, (String[])new String[]{""}), (String)"b");
        StringUtilsTest.assertEquals((String)StringUtils.replaceEach((String)"aba", (String[])new String[]{null}, (String[])new String[]{"a"}), (String)"aba");
        StringUtilsTest.assertEquals((String)StringUtils.replaceEach((String)"abcde", (String[])new String[]{"ab", "d"}, (String[])new String[]{"w", "t"}), (String)"wcte");
        StringUtilsTest.assertEquals((String)StringUtils.replaceEach((String)"abcde", (String[])new String[]{"ab", "d"}, (String[])new String[]{"d", "t"}), (String)"dcte");
        StringUtilsTest.assertEquals((String)"bcc", (String)StringUtils.replaceEach((String)"abc", (String[])new String[]{"a", "b"}, (String[])new String[]{"b", "c"}));
        StringUtilsTest.assertEquals((String)"q651.506bera", (String)StringUtils.replaceEach((String)"d216.102oren", (String[])new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "1", "2", "3", "4", "5", "6", "7", "8", "9"}, (String[])new String[]{"n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "5", "6", "7", "8", "9", "1", "2", "3", "4"}));
        StringUtilsTest.assertEquals((String)StringUtils.replaceEach((String)"aba", (String[])new String[]{"a"}, (String[])new String[]{null}), (String)"aba");
        StringUtilsTest.assertEquals((String)StringUtils.replaceEach((String)"aba", (String[])new String[]{"a", "b"}, (String[])new String[]{"c", null}), (String)"cbc");
    }

    public void testReplace_StringStringArrayStringArrayBoolean() {
        StringUtilsTest.assertNull((Object)StringUtils.replaceEachRepeatedly(null, (String[])new String[]{"a"}, (String[])new String[]{"b"}));
        StringUtilsTest.assertEquals((String)StringUtils.replaceEachRepeatedly((String)"", (String[])new String[]{"a"}, (String[])new String[]{"b"}), (String)"");
        StringUtilsTest.assertEquals((String)StringUtils.replaceEachRepeatedly((String)"aba", null, null), (String)"aba");
        StringUtilsTest.assertEquals((String)StringUtils.replaceEachRepeatedly((String)"aba", (String[])new String[0], null), (String)"aba");
        StringUtilsTest.assertEquals((String)StringUtils.replaceEachRepeatedly((String)"aba", null, (String[])new String[0]), (String)"aba");
        StringUtilsTest.assertEquals((String)StringUtils.replaceEachRepeatedly((String)"aba", (String[])new String[0], null), (String)"aba");
        StringUtilsTest.assertEquals((String)StringUtils.replaceEachRepeatedly((String)"aba", (String[])new String[]{"a"}, (String[])new String[]{""}), (String)"b");
        StringUtilsTest.assertEquals((String)StringUtils.replaceEachRepeatedly((String)"aba", (String[])new String[]{null}, (String[])new String[]{"a"}), (String)"aba");
        StringUtilsTest.assertEquals((String)StringUtils.replaceEachRepeatedly((String)"abcde", (String[])new String[]{"ab", "d"}, (String[])new String[]{"w", "t"}), (String)"wcte");
        StringUtilsTest.assertEquals((String)StringUtils.replaceEachRepeatedly((String)"abcde", (String[])new String[]{"ab", "d"}, (String[])new String[]{"d", "t"}), (String)"tcte");
        try {
            StringUtils.replaceEachRepeatedly((String)"abcde", (String[])new String[]{"ab", "d"}, (String[])new String[]{"d", "ab"});
            StringUtilsTest.fail((String)"Should be a circular reference");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testReplaceChars_StringCharChar() {
        StringUtilsTest.assertEquals(null, (String)StringUtils.replaceChars(null, (char)'b', (char)'z'));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.replaceChars((String)"", (char)'b', (char)'z'));
        StringUtilsTest.assertEquals((String)"azcza", (String)StringUtils.replaceChars((String)"abcba", (char)'b', (char)'z'));
        StringUtilsTest.assertEquals((String)"abcba", (String)StringUtils.replaceChars((String)"abcba", (char)'x', (char)'z'));
    }

    public void testReplaceChars_StringStringString() {
        StringUtilsTest.assertEquals(null, (String)StringUtils.replaceChars(null, null, null));
        StringUtilsTest.assertEquals(null, (String)StringUtils.replaceChars(null, (String)"", null));
        StringUtilsTest.assertEquals(null, (String)StringUtils.replaceChars(null, (String)"a", null));
        StringUtilsTest.assertEquals(null, (String)StringUtils.replaceChars(null, null, (String)""));
        StringUtilsTest.assertEquals(null, (String)StringUtils.replaceChars(null, null, (String)"x"));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.replaceChars((String)"", null, null));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.replaceChars((String)"", (String)"", null));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.replaceChars((String)"", (String)"a", null));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.replaceChars((String)"", null, (String)""));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.replaceChars((String)"", null, (String)"x"));
        StringUtilsTest.assertEquals((String)"abc", (String)StringUtils.replaceChars((String)"abc", null, null));
        StringUtilsTest.assertEquals((String)"abc", (String)StringUtils.replaceChars((String)"abc", null, (String)""));
        StringUtilsTest.assertEquals((String)"abc", (String)StringUtils.replaceChars((String)"abc", null, (String)"x"));
        StringUtilsTest.assertEquals((String)"abc", (String)StringUtils.replaceChars((String)"abc", (String)"", null));
        StringUtilsTest.assertEquals((String)"abc", (String)StringUtils.replaceChars((String)"abc", (String)"", (String)""));
        StringUtilsTest.assertEquals((String)"abc", (String)StringUtils.replaceChars((String)"abc", (String)"", (String)"x"));
        StringUtilsTest.assertEquals((String)"ac", (String)StringUtils.replaceChars((String)"abc", (String)"b", null));
        StringUtilsTest.assertEquals((String)"ac", (String)StringUtils.replaceChars((String)"abc", (String)"b", (String)""));
        StringUtilsTest.assertEquals((String)"axc", (String)StringUtils.replaceChars((String)"abc", (String)"b", (String)"x"));
        StringUtilsTest.assertEquals((String)"ayzya", (String)StringUtils.replaceChars((String)"abcba", (String)"bc", (String)"yz"));
        StringUtilsTest.assertEquals((String)"ayya", (String)StringUtils.replaceChars((String)"abcba", (String)"bc", (String)"y"));
        StringUtilsTest.assertEquals((String)"ayzya", (String)StringUtils.replaceChars((String)"abcba", (String)"bc", (String)"yzx"));
        StringUtilsTest.assertEquals((String)"abcba", (String)StringUtils.replaceChars((String)"abcba", (String)"z", (String)"w"));
        StringUtilsTest.assertSame((Object)"abcba", (Object)StringUtils.replaceChars((String)"abcba", (String)"z", (String)"w"));
        StringUtilsTest.assertEquals((String)"jelly", (String)StringUtils.replaceChars((String)"hello", (String)"ho", (String)"jy"));
        StringUtilsTest.assertEquals((String)"ayzya", (String)StringUtils.replaceChars((String)"abcba", (String)"bc", (String)"yz"));
        StringUtilsTest.assertEquals((String)"ayya", (String)StringUtils.replaceChars((String)"abcba", (String)"bc", (String)"y"));
        StringUtilsTest.assertEquals((String)"ayzya", (String)StringUtils.replaceChars((String)"abcba", (String)"bc", (String)"yzx"));
        StringUtilsTest.assertEquals((String)"bcc", (String)StringUtils.replaceChars((String)"abc", (String)"ab", (String)"bc"));
        StringUtilsTest.assertEquals((String)"q651.506bera", (String)StringUtils.replaceChars((String)"d216.102oren", (String)"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ123456789", (String)"nopqrstuvwxyzabcdefghijklmNOPQRSTUVWXYZABCDEFGHIJKLM567891234"));
    }

    public void testOverlay_StringStringIntInt() {
        StringUtilsTest.assertEquals(null, (String)StringUtils.overlay(null, null, (int)2, (int)4));
        StringUtilsTest.assertEquals(null, (String)StringUtils.overlay(null, null, (int)-2, (int)-4));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.overlay((String)"", null, (int)0, (int)0));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.overlay((String)"", (String)"", (int)0, (int)0));
        StringUtilsTest.assertEquals((String)"zzzz", (String)StringUtils.overlay((String)"", (String)"zzzz", (int)0, (int)0));
        StringUtilsTest.assertEquals((String)"zzzz", (String)StringUtils.overlay((String)"", (String)"zzzz", (int)2, (int)4));
        StringUtilsTest.assertEquals((String)"zzzz", (String)StringUtils.overlay((String)"", (String)"zzzz", (int)-2, (int)-4));
        StringUtilsTest.assertEquals((String)"abef", (String)StringUtils.overlay((String)"abcdef", null, (int)2, (int)4));
        StringUtilsTest.assertEquals((String)"abef", (String)StringUtils.overlay((String)"abcdef", null, (int)4, (int)2));
        StringUtilsTest.assertEquals((String)"abef", (String)StringUtils.overlay((String)"abcdef", (String)"", (int)2, (int)4));
        StringUtilsTest.assertEquals((String)"abef", (String)StringUtils.overlay((String)"abcdef", (String)"", (int)4, (int)2));
        StringUtilsTest.assertEquals((String)"abzzzzef", (String)StringUtils.overlay((String)"abcdef", (String)"zzzz", (int)2, (int)4));
        StringUtilsTest.assertEquals((String)"abzzzzef", (String)StringUtils.overlay((String)"abcdef", (String)"zzzz", (int)4, (int)2));
        StringUtilsTest.assertEquals((String)"zzzzef", (String)StringUtils.overlay((String)"abcdef", (String)"zzzz", (int)-1, (int)4));
        StringUtilsTest.assertEquals((String)"zzzzef", (String)StringUtils.overlay((String)"abcdef", (String)"zzzz", (int)4, (int)-1));
        StringUtilsTest.assertEquals((String)"zzzzabcdef", (String)StringUtils.overlay((String)"abcdef", (String)"zzzz", (int)-2, (int)-1));
        StringUtilsTest.assertEquals((String)"zzzzabcdef", (String)StringUtils.overlay((String)"abcdef", (String)"zzzz", (int)-1, (int)-2));
        StringUtilsTest.assertEquals((String)"abcdzzzz", (String)StringUtils.overlay((String)"abcdef", (String)"zzzz", (int)4, (int)10));
        StringUtilsTest.assertEquals((String)"abcdzzzz", (String)StringUtils.overlay((String)"abcdef", (String)"zzzz", (int)10, (int)4));
        StringUtilsTest.assertEquals((String)"abcdefzzzz", (String)StringUtils.overlay((String)"abcdef", (String)"zzzz", (int)8, (int)10));
        StringUtilsTest.assertEquals((String)"abcdefzzzz", (String)StringUtils.overlay((String)"abcdef", (String)"zzzz", (int)10, (int)8));
    }

    public void testRepeat_StringInt() {
        StringUtilsTest.assertEquals(null, (String)StringUtils.repeat(null, (int)2));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.repeat((String)"ab", (int)0));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.repeat((String)"", (int)3));
        StringUtilsTest.assertEquals((String)"aaa", (String)StringUtils.repeat((String)"a", (int)3));
        StringUtilsTest.assertEquals((String)"ababab", (String)StringUtils.repeat((String)"ab", (int)3));
        StringUtilsTest.assertEquals((String)"abcabcabc", (String)StringUtils.repeat((String)"abc", (int)3));
        String str = StringUtils.repeat((String)"a", (int)10000);
        StringUtilsTest.assertEquals((int)10000, (int)str.length());
        StringUtilsTest.assertEquals((boolean)true, (boolean)StringUtils.containsOnly((CharSequence)str, (char[])new char[]{'a'}));
    }

    public void testRepeat_StringStringInt() {
        StringUtilsTest.assertEquals(null, (String)StringUtils.repeat(null, null, (int)2));
        StringUtilsTest.assertEquals(null, (String)StringUtils.repeat(null, (String)"x", (int)2));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.repeat((String)"", null, (int)2));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.repeat((String)"ab", (String)"", (int)0));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.repeat((String)"", (String)"", (int)2));
        StringUtilsTest.assertEquals((String)"xx", (String)StringUtils.repeat((String)"", (String)"x", (int)3));
        StringUtilsTest.assertEquals((String)"?, ?, ?", (String)StringUtils.repeat((String)"?", (String)", ", (int)3));
    }

    public void testChop() {
        String[][] chopCases;
        for (String[] chopCase : chopCases = new String[][]{{"foo\r\n", FOO_UNCAP}, {"foo\n", FOO_UNCAP}, {"foo\r", FOO_UNCAP}, {"foo \r", "foo "}, {FOO_UNCAP, "fo"}, {"foo\nfoo", "foo\nfo"}, {"\n", ""}, {"\r", ""}, {"\r\n", ""}, {null, null}, {"", ""}, {"a", ""}}) {
            String original = chopCase[0];
            String expectedResult = chopCase[1];
            StringUtilsTest.assertEquals((String)"chop(String) failed", (String)expectedResult, (String)StringUtils.chop((String)original));
        }
    }

    public void testChomp() {
        String[][] chompCases;
        for (String[] chompCase : chompCases = new String[][]{{"foo\r\n", FOO_UNCAP}, {"foo\n", FOO_UNCAP}, {"foo\r", FOO_UNCAP}, {"foo \r", "foo "}, {FOO_UNCAP, FOO_UNCAP}, {"foo\n\n", "foo\n"}, {"foo\r\n\r\n", "foo\r\n"}, {"foo\nfoo", "foo\nfoo"}, {"foo\n\rfoo", "foo\n\rfoo"}, {"\n", ""}, {"\r", ""}, {"a", "a"}, {"\r\n", ""}, {"", ""}, {null, null}, {"foo\n\r", "foo\n"}}) {
            String original = chompCase[0];
            String expectedResult = chompCase[1];
            StringUtilsTest.assertEquals((String)"chomp(String) failed", (String)expectedResult, (String)StringUtils.chomp((String)original));
        }
        StringUtilsTest.assertEquals((String)"chomp(String, String) failed", (String)FOO_UNCAP, (String)StringUtils.chomp((String)"foobar", (String)"bar"));
        StringUtilsTest.assertEquals((String)"chomp(String, String) failed", (String)"foobar", (String)StringUtils.chomp((String)"foobar", (String)"baz"));
        StringUtilsTest.assertEquals((String)"chomp(String, String) failed", (String)FOO_UNCAP, (String)StringUtils.chomp((String)FOO_UNCAP, (String)"foooo"));
        StringUtilsTest.assertEquals((String)"chomp(String, String) failed", (String)"foobar", (String)StringUtils.chomp((String)"foobar", (String)""));
        StringUtilsTest.assertEquals((String)"chomp(String, String) failed", (String)"foobar", (String)StringUtils.chomp((String)"foobar", null));
        StringUtilsTest.assertEquals((String)"chomp(String, String) failed", (String)"", (String)StringUtils.chomp((String)"", (String)FOO_UNCAP));
        StringUtilsTest.assertEquals((String)"chomp(String, String) failed", (String)"", (String)StringUtils.chomp((String)"", null));
        StringUtilsTest.assertEquals((String)"chomp(String, String) failed", (String)"", (String)StringUtils.chomp((String)"", (String)""));
        StringUtilsTest.assertEquals((String)"chomp(String, String) failed", null, (String)StringUtils.chomp(null, (String)FOO_UNCAP));
        StringUtilsTest.assertEquals((String)"chomp(String, String) failed", null, (String)StringUtils.chomp(null, null));
        StringUtilsTest.assertEquals((String)"chomp(String, String) failed", null, (String)StringUtils.chomp(null, (String)""));
        StringUtilsTest.assertEquals((String)"chomp(String, String) failed", (String)"", (String)StringUtils.chomp((String)FOO_UNCAP, (String)FOO_UNCAP));
        StringUtilsTest.assertEquals((String)"chomp(String, String) failed", (String)" ", (String)StringUtils.chomp((String)" foo", (String)FOO_UNCAP));
        StringUtilsTest.assertEquals((String)"chomp(String, String) failed", (String)"foo ", (String)StringUtils.chomp((String)"foo ", (String)FOO_UNCAP));
    }

    public void testRightPad_StringInt() {
        StringUtilsTest.assertEquals(null, (String)StringUtils.rightPad(null, (int)5));
        StringUtilsTest.assertEquals((String)"     ", (String)StringUtils.rightPad((String)"", (int)5));
        StringUtilsTest.assertEquals((String)"abc  ", (String)StringUtils.rightPad((String)"abc", (int)5));
        StringUtilsTest.assertEquals((String)"abc", (String)StringUtils.rightPad((String)"abc", (int)2));
        StringUtilsTest.assertEquals((String)"abc", (String)StringUtils.rightPad((String)"abc", (int)-1));
    }

    public void testRightPad_StringIntChar() {
        StringUtilsTest.assertEquals(null, (String)StringUtils.rightPad(null, (int)5, (char)' '));
        StringUtilsTest.assertEquals((String)"     ", (String)StringUtils.rightPad((String)"", (int)5, (char)' '));
        StringUtilsTest.assertEquals((String)"abc  ", (String)StringUtils.rightPad((String)"abc", (int)5, (char)' '));
        StringUtilsTest.assertEquals((String)"abc", (String)StringUtils.rightPad((String)"abc", (int)2, (char)' '));
        StringUtilsTest.assertEquals((String)"abc", (String)StringUtils.rightPad((String)"abc", (int)-1, (char)' '));
        StringUtilsTest.assertEquals((String)"abcxx", (String)StringUtils.rightPad((String)"abc", (int)5, (char)'x'));
        String str = StringUtils.rightPad((String)"aaa", (int)10000, (char)'a');
        StringUtilsTest.assertEquals((int)10000, (int)str.length());
        StringUtilsTest.assertEquals((boolean)true, (boolean)StringUtils.containsOnly((CharSequence)str, (char[])new char[]{'a'}));
    }

    public void testRightPad_StringIntString() {
        StringUtilsTest.assertEquals(null, (String)StringUtils.rightPad(null, (int)5, (String)"-+"));
        StringUtilsTest.assertEquals((String)"     ", (String)StringUtils.rightPad((String)"", (int)5, (String)" "));
        StringUtilsTest.assertEquals(null, (String)StringUtils.rightPad(null, (int)8, null));
        StringUtilsTest.assertEquals((String)"abc-+-+", (String)StringUtils.rightPad((String)"abc", (int)7, (String)"-+"));
        StringUtilsTest.assertEquals((String)"abc-+~", (String)StringUtils.rightPad((String)"abc", (int)6, (String)"-+~"));
        StringUtilsTest.assertEquals((String)"abc-+", (String)StringUtils.rightPad((String)"abc", (int)5, (String)"-+~"));
        StringUtilsTest.assertEquals((String)"abc", (String)StringUtils.rightPad((String)"abc", (int)2, (String)" "));
        StringUtilsTest.assertEquals((String)"abc", (String)StringUtils.rightPad((String)"abc", (int)-1, (String)" "));
        StringUtilsTest.assertEquals((String)"abc  ", (String)StringUtils.rightPad((String)"abc", (int)5, null));
        StringUtilsTest.assertEquals((String)"abc  ", (String)StringUtils.rightPad((String)"abc", (int)5, (String)""));
    }

    public void testLeftPad_StringInt() {
        StringUtilsTest.assertEquals(null, (String)StringUtils.leftPad(null, (int)5));
        StringUtilsTest.assertEquals((String)"     ", (String)StringUtils.leftPad((String)"", (int)5));
        StringUtilsTest.assertEquals((String)"  abc", (String)StringUtils.leftPad((String)"abc", (int)5));
        StringUtilsTest.assertEquals((String)"abc", (String)StringUtils.leftPad((String)"abc", (int)2));
    }

    public void testLeftPad_StringIntChar() {
        StringUtilsTest.assertEquals(null, (String)StringUtils.leftPad(null, (int)5, (char)' '));
        StringUtilsTest.assertEquals((String)"     ", (String)StringUtils.leftPad((String)"", (int)5, (char)' '));
        StringUtilsTest.assertEquals((String)"  abc", (String)StringUtils.leftPad((String)"abc", (int)5, (char)' '));
        StringUtilsTest.assertEquals((String)"xxabc", (String)StringUtils.leftPad((String)"abc", (int)5, (char)'x'));
        StringUtilsTest.assertEquals((String)"\uffff\uffffabc", (String)StringUtils.leftPad((String)"abc", (int)5, (char)'\uffff'));
        StringUtilsTest.assertEquals((String)"abc", (String)StringUtils.leftPad((String)"abc", (int)2, (char)' '));
        String str = StringUtils.leftPad((String)"aaa", (int)10000, (char)'a');
        StringUtilsTest.assertEquals((int)10000, (int)str.length());
        StringUtilsTest.assertEquals((boolean)true, (boolean)StringUtils.containsOnly((CharSequence)str, (char[])new char[]{'a'}));
    }

    public void testLeftPad_StringIntString() {
        StringUtilsTest.assertEquals(null, (String)StringUtils.leftPad(null, (int)5, (String)"-+"));
        StringUtilsTest.assertEquals(null, (String)StringUtils.leftPad(null, (int)5, null));
        StringUtilsTest.assertEquals((String)"     ", (String)StringUtils.leftPad((String)"", (int)5, (String)" "));
        StringUtilsTest.assertEquals((String)"-+-+abc", (String)StringUtils.leftPad((String)"abc", (int)7, (String)"-+"));
        StringUtilsTest.assertEquals((String)"-+~abc", (String)StringUtils.leftPad((String)"abc", (int)6, (String)"-+~"));
        StringUtilsTest.assertEquals((String)"-+abc", (String)StringUtils.leftPad((String)"abc", (int)5, (String)"-+~"));
        StringUtilsTest.assertEquals((String)"abc", (String)StringUtils.leftPad((String)"abc", (int)2, (String)" "));
        StringUtilsTest.assertEquals((String)"abc", (String)StringUtils.leftPad((String)"abc", (int)-1, (String)" "));
        StringUtilsTest.assertEquals((String)"  abc", (String)StringUtils.leftPad((String)"abc", (int)5, null));
        StringUtilsTest.assertEquals((String)"  abc", (String)StringUtils.leftPad((String)"abc", (int)5, (String)""));
    }

    public void testLengthString() {
        StringUtilsTest.assertEquals((int)0, (int)StringUtils.length(null));
        StringUtilsTest.assertEquals((int)0, (int)StringUtils.length((CharSequence)""));
        StringUtilsTest.assertEquals((int)0, (int)StringUtils.length((CharSequence)""));
        StringUtilsTest.assertEquals((int)1, (int)StringUtils.length((CharSequence)"A"));
        StringUtilsTest.assertEquals((int)1, (int)StringUtils.length((CharSequence)" "));
        StringUtilsTest.assertEquals((int)8, (int)StringUtils.length((CharSequence)"ABCDEFGH"));
    }

    public void testLengthStringBuffer() {
        StringUtilsTest.assertEquals((int)0, (int)StringUtils.length((CharSequence)new StringBuffer("")));
        StringUtilsTest.assertEquals((int)0, (int)StringUtils.length((CharSequence)new StringBuffer("")));
        StringUtilsTest.assertEquals((int)1, (int)StringUtils.length((CharSequence)new StringBuffer("A")));
        StringUtilsTest.assertEquals((int)1, (int)StringUtils.length((CharSequence)new StringBuffer(" ")));
        StringUtilsTest.assertEquals((int)8, (int)StringUtils.length((CharSequence)new StringBuffer("ABCDEFGH")));
    }

    public void testLengthStringBuilder() {
        StringUtilsTest.assertEquals((int)0, (int)StringUtils.length((CharSequence)new StringBuilder("")));
        StringUtilsTest.assertEquals((int)0, (int)StringUtils.length((CharSequence)new StringBuilder("")));
        StringUtilsTest.assertEquals((int)1, (int)StringUtils.length((CharSequence)new StringBuilder("A")));
        StringUtilsTest.assertEquals((int)1, (int)StringUtils.length((CharSequence)new StringBuilder(" ")));
        StringUtilsTest.assertEquals((int)8, (int)StringUtils.length((CharSequence)new StringBuilder("ABCDEFGH")));
    }

    public void testLength_CharBuffer() {
        StringUtilsTest.assertEquals((int)0, (int)StringUtils.length((CharSequence)CharBuffer.wrap("")));
        StringUtilsTest.assertEquals((int)1, (int)StringUtils.length((CharSequence)CharBuffer.wrap("A")));
        StringUtilsTest.assertEquals((int)1, (int)StringUtils.length((CharSequence)CharBuffer.wrap(" ")));
        StringUtilsTest.assertEquals((int)8, (int)StringUtils.length((CharSequence)CharBuffer.wrap("ABCDEFGH")));
    }

    public void testCenter_StringInt() {
        StringUtilsTest.assertEquals(null, (String)StringUtils.center(null, (int)-1));
        StringUtilsTest.assertEquals(null, (String)StringUtils.center(null, (int)4));
        StringUtilsTest.assertEquals((String)"    ", (String)StringUtils.center((String)"", (int)4));
        StringUtilsTest.assertEquals((String)"ab", (String)StringUtils.center((String)"ab", (int)0));
        StringUtilsTest.assertEquals((String)"ab", (String)StringUtils.center((String)"ab", (int)-1));
        StringUtilsTest.assertEquals((String)"ab", (String)StringUtils.center((String)"ab", (int)1));
        StringUtilsTest.assertEquals((String)"    ", (String)StringUtils.center((String)"", (int)4));
        StringUtilsTest.assertEquals((String)" ab ", (String)StringUtils.center((String)"ab", (int)4));
        StringUtilsTest.assertEquals((String)"abcd", (String)StringUtils.center((String)"abcd", (int)2));
        StringUtilsTest.assertEquals((String)" a  ", (String)StringUtils.center((String)"a", (int)4));
        StringUtilsTest.assertEquals((String)"  a  ", (String)StringUtils.center((String)"a", (int)5));
    }

    public void testCenter_StringIntChar() {
        StringUtilsTest.assertEquals(null, (String)StringUtils.center(null, (int)-1, (char)' '));
        StringUtilsTest.assertEquals(null, (String)StringUtils.center(null, (int)4, (char)' '));
        StringUtilsTest.assertEquals((String)"    ", (String)StringUtils.center((String)"", (int)4, (char)' '));
        StringUtilsTest.assertEquals((String)"ab", (String)StringUtils.center((String)"ab", (int)0, (char)' '));
        StringUtilsTest.assertEquals((String)"ab", (String)StringUtils.center((String)"ab", (int)-1, (char)' '));
        StringUtilsTest.assertEquals((String)"ab", (String)StringUtils.center((String)"ab", (int)1, (char)' '));
        StringUtilsTest.assertEquals((String)"    ", (String)StringUtils.center((String)"", (int)4, (char)' '));
        StringUtilsTest.assertEquals((String)" ab ", (String)StringUtils.center((String)"ab", (int)4, (char)' '));
        StringUtilsTest.assertEquals((String)"abcd", (String)StringUtils.center((String)"abcd", (int)2, (char)' '));
        StringUtilsTest.assertEquals((String)" a  ", (String)StringUtils.center((String)"a", (int)4, (char)' '));
        StringUtilsTest.assertEquals((String)"  a  ", (String)StringUtils.center((String)"a", (int)5, (char)' '));
        StringUtilsTest.assertEquals((String)"xxaxx", (String)StringUtils.center((String)"a", (int)5, (char)'x'));
    }

    public void testCenter_StringIntString() {
        StringUtilsTest.assertEquals(null, (String)StringUtils.center(null, (int)4, null));
        StringUtilsTest.assertEquals(null, (String)StringUtils.center(null, (int)-1, (String)" "));
        StringUtilsTest.assertEquals(null, (String)StringUtils.center(null, (int)4, (String)" "));
        StringUtilsTest.assertEquals((String)"    ", (String)StringUtils.center((String)"", (int)4, (String)" "));
        StringUtilsTest.assertEquals((String)"ab", (String)StringUtils.center((String)"ab", (int)0, (String)" "));
        StringUtilsTest.assertEquals((String)"ab", (String)StringUtils.center((String)"ab", (int)-1, (String)" "));
        StringUtilsTest.assertEquals((String)"ab", (String)StringUtils.center((String)"ab", (int)1, (String)" "));
        StringUtilsTest.assertEquals((String)"    ", (String)StringUtils.center((String)"", (int)4, (String)" "));
        StringUtilsTest.assertEquals((String)" ab ", (String)StringUtils.center((String)"ab", (int)4, (String)" "));
        StringUtilsTest.assertEquals((String)"abcd", (String)StringUtils.center((String)"abcd", (int)2, (String)" "));
        StringUtilsTest.assertEquals((String)" a  ", (String)StringUtils.center((String)"a", (int)4, (String)" "));
        StringUtilsTest.assertEquals((String)"yayz", (String)StringUtils.center((String)"a", (int)4, (String)"yz"));
        StringUtilsTest.assertEquals((String)"yzyayzy", (String)StringUtils.center((String)"a", (int)7, (String)"yz"));
        StringUtilsTest.assertEquals((String)"  abc  ", (String)StringUtils.center((String)"abc", (int)7, null));
        StringUtilsTest.assertEquals((String)"  abc  ", (String)StringUtils.center((String)"abc", (int)7, (String)""));
    }

    public void testReverse_String() {
        StringUtilsTest.assertEquals(null, (String)StringUtils.reverse(null));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.reverse((String)""));
        StringUtilsTest.assertEquals((String)"sdrawkcab", (String)StringUtils.reverse((String)"backwards"));
    }

    public void testReverseDelimited_StringChar() {
        StringUtilsTest.assertEquals(null, (String)StringUtils.reverseDelimited(null, (char)'.'));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.reverseDelimited((String)"", (char)'.'));
        StringUtilsTest.assertEquals((String)"c.b.a", (String)StringUtils.reverseDelimited((String)"a.b.c", (char)'.'));
        StringUtilsTest.assertEquals((String)"a b c", (String)StringUtils.reverseDelimited((String)"a b c", (char)'.'));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.reverseDelimited((String)"", (char)'.'));
    }

    public void testDefault_String() {
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.defaultString(null));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.defaultString((String)""));
        StringUtilsTest.assertEquals((String)"abc", (String)StringUtils.defaultString((String)"abc"));
    }

    public void testDefault_StringString() {
        StringUtilsTest.assertEquals((String)"NULL", (String)StringUtils.defaultString(null, (String)"NULL"));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.defaultString((String)"", (String)"NULL"));
        StringUtilsTest.assertEquals((String)"abc", (String)StringUtils.defaultString((String)"abc", (String)"NULL"));
    }

    public void testDefaultIfEmpty_StringString() {
        StringUtilsTest.assertEquals((String)"NULL", (String)((String)StringUtils.defaultIfEmpty(null, (CharSequence)"NULL")));
        StringUtilsTest.assertEquals((String)"NULL", (String)((String)StringUtils.defaultIfEmpty((CharSequence)"", (CharSequence)"NULL")));
        StringUtilsTest.assertEquals((String)"abc", (String)((String)StringUtils.defaultIfEmpty((CharSequence)"abc", (CharSequence)"NULL")));
        StringUtilsTest.assertNull((Object)StringUtils.defaultIfEmpty((CharSequence)"", null));
        String s = (String)StringUtils.defaultIfEmpty((CharSequence)"abc", (CharSequence)"NULL");
        StringUtilsTest.assertEquals((String)"abc", (String)s);
    }

    public void testDefaultIfBlank_StringString() {
        StringUtilsTest.assertEquals((String)"NULL", (String)((String)StringUtils.defaultIfBlank(null, (CharSequence)"NULL")));
        StringUtilsTest.assertEquals((String)"NULL", (String)((String)StringUtils.defaultIfBlank((CharSequence)"", (CharSequence)"NULL")));
        StringUtilsTest.assertEquals((String)"NULL", (String)((String)StringUtils.defaultIfBlank((CharSequence)" ", (CharSequence)"NULL")));
        StringUtilsTest.assertEquals((String)"abc", (String)((String)StringUtils.defaultIfBlank((CharSequence)"abc", (CharSequence)"NULL")));
        StringUtilsTest.assertNull((Object)StringUtils.defaultIfBlank((CharSequence)"", null));
        String s = (String)StringUtils.defaultIfBlank((CharSequence)"abc", (CharSequence)"NULL");
        StringUtilsTest.assertEquals((String)"abc", (String)s);
    }

    public void testDefaultIfEmpty_StringBuilders() {
        StringUtilsTest.assertEquals((String)"NULL", (String)((StringBuilder)StringUtils.defaultIfEmpty((CharSequence)new StringBuilder(""), (CharSequence)new StringBuilder("NULL"))).toString());
        StringUtilsTest.assertEquals((String)"abc", (String)((StringBuilder)StringUtils.defaultIfEmpty((CharSequence)new StringBuilder("abc"), (CharSequence)new StringBuilder("NULL"))).toString());
        StringUtilsTest.assertNull((Object)StringUtils.defaultIfEmpty((CharSequence)new StringBuilder(""), null));
        StringBuilder s = (StringBuilder)StringUtils.defaultIfEmpty((CharSequence)new StringBuilder("abc"), (CharSequence)new StringBuilder("NULL"));
        StringUtilsTest.assertEquals((String)"abc", (String)s.toString());
    }

    public void testDefaultIfBlank_StringBuilders() {
        StringUtilsTest.assertEquals((String)"NULL", (String)((StringBuilder)StringUtils.defaultIfBlank((CharSequence)new StringBuilder(""), (CharSequence)new StringBuilder("NULL"))).toString());
        StringUtilsTest.assertEquals((String)"NULL", (String)((StringBuilder)StringUtils.defaultIfBlank((CharSequence)new StringBuilder(" "), (CharSequence)new StringBuilder("NULL"))).toString());
        StringUtilsTest.assertEquals((String)"abc", (String)((StringBuilder)StringUtils.defaultIfBlank((CharSequence)new StringBuilder("abc"), (CharSequence)new StringBuilder("NULL"))).toString());
        StringUtilsTest.assertNull((Object)StringUtils.defaultIfBlank((CharSequence)new StringBuilder(""), null));
        StringBuilder s = (StringBuilder)StringUtils.defaultIfBlank((CharSequence)new StringBuilder("abc"), (CharSequence)new StringBuilder("NULL"));
        StringUtilsTest.assertEquals((String)"abc", (String)s.toString());
    }

    public void testDefaultIfEmpty_StringBuffers() {
        StringUtilsTest.assertEquals((String)"NULL", (String)((StringBuffer)StringUtils.defaultIfEmpty((CharSequence)new StringBuffer(""), (CharSequence)new StringBuffer("NULL"))).toString());
        StringUtilsTest.assertEquals((String)"abc", (String)((StringBuffer)StringUtils.defaultIfEmpty((CharSequence)new StringBuffer("abc"), (CharSequence)new StringBuffer("NULL"))).toString());
        StringUtilsTest.assertNull((Object)StringUtils.defaultIfEmpty((CharSequence)new StringBuffer(""), null));
        StringBuffer s = (StringBuffer)StringUtils.defaultIfEmpty((CharSequence)new StringBuffer("abc"), (CharSequence)new StringBuffer("NULL"));
        StringUtilsTest.assertEquals((String)"abc", (String)s.toString());
    }

    public void testDefaultIfBlank_StringBuffers() {
        StringUtilsTest.assertEquals((String)"NULL", (String)((StringBuffer)StringUtils.defaultIfBlank((CharSequence)new StringBuffer(""), (CharSequence)new StringBuffer("NULL"))).toString());
        StringUtilsTest.assertEquals((String)"NULL", (String)((StringBuffer)StringUtils.defaultIfBlank((CharSequence)new StringBuffer(" "), (CharSequence)new StringBuffer("NULL"))).toString());
        StringUtilsTest.assertEquals((String)"abc", (String)((StringBuffer)StringUtils.defaultIfBlank((CharSequence)new StringBuffer("abc"), (CharSequence)new StringBuffer("NULL"))).toString());
        StringUtilsTest.assertNull((Object)StringUtils.defaultIfBlank((CharSequence)new StringBuffer(""), null));
        StringBuffer s = (StringBuffer)StringUtils.defaultIfBlank((CharSequence)new StringBuffer("abc"), (CharSequence)new StringBuffer("NULL"));
        StringUtilsTest.assertEquals((String)"abc", (String)s.toString());
    }

    public void testDefaultIfEmpty_CharBuffers() {
        StringUtilsTest.assertEquals((String)"NULL", (String)((CharBuffer)StringUtils.defaultIfEmpty((CharSequence)CharBuffer.wrap(""), (CharSequence)CharBuffer.wrap("NULL"))).toString());
        StringUtilsTest.assertEquals((String)"abc", (String)((CharBuffer)StringUtils.defaultIfEmpty((CharSequence)CharBuffer.wrap("abc"), (CharSequence)CharBuffer.wrap("NULL"))).toString());
        StringUtilsTest.assertNull((Object)StringUtils.defaultIfEmpty((CharSequence)CharBuffer.wrap(""), null));
        CharBuffer s = (CharBuffer)StringUtils.defaultIfEmpty((CharSequence)CharBuffer.wrap("abc"), (CharSequence)CharBuffer.wrap("NULL"));
        StringUtilsTest.assertEquals((String)"abc", (String)s.toString());
    }

    public void testDefaultIfBlank_CharBuffers() {
        StringUtilsTest.assertEquals((String)"NULL", (String)((CharBuffer)StringUtils.defaultIfBlank((CharSequence)CharBuffer.wrap(""), (CharSequence)CharBuffer.wrap("NULL"))).toString());
        StringUtilsTest.assertEquals((String)"NULL", (String)((CharBuffer)StringUtils.defaultIfBlank((CharSequence)CharBuffer.wrap(" "), (CharSequence)CharBuffer.wrap("NULL"))).toString());
        StringUtilsTest.assertEquals((String)"abc", (String)((CharBuffer)StringUtils.defaultIfBlank((CharSequence)CharBuffer.wrap("abc"), (CharSequence)CharBuffer.wrap("NULL"))).toString());
        StringUtilsTest.assertNull((Object)StringUtils.defaultIfBlank((CharSequence)CharBuffer.wrap(""), null));
        CharBuffer s = (CharBuffer)StringUtils.defaultIfBlank((CharSequence)CharBuffer.wrap("abc"), (CharSequence)CharBuffer.wrap("NULL"));
        StringUtilsTest.assertEquals((String)"abc", (String)s.toString());
    }

    public void testAbbreviate_StringInt() {
        StringUtilsTest.assertEquals(null, (String)StringUtils.abbreviate(null, (int)10));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.abbreviate((String)"", (int)10));
        StringUtilsTest.assertEquals((String)"short", (String)StringUtils.abbreviate((String)"short", (int)10));
        StringUtilsTest.assertEquals((String)"Now is ...", (String)StringUtils.abbreviate((String)"Now is the time for all good men to come to the aid of their party.", (int)10));
        String raspberry = "raspberry peach";
        StringUtilsTest.assertEquals((String)"raspberry p...", (String)StringUtils.abbreviate((String)raspberry, (int)14));
        StringUtilsTest.assertEquals((String)"raspberry peach", (String)StringUtils.abbreviate((String)"raspberry peach", (int)15));
        StringUtilsTest.assertEquals((String)"raspberry peach", (String)StringUtils.abbreviate((String)"raspberry peach", (int)16));
        StringUtilsTest.assertEquals((String)"abc...", (String)StringUtils.abbreviate((String)"abcdefg", (int)6));
        StringUtilsTest.assertEquals((String)"abcdefg", (String)StringUtils.abbreviate((String)"abcdefg", (int)7));
        StringUtilsTest.assertEquals((String)"abcdefg", (String)StringUtils.abbreviate((String)"abcdefg", (int)8));
        StringUtilsTest.assertEquals((String)"a...", (String)StringUtils.abbreviate((String)"abcdefg", (int)4));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.abbreviate((String)"", (int)4));
        try {
            String res = StringUtils.abbreviate((String)"abc", (int)3);
            StringUtilsTest.fail((String)"StringUtils.abbreviate expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testAbbreviate_StringIntInt() {
        String res;
        StringUtilsTest.assertEquals(null, (String)StringUtils.abbreviate(null, (int)10, (int)12));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.abbreviate((String)"", (int)0, (int)10));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.abbreviate((String)"", (int)2, (int)10));
        try {
            res = StringUtils.abbreviate((String)"abcdefghij", (int)0, (int)3);
            StringUtilsTest.fail((String)"StringUtils.abbreviate expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            res = StringUtils.abbreviate((String)"abcdefghij", (int)5, (int)6);
            StringUtilsTest.fail((String)"StringUtils.abbreviate expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        String raspberry = "raspberry peach";
        StringUtilsTest.assertEquals((String)"raspberry peach", (String)StringUtils.abbreviate((String)raspberry, (int)11, (int)15));
        StringUtilsTest.assertEquals(null, (String)StringUtils.abbreviate(null, (int)7, (int)14));
        this.assertAbbreviateWithOffset("abcdefg...", -1, 10);
        this.assertAbbreviateWithOffset("abcdefg...", 0, 10);
        this.assertAbbreviateWithOffset("abcdefg...", 1, 10);
        this.assertAbbreviateWithOffset("abcdefg...", 2, 10);
        this.assertAbbreviateWithOffset("abcdefg...", 3, 10);
        this.assertAbbreviateWithOffset("abcdefg...", 4, 10);
        this.assertAbbreviateWithOffset("...fghi...", 5, 10);
        this.assertAbbreviateWithOffset("...ghij...", 6, 10);
        this.assertAbbreviateWithOffset("...hijk...", 7, 10);
        this.assertAbbreviateWithOffset("...ijklmno", 8, 10);
        this.assertAbbreviateWithOffset("...ijklmno", 9, 10);
        this.assertAbbreviateWithOffset("...ijklmno", 10, 10);
        this.assertAbbreviateWithOffset("...ijklmno", 10, 10);
        this.assertAbbreviateWithOffset("...ijklmno", 11, 10);
        this.assertAbbreviateWithOffset("...ijklmno", 12, 10);
        this.assertAbbreviateWithOffset("...ijklmno", 13, 10);
        this.assertAbbreviateWithOffset("...ijklmno", 14, 10);
        this.assertAbbreviateWithOffset("...ijklmno", 15, 10);
        this.assertAbbreviateWithOffset("...ijklmno", 16, 10);
        this.assertAbbreviateWithOffset("...ijklmno", Integer.MAX_VALUE, 10);
    }

    private void assertAbbreviateWithOffset(String expected, int offset, int maxWidth) {
        String abcdefghijklmno = "abcdefghijklmno";
        String message = "abbreviate(String,int,int) failed";
        String actual = StringUtils.abbreviate((String)abcdefghijklmno, (int)offset, (int)maxWidth);
        if (offset >= 0 && offset < abcdefghijklmno.length()) {
            StringUtilsTest.assertTrue((String)(message + " -- should contain offset character"), (actual.indexOf((char)(97 + offset)) != -1 ? 1 : 0) != 0);
        }
        StringUtilsTest.assertTrue((String)(message + " -- should not be greater than maxWidth"), (actual.length() <= maxWidth ? 1 : 0) != 0);
        StringUtilsTest.assertEquals((String)message, (String)expected, (String)actual);
    }

    public void testAbbreviateMiddle() {
        StringUtilsTest.assertNull((Object)StringUtils.abbreviateMiddle(null, null, (int)0));
        StringUtilsTest.assertEquals((String)"abc", (String)StringUtils.abbreviateMiddle((String)"abc", null, (int)0));
        StringUtilsTest.assertEquals((String)"abc", (String)StringUtils.abbreviateMiddle((String)"abc", (String)".", (int)0));
        StringUtilsTest.assertEquals((String)"abc", (String)StringUtils.abbreviateMiddle((String)"abc", (String)".", (int)3));
        StringUtilsTest.assertEquals((String)"ab.f", (String)StringUtils.abbreviateMiddle((String)"abcdef", (String)".", (int)4));
        StringUtilsTest.assertEquals((String)"A very long text with un...f the text is complete.", (String)StringUtils.abbreviateMiddle((String)"A very long text with unimportant stuff in the middle but interesting start and end to see if the text is complete.", (String)"...", (int)50));
        String longText = "Start text" + StringUtils.repeat((String)"x", (int)10000) + "Close text";
        StringUtilsTest.assertEquals((String)"Start text->Close text", (String)StringUtils.abbreviateMiddle((String)longText, (String)"->", (int)22));
        StringUtilsTest.assertEquals((String)"abc", (String)StringUtils.abbreviateMiddle((String)"abc", (String)".", (int)-1));
        StringUtilsTest.assertEquals((String)"abc", (String)StringUtils.abbreviateMiddle((String)"abc", (String)".", (int)1));
        StringUtilsTest.assertEquals((String)"abc", (String)StringUtils.abbreviateMiddle((String)"abc", (String)".", (int)2));
        StringUtilsTest.assertEquals((String)"a", (String)StringUtils.abbreviateMiddle((String)"a", (String)".", (int)1));
        StringUtilsTest.assertEquals((String)"a.d", (String)StringUtils.abbreviateMiddle((String)"abcd", (String)".", (int)3));
        StringUtilsTest.assertEquals((String)"a..f", (String)StringUtils.abbreviateMiddle((String)"abcdef", (String)"..", (int)4));
        StringUtilsTest.assertEquals((String)"ab.ef", (String)StringUtils.abbreviateMiddle((String)"abcdef", (String)".", (int)5));
    }

    public void testDifference_StringString() {
        StringUtilsTest.assertEquals(null, (String)StringUtils.difference(null, null));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.difference((String)"", (String)""));
        StringUtilsTest.assertEquals((String)"abc", (String)StringUtils.difference((String)"", (String)"abc"));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.difference((String)"abc", (String)""));
        StringUtilsTest.assertEquals((String)"i am a robot", (String)StringUtils.difference(null, (String)"i am a robot"));
        StringUtilsTest.assertEquals((String)"i am a machine", (String)StringUtils.difference((String)"i am a machine", null));
        StringUtilsTest.assertEquals((String)"robot", (String)StringUtils.difference((String)"i am a machine", (String)"i am a robot"));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.difference((String)"abc", (String)"abc"));
        StringUtilsTest.assertEquals((String)"you are a robot", (String)StringUtils.difference((String)"i am a robot", (String)"you are a robot"));
    }

    public void testDifferenceAt_StringString() {
        StringUtilsTest.assertEquals((int)-1, (int)StringUtils.indexOfDifference(null, null));
        StringUtilsTest.assertEquals((int)0, (int)StringUtils.indexOfDifference(null, (CharSequence)"i am a robot"));
        StringUtilsTest.assertEquals((int)-1, (int)StringUtils.indexOfDifference((CharSequence)"", (CharSequence)""));
        StringUtilsTest.assertEquals((int)0, (int)StringUtils.indexOfDifference((CharSequence)"", (CharSequence)"abc"));
        StringUtilsTest.assertEquals((int)0, (int)StringUtils.indexOfDifference((CharSequence)"abc", (CharSequence)""));
        StringUtilsTest.assertEquals((int)0, (int)StringUtils.indexOfDifference((CharSequence)"i am a machine", null));
        StringUtilsTest.assertEquals((int)7, (int)StringUtils.indexOfDifference((CharSequence)"i am a machine", (CharSequence)"i am a robot"));
        StringUtilsTest.assertEquals((int)-1, (int)StringUtils.indexOfDifference((CharSequence)FOO_UNCAP, (CharSequence)FOO_UNCAP));
        StringUtilsTest.assertEquals((int)0, (int)StringUtils.indexOfDifference((CharSequence)"i am a robot", (CharSequence)"you are a robot"));
    }

    public void testGetLevenshteinDistance_StringString() {
        int d;
        StringUtilsTest.assertEquals((int)0, (int)StringUtils.getLevenshteinDistance((CharSequence)"", (CharSequence)""));
        StringUtilsTest.assertEquals((int)1, (int)StringUtils.getLevenshteinDistance((CharSequence)"", (CharSequence)"a"));
        StringUtilsTest.assertEquals((int)7, (int)StringUtils.getLevenshteinDistance((CharSequence)"aaapppp", (CharSequence)""));
        StringUtilsTest.assertEquals((int)1, (int)StringUtils.getLevenshteinDistance((CharSequence)"frog", (CharSequence)"fog"));
        StringUtilsTest.assertEquals((int)3, (int)StringUtils.getLevenshteinDistance((CharSequence)"fly", (CharSequence)"ant"));
        StringUtilsTest.assertEquals((int)7, (int)StringUtils.getLevenshteinDistance((CharSequence)"elephant", (CharSequence)"hippo"));
        StringUtilsTest.assertEquals((int)7, (int)StringUtils.getLevenshteinDistance((CharSequence)"hippo", (CharSequence)"elephant"));
        StringUtilsTest.assertEquals((int)8, (int)StringUtils.getLevenshteinDistance((CharSequence)"hippo", (CharSequence)"zzzzzzzz"));
        StringUtilsTest.assertEquals((int)8, (int)StringUtils.getLevenshteinDistance((CharSequence)"zzzzzzzz", (CharSequence)"hippo"));
        StringUtilsTest.assertEquals((int)1, (int)StringUtils.getLevenshteinDistance((CharSequence)"hello", (CharSequence)"hallo"));
        try {
            d = StringUtils.getLevenshteinDistance((CharSequence)"a", null);
            StringUtilsTest.fail((String)"expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            d = StringUtils.getLevenshteinDistance(null, (CharSequence)"a");
            StringUtilsTest.fail((String)"expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetLevenshteinDistance_StringStringInt() {
        int d;
        StringUtilsTest.assertEquals((int)0, (int)StringUtils.getLevenshteinDistance((CharSequence)"", (CharSequence)"", (int)0));
        StringUtilsTest.assertEquals((int)7, (int)StringUtils.getLevenshteinDistance((CharSequence)"aaapppp", (CharSequence)"", (int)8));
        StringUtilsTest.assertEquals((int)7, (int)StringUtils.getLevenshteinDistance((CharSequence)"aaapppp", (CharSequence)"", (int)7));
        StringUtilsTest.assertEquals((int)-1, (int)StringUtils.getLevenshteinDistance((CharSequence)"aaapppp", (CharSequence)"", (int)6));
        StringUtilsTest.assertEquals((int)-1, (int)StringUtils.getLevenshteinDistance((CharSequence)"b", (CharSequence)"a", (int)0));
        StringUtilsTest.assertEquals((int)-1, (int)StringUtils.getLevenshteinDistance((CharSequence)"a", (CharSequence)"b", (int)0));
        StringUtilsTest.assertEquals((int)0, (int)StringUtils.getLevenshteinDistance((CharSequence)"aa", (CharSequence)"aa", (int)0));
        StringUtilsTest.assertEquals((int)0, (int)StringUtils.getLevenshteinDistance((CharSequence)"aa", (CharSequence)"aa", (int)2));
        StringUtilsTest.assertEquals((int)-1, (int)StringUtils.getLevenshteinDistance((CharSequence)"aaa", (CharSequence)"bbb", (int)2));
        StringUtilsTest.assertEquals((int)3, (int)StringUtils.getLevenshteinDistance((CharSequence)"aaa", (CharSequence)"bbb", (int)3));
        StringUtilsTest.assertEquals((int)6, (int)StringUtils.getLevenshteinDistance((CharSequence)"aaaaaa", (CharSequence)"b", (int)10));
        StringUtilsTest.assertEquals((int)7, (int)StringUtils.getLevenshteinDistance((CharSequence)"aaapppp", (CharSequence)"b", (int)8));
        StringUtilsTest.assertEquals((int)3, (int)StringUtils.getLevenshteinDistance((CharSequence)"a", (CharSequence)"bbb", (int)4));
        StringUtilsTest.assertEquals((int)7, (int)StringUtils.getLevenshteinDistance((CharSequence)"aaapppp", (CharSequence)"b", (int)7));
        StringUtilsTest.assertEquals((int)3, (int)StringUtils.getLevenshteinDistance((CharSequence)"a", (CharSequence)"bbb", (int)3));
        StringUtilsTest.assertEquals((int)-1, (int)StringUtils.getLevenshteinDistance((CharSequence)"a", (CharSequence)"bbb", (int)2));
        StringUtilsTest.assertEquals((int)-1, (int)StringUtils.getLevenshteinDistance((CharSequence)"bbb", (CharSequence)"a", (int)2));
        StringUtilsTest.assertEquals((int)-1, (int)StringUtils.getLevenshteinDistance((CharSequence)"aaapppp", (CharSequence)"b", (int)6));
        StringUtilsTest.assertEquals((int)-1, (int)StringUtils.getLevenshteinDistance((CharSequence)"a", (CharSequence)"bbb", (int)1));
        StringUtilsTest.assertEquals((int)-1, (int)StringUtils.getLevenshteinDistance((CharSequence)"bbb", (CharSequence)"a", (int)1));
        StringUtilsTest.assertEquals((int)-1, (int)StringUtils.getLevenshteinDistance((CharSequence)"12345", (CharSequence)"1234567", (int)1));
        StringUtilsTest.assertEquals((int)-1, (int)StringUtils.getLevenshteinDistance((CharSequence)"1234567", (CharSequence)"12345", (int)1));
        StringUtilsTest.assertEquals((int)1, (int)StringUtils.getLevenshteinDistance((CharSequence)"frog", (CharSequence)"fog", (int)1));
        StringUtilsTest.assertEquals((int)3, (int)StringUtils.getLevenshteinDistance((CharSequence)"fly", (CharSequence)"ant", (int)3));
        StringUtilsTest.assertEquals((int)7, (int)StringUtils.getLevenshteinDistance((CharSequence)"elephant", (CharSequence)"hippo", (int)7));
        StringUtilsTest.assertEquals((int)-1, (int)StringUtils.getLevenshteinDistance((CharSequence)"elephant", (CharSequence)"hippo", (int)6));
        StringUtilsTest.assertEquals((int)7, (int)StringUtils.getLevenshteinDistance((CharSequence)"hippo", (CharSequence)"elephant", (int)7));
        StringUtilsTest.assertEquals((int)-1, (int)StringUtils.getLevenshteinDistance((CharSequence)"hippo", (CharSequence)"elephant", (int)6));
        StringUtilsTest.assertEquals((int)8, (int)StringUtils.getLevenshteinDistance((CharSequence)"hippo", (CharSequence)"zzzzzzzz", (int)8));
        StringUtilsTest.assertEquals((int)8, (int)StringUtils.getLevenshteinDistance((CharSequence)"zzzzzzzz", (CharSequence)"hippo", (int)8));
        StringUtilsTest.assertEquals((int)1, (int)StringUtils.getLevenshteinDistance((CharSequence)"hello", (CharSequence)"hallo", (int)1));
        try {
            d = StringUtils.getLevenshteinDistance((CharSequence)"a", null, (int)0);
            StringUtilsTest.fail((String)"expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            d = StringUtils.getLevenshteinDistance(null, (CharSequence)"a", (int)0);
            StringUtilsTest.fail((String)"expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            int d2 = StringUtils.getLevenshteinDistance((CharSequence)"a", (CharSequence)"a", (int)-1);
            StringUtilsTest.fail((String)"expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testEMPTY() {
        StringUtilsTest.assertNotNull((Object)"");
        StringUtilsTest.assertEquals((String)"", (String)"");
        StringUtilsTest.assertEquals((int)0, (int)"".length());
    }

    public void testIsAllLowerCase() {
        StringUtilsTest.assertFalse((boolean)StringUtils.isAllLowerCase(null));
        StringUtilsTest.assertFalse((boolean)StringUtils.isAllLowerCase((CharSequence)""));
        StringUtilsTest.assertTrue((boolean)StringUtils.isAllLowerCase((CharSequence)"abc"));
        StringUtilsTest.assertFalse((boolean)StringUtils.isAllLowerCase((CharSequence)"abc "));
        StringUtilsTest.assertFalse((boolean)StringUtils.isAllLowerCase((CharSequence)"abC"));
    }

    public void testIsAllUpperCase() {
        StringUtilsTest.assertFalse((boolean)StringUtils.isAllUpperCase(null));
        StringUtilsTest.assertFalse((boolean)StringUtils.isAllUpperCase((CharSequence)""));
        StringUtilsTest.assertTrue((boolean)StringUtils.isAllUpperCase((CharSequence)"ABC"));
        StringUtilsTest.assertFalse((boolean)StringUtils.isAllUpperCase((CharSequence)"ABC "));
        StringUtilsTest.assertFalse((boolean)StringUtils.isAllUpperCase((CharSequence)"aBC"));
    }

    public void testRemoveStart() {
        StringUtilsTest.assertNull((Object)StringUtils.removeStart(null, null));
        StringUtilsTest.assertNull((Object)StringUtils.removeStart(null, (String)""));
        StringUtilsTest.assertNull((Object)StringUtils.removeStart(null, (String)"a"));
        StringUtilsTest.assertEquals((String)StringUtils.removeStart((String)"", null), (String)"");
        StringUtilsTest.assertEquals((String)StringUtils.removeStart((String)"", (String)""), (String)"");
        StringUtilsTest.assertEquals((String)StringUtils.removeStart((String)"", (String)"a"), (String)"");
        StringUtilsTest.assertEquals((String)StringUtils.removeStart((String)"www.domain.com", (String)"www."), (String)"domain.com");
        StringUtilsTest.assertEquals((String)StringUtils.removeStart((String)"domain.com", (String)"www."), (String)"domain.com");
        StringUtilsTest.assertEquals((String)StringUtils.removeStart((String)"domain.com", (String)""), (String)"domain.com");
        StringUtilsTest.assertEquals((String)StringUtils.removeStart((String)"domain.com", null), (String)"domain.com");
    }

    public void testRemoveStartIgnoreCase() {
        StringUtilsTest.assertNull((String)"removeStartIgnoreCase(null, null)", (Object)StringUtils.removeStartIgnoreCase(null, null));
        StringUtilsTest.assertNull((String)"removeStartIgnoreCase(null, \"\")", (Object)StringUtils.removeStartIgnoreCase(null, (String)""));
        StringUtilsTest.assertNull((String)"removeStartIgnoreCase(null, \"a\")", (Object)StringUtils.removeStartIgnoreCase(null, (String)"a"));
        StringUtilsTest.assertEquals((String)"removeStartIgnoreCase(\"\", null)", (String)StringUtils.removeStartIgnoreCase((String)"", null), (String)"");
        StringUtilsTest.assertEquals((String)"removeStartIgnoreCase(\"\", \"\")", (String)StringUtils.removeStartIgnoreCase((String)"", (String)""), (String)"");
        StringUtilsTest.assertEquals((String)"removeStartIgnoreCase(\"\", \"a\")", (String)StringUtils.removeStartIgnoreCase((String)"", (String)"a"), (String)"");
        StringUtilsTest.assertEquals((String)"removeStartIgnoreCase(\"www.domain.com\", \"www.\")", (String)StringUtils.removeStartIgnoreCase((String)"www.domain.com", (String)"www."), (String)"domain.com");
        StringUtilsTest.assertEquals((String)"removeStartIgnoreCase(\"domain.com\", \"www.\")", (String)StringUtils.removeStartIgnoreCase((String)"domain.com", (String)"www."), (String)"domain.com");
        StringUtilsTest.assertEquals((String)"removeStartIgnoreCase(\"domain.com\", \"\")", (String)StringUtils.removeStartIgnoreCase((String)"domain.com", (String)""), (String)"domain.com");
        StringUtilsTest.assertEquals((String)"removeStartIgnoreCase(\"domain.com\", null)", (String)StringUtils.removeStartIgnoreCase((String)"domain.com", null), (String)"domain.com");
        StringUtilsTest.assertEquals((String)"removeStartIgnoreCase(\"www.domain.com\", \"WWW.\")", (String)StringUtils.removeStartIgnoreCase((String)"www.domain.com", (String)"WWW."), (String)"domain.com");
    }

    public void testRemoveEnd() {
        StringUtilsTest.assertNull((Object)StringUtils.removeEnd(null, null));
        StringUtilsTest.assertNull((Object)StringUtils.removeEnd(null, (String)""));
        StringUtilsTest.assertNull((Object)StringUtils.removeEnd(null, (String)"a"));
        StringUtilsTest.assertEquals((String)StringUtils.removeEnd((String)"", null), (String)"");
        StringUtilsTest.assertEquals((String)StringUtils.removeEnd((String)"", (String)""), (String)"");
        StringUtilsTest.assertEquals((String)StringUtils.removeEnd((String)"", (String)"a"), (String)"");
        StringUtilsTest.assertEquals((String)StringUtils.removeEnd((String)"www.domain.com.", (String)".com"), (String)"www.domain.com.");
        StringUtilsTest.assertEquals((String)StringUtils.removeEnd((String)"www.domain.com", (String)".com"), (String)"www.domain");
        StringUtilsTest.assertEquals((String)StringUtils.removeEnd((String)"www.domain", (String)".com"), (String)"www.domain");
        StringUtilsTest.assertEquals((String)StringUtils.removeEnd((String)"domain.com", (String)""), (String)"domain.com");
        StringUtilsTest.assertEquals((String)StringUtils.removeEnd((String)"domain.com", null), (String)"domain.com");
    }

    public void testRemoveEndIgnoreCase() {
        StringUtilsTest.assertNull((String)"removeEndIgnoreCase(null, null)", (Object)StringUtils.removeEndIgnoreCase(null, null));
        StringUtilsTest.assertNull((String)"removeEndIgnoreCase(null, \"\")", (Object)StringUtils.removeEndIgnoreCase(null, (String)""));
        StringUtilsTest.assertNull((String)"removeEndIgnoreCase(null, \"a\")", (Object)StringUtils.removeEndIgnoreCase(null, (String)"a"));
        StringUtilsTest.assertEquals((String)"removeEndIgnoreCase(\"\", null)", (String)StringUtils.removeEndIgnoreCase((String)"", null), (String)"");
        StringUtilsTest.assertEquals((String)"removeEndIgnoreCase(\"\", \"\")", (String)StringUtils.removeEndIgnoreCase((String)"", (String)""), (String)"");
        StringUtilsTest.assertEquals((String)"removeEndIgnoreCase(\"\", \"a\")", (String)StringUtils.removeEndIgnoreCase((String)"", (String)"a"), (String)"");
        StringUtilsTest.assertEquals((String)"removeEndIgnoreCase(\"www.domain.com.\", \".com\")", (String)StringUtils.removeEndIgnoreCase((String)"www.domain.com.", (String)".com"), (String)"www.domain.com.");
        StringUtilsTest.assertEquals((String)"removeEndIgnoreCase(\"www.domain.com\", \".com\")", (String)StringUtils.removeEndIgnoreCase((String)"www.domain.com", (String)".com"), (String)"www.domain");
        StringUtilsTest.assertEquals((String)"removeEndIgnoreCase(\"www.domain\", \".com\")", (String)StringUtils.removeEndIgnoreCase((String)"www.domain", (String)".com"), (String)"www.domain");
        StringUtilsTest.assertEquals((String)"removeEndIgnoreCase(\"domain.com\", \"\")", (String)StringUtils.removeEndIgnoreCase((String)"domain.com", (String)""), (String)"domain.com");
        StringUtilsTest.assertEquals((String)"removeEndIgnoreCase(\"domain.com\", null)", (String)StringUtils.removeEndIgnoreCase((String)"domain.com", null), (String)"domain.com");
        StringUtilsTest.assertEquals((String)"removeEndIgnoreCase(\"www.domain.com\", \".COM\")", (String)StringUtils.removeEndIgnoreCase((String)"www.domain.com", (String)".COM"), (String)"www.domain");
        StringUtilsTest.assertEquals((String)"removeEndIgnoreCase(\"www.domain.COM\", \".com\")", (String)StringUtils.removeEndIgnoreCase((String)"www.domain.COM", (String)".com"), (String)"www.domain");
    }

    public void testRemove_String() {
        StringUtilsTest.assertEquals(null, (String)StringUtils.remove(null, null));
        StringUtilsTest.assertEquals(null, (String)StringUtils.remove(null, (String)""));
        StringUtilsTest.assertEquals(null, (String)StringUtils.remove(null, (String)"a"));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.remove((String)"", null));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.remove((String)"", (String)""));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.remove((String)"", (String)"a"));
        StringUtilsTest.assertEquals(null, (String)StringUtils.remove(null, null));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.remove((String)"", null));
        StringUtilsTest.assertEquals((String)"a", (String)StringUtils.remove((String)"a", null));
        StringUtilsTest.assertEquals(null, (String)StringUtils.remove(null, (String)""));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.remove((String)"", (String)""));
        StringUtilsTest.assertEquals((String)"a", (String)StringUtils.remove((String)"a", (String)""));
        StringUtilsTest.assertEquals((String)"qd", (String)StringUtils.remove((String)"queued", (String)"ue"));
        StringUtilsTest.assertEquals((String)"queued", (String)StringUtils.remove((String)"queued", (String)"zz"));
    }

    public void testRemove_char() {
        StringUtilsTest.assertEquals(null, (String)StringUtils.remove(null, (char)'a'));
        StringUtilsTest.assertEquals(null, (String)StringUtils.remove(null, (char)'a'));
        StringUtilsTest.assertEquals(null, (String)StringUtils.remove(null, (char)'a'));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.remove((String)"", (char)'a'));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.remove((String)"", (char)'a'));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.remove((String)"", (char)'a'));
        StringUtilsTest.assertEquals((String)"qeed", (String)StringUtils.remove((String)"queued", (char)'u'));
        StringUtilsTest.assertEquals((String)"queued", (String)StringUtils.remove((String)"queued", (char)'z'));
    }

    public void testDifferenceAt_StringArray() {
        StringUtilsTest.assertEquals((int)-1, (int)StringUtils.indexOfDifference((CharSequence[])null));
        StringUtilsTest.assertEquals((int)-1, (int)StringUtils.indexOfDifference((CharSequence[])new String[0]));
        StringUtilsTest.assertEquals((int)-1, (int)StringUtils.indexOfDifference((CharSequence[])new String[]{"abc"}));
        StringUtilsTest.assertEquals((int)-1, (int)StringUtils.indexOfDifference((CharSequence[])new String[]{null, null}));
        StringUtilsTest.assertEquals((int)-1, (int)StringUtils.indexOfDifference((CharSequence[])new String[]{"", ""}));
        StringUtilsTest.assertEquals((int)0, (int)StringUtils.indexOfDifference((CharSequence[])new String[]{"", null}));
        StringUtilsTest.assertEquals((int)0, (int)StringUtils.indexOfDifference((CharSequence[])new String[]{"abc", null, null}));
        StringUtilsTest.assertEquals((int)0, (int)StringUtils.indexOfDifference((CharSequence[])new String[]{null, null, "abc"}));
        StringUtilsTest.assertEquals((int)0, (int)StringUtils.indexOfDifference((CharSequence[])new String[]{"", "abc"}));
        StringUtilsTest.assertEquals((int)0, (int)StringUtils.indexOfDifference((CharSequence[])new String[]{"abc", ""}));
        StringUtilsTest.assertEquals((int)-1, (int)StringUtils.indexOfDifference((CharSequence[])new String[]{"abc", "abc"}));
        StringUtilsTest.assertEquals((int)1, (int)StringUtils.indexOfDifference((CharSequence[])new String[]{"abc", "a"}));
        StringUtilsTest.assertEquals((int)2, (int)StringUtils.indexOfDifference((CharSequence[])new String[]{"ab", "abxyz"}));
        StringUtilsTest.assertEquals((int)2, (int)StringUtils.indexOfDifference((CharSequence[])new String[]{"abcde", "abxyz"}));
        StringUtilsTest.assertEquals((int)0, (int)StringUtils.indexOfDifference((CharSequence[])new String[]{"abcde", "xyz"}));
        StringUtilsTest.assertEquals((int)0, (int)StringUtils.indexOfDifference((CharSequence[])new String[]{"xyz", "abcde"}));
        StringUtilsTest.assertEquals((int)7, (int)StringUtils.indexOfDifference((CharSequence[])new String[]{"i am a machine", "i am a robot"}));
    }

    public void testGetCommonPrefix_StringArray() {
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.getCommonPrefix((String[])null));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.getCommonPrefix((String[])new String[0]));
        StringUtilsTest.assertEquals((String)"abc", (String)StringUtils.getCommonPrefix((String[])new String[]{"abc"}));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.getCommonPrefix((String[])new String[]{null, null}));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.getCommonPrefix((String[])new String[]{"", ""}));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.getCommonPrefix((String[])new String[]{"", null}));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.getCommonPrefix((String[])new String[]{"abc", null, null}));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.getCommonPrefix((String[])new String[]{null, null, "abc"}));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.getCommonPrefix((String[])new String[]{"", "abc"}));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.getCommonPrefix((String[])new String[]{"abc", ""}));
        StringUtilsTest.assertEquals((String)"abc", (String)StringUtils.getCommonPrefix((String[])new String[]{"abc", "abc"}));
        StringUtilsTest.assertEquals((String)"a", (String)StringUtils.getCommonPrefix((String[])new String[]{"abc", "a"}));
        StringUtilsTest.assertEquals((String)"ab", (String)StringUtils.getCommonPrefix((String[])new String[]{"ab", "abxyz"}));
        StringUtilsTest.assertEquals((String)"ab", (String)StringUtils.getCommonPrefix((String[])new String[]{"abcde", "abxyz"}));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.getCommonPrefix((String[])new String[]{"abcde", "xyz"}));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.getCommonPrefix((String[])new String[]{"xyz", "abcde"}));
        StringUtilsTest.assertEquals((String)"i am a ", (String)StringUtils.getCommonPrefix((String[])new String[]{"i am a machine", "i am a robot"}));
    }

    public void testNormalizeSpace() {
        StringUtilsTest.assertEquals(null, (String)StringUtils.normalizeSpace(null));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.normalizeSpace((String)""));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.normalizeSpace((String)" "));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.normalizeSpace((String)"\t"));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.normalizeSpace((String)"\n"));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.normalizeSpace((String)"\t"));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.normalizeSpace((String)"\u000b"));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.normalizeSpace((String)"\f"));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.normalizeSpace((String)"\u001c"));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.normalizeSpace((String)"\u001d"));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.normalizeSpace((String)"\u001e"));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.normalizeSpace((String)"\u001f"));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.normalizeSpace((String)"\f"));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.normalizeSpace((String)"\r"));
        StringUtilsTest.assertEquals((String)"a", (String)StringUtils.normalizeSpace((String)"  a  "));
        StringUtilsTest.assertEquals((String)"a b c", (String)StringUtils.normalizeSpace((String)"  a  b   c  "));
        StringUtilsTest.assertEquals((String)"a b c", (String)StringUtils.normalizeSpace((String)"a\t\f\r  b\u000b   c\n"));
    }

    public void testLANG666() {
        StringUtilsTest.assertEquals((String)"12", (String)StringUtils.stripEnd((String)"120.00", (String)".0"));
        StringUtilsTest.assertEquals((String)"121", (String)StringUtils.stripEnd((String)"121.00", (String)".0"));
    }

    public void testStringUtilsCharSequenceContract() {
        Method[] methods;
        Class<StringUtils> c = StringUtils.class;
        for (Method m : methods = c.getMethods()) {
            Class<?>[] params;
            if (m.getReturnType() == String.class || m.getReturnType() == String[].class) {
                params = m.getParameterTypes();
                if (params.length <= 0 || params[0] != CharSequence.class && params[0] != CharSequence[].class) continue;
                StringUtilsTest.fail((String)("The method " + m + " appears to be mutable in spirit and therefore must not accept a CharSequence"));
                continue;
            }
            params = m.getParameterTypes();
            if (params.length <= 0 || params[0] != String.class && params[0] != String[].class) continue;
            StringUtilsTest.fail((String)("The method " + m + " appears to be immutable in spirit and therefore must not accept a String"));
        }
    }

    static {
        int i;
        String ws = "";
        String nws = "";
        String tr = "";
        String ntr = "";
        for (i = 0; i < 65535; ++i) {
            if (Character.isWhitespace((char)i)) {
                ws = ws + String.valueOf((char)i);
                if (i <= 32) continue;
                ntr = ntr + String.valueOf((char)i);
                continue;
            }
            if (i >= 40) continue;
            nws = nws + String.valueOf((char)i);
        }
        for (i = 0; i <= 32; ++i) {
            tr = tr + String.valueOf((char)i);
        }
        WHITESPACE = ws;
        NON_WHITESPACE = nws;
        TRIMMABLE = tr;
        NON_TRIMMABLE = ntr;
        ARRAY_LIST = new String[]{FOO_UNCAP, "bar", "baz"};
        EMPTY_ARRAY_LIST = new String[0];
        NULL_ARRAY_LIST = new String[]{null};
        NULL_TO_STRING_LIST = new Object[]{new Object(){

            public String toString() {
                return null;
            }
        }};
        MIXED_ARRAY_LIST = new String[]{null, "", FOO_UNCAP};
        MIXED_TYPE_LIST = new Object[]{FOO_UNCAP, 2L};
    }
}

