/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.commons.lang3.Validate;

public class ValidateTest
extends TestCase {
    public ValidateTest(String name) {
        super(name);
    }

    public void testIsTrue1() {
        Validate.isTrue((boolean)true);
        try {
            Validate.isTrue((boolean)false);
            ValidateTest.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {
            ValidateTest.assertEquals((String)"The validated expression is false", (String)ex.getMessage());
        }
    }

    public void testIsTrue2() {
        Validate.isTrue((boolean)true, (String)"MSG", (Object[])new Object[0]);
        try {
            Validate.isTrue((boolean)false, (String)"MSG", (Object[])new Object[0]);
            ValidateTest.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {
            ValidateTest.assertEquals((String)"MSG", (String)ex.getMessage());
        }
    }

    public void testIsTrue3() {
        Validate.isTrue((boolean)true, (String)"MSG", (long)Integer.valueOf(6).intValue());
        try {
            Validate.isTrue((boolean)false, (String)"MSG", (long)Integer.valueOf(6).intValue());
            ValidateTest.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {
            ValidateTest.assertEquals((String)"MSG", (String)ex.getMessage());
        }
    }

    public void testIsTrue4() {
        Validate.isTrue((boolean)true, (String)"MSG", (long)7L);
        try {
            Validate.isTrue((boolean)false, (String)"MSG", (long)7L);
            ValidateTest.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {
            ValidateTest.assertEquals((String)"MSG", (String)ex.getMessage());
        }
    }

    public void testIsTrue5() {
        Validate.isTrue((boolean)true, (String)"MSG", (double)7.4);
        try {
            Validate.isTrue((boolean)false, (String)"MSG", (double)7.4);
            ValidateTest.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {
            ValidateTest.assertEquals((String)"MSG", (String)ex.getMessage());
        }
    }

    public void testNotNull1() {
        Validate.notNull((Object)new Object());
        try {
            Validate.notNull(null);
            ValidateTest.fail((String)"Expecting NullPointerException");
        }
        catch (NullPointerException ex) {
            ValidateTest.assertEquals((String)"The validated object is null", (String)ex.getMessage());
        }
        String str = "Hi";
        String testStr = (String)Validate.notNull((Object)str);
        ValidateTest.assertSame((Object)str, (Object)testStr);
    }

    public void testNotNull2() {
        Validate.notNull((Object)new Object(), (String)"MSG", (Object[])new Object[0]);
        try {
            Validate.notNull(null, (String)"MSG", (Object[])new Object[0]);
            ValidateTest.fail((String)"Expecting NullPointerException");
        }
        catch (NullPointerException ex) {
            ValidateTest.assertEquals((String)"MSG", (String)ex.getMessage());
        }
        String str = "Hi";
        String testStr = (String)Validate.notNull((Object)str, (String)"Message", (Object[])new Object[0]);
        ValidateTest.assertSame((Object)str, (Object)testStr);
    }

    public void testNotEmptyArray1() {
        Validate.notEmpty((Object[])new Object[]{null});
        try {
            Validate.notEmpty((Object[])null);
            ValidateTest.fail((String)"Expecting NullPointerException");
        }
        catch (NullPointerException ex) {
            ValidateTest.assertEquals((String)"The validated array is empty", (String)ex.getMessage());
        }
        try {
            Validate.notEmpty((Object[])new Object[0]);
            ValidateTest.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {
            ValidateTest.assertEquals((String)"The validated array is empty", (String)ex.getMessage());
        }
        Object[] array = new String[]{"hi"};
        String[] test = (String[])Validate.notEmpty((Object[])array);
        ValidateTest.assertSame((Object)array, (Object)test);
    }

    public void testNotEmptyArray2() {
        Validate.notEmpty((Object[])new Object[]{null}, (String)"MSG", (Object[])new Object[0]);
        try {
            Validate.notEmpty((Object[])null, (String)"MSG", (Object[])new Object[0]);
            ValidateTest.fail((String)"Expecting NullPointerException");
        }
        catch (NullPointerException ex) {
            ValidateTest.assertEquals((String)"MSG", (String)ex.getMessage());
        }
        try {
            Validate.notEmpty((Object[])new Object[0], (String)"MSG", (Object[])new Object[0]);
            ValidateTest.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {
            ValidateTest.assertEquals((String)"MSG", (String)ex.getMessage());
        }
        Object[] array = new String[]{"hi"};
        String[] test = (String[])Validate.notEmpty((Object[])array, (String)"Message", (Object[])new Object[0]);
        ValidateTest.assertSame((Object)array, (Object)test);
    }

    public void testNotEmptyCollection1() {
        ArrayList<Integer> coll = new ArrayList<Integer>();
        try {
            Validate.notEmpty((Collection)null);
            ValidateTest.fail((String)"Expecting NullPointerException");
        }
        catch (NullPointerException ex) {
            ValidateTest.assertEquals((String)"The validated collection is empty", (String)ex.getMessage());
        }
        try {
            Validate.notEmpty(coll);
            ValidateTest.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {
            ValidateTest.assertEquals((String)"The validated collection is empty", (String)ex.getMessage());
        }
        coll.add(8);
        Validate.notEmpty(coll);
        Collection test = Validate.notEmpty(coll);
        ValidateTest.assertSame(coll, (Object)test);
    }

    public void testNotEmptyCollection2() {
        ArrayList<Integer> coll = new ArrayList<Integer>();
        try {
            Validate.notEmpty((Collection)null, (String)"MSG", (Object[])new Object[0]);
            ValidateTest.fail((String)"Expecting NullPointerException");
        }
        catch (NullPointerException ex) {
            ValidateTest.assertEquals((String)"MSG", (String)ex.getMessage());
        }
        try {
            Validate.notEmpty(coll, (String)"MSG", (Object[])new Object[0]);
            ValidateTest.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {
            ValidateTest.assertEquals((String)"MSG", (String)ex.getMessage());
        }
        coll.add(8);
        Validate.notEmpty(coll, (String)"MSG", (Object[])new Object[0]);
        Collection test = Validate.notEmpty(coll, (String)"Message", (Object[])new Object[0]);
        ValidateTest.assertSame(coll, (Object)test);
    }

    public void testNotEmptyMap1() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        try {
            Validate.notEmpty((Map)null);
            ValidateTest.fail((String)"Expecting NullPointerException");
        }
        catch (NullPointerException ex) {
            ValidateTest.assertEquals((String)"The validated map is empty", (String)ex.getMessage());
        }
        try {
            Validate.notEmpty(map);
            ValidateTest.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {
            ValidateTest.assertEquals((String)"The validated map is empty", (String)ex.getMessage());
        }
        map.put("ll", 8);
        Validate.notEmpty(map);
        Map test = Validate.notEmpty(map);
        ValidateTest.assertSame(map, (Object)test);
    }

    public void testNotEmptyMap2() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        try {
            Validate.notEmpty((Map)null, (String)"MSG", (Object[])new Object[0]);
            ValidateTest.fail((String)"Expecting NullPointerException");
        }
        catch (NullPointerException ex) {
            ValidateTest.assertEquals((String)"MSG", (String)ex.getMessage());
        }
        try {
            Validate.notEmpty(map, (String)"MSG", (Object[])new Object[0]);
            ValidateTest.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {
            ValidateTest.assertEquals((String)"MSG", (String)ex.getMessage());
        }
        map.put("ll", 8);
        Validate.notEmpty(map, (String)"MSG", (Object[])new Object[0]);
        Map test = Validate.notEmpty(map, (String)"Message", (Object[])new Object[0]);
        ValidateTest.assertSame(map, (Object)test);
    }

    public void testNotEmptyString1() {
        Validate.notEmpty((CharSequence)"hjl");
        try {
            Validate.notEmpty((CharSequence)null);
            ValidateTest.fail((String)"Expecting NullPointerException");
        }
        catch (NullPointerException ex) {
            ValidateTest.assertEquals((String)"The validated character sequence is empty", (String)ex.getMessage());
        }
        try {
            Validate.notEmpty((CharSequence)"");
            ValidateTest.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {
            ValidateTest.assertEquals((String)"The validated character sequence is empty", (String)ex.getMessage());
        }
        String str = "Hi";
        String testStr = (String)Validate.notEmpty((CharSequence)str);
        ValidateTest.assertSame((Object)str, (Object)testStr);
    }

    public void testNotEmptyString2() {
        Validate.notEmpty((CharSequence)"a", (String)"MSG", (Object[])new Object[0]);
        try {
            Validate.notEmpty((CharSequence)null, (String)"MSG", (Object[])new Object[0]);
            ValidateTest.fail((String)"Expecting NullPointerException");
        }
        catch (NullPointerException ex) {
            ValidateTest.assertEquals((String)"MSG", (String)ex.getMessage());
        }
        try {
            Validate.notEmpty((CharSequence)"", (String)"MSG", (Object[])new Object[0]);
            ValidateTest.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {
            ValidateTest.assertEquals((String)"MSG", (String)ex.getMessage());
        }
        String str = "Hi";
        String testStr = (String)Validate.notEmpty((CharSequence)str, (String)"Message", (Object[])new Object[0]);
        ValidateTest.assertSame((Object)str, (Object)testStr);
    }

    public void testNotBlankNullStringShouldThrow() {
        CharSequence string = null;
        try {
            Validate.notBlank(string);
            ValidateTest.fail((String)"Expecting NullPointerException");
        }
        catch (NullPointerException e) {
            ValidateTest.assertEquals((String)"The validated character sequence is blank", (String)e.getMessage());
        }
    }

    public void testNotBlankMsgNullStringShouldThrow() {
        CharSequence string = null;
        try {
            Validate.notBlank(string, (String)"Message", (Object[])new Object[0]);
            ValidateTest.fail((String)"Expecting NullPointerException");
        }
        catch (NullPointerException e) {
            ValidateTest.assertEquals((String)"Message", (String)e.getMessage());
        }
    }

    public void testNotBlankEmptyStringShouldThrow() {
        String string = "";
        try {
            Validate.notBlank((CharSequence)string);
            ValidateTest.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            ValidateTest.assertEquals((String)"The validated character sequence is blank", (String)e.getMessage());
        }
    }

    public void testNotBlankBlankStringWithWhitespacesShouldThrow() {
        String string = "   ";
        try {
            Validate.notBlank((CharSequence)string);
            ValidateTest.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            ValidateTest.assertEquals((String)"The validated character sequence is blank", (String)e.getMessage());
        }
    }

    public void testNotBlankBlankStringWithNewlinesShouldThrow() {
        String string = " \n \t \r \n ";
        try {
            Validate.notBlank((CharSequence)string);
            ValidateTest.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            ValidateTest.assertEquals((String)"The validated character sequence is blank", (String)e.getMessage());
        }
    }

    public void testNotBlankMsgBlankStringShouldThrow() {
        String string = " \n \t \r \n ";
        try {
            Validate.notBlank((CharSequence)string, (String)"Message", (Object[])new Object[0]);
            ValidateTest.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            ValidateTest.assertEquals((String)"Message", (String)e.getMessage());
        }
    }

    public void testNotBlankMsgBlankStringWithWhitespacesShouldThrow() {
        String string = "   ";
        try {
            Validate.notBlank((CharSequence)string, (String)"Message", (Object[])new Object[0]);
            ValidateTest.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            ValidateTest.assertEquals((String)"Message", (String)e.getMessage());
        }
    }

    public void testNotBlankMsgEmptyStringShouldThrow() {
        String string = "";
        try {
            Validate.notBlank((CharSequence)string, (String)"Message", (Object[])new Object[0]);
            ValidateTest.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            ValidateTest.assertEquals((String)"Message", (String)e.getMessage());
        }
    }

    public void testNotBlankNotBlankStringShouldNotThrow() {
        String string = "abc";
        Validate.notBlank((CharSequence)string);
    }

    public void testNotBlankNotBlankStringWithWhitespacesShouldNotThrow() {
        String string = "  abc   ";
        Validate.notBlank((CharSequence)string);
    }

    public void testNotBlankNotBlankStringWithNewlinesShouldNotThrow() {
        String string = " \n \t abc \r \n ";
        Validate.notBlank((CharSequence)string);
    }

    public void testNotBlankMsgNotBlankStringShouldNotThrow() {
        String string = "abc";
        Validate.notBlank((CharSequence)string, (String)"Message", (Object[])new Object[0]);
    }

    public void testNotBlankMsgNotBlankStringWithWhitespacesShouldNotThrow() {
        String string = "  abc   ";
        Validate.notBlank((CharSequence)string, (String)"Message", (Object[])new Object[0]);
    }

    public void testNotBlankMsgNotBlankStringWithNewlinesShouldNotThrow() {
        String string = " \n \t abc \r \n ";
        Validate.notBlank((CharSequence)string, (String)"Message", (Object[])new Object[0]);
    }

    public void testNotBlankReturnValues1() {
        String str = "Hi";
        String test = (String)Validate.notBlank((CharSequence)str);
        ValidateTest.assertSame((Object)str, (Object)test);
    }

    public void testNotBlankReturnValues2() {
        String str = "Hi";
        String test = (String)Validate.notBlank((CharSequence)str, (String)"Message", (Object[])new Object[0]);
        ValidateTest.assertSame((Object)str, (Object)test);
    }

    public void testNoNullElementsArray1() {
        Object[] array = new String[]{"a", "b"};
        Validate.noNullElements((Object[])array);
        try {
            Validate.noNullElements((Object[])null);
            ValidateTest.fail((String)"Expecting NullPointerException");
        }
        catch (NullPointerException ex) {
            ValidateTest.assertEquals((String)"The validated object is null", (String)ex.getMessage());
        }
        array[1] = null;
        try {
            Validate.noNullElements((Object[])array);
            ValidateTest.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {
            ValidateTest.assertEquals((String)"The validated array contains null element at index: 1", (String)ex.getMessage());
        }
        array = new String[]{"a", "b"};
        String[] test = (String[])Validate.noNullElements((Object[])array);
        ValidateTest.assertSame((Object)array, (Object)test);
    }

    public void testNoNullElementsArray2() {
        Object[] array = new String[]{"a", "b"};
        Validate.noNullElements((Object[])array, (String)"MSG", (Object[])new Object[0]);
        try {
            Validate.noNullElements((Object[])null, (String)"MSG", (Object[])new Object[0]);
            ValidateTest.fail((String)"Expecting NullPointerException");
        }
        catch (NullPointerException ex) {
            ValidateTest.assertEquals((String)"The validated object is null", (String)ex.getMessage());
        }
        array[1] = null;
        try {
            Validate.noNullElements((Object[])array, (String)"MSG", (Object[])new Object[0]);
            ValidateTest.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {
            ValidateTest.assertEquals((String)"MSG", (String)ex.getMessage());
        }
        array = new String[]{"a", "b"};
        String[] test = (String[])Validate.noNullElements((Object[])array, (String)"Message", (Object[])new Object[0]);
        ValidateTest.assertSame((Object)array, (Object)test);
    }

    public void testNoNullElementsCollection1() {
        ArrayList<String> coll = new ArrayList<String>();
        coll.add("a");
        coll.add("b");
        Validate.noNullElements(coll);
        try {
            Validate.noNullElements((Iterable)null);
            ValidateTest.fail((String)"Expecting NullPointerException");
        }
        catch (NullPointerException ex) {
            ValidateTest.assertEquals((String)"The validated object is null", (String)ex.getMessage());
        }
        coll.set(1, null);
        try {
            Validate.noNullElements(coll);
            ValidateTest.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {
            ValidateTest.assertEquals((String)"The validated collection contains null element at index: 1", (String)ex.getMessage());
        }
        coll.set(1, "b");
        List test = (List)Validate.noNullElements(coll);
        ValidateTest.assertSame(coll, (Object)test);
    }

    public void testNoNullElementsCollection2() {
        ArrayList<String> coll = new ArrayList<String>();
        coll.add("a");
        coll.add("b");
        Validate.noNullElements(coll, (String)"MSG", (Object[])new Object[0]);
        try {
            Validate.noNullElements((Iterable)null, (String)"MSG", (Object[])new Object[0]);
            ValidateTest.fail((String)"Expecting NullPointerException");
        }
        catch (NullPointerException ex) {
            ValidateTest.assertEquals((String)"The validated object is null", (String)ex.getMessage());
        }
        coll.set(1, null);
        try {
            Validate.noNullElements(coll, (String)"MSG", (Object[])new Object[0]);
            ValidateTest.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {
            ValidateTest.assertEquals((String)"MSG", (String)ex.getMessage());
        }
        coll.set(1, "b");
        List test = (List)Validate.noNullElements(coll, (String)"Message", (Object[])new Object[0]);
        ValidateTest.assertSame(coll, (Object)test);
    }

    public void testConstructor() {
        ValidateTest.assertNotNull((Object)new Validate());
        Constructor<?>[] cons = Validate.class.getDeclaredConstructors();
        ValidateTest.assertEquals((int)1, (int)cons.length);
        ValidateTest.assertEquals((boolean)true, (boolean)Modifier.isPublic(cons[0].getModifiers()));
        ValidateTest.assertEquals((boolean)true, (boolean)Modifier.isPublic(Validate.class.getModifiers()));
        ValidateTest.assertEquals((boolean)false, (boolean)Modifier.isFinal(Validate.class.getModifiers()));
    }

    public void testValidIndex_withMessage_array() {
        Object[] array = new Object[2];
        Validate.validIndex((Object[])array, (int)0, (String)"Broken: ", (Object[])new Object[0]);
        Validate.validIndex((Object[])array, (int)1, (String)"Broken: ", (Object[])new Object[0]);
        try {
            Validate.validIndex((Object[])array, (int)-1, (String)"Broken: ", (Object[])new Object[0]);
            ValidateTest.fail((String)"Expecting IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException ex) {
            ValidateTest.assertEquals((String)"Broken: ", (String)ex.getMessage());
        }
        try {
            Validate.validIndex((Object[])array, (int)2, (String)"Broken: ", (Object[])new Object[0]);
            ValidateTest.fail((String)"Expecting IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException ex) {
            ValidateTest.assertEquals((String)"Broken: ", (String)ex.getMessage());
        }
        Object[] strArray = new String[]{"Hi"};
        String[] test = (String[])Validate.noNullElements((Object[])strArray, (String)"Message", (Object[])new Object[0]);
        ValidateTest.assertSame((Object)strArray, (Object)test);
    }

    public void testValidIndex_array() {
        Object[] array = new Object[2];
        Validate.validIndex((Object[])array, (int)0);
        Validate.validIndex((Object[])array, (int)1);
        try {
            Validate.validIndex((Object[])array, (int)-1);
            ValidateTest.fail((String)"Expecting IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException ex) {
            ValidateTest.assertEquals((String)"The validated array index is invalid: -1", (String)ex.getMessage());
        }
        try {
            Validate.validIndex((Object[])array, (int)2);
            ValidateTest.fail((String)"Expecting IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException ex) {
            ValidateTest.assertEquals((String)"The validated array index is invalid: 2", (String)ex.getMessage());
        }
        Object[] strArray = new String[]{"Hi"};
        String[] test = (String[])Validate.noNullElements((Object[])strArray);
        ValidateTest.assertSame((Object)strArray, (Object)test);
    }

    public void testValidIndex_withMessage_collection() {
        ArrayList<Object> coll = new ArrayList<Object>();
        coll.add(null);
        coll.add(null);
        Validate.validIndex(coll, (int)0, (String)"Broken: ", (Object[])new Object[0]);
        Validate.validIndex(coll, (int)1, (String)"Broken: ", (Object[])new Object[0]);
        try {
            Validate.validIndex(coll, (int)-1, (String)"Broken: ", (Object[])new Object[0]);
            ValidateTest.fail((String)"Expecting IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException ex) {
            ValidateTest.assertEquals((String)"Broken: ", (String)ex.getMessage());
        }
        try {
            Validate.validIndex(coll, (int)2, (String)"Broken: ", (Object[])new Object[0]);
            ValidateTest.fail((String)"Expecting IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException ex) {
            ValidateTest.assertEquals((String)"Broken: ", (String)ex.getMessage());
        }
        List<String> strColl = Arrays.asList("Hi");
        List test = (List)Validate.validIndex(strColl, (int)0, (String)"Message", (Object[])new Object[0]);
        ValidateTest.assertSame(strColl, (Object)test);
    }

    public void testValidIndex_collection() {
        ArrayList<Object> coll = new ArrayList<Object>();
        coll.add(null);
        coll.add(null);
        Validate.validIndex(coll, (int)0);
        Validate.validIndex(coll, (int)1);
        try {
            Validate.validIndex(coll, (int)-1);
            ValidateTest.fail((String)"Expecting IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException ex) {
            ValidateTest.assertEquals((String)"The validated collection index is invalid: -1", (String)ex.getMessage());
        }
        try {
            Validate.validIndex(coll, (int)2);
            ValidateTest.fail((String)"Expecting IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException ex) {
            ValidateTest.assertEquals((String)"The validated collection index is invalid: 2", (String)ex.getMessage());
        }
        List<String> strColl = Arrays.asList("Hi");
        List test = (List)Validate.validIndex(strColl, (int)0);
        ValidateTest.assertSame(strColl, (Object)test);
    }

    public void testValidIndex_withMessage_charSequence() {
        String str = "Hi";
        Validate.validIndex((CharSequence)str, (int)0, (String)"Broken: ", (Object[])new Object[0]);
        Validate.validIndex((CharSequence)str, (int)1, (String)"Broken: ", (Object[])new Object[0]);
        try {
            Validate.validIndex((CharSequence)str, (int)-1, (String)"Broken: ", (Object[])new Object[0]);
            ValidateTest.fail((String)"Expecting IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException ex) {
            ValidateTest.assertEquals((String)"Broken: ", (String)ex.getMessage());
        }
        try {
            Validate.validIndex((CharSequence)str, (int)2, (String)"Broken: ", (Object[])new Object[0]);
            ValidateTest.fail((String)"Expecting IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException ex) {
            ValidateTest.assertEquals((String)"Broken: ", (String)ex.getMessage());
        }
        String input = "Hi";
        String test = (String)Validate.validIndex((CharSequence)input, (int)0, (String)"Message", (Object[])new Object[0]);
        ValidateTest.assertSame((Object)input, (Object)test);
    }

    public void testValidIndex_charSequence() {
        String str = "Hi";
        Validate.validIndex((CharSequence)str, (int)0);
        Validate.validIndex((CharSequence)str, (int)1);
        try {
            Validate.validIndex((CharSequence)str, (int)-1);
            ValidateTest.fail((String)"Expecting IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException ex) {
            ValidateTest.assertEquals((String)"The validated character sequence index is invalid: -1", (String)ex.getMessage());
        }
        try {
            Validate.validIndex((CharSequence)str, (int)2);
            ValidateTest.fail((String)"Expecting IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException ex) {
            ValidateTest.assertEquals((String)"The validated character sequence index is invalid: 2", (String)ex.getMessage());
        }
        String input = "Hi";
        String test = (String)Validate.validIndex((CharSequence)input, (int)0);
        ValidateTest.assertSame((Object)input, (Object)test);
    }

    public void testMatchesPattern() {
        String str = "hi";
        Validate.matchesPattern((CharSequence)str, (String)"[a-z]*");
        try {
            Validate.matchesPattern((CharSequence)str, (String)"[0-9]*");
            ValidateTest.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            ValidateTest.assertEquals((String)"The string hi does not match the pattern [0-9]*", (String)e.getMessage());
        }
    }

    public void testMatchesPattern_withMessage() {
        String str = "hi";
        Validate.matchesPattern((CharSequence)str, (String)"[a-z]*", (String)"Does not match", (Object[])new Object[0]);
        try {
            Validate.matchesPattern((CharSequence)str, (String)"[0-9]*", (String)"Does not match", (Object[])new Object[0]);
            ValidateTest.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            ValidateTest.assertEquals((String)"Does not match", (String)e.getMessage());
        }
    }

    public void testInclusiveBetween() {
        Validate.inclusiveBetween((Object)"a", (Object)"c", (Comparable)((Object)"b"));
        Validate.inclusiveBetween((Object)0, (Object)2, (Comparable)Integer.valueOf(1));
        Validate.inclusiveBetween((Object)0, (Object)2, (Comparable)Integer.valueOf(2));
        try {
            Validate.inclusiveBetween((Object)0, (Object)5, (Comparable)Integer.valueOf(6));
            ValidateTest.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            ValidateTest.assertEquals((String)"The value 6 is not in the specified inclusive range of 0 to 5", (String)e.getMessage());
        }
    }

    public void testInclusiveBetween_withMessage() {
        Validate.inclusiveBetween((Object)"a", (Object)"c", (Comparable)((Object)"b"), (String)"Error", (Object[])new Object[0]);
        Validate.inclusiveBetween((Object)0, (Object)2, (Comparable)Integer.valueOf(1), (String)"Error", (Object[])new Object[0]);
        Validate.inclusiveBetween((Object)0, (Object)2, (Comparable)Integer.valueOf(2), (String)"Error", (Object[])new Object[0]);
        try {
            Validate.inclusiveBetween((Object)0, (Object)5, (Comparable)Integer.valueOf(6), (String)"Error", (Object[])new Object[0]);
            ValidateTest.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            ValidateTest.assertEquals((String)"Error", (String)e.getMessage());
        }
    }

    public void testExclusiveBetween() {
        Validate.exclusiveBetween((Object)"a", (Object)"c", (Comparable)((Object)"b"));
        Validate.exclusiveBetween((Object)0, (Object)2, (Comparable)Integer.valueOf(1));
        try {
            Validate.exclusiveBetween((Object)0, (Object)5, (Comparable)Integer.valueOf(6));
            ValidateTest.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            ValidateTest.assertEquals((String)"The value 6 is not in the specified exclusive range of 0 to 5", (String)e.getMessage());
        }
        try {
            Validate.exclusiveBetween((Object)0, (Object)5, (Comparable)Integer.valueOf(5));
            ValidateTest.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            ValidateTest.assertEquals((String)"The value 5 is not in the specified exclusive range of 0 to 5", (String)e.getMessage());
        }
    }

    public void testExclusiveBetween_withMessage() {
        Validate.exclusiveBetween((Object)"a", (Object)"c", (Comparable)((Object)"b"), (String)"Error", (Object[])new Object[0]);
        Validate.exclusiveBetween((Object)0, (Object)2, (Comparable)Integer.valueOf(1), (String)"Error", (Object[])new Object[0]);
        try {
            Validate.exclusiveBetween((Object)0, (Object)5, (Comparable)Integer.valueOf(6), (String)"Error", (Object[])new Object[0]);
            ValidateTest.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            ValidateTest.assertEquals((String)"Error", (String)e.getMessage());
        }
        try {
            Validate.exclusiveBetween((Object)0, (Object)5, (Comparable)Integer.valueOf(5), (String)"Error", (Object[])new Object[0]);
            ValidateTest.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            ValidateTest.assertEquals((String)"Error", (String)e.getMessage());
        }
    }

    public void testIsInstanceOf() {
        Validate.isInstanceOf(String.class, (Object)"hi");
        Validate.isInstanceOf(Integer.class, (Object)1);
        try {
            Validate.isInstanceOf(List.class, (Object)"hi");
            ValidateTest.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            ValidateTest.assertEquals((String)"The validated object is not an instance of java.util.List", (String)e.getMessage());
        }
    }

    public void testIsInstanceOf_withMessage() {
        Validate.isInstanceOf(String.class, (Object)"hi", (String)"Error", (Object[])new Object[0]);
        Validate.isInstanceOf(Integer.class, (Object)1, (String)"Error", (Object[])new Object[0]);
        try {
            Validate.isInstanceOf(List.class, (Object)"hi", (String)"Error", (Object[])new Object[0]);
            ValidateTest.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            ValidateTest.assertEquals((String)"Error", (String)e.getMessage());
        }
    }

    public void testIsAssignable() {
        Validate.isAssignableFrom(CharSequence.class, String.class);
        Validate.isAssignableFrom(AbstractList.class, ArrayList.class);
        try {
            Validate.isAssignableFrom(List.class, String.class);
            ValidateTest.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            ValidateTest.assertEquals((String)"The validated class can not be converted to the java.util.List class", (String)e.getMessage());
        }
    }

    public void testIsAssignable_withMessage() {
        Validate.isAssignableFrom(CharSequence.class, String.class, (String)"Error", (Object[])new Object[0]);
        Validate.isAssignableFrom(AbstractList.class, ArrayList.class, (String)"Error", (Object[])new Object[0]);
        try {
            Validate.isAssignableFrom(List.class, String.class, (String)"Error", (Object[])new Object[0]);
            ValidateTest.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            ValidateTest.assertEquals((String)"Error", (String)e.getMessage());
        }
    }
}

