/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import java.util.Arrays;
import junit.framework.TestCase;
import org.apache.commons.lang3.builder.EqualsBuilder;

public class EqualsBuilderTest
extends TestCase {
    public EqualsBuilderTest(String name) {
        super(name);
    }

    public void testReflectionEquals() {
        TestObject o1 = new TestObject(4);
        TestObject o2 = new TestObject(5);
        EqualsBuilderTest.assertTrue((boolean)EqualsBuilder.reflectionEquals((Object)o1, (Object)o1, (String[])new String[0]));
        EqualsBuilderTest.assertTrue((!EqualsBuilder.reflectionEquals((Object)o1, (Object)o2, (String[])new String[0]) ? 1 : 0) != 0);
        o2.setA(4);
        EqualsBuilderTest.assertTrue((boolean)EqualsBuilder.reflectionEquals((Object)o1, (Object)o2, (String[])new String[0]));
        EqualsBuilderTest.assertTrue((!EqualsBuilder.reflectionEquals((Object)o1, (Object)((Object)this), (String[])new String[0]) ? 1 : 0) != 0);
        EqualsBuilderTest.assertTrue((!EqualsBuilder.reflectionEquals((Object)o1, null, (String[])new String[0]) ? 1 : 0) != 0);
        EqualsBuilderTest.assertTrue((!EqualsBuilder.reflectionEquals(null, (Object)o2, (String[])new String[0]) ? 1 : 0) != 0);
        EqualsBuilderTest.assertTrue((boolean)EqualsBuilder.reflectionEquals((Object)null, (Object)null, (String[])new String[0]));
    }

    public void testReflectionHierarchyEquals() {
        this.testReflectionHierarchyEquals(false);
        this.testReflectionHierarchyEquals(true);
        EqualsBuilderTest.assertTrue((boolean)EqualsBuilder.reflectionEquals((Object)new TestTTLeafObject(1, 2, 3, 4), (Object)new TestTTLeafObject(1, 2, 3, 4), (boolean)true));
        EqualsBuilderTest.assertTrue((boolean)EqualsBuilder.reflectionEquals((Object)new TestTTLeafObject(1, 2, 3, 4), (Object)new TestTTLeafObject(1, 2, 3, 4), (boolean)false));
        EqualsBuilderTest.assertTrue((!EqualsBuilder.reflectionEquals((Object)new TestTTLeafObject(1, 0, 0, 4), (Object)new TestTTLeafObject(1, 2, 3, 4), (boolean)true) ? 1 : 0) != 0);
        EqualsBuilderTest.assertTrue((!EqualsBuilder.reflectionEquals((Object)new TestTTLeafObject(1, 2, 3, 4), (Object)new TestTTLeafObject(1, 2, 3, 0), (boolean)true) ? 1 : 0) != 0);
        EqualsBuilderTest.assertTrue((!EqualsBuilder.reflectionEquals((Object)new TestTTLeafObject(0, 2, 3, 4), (Object)new TestTTLeafObject(1, 2, 3, 4), (boolean)true) ? 1 : 0) != 0);
    }

    public void testReflectionHierarchyEquals(boolean testTransients) {
        TestObject to1 = new TestObject(4);
        TestObject to1Bis = new TestObject(4);
        TestObject to1Ter = new TestObject(4);
        TestObject to2 = new TestObject(5);
        TestEmptySubObject teso = new TestEmptySubObject(4);
        TestTSubObject ttso = new TestTSubObject(4, 1);
        TestTTSubObject tttso = new TestTTSubObject(4, 1, 2);
        TestTTLeafObject ttlo = new TestTTLeafObject(4, 1, 2, 3);
        TestSubObject tso1 = new TestSubObject(1, 4);
        TestSubObject tso1bis = new TestSubObject(1, 4);
        TestSubObject tso1ter = new TestSubObject(1, 4);
        TestSubObject tso2 = new TestSubObject(2, 5);
        this.testReflectionEqualsEquivalenceRelationship(to1, to1Bis, to1Ter, to2, new TestObject(), testTransients);
        this.testReflectionEqualsEquivalenceRelationship(tso1, tso1bis, tso1ter, tso2, new TestSubObject(), testTransients);
        EqualsBuilderTest.assertTrue((boolean)EqualsBuilder.reflectionEquals((Object)ttlo, (Object)ttlo, (boolean)testTransients));
        EqualsBuilderTest.assertTrue((boolean)EqualsBuilder.reflectionEquals((Object)new TestSubObject(1, 10), (Object)new TestSubObject(1, 10), (boolean)testTransients));
        EqualsBuilderTest.assertTrue((!EqualsBuilder.reflectionEquals((Object)new TestSubObject(1, 10), (Object)new TestSubObject(1, 11), (boolean)testTransients) ? 1 : 0) != 0);
        EqualsBuilderTest.assertTrue((!EqualsBuilder.reflectionEquals((Object)new TestSubObject(1, 11), (Object)new TestSubObject(1, 10), (boolean)testTransients) ? 1 : 0) != 0);
        EqualsBuilderTest.assertTrue((!EqualsBuilder.reflectionEquals((Object)new TestSubObject(0, 10), (Object)new TestSubObject(1, 10), (boolean)testTransients) ? 1 : 0) != 0);
        EqualsBuilderTest.assertTrue((!EqualsBuilder.reflectionEquals((Object)new TestSubObject(1, 10), (Object)new TestSubObject(0, 10), (boolean)testTransients) ? 1 : 0) != 0);
        EqualsBuilderTest.assertTrue((boolean)EqualsBuilder.reflectionEquals((Object)to1, (Object)teso, (boolean)testTransients));
        EqualsBuilderTest.assertTrue((boolean)EqualsBuilder.reflectionEquals((Object)teso, (Object)to1, (boolean)testTransients));
        EqualsBuilderTest.assertTrue((boolean)EqualsBuilder.reflectionEquals((Object)to1, (Object)ttso, (boolean)false));
        EqualsBuilderTest.assertTrue((boolean)EqualsBuilder.reflectionEquals((Object)ttso, (Object)to1, (boolean)false));
        EqualsBuilderTest.assertTrue((boolean)EqualsBuilder.reflectionEquals((Object)to1, (Object)tttso, (boolean)false));
        EqualsBuilderTest.assertTrue((boolean)EqualsBuilder.reflectionEquals((Object)tttso, (Object)to1, (boolean)false));
        EqualsBuilderTest.assertTrue((boolean)EqualsBuilder.reflectionEquals((Object)ttso, (Object)tttso, (boolean)false));
        EqualsBuilderTest.assertTrue((boolean)EqualsBuilder.reflectionEquals((Object)tttso, (Object)ttso, (boolean)false));
        EqualsBuilderTest.assertTrue((!EqualsBuilder.reflectionEquals((Object)new TestObject(0), (Object)new TestEmptySubObject(1), (boolean)testTransients) ? 1 : 0) != 0);
        EqualsBuilderTest.assertTrue((!EqualsBuilder.reflectionEquals((Object)new TestEmptySubObject(1), (Object)new TestObject(0), (boolean)testTransients) ? 1 : 0) != 0);
        EqualsBuilderTest.assertTrue((!EqualsBuilder.reflectionEquals((Object)new TestObject(0), (Object)new TestTSubObject(1, 1), (boolean)testTransients) ? 1 : 0) != 0);
        EqualsBuilderTest.assertTrue((!EqualsBuilder.reflectionEquals((Object)new TestTSubObject(1, 1), (Object)new TestObject(0), (boolean)testTransients) ? 1 : 0) != 0);
        EqualsBuilderTest.assertTrue((!EqualsBuilder.reflectionEquals((Object)new TestObject(1), (Object)new TestSubObject(0, 10), (boolean)testTransients) ? 1 : 0) != 0);
        EqualsBuilderTest.assertTrue((!EqualsBuilder.reflectionEquals((Object)new TestSubObject(0, 10), (Object)new TestObject(1), (boolean)testTransients) ? 1 : 0) != 0);
        EqualsBuilderTest.assertTrue((!EqualsBuilder.reflectionEquals((Object)to1, (Object)ttlo, (String[])new String[0]) ? 1 : 0) != 0);
        EqualsBuilderTest.assertTrue((!EqualsBuilder.reflectionEquals((Object)tso1, (Object)((Object)this), (String[])new String[0]) ? 1 : 0) != 0);
    }

    public void testReflectionEqualsEquivalenceRelationship(TestObject to, TestObject toBis, TestObject toTer, TestObject to2, TestObject oToChange, boolean testTransients) {
        EqualsBuilderTest.assertTrue((boolean)EqualsBuilder.reflectionEquals((Object)to, (Object)to, (boolean)testTransients));
        EqualsBuilderTest.assertTrue((boolean)EqualsBuilder.reflectionEquals((Object)to2, (Object)to2, (boolean)testTransients));
        EqualsBuilderTest.assertTrue((EqualsBuilder.reflectionEquals((Object)to, (Object)toBis, (boolean)testTransients) && EqualsBuilder.reflectionEquals((Object)toBis, (Object)to, (boolean)testTransients) ? 1 : 0) != 0);
        EqualsBuilderTest.assertTrue((EqualsBuilder.reflectionEquals((Object)to, (Object)toBis, (boolean)testTransients) && EqualsBuilder.reflectionEquals((Object)toBis, (Object)toTer, (boolean)testTransients) && EqualsBuilder.reflectionEquals((Object)to, (Object)toTer, (boolean)testTransients) ? 1 : 0) != 0);
        oToChange.setA(to.getA());
        if (oToChange instanceof TestSubObject) {
            ((TestSubObject)oToChange).setB(((TestSubObject)to).getB());
        }
        EqualsBuilderTest.assertTrue((boolean)EqualsBuilder.reflectionEquals((Object)oToChange, (Object)to, (boolean)testTransients));
        EqualsBuilderTest.assertTrue((boolean)EqualsBuilder.reflectionEquals((Object)oToChange, (Object)to, (boolean)testTransients));
        oToChange.setA(to.getA() + 1);
        if (oToChange instanceof TestSubObject) {
            ((TestSubObject)oToChange).setB(((TestSubObject)to).getB() + 1);
        }
        EqualsBuilderTest.assertTrue((!EqualsBuilder.reflectionEquals((Object)oToChange, (Object)to, (boolean)testTransients) ? 1 : 0) != 0);
        EqualsBuilderTest.assertTrue((!EqualsBuilder.reflectionEquals((Object)oToChange, (Object)to, (boolean)testTransients) ? 1 : 0) != 0);
        EqualsBuilderTest.assertTrue((!EqualsBuilder.reflectionEquals((Object)to, null, (boolean)testTransients) ? 1 : 0) != 0);
        EqualsBuilderTest.assertTrue((!EqualsBuilder.reflectionEquals((Object)to2, null, (boolean)testTransients) ? 1 : 0) != 0);
        EqualsBuilderTest.assertTrue((!EqualsBuilder.reflectionEquals(null, (Object)to, (boolean)testTransients) ? 1 : 0) != 0);
        EqualsBuilderTest.assertTrue((!EqualsBuilder.reflectionEquals(null, (Object)to2, (boolean)testTransients) ? 1 : 0) != 0);
        EqualsBuilderTest.assertTrue((boolean)EqualsBuilder.reflectionEquals((Object)null, (Object)null, (boolean)testTransients));
    }

    public void testSuper() {
        TestObject o1 = new TestObject(4);
        TestObject o2 = new TestObject(5);
        EqualsBuilderTest.assertEquals((boolean)true, (boolean)new EqualsBuilder().appendSuper(true).append((Object)o1, (Object)o1).isEquals());
        EqualsBuilderTest.assertEquals((boolean)false, (boolean)new EqualsBuilder().appendSuper(false).append((Object)o1, (Object)o1).isEquals());
        EqualsBuilderTest.assertEquals((boolean)false, (boolean)new EqualsBuilder().appendSuper(true).append((Object)o1, (Object)o2).isEquals());
        EqualsBuilderTest.assertEquals((boolean)false, (boolean)new EqualsBuilder().appendSuper(false).append((Object)o1, (Object)o2).isEquals());
    }

    public void testObject() {
        TestObject o1 = new TestObject(4);
        TestObject o2 = new TestObject(5);
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append((Object)o1, (Object)o1).isEquals());
        EqualsBuilderTest.assertTrue((!new EqualsBuilder().append((Object)o1, (Object)o2).isEquals() ? 1 : 0) != 0);
        o2.setA(4);
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append((Object)o1, (Object)o2).isEquals());
        EqualsBuilderTest.assertTrue((!new EqualsBuilder().append((Object)o1, (Object)this).isEquals() ? 1 : 0) != 0);
        EqualsBuilderTest.assertTrue((!new EqualsBuilder().append((Object)o1, null).isEquals() ? 1 : 0) != 0);
        EqualsBuilderTest.assertTrue((!new EqualsBuilder().append(null, (Object)o2).isEquals() ? 1 : 0) != 0);
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append((Object)null, (Object)null).isEquals());
    }

    public void testObjectBuild() {
        TestObject o1 = new TestObject(4);
        TestObject o2 = new TestObject(5);
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append((Object)o1, (Object)o1).build());
        EqualsBuilderTest.assertTrue((new EqualsBuilder().append((Object)o1, (Object)o2).build() == false ? 1 : 0) != 0);
        o2.setA(4);
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append((Object)o1, (Object)o2).build());
        EqualsBuilderTest.assertTrue((new EqualsBuilder().append((Object)o1, (Object)this).build() == false ? 1 : 0) != 0);
        EqualsBuilderTest.assertTrue((new EqualsBuilder().append((Object)o1, null).build() == false ? 1 : 0) != 0);
        EqualsBuilderTest.assertTrue((new EqualsBuilder().append(null, (Object)o2).build() == false ? 1 : 0) != 0);
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append((Object)null, (Object)null).build());
    }

    public void testLong() {
        long o1 = 1L;
        long o2 = 2L;
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append(o1, o1).isEquals());
        EqualsBuilderTest.assertTrue((!new EqualsBuilder().append(o1, o2).isEquals() ? 1 : 0) != 0);
    }

    public void testInt() {
        int o1 = 1;
        int o2 = 2;
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append(o1, o1).isEquals());
        EqualsBuilderTest.assertTrue((!new EqualsBuilder().append(o1, o2).isEquals() ? 1 : 0) != 0);
    }

    public void testShort() {
        short o1 = 1;
        short o2 = 2;
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append(o1, o1).isEquals());
        EqualsBuilderTest.assertTrue((!new EqualsBuilder().append(o1, o2).isEquals() ? 1 : 0) != 0);
    }

    public void testChar() {
        char o1 = '\u0001';
        char o2 = '\u0002';
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append(o1, o1).isEquals());
        EqualsBuilderTest.assertTrue((!new EqualsBuilder().append(o1, o2).isEquals() ? 1 : 0) != 0);
    }

    public void testByte() {
        byte o1 = 1;
        byte o2 = 2;
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append(o1, o1).isEquals());
        EqualsBuilderTest.assertTrue((!new EqualsBuilder().append(o1, o2).isEquals() ? 1 : 0) != 0);
    }

    public void testDouble() {
        double o1 = 1.0;
        double o2 = 2.0;
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append(o1, o1).isEquals());
        EqualsBuilderTest.assertTrue((!new EqualsBuilder().append(o1, o2).isEquals() ? 1 : 0) != 0);
        EqualsBuilderTest.assertTrue((!new EqualsBuilder().append(o1, Double.NaN).isEquals() ? 1 : 0) != 0);
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append(Double.NaN, Double.NaN).isEquals());
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY).isEquals());
    }

    public void testFloat() {
        float o1 = 1.0f;
        float o2 = 2.0f;
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append(o1, o1).isEquals());
        EqualsBuilderTest.assertTrue((!new EqualsBuilder().append(o1, o2).isEquals() ? 1 : 0) != 0);
        EqualsBuilderTest.assertTrue((!new EqualsBuilder().append(o1, Float.NaN).isEquals() ? 1 : 0) != 0);
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append(Float.NaN, Float.NaN).isEquals());
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY).isEquals());
    }

    public void testAccessors() {
        EqualsBuilder equalsBuilder = new EqualsBuilder();
        EqualsBuilderTest.assertTrue((boolean)equalsBuilder.isEquals());
        equalsBuilder.setEquals(true);
        EqualsBuilderTest.assertTrue((boolean)equalsBuilder.isEquals());
        equalsBuilder.setEquals(false);
        EqualsBuilderTest.assertFalse((boolean)equalsBuilder.isEquals());
    }

    public void testReset() {
        EqualsBuilder equalsBuilder = new EqualsBuilder();
        EqualsBuilderTest.assertTrue((boolean)equalsBuilder.isEquals());
        equalsBuilder.setEquals(false);
        EqualsBuilderTest.assertFalse((boolean)equalsBuilder.isEquals());
        equalsBuilder.reset();
        EqualsBuilderTest.assertTrue((boolean)equalsBuilder.isEquals());
    }

    public void testBoolean() {
        boolean o1 = true;
        boolean o2 = false;
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append(o1, o1).isEquals());
        EqualsBuilderTest.assertTrue((!new EqualsBuilder().append(o1, o2).isEquals() ? 1 : 0) != 0);
    }

    public void testObjectArray() {
        Object[] obj1 = new TestObject[]{new TestObject(4), new TestObject(5), null};
        Object[] obj2 = new TestObject[]{new TestObject(4), new TestObject(5), null};
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append(obj1, obj1).isEquals());
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append(obj2, obj2).isEquals());
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append(obj1, obj2).isEquals());
        ((TestObject)obj1[1]).setA(6);
        EqualsBuilderTest.assertTrue((!new EqualsBuilder().append(obj1, obj2).isEquals() ? 1 : 0) != 0);
        ((TestObject)obj1[1]).setA(5);
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append(obj1, obj2).isEquals());
        obj1[2] = obj1[1];
        EqualsBuilderTest.assertTrue((!new EqualsBuilder().append(obj1, obj2).isEquals() ? 1 : 0) != 0);
        obj1[2] = null;
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append(obj1, obj2).isEquals());
        obj2 = null;
        EqualsBuilderTest.assertTrue((!new EqualsBuilder().append(obj1, obj2).isEquals() ? 1 : 0) != 0);
        obj1 = null;
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append(obj1, obj2).isEquals());
    }

    public void testLongArray() {
        long[] obj1 = new long[]{5L, 6L};
        long[] obj2 = new long[]{5L, 6L};
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append(obj1, obj1).isEquals());
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append(obj1, obj2).isEquals());
        obj1[1] = 7L;
        EqualsBuilderTest.assertTrue((!new EqualsBuilder().append(obj1, obj2).isEquals() ? 1 : 0) != 0);
        obj2 = null;
        EqualsBuilderTest.assertTrue((!new EqualsBuilder().append(obj1, obj2).isEquals() ? 1 : 0) != 0);
        obj1 = null;
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append(obj1, obj2).isEquals());
    }

    public void testIntArray() {
        int[] obj1 = new int[]{5, 6};
        int[] obj2 = new int[]{5, 6};
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append(obj1, obj1).isEquals());
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append(obj1, obj2).isEquals());
        obj1[1] = 7;
        EqualsBuilderTest.assertTrue((!new EqualsBuilder().append(obj1, obj2).isEquals() ? 1 : 0) != 0);
        obj2 = null;
        EqualsBuilderTest.assertTrue((!new EqualsBuilder().append(obj1, obj2).isEquals() ? 1 : 0) != 0);
        obj1 = null;
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append(obj1, obj2).isEquals());
    }

    public void testShortArray() {
        short[] obj1 = new short[]{5, 6};
        short[] obj2 = new short[]{5, 6};
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append(obj1, obj1).isEquals());
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append(obj1, obj2).isEquals());
        obj1[1] = 7;
        EqualsBuilderTest.assertTrue((!new EqualsBuilder().append(obj1, obj2).isEquals() ? 1 : 0) != 0);
        obj2 = null;
        EqualsBuilderTest.assertTrue((!new EqualsBuilder().append(obj1, obj2).isEquals() ? 1 : 0) != 0);
        obj1 = null;
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append(obj1, obj2).isEquals());
    }

    public void testCharArray() {
        char[] obj1 = new char[]{'\u0005', '\u0006'};
        char[] obj2 = new char[]{'\u0005', '\u0006'};
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append(obj1, obj1).isEquals());
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append(obj1, obj2).isEquals());
        obj1[1] = 7;
        EqualsBuilderTest.assertTrue((!new EqualsBuilder().append(obj1, obj2).isEquals() ? 1 : 0) != 0);
        obj2 = null;
        EqualsBuilderTest.assertTrue((!new EqualsBuilder().append(obj1, obj2).isEquals() ? 1 : 0) != 0);
        obj1 = null;
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append(obj1, obj2).isEquals());
    }

    public void testByteArray() {
        byte[] obj1 = new byte[]{5, 6};
        byte[] obj2 = new byte[]{5, 6};
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append(obj1, obj1).isEquals());
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append(obj1, obj2).isEquals());
        obj1[1] = 7;
        EqualsBuilderTest.assertTrue((!new EqualsBuilder().append(obj1, obj2).isEquals() ? 1 : 0) != 0);
        obj2 = null;
        EqualsBuilderTest.assertTrue((!new EqualsBuilder().append(obj1, obj2).isEquals() ? 1 : 0) != 0);
        obj1 = null;
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append(obj1, obj2).isEquals());
    }

    public void testDoubleArray() {
        double[] obj1 = new double[]{5.0, 6.0};
        double[] obj2 = new double[]{5.0, 6.0};
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append(obj1, obj1).isEquals());
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append(obj1, obj2).isEquals());
        obj1[1] = 7.0;
        EqualsBuilderTest.assertTrue((!new EqualsBuilder().append(obj1, obj2).isEquals() ? 1 : 0) != 0);
        obj2 = null;
        EqualsBuilderTest.assertTrue((!new EqualsBuilder().append(obj1, obj2).isEquals() ? 1 : 0) != 0);
        obj1 = null;
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append(obj1, obj2).isEquals());
    }

    public void testFloatArray() {
        float[] obj1 = new float[]{5.0f, 6.0f};
        float[] obj2 = new float[]{5.0f, 6.0f};
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append(obj1, obj1).isEquals());
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append(obj1, obj2).isEquals());
        obj1[1] = 7.0f;
        EqualsBuilderTest.assertTrue((!new EqualsBuilder().append(obj1, obj2).isEquals() ? 1 : 0) != 0);
        obj2 = null;
        EqualsBuilderTest.assertTrue((!new EqualsBuilder().append(obj1, obj2).isEquals() ? 1 : 0) != 0);
        obj1 = null;
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append(obj1, obj2).isEquals());
    }

    public void testBooleanArray() {
        boolean[] obj1 = new boolean[]{true, false};
        boolean[] obj2 = new boolean[]{true, false};
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append(obj1, obj1).isEquals());
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append(obj1, obj2).isEquals());
        obj1[1] = true;
        EqualsBuilderTest.assertTrue((!new EqualsBuilder().append(obj1, obj2).isEquals() ? 1 : 0) != 0);
        obj2 = null;
        EqualsBuilderTest.assertTrue((!new EqualsBuilder().append(obj1, obj2).isEquals() ? 1 : 0) != 0);
        obj1 = null;
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append(obj1, obj2).isEquals());
    }

    public void testMultiLongArray() {
        long[][] array1 = new long[2][2];
        long[][] array2 = new long[2][2];
        for (int i = 0; i < array1.length; ++i) {
            for (int j = 0; j < array1[0].length; ++j) {
                array1[i][j] = (i + 1) * (j + 1);
                array2[i][j] = (i + 1) * (j + 1);
            }
        }
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append((Object[])array1, (Object[])array1).isEquals());
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append((Object[])array1, (Object[])array2).isEquals());
        array1[1][1] = 0L;
        EqualsBuilderTest.assertTrue((!new EqualsBuilder().append((Object[])array1, (Object[])array2).isEquals() ? 1 : 0) != 0);
    }

    public void testMultiIntArray() {
        int[][] array1 = new int[2][2];
        int[][] array2 = new int[2][2];
        for (int i = 0; i < array1.length; ++i) {
            for (int j = 0; j < array1[0].length; ++j) {
                array1[i][j] = (i + 1) * (j + 1);
                array2[i][j] = (i + 1) * (j + 1);
            }
        }
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append((Object[])array1, (Object[])array1).isEquals());
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append((Object[])array1, (Object[])array2).isEquals());
        array1[1][1] = 0;
        EqualsBuilderTest.assertTrue((!new EqualsBuilder().append((Object[])array1, (Object[])array2).isEquals() ? 1 : 0) != 0);
    }

    public void testMultiShortArray() {
        short[][] array1 = new short[2][2];
        short[][] array2 = new short[2][2];
        for (int i = 0; i < array1.length; i = (int)((short)(i + 1))) {
            for (int j = 0; j < array1[0].length; j = (int)((short)(j + 1))) {
                array1[i][j] = i;
                array2[i][j] = i;
            }
        }
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append((Object[])array1, (Object[])array1).isEquals());
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append((Object[])array1, (Object[])array2).isEquals());
        array1[1][1] = 0;
        EqualsBuilderTest.assertTrue((!new EqualsBuilder().append((Object[])array1, (Object[])array2).isEquals() ? 1 : 0) != 0);
    }

    public void testMultiCharArray() {
        char[][] array1 = new char[2][2];
        char[][] array2 = new char[2][2];
        for (int i = 0; i < array1.length; i = (int)((char)(i + 1))) {
            for (int j = 0; j < array1[0].length; j = (int)((char)(j + 1))) {
                array1[i][j] = i;
                array2[i][j] = i;
            }
        }
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append((Object[])array1, (Object[])array1).isEquals());
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append((Object[])array1, (Object[])array2).isEquals());
        array1[1][1] = '\u0000';
        EqualsBuilderTest.assertTrue((!new EqualsBuilder().append((Object[])array1, (Object[])array2).isEquals() ? 1 : 0) != 0);
    }

    public void testMultiByteArray() {
        byte[][] array1 = new byte[2][2];
        byte[][] array2 = new byte[2][2];
        for (int i = 0; i < array1.length; i = (int)((byte)(i + 1))) {
            for (int j = 0; j < array1[0].length; j = (int)((byte)(j + 1))) {
                array1[i][j] = i;
                array2[i][j] = i;
            }
        }
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append((Object[])array1, (Object[])array1).isEquals());
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append((Object[])array1, (Object[])array2).isEquals());
        array1[1][1] = 0;
        EqualsBuilderTest.assertTrue((!new EqualsBuilder().append((Object[])array1, (Object[])array2).isEquals() ? 1 : 0) != 0);
    }

    public void testMultiFloatArray() {
        float[][] array1 = new float[2][2];
        float[][] array2 = new float[2][2];
        for (int i = 0; i < array1.length; ++i) {
            for (int j = 0; j < array1[0].length; ++j) {
                array1[i][j] = (i + 1) * (j + 1);
                array2[i][j] = (i + 1) * (j + 1);
            }
        }
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append((Object[])array1, (Object[])array1).isEquals());
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append((Object[])array1, (Object[])array2).isEquals());
        array1[1][1] = 0.0f;
        EqualsBuilderTest.assertTrue((!new EqualsBuilder().append((Object[])array1, (Object[])array2).isEquals() ? 1 : 0) != 0);
    }

    public void testMultiDoubleArray() {
        double[][] array1 = new double[2][2];
        double[][] array2 = new double[2][2];
        for (int i = 0; i < array1.length; ++i) {
            for (int j = 0; j < array1[0].length; ++j) {
                array1[i][j] = (i + 1) * (j + 1);
                array2[i][j] = (i + 1) * (j + 1);
            }
        }
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append((Object[])array1, (Object[])array1).isEquals());
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append((Object[])array1, (Object[])array2).isEquals());
        array1[1][1] = 0.0;
        EqualsBuilderTest.assertTrue((!new EqualsBuilder().append((Object[])array1, (Object[])array2).isEquals() ? 1 : 0) != 0);
    }

    public void testMultiBooleanArray() {
        boolean[][] array1 = new boolean[2][2];
        boolean[][] array2 = new boolean[2][2];
        for (int i = 0; i < array1.length; ++i) {
            for (int j = 0; j < array1[0].length; ++j) {
                array1[i][j] = i == 1 || j == 1;
                array2[i][j] = i == 1 || j == 1;
            }
        }
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append((Object[])array1, (Object[])array1).isEquals());
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append((Object[])array1, (Object[])array2).isEquals());
        array1[1][1] = false;
        EqualsBuilderTest.assertTrue((!new EqualsBuilder().append((Object[])array1, (Object[])array2).isEquals() ? 1 : 0) != 0);
        boolean[] array3 = new boolean[]{true, true};
        EqualsBuilderTest.assertFalse((boolean)new EqualsBuilder().append((Object)array1, (Object)array3).isEquals());
        EqualsBuilderTest.assertFalse((boolean)new EqualsBuilder().append((Object)array3, (Object)array1).isEquals());
        EqualsBuilderTest.assertFalse((boolean)new EqualsBuilder().append((Object)array2, (Object)array3).isEquals());
        EqualsBuilderTest.assertFalse((boolean)new EqualsBuilder().append((Object)array3, (Object)array2).isEquals());
    }

    public void testRaggedArray() {
        long[][] array1 = new long[2][];
        long[][] array2 = new long[2][];
        for (int i = 0; i < array1.length; ++i) {
            array1[i] = new long[2];
            array2[i] = new long[2];
            for (int j = 0; j < array1[i].length; ++j) {
                array1[i][j] = (i + 1) * (j + 1);
                array2[i][j] = (i + 1) * (j + 1);
            }
        }
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append((Object[])array1, (Object[])array1).isEquals());
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append((Object[])array1, (Object[])array2).isEquals());
        array1[1][1] = 0L;
        EqualsBuilderTest.assertTrue((!new EqualsBuilder().append((Object[])array1, (Object[])array2).isEquals() ? 1 : 0) != 0);
    }

    public void testMixedArray() {
        Object[] array1 = new Object[2];
        Object[] array2 = new Object[2];
        for (int i = 0; i < array1.length; ++i) {
            array1[i] = new long[2];
            array2[i] = new long[2];
            for (int j = 0; j < 2; ++j) {
                ((long[])array1[i])[j] = (i + 1) * (j + 1);
                ((long[])array2[i])[j] = (i + 1) * (j + 1);
            }
        }
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append(array1, array1).isEquals());
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append(array1, array2).isEquals());
        ((long[])array1[1])[1] = 0L;
        EqualsBuilderTest.assertTrue((!new EqualsBuilder().append(array1, array2).isEquals() ? 1 : 0) != 0);
    }

    public void testObjectArrayHiddenByObject() {
        TestObject[] array1 = new TestObject[]{new TestObject(4), new TestObject(5)};
        TestObject[] array2 = new TestObject[]{new TestObject(4), new TestObject(5)};
        TestObject[] obj1 = array1;
        TestObject[] obj2 = array2;
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append((Object)obj1, (Object)obj1).isEquals());
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append((Object)obj1, (Object)array1).isEquals());
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append((Object)obj1, (Object)obj2).isEquals());
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append((Object)obj1, (Object)array2).isEquals());
        array1[1].setA(6);
        EqualsBuilderTest.assertTrue((!new EqualsBuilder().append((Object)obj1, (Object)obj2).isEquals() ? 1 : 0) != 0);
    }

    public void testLongArrayHiddenByObject() {
        long[] array1 = new long[]{5L, 6L};
        long[] array2 = new long[]{5L, 6L};
        long[] obj1 = array1;
        long[] obj2 = array2;
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append((Object)obj1, (Object)obj1).isEquals());
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append((Object)obj1, (Object)array1).isEquals());
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append((Object)obj1, (Object)obj2).isEquals());
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append((Object)obj1, (Object)array2).isEquals());
        array1[1] = 7L;
        EqualsBuilderTest.assertTrue((!new EqualsBuilder().append((Object)obj1, (Object)obj2).isEquals() ? 1 : 0) != 0);
    }

    public void testIntArrayHiddenByObject() {
        int[] array1 = new int[]{5, 6};
        int[] array2 = new int[]{5, 6};
        int[] obj1 = array1;
        int[] obj2 = array2;
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append((Object)obj1, (Object)obj1).isEquals());
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append((Object)obj1, (Object)array1).isEquals());
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append((Object)obj1, (Object)obj2).isEquals());
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append((Object)obj1, (Object)array2).isEquals());
        array1[1] = 7;
        EqualsBuilderTest.assertTrue((!new EqualsBuilder().append((Object)obj1, (Object)obj2).isEquals() ? 1 : 0) != 0);
    }

    public void testShortArrayHiddenByObject() {
        short[] array1 = new short[]{5, 6};
        short[] array2 = new short[]{5, 6};
        short[] obj1 = array1;
        short[] obj2 = array2;
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append((Object)obj1, (Object)obj1).isEquals());
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append((Object)obj1, (Object)array1).isEquals());
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append((Object)obj1, (Object)obj2).isEquals());
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append((Object)obj1, (Object)array2).isEquals());
        array1[1] = 7;
        EqualsBuilderTest.assertTrue((!new EqualsBuilder().append((Object)obj1, (Object)obj2).isEquals() ? 1 : 0) != 0);
    }

    public void testCharArrayHiddenByObject() {
        char[] array1 = new char[]{'\u0005', '\u0006'};
        char[] array2 = new char[]{'\u0005', '\u0006'};
        char[] obj1 = array1;
        char[] obj2 = array2;
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append((Object)obj1, (Object)obj1).isEquals());
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append((Object)obj1, (Object)array1).isEquals());
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append((Object)obj1, (Object)obj2).isEquals());
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append((Object)obj1, (Object)array2).isEquals());
        array1[1] = 7;
        EqualsBuilderTest.assertTrue((!new EqualsBuilder().append((Object)obj1, (Object)obj2).isEquals() ? 1 : 0) != 0);
    }

    public void testByteArrayHiddenByObject() {
        byte[] array1 = new byte[]{5, 6};
        byte[] array2 = new byte[]{5, 6};
        byte[] obj1 = array1;
        byte[] obj2 = array2;
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append((Object)obj1, (Object)obj1).isEquals());
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append((Object)obj1, (Object)array1).isEquals());
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append((Object)obj1, (Object)obj2).isEquals());
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append((Object)obj1, (Object)array2).isEquals());
        array1[1] = 7;
        EqualsBuilderTest.assertTrue((!new EqualsBuilder().append((Object)obj1, (Object)obj2).isEquals() ? 1 : 0) != 0);
    }

    public void testDoubleArrayHiddenByObject() {
        double[] array1 = new double[]{5.0, 6.0};
        double[] array2 = new double[]{5.0, 6.0};
        double[] obj1 = array1;
        double[] obj2 = array2;
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append((Object)obj1, (Object)obj1).isEquals());
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append((Object)obj1, (Object)array1).isEquals());
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append((Object)obj1, (Object)obj2).isEquals());
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append((Object)obj1, (Object)array2).isEquals());
        array1[1] = 7.0;
        EqualsBuilderTest.assertTrue((!new EqualsBuilder().append((Object)obj1, (Object)obj2).isEquals() ? 1 : 0) != 0);
    }

    public void testFloatArrayHiddenByObject() {
        float[] array1 = new float[]{5.0f, 6.0f};
        float[] array2 = new float[]{5.0f, 6.0f};
        float[] obj1 = array1;
        float[] obj2 = array2;
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append((Object)obj1, (Object)obj1).isEquals());
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append((Object)obj1, (Object)array1).isEquals());
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append((Object)obj1, (Object)obj2).isEquals());
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append((Object)obj1, (Object)array2).isEquals());
        array1[1] = 7.0f;
        EqualsBuilderTest.assertTrue((!new EqualsBuilder().append((Object)obj1, (Object)obj2).isEquals() ? 1 : 0) != 0);
    }

    public void testBooleanArrayHiddenByObject() {
        boolean[] array1 = new boolean[]{true, false};
        boolean[] array2 = new boolean[]{true, false};
        boolean[] obj1 = array1;
        boolean[] obj2 = array2;
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append((Object)obj1, (Object)obj1).isEquals());
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append((Object)obj1, (Object)array1).isEquals());
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append((Object)obj1, (Object)obj2).isEquals());
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append((Object)obj1, (Object)array2).isEquals());
        array1[1] = true;
        EqualsBuilderTest.assertTrue((!new EqualsBuilder().append((Object)obj1, (Object)obj2).isEquals() ? 1 : 0) != 0);
    }

    public void testUnrelatedClasses() {
        Object[] x = new Object[]{new TestACanEqualB(1)};
        Object[] y = new Object[]{new TestBCanEqualA(1)};
        EqualsBuilderTest.assertTrue((boolean)Arrays.equals(x, x));
        EqualsBuilderTest.assertTrue((boolean)Arrays.equals(y, y));
        EqualsBuilderTest.assertTrue((boolean)Arrays.equals(x, y));
        EqualsBuilderTest.assertTrue((boolean)Arrays.equals(y, x));
        EqualsBuilderTest.assertTrue((boolean)x[0].equals(x[0]));
        EqualsBuilderTest.assertTrue((boolean)y[0].equals(y[0]));
        EqualsBuilderTest.assertTrue((boolean)x[0].equals(y[0]));
        EqualsBuilderTest.assertTrue((boolean)y[0].equals(x[0]));
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append(x, x).isEquals());
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append(y, y).isEquals());
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append(x, y).isEquals());
        EqualsBuilderTest.assertTrue((boolean)new EqualsBuilder().append(y, x).isEquals());
    }

    public void testNpeForNullElement() {
        Object[] x1 = new Object[]{1, null, 3};
        Object[] x2 = new Object[]{1, 2, 3};
        new EqualsBuilder().append(x1, x2);
    }

    public void testReflectionEqualsExcludeFields() throws Exception {
        TestObjectWithMultipleFields x1 = new TestObjectWithMultipleFields(1, 2, 3);
        TestObjectWithMultipleFields x2 = new TestObjectWithMultipleFields(1, 3, 4);
        EqualsBuilderTest.assertTrue((!EqualsBuilder.reflectionEquals((Object)x1, (Object)x2, (String[])new String[0]) ? 1 : 0) != 0);
        EqualsBuilderTest.assertTrue((!EqualsBuilder.reflectionEquals((Object)x1, (Object)x2, (String[])null) ? 1 : 0) != 0);
        EqualsBuilderTest.assertTrue((!EqualsBuilder.reflectionEquals((Object)x1, (Object)x2, (String[])new String[0]) ? 1 : 0) != 0);
        EqualsBuilderTest.assertTrue((!EqualsBuilder.reflectionEquals((Object)x1, (Object)x2, (String[])new String[]{"xxx"}) ? 1 : 0) != 0);
        EqualsBuilderTest.assertTrue((!EqualsBuilder.reflectionEquals((Object)x1, (Object)x2, (String[])new String[]{"two"}) ? 1 : 0) != 0);
        EqualsBuilderTest.assertTrue((!EqualsBuilder.reflectionEquals((Object)x1, (Object)x2, (String[])new String[]{"three"}) ? 1 : 0) != 0);
        EqualsBuilderTest.assertTrue((boolean)EqualsBuilder.reflectionEquals((Object)x1, (Object)x2, (String[])new String[]{"two", "three"}));
        EqualsBuilderTest.assertTrue((boolean)EqualsBuilder.reflectionEquals((Object)x1, (Object)x2, (String[])new String[]{"one", "two", "three"}));
        EqualsBuilderTest.assertTrue((boolean)EqualsBuilder.reflectionEquals((Object)x1, (Object)x2, (String[])new String[]{"one", "two", "three", "xxx"}));
    }

    public void testCyclicalObjectReferences() {
        TestObjectReference refX1 = new TestObjectReference(1);
        TestObjectReference x1 = new TestObjectReference(1);
        x1.setObjectReference(refX1);
        refX1.setObjectReference(x1);
        TestObjectReference refX2 = new TestObjectReference(1);
        TestObjectReference x2 = new TestObjectReference(1);
        x2.setObjectReference(refX2);
        refX2.setObjectReference(x2);
        TestObjectReference refX3 = new TestObjectReference(2);
        TestObjectReference x3 = new TestObjectReference(2);
        x3.setObjectReference(refX3);
        refX3.setObjectReference(x3);
        EqualsBuilderTest.assertTrue((boolean)x1.equals(x2));
        EqualsBuilderTest.assertNull((Object)EqualsBuilder.getRegistry());
        EqualsBuilderTest.assertFalse((boolean)x1.equals(x3));
        EqualsBuilderTest.assertNull((Object)EqualsBuilder.getRegistry());
        EqualsBuilderTest.assertFalse((boolean)x2.equals(x3));
        EqualsBuilderTest.assertNull((Object)EqualsBuilder.getRegistry());
    }

    static class TestObjectReference {
        private TestObjectReference reference;
        private TestObject one;

        public TestObjectReference(int one) {
            this.one = new TestObject(one);
        }

        public void setObjectReference(TestObjectReference reference) {
            this.reference = reference;
        }

        public boolean equals(Object obj) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
        }
    }

    static class TestObjectWithMultipleFields {
        private TestObject one;
        private TestObject two;
        private TestObject three;

        public TestObjectWithMultipleFields(int one, int two, int three) {
            this.one = new TestObject(one);
            this.two = new TestObject(two);
            this.three = new TestObject(three);
        }
    }

    public static class TestBCanEqualA {
        private int b;

        public TestBCanEqualA(int b) {
            this.b = b;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof TestACanEqualB) {
                return this.b == ((TestACanEqualB)o).getA();
            }
            if (o instanceof TestBCanEqualA) {
                return this.b == ((TestBCanEqualA)o).getB();
            }
            return false;
        }

        public int getB() {
            return this.b;
        }
    }

    public static class TestACanEqualB {
        private int a;

        public TestACanEqualB(int a) {
            this.a = a;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof TestACanEqualB) {
                return this.a == ((TestACanEqualB)o).getA();
            }
            if (o instanceof TestBCanEqualA) {
                return this.a == ((TestBCanEqualA)o).getB();
            }
            return false;
        }

        public int getA() {
            return this.a;
        }
    }

    static class TestTSubObject2
    extends TestObject {
        private transient int t;

        public TestTSubObject2(int a, int t) {
            super(a);
        }

        public int getT() {
            return this.t;
        }

        public void setT(int t) {
            this.t = t;
        }
    }

    static class TestTTLeafObject
    extends TestTTSubObject {
        private int leafValue;

        public TestTTLeafObject(int a, int t, int tt, int leafValue) {
            super(a, t, tt);
            this.leafValue = leafValue;
        }
    }

    static class TestTTSubObject
    extends TestTSubObject {
        private transient int tt;

        public TestTTSubObject(int a, int t, int tt) {
            super(a, t);
            this.tt = tt;
        }
    }

    static class TestTSubObject
    extends TestObject {
        private transient int t;

        public TestTSubObject(int a, int t) {
            super(a);
            this.t = t;
        }
    }

    static class TestEmptySubObject
    extends TestObject {
        public TestEmptySubObject(int a) {
            super(a);
        }
    }

    static class TestSubObject
    extends TestObject {
        private int b;

        public TestSubObject() {
            super(0);
        }

        public TestSubObject(int a, int b) {
            super(a);
            this.b = b;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (o.getClass() != this.getClass()) {
                return false;
            }
            TestSubObject rhs = (TestSubObject)o;
            return super.equals(o) && this.b == rhs.b;
        }

        public void setB(int b) {
            this.b = b;
        }

        public int getB() {
            return this.b;
        }
    }

    static class TestObject {
        private int a;

        public TestObject() {
        }

        public TestObject(int a) {
            this.a = a;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (o.getClass() != this.getClass()) {
                return false;
            }
            TestObject rhs = (TestObject)o;
            return this.a == rhs.a;
        }

        public void setA(int a) {
            this.a = a;
        }

        public int getA() {
            return this.a;
        }
    }
}

