/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import junit.framework.TestCase;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class HashCodeBuilderTest
extends TestCase {
    public HashCodeBuilderTest(String name) {
        super(name);
    }

    public void testConstructorEx1() {
        try {
            new HashCodeBuilder(0, 0);
        }
        catch (IllegalArgumentException ex) {
            return;
        }
        HashCodeBuilderTest.fail();
    }

    public void testConstructorEx2() {
        try {
            new HashCodeBuilder(2, 2);
        }
        catch (IllegalArgumentException ex) {
            return;
        }
        HashCodeBuilderTest.fail();
    }

    public void testReflectionHashCode() {
        HashCodeBuilderTest.assertEquals((int)629, (int)HashCodeBuilder.reflectionHashCode((Object)new TestObject(0), (String[])new String[0]));
        HashCodeBuilderTest.assertEquals((int)124085, (int)HashCodeBuilder.reflectionHashCode((Object)new TestObject(123456), (String[])new String[0]));
    }

    public void testReflectionHierarchyHashCode() {
        HashCodeBuilderTest.assertEquals((int)23273, (int)HashCodeBuilder.reflectionHashCode((Object)new TestSubObject(0, 0, 0), (String[])new String[0]));
        HashCodeBuilderTest.assertEquals((int)861101, (int)HashCodeBuilder.reflectionHashCode((Object)new TestSubObject(0, 0, 0), (boolean)true));
        HashCodeBuilderTest.assertEquals((int)438659, (int)HashCodeBuilder.reflectionHashCode((Object)new TestSubObject(123456, 7890, 0), (String[])new String[0]));
        HashCodeBuilderTest.assertEquals((int)11785967, (int)HashCodeBuilder.reflectionHashCode((Object)new TestSubObject(123456, 7890, 0), (boolean)true));
    }

    public void testReflectionHierarchyHashCodeEx1() {
        try {
            HashCodeBuilder.reflectionHashCode((int)0, (int)0, (Object)new TestSubObject(0, 0, 0), (boolean)true);
        }
        catch (IllegalArgumentException ex) {
            return;
        }
        HashCodeBuilderTest.fail();
    }

    public void testReflectionHierarchyHashCodeEx2() {
        try {
            HashCodeBuilder.reflectionHashCode((int)2, (int)2, (Object)new TestSubObject(0, 0, 0), (boolean)true);
        }
        catch (IllegalArgumentException ex) {
            return;
        }
        HashCodeBuilderTest.fail();
    }

    public void testReflectionHashCodeEx1() {
        try {
            HashCodeBuilder.reflectionHashCode((int)0, (int)0, (Object)new TestObject(0), (boolean)true);
        }
        catch (IllegalArgumentException ex) {
            return;
        }
        HashCodeBuilderTest.fail();
    }

    public void testReflectionHashCodeEx2() {
        try {
            HashCodeBuilder.reflectionHashCode((int)2, (int)2, (Object)new TestObject(0), (boolean)true);
        }
        catch (IllegalArgumentException ex) {
            return;
        }
        HashCodeBuilderTest.fail();
    }

    public void testReflectionHashCodeEx3() {
        try {
            HashCodeBuilder.reflectionHashCode((int)13, (int)19, null, (boolean)true);
        }
        catch (IllegalArgumentException ex) {
            return;
        }
        HashCodeBuilderTest.fail();
    }

    public void testSuper() {
        Object obj = new Object();
        HashCodeBuilderTest.assertEquals((int)(629 + (779 + obj.hashCode())), (int)new HashCodeBuilder(17, 37).appendSuper(new HashCodeBuilder(19, 41).append(obj).toHashCode()).toHashCode());
    }

    public void testObject() {
        Object obj = null;
        HashCodeBuilderTest.assertEquals((int)629, (int)new HashCodeBuilder(17, 37).append(obj).toHashCode());
        obj = new Object();
        HashCodeBuilderTest.assertEquals((int)(629 + obj.hashCode()), (int)new HashCodeBuilder(17, 37).append(obj).toHashCode());
    }

    public void testObjectBuild() {
        Object obj = null;
        HashCodeBuilderTest.assertEquals((int)629, (int)new HashCodeBuilder(17, 37).append(obj).build());
        obj = new Object();
        HashCodeBuilderTest.assertEquals((int)(629 + obj.hashCode()), (int)new HashCodeBuilder(17, 37).append(obj).build());
    }

    public void testLong() {
        HashCodeBuilderTest.assertEquals((int)629, (int)new HashCodeBuilder(17, 37).append(0L).toHashCode());
        HashCodeBuilderTest.assertEquals((int)123457418, (int)new HashCodeBuilder(17, 37).append(123456789L).toHashCode());
    }

    public void testInt() {
        HashCodeBuilderTest.assertEquals((int)629, (int)new HashCodeBuilder(17, 37).append(0).toHashCode());
        HashCodeBuilderTest.assertEquals((int)124085, (int)new HashCodeBuilder(17, 37).append(123456).toHashCode());
    }

    public void testShort() {
        HashCodeBuilderTest.assertEquals((int)629, (int)new HashCodeBuilder(17, 37).append((short)0).toHashCode());
        HashCodeBuilderTest.assertEquals((int)12974, (int)new HashCodeBuilder(17, 37).append((short)12345).toHashCode());
    }

    public void testChar() {
        HashCodeBuilderTest.assertEquals((int)629, (int)new HashCodeBuilder(17, 37).append('\u0000').toHashCode());
        HashCodeBuilderTest.assertEquals((int)1863, (int)new HashCodeBuilder(17, 37).append('\u04d2').toHashCode());
    }

    public void testByte() {
        HashCodeBuilderTest.assertEquals((int)629, (int)new HashCodeBuilder(17, 37).append((byte)0).toHashCode());
        HashCodeBuilderTest.assertEquals((int)752, (int)new HashCodeBuilder(17, 37).append((byte)123).toHashCode());
    }

    public void testDouble() {
        HashCodeBuilderTest.assertEquals((int)629, (int)new HashCodeBuilder(17, 37).append(0.0).toHashCode());
        double d = 1234567.89;
        long l = Double.doubleToLongBits(d);
        HashCodeBuilderTest.assertEquals((int)(629 + (int)(l ^ l >> 32)), (int)new HashCodeBuilder(17, 37).append(d).toHashCode());
    }

    public void testFloat() {
        HashCodeBuilderTest.assertEquals((int)629, (int)new HashCodeBuilder(17, 37).append(0.0f).toHashCode());
        float f = 1234.89f;
        int i = Float.floatToIntBits(f);
        HashCodeBuilderTest.assertEquals((int)(629 + i), (int)new HashCodeBuilder(17, 37).append(f).toHashCode());
    }

    public void testBoolean() {
        HashCodeBuilderTest.assertEquals((int)629, (int)new HashCodeBuilder(17, 37).append(true).toHashCode());
        HashCodeBuilderTest.assertEquals((int)630, (int)new HashCodeBuilder(17, 37).append(false).toHashCode());
    }

    public void testObjectArray() {
        HashCodeBuilderTest.assertEquals((int)629, (int)new HashCodeBuilder(17, 37).append((Object[])null).toHashCode());
        Object[] obj = new Object[2];
        HashCodeBuilderTest.assertEquals((int)23273, (int)new HashCodeBuilder(17, 37).append(obj).toHashCode());
        obj[0] = new Object();
        HashCodeBuilderTest.assertEquals((int)((629 + obj[0].hashCode()) * 37), (int)new HashCodeBuilder(17, 37).append(obj).toHashCode());
        obj[1] = new Object();
        HashCodeBuilderTest.assertEquals((int)((629 + obj[0].hashCode()) * 37 + obj[1].hashCode()), (int)new HashCodeBuilder(17, 37).append(obj).toHashCode());
    }

    public void testObjectArrayAsObject() {
        Object[] obj = new Object[2];
        HashCodeBuilderTest.assertEquals((int)23273, (int)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
        obj[0] = new Object();
        HashCodeBuilderTest.assertEquals((int)((629 + obj[0].hashCode()) * 37), (int)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
        obj[1] = new Object();
        HashCodeBuilderTest.assertEquals((int)((629 + obj[0].hashCode()) * 37 + obj[1].hashCode()), (int)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
    }

    public void testLongArray() {
        HashCodeBuilderTest.assertEquals((int)629, (int)new HashCodeBuilder(17, 37).append((long[])null).toHashCode());
        long[] obj = new long[2];
        HashCodeBuilderTest.assertEquals((int)23273, (int)new HashCodeBuilder(17, 37).append(obj).toHashCode());
        obj[0] = 5L;
        int h1 = 5;
        HashCodeBuilderTest.assertEquals((int)((629 + h1) * 37), (int)new HashCodeBuilder(17, 37).append(obj).toHashCode());
        obj[1] = 6L;
        int h2 = 6;
        HashCodeBuilderTest.assertEquals((int)((629 + h1) * 37 + h2), (int)new HashCodeBuilder(17, 37).append(obj).toHashCode());
    }

    public void testLongArrayAsObject() {
        long[] obj = new long[2];
        HashCodeBuilderTest.assertEquals((int)23273, (int)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
        obj[0] = 5L;
        int h1 = 5;
        HashCodeBuilderTest.assertEquals((int)((629 + h1) * 37), (int)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
        obj[1] = 6L;
        int h2 = 6;
        HashCodeBuilderTest.assertEquals((int)((629 + h1) * 37 + h2), (int)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
    }

    public void testIntArray() {
        HashCodeBuilderTest.assertEquals((int)629, (int)new HashCodeBuilder(17, 37).append((int[])null).toHashCode());
        int[] obj = new int[2];
        HashCodeBuilderTest.assertEquals((int)23273, (int)new HashCodeBuilder(17, 37).append(obj).toHashCode());
        obj[0] = 5;
        HashCodeBuilderTest.assertEquals((int)23458, (int)new HashCodeBuilder(17, 37).append(obj).toHashCode());
        obj[1] = 6;
        HashCodeBuilderTest.assertEquals((int)23464, (int)new HashCodeBuilder(17, 37).append(obj).toHashCode());
    }

    public void testIntArrayAsObject() {
        int[] obj = new int[2];
        HashCodeBuilderTest.assertEquals((int)23273, (int)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
        obj[0] = 5;
        HashCodeBuilderTest.assertEquals((int)23458, (int)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
        obj[1] = 6;
        HashCodeBuilderTest.assertEquals((int)23464, (int)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
    }

    public void testShortArray() {
        HashCodeBuilderTest.assertEquals((int)629, (int)new HashCodeBuilder(17, 37).append((short[])null).toHashCode());
        short[] obj = new short[2];
        HashCodeBuilderTest.assertEquals((int)23273, (int)new HashCodeBuilder(17, 37).append(obj).toHashCode());
        obj[0] = 5;
        HashCodeBuilderTest.assertEquals((int)23458, (int)new HashCodeBuilder(17, 37).append(obj).toHashCode());
        obj[1] = 6;
        HashCodeBuilderTest.assertEquals((int)23464, (int)new HashCodeBuilder(17, 37).append(obj).toHashCode());
    }

    public void testShortArrayAsObject() {
        short[] obj = new short[2];
        HashCodeBuilderTest.assertEquals((int)23273, (int)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
        obj[0] = 5;
        HashCodeBuilderTest.assertEquals((int)23458, (int)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
        obj[1] = 6;
        HashCodeBuilderTest.assertEquals((int)23464, (int)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
    }

    public void testCharArray() {
        HashCodeBuilderTest.assertEquals((int)629, (int)new HashCodeBuilder(17, 37).append((char[])null).toHashCode());
        char[] obj = new char[2];
        HashCodeBuilderTest.assertEquals((int)23273, (int)new HashCodeBuilder(17, 37).append(obj).toHashCode());
        obj[0] = 5;
        HashCodeBuilderTest.assertEquals((int)23458, (int)new HashCodeBuilder(17, 37).append(obj).toHashCode());
        obj[1] = 6;
        HashCodeBuilderTest.assertEquals((int)23464, (int)new HashCodeBuilder(17, 37).append(obj).toHashCode());
    }

    public void testCharArrayAsObject() {
        char[] obj = new char[2];
        HashCodeBuilderTest.assertEquals((int)23273, (int)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
        obj[0] = 5;
        HashCodeBuilderTest.assertEquals((int)23458, (int)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
        obj[1] = 6;
        HashCodeBuilderTest.assertEquals((int)23464, (int)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
    }

    public void testByteArray() {
        HashCodeBuilderTest.assertEquals((int)629, (int)new HashCodeBuilder(17, 37).append((byte[])null).toHashCode());
        byte[] obj = new byte[2];
        HashCodeBuilderTest.assertEquals((int)23273, (int)new HashCodeBuilder(17, 37).append(obj).toHashCode());
        obj[0] = 5;
        HashCodeBuilderTest.assertEquals((int)23458, (int)new HashCodeBuilder(17, 37).append(obj).toHashCode());
        obj[1] = 6;
        HashCodeBuilderTest.assertEquals((int)23464, (int)new HashCodeBuilder(17, 37).append(obj).toHashCode());
    }

    public void testByteArrayAsObject() {
        byte[] obj = new byte[2];
        HashCodeBuilderTest.assertEquals((int)23273, (int)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
        obj[0] = 5;
        HashCodeBuilderTest.assertEquals((int)23458, (int)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
        obj[1] = 6;
        HashCodeBuilderTest.assertEquals((int)23464, (int)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
    }

    public void testDoubleArray() {
        HashCodeBuilderTest.assertEquals((int)629, (int)new HashCodeBuilder(17, 37).append((double[])null).toHashCode());
        double[] obj = new double[2];
        HashCodeBuilderTest.assertEquals((int)23273, (int)new HashCodeBuilder(17, 37).append(obj).toHashCode());
        obj[0] = 5.4;
        long l1 = Double.doubleToLongBits(5.4);
        int h1 = (int)(l1 ^ l1 >> 32);
        HashCodeBuilderTest.assertEquals((int)((629 + h1) * 37), (int)new HashCodeBuilder(17, 37).append(obj).toHashCode());
        obj[1] = 6.3;
        long l2 = Double.doubleToLongBits(6.3);
        int h2 = (int)(l2 ^ l2 >> 32);
        HashCodeBuilderTest.assertEquals((int)((629 + h1) * 37 + h2), (int)new HashCodeBuilder(17, 37).append(obj).toHashCode());
    }

    public void testDoubleArrayAsObject() {
        double[] obj = new double[2];
        HashCodeBuilderTest.assertEquals((int)23273, (int)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
        obj[0] = 5.4;
        long l1 = Double.doubleToLongBits(5.4);
        int h1 = (int)(l1 ^ l1 >> 32);
        HashCodeBuilderTest.assertEquals((int)((629 + h1) * 37), (int)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
        obj[1] = 6.3;
        long l2 = Double.doubleToLongBits(6.3);
        int h2 = (int)(l2 ^ l2 >> 32);
        HashCodeBuilderTest.assertEquals((int)((629 + h1) * 37 + h2), (int)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
    }

    public void testFloatArray() {
        HashCodeBuilderTest.assertEquals((int)629, (int)new HashCodeBuilder(17, 37).append((float[])null).toHashCode());
        float[] obj = new float[2];
        HashCodeBuilderTest.assertEquals((int)23273, (int)new HashCodeBuilder(17, 37).append(obj).toHashCode());
        obj[0] = 5.4f;
        int h1 = Float.floatToIntBits(5.4f);
        HashCodeBuilderTest.assertEquals((int)((629 + h1) * 37), (int)new HashCodeBuilder(17, 37).append(obj).toHashCode());
        obj[1] = 6.3f;
        int h2 = Float.floatToIntBits(6.3f);
        HashCodeBuilderTest.assertEquals((int)((629 + h1) * 37 + h2), (int)new HashCodeBuilder(17, 37).append(obj).toHashCode());
    }

    public void testFloatArrayAsObject() {
        float[] obj = new float[2];
        HashCodeBuilderTest.assertEquals((int)23273, (int)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
        obj[0] = 5.4f;
        int h1 = Float.floatToIntBits(5.4f);
        HashCodeBuilderTest.assertEquals((int)((629 + h1) * 37), (int)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
        obj[1] = 6.3f;
        int h2 = Float.floatToIntBits(6.3f);
        HashCodeBuilderTest.assertEquals((int)((629 + h1) * 37 + h2), (int)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
    }

    public void testBooleanArray() {
        HashCodeBuilderTest.assertEquals((int)629, (int)new HashCodeBuilder(17, 37).append((boolean[])null).toHashCode());
        boolean[] obj = new boolean[2];
        HashCodeBuilderTest.assertEquals((int)23311, (int)new HashCodeBuilder(17, 37).append(obj).toHashCode());
        obj[0] = true;
        HashCodeBuilderTest.assertEquals((int)23274, (int)new HashCodeBuilder(17, 37).append(obj).toHashCode());
        obj[1] = false;
        HashCodeBuilderTest.assertEquals((int)23274, (int)new HashCodeBuilder(17, 37).append(obj).toHashCode());
    }

    public void testBooleanArrayAsObject() {
        boolean[] obj = new boolean[2];
        HashCodeBuilderTest.assertEquals((int)23311, (int)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
        obj[0] = true;
        HashCodeBuilderTest.assertEquals((int)23274, (int)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
        obj[1] = false;
        HashCodeBuilderTest.assertEquals((int)23274, (int)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
    }

    public void testBooleanMultiArray() {
        boolean[][] obj = new boolean[2][];
        HashCodeBuilderTest.assertEquals((int)23273, (int)new HashCodeBuilder(17, 37).append((Object[])obj).toHashCode());
        obj[0] = new boolean[0];
        HashCodeBuilderTest.assertEquals((int)629, (int)new HashCodeBuilder(17, 37).append((Object[])obj).toHashCode());
        obj[0] = new boolean[1];
        HashCodeBuilderTest.assertEquals((int)23310, (int)new HashCodeBuilder(17, 37).append((Object[])obj).toHashCode());
        obj[0] = new boolean[2];
        HashCodeBuilderTest.assertEquals((int)862507, (int)new HashCodeBuilder(17, 37).append((Object[])obj).toHashCode());
        obj[0][0] = true;
        HashCodeBuilderTest.assertEquals((int)861138, (int)new HashCodeBuilder(17, 37).append((Object[])obj).toHashCode());
        obj[1] = new boolean[1];
        HashCodeBuilderTest.assertEquals((int)861139, (int)new HashCodeBuilder(17, 37).append((Object[])obj).toHashCode());
    }

    public void testReflectionHashCodeExcludeFields() throws Exception {
        TestObjectWithMultipleFields x = new TestObjectWithMultipleFields(1, 2, 3);
        HashCodeBuilderTest.assertEquals((int)862547, (int)HashCodeBuilder.reflectionHashCode((Object)x, (String[])new String[0]));
        HashCodeBuilderTest.assertEquals((int)862547, (int)HashCodeBuilder.reflectionHashCode((Object)x, (String[])null));
        HashCodeBuilderTest.assertEquals((int)862547, (int)HashCodeBuilder.reflectionHashCode((Object)x, (String[])new String[0]));
        HashCodeBuilderTest.assertEquals((int)862547, (int)HashCodeBuilder.reflectionHashCode((Object)x, (String[])new String[]{"xxx"}));
        HashCodeBuilderTest.assertEquals((int)23313, (int)HashCodeBuilder.reflectionHashCode((Object)x, (String[])new String[]{"two"}));
        HashCodeBuilderTest.assertEquals((int)23312, (int)HashCodeBuilder.reflectionHashCode((Object)x, (String[])new String[]{"three"}));
        HashCodeBuilderTest.assertEquals((int)630, (int)HashCodeBuilder.reflectionHashCode((Object)x, (String[])new String[]{"two", "three"}));
        HashCodeBuilderTest.assertEquals((int)17, (int)HashCodeBuilder.reflectionHashCode((Object)x, (String[])new String[]{"one", "two", "three"}));
        HashCodeBuilderTest.assertEquals((int)17, (int)HashCodeBuilder.reflectionHashCode((Object)x, (String[])new String[]{"one", "two", "three", "xxx"}));
    }

    public void testReflectionObjectCycle() {
        ReflectionTestCycleB b;
        ReflectionTestCycleA a = new ReflectionTestCycleA();
        a.b = b = new ReflectionTestCycleB();
        b.a = a;
        a.hashCode();
        HashCodeBuilderTest.assertNull((Object)HashCodeBuilder.getRegistry());
        b.hashCode();
        HashCodeBuilderTest.assertNull((Object)HashCodeBuilder.getRegistry());
    }

    public void testToHashCodeEqualsHashCode() {
        HashCodeBuilder hcb = new HashCodeBuilder(17, 37).append(new Object()).append('a');
        HashCodeBuilderTest.assertEquals((String)"hashCode() is no longer returning the same value as toHashCode() - see LANG-520", (int)hcb.toHashCode(), (int)hcb.hashCode());
    }

    static class TestObjectWithMultipleFields {
        private int one = 0;
        private int two = 0;
        private int three = 0;

        public TestObjectWithMultipleFields(int one, int two, int three) {
            this.one = one;
            this.two = two;
            this.three = three;
        }
    }

    static class TestSubObject
    extends TestObject {
        private int b;
        private transient int t;

        public TestSubObject() {
            super(0);
        }

        public TestSubObject(int a, int b, int t) {
            super(a);
            this.b = b;
            this.t = t;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TestSubObject)) {
                return false;
            }
            TestSubObject rhs = (TestSubObject)o;
            return super.equals(o) && this.b == rhs.b;
        }
    }

    static class TestObject {
        private int a;

        public TestObject(int a) {
            this.a = a;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TestObject)) {
                return false;
            }
            TestObject rhs = (TestObject)o;
            return this.a == rhs.a;
        }

        public void setA(int a) {
            this.a = a;
        }

        public int getA() {
            return this.a;
        }
    }

    static class ReflectionTestCycleB {
        ReflectionTestCycleA a;

        ReflectionTestCycleB() {
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
        }
    }

    static class ReflectionTestCycleA {
        ReflectionTestCycleB b;

        ReflectionTestCycleA() {
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
        }
    }
}

