/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import java.util.ArrayList;
import java.util.HashMap;
import junit.framework.TestCase;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.lang3.builder.ToStringStyleTest;

public class SimpleToStringStyleTest
extends TestCase {
    private final Integer base = 5;

    public SimpleToStringStyleTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        ToStringBuilder.setDefaultStyle((ToStringStyle)ToStringStyle.SIMPLE_STYLE);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        ToStringBuilder.setDefaultStyle((ToStringStyle)ToStringStyle.DEFAULT_STYLE);
    }

    public void testBlank() {
        SimpleToStringStyleTest.assertEquals((String)"", (String)new ToStringBuilder((Object)this.base).toString());
    }

    public void testAppendSuper() {
        SimpleToStringStyleTest.assertEquals((String)"", (String)new ToStringBuilder((Object)this.base).appendSuper("").toString());
        SimpleToStringStyleTest.assertEquals((String)"<null>", (String)new ToStringBuilder((Object)this.base).appendSuper("<null>").toString());
        SimpleToStringStyleTest.assertEquals((String)"hello", (String)new ToStringBuilder((Object)this.base).appendSuper("").append("a", (Object)"hello").toString());
        SimpleToStringStyleTest.assertEquals((String)"<null>,hello", (String)new ToStringBuilder((Object)this.base).appendSuper("<null>").append("a", (Object)"hello").toString());
        SimpleToStringStyleTest.assertEquals((String)"hello", (String)new ToStringBuilder((Object)this.base).appendSuper(null).append("a", (Object)"hello").toString());
    }

    public void testObject() {
        Integer i3 = 3;
        Integer i4 = 4;
        SimpleToStringStyleTest.assertEquals((String)"<null>", (String)new ToStringBuilder((Object)this.base).append((Object)null).toString());
        SimpleToStringStyleTest.assertEquals((String)"3", (String)new ToStringBuilder((Object)this.base).append((Object)i3).toString());
        SimpleToStringStyleTest.assertEquals((String)"<null>", (String)new ToStringBuilder((Object)this.base).append("a", (Object)null).toString());
        SimpleToStringStyleTest.assertEquals((String)"3", (String)new ToStringBuilder((Object)this.base).append("a", (Object)i3).toString());
        SimpleToStringStyleTest.assertEquals((String)"3,4", (String)new ToStringBuilder((Object)this.base).append("a", (Object)i3).append("b", (Object)i4).toString());
        SimpleToStringStyleTest.assertEquals((String)"<Integer>", (String)new ToStringBuilder((Object)this.base).append("a", (Object)i3, false).toString());
        SimpleToStringStyleTest.assertEquals((String)"<size=0>", (String)new ToStringBuilder((Object)this.base).append("a", new ArrayList(), false).toString());
        SimpleToStringStyleTest.assertEquals((String)"[]", (String)new ToStringBuilder((Object)this.base).append("a", new ArrayList(), true).toString());
        SimpleToStringStyleTest.assertEquals((String)"<size=0>", (String)new ToStringBuilder((Object)this.base).append("a", new HashMap(), false).toString());
        SimpleToStringStyleTest.assertEquals((String)"{}", (String)new ToStringBuilder((Object)this.base).append("a", new HashMap(), true).toString());
        SimpleToStringStyleTest.assertEquals((String)"<size=0>", (String)new ToStringBuilder((Object)this.base).append("a", (Object)new String[0], false).toString());
        SimpleToStringStyleTest.assertEquals((String)"{}", (String)new ToStringBuilder((Object)this.base).append("a", (Object)new String[0], true).toString());
    }

    public void testPerson() {
        ToStringStyleTest.Person p = new ToStringStyleTest.Person();
        p.name = "Jane Q. Public";
        p.age = 47;
        p.smoker = false;
        SimpleToStringStyleTest.assertEquals((String)"Jane Q. Public,47,false", (String)new ToStringBuilder((Object)p).append("name", (Object)p.name).append("age", p.age).append("smoker", p.smoker).toString());
    }

    public void testLong() {
        SimpleToStringStyleTest.assertEquals((String)"3", (String)new ToStringBuilder((Object)this.base).append(3L).toString());
        SimpleToStringStyleTest.assertEquals((String)"3", (String)new ToStringBuilder((Object)this.base).append("a", 3L).toString());
        SimpleToStringStyleTest.assertEquals((String)"3,4", (String)new ToStringBuilder((Object)this.base).append("a", 3L).append("b", 4L).toString());
    }

    public void testObjectArray() {
        Object[] array = new Object[]{null, this.base, new int[]{3, 6}};
        SimpleToStringStyleTest.assertEquals((String)"{<null>,5,{3,6}}", (String)new ToStringBuilder((Object)this.base).append(array).toString());
        SimpleToStringStyleTest.assertEquals((String)"{<null>,5,{3,6}}", (String)new ToStringBuilder((Object)this.base).append((Object)array).toString());
        array = null;
        SimpleToStringStyleTest.assertEquals((String)"<null>", (String)new ToStringBuilder((Object)this.base).append(array).toString());
        SimpleToStringStyleTest.assertEquals((String)"<null>", (String)new ToStringBuilder((Object)this.base).append((Object)array).toString());
    }

    public void testLongArray() {
        long[] array = new long[]{1L, 2L, -3L, 4L};
        SimpleToStringStyleTest.assertEquals((String)"{1,2,-3,4}", (String)new ToStringBuilder((Object)this.base).append(array).toString());
        SimpleToStringStyleTest.assertEquals((String)"{1,2,-3,4}", (String)new ToStringBuilder((Object)this.base).append((Object)array).toString());
        array = null;
        SimpleToStringStyleTest.assertEquals((String)"<null>", (String)new ToStringBuilder((Object)this.base).append(array).toString());
        SimpleToStringStyleTest.assertEquals((String)"<null>", (String)new ToStringBuilder((Object)this.base).append((Object)array).toString());
    }

    public void testLongArrayArray() {
        Object array = new long[][]{{1L, 2L}, null, {5L}};
        SimpleToStringStyleTest.assertEquals((String)"{{1,2},<null>,{5}}", (String)new ToStringBuilder((Object)this.base).append((Object[])array).toString());
        SimpleToStringStyleTest.assertEquals((String)"{{1,2},<null>,{5}}", (String)new ToStringBuilder((Object)this.base).append(array).toString());
        array = null;
        SimpleToStringStyleTest.assertEquals((String)"<null>", (String)new ToStringBuilder((Object)this.base).append((Object[])array).toString());
        SimpleToStringStyleTest.assertEquals((String)"<null>", (String)new ToStringBuilder((Object)this.base).append(array).toString());
    }
}

